#!/usr/bin/perl -w

require 5.002;

$runtests=shift(@ARGV);
if ( -f "t/test.pl" ) {
  require "t/test.pl";
  $dir="./lib";
  $tdir="t";
} elsif ( -f "test.pl" ) {
  require "test.pl";
  $dir="../lib";
  $tdir=".";
} else {
  die "ERROR: cannot find test.pl\n";
}

unshift(@INC,$dir);
use Locale::Script;

%type = ( "LOCALE_SCRIPT_ALPHA"   => LOCALE_SCRIPT_ALPHA,
          "LOCALE_SCRIPT_NUMERIC" => LOCALE_SCRIPT_NUMERIC,
        );

sub test {
   my(@test) = @_;
   $test[1]  = $type{$test[1]}
     if (@test == 2  &&  $test[1]  &&  exists $type{$test[1]});
   return code2script(@test);
}

$tests = "

~ _undef_

Phnx ~ Phoenician

phnx ~ Phoenician

115 LOCALE_SCRIPT_NUMERIC ~ Phoenician

";

print "code2script...\n";
test_Func(\&test,$tests,$runtests);

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 3
# cperl-continued-statement-offset: 2
# cperl-continued-brace-offset: 0
# cperl-brace-offset: 0
# cperl-brace-imaginary-offset: 0
# cperl-label-offset: -2
# End:
