package Date::Manip::Zones;
# Copyright (c) 2008-2018 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Wed May 30 14:52:52 EDT 2018
#    Data version: tzdata2018e
#    Code version: tzcode2018e

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

use strict;
use warnings;
require 5.010000;

our ($VERSION);
$VERSION='6.73';
END { undef $VERSION; }

our ($TzdataVersion,$TzcodeVersion,
     $FirstDate,$LastDate,$LastYear,
     %Module,%ZoneNames,%Alias,%Abbrev,%Offmod);
END {
   undef $TzdataVersion;
   undef $TzcodeVersion;
   undef $FirstDate;
   undef $LastDate;
   undef $LastYear;
   undef %Module;
   undef %ZoneNames;
   undef %Alias;
   undef %Abbrev;
   undef %Offmod;
}

$TzdataVersion = 'tzdata2018e';
$TzcodeVersion = 'tzcode2018e';
$FirstDate     = '0001010200:00:00';
$LastDate      = '9999123100:00:00';
$LastYear      = '2068';


%Module = (
  'africa/abidjan'                     => 'afabid00',
  'africa/accra'                       => 'afaccr00',
  'africa/algiers'                     => 'afalgi00',
  'africa/bissau'                      => 'afbiss00',
  'africa/cairo'                       => 'afcair00',
  'africa/casablanca'                  => 'afcasa00',
  'africa/ceuta'                       => 'afceut00',
  'africa/el_aaiun'                    => 'afel_a00',
  'africa/johannesburg'                => 'afjoha00',
  'africa/juba'                        => 'afjuba00',
  'africa/khartoum'                    => 'afkhar00',
  'africa/lagos'                       => 'aflago00',
  'africa/maputo'                      => 'afmapu00',
  'africa/monrovia'                    => 'afmonr00',
  'africa/nairobi'                     => 'afnair00',
  'africa/ndjamena'                    => 'afndja00',
  'africa/sao_tome'                    => 'afsao_00',
  'africa/tripoli'                     => 'aftrip00',
  'africa/tunis'                       => 'aftuni00',
  'africa/windhoek'                    => 'afwind00',
  'america/adak'                       => 'amadak00',
  'america/anchorage'                  => 'amanch00',
  'america/araguaina'                  => 'amarag00',
  'america/argentina/buenos_aires'     => 'ambuen00',
  'america/argentina/catamarca'        => 'amcata00',
  'america/argentina/cordoba'          => 'amcord00',
  'america/argentina/jujuy'            => 'amjuju00',
  'america/argentina/la_rioja'         => 'amla_r00',
  'america/argentina/mendoza'          => 'ammend00',
  'america/argentina/rio_gallegos'     => 'amrio_00',
  'america/argentina/salta'            => 'amsalt00',
  'america/argentina/san_juan'         => 'amsan_00',
  'america/argentina/san_luis'         => 'amsan_01',
  'america/argentina/tucuman'          => 'amtucu00',
  'america/argentina/ushuaia'          => 'amushu00',
  'america/asuncion'                   => 'amasun00',
  'america/atikokan'                   => 'amatik00',
  'america/bahia'                      => 'ambahi00',
  'america/bahia_banderas'             => 'ambahi01',
  'america/barbados'                   => 'ambarb00',
  'america/belem'                      => 'ambele00',
  'america/belize'                     => 'ambeli00',
  'america/blanc-sablon'               => 'amblan00',
  'america/boa_vista'                  => 'amboa_00',
  'america/bogota'                     => 'ambogo00',
  'america/boise'                      => 'ambois00',
  'america/cambridge_bay'              => 'amcamb00',
  'america/campo_grande'               => 'amcamp00',
  'america/cancun'                     => 'amcanc00',
  'america/caracas'                    => 'amcara00',
  'america/cayenne'                    => 'amcaye00',
  'america/chicago'                    => 'amchic00',
  'america/chihuahua'                  => 'amchih00',
  'america/costa_rica'                 => 'amcost00',
  'america/creston'                    => 'amcres00',
  'america/cuiaba'                     => 'amcuia00',
  'america/curacao'                    => 'amcura00',
  'america/danmarkshavn'               => 'amdanm00',
  'america/dawson'                     => 'amdaws00',
  'america/dawson_creek'               => 'amdaws01',
  'america/denver'                     => 'amdenv00',
  'america/detroit'                    => 'amdetr00',
  'america/edmonton'                   => 'amedmo00',
  'america/eirunepe'                   => 'ameiru00',
  'america/el_salvador'                => 'amel_s00',
  'america/fort_nelson'                => 'amfort00',
  'america/fortaleza'                  => 'amfort01',
  'america/glace_bay'                  => 'amglac00',
  'america/godthab'                    => 'amgodt00',
  'america/goose_bay'                  => 'amgoos00',
  'america/grand_turk'                 => 'amgran00',
  'america/guatemala'                  => 'amguat00',
  'america/guayaquil'                  => 'amguay00',
  'america/guyana'                     => 'amguya00',
  'america/halifax'                    => 'amhali00',
  'america/havana'                     => 'amhava00',
  'america/hermosillo'                 => 'amherm00',
  'america/indiana/indianapolis'       => 'amindi00',
  'america/indiana/knox'               => 'amknox00',
  'america/indiana/marengo'            => 'ammare00',
  'america/indiana/petersburg'         => 'ampete00',
  'america/indiana/tell_city'          => 'amtell00',
  'america/indiana/vevay'              => 'amveva00',
  'america/indiana/vincennes'          => 'amvinc00',
  'america/indiana/winamac'            => 'amwina00',
  'america/inuvik'                     => 'aminuv00',
  'america/iqaluit'                    => 'amiqal00',
  'america/jamaica'                    => 'amjama00',
  'america/juneau'                     => 'amjune00',
  'america/kentucky/louisville'        => 'amloui00',
  'america/kentucky/monticello'        => 'ammont00',
  'america/la_paz'                     => 'amla_p00',
  'america/lima'                       => 'amlima00',
  'america/los_angeles'                => 'amlos_00',
  'america/maceio'                     => 'ammace00',
  'america/managua'                    => 'ammana00',
  'america/manaus'                     => 'ammana01',
  'america/martinique'                 => 'ammart00',
  'america/matamoros'                  => 'ammata00',
  'america/mazatlan'                   => 'ammaza00',
  'america/menominee'                  => 'ammeno00',
  'america/merida'                     => 'ammeri00',
  'america/metlakatla'                 => 'ammetl00',
  'america/mexico_city'                => 'ammexi00',
  'america/miquelon'                   => 'ammiqu00',
  'america/moncton'                    => 'ammonc00',
  'america/monterrey'                  => 'ammont01',
  'america/montevideo'                 => 'ammont02',
  'america/nassau'                     => 'amnass00',
  'america/new_york'                   => 'amnew_00',
  'america/nipigon'                    => 'amnipi00',
  'america/nome'                       => 'amnome00',
  'america/noronha'                    => 'amnoro00',
  'america/north_dakota/beulah'        => 'ambeul00',
  'america/north_dakota/center'        => 'amcent00',
  'america/north_dakota/new_salem'     => 'amnew_01',
  'america/ojinaga'                    => 'amojin00',
  'america/panama'                     => 'ampana00',
  'america/pangnirtung'                => 'ampang00',
  'america/paramaribo'                 => 'ampara00',
  'america/phoenix'                    => 'amphoe00',
  'america/port-au-prince'             => 'amport00',
  'america/port_of_spain'              => 'amport01',
  'america/porto_velho'                => 'amport02',
  'america/puerto_rico'                => 'ampuer00',
  'america/punta_arenas'               => 'ampunt00',
  'america/rainy_river'                => 'amrain00',
  'america/rankin_inlet'               => 'amrank00',
  'america/recife'                     => 'amreci00',
  'america/regina'                     => 'amregi00',
  'america/resolute'                   => 'amreso00',
  'america/rio_branco'                 => 'amrio_01',
  'america/santarem'                   => 'amsant00',
  'america/santiago'                   => 'amsant01',
  'america/santo_domingo'              => 'amsant02',
  'america/sao_paulo'                  => 'amsao_00',
  'america/scoresbysund'               => 'amscor00',
  'america/sitka'                      => 'amsitk00',
  'america/st_johns'                   => 'amst_j00',
  'america/swift_current'              => 'amswif00',
  'america/tegucigalpa'                => 'amtegu00',
  'america/thule'                      => 'amthul00',
  'america/thunder_bay'                => 'amthun00',
  'america/tijuana'                    => 'amtiju00',
  'america/toronto'                    => 'amtoro00',
  'america/vancouver'                  => 'amvanc00',
  'america/whitehorse'                 => 'amwhit00',
  'america/winnipeg'                   => 'amwinn00',
  'america/yakutat'                    => 'amyaku00',
  'america/yellowknife'                => 'amyell00',
  'antarctica/casey'                   => 'ancase00',
  'antarctica/davis'                   => 'andavi00',
  'antarctica/dumontdurville'          => 'andumo00',
  'antarctica/macquarie'               => 'anmacq00',
  'antarctica/mawson'                  => 'anmaws00',
  'antarctica/palmer'                  => 'anpalm00',
  'antarctica/rothera'                 => 'anroth00',
  'antarctica/syowa'                   => 'ansyow00',
  'antarctica/troll'                   => 'antrol00',
  'antarctica/vostok'                  => 'anvost00',
  'asia/almaty'                        => 'asalma00',
  'asia/amman'                         => 'asamma00',
  'asia/anadyr'                        => 'asanad00',
  'asia/aqtau'                         => 'asaqta00',
  'asia/aqtobe'                        => 'asaqto00',
  'asia/ashgabat'                      => 'asashg00',
  'asia/atyrau'                        => 'asatyr00',
  'asia/baghdad'                       => 'asbagh00',
  'asia/baku'                          => 'asbaku00',
  'asia/bangkok'                       => 'asbang00',
  'asia/barnaul'                       => 'asbarn00',
  'asia/beirut'                        => 'asbeir00',
  'asia/bishkek'                       => 'asbish00',
  'asia/brunei'                        => 'asbrun00',
  'asia/chita'                         => 'aschit00',
  'asia/choibalsan'                    => 'aschoi00',
  'asia/colombo'                       => 'ascolo00',
  'asia/damascus'                      => 'asdama00',
  'asia/dhaka'                         => 'asdhak00',
  'asia/dili'                          => 'asdili00',
  'asia/dubai'                         => 'asduba00',
  'asia/dushanbe'                      => 'asdush00',
  'asia/famagusta'                     => 'asfama00',
  'asia/gaza'                          => 'asgaza00',
  'asia/hebron'                        => 'ashebr00',
  'asia/ho_chi_minh'                   => 'asho_c00',
  'asia/hong_kong'                     => 'ashong00',
  'asia/hovd'                          => 'ashovd00',
  'asia/irkutsk'                       => 'asirku00',
  'asia/jakarta'                       => 'asjaka00',
  'asia/jayapura'                      => 'asjaya00',
  'asia/jerusalem'                     => 'asjeru00',
  'asia/kabul'                         => 'askabu00',
  'asia/kamchatka'                     => 'askamc00',
  'asia/karachi'                       => 'askara00',
  'asia/kathmandu'                     => 'askath00',
  'asia/khandyga'                      => 'askhan00',
  'asia/kolkata'                       => 'askolk00',
  'asia/krasnoyarsk'                   => 'askras00',
  'asia/kuala_lumpur'                  => 'askual00',
  'asia/kuching'                       => 'askuch00',
  'asia/macau'                         => 'asmaca00',
  'asia/magadan'                       => 'asmaga00',
  'asia/makassar'                      => 'asmaka00',
  'asia/manila'                        => 'asmani00',
  'asia/nicosia'                       => 'asnico00',
  'asia/novokuznetsk'                  => 'asnovo00',
  'asia/novosibirsk'                   => 'asnovo01',
  'asia/omsk'                          => 'asomsk00',
  'asia/oral'                          => 'asoral00',
  'asia/pontianak'                     => 'aspont00',
  'asia/pyongyang'                     => 'aspyon00',
  'asia/qatar'                         => 'asqata00',
  'asia/qyzylorda'                     => 'asqyzy00',
  'asia/riyadh'                        => 'asriya00',
  'asia/sakhalin'                      => 'assakh00',
  'asia/samarkand'                     => 'assama00',
  'asia/seoul'                         => 'asseou00',
  'asia/shanghai'                      => 'asshan00',
  'asia/singapore'                     => 'assing00',
  'asia/srednekolymsk'                 => 'assred00',
  'asia/taipei'                        => 'astaip00',
  'asia/tashkent'                      => 'astash00',
  'asia/tbilisi'                       => 'astbil00',
  'asia/tehran'                        => 'astehr00',
  'asia/thimphu'                       => 'asthim00',
  'asia/tokyo'                         => 'astoky00',
  'asia/tomsk'                         => 'astoms00',
  'asia/ulaanbaatar'                   => 'asulaa00',
  'asia/urumqi'                        => 'asurum00',
  'asia/ust-nera'                      => 'asustm00',
  'asia/vladivostok'                   => 'asvlad00',
  'asia/yakutsk'                       => 'asyaku00',
  'asia/yangon'                        => 'asyang00',
  'asia/yekaterinburg'                 => 'asyeka00',
  'asia/yerevan'                       => 'asyere00',
  'atlantic/azores'                    => 'atazor00',
  'atlantic/bermuda'                   => 'atberm00',
  'atlantic/canary'                    => 'atcana00',
  'atlantic/cape_verde'                => 'atcape00',
  'atlantic/faroe'                     => 'atfaro00',
  'atlantic/madeira'                   => 'atmade00',
  'atlantic/reykjavik'                 => 'atreyk00',
  'atlantic/south_georgia'             => 'atsout00',
  'atlantic/stanley'                   => 'atstan00',
  'australia/adelaide'                 => 'auadel00',
  'australia/brisbane'                 => 'aubris00',
  'australia/broken_hill'              => 'aubrok00',
  'australia/currie'                   => 'aucurr00',
  'australia/darwin'                   => 'audarw00',
  'australia/eucla'                    => 'aueucl00',
  'australia/hobart'                   => 'auhoba00',
  'australia/lindeman'                 => 'aulind00',
  'australia/lord_howe'                => 'aulord00',
  'australia/melbourne'                => 'aumelb00',
  'australia/perth'                    => 'aupert00',
  'australia/sydney'                   => 'ausydn00',
  'cet'                                => 'cet00',
  'eet'                                => 'eet00',
  'europe/amsterdam'                   => 'euamst00',
  'europe/andorra'                     => 'euando00',
  'europe/astrakhan'                   => 'euastr00',
  'europe/athens'                      => 'euathe00',
  'europe/belgrade'                    => 'eubelg00',
  'europe/berlin'                      => 'euberl00',
  'europe/brussels'                    => 'eubrus00',
  'europe/bucharest'                   => 'eubuch00',
  'europe/budapest'                    => 'eubuda00',
  'europe/chisinau'                    => 'euchis00',
  'europe/copenhagen'                  => 'eucope00',
  'europe/dublin'                      => 'eudubl00',
  'europe/gibraltar'                   => 'eugibr00',
  'europe/helsinki'                    => 'euhels00',
  'europe/istanbul'                    => 'euista00',
  'europe/kaliningrad'                 => 'eukali00',
  'europe/kiev'                        => 'eukiev00',
  'europe/kirov'                       => 'eukiro00',
  'europe/lisbon'                      => 'eulisb00',
  'europe/london'                      => 'eulond00',
  'europe/luxembourg'                  => 'euluxe00',
  'europe/madrid'                      => 'eumadr00',
  'europe/malta'                       => 'eumalt00',
  'europe/minsk'                       => 'eumins00',
  'europe/monaco'                      => 'eumona00',
  'europe/moscow'                      => 'eumosc00',
  'europe/oslo'                        => 'euoslo00',
  'europe/paris'                       => 'eupari00',
  'europe/prague'                      => 'euprag00',
  'europe/riga'                        => 'euriga00',
  'europe/rome'                        => 'eurome00',
  'europe/samara'                      => 'eusama00',
  'europe/saratov'                     => 'eusara00',
  'europe/simferopol'                  => 'eusimf00',
  'europe/sofia'                       => 'eusofi00',
  'europe/stockholm'                   => 'eustoc00',
  'europe/tallinn'                     => 'eutall00',
  'europe/tirane'                      => 'eutira00',
  'europe/ulyanovsk'                   => 'euulya00',
  'europe/uzhgorod'                    => 'euuzhg00',
  'europe/vienna'                      => 'euvien00',
  'europe/vilnius'                     => 'euviln00',
  'europe/volgograd'                   => 'euvolg00',
  'europe/warsaw'                      => 'euwars00',
  'europe/zaporozhye'                  => 'euzapo00',
  'europe/zurich'                      => 'euzuri00',
  'indian/chagos'                      => 'inchag00',
  'indian/christmas'                   => 'inchri00',
  'indian/cocos'                       => 'incoco00',
  'indian/kerguelen'                   => 'inkerg00',
  'indian/mahe'                        => 'inmahe00',
  'indian/maldives'                    => 'inmald00',
  'indian/mauritius'                   => 'inmaur00',
  'indian/reunion'                     => 'inreun00',
  'met'                                => 'met00',
  'pacific/apia'                       => 'paapia00',
  'pacific/auckland'                   => 'paauck00',
  'pacific/bougainville'               => 'paboug00',
  'pacific/chatham'                    => 'pachat00',
  'pacific/chuuk'                      => 'pachuu00',
  'pacific/easter'                     => 'paeast00',
  'pacific/efate'                      => 'paefat00',
  'pacific/enderbury'                  => 'paende00',
  'pacific/fakaofo'                    => 'pafaka00',
  'pacific/fiji'                       => 'pafiji00',
  'pacific/funafuti'                   => 'pafuna00',
  'pacific/galapagos'                  => 'pagala00',
  'pacific/gambier'                    => 'pagamb00',
  'pacific/guadalcanal'                => 'paguad00',
  'pacific/guam'                       => 'paguam00',
  'pacific/honolulu'                   => 'pahono00',
  'pacific/kiritimati'                 => 'pakiri00',
  'pacific/kosrae'                     => 'pakosr00',
  'pacific/kwajalein'                  => 'pakwaj00',
  'pacific/majuro'                     => 'pamaju00',
  'pacific/marquesas'                  => 'pamarq00',
  'pacific/nauru'                      => 'panaur00',
  'pacific/niue'                       => 'paniue00',
  'pacific/norfolk'                    => 'panorf00',
  'pacific/noumea'                     => 'panoum00',
  'pacific/pago_pago'                  => 'papago00',
  'pacific/palau'                      => 'papala00',
  'pacific/pitcairn'                   => 'papitc00',
  'pacific/pohnpei'                    => 'papohn00',
  'pacific/port_moresby'               => 'paport00',
  'pacific/rarotonga'                  => 'pararo00',
  'pacific/tahiti'                     => 'patahi00',
  'pacific/tarawa'                     => 'patara00',
  'pacific/tongatapu'                  => 'patong00',
  'pacific/wake'                       => 'pawake00',
  'pacific/wallis'                     => 'pawall00',
  'wet'                                => 'wet00',
  'a'                                  => 'a00',
  'b'                                  => 'b00',
  'c'                                  => 'c00',
  'd'                                  => 'd00',
  'e'                                  => 'e00',
  'etc/gmt'                            => 'etgmt00',
  'etc/gmt+1'                          => 'etgmtp00',
  'etc/gmt+10'                         => 'etgmtp01',
  'etc/gmt+11'                         => 'etgmtp02',
  'etc/gmt+12'                         => 'etgmtp03',
  'etc/gmt+2'                          => 'etgmtp04',
  'etc/gmt+3'                          => 'etgmtp05',
  'etc/gmt+4'                          => 'etgmtp06',
  'etc/gmt+5'                          => 'etgmtp07',
  'etc/gmt+6'                          => 'etgmtp08',
  'etc/gmt+7'                          => 'etgmtp09',
  'etc/gmt+8'                          => 'etgmtp10',
  'etc/gmt+9'                          => 'etgmtp11',
  'etc/gmt-1'                          => 'etgmtm00',
  'etc/gmt-10'                         => 'etgmtm01',
  'etc/gmt-11'                         => 'etgmtm02',
  'etc/gmt-12'                         => 'etgmtm03',
  'etc/gmt-13'                         => 'etgmtm04',
  'etc/gmt-14'                         => 'etgmtm05',
  'etc/gmt-2'                          => 'etgmtm06',
  'etc/gmt-3'                          => 'etgmtm07',
  'etc/gmt-4'                          => 'etgmtm08',
  'etc/gmt-5'                          => 'etgmtm09',
  'etc/gmt-6'                          => 'etgmtm10',
  'etc/gmt-7'                          => 'etgmtm11',
  'etc/gmt-8'                          => 'etgmtm12',
  'etc/gmt-9'                          => 'etgmtm13',
  'f'                                  => 'f00',
  'g'                                  => 'g00',
  'h'                                  => 'h00',
  'i'                                  => 'i00',
  'k'                                  => 'k00',
  'l'                                  => 'l00',
  'm'                                  => 'm00',
  'n'                                  => 'n00',
  'o'                                  => 'o00',
  'p'                                  => 'p00',
  'q'                                  => 'q00',
  'r'                                  => 'r00',
  's'                                  => 's00',
  't'                                  => 't00',
  'u'                                  => 'u00',
  'ut'                                 => 'ut00',
  'utc'                                => 'utc00',
  'v'                                  => 'v00',
  'w'                                  => 'w00',
  'x'                                  => 'x00',
  'y'                                  => 'y00',
  'z'                                  => 'z00',
);

%ZoneNames = (
  'africa/abidjan'                     => 'Africa/Abidjan',
  'africa/accra'                       => 'Africa/Accra',
  'africa/algiers'                     => 'Africa/Algiers',
  'africa/bissau'                      => 'Africa/Bissau',
  'africa/cairo'                       => 'Africa/Cairo',
  'africa/casablanca'                  => 'Africa/Casablanca',
  'africa/ceuta'                       => 'Africa/Ceuta',
  'africa/el_aaiun'                    => 'Africa/El_Aaiun',
  'africa/johannesburg'                => 'Africa/Johannesburg',
  'africa/juba'                        => 'Africa/Juba',
  'africa/khartoum'                    => 'Africa/Khartoum',
  'africa/lagos'                       => 'Africa/Lagos',
  'africa/maputo'                      => 'Africa/Maputo',
  'africa/monrovia'                    => 'Africa/Monrovia',
  'africa/nairobi'                     => 'Africa/Nairobi',
  'africa/ndjamena'                    => 'Africa/Ndjamena',
  'africa/sao_tome'                    => 'Africa/Sao_Tome',
  'africa/tripoli'                     => 'Africa/Tripoli',
  'africa/tunis'                       => 'Africa/Tunis',
  'africa/windhoek'                    => 'Africa/Windhoek',
  'america/adak'                       => 'America/Adak',
  'america/anchorage'                  => 'America/Anchorage',
  'america/araguaina'                  => 'America/Araguaina',
  'america/argentina/buenos_aires'     => 'America/Argentina/Buenos_Aires',
  'america/argentina/catamarca'        => 'America/Argentina/Catamarca',
  'america/argentina/cordoba'          => 'America/Argentina/Cordoba',
  'america/argentina/jujuy'            => 'America/Argentina/Jujuy',
  'america/argentina/la_rioja'         => 'America/Argentina/La_Rioja',
  'america/argentina/mendoza'          => 'America/Argentina/Mendoza',
  'america/argentina/rio_gallegos'     => 'America/Argentina/Rio_Gallegos',
  'america/argentina/salta'            => 'America/Argentina/Salta',
  'america/argentina/san_juan'         => 'America/Argentina/San_Juan',
  'america/argentina/san_luis'         => 'America/Argentina/San_Luis',
  'america/argentina/tucuman'          => 'America/Argentina/Tucuman',
  'america/argentina/ushuaia'          => 'America/Argentina/Ushuaia',
  'america/asuncion'                   => 'America/Asuncion',
  'america/atikokan'                   => 'America/Atikokan',
  'america/bahia'                      => 'America/Bahia',
  'america/bahia_banderas'             => 'America/Bahia_Banderas',
  'america/barbados'                   => 'America/Barbados',
  'america/belem'                      => 'America/Belem',
  'america/belize'                     => 'America/Belize',
  'america/blanc-sablon'               => 'America/Blanc-Sablon',
  'america/boa_vista'                  => 'America/Boa_Vista',
  'america/bogota'                     => 'America/Bogota',
  'america/boise'                      => 'America/Boise',
  'america/cambridge_bay'              => 'America/Cambridge_Bay',
  'america/campo_grande'               => 'America/Campo_Grande',
  'america/cancun'                     => 'America/Cancun',
  'america/caracas'                    => 'America/Caracas',
  'america/cayenne'                    => 'America/Cayenne',
  'america/chicago'                    => 'America/Chicago',
  'america/chihuahua'                  => 'America/Chihuahua',
  'america/costa_rica'                 => 'America/Costa_Rica',
  'america/creston'                    => 'America/Creston',
  'america/cuiaba'                     => 'America/Cuiaba',
  'america/curacao'                    => 'America/Curacao',
  'america/danmarkshavn'               => 'America/Danmarkshavn',
  'america/dawson'                     => 'America/Dawson',
  'america/dawson_creek'               => 'America/Dawson_Creek',
  'america/denver'                     => 'America/Denver',
  'america/detroit'                    => 'America/Detroit',
  'america/edmonton'                   => 'America/Edmonton',
  'america/eirunepe'                   => 'America/Eirunepe',
  'america/el_salvador'                => 'America/El_Salvador',
  'america/fort_nelson'                => 'America/Fort_Nelson',
  'america/fortaleza'                  => 'America/Fortaleza',
  'america/glace_bay'                  => 'America/Glace_Bay',
  'america/godthab'                    => 'America/Godthab',
  'america/goose_bay'                  => 'America/Goose_Bay',
  'america/grand_turk'                 => 'America/Grand_Turk',
  'america/guatemala'                  => 'America/Guatemala',
  'america/guayaquil'                  => 'America/Guayaquil',
  'america/guyana'                     => 'America/Guyana',
  'america/halifax'                    => 'America/Halifax',
  'america/havana'                     => 'America/Havana',
  'america/hermosillo'                 => 'America/Hermosillo',
  'america/indiana/indianapolis'       => 'America/Indiana/Indianapolis',
  'america/indiana/knox'               => 'America/Indiana/Knox',
  'america/indiana/marengo'            => 'America/Indiana/Marengo',
  'america/indiana/petersburg'         => 'America/Indiana/Petersburg',
  'america/indiana/tell_city'          => 'America/Indiana/Tell_City',
  'america/indiana/vevay'              => 'America/Indiana/Vevay',
  'america/indiana/vincennes'          => 'America/Indiana/Vincennes',
  'america/indiana/winamac'            => 'America/Indiana/Winamac',
  'america/inuvik'                     => 'America/Inuvik',
  'america/iqaluit'                    => 'America/Iqaluit',
  'america/jamaica'                    => 'America/Jamaica',
  'america/juneau'                     => 'America/Juneau',
  'america/kentucky/louisville'        => 'America/Kentucky/Louisville',
  'america/kentucky/monticello'        => 'America/Kentucky/Monticello',
  'america/la_paz'                     => 'America/La_Paz',
  'america/lima'                       => 'America/Lima',
  'america/los_angeles'                => 'America/Los_Angeles',
  'america/maceio'                     => 'America/Maceio',
  'america/managua'                    => 'America/Managua',
  'america/manaus'                     => 'America/Manaus',
  'america/martinique'                 => 'America/Martinique',
  'america/matamoros'                  => 'America/Matamoros',
  'america/mazatlan'                   => 'America/Mazatlan',
  'america/menominee'                  => 'America/Menominee',
  'america/merida'                     => 'America/Merida',
  'america/metlakatla'                 => 'America/Metlakatla',
  'america/mexico_city'                => 'America/Mexico_City',
  'america/miquelon'                   => 'America/Miquelon',
  'america/moncton'                    => 'America/Moncton',
  'america/monterrey'                  => 'America/Monterrey',
  'america/montevideo'                 => 'America/Montevideo',
  'america/nassau'                     => 'America/Nassau',
  'america/new_york'                   => 'America/New_York',
  'america/nipigon'                    => 'America/Nipigon',
  'america/nome'                       => 'America/Nome',
  'america/noronha'                    => 'America/Noronha',
  'america/north_dakota/beulah'        => 'America/North_Dakota/Beulah',
  'america/north_dakota/center'        => 'America/North_Dakota/Center',
  'america/north_dakota/new_salem'     => 'America/North_Dakota/New_Salem',
  'america/ojinaga'                    => 'America/Ojinaga',
  'america/panama'                     => 'America/Panama',
  'america/pangnirtung'                => 'America/Pangnirtung',
  'america/paramaribo'                 => 'America/Paramaribo',
  'america/phoenix'                    => 'America/Phoenix',
  'america/port-au-prince'             => 'America/Port-au-Prince',
  'america/port_of_spain'              => 'America/Port_of_Spain',
  'america/porto_velho'                => 'America/Porto_Velho',
  'america/puerto_rico'                => 'America/Puerto_Rico',
  'america/punta_arenas'               => 'America/Punta_Arenas',
  'america/rainy_river'                => 'America/Rainy_River',
  'america/rankin_inlet'               => 'America/Rankin_Inlet',
  'america/recife'                     => 'America/Recife',
  'america/regina'                     => 'America/Regina',
  'america/resolute'                   => 'America/Resolute',
  'america/rio_branco'                 => 'America/Rio_Branco',
  'america/santarem'                   => 'America/Santarem',
  'america/santiago'                   => 'America/Santiago',
  'america/santo_domingo'              => 'America/Santo_Domingo',
  'america/sao_paulo'                  => 'America/Sao_Paulo',
  'america/scoresbysund'               => 'America/Scoresbysund',
  'america/sitka'                      => 'America/Sitka',
  'america/st_johns'                   => 'America/St_Johns',
  'america/swift_current'              => 'America/Swift_Current',
  'america/tegucigalpa'                => 'America/Tegucigalpa',
  'america/thule'                      => 'America/Thule',
  'america/thunder_bay'                => 'America/Thunder_Bay',
  'america/tijuana'                    => 'America/Tijuana',
  'america/toronto'                    => 'America/Toronto',
  'america/vancouver'                  => 'America/Vancouver',
  'america/whitehorse'                 => 'America/Whitehorse',
  'america/winnipeg'                   => 'America/Winnipeg',
  'america/yakutat'                    => 'America/Yakutat',
  'america/yellowknife'                => 'America/Yellowknife',
  'antarctica/casey'                   => 'Antarctica/Casey',
  'antarctica/davis'                   => 'Antarctica/Davis',
  'antarctica/dumontdurville'          => 'Antarctica/DumontDUrville',
  'antarctica/macquarie'               => 'Antarctica/Macquarie',
  'antarctica/mawson'                  => 'Antarctica/Mawson',
  'antarctica/palmer'                  => 'Antarctica/Palmer',
  'antarctica/rothera'                 => 'Antarctica/Rothera',
  'antarctica/syowa'                   => 'Antarctica/Syowa',
  'antarctica/troll'                   => 'Antarctica/Troll',
  'antarctica/vostok'                  => 'Antarctica/Vostok',
  'asia/almaty'                        => 'Asia/Almaty',
  'asia/amman'                         => 'Asia/Amman',
  'asia/anadyr'                        => 'Asia/Anadyr',
  'asia/aqtau'                         => 'Asia/Aqtau',
  'asia/aqtobe'                        => 'Asia/Aqtobe',
  'asia/ashgabat'                      => 'Asia/Ashgabat',
  'asia/atyrau'                        => 'Asia/Atyrau',
  'asia/baghdad'                       => 'Asia/Baghdad',
  'asia/baku'                          => 'Asia/Baku',
  'asia/bangkok'                       => 'Asia/Bangkok',
  'asia/barnaul'                       => 'Asia/Barnaul',
  'asia/beirut'                        => 'Asia/Beirut',
  'asia/bishkek'                       => 'Asia/Bishkek',
  'asia/brunei'                        => 'Asia/Brunei',
  'asia/chita'                         => 'Asia/Chita',
  'asia/choibalsan'                    => 'Asia/Choibalsan',
  'asia/colombo'                       => 'Asia/Colombo',
  'asia/damascus'                      => 'Asia/Damascus',
  'asia/dhaka'                         => 'Asia/Dhaka',
  'asia/dili'                          => 'Asia/Dili',
  'asia/dubai'                         => 'Asia/Dubai',
  'asia/dushanbe'                      => 'Asia/Dushanbe',
  'asia/famagusta'                     => 'Asia/Famagusta',
  'asia/gaza'                          => 'Asia/Gaza',
  'asia/hebron'                        => 'Asia/Hebron',
  'asia/ho_chi_minh'                   => 'Asia/Ho_Chi_Minh',
  'asia/hong_kong'                     => 'Asia/Hong_Kong',
  'asia/hovd'                          => 'Asia/Hovd',
  'asia/irkutsk'                       => 'Asia/Irkutsk',
  'asia/jakarta'                       => 'Asia/Jakarta',
  'asia/jayapura'                      => 'Asia/Jayapura',
  'asia/jerusalem'                     => 'Asia/Jerusalem',
  'asia/kabul'                         => 'Asia/Kabul',
  'asia/kamchatka'                     => 'Asia/Kamchatka',
  'asia/karachi'                       => 'Asia/Karachi',
  'asia/kathmandu'                     => 'Asia/Kathmandu',
  'asia/khandyga'                      => 'Asia/Khandyga',
  'asia/kolkata'                       => 'Asia/Kolkata',
  'asia/krasnoyarsk'                   => 'Asia/Krasnoyarsk',
  'asia/kuala_lumpur'                  => 'Asia/Kuala_Lumpur',
  'asia/kuching'                       => 'Asia/Kuching',
  'asia/macau'                         => 'Asia/Macau',
  'asia/magadan'                       => 'Asia/Magadan',
  'asia/makassar'                      => 'Asia/Makassar',
  'asia/manila'                        => 'Asia/Manila',
  'asia/nicosia'                       => 'Asia/Nicosia',
  'asia/novokuznetsk'                  => 'Asia/Novokuznetsk',
  'asia/novosibirsk'                   => 'Asia/Novosibirsk',
  'asia/omsk'                          => 'Asia/Omsk',
  'asia/oral'                          => 'Asia/Oral',
  'asia/pontianak'                     => 'Asia/Pontianak',
  'asia/pyongyang'                     => 'Asia/Pyongyang',
  'asia/qatar'                         => 'Asia/Qatar',
  'asia/qyzylorda'                     => 'Asia/Qyzylorda',
  'asia/riyadh'                        => 'Asia/Riyadh',
  'asia/sakhalin'                      => 'Asia/Sakhalin',
  'asia/samarkand'                     => 'Asia/Samarkand',
  'asia/seoul'                         => 'Asia/Seoul',
  'asia/shanghai'                      => 'Asia/Shanghai',
  'asia/singapore'                     => 'Asia/Singapore',
  'asia/srednekolymsk'                 => 'Asia/Srednekolymsk',
  'asia/taipei'                        => 'Asia/Taipei',
  'asia/tashkent'                      => 'Asia/Tashkent',
  'asia/tbilisi'                       => 'Asia/Tbilisi',
  'asia/tehran'                        => 'Asia/Tehran',
  'asia/thimphu'                       => 'Asia/Thimphu',
  'asia/tokyo'                         => 'Asia/Tokyo',
  'asia/tomsk'                         => 'Asia/Tomsk',
  'asia/ulaanbaatar'                   => 'Asia/Ulaanbaatar',
  'asia/urumqi'                        => 'Asia/Urumqi',
  'asia/ust-nera'                      => 'Asia/Ust-Nera',
  'asia/vladivostok'                   => 'Asia/Vladivostok',
  'asia/yakutsk'                       => 'Asia/Yakutsk',
  'asia/yangon'                        => 'Asia/Yangon',
  'asia/yekaterinburg'                 => 'Asia/Yekaterinburg',
  'asia/yerevan'                       => 'Asia/Yerevan',
  'atlantic/azores'                    => 'Atlantic/Azores',
  'atlantic/bermuda'                   => 'Atlantic/Bermuda',
  'atlantic/canary'                    => 'Atlantic/Canary',
  'atlantic/cape_verde'                => 'Atlantic/Cape_Verde',
  'atlantic/faroe'                     => 'Atlantic/Faroe',
  'atlantic/madeira'                   => 'Atlantic/Madeira',
  'atlantic/reykjavik'                 => 'Atlantic/Reykjavik',
  'atlantic/south_georgia'             => 'Atlantic/South_Georgia',
  'atlantic/stanley'                   => 'Atlantic/Stanley',
  'australia/adelaide'                 => 'Australia/Adelaide',
  'australia/brisbane'                 => 'Australia/Brisbane',
  'australia/broken_hill'              => 'Australia/Broken_Hill',
  'australia/currie'                   => 'Australia/Currie',
  'australia/darwin'                   => 'Australia/Darwin',
  'australia/eucla'                    => 'Australia/Eucla',
  'australia/hobart'                   => 'Australia/Hobart',
  'australia/lindeman'                 => 'Australia/Lindeman',
  'australia/lord_howe'                => 'Australia/Lord_Howe',
  'australia/melbourne'                => 'Australia/Melbourne',
  'australia/perth'                    => 'Australia/Perth',
  'australia/sydney'                   => 'Australia/Sydney',
  'cet'                                => 'CET',
  'eet'                                => 'EET',
  'europe/amsterdam'                   => 'Europe/Amsterdam',
  'europe/andorra'                     => 'Europe/Andorra',
  'europe/astrakhan'                   => 'Europe/Astrakhan',
  'europe/athens'                      => 'Europe/Athens',
  'europe/belgrade'                    => 'Europe/Belgrade',
  'europe/berlin'                      => 'Europe/Berlin',
  'europe/brussels'                    => 'Europe/Brussels',
  'europe/bucharest'                   => 'Europe/Bucharest',
  'europe/budapest'                    => 'Europe/Budapest',
  'europe/chisinau'                    => 'Europe/Chisinau',
  'europe/copenhagen'                  => 'Europe/Copenhagen',
  'europe/dublin'                      => 'Europe/Dublin',
  'europe/gibraltar'                   => 'Europe/Gibraltar',
  'europe/helsinki'                    => 'Europe/Helsinki',
  'europe/istanbul'                    => 'Europe/Istanbul',
  'europe/kaliningrad'                 => 'Europe/Kaliningrad',
  'europe/kiev'                        => 'Europe/Kiev',
  'europe/kirov'                       => 'Europe/Kirov',
  'europe/lisbon'                      => 'Europe/Lisbon',
  'europe/london'                      => 'Europe/London',
  'europe/luxembourg'                  => 'Europe/Luxembourg',
  'europe/madrid'                      => 'Europe/Madrid',
  'europe/malta'                       => 'Europe/Malta',
  'europe/minsk'                       => 'Europe/Minsk',
  'europe/monaco'                      => 'Europe/Monaco',
  'europe/moscow'                      => 'Europe/Moscow',
  'europe/oslo'                        => 'Europe/Oslo',
  'europe/paris'                       => 'Europe/Paris',
  'europe/prague'                      => 'Europe/Prague',
  'europe/riga'                        => 'Europe/Riga',
  'europe/rome'                        => 'Europe/Rome',
  'europe/samara'                      => 'Europe/Samara',
  'europe/saratov'                     => 'Europe/Saratov',
  'europe/simferopol'                  => 'Europe/Simferopol',
  'europe/sofia'                       => 'Europe/Sofia',
  'europe/stockholm'                   => 'Europe/Stockholm',
  'europe/tallinn'                     => 'Europe/Tallinn',
  'europe/tirane'                      => 'Europe/Tirane',
  'europe/ulyanovsk'                   => 'Europe/Ulyanovsk',
  'europe/uzhgorod'                    => 'Europe/Uzhgorod',
  'europe/vienna'                      => 'Europe/Vienna',
  'europe/vilnius'                     => 'Europe/Vilnius',
  'europe/volgograd'                   => 'Europe/Volgograd',
  'europe/warsaw'                      => 'Europe/Warsaw',
  'europe/zaporozhye'                  => 'Europe/Zaporozhye',
  'europe/zurich'                      => 'Europe/Zurich',
  'indian/chagos'                      => 'Indian/Chagos',
  'indian/christmas'                   => 'Indian/Christmas',
  'indian/cocos'                       => 'Indian/Cocos',
  'indian/kerguelen'                   => 'Indian/Kerguelen',
  'indian/mahe'                        => 'Indian/Mahe',
  'indian/maldives'                    => 'Indian/Maldives',
  'indian/mauritius'                   => 'Indian/Mauritius',
  'indian/reunion'                     => 'Indian/Reunion',
  'met'                                => 'MET',
  'pacific/apia'                       => 'Pacific/Apia',
  'pacific/auckland'                   => 'Pacific/Auckland',
  'pacific/bougainville'               => 'Pacific/Bougainville',
  'pacific/chatham'                    => 'Pacific/Chatham',
  'pacific/chuuk'                      => 'Pacific/Chuuk',
  'pacific/easter'                     => 'Pacific/Easter',
  'pacific/efate'                      => 'Pacific/Efate',
  'pacific/enderbury'                  => 'Pacific/Enderbury',
  'pacific/fakaofo'                    => 'Pacific/Fakaofo',
  'pacific/fiji'                       => 'Pacific/Fiji',
  'pacific/funafuti'                   => 'Pacific/Funafuti',
  'pacific/galapagos'                  => 'Pacific/Galapagos',
  'pacific/gambier'                    => 'Pacific/Gambier',
  'pacific/guadalcanal'                => 'Pacific/Guadalcanal',
  'pacific/guam'                       => 'Pacific/Guam',
  'pacific/honolulu'                   => 'Pacific/Honolulu',
  'pacific/kiritimati'                 => 'Pacific/Kiritimati',
  'pacific/kosrae'                     => 'Pacific/Kosrae',
  'pacific/kwajalein'                  => 'Pacific/Kwajalein',
  'pacific/majuro'                     => 'Pacific/Majuro',
  'pacific/marquesas'                  => 'Pacific/Marquesas',
  'pacific/nauru'                      => 'Pacific/Nauru',
  'pacific/niue'                       => 'Pacific/Niue',
  'pacific/norfolk'                    => 'Pacific/Norfolk',
  'pacific/noumea'                     => 'Pacific/Noumea',
  'pacific/pago_pago'                  => 'Pacific/Pago_Pago',
  'pacific/palau'                      => 'Pacific/Palau',
  'pacific/pitcairn'                   => 'Pacific/Pitcairn',
  'pacific/pohnpei'                    => 'Pacific/Pohnpei',
  'pacific/port_moresby'               => 'Pacific/Port_Moresby',
  'pacific/rarotonga'                  => 'Pacific/Rarotonga',
  'pacific/tahiti'                     => 'Pacific/Tahiti',
  'pacific/tarawa'                     => 'Pacific/Tarawa',
  'pacific/tongatapu'                  => 'Pacific/Tongatapu',
  'pacific/wake'                       => 'Pacific/Wake',
  'pacific/wallis'                     => 'Pacific/Wallis',
  'wet'                                => 'WET',
  'a'                                  => 'A',
  'b'                                  => 'B',
  'c'                                  => 'C',
  'd'                                  => 'D',
  'e'                                  => 'E',
  'etc/gmt'                            => 'Etc/GMT',
  'etc/gmt+1'                          => 'Etc/GMT+1',
  'etc/gmt+10'                         => 'Etc/GMT+10',
  'etc/gmt+11'                         => 'Etc/GMT+11',
  'etc/gmt+12'                         => 'Etc/GMT+12',
  'etc/gmt+2'                          => 'Etc/GMT+2',
  'etc/gmt+3'                          => 'Etc/GMT+3',
  'etc/gmt+4'                          => 'Etc/GMT+4',
  'etc/gmt+5'                          => 'Etc/GMT+5',
  'etc/gmt+6'                          => 'Etc/GMT+6',
  'etc/gmt+7'                          => 'Etc/GMT+7',
  'etc/gmt+8'                          => 'Etc/GMT+8',
  'etc/gmt+9'                          => 'Etc/GMT+9',
  'etc/gmt-1'                          => 'Etc/GMT-1',
  'etc/gmt-10'                         => 'Etc/GMT-10',
  'etc/gmt-11'                         => 'Etc/GMT-11',
  'etc/gmt-12'                         => 'Etc/GMT-12',
  'etc/gmt-13'                         => 'Etc/GMT-13',
  'etc/gmt-14'                         => 'Etc/GMT-14',
  'etc/gmt-2'                          => 'Etc/GMT-2',
  'etc/gmt-3'                          => 'Etc/GMT-3',
  'etc/gmt-4'                          => 'Etc/GMT-4',
  'etc/gmt-5'                          => 'Etc/GMT-5',
  'etc/gmt-6'                          => 'Etc/GMT-6',
  'etc/gmt-7'                          => 'Etc/GMT-7',
  'etc/gmt-8'                          => 'Etc/GMT-8',
  'etc/gmt-9'                          => 'Etc/GMT-9',
  'f'                                  => 'F',
  'g'                                  => 'G',
  'h'                                  => 'H',
  'i'                                  => 'I',
  'k'                                  => 'K',
  'l'                                  => 'L',
  'm'                                  => 'M',
  'n'                                  => 'N',
  'o'                                  => 'O',
  'p'                                  => 'P',
  'q'                                  => 'Q',
  'r'                                  => 'R',
  's'                                  => 'S',
  't'                                  => 'T',
  'u'                                  => 'U',
  'ut'                                 => 'UT',
  'utc'                                => 'UTC',
  'v'                                  => 'V',
  'w'                                  => 'W',
  'x'                                  => 'X',
  'y'                                  => 'Y',
  'z'                                  => 'Z',
);

%Alias = (
  'a'                                  => 'a',
  'africa/abidjan'                     => 'africa/abidjan',
  'africa/accra'                       => 'africa/accra',
  'africa/algiers'                     => 'africa/algiers',
  'africa/bissau'                      => 'africa/bissau',
  'africa/cairo'                       => 'africa/cairo',
  'africa/casablanca'                  => 'africa/casablanca',
  'africa/ceuta'                       => 'africa/ceuta',
  'africa/el_aaiun'                    => 'africa/el_aaiun',
  'africa/johannesburg'                => 'africa/johannesburg',
  'africa/juba'                        => 'africa/juba',
  'africa/khartoum'                    => 'africa/khartoum',
  'africa/lagos'                       => 'africa/lagos',
  'africa/maputo'                      => 'africa/maputo',
  'africa/monrovia'                    => 'africa/monrovia',
  'africa/nairobi'                     => 'africa/nairobi',
  'africa/ndjamena'                    => 'africa/ndjamena',
  'africa/sao_tome'                    => 'africa/sao_tome',
  'africa/tripoli'                     => 'africa/tripoli',
  'africa/tunis'                       => 'africa/tunis',
  'africa/windhoek'                    => 'africa/windhoek',
  'america/adak'                       => 'america/adak',
  'america/anchorage'                  => 'america/anchorage',
  'america/araguaina'                  => 'america/araguaina',
  'america/argentina/buenos_aires'     => 'america/argentina/buenos_aires',
  'america/argentina/catamarca'        => 'america/argentina/catamarca',
  'america/argentina/cordoba'          => 'america/argentina/cordoba',
  'america/argentina/jujuy'            => 'america/argentina/jujuy',
  'america/argentina/la_rioja'         => 'america/argentina/la_rioja',
  'america/argentina/mendoza'          => 'america/argentina/mendoza',
  'america/argentina/rio_gallegos'     => 'america/argentina/rio_gallegos',
  'america/argentina/salta'            => 'america/argentina/salta',
  'america/argentina/san_juan'         => 'america/argentina/san_juan',
  'america/argentina/san_luis'         => 'america/argentina/san_luis',
  'america/argentina/tucuman'          => 'america/argentina/tucuman',
  'america/argentina/ushuaia'          => 'america/argentina/ushuaia',
  'america/asuncion'                   => 'america/asuncion',
  'america/atikokan'                   => 'america/atikokan',
  'america/bahia'                      => 'america/bahia',
  'america/bahia_banderas'             => 'america/bahia_banderas',
  'america/barbados'                   => 'america/barbados',
  'america/belem'                      => 'america/belem',
  'america/belize'                     => 'america/belize',
  'america/blanc-sablon'               => 'america/blanc-sablon',
  'america/boa_vista'                  => 'america/boa_vista',
  'america/bogota'                     => 'america/bogota',
  'america/boise'                      => 'america/boise',
  'america/cambridge_bay'              => 'america/cambridge_bay',
  'america/campo_grande'               => 'america/campo_grande',
  'america/cancun'                     => 'america/cancun',
  'america/caracas'                    => 'america/caracas',
  'america/cayenne'                    => 'america/cayenne',
  'america/chicago'                    => 'america/chicago',
  'america/chihuahua'                  => 'america/chihuahua',
  'america/costa_rica'                 => 'america/costa_rica',
  'america/creston'                    => 'america/creston',
  'america/cuiaba'                     => 'america/cuiaba',
  'america/curacao'                    => 'america/curacao',
  'america/danmarkshavn'               => 'america/danmarkshavn',
  'america/dawson'                     => 'america/dawson',
  'america/dawson_creek'               => 'america/dawson_creek',
  'america/denver'                     => 'america/denver',
  'america/detroit'                    => 'america/detroit',
  'america/edmonton'                   => 'america/edmonton',
  'america/eirunepe'                   => 'america/eirunepe',
  'america/el_salvador'                => 'america/el_salvador',
  'america/fort_nelson'                => 'america/fort_nelson',
  'america/fortaleza'                  => 'america/fortaleza',
  'america/glace_bay'                  => 'america/glace_bay',
  'america/godthab'                    => 'america/godthab',
  'america/goose_bay'                  => 'america/goose_bay',
  'america/grand_turk'                 => 'america/grand_turk',
  'america/guatemala'                  => 'america/guatemala',
  'america/guayaquil'                  => 'america/guayaquil',
  'america/guyana'                     => 'america/guyana',
  'america/halifax'                    => 'america/halifax',
  'america/havana'                     => 'america/havana',
  'america/hermosillo'                 => 'america/hermosillo',
  'america/indiana/indianapolis'       => 'america/indiana/indianapolis',
  'america/indiana/knox'               => 'america/indiana/knox',
  'america/indiana/marengo'            => 'america/indiana/marengo',
  'america/indiana/petersburg'         => 'america/indiana/petersburg',
  'america/indiana/tell_city'          => 'america/indiana/tell_city',
  'america/indiana/vevay'              => 'america/indiana/vevay',
  'america/indiana/vincennes'          => 'america/indiana/vincennes',
  'america/indiana/winamac'            => 'america/indiana/winamac',
  'america/inuvik'                     => 'america/inuvik',
  'america/iqaluit'                    => 'america/iqaluit',
  'america/jamaica'                    => 'america/jamaica',
  'america/juneau'                     => 'america/juneau',
  'america/kentucky/louisville'        => 'america/kentucky/louisville',
  'america/kentucky/monticello'        => 'america/kentucky/monticello',
  'america/la_paz'                     => 'america/la_paz',
  'america/lima'                       => 'america/lima',
  'america/los_angeles'                => 'america/los_angeles',
  'america/maceio'                     => 'america/maceio',
  'america/managua'                    => 'america/managua',
  'america/manaus'                     => 'america/manaus',
  'america/martinique'                 => 'america/martinique',
  'america/matamoros'                  => 'america/matamoros',
  'america/mazatlan'                   => 'america/mazatlan',
  'america/menominee'                  => 'america/menominee',
  'america/merida'                     => 'america/merida',
  'america/metlakatla'                 => 'america/metlakatla',
  'america/mexico_city'                => 'america/mexico_city',
  'america/miquelon'                   => 'america/miquelon',
  'america/moncton'                    => 'america/moncton',
  'america/monterrey'                  => 'america/monterrey',
  'america/montevideo'                 => 'america/montevideo',
  'america/nassau'                     => 'america/nassau',
  'america/new_york'                   => 'america/new_york',
  'america/nipigon'                    => 'america/nipigon',
  'america/nome'                       => 'america/nome',
  'america/noronha'                    => 'america/noronha',
  'america/north_dakota/beulah'        => 'america/north_dakota/beulah',
  'america/north_dakota/center'        => 'america/north_dakota/center',
  'america/north_dakota/new_salem'     => 'america/north_dakota/new_salem',
  'america/ojinaga'                    => 'america/ojinaga',
  'america/panama'                     => 'america/panama',
  'america/pangnirtung'                => 'america/pangnirtung',
  'america/paramaribo'                 => 'america/paramaribo',
  'america/phoenix'                    => 'america/phoenix',
  'america/port-au-prince'             => 'america/port-au-prince',
  'america/port_of_spain'              => 'america/port_of_spain',
  'america/porto_velho'                => 'america/porto_velho',
  'america/puerto_rico'                => 'america/puerto_rico',
  'america/punta_arenas'               => 'america/punta_arenas',
  'america/rainy_river'                => 'america/rainy_river',
  'america/rankin_inlet'               => 'america/rankin_inlet',
  'america/recife'                     => 'america/recife',
  'america/regina'                     => 'america/regina',
  'america/resolute'                   => 'america/resolute',
  'america/rio_branco'                 => 'america/rio_branco',
  'america/santarem'                   => 'america/santarem',
  'america/santiago'                   => 'america/santiago',
  'america/santo_domingo'              => 'america/santo_domingo',
  'america/sao_paulo'                  => 'america/sao_paulo',
  'america/scoresbysund'               => 'america/scoresbysund',
  'america/sitka'                      => 'america/sitka',
  'america/st_johns'                   => 'america/st_johns',
  'america/swift_current'              => 'america/swift_current',
  'america/tegucigalpa'                => 'america/tegucigalpa',
  'america/thule'                      => 'america/thule',
  'america/thunder_bay'                => 'america/thunder_bay',
  'america/tijuana'                    => 'america/tijuana',
  'america/toronto'                    => 'america/toronto',
  'america/vancouver'                  => 'america/vancouver',
  'america/whitehorse'                 => 'america/whitehorse',
  'america/winnipeg'                   => 'america/winnipeg',
  'america/yakutat'                    => 'america/yakutat',
  'america/yellowknife'                => 'america/yellowknife',
  'antarctica/casey'                   => 'antarctica/casey',
  'antarctica/davis'                   => 'antarctica/davis',
  'antarctica/dumontdurville'          => 'antarctica/dumontdurville',
  'antarctica/macquarie'               => 'antarctica/macquarie',
  'antarctica/mawson'                  => 'antarctica/mawson',
  'antarctica/palmer'                  => 'antarctica/palmer',
  'antarctica/rothera'                 => 'antarctica/rothera',
  'antarctica/syowa'                   => 'antarctica/syowa',
  'antarctica/troll'                   => 'antarctica/troll',
  'antarctica/vostok'                  => 'antarctica/vostok',
  'asia/almaty'                        => 'asia/almaty',
  'asia/amman'                         => 'asia/amman',
  'asia/anadyr'                        => 'asia/anadyr',
  'asia/aqtau'                         => 'asia/aqtau',
  'asia/aqtobe'                        => 'asia/aqtobe',
  'asia/ashgabat'                      => 'asia/ashgabat',
  'asia/atyrau'                        => 'asia/atyrau',
  'asia/baghdad'                       => 'asia/baghdad',
  'asia/baku'                          => 'asia/baku',
  'asia/bangkok'                       => 'asia/bangkok',
  'asia/barnaul'                       => 'asia/barnaul',
  'asia/beirut'                        => 'asia/beirut',
  'asia/bishkek'                       => 'asia/bishkek',
  'asia/brunei'                        => 'asia/brunei',
  'asia/chita'                         => 'asia/chita',
  'asia/choibalsan'                    => 'asia/choibalsan',
  'asia/colombo'                       => 'asia/colombo',
  'asia/damascus'                      => 'asia/damascus',
  'asia/dhaka'                         => 'asia/dhaka',
  'asia/dili'                          => 'asia/dili',
  'asia/dubai'                         => 'asia/dubai',
  'asia/dushanbe'                      => 'asia/dushanbe',
  'asia/famagusta'                     => 'asia/famagusta',
  'asia/gaza'                          => 'asia/gaza',
  'asia/hebron'                        => 'asia/hebron',
  'asia/ho_chi_minh'                   => 'asia/ho_chi_minh',
  'asia/hong_kong'                     => 'asia/hong_kong',
  'asia/hovd'                          => 'asia/hovd',
  'asia/irkutsk'                       => 'asia/irkutsk',
  'asia/jakarta'                       => 'asia/jakarta',
  'asia/jayapura'                      => 'asia/jayapura',
  'asia/jerusalem'                     => 'asia/jerusalem',
  'asia/kabul'                         => 'asia/kabul',
  'asia/kamchatka'                     => 'asia/kamchatka',
  'asia/karachi'                       => 'asia/karachi',
  'asia/kathmandu'                     => 'asia/kathmandu',
  'asia/khandyga'                      => 'asia/khandyga',
  'asia/kolkata'                       => 'asia/kolkata',
  'asia/krasnoyarsk'                   => 'asia/krasnoyarsk',
  'asia/kuala_lumpur'                  => 'asia/kuala_lumpur',
  'asia/kuching'                       => 'asia/kuching',
  'asia/macau'                         => 'asia/macau',
  'asia/magadan'                       => 'asia/magadan',
  'asia/makassar'                      => 'asia/makassar',
  'asia/manila'                        => 'asia/manila',
  'asia/nicosia'                       => 'asia/nicosia',
  'asia/novokuznetsk'                  => 'asia/novokuznetsk',
  'asia/novosibirsk'                   => 'asia/novosibirsk',
  'asia/omsk'                          => 'asia/omsk',
  'asia/oral'                          => 'asia/oral',
  'asia/pontianak'                     => 'asia/pontianak',
  'asia/pyongyang'                     => 'asia/pyongyang',
  'asia/qatar'                         => 'asia/qatar',
  'asia/qyzylorda'                     => 'asia/qyzylorda',
  'asia/riyadh'                        => 'asia/riyadh',
  'asia/sakhalin'                      => 'asia/sakhalin',
  'asia/samarkand'                     => 'asia/samarkand',
  'asia/seoul'                         => 'asia/seoul',
  'asia/shanghai'                      => 'asia/shanghai',
  'asia/singapore'                     => 'asia/singapore',
  'asia/srednekolymsk'                 => 'asia/srednekolymsk',
  'asia/taipei'                        => 'asia/taipei',
  'asia/tashkent'                      => 'asia/tashkent',
  'asia/tbilisi'                       => 'asia/tbilisi',
  'asia/tehran'                        => 'asia/tehran',
  'asia/thimphu'                       => 'asia/thimphu',
  'asia/tokyo'                         => 'asia/tokyo',
  'asia/tomsk'                         => 'asia/tomsk',
  'asia/ulaanbaatar'                   => 'asia/ulaanbaatar',
  'asia/urumqi'                        => 'asia/urumqi',
  'asia/ust-nera'                      => 'asia/ust-nera',
  'asia/vladivostok'                   => 'asia/vladivostok',
  'asia/yakutsk'                       => 'asia/yakutsk',
  'asia/yangon'                        => 'asia/yangon',
  'asia/yekaterinburg'                 => 'asia/yekaterinburg',
  'asia/yerevan'                       => 'asia/yerevan',
  'atlantic/azores'                    => 'atlantic/azores',
  'atlantic/bermuda'                   => 'atlantic/bermuda',
  'atlantic/canary'                    => 'atlantic/canary',
  'atlantic/cape_verde'                => 'atlantic/cape_verde',
  'atlantic/faroe'                     => 'atlantic/faroe',
  'atlantic/madeira'                   => 'atlantic/madeira',
  'atlantic/reykjavik'                 => 'atlantic/reykjavik',
  'atlantic/south_georgia'             => 'atlantic/south_georgia',
  'atlantic/stanley'                   => 'atlantic/stanley',
  'australia/adelaide'                 => 'australia/adelaide',
  'australia/brisbane'                 => 'australia/brisbane',
  'australia/broken_hill'              => 'australia/broken_hill',
  'australia/currie'                   => 'australia/currie',
  'australia/darwin'                   => 'australia/darwin',
  'australia/eucla'                    => 'australia/eucla',
  'australia/hobart'                   => 'australia/hobart',
  'australia/lindeman'                 => 'australia/lindeman',
  'australia/lord_howe'                => 'australia/lord_howe',
  'australia/melbourne'                => 'australia/melbourne',
  'australia/perth'                    => 'australia/perth',
  'australia/sydney'                   => 'australia/sydney',
  'b'                                  => 'b',
  'c'                                  => 'c',
  'cet'                                => 'cet',
  'd'                                  => 'd',
  'e'                                  => 'e',
  'eet'                                => 'eet',
  'etc/gmt'                            => 'etc/gmt',
  'etc/gmt+1'                          => 'etc/gmt+1',
  'etc/gmt+10'                         => 'etc/gmt+10',
  'etc/gmt+11'                         => 'etc/gmt+11',
  'etc/gmt+12'                         => 'etc/gmt+12',
  'etc/gmt+2'                          => 'etc/gmt+2',
  'etc/gmt+3'                          => 'etc/gmt+3',
  'etc/gmt+4'                          => 'etc/gmt+4',
  'etc/gmt+5'                          => 'etc/gmt+5',
  'etc/gmt+6'                          => 'etc/gmt+6',
  'etc/gmt+7'                          => 'etc/gmt+7',
  'etc/gmt+8'                          => 'etc/gmt+8',
  'etc/gmt+9'                          => 'etc/gmt+9',
  'etc/gmt-1'                          => 'etc/gmt-1',
  'etc/gmt-10'                         => 'etc/gmt-10',
  'etc/gmt-11'                         => 'etc/gmt-11',
  'etc/gmt-12'                         => 'etc/gmt-12',
  'etc/gmt-13'                         => 'etc/gmt-13',
  'etc/gmt-14'                         => 'etc/gmt-14',
  'etc/gmt-2'                          => 'etc/gmt-2',
  'etc/gmt-3'                          => 'etc/gmt-3',
  'etc/gmt-4'                          => 'etc/gmt-4',
  'etc/gmt-5'                          => 'etc/gmt-5',
  'etc/gmt-6'                          => 'etc/gmt-6',
  'etc/gmt-7'                          => 'etc/gmt-7',
  'etc/gmt-8'                          => 'etc/gmt-8',
  'etc/gmt-9'                          => 'etc/gmt-9',
  'europe/amsterdam'                   => 'europe/amsterdam',
  'europe/andorra'                     => 'europe/andorra',
  'europe/astrakhan'                   => 'europe/astrakhan',
  'europe/athens'                      => 'europe/athens',
  'europe/belgrade'                    => 'europe/belgrade',
  'europe/berlin'                      => 'europe/berlin',
  'europe/brussels'                    => 'europe/brussels',
  'europe/bucharest'                   => 'europe/bucharest',
  'europe/budapest'                    => 'europe/budapest',
  'europe/chisinau'                    => 'europe/chisinau',
  'europe/copenhagen'                  => 'europe/copenhagen',
  'europe/dublin'                      => 'europe/dublin',
  'europe/gibraltar'                   => 'europe/gibraltar',
  'europe/helsinki'                    => 'europe/helsinki',
  'europe/istanbul'                    => 'europe/istanbul',
  'europe/kaliningrad'                 => 'europe/kaliningrad',
  'europe/kiev'                        => 'europe/kiev',
  'europe/kirov'                       => 'europe/kirov',
  'europe/lisbon'                      => 'europe/lisbon',
  'europe/london'                      => 'europe/london',
  'europe/luxembourg'                  => 'europe/luxembourg',
  'europe/madrid'                      => 'europe/madrid',
  'europe/malta'                       => 'europe/malta',
  'europe/minsk'                       => 'europe/minsk',
  'europe/monaco'                      => 'europe/monaco',
  'europe/moscow'                      => 'europe/moscow',
  'europe/oslo'                        => 'europe/oslo',
  'europe/paris'                       => 'europe/paris',
  'europe/prague'                      => 'europe/prague',
  'europe/riga'                        => 'europe/riga',
  'europe/rome'                        => 'europe/rome',
  'europe/samara'                      => 'europe/samara',
  'europe/saratov'                     => 'europe/saratov',
  'europe/simferopol'                  => 'europe/simferopol',
  'europe/sofia'                       => 'europe/sofia',
  'europe/stockholm'                   => 'europe/stockholm',
  'europe/tallinn'                     => 'europe/tallinn',
  'europe/tirane'                      => 'europe/tirane',
  'europe/ulyanovsk'                   => 'europe/ulyanovsk',
  'europe/uzhgorod'                    => 'europe/uzhgorod',
  'europe/vienna'                      => 'europe/vienna',
  'europe/vilnius'                     => 'europe/vilnius',
  'europe/volgograd'                   => 'europe/volgograd',
  'europe/warsaw'                      => 'europe/warsaw',
  'europe/zaporozhye'                  => 'europe/zaporozhye',
  'europe/zurich'                      => 'europe/zurich',
  'f'                                  => 'f',
  'g'                                  => 'g',
  'h'                                  => 'h',
  'i'                                  => 'i',
  'indian/chagos'                      => 'indian/chagos',
  'indian/christmas'                   => 'indian/christmas',
  'indian/cocos'                       => 'indian/cocos',
  'indian/kerguelen'                   => 'indian/kerguelen',
  'indian/mahe'                        => 'indian/mahe',
  'indian/maldives'                    => 'indian/maldives',
  'indian/mauritius'                   => 'indian/mauritius',
  'indian/reunion'                     => 'indian/reunion',
  'k'                                  => 'k',
  'l'                                  => 'l',
  'm'                                  => 'm',
  'met'                                => 'met',
  'n'                                  => 'n',
  'o'                                  => 'o',
  'p'                                  => 'p',
  'pacific/apia'                       => 'pacific/apia',
  'pacific/auckland'                   => 'pacific/auckland',
  'pacific/bougainville'               => 'pacific/bougainville',
  'pacific/chatham'                    => 'pacific/chatham',
  'pacific/chuuk'                      => 'pacific/chuuk',
  'pacific/easter'                     => 'pacific/easter',
  'pacific/efate'                      => 'pacific/efate',
  'pacific/enderbury'                  => 'pacific/enderbury',
  'pacific/fakaofo'                    => 'pacific/fakaofo',
  'pacific/fiji'                       => 'pacific/fiji',
  'pacific/funafuti'                   => 'pacific/funafuti',
  'pacific/galapagos'                  => 'pacific/galapagos',
  'pacific/gambier'                    => 'pacific/gambier',
  'pacific/guadalcanal'                => 'pacific/guadalcanal',
  'pacific/guam'                       => 'pacific/guam',
  'pacific/honolulu'                   => 'pacific/honolulu',
  'pacific/kiritimati'                 => 'pacific/kiritimati',
  'pacific/kosrae'                     => 'pacific/kosrae',
  'pacific/kwajalein'                  => 'pacific/kwajalein',
  'pacific/majuro'                     => 'pacific/majuro',
  'pacific/marquesas'                  => 'pacific/marquesas',
  'pacific/nauru'                      => 'pacific/nauru',
  'pacific/niue'                       => 'pacific/niue',
  'pacific/norfolk'                    => 'pacific/norfolk',
  'pacific/noumea'                     => 'pacific/noumea',
  'pacific/pago_pago'                  => 'pacific/pago_pago',
  'pacific/palau'                      => 'pacific/palau',
  'pacific/pitcairn'                   => 'pacific/pitcairn',
  'pacific/pohnpei'                    => 'pacific/pohnpei',
  'pacific/port_moresby'               => 'pacific/port_moresby',
  'pacific/rarotonga'                  => 'pacific/rarotonga',
  'pacific/tahiti'                     => 'pacific/tahiti',
  'pacific/tarawa'                     => 'pacific/tarawa',
  'pacific/tongatapu'                  => 'pacific/tongatapu',
  'pacific/wake'                       => 'pacific/wake',
  'pacific/wallis'                     => 'pacific/wallis',
  'q'                                  => 'q',
  'r'                                  => 'r',
  's'                                  => 's',
  't'                                  => 't',
  'u'                                  => 'u',
  'ut'                                 => 'ut',
  'utc'                                => 'utc',
  'v'                                  => 'v',
  'w'                                  => 'w',
  'wet'                                => 'wet',
  'x'                                  => 'x',
  'y'                                  => 'y',
  'z'                                  => 'z',
  'africa/addis_ababa'                 => 'africa/nairobi',
  'africa/asmara'                      => 'africa/nairobi',
  'africa/asmera'                      => 'africa/nairobi',
  'africa/bamako'                      => 'africa/abidjan',
  'africa/bangui'                      => 'africa/lagos',
  'africa/banjul'                      => 'africa/abidjan',
  'africa/blantyre'                    => 'africa/maputo',
  'africa/brazzaville'                 => 'africa/lagos',
  'africa/bujumbura'                   => 'africa/maputo',
  'africa/conakry'                     => 'africa/abidjan',
  'africa/dakar'                       => 'africa/abidjan',
  'africa/dar_es_salaam'               => 'africa/nairobi',
  'africa/djibouti'                    => 'africa/nairobi',
  'africa/douala'                      => 'africa/lagos',
  'africa/freetown'                    => 'africa/abidjan',
  'africa/gaborone'                    => 'africa/maputo',
  'africa/harare'                      => 'africa/maputo',
  'africa/kampala'                     => 'africa/nairobi',
  'africa/kigali'                      => 'africa/maputo',
  'africa/kinshasa'                    => 'africa/lagos',
  'africa/libreville'                  => 'africa/lagos',
  'africa/lome'                        => 'africa/abidjan',
  'africa/luanda'                      => 'africa/lagos',
  'africa/lubumbashi'                  => 'africa/maputo',
  'africa/lusaka'                      => 'africa/maputo',
  'africa/malabo'                      => 'africa/lagos',
  'africa/maseru'                      => 'africa/johannesburg',
  'africa/mbabane'                     => 'africa/johannesburg',
  'africa/mogadishu'                   => 'africa/nairobi',
  'africa/niamey'                      => 'africa/lagos',
  'africa/nouakchott'                  => 'africa/abidjan',
  'africa/ouagadougou'                 => 'africa/abidjan',
  'africa/porto-novo'                  => 'africa/lagos',
  'africa/timbuktu'                    => 'africa/abidjan',
  'america/anguilla'                   => 'america/port_of_spain',
  'america/antigua'                    => 'america/port_of_spain',
  'america/argentina/comodrivadavia'   => 'america/argentina/catamarca',
  'america/aruba'                      => 'america/curacao',
  'america/atka'                       => 'america/adak',
  'america/buenos_aires'               => 'america/argentina/buenos_aires',
  'america/catamarca'                  => 'america/argentina/catamarca',
  'america/cayman'                     => 'america/panama',
  'america/coral_harbour'              => 'america/atikokan',
  'america/cordoba'                    => 'america/argentina/cordoba',
  'america/dominica'                   => 'america/port_of_spain',
  'america/ensenada'                   => 'america/tijuana',
  'america/fort_wayne'                 => 'america/indiana/indianapolis',
  'america/grenada'                    => 'america/port_of_spain',
  'america/guadeloupe'                 => 'america/port_of_spain',
  'america/indianapolis'               => 'america/indiana/indianapolis',
  'america/jujuy'                      => 'america/argentina/jujuy',
  'america/knox_in'                    => 'america/indiana/knox',
  'america/kralendijk'                 => 'america/curacao',
  'america/louisville'                 => 'america/kentucky/louisville',
  'america/lower_princes'              => 'america/curacao',
  'america/marigot'                    => 'america/port_of_spain',
  'america/mendoza'                    => 'america/argentina/mendoza',
  'america/montreal'                   => 'america/toronto',
  'america/montserrat'                 => 'america/port_of_spain',
  'america/porto_acre'                 => 'america/rio_branco',
  'america/rosario'                    => 'america/argentina/cordoba',
  'america/santa_isabel'               => 'america/tijuana',
  'america/shiprock'                   => 'america/denver',
  'america/st_barthelemy'              => 'america/port_of_spain',
  'america/st_kitts'                   => 'america/port_of_spain',
  'america/st_lucia'                   => 'america/port_of_spain',
  'america/st_thomas'                  => 'america/port_of_spain',
  'america/st_vincent'                 => 'america/port_of_spain',
  'america/tortola'                    => 'america/port_of_spain',
  'america/virgin'                     => 'america/port_of_spain',
  'antarctica/mcmurdo'                 => 'pacific/auckland',
  'antarctica/south_pole'              => 'pacific/auckland',
  'arctic/longyearbyen'                => 'europe/oslo',
  'asia/aden'                          => 'asia/riyadh',
  'asia/ashkhabad'                     => 'asia/ashgabat',
  'asia/bahrain'                       => 'asia/qatar',
  'asia/calcutta'                      => 'asia/kolkata',
  'asia/chongqing'                     => 'asia/shanghai',
  'asia/chungking'                     => 'asia/shanghai',
  'asia/dacca'                         => 'asia/dhaka',
  'asia/harbin'                        => 'asia/shanghai',
  'asia/istanbul'                      => 'europe/istanbul',
  'asia/kashgar'                       => 'asia/urumqi',
  'asia/katmandu'                      => 'asia/kathmandu',
  'asia/kuwait'                        => 'asia/riyadh',
  'asia/macao'                         => 'asia/macau',
  'asia/muscat'                        => 'asia/dubai',
  'asia/phnom_penh'                    => 'asia/bangkok',
  'asia/rangoon'                       => 'asia/yangon',
  'asia/saigon'                        => 'asia/ho_chi_minh',
  'asia/tel_aviv'                      => 'asia/jerusalem',
  'asia/thimbu'                        => 'asia/thimphu',
  'asia/ujung_pandang'                 => 'asia/makassar',
  'asia/ulan_bator'                    => 'asia/ulaanbaatar',
  'asia/vientiane'                     => 'asia/bangkok',
  'atlantic/faeroe'                    => 'atlantic/faroe',
  'atlantic/jan_mayen'                 => 'europe/oslo',
  'atlantic/st_helena'                 => 'africa/abidjan',
  'australia/act'                      => 'australia/sydney',
  'australia/canberra'                 => 'australia/sydney',
  'australia/lhi'                      => 'australia/lord_howe',
  'australia/nsw'                      => 'australia/sydney',
  'australia/north'                    => 'australia/darwin',
  'australia/queensland'               => 'australia/brisbane',
  'australia/south'                    => 'australia/adelaide',
  'australia/tasmania'                 => 'australia/hobart',
  'australia/victoria'                 => 'australia/melbourne',
  'australia/west'                     => 'australia/perth',
  'australia/yancowinna'               => 'australia/broken_hill',
  'brazil/acre'                        => 'america/rio_branco',
  'brazil/denoronha'                   => 'america/noronha',
  'brazil/east'                        => 'america/sao_paulo',
  'brazil/west'                        => 'america/manaus',
  'canada/atlantic'                    => 'america/halifax',
  'canada/central'                     => 'america/winnipeg',
  'canada/eastern'                     => 'america/toronto',
  'canada/mountain'                    => 'america/edmonton',
  'canada/newfoundland'                => 'america/st_johns',
  'canada/pacific'                     => 'america/vancouver',
  'canada/saskatchewan'                => 'america/regina',
  'canada/yukon'                       => 'america/whitehorse',
  'chile/continental'                  => 'america/santiago',
  'chile/easterisland'                 => 'pacific/easter',
  'cuba'                               => 'america/havana',
  'egypt'                              => 'africa/cairo',
  'eire'                               => 'europe/dublin',
  'europe/belfast'                     => 'europe/london',
  'europe/bratislava'                  => 'europe/prague',
  'europe/busingen'                    => 'europe/zurich',
  'europe/guernsey'                    => 'europe/london',
  'europe/isle_of_man'                 => 'europe/london',
  'europe/jersey'                      => 'europe/london',
  'europe/ljubljana'                   => 'europe/belgrade',
  'europe/mariehamn'                   => 'europe/helsinki',
  'europe/nicosia'                     => 'asia/nicosia',
  'europe/podgorica'                   => 'europe/belgrade',
  'europe/san_marino'                  => 'europe/rome',
  'europe/sarajevo'                    => 'europe/belgrade',
  'europe/skopje'                      => 'europe/belgrade',
  'europe/tiraspol'                    => 'europe/chisinau',
  'europe/vaduz'                       => 'europe/zurich',
  'europe/vatican'                     => 'europe/rome',
  'europe/zagreb'                      => 'europe/belgrade',
  'gb'                                 => 'europe/london',
  'gb-eire'                            => 'europe/london',
  'hongkong'                           => 'asia/hong_kong',
  'iceland'                            => 'atlantic/reykjavik',
  'indian/antananarivo'                => 'africa/nairobi',
  'indian/comoro'                      => 'africa/nairobi',
  'indian/mayotte'                     => 'africa/nairobi',
  'iran'                               => 'asia/tehran',
  'israel'                             => 'asia/jerusalem',
  'jamaica'                            => 'america/jamaica',
  'japan'                              => 'asia/tokyo',
  'kwajalein'                          => 'pacific/kwajalein',
  'libya'                              => 'africa/tripoli',
  'mexico/bajanorte'                   => 'america/tijuana',
  'mexico/bajasur'                     => 'america/mazatlan',
  'mexico/general'                     => 'america/mexico_city',
  'nz'                                 => 'pacific/auckland',
  'nz-chat'                            => 'pacific/chatham',
  'navajo'                             => 'america/denver',
  'prc'                                => 'asia/shanghai',
  'pacific/johnston'                   => 'pacific/honolulu',
  'pacific/midway'                     => 'pacific/pago_pago',
  'pacific/ponape'                     => 'pacific/pohnpei',
  'pacific/saipan'                     => 'pacific/guam',
  'pacific/samoa'                      => 'pacific/pago_pago',
  'pacific/truk'                       => 'pacific/chuuk',
  'pacific/yap'                        => 'pacific/chuuk',
  'poland'                             => 'europe/warsaw',
  'portugal'                           => 'europe/lisbon',
  'roc'                                => 'asia/taipei',
  'rok'                                => 'asia/seoul',
  'singapore'                          => 'asia/singapore',
  'turkey'                             => 'europe/istanbul',
  'us/alaska'                          => 'america/anchorage',
  'us/aleutian'                        => 'america/adak',
  'us/arizona'                         => 'america/phoenix',
  'us/central'                         => 'america/chicago',
  'us/east-indiana'                    => 'america/indiana/indianapolis',
  'us/eastern'                         => 'america/new_york',
  'us/hawaii'                          => 'pacific/honolulu',
  'us/indiana-starke'                  => 'america/indiana/knox',
  'us/michigan'                        => 'america/detroit',
  'us/mountain'                        => 'america/denver',
  'us/pacific'                         => 'america/los_angeles',
  'us/pacific-new'                     => 'america/los_angeles',
  'us/samoa'                           => 'pacific/pago_pago',
  'w-su'                               => 'europe/moscow',
  'aest-10aedt'                        => 'australia/melbourne',
  'ahst10ahdt'                         => 'america/anchorage',
  'akst9akdt'                          => 'america/anchorage',
  'ast10apt'                           => 'america/anchorage',
  'ast4adt'                            => 'america/halifax',
  'ast4apt'                            => 'america/blanc-sablon',
  'awst-8awdt'                         => 'australia/perth',
  'bst11bdt'                           => 'america/adak',
  'cat-2cast'                          => 'africa/juba',
  'cat-2wat'                           => 'africa/windhoek',
  'cet-1cest'                          => 'cet',
  'cet-1wemt'                          => 'europe/monaco',
  'cet-1west'                          => 'europe/luxembourg',
  'cst-8cdt'                           => 'asia/shanghai',
  'cst5cdt'                            => 'america/havana',
  'cst6cdt'                            => 'america/chicago',
  'cst6cpt'                            => 'america/chicago',
  'eet-2eest'                          => 'eet',
  'est5edt'                            => 'america/new_york',
  'est5ept'                            => 'america/new_york',
  'gmt0bst'                            => 'europe/london',
  'gmt0ist'                            => 'europe/dublin',
  'hkt-8hkst'                          => 'asia/hong_kong',
  'hst10hdt'                           => 'america/adak',
  'ist-1gmt'                           => 'europe/dublin',
  'ist-2eest'                          => 'asia/gaza',
  'ist-2idt'                           => 'asia/jerusalem',
  'jst-9jdt'                           => 'asia/tokyo',
  'kst-9kdt'                           => 'asia/seoul',
  'met-1mest'                          => 'met',
  'msk-3cest'                          => 'europe/minsk',
  'msk-3msd'                           => 'europe/moscow',
  'mst7mdt'                            => 'america/denver',
  'mst7mpt'                            => 'america/denver',
  'nst11npt'                           => 'america/adak',
  'nzst-12nzdt'                        => 'pacific/auckland',
  'pkt-5pkst'                          => 'asia/karachi',
  'pst8pdt'                            => 'america/los_angeles',
  'pst8ppt'                            => 'america/los_angeles',
  'sast-2sast'                         => 'africa/johannesburg',
  'wet-1west'                          => 'europe/luxembourg',
  'wet0west'                           => 'wet',
  'yst9ydt'                            => 'america/yakutat',
  'yst9ypt'                            => 'america/whitehorse',
  'arst3ardt'                          => 'america/argentina/buenos_aires',
  'ast10adt'                           => 'america/adak',
  'ast4adt#canada'                     => 'america/halifax',
  'aus central standard time'          => 'australia/darwin',
  'aus eastern standard time'          => 'australia/sydney',
  'afghanistan standard time'          => 'asia/kabul',
  'alaskan standard time'              => 'america/anchorage',
  'arab standard time'                 => 'asia/riyadh',
  'arabian standard time'              => 'asia/dubai',
  'arabic standard time'               => 'asia/baghdad',
  'argentina standard time'            => 'america/argentina/buenos_aires',
  'atlantic standard time'             => 'america/halifax',
  'azerbaijan standard time'           => 'asia/baku',
  'azores standard time'               => 'atlantic/azores',
  'brst3brdt'                          => 'america/sao_paulo',
  'brwst4brwdt'                        => 'america/campo_grande',
  'bahia standard time'                => 'america/bahia',
  'bangladesh standard time'           => 'asia/dhaka',
  'csm6cdm'                            => 'america/mexico_city',
  'cst-9:30cdt'                        => 'australia/adelaide',
  'cst6cdt#canada'                     => 'america/winnipeg',
  'cst6cdt#indiana'                    => 'america/indiana/indianapolis',
  'cst6cdt#mexico'                     => 'america/mexico_city',
  'canada central standard time'       => 'america/regina',
  'cape verde standard time'           => 'atlantic/cape_verde',
  'caucasus standard time'             => 'asia/yerevan',
  'cen. australia standard time'       => 'australia/adelaide',
  'central america standard time'      => 'america/guatemala',
  'central asia standard time'         => 'asia/almaty',
  'central brazilian standard time'    => 'america/cuiaba',
  'central europe standard time'       => 'europe/budapest',
  'central european standard time'     => 'europe/warsaw',
  'central pacific standard time'      => 'pacific/guadalcanal',
  'central standard time'              => 'america/chicago',
  'central standard time (mexico)'     => 'america/mexico_city',
  'china standard time'                => 'asia/shanghai',
  'dateline standard time'             => 'etc/gmt+12',
  'e. africa standard time'            => 'africa/nairobi',
  'e. australia standard time'         => 'australia/brisbane',
  'e. europe standard time'            => 'asia/nicosia',
  'e. south america standard time'     => 'america/sao_paulo',
  'eet-2eetdst'                        => 'europe/helsinki',
  'est-10edt'                          => 'australia/melbourne',
  'est-10edt#nsw'                      => 'australia/sydney',
  'est-10edt#tasmania'                 => 'australia/hobart',
  'est-10edt#vic'                      => 'australia/melbourne',
  'est5cdt'                            => 'america/indiana/indianapolis',
  'est5edt#canada'                     => 'america/toronto',
  'est5edt#indiana'                    => 'america/indiana/indianapolis',
  'est5est'                            => 'america/indiana/indianapolis',
  'est6cdt'                            => 'america/indiana/indianapolis',
  'eastern standard time'              => 'america/new_york',
  'egypt standard time'                => 'africa/cairo',
  'ekaterinburg standard time'         => 'asia/yekaterinburg',
  'etc/uct'                            => 'utc',
  'etc/utc'                            => 'utc',
  'fle standard time'                  => 'europe/kiev',
  'fiji standard time'                 => 'pacific/fiji',
  'gmt'                                => 'etc/gmt',
  'gmt standard time'                  => 'europe/london',
  'gtb standard time'                  => 'europe/istanbul',
  'georgian standard time'             => 'asia/tbilisi',
  'greenland standard time'            => 'america/godthab',
  'greenwich standard time'            => 'atlantic/reykjavik',
  'hawaiian standard time'             => 'pacific/honolulu',
  'india standard time'                => 'asia/kolkata',
  'iran standard time'                 => 'asia/tehran',
  'israel standard time'               => 'asia/jerusalem',
  'jordan standard time'               => 'asia/amman',
  'kaliningrad standard time'          => 'europe/kaliningrad',
  'korea standard time'                => 'asia/seoul',
  'met-1metdst'                        => 'met',
  'mez-1mesz'                          => 'cet',
  'msm7mdm'                            => 'america/chihuahua',
  'mst7mdt#canada'                     => 'america/edmonton',
  'mst7mdt#mexico'                     => 'america/chihuahua',
  'mxst6mxdt'                          => 'america/mexico_city',
  'mxst6mxdt#mexico'                   => 'america/mexico_city',
  'magadan standard time'              => 'asia/magadan',
  'mauritius standard time'            => 'indian/mauritius',
  'middle east standard time'          => 'asia/beirut',
  'montevideo standard time'           => 'america/montevideo',
  'morocco standard time'              => 'africa/casablanca',
  'mountain standard time'             => 'america/denver',
  'mountain standard time (mexico)'    => 'america/chihuahua',
  'myanmar standard time'              => 'asia/yangon',
  'n. central asia standard time'      => 'asia/novosibirsk',
  'nst3:30ndt'                         => 'america/st_johns',
  'nst3:30ndt#canada'                  => 'america/st_johns',
  'namibia standard time'              => 'africa/windhoek',
  'nepal standard time'                => 'asia/kathmandu',
  'new zealand standard time'          => 'pacific/auckland',
  'newfoundland standard time'         => 'america/st_johns',
  'north asia east standard time'      => 'asia/irkutsk',
  'north asia standard time'           => 'asia/krasnoyarsk',
  'pst-8pdt'                           => 'asia/singapore',
  'pst8pdt#canada'                     => 'america/vancouver',
  'pwt0pst'                            => 'europe/lisbon',
  'pacific sa standard time'           => 'america/santiago',
  'pacific standard time'              => 'america/los_angeles',
  'pacific/johnston'                   => 'pacific/honolulu',
  'pakistan standard time'             => 'asia/karachi',
  'paraguay standard time'             => 'america/asuncion',
  'romance standard time'              => 'europe/paris',
  'russian standard time'              => 'europe/moscow',
  'sa eastern standard time'           => 'america/cayenne',
  'sa pacific standard time'           => 'america/bogota',
  'sa western standard time'           => 'america/la_paz',
  'sast-2'                             => 'africa/johannesburg',
  'se asia standard time'              => 'asia/bangkok',
  'samoa standard time'                => 'pacific/apia',
  'singapore standard time'            => 'asia/singapore',
  'south africa standard time'         => 'africa/johannesburg',
  'sri lanka standard time'            => 'asia/colombo',
  'syria standard time'                => 'asia/damascus',
  'taipei standard time'               => 'asia/taipei',
  'tasmania standard time'             => 'australia/hobart',
  'tokyo standard time'                => 'asia/tokyo',
  'tonga standard time'                => 'pacific/tongatapu',
  'turkey standard time'               => 'europe/istanbul',
  'uct'                                => 'utc',
  'us eastern standard time'           => 'america/indiana/indianapolis',
  'us mountain standard time'          => 'america/phoenix',
  'utc+12'                             => 'etc/gmt-12',
  'utc-02'                             => 'etc/gmt+2',
  'utc-11'                             => 'etc/gmt+11',
  'ulaanbaatar standard time'          => 'asia/ulaanbaatar',
  'venezuela standard time'            => 'america/caracas',
  'vladivostok standard time'          => 'asia/vladivostok',
  'w. australia standard time'         => 'australia/perth',
  'w. central africa standard time'    => 'africa/lagos',
  'w. europe standard time'            => 'europe/berlin',
  'wet0wetdst'                         => 'wet',
  'wst-10wstdst'                       => 'asia/vladivostok',
  'wst-11wstdst'                       => 'asia/srednekolymsk',
  'wst-12wstdst'                       => 'asia/kamchatka',
  'wst-2wstdst'                        => 'europe/minsk',
  'wst-3wstdst'                        => 'europe/moscow',
  'wst-4wstdst'                        => 'europe/samara',
  'wst-5wstdst'                        => 'asia/yekaterinburg',
  'wst-6wstdst'                        => 'asia/omsk',
  'wst-7wstdst'                        => 'asia/krasnoyarsk',
  'wst-8wdt'                           => 'australia/perth',
  'wst-8wstdst'                        => 'asia/irkutsk',
  'wst-9wstdst'                        => 'asia/yakutsk',
  'west asia standard time'            => 'asia/tashkent',
  'west pacific standard time'         => 'pacific/port_moresby',
  'yakutsk standard time'              => 'asia/yakutsk',
);

%Abbrev = (
  'a'           => [ 'a' ],
  'acdt'        => [ 'australia/adelaide',
                     'australia/broken_hill',
                     'australia/darwin' ],
  'acst'        => [ 'australia/adelaide',
                     'australia/darwin',
                     'australia/broken_hill' ],
  'addt'        => [ 'america/goose_bay',
                     'america/pangnirtung' ],
  'adt'         => [ 'america/halifax',
                     'america/glace_bay',
                     'america/moncton',
                     'america/goose_bay',
                     'atlantic/bermuda',
                     'america/thule',
                     'america/pangnirtung',
                     'america/barbados',
                     'america/martinique',
                     'america/blanc-sablon' ],
  'aedt'        => [ 'australia/melbourne',
                     'australia/currie',
                     'australia/hobart',
                     'australia/sydney',
                     'australia/lindeman',
                     'australia/brisbane',
                     'antarctica/macquarie' ],
  'aest'        => [ 'australia/melbourne',
                     'australia/brisbane',
                     'australia/lindeman',
                     'australia/currie',
                     'australia/hobart',
                     'australia/sydney',
                     'australia/lord_howe',
                     'australia/broken_hill',
                     'antarctica/macquarie' ],
  'ahdt'        => [ 'america/anchorage' ],
  'ahst'        => [ 'america/anchorage',
                     'america/adak' ],
  'akdt'        => [ 'america/anchorage',
                     'america/juneau',
                     'america/nome',
                     'america/sitka',
                     'america/yakutat',
                     'america/metlakatla' ],
  'akst'        => [ 'america/anchorage',
                     'america/juneau',
                     'america/nome',
                     'america/sitka',
                     'america/yakutat',
                     'america/metlakatla' ],
  'amt'         => [ 'europe/amsterdam',
                     'america/asuncion',
                     'europe/athens' ],
  'apt'         => [ 'america/halifax',
                     'america/anchorage',
                     'america/blanc-sablon',
                     'america/glace_bay',
                     'america/moncton',
                     'america/pangnirtung',
                     'america/puerto_rico' ],
  'ast'         => [ 'america/blanc-sablon',
                     'america/puerto_rico',
                     'america/glace_bay',
                     'america/halifax',
                     'america/moncton',
                     'america/martinique',
                     'america/port_of_spain',
                     'america/thule',
                     'atlantic/bermuda',
                     'america/barbados',
                     'america/curacao',
                     'america/goose_bay',
                     'america/santo_domingo',
                     'america/grand_turk',
                     'america/pangnirtung',
                     'america/miquelon',
                     'america/anchorage' ],
  'awdt'        => [ 'australia/perth' ],
  'awst'        => [ 'australia/perth' ],
  'awt'         => [ 'america/halifax',
                     'america/anchorage',
                     'america/blanc-sablon',
                     'america/glace_bay',
                     'america/moncton',
                     'america/pangnirtung',
                     'america/puerto_rico' ],
  'b'           => [ 'b' ],
  'bdst'        => [ 'europe/gibraltar',
                     'europe/london' ],
  'bdt'         => [ 'america/adak',
                     'america/nome' ],
  'bmt'         => [ 'america/barbados',
                     'europe/bucharest',
                     'europe/chisinau',
                     'asia/jakarta',
                     'asia/bangkok',
                     'asia/baghdad',
                     'america/bogota',
                     'europe/zurich',
                     'europe/brussels' ],
  'bst'         => [ 'europe/london',
                     'america/adak',
                     'america/nome',
                     'europe/gibraltar',
                     'america/la_paz',
                     'europe/dublin' ],
  'c'           => [ 'c' ],
  'cast'        => [ 'africa/juba',
                     'africa/khartoum' ],
  'cat'         => [ 'africa/maputo',
                     'africa/khartoum',
                     'africa/windhoek',
                     'africa/juba' ],
  'cddt'        => [ 'america/rankin_inlet',
                     'america/resolute' ],
  'cdt'         => [ 'america/chicago',
                     'america/winnipeg',
                     'america/indiana/knox',
                     'america/indiana/tell_city',
                     'america/menominee',
                     'america/rainy_river',
                     'america/havana',
                     'america/mexico_city',
                     'america/rankin_inlet',
                     'america/resolute',
                     'america/matamoros',
                     'america/monterrey',
                     'america/north_dakota/center',
                     'america/merida',
                     'america/north_dakota/new_salem',
                     'america/bahia_banderas',
                     'america/north_dakota/beulah',
                     'america/cancun',
                     'america/indiana/petersburg',
                     'america/indiana/vincennes',
                     'america/indiana/winamac',
                     'america/guatemala',
                     'america/managua',
                     'america/tegucigalpa',
                     'america/kentucky/monticello',
                     'america/cambridge_bay',
                     'america/iqaluit',
                     'america/pangnirtung',
                     'america/chihuahua',
                     'america/ojinaga',
                     'america/costa_rica',
                     'asia/shanghai',
                     'america/el_salvador',
                     'america/belize',
                     'asia/macau',
                     'asia/taipei',
                     'america/indiana/marengo',
                     'america/kentucky/louisville',
                     'america/indiana/indianapolis',
                     'america/atikokan',
                     'america/indiana/vevay' ],
  'cemt'        => [ 'europe/berlin' ],
  'cest'        => [ 'cet',
                     'europe/berlin',
                     'europe/brussels',
                     'europe/budapest',
                     'europe/copenhagen',
                     'europe/luxembourg',
                     'europe/malta',
                     'europe/oslo',
                     'europe/prague',
                     'europe/rome',
                     'europe/stockholm',
                     'europe/vienna',
                     'europe/warsaw',
                     'europe/amsterdam',
                     'europe/paris',
                     'europe/tirane',
                     'europe/belgrade',
                     'europe/zurich',
                     'europe/madrid',
                     'europe/monaco',
                     'europe/gibraltar',
                     'europe/andorra',
                     'africa/ceuta',
                     'africa/tripoli',
                     'africa/tunis',
                     'europe/vilnius',
                     'europe/lisbon',
                     'africa/algiers',
                     'europe/kaliningrad',
                     'europe/tallinn',
                     'europe/uzhgorod',
                     'europe/chisinau',
                     'europe/minsk',
                     'europe/riga',
                     'europe/simferopol',
                     'europe/sofia',
                     'europe/athens',
                     'europe/kiev',
                     'europe/zaporozhye' ],
  'cet'         => [ 'cet',
                     'europe/belgrade',
                     'europe/budapest',
                     'europe/prague',
                     'europe/berlin',
                     'europe/copenhagen',
                     'europe/malta',
                     'europe/rome',
                     'europe/vienna',
                     'europe/oslo',
                     'europe/zurich',
                     'europe/stockholm',
                     'europe/luxembourg',
                     'africa/tunis',
                     'europe/tirane',
                     'europe/brussels',
                     'europe/warsaw',
                     'europe/madrid',
                     'africa/algiers',
                     'europe/amsterdam',
                     'europe/paris',
                     'europe/monaco',
                     'europe/andorra',
                     'europe/gibraltar',
                     'africa/ceuta',
                     'africa/tripoli',
                     'europe/vilnius',
                     'europe/lisbon',
                     'europe/uzhgorod',
                     'africa/casablanca',
                     'europe/kaliningrad',
                     'europe/sofia',
                     'europe/tallinn',
                     'europe/athens',
                     'europe/chisinau',
                     'europe/minsk',
                     'europe/riga',
                     'europe/simferopol',
                     'europe/kiev',
                     'europe/zaporozhye' ],
  'cmt'         => [ 'america/la_paz',
                     'america/argentina/buenos_aires',
                     'america/argentina/catamarca',
                     'america/argentina/cordoba',
                     'america/argentina/jujuy',
                     'america/argentina/la_rioja',
                     'america/argentina/mendoza',
                     'america/argentina/rio_gallegos',
                     'america/argentina/salta',
                     'america/argentina/san_juan',
                     'america/argentina/san_luis',
                     'america/argentina/tucuman',
                     'america/argentina/ushuaia',
                     'europe/chisinau',
                     'america/caracas',
                     'america/panama',
                     'europe/copenhagen' ],
  'cpt'         => [ 'america/chicago',
                     'america/atikokan',
                     'america/indiana/indianapolis',
                     'america/indiana/knox',
                     'america/indiana/marengo',
                     'america/indiana/petersburg',
                     'america/indiana/tell_city',
                     'america/indiana/vevay',
                     'america/indiana/vincennes',
                     'america/indiana/winamac',
                     'america/kentucky/louisville',
                     'america/kentucky/monticello',
                     'america/menominee',
                     'america/rainy_river',
                     'america/winnipeg' ],
  'cst'         => [ 'america/chicago',
                     'america/indiana/knox',
                     'america/indiana/tell_city',
                     'america/menominee',
                     'america/winnipeg',
                     'america/rainy_river',
                     'asia/taipei',
                     'asia/shanghai',
                     'asia/macau',
                     'america/belize',
                     'america/guatemala',
                     'america/costa_rica',
                     'america/el_salvador',
                     'america/tegucigalpa',
                     'america/matamoros',
                     'america/merida',
                     'america/monterrey',
                     'america/havana',
                     'america/bahia_banderas',
                     'america/mexico_city',
                     'america/managua',
                     'america/resolute',
                     'america/rankin_inlet',
                     'america/regina',
                     'america/swift_current',
                     'america/north_dakota/center',
                     'america/north_dakota/new_salem',
                     'america/north_dakota/beulah',
                     'america/cancun',
                     'america/indiana/petersburg',
                     'america/indiana/vincennes',
                     'america/indiana/winamac',
                     'america/cambridge_bay',
                     'america/kentucky/monticello',
                     'america/iqaluit',
                     'america/pangnirtung',
                     'america/chihuahua',
                     'america/ojinaga',
                     'america/indiana/marengo',
                     'america/kentucky/louisville',
                     'america/indiana/indianapolis',
                     'america/indiana/vevay',
                     'america/hermosillo',
                     'america/mazatlan',
                     'america/atikokan',
                     'america/detroit',
                     'america/thunder_bay' ],
  'cwt'         => [ 'america/chicago',
                     'america/atikokan',
                     'america/indiana/indianapolis',
                     'america/indiana/knox',
                     'america/indiana/marengo',
                     'america/indiana/petersburg',
                     'america/indiana/tell_city',
                     'america/indiana/vevay',
                     'america/indiana/vincennes',
                     'america/indiana/winamac',
                     'america/kentucky/louisville',
                     'america/kentucky/monticello',
                     'america/menominee',
                     'america/rainy_river',
                     'america/winnipeg',
                     'america/mexico_city' ],
  'chst'        => [ 'pacific/guam' ],
  'd'           => [ 'd' ],
  'dmt'         => [ 'europe/dublin' ],
  'e'           => [ 'e' ],
  'eat'         => [ 'africa/nairobi',
                     'africa/juba',
                     'africa/khartoum' ],
  'eddt'        => [ 'america/iqaluit' ],
  'edt'         => [ 'america/new_york',
                     'america/nipigon',
                     'america/toronto',
                     'america/detroit',
                     'america/nassau',
                     'america/kentucky/louisville',
                     'america/indiana/indianapolis',
                     'america/indiana/marengo',
                     'america/indiana/vevay',
                     'america/indiana/vincennes',
                     'america/indiana/winamac',
                     'america/thunder_bay',
                     'america/grand_turk',
                     'america/iqaluit',
                     'america/port-au-prince',
                     'america/pangnirtung',
                     'america/kentucky/monticello',
                     'america/indiana/petersburg',
                     'america/cancun',
                     'america/jamaica',
                     'america/indiana/tell_city',
                     'america/santo_domingo' ],
  'eest'        => [ 'eet',
                     'asia/beirut',
                     'asia/damascus',
                     'europe/athens',
                     'europe/bucharest',
                     'europe/chisinau',
                     'asia/gaza',
                     'asia/hebron',
                     'europe/helsinki',
                     'asia/amman',
                     'asia/famagusta',
                     'asia/nicosia',
                     'europe/sofia',
                     'europe/riga',
                     'europe/tallinn',
                     'europe/vilnius',
                     'europe/kiev',
                     'europe/zaporozhye',
                     'europe/uzhgorod',
                     'europe/istanbul',
                     'africa/cairo',
                     'europe/simferopol',
                     'europe/kaliningrad',
                     'europe/minsk',
                     'europe/moscow',
                     'europe/warsaw' ],
  'eet'         => [ 'eet',
                     'asia/beirut',
                     'europe/sofia',
                     'asia/gaza',
                     'asia/hebron',
                     'africa/cairo',
                     'europe/athens',
                     'asia/damascus',
                     'europe/vilnius',
                     'europe/helsinki',
                     'europe/tallinn',
                     'asia/famagusta',
                     'asia/nicosia',
                     'europe/kiev',
                     'europe/zaporozhye',
                     'europe/riga',
                     'asia/amman',
                     'europe/bucharest',
                     'europe/chisinau',
                     'africa/tripoli',
                     'europe/kaliningrad',
                     'europe/uzhgorod',
                     'europe/istanbul',
                     'europe/simferopol',
                     'europe/minsk',
                     'europe/moscow',
                     'europe/warsaw' ],
  'emt'         => [ 'pacific/easter' ],
  'ept'         => [ 'america/new_york',
                     'america/detroit',
                     'america/iqaluit',
                     'america/nipigon',
                     'america/thunder_bay',
                     'america/toronto' ],
  'est'         => [ 'america/new_york',
                     'america/nipigon',
                     'america/toronto',
                     'america/panama',
                     'america/thunder_bay',
                     'america/grand_turk',
                     'america/jamaica',
                     'america/nassau',
                     'america/detroit',
                     'america/port-au-prince',
                     'america/atikokan',
                     'america/iqaluit',
                     'america/indiana/vevay',
                     'america/indiana/indianapolis',
                     'america/indiana/marengo',
                     'america/indiana/winamac',
                     'america/kentucky/louisville',
                     'america/indiana/vincennes',
                     'america/indiana/petersburg',
                     'america/cancun',
                     'america/pangnirtung',
                     'america/kentucky/monticello',
                     'america/resolute',
                     'america/indiana/knox',
                     'america/indiana/tell_city',
                     'america/rankin_inlet',
                     'america/santo_domingo',
                     'america/cambridge_bay',
                     'america/managua',
                     'america/merida',
                     'america/menominee',
                     'america/chicago',
                     'america/moncton' ],
  'ewt'         => [ 'america/new_york',
                     'america/detroit',
                     'america/iqaluit',
                     'america/nipigon',
                     'america/thunder_bay',
                     'america/toronto' ],
  'f'           => [ 'f' ],
  'ffmt'        => [ 'america/martinique' ],
  'fmt'         => [ 'atlantic/madeira' ],
  'g'           => [ 'g' ],
  'gmt'         => [ 'etc/gmt',
                     'europe/london',
                     'africa/abidjan',
                     'europe/dublin',
                     'africa/accra',
                     'atlantic/reykjavik',
                     'africa/monrovia',
                     'africa/bissau',
                     'america/danmarkshavn',
                     'africa/sao_tome',
                     'europe/gibraltar',
                     'europe/prague' ],
  'gmt+1'       => [ 'etc/gmt+1' ],
  'gmt+10'      => [ 'etc/gmt+10' ],
  'gmt+11'      => [ 'etc/gmt+11' ],
  'gmt+12'      => [ 'etc/gmt+12' ],
  'gmt+2'       => [ 'etc/gmt+2' ],
  'gmt+3'       => [ 'etc/gmt+3' ],
  'gmt+4'       => [ 'etc/gmt+4' ],
  'gmt+5'       => [ 'etc/gmt+5' ],
  'gmt+6'       => [ 'etc/gmt+6' ],
  'gmt+7'       => [ 'etc/gmt+7' ],
  'gmt+8'       => [ 'etc/gmt+8' ],
  'gmt+9'       => [ 'etc/gmt+9' ],
  'gmt-1'       => [ 'etc/gmt-1' ],
  'gmt-10'      => [ 'etc/gmt-10' ],
  'gmt-11'      => [ 'etc/gmt-11' ],
  'gmt-12'      => [ 'etc/gmt-12' ],
  'gmt-13'      => [ 'etc/gmt-13' ],
  'gmt-14'      => [ 'etc/gmt-14' ],
  'gmt-2'       => [ 'etc/gmt-2' ],
  'gmt-3'       => [ 'etc/gmt-3' ],
  'gmt-4'       => [ 'etc/gmt-4' ],
  'gmt-5'       => [ 'etc/gmt-5' ],
  'gmt-6'       => [ 'etc/gmt-6' ],
  'gmt-7'       => [ 'etc/gmt-7' ],
  'gmt-8'       => [ 'etc/gmt-8' ],
  'gmt-9'       => [ 'etc/gmt-9' ],
  'gst'         => [ 'pacific/guam' ],
  'h'           => [ 'h' ],
  'hdt'         => [ 'america/adak',
                     'pacific/honolulu' ],
  'hkst'        => [ 'asia/hong_kong' ],
  'hkt'         => [ 'asia/hong_kong' ],
  'hmt'         => [ 'asia/dhaka',
                     'america/havana',
                     'europe/helsinki',
                     'atlantic/azores',
                     'asia/kolkata' ],
  'hst'         => [ 'pacific/honolulu',
                     'america/adak' ],
  'i'           => [ 'i' ],
  'iddt'        => [ 'asia/jerusalem' ],
  'idt'         => [ 'asia/jerusalem',
                     'asia/gaza',
                     'asia/hebron' ],
  'imt'         => [ 'asia/irkutsk',
                     'europe/istanbul',
                     'europe/sofia' ],
  'ist'         => [ 'asia/kolkata',
                     'europe/dublin',
                     'asia/jerusalem',
                     'asia/gaza',
                     'asia/hebron' ],
  'jdt'         => [ 'asia/tokyo' ],
  'jmt'         => [ 'asia/jerusalem' ],
  'jst'         => [ 'asia/tokyo',
                     'asia/pyongyang',
                     'asia/seoul',
                     'asia/taipei',
                     'asia/hong_kong' ],
  'k'           => [ 'k' ],
  'kdt'         => [ 'asia/seoul' ],
  'kmt'         => [ 'europe/kiev',
                     'europe/vilnius',
                     'america/grand_turk',
                     'america/jamaica' ],
  'kst'         => [ 'asia/seoul',
                     'asia/pyongyang' ],
  'l'           => [ 'l' ],
  'lst'         => [ 'europe/riga' ],
  'm'           => [ 'm' ],
  'mddt'        => [ 'america/cambridge_bay',
                     'america/yellowknife' ],
  'mdst'        => [ 'europe/moscow' ],
  'mdt'         => [ 'america/denver',
                     'america/edmonton',
                     'america/boise',
                     'america/cambridge_bay',
                     'america/inuvik',
                     'america/yellowknife',
                     'america/mazatlan',
                     'america/chihuahua',
                     'america/ojinaga',
                     'america/north_dakota/beulah',
                     'america/bahia_banderas',
                     'america/north_dakota/new_salem',
                     'america/hermosillo',
                     'america/north_dakota/center',
                     'america/phoenix',
                     'america/swift_current',
                     'america/regina' ],
  'mest'        => [ 'met' ],
  'met'         => [ 'met' ],
  'mmt'         => [ 'africa/monrovia',
                     'indian/maldives',
                     'america/managua',
                     'asia/makassar',
                     'europe/minsk',
                     'america/montevideo',
                     'europe/moscow',
                     'asia/kolkata',
                     'asia/colombo' ],
  'mpt'         => [ 'america/denver',
                     'america/boise',
                     'america/cambridge_bay',
                     'america/edmonton',
                     'america/north_dakota/beulah',
                     'america/north_dakota/center',
                     'america/north_dakota/new_salem',
                     'america/regina',
                     'america/swift_current',
                     'america/yellowknife' ],
  'msd'         => [ 'europe/moscow',
                     'europe/simferopol',
                     'europe/chisinau',
                     'europe/kiev',
                     'europe/zaporozhye',
                     'europe/minsk',
                     'europe/uzhgorod',
                     'europe/kaliningrad',
                     'europe/riga',
                     'europe/tallinn',
                     'europe/vilnius' ],
  'msk'         => [ 'europe/moscow',
                     'europe/simferopol',
                     'europe/minsk',
                     'europe/zaporozhye',
                     'europe/kiev',
                     'europe/chisinau',
                     'europe/uzhgorod',
                     'europe/riga',
                     'europe/tallinn',
                     'europe/vilnius',
                     'europe/kaliningrad' ],
  'mst'         => [ 'america/denver',
                     'america/phoenix',
                     'america/creston',
                     'america/edmonton',
                     'america/cambridge_bay',
                     'america/chihuahua',
                     'america/hermosillo',
                     'america/mazatlan',
                     'america/ojinaga',
                     'america/boise',
                     'america/yellowknife',
                     'america/dawson_creek',
                     'america/inuvik',
                     'america/fort_nelson',
                     'america/north_dakota/beulah',
                     'america/bahia_banderas',
                     'america/north_dakota/new_salem',
                     'america/north_dakota/center',
                     'america/swift_current',
                     'america/regina',
                     'america/mexico_city',
                     'america/tijuana',
                     'europe/moscow' ],
  'mwt'         => [ 'america/denver',
                     'america/boise',
                     'america/cambridge_bay',
                     'america/edmonton',
                     'america/north_dakota/beulah',
                     'america/north_dakota/center',
                     'america/north_dakota/new_salem',
                     'america/regina',
                     'america/swift_current',
                     'america/yellowknife',
                     'america/phoenix' ],
  'n'           => [ 'n' ],
  'nddt'        => [ 'america/st_johns' ],
  'ndt'         => [ 'america/st_johns',
                     'america/goose_bay' ],
  'npt'         => [ 'america/adak',
                     'america/goose_bay',
                     'america/nome',
                     'america/st_johns' ],
  'nst'         => [ 'america/st_johns',
                     'america/adak',
                     'america/nome',
                     'america/goose_bay',
                     'europe/amsterdam' ],
  'nwt'         => [ 'america/st_johns',
                     'america/adak',
                     'america/goose_bay',
                     'america/nome' ],
  'nzdt'        => [ 'pacific/auckland' ],
  'nzmt'        => [ 'pacific/auckland' ],
  'nzst'        => [ 'pacific/auckland' ],
  'o'           => [ 'o' ],
  'p'           => [ 'p' ],
  'pddt'        => [ 'america/inuvik' ],
  'pdt'         => [ 'america/los_angeles',
                     'america/vancouver',
                     'america/tijuana',
                     'america/dawson',
                     'america/whitehorse',
                     'america/fort_nelson',
                     'america/juneau',
                     'america/metlakatla',
                     'america/sitka',
                     'america/dawson_creek',
                     'america/boise' ],
  'pkst'        => [ 'asia/karachi' ],
  'pkt'         => [ 'asia/karachi' ],
  'plmt'        => [ 'asia/ho_chi_minh' ],
  'pmmt'        => [ 'pacific/port_moresby',
                     'pacific/bougainville' ],
  'pmt'         => [ 'america/paramaribo',
                     'asia/pontianak',
                     'asia/yekaterinburg',
                     'africa/tunis',
                     'europe/monaco',
                     'europe/paris',
                     'africa/algiers',
                     'europe/prague' ],
  'ppmt'        => [ 'america/port-au-prince' ],
  'ppt'         => [ 'america/los_angeles',
                     'america/dawson_creek',
                     'america/fort_nelson',
                     'america/juneau',
                     'america/metlakatla',
                     'america/sitka',
                     'america/tijuana',
                     'america/vancouver' ],
  'pst'         => [ 'america/los_angeles',
                     'america/vancouver',
                     'america/tijuana',
                     'america/whitehorse',
                     'america/dawson',
                     'america/fort_nelson',
                     'america/metlakatla',
                     'america/juneau',
                     'america/sitka',
                     'america/inuvik',
                     'america/dawson_creek',
                     'america/bahia_banderas',
                     'america/hermosillo',
                     'america/mazatlan',
                     'america/boise',
                     'america/creston' ],
  'pwt'         => [ 'america/dawson_creek',
                     'america/fort_nelson',
                     'america/juneau',
                     'america/los_angeles',
                     'america/metlakatla',
                     'america/sitka',
                     'america/tijuana',
                     'america/vancouver' ],
  'q'           => [ 'q' ],
  'qmt'         => [ 'america/guayaquil' ],
  'r'           => [ 'r' ],
  'rmt'         => [ 'europe/riga',
                     'asia/yangon',
                     'europe/rome' ],
  's'           => [ 's' ],
  'sast'        => [ 'africa/johannesburg',
                     'africa/windhoek' ],
  'sdmt'        => [ 'america/santo_domingo' ],
  'set'         => [ 'europe/stockholm' ],
  'sjmt'        => [ 'america/costa_rica' ],
  'smt'         => [ 'america/punta_arenas',
                     'america/santiago',
                     'europe/simferopol',
                     'atlantic/stanley',
                     'asia/kuala_lumpur',
                     'asia/singapore' ],
  'sst'         => [ 'pacific/pago_pago' ],
  't'           => [ 't' ],
  'tbmt'        => [ 'asia/tbilisi' ],
  'tmt'         => [ 'asia/tehran',
                     'europe/tallinn' ],
  'u'           => [ 'u' ],
  'ut'          => [ 'ut' ],
  'utc'         => [ 'utc' ],
  'v'           => [ 'v' ],
  'w'           => [ 'w' ],
  'wast'        => [ 'africa/ndjamena' ],
  'wat'         => [ 'africa/ndjamena',
                     'africa/lagos',
                     'africa/sao_tome',
                     'africa/windhoek' ],
  'wemt'        => [ 'europe/monaco',
                     'europe/lisbon',
                     'europe/paris',
                     'europe/madrid' ],
  'west'        => [ 'wet',
                     'europe/lisbon',
                     'africa/casablanca',
                     'africa/el_aaiun',
                     'atlantic/madeira',
                     'atlantic/canary',
                     'atlantic/faroe',
                     'africa/algiers',
                     'africa/ceuta',
                     'europe/monaco',
                     'europe/paris',
                     'europe/luxembourg',
                     'europe/brussels',
                     'europe/madrid' ],
  'wet'         => [ 'wet',
                     'atlantic/faroe',
                     'europe/lisbon',
                     'africa/casablanca',
                     'atlantic/canary',
                     'atlantic/madeira',
                     'africa/el_aaiun',
                     'atlantic/azores',
                     'africa/ceuta',
                     'africa/algiers',
                     'europe/andorra',
                     'europe/luxembourg',
                     'europe/brussels',
                     'europe/madrid',
                     'europe/monaco',
                     'europe/paris' ],
  'wib'         => [ 'asia/jakarta',
                     'asia/pontianak' ],
  'wit'         => [ 'asia/jayapura' ],
  'wita'        => [ 'asia/makassar',
                     'asia/pontianak' ],
  'wmt'         => [ 'europe/vilnius',
                     'europe/warsaw' ],
  'x'           => [ 'x' ],
  'y'           => [ 'y' ],
  'yddt'        => [ 'america/whitehorse',
                     'america/dawson' ],
  'ydt'         => [ 'america/yakutat',
                     'america/juneau',
                     'america/dawson',
                     'america/whitehorse' ],
  'ypt'         => [ 'america/whitehorse',
                     'america/dawson',
                     'america/yakutat' ],
  'yst'         => [ 'america/yakutat',
                     'america/anchorage',
                     'america/juneau',
                     'america/nome',
                     'america/sitka',
                     'america/dawson',
                     'america/whitehorse' ],
  'ywt'         => [ 'america/whitehorse',
                     'america/dawson',
                     'america/yakutat' ],
  'z'           => [ 'z' ],

);

%Offmod = (
  '+00:00:00'  => 'off000',
  '+00:06:04'  => 'off001',
  '+00:09:21'  => 'off002',
  '+00:12:12'  => 'off003',
  '+00:13:36'  => 'off004',
  '+00:17:30'  => 'off005',
  '+00:19:32'  => 'off006',
  '+00:20:00'  => 'off007',
  '+00:24:36'  => 'off008',
  '+00:26:56'  => 'off009',
  '+00:29:32'  => 'off010',
  '+00:29:46'  => 'off011',
  '+00:34:08'  => 'off012',
  '+00:34:39'  => 'off013',
  '+00:40:44'  => 'off014',
  '+00:43:00'  => 'off015',
  '+00:49:56'  => 'off016',
  '+00:50:20'  => 'off017',
  '+00:52:44'  => 'off018',
  '+00:53:28'  => 'off019',
  '+00:57:44'  => 'off020',
  '+00:58:04'  => 'off021',
  '+01:00:00'  => 'off022',
  '+01:00:12'  => 'off023',
  '+01:00:14'  => 'off024',
  '+01:05:21'  => 'off025',
  '+01:08:24'  => 'off026',
  '+01:12:12'  => 'off027',
  '+01:16:20'  => 'off028',
  '+01:19:20'  => 'off029',
  '+01:19:32'  => 'off030',
  '+01:20:00'  => 'off031',
  '+01:22:00'  => 'off032',
  '+01:24:00'  => 'off033',
  '+01:29:12'  => 'off034',
  '+01:30:00'  => 'off035',
  '+01:33:16'  => 'off036',
  '+01:34:52'  => 'off037',
  '+01:35:36'  => 'off038',
  '+01:36:34'  => 'off039',
  '+01:39:00'  => 'off040',
  '+01:39:49'  => 'off041',
  '+01:41:16'  => 'off042',
  '+01:44:24'  => 'off043',
  '+01:50:00'  => 'off044',
  '+01:50:16'  => 'off045',
  '+01:52:00'  => 'off046',
  '+01:55:00'  => 'off047',
  '+01:55:20'  => 'off048',
  '+01:55:52'  => 'off049',
  '+01:56:56'  => 'off050',
  '+02:00:00'  => 'off051',
  '+02:02:04'  => 'off052',
  '+02:05:09'  => 'off053',
  '+02:06:28'  => 'off054',
  '+02:10:08'  => 'off055',
  '+02:10:20'  => 'off056',
  '+02:13:28'  => 'off057',
  '+02:15:48'  => 'off058',
  '+02:16:00'  => 'off059',
  '+02:16:24'  => 'off060',
  '+02:17:52'  => 'off061',
  '+02:20:00'  => 'off062',
  '+02:20:23'  => 'off063',
  '+02:20:40'  => 'off064',
  '+02:20:54'  => 'off065',
  '+02:22:00'  => 'off066',
  '+02:23:44'  => 'off067',
  '+02:25:12'  => 'off068',
  '+02:27:16'  => 'off069',
  '+02:30:00'  => 'off070',
  '+02:30:17'  => 'off071',
  '+02:31:19'  => 'off072',
  '+02:36:34'  => 'off073',
  '+02:45:00'  => 'off074',
  '+02:57:36'  => 'off075',
  '+02:57:40'  => 'off076',
  '+02:58:00'  => 'off077',
  '+02:59:11'  => 'off078',
  '+03:00:00'  => 'off079',
  '+03:04:18'  => 'off080',
  '+03:06:52'  => 'off081',
  '+03:12:12'  => 'off082',
  '+03:13:36'  => 'off083',
  '+03:18:48'  => 'off084',
  '+03:19:24'  => 'off085',
  '+03:20:20'  => 'off086',
  '+03:21:04'  => 'off087',
  '+03:25:24'  => 'off088',
  '+03:25:44'  => 'off089',
  '+03:26:08'  => 'off090',
  '+03:27:44'  => 'off091',
  '+03:30:00'  => 'off092',
  '+03:31:19'  => 'off093',
  '+03:41:12'  => 'off094',
  '+03:41:48'  => 'off095',
  '+03:41:52'  => 'off096',
  '+03:45:05'  => 'off097',
  '+03:48:40'  => 'off098',
  '+03:50:00'  => 'off099',
  '+03:53:32'  => 'off100',
  '+04:00:00'  => 'off101',
  '+04:02:33'  => 'off102',
  '+04:21:52'  => 'off103',
  '+04:27:53'  => 'off104',
  '+04:28:12'  => 'off105',
  '+04:30:00'  => 'off106',
  '+04:31:19'  => 'off107',
  '+04:35:12'  => 'off108',
  '+04:36:48'  => 'off109',
  '+04:37:11'  => 'off110',
  '+04:49:40'  => 'off111',
  '+04:53:30'  => 'off112',
  '+04:54:00'  => 'off113',
  '+04:58:24'  => 'off114',
  '+05:00:00'  => 'off115',
  '+05:07:48'  => 'off116',
  '+05:19:24'  => 'off117',
  '+05:19:32'  => 'off118',
  '+05:21:10'  => 'off119',
  '+05:30:00'  => 'off120',
  '+05:31:40'  => 'off121',
  '+05:35:00'  => 'off122',
  '+05:39:51'  => 'off123',
  '+05:41:16'  => 'off124',
  '+05:45:00'  => 'off125',
  '+05:48:48'  => 'off126',
  '+05:50:20'  => 'off127',
  '+05:53:20'  => 'off128',
  '+05:53:28'  => 'off129',
  '+05:58:36'  => 'off130',
  '+06:00:00'  => 'off131',
  '+06:01:40'  => 'off132',
  '+06:06:36'  => 'off133',
  '+06:11:26'  => 'off134',
  '+06:24:47'  => 'off135',
  '+06:27:40'  => 'off136',
  '+06:30:00'  => 'off137',
  '+06:42:04'  => 'off138',
  '+06:46:46'  => 'off139',
  '+06:55:25'  => 'off140',
  '+06:57:05'  => 'off141',
  '+07:00:00'  => 'off142',
  '+07:02:52'  => 'off143',
  '+07:06:30'  => 'off144',
  '+07:06:40'  => 'off145',
  '+07:07:12'  => 'off146',
  '+07:07:32'  => 'off147',
  '+07:17:20'  => 'off148',
  '+07:20:00'  => 'off149',
  '+07:21:20'  => 'off150',
  '+07:30:00'  => 'off151',
  '+07:33:52'  => 'off152',
  '+07:34:20'  => 'off153',
  '+07:36:42'  => 'off154',
  '+07:38:00'  => 'off155',
  '+07:39:40'  => 'off156',
  '+07:43:24'  => 'off157',
  '+07:57:36'  => 'off158',
  '+08:00:00'  => 'off159',
  '+08:04:00'  => 'off160',
  '+08:05:43'  => 'off161',
  '+08:06:00'  => 'off162',
  '+08:20:00'  => 'off163',
  '+08:22:20'  => 'off164',
  '+08:23:00'  => 'off165',
  '+08:27:52'  => 'off166',
  '+08:30:00'  => 'off167',
  '+08:35:28'  => 'off168',
  '+08:38:58'  => 'off169',
  '+08:43:20'  => 'off170',
  '+08:45:00'  => 'off171',
  '+08:47:31'  => 'off172',
  '+08:57:56'  => 'off173',
  '+09:00:00'  => 'off174',
  '+09:02:13'  => 'off175',
  '+09:14:20'  => 'off176',
  '+09:18:59'  => 'off177',
  '+09:22:48'  => 'off178',
  '+09:25:48'  => 'off179',
  '+09:30:00'  => 'off180',
  '+09:30:48'  => 'off181',
  '+09:32:54'  => 'off182',
  '+09:35:28'  => 'off183',
  '+09:39:00'  => 'off184',
  '+09:39:52'  => 'off185',
  '+09:45:00'  => 'off186',
  '+09:48:32'  => 'off187',
  '+09:48:40'  => 'off188',
  '+09:49:16'  => 'off189',
  '+09:55:56'  => 'off190',
  '+10:00:00'  => 'off191',
  '+10:03:12'  => 'off192',
  '+10:04:52'  => 'off193',
  '+10:07:08'  => 'off194',
  '+10:12:08'  => 'off195',
  '+10:14:52'  => 'off196',
  '+10:22:16'  => 'off197',
  '+10:30:00'  => 'off198',
  '+10:32:52'  => 'off199',
  '+10:34:36'  => 'off200',
  '+10:36:20'  => 'off201',
  '+10:39:48'  => 'off202',
  '+10:51:56'  => 'off203',
  '+11:00:00'  => 'off204',
  '+11:05:48'  => 'off205',
  '+11:06:28'  => 'off206',
  '+11:07:40'  => 'off207',
  '+11:09:20'  => 'off208',
  '+11:11:52'  => 'off209',
  '+11:12:00'  => 'off210',
  '+11:13:16'  => 'off211',
  '+11:24:48'  => 'off212',
  '+11:30:00'  => 'off213',
  '+11:32:04'  => 'off214',
  '+11:39:04'  => 'off215',
  '+11:49:56'  => 'off216',
  '+11:55:44'  => 'off217',
  '+11:56:52'  => 'off218',
  '+12:00:00'  => 'off219',
  '+12:13:22'  => 'off220',
  '+12:13:48'  => 'off221',
  '+12:15:00'  => 'off222',
  '+12:15:20'  => 'off223',
  '+12:19:20'  => 'off224',
  '+12:20:00'  => 'off225',
  '+12:30:00'  => 'off226',
  '+12:33:04'  => 'off227',
  '+12:37:12'  => 'off228',
  '+12:45:00'  => 'off229',
  '+12:58:22'  => 'off230',
  '+13:00:00'  => 'off231',
  '+13:45:00'  => 'off232',
  '+14:00:00'  => 'off233',
  '+14:00:24'  => 'off234',
  '+14:41:05'  => 'off235',
  '+14:58:47'  => 'off236',
  '+15:02:19'  => 'off237',
  '+15:13:42'  => 'off238',
  '-00:00:52'  => 'off239',
  '-00:01:15'  => 'off240',
  '-00:14:44'  => 'off241',
  '-00:16:08'  => 'off242',
  '-00:21:16'  => 'off243',
  '-00:21:24'  => 'off244',
  '-00:25:00'  => 'off245',
  '-00:25:21'  => 'off246',
  '-00:27:04'  => 'off247',
  '-00:30:20'  => 'off248',
  '-00:36:45'  => 'off249',
  '-00:43:08'  => 'off250',
  '-00:44:30'  => 'off251',
  '-00:52:48'  => 'off252',
  '-01:00:00'  => 'off253',
  '-01:01:36'  => 'off254',
  '-01:02:20'  => 'off255',
  '-01:07:36'  => 'off256',
  '-01:14:40'  => 'off257',
  '-01:27:52'  => 'off258',
  '-01:28:00'  => 'off259',
  '-01:30:00'  => 'off260',
  '-01:34:04'  => 'off261',
  '-01:42:40'  => 'off262',
  '-01:54:32'  => 'off263',
  '-02:00:00'  => 'off264',
  '-02:09:40'  => 'off265',
  '-02:19:36'  => 'off266',
  '-02:22:52'  => 'off267',
  '-02:26:08'  => 'off268',
  '-02:30:00'  => 'off269',
  '-02:30:52'  => 'off270',
  '-02:34:00'  => 'off271',
  '-02:34:04'  => 'off272',
  '-03:00:00'  => 'off273',
  '-03:06:28'  => 'off274',
  '-03:12:48'  => 'off275',
  '-03:13:56'  => 'off276',
  '-03:26:56'  => 'off277',
  '-03:29:20'  => 'off278',
  '-03:30:00'  => 'off279',
  '-03:30:52'  => 'off280',
  '-03:32:36'  => 'off281',
  '-03:38:28'  => 'off282',
  '-03:38:48'  => 'off283',
  '-03:40:36'  => 'off284',
  '-03:40:40'  => 'off285',
  '-03:40:52'  => 'off286',
  '-03:44:20'  => 'off287',
  '-03:44:40'  => 'off288',
  '-03:44:51'  => 'off289',
  '-03:45:00'  => 'off290',
  '-03:48:28'  => 'off291',
  '-03:50:40'  => 'off292',
  '-03:51:24'  => 'off293',
  '-03:52:40'  => 'off294',
  '-03:53:48'  => 'off295',
  '-03:58:29'  => 'off296',
  '-03:59:48'  => 'off297',
  '-04:00:00'  => 'off298',
  '-04:00:04'  => 'off299',
  '-04:01:40'  => 'off300',
  '-04:02:40'  => 'off301',
  '-04:04:20'  => 'off302',
  '-04:06:04'  => 'off303',
  '-04:14:24'  => 'off304',
  '-04:15:36'  => 'off305',
  '-04:16:48'  => 'off306',
  '-04:19:08'  => 'off307',
  '-04:19:18'  => 'off308',
  '-04:20:52'  => 'off309',
  '-04:21:12'  => 'off310',
  '-04:21:40'  => 'off311',
  '-04:23:08'  => 'off312',
  '-04:24:25'  => 'off313',
  '-04:25:24'  => 'off314',
  '-04:27:24'  => 'off315',
  '-04:27:40'  => 'off316',
  '-04:27:44'  => 'off317',
  '-04:30:00'  => 'off318',
  '-04:31:12'  => 'off319',
  '-04:32:36'  => 'off320',
  '-04:33:12'  => 'off321',
  '-04:34:04'  => 'off322',
  '-04:35:08'  => 'off323',
  '-04:35:16'  => 'off324',
  '-04:35:47'  => 'off325',
  '-04:36:52'  => 'off326',
  '-04:39:28'  => 'off327',
  '-04:39:36'  => 'off328',
  '-04:40:00'  => 'off329',
  '-04:42:46'  => 'off330',
  '-04:43:40'  => 'off331',
  '-04:44:32'  => 'off332',
  '-04:49:00'  => 'off333',
  '-04:49:20'  => 'off334',
  '-04:56:02'  => 'off335',
  '-04:56:16'  => 'off336',
  '-05:00:00'  => 'off337',
  '-05:07:10'  => 'off338',
  '-05:08:12'  => 'off339',
  '-05:08:36'  => 'off340',
  '-05:09:30'  => 'off341',
  '-05:14:00'  => 'off342',
  '-05:17:32'  => 'off343',
  '-05:18:08'  => 'off344',
  '-05:19:20'  => 'off345',
  '-05:19:36'  => 'off346',
  '-05:29:28'  => 'off347',
  '-05:29:36'  => 'off348',
  '-05:30:00'  => 'off349',
  '-05:32:11'  => 'off350',
  '-05:36:13'  => 'off351',
  '-05:39:24'  => 'off352',
  '-05:40:16'  => 'off353',
  '-05:43:02'  => 'off354',
  '-05:44:38'  => 'off355',
  '-05:45:08'  => 'off356',
  '-05:45:12'  => 'off357',
  '-05:45:23'  => 'off358',
  '-05:46:25'  => 'off359',
  '-05:46:30'  => 'off360',
  '-05:47:03'  => 'off361',
  '-05:47:04'  => 'off362',
  '-05:48:52'  => 'off363',
  '-05:49:07'  => 'off364',
  '-05:50:07'  => 'off365',
  '-05:50:27'  => 'off366',
  '-05:50:36'  => 'off367',
  '-05:52:48'  => 'off368',
  '-05:53:04'  => 'off369',
  '-05:56:48'  => 'off370',
  '-05:57:00'  => 'off371',
  '-05:58:24'  => 'off372',
  '-05:58:28'  => 'off373',
  '-06:00:00'  => 'off374',
  '-06:02:04'  => 'off375',
  '-06:06:28'  => 'off376',
  '-06:18:16'  => 'off377',
  '-06:28:36'  => 'off378',
  '-06:36:36'  => 'off379',
  '-06:40:00'  => 'off380',
  '-06:41:16'  => 'off381',
  '-06:45:12'  => 'off382',
  '-06:45:39'  => 'off383',
  '-06:47:07'  => 'off384',
  '-06:57:40'  => 'off385',
  '-06:58:36'  => 'off386',
  '-06:59:56'  => 'off387',
  '-07:00:00'  => 'off388',
  '-07:01:00'  => 'off389',
  '-07:04:20'  => 'off390',
  '-07:05:40'  => 'off391',
  '-07:11:20'  => 'off392',
  '-07:17:28'  => 'off393',
  '-07:23:52'  => 'off394',
  '-07:28:18'  => 'off395',
  '-07:33:52'  => 'off396',
  '-07:44:49'  => 'off397',
  '-07:46:04'  => 'off398',
  '-07:48:04'  => 'off399',
  '-07:52:58'  => 'off400',
  '-08:00:00'  => 'off401',
  '-08:00:56'  => 'off402',
  '-08:10:47'  => 'off403',
  '-08:12:28'  => 'off404',
  '-08:30:00'  => 'off405',
  '-08:40:20'  => 'off406',
  '-08:46:18'  => 'off407',
  '-08:57:41'  => 'off408',
  '-08:59:48'  => 'off409',
  '-09:00:00'  => 'off410',
  '-09:00:12'  => 'off411',
  '-09:01:13'  => 'off412',
  '-09:17:40'  => 'off413',
  '-09:18:00'  => 'off414',
  '-09:18:55'  => 'off415',
  '-09:30:00'  => 'off416',
  '-09:58:16'  => 'off417',
  '-09:59:36'  => 'off418',
  '-10:00:00'  => 'off419',
  '-10:29:20'  => 'off420',
  '-10:30:00'  => 'off421',
  '-10:31:26'  => 'off422',
  '-10:39:04'  => 'off423',
  '-10:40:00'  => 'off424',
  '-11:00:00'  => 'off425',
  '-11:01:38'  => 'off426',
  '-11:19:40'  => 'off427',
  '-11:20:00'  => 'off428',
  '-11:22:48'  => 'off429',
  '-11:24:20'  => 'off430',
  '-11:24:56'  => 'off431',
  '-11:26:56'  => 'off432',
  '-11:30:00'  => 'off433',
  '-11:46:38'  => 'off434',
  '-12:00:00'  => 'off435',
  '-13:00:00'  => 'off436',
  '-14:00:00'  => 'off437',
  '-14:21:00'  => 'off438',
  '-15:56:00'  => 'off439',

);

1;
