package Date::Manip::TZ::eudubl00;
# Copyright (c) 2008-2009 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:49 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::eudubl00 - Support for the Europe/Dublin time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.00";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,23,35,0],'-00:25:00',[0,-25,0],
          'LMT',0,[1880,8,2,0,24,59],[1880,8,1,23,59,59] ],
     ],
   1880 =>
     [
        [ [1880,8,2,0,25,0],[1880,8,1,23,59,39],'-00:25:21',[0,-25,-21],
          'DMT',0,[1916,5,21,2,25,20],[1916,5,21,1,59,59] ],
     ],
   1916 =>
     [
        [ [1916,5,21,2,25,21],[1916,5,21,3,0,0],'+00:34:39',[0,34,39],
          'IST',1,[1916,10,1,2,25,20],[1916,10,1,2,59,59] ],
        [ [1916,10,1,2,25,21],[1916,10,1,2,25,21],'+00:00:00',[0,0,0],
          'GMT',0,[1917,4,8,1,59,59],[1917,4,8,1,59,59] ],
     ],
   1917 =>
     [
        [ [1917,4,8,2,0,0],[1917,4,8,3,0,0],'+01:00:00',[1,0,0],
          'BST',1,[1917,9,17,1,59,59],[1917,9,17,2,59,59] ],
        [ [1917,9,17,2,0,0],[1917,9,17,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1918,3,24,1,59,59],[1918,3,24,1,59,59] ],
     ],
   1918 =>
     [
        [ [1918,3,24,2,0,0],[1918,3,24,3,0,0],'+01:00:00',[1,0,0],
          'BST',1,[1918,9,30,1,59,59],[1918,9,30,2,59,59] ],
        [ [1918,9,30,2,0,0],[1918,9,30,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1919,3,30,1,59,59],[1919,3,30,1,59,59] ],
     ],
   1919 =>
     [
        [ [1919,3,30,2,0,0],[1919,3,30,3,0,0],'+01:00:00',[1,0,0],
          'BST',1,[1919,9,29,1,59,59],[1919,9,29,2,59,59] ],
        [ [1919,9,29,2,0,0],[1919,9,29,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1920,3,28,1,59,59],[1920,3,28,1,59,59] ],
     ],
   1920 =>
     [
        [ [1920,3,28,2,0,0],[1920,3,28,3,0,0],'+01:00:00',[1,0,0],
          'BST',1,[1920,10,25,1,59,59],[1920,10,25,2,59,59] ],
        [ [1920,10,25,2,0,0],[1920,10,25,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1921,4,3,1,59,59],[1921,4,3,1,59,59] ],
     ],
   1921 =>
     [
        [ [1921,4,3,2,0,0],[1921,4,3,3,0,0],'+01:00:00',[1,0,0],
          'BST',1,[1921,10,3,1,59,59],[1921,10,3,2,59,59] ],
        [ [1921,10,3,2,0,0],[1921,10,3,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1922,3,26,1,59,59],[1922,3,26,1,59,59] ],
     ],
   1922 =>
     [
        [ [1922,3,26,2,0,0],[1922,3,26,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1922,10,8,1,59,59],[1922,10,8,2,59,59] ],
        [ [1922,10,8,2,0,0],[1922,10,8,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1923,4,22,1,59,59],[1923,4,22,1,59,59] ],
     ],
   1923 =>
     [
        [ [1923,4,22,2,0,0],[1923,4,22,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1923,9,16,1,59,59],[1923,9,16,2,59,59] ],
        [ [1923,9,16,2,0,0],[1923,9,16,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1924,4,13,1,59,59],[1924,4,13,1,59,59] ],
     ],
   1924 =>
     [
        [ [1924,4,13,2,0,0],[1924,4,13,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1924,9,21,1,59,59],[1924,9,21,2,59,59] ],
        [ [1924,9,21,2,0,0],[1924,9,21,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1925,4,19,1,59,59],[1925,4,19,1,59,59] ],
     ],
   1925 =>
     [
        [ [1925,4,19,2,0,0],[1925,4,19,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1925,10,4,1,59,59],[1925,10,4,2,59,59] ],
        [ [1925,10,4,2,0,0],[1925,10,4,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1926,4,18,1,59,59],[1926,4,18,1,59,59] ],
     ],
   1926 =>
     [
        [ [1926,4,18,2,0,0],[1926,4,18,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1926,10,3,1,59,59],[1926,10,3,2,59,59] ],
        [ [1926,10,3,2,0,0],[1926,10,3,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1927,4,10,1,59,59],[1927,4,10,1,59,59] ],
     ],
   1927 =>
     [
        [ [1927,4,10,2,0,0],[1927,4,10,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1927,10,2,1,59,59],[1927,10,2,2,59,59] ],
        [ [1927,10,2,2,0,0],[1927,10,2,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1928,4,22,1,59,59],[1928,4,22,1,59,59] ],
     ],
   1928 =>
     [
        [ [1928,4,22,2,0,0],[1928,4,22,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1928,10,7,1,59,59],[1928,10,7,2,59,59] ],
        [ [1928,10,7,2,0,0],[1928,10,7,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1929,4,21,1,59,59],[1929,4,21,1,59,59] ],
     ],
   1929 =>
     [
        [ [1929,4,21,2,0,0],[1929,4,21,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1929,10,6,1,59,59],[1929,10,6,2,59,59] ],
        [ [1929,10,6,2,0,0],[1929,10,6,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1930,4,13,1,59,59],[1930,4,13,1,59,59] ],
     ],
   1930 =>
     [
        [ [1930,4,13,2,0,0],[1930,4,13,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1930,10,5,1,59,59],[1930,10,5,2,59,59] ],
        [ [1930,10,5,2,0,0],[1930,10,5,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1931,4,19,1,59,59],[1931,4,19,1,59,59] ],
     ],
   1931 =>
     [
        [ [1931,4,19,2,0,0],[1931,4,19,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1931,10,4,1,59,59],[1931,10,4,2,59,59] ],
        [ [1931,10,4,2,0,0],[1931,10,4,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1932,4,17,1,59,59],[1932,4,17,1,59,59] ],
     ],
   1932 =>
     [
        [ [1932,4,17,2,0,0],[1932,4,17,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1932,10,2,1,59,59],[1932,10,2,2,59,59] ],
        [ [1932,10,2,2,0,0],[1932,10,2,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1933,4,9,1,59,59],[1933,4,9,1,59,59] ],
     ],
   1933 =>
     [
        [ [1933,4,9,2,0,0],[1933,4,9,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1933,10,8,1,59,59],[1933,10,8,2,59,59] ],
        [ [1933,10,8,2,0,0],[1933,10,8,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1934,4,22,1,59,59],[1934,4,22,1,59,59] ],
     ],
   1934 =>
     [
        [ [1934,4,22,2,0,0],[1934,4,22,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1934,10,7,1,59,59],[1934,10,7,2,59,59] ],
        [ [1934,10,7,2,0,0],[1934,10,7,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1935,4,14,1,59,59],[1935,4,14,1,59,59] ],
     ],
   1935 =>
     [
        [ [1935,4,14,2,0,0],[1935,4,14,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1935,10,6,1,59,59],[1935,10,6,2,59,59] ],
        [ [1935,10,6,2,0,0],[1935,10,6,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1936,4,19,1,59,59],[1936,4,19,1,59,59] ],
     ],
   1936 =>
     [
        [ [1936,4,19,2,0,0],[1936,4,19,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1936,10,4,1,59,59],[1936,10,4,2,59,59] ],
        [ [1936,10,4,2,0,0],[1936,10,4,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1937,4,18,1,59,59],[1937,4,18,1,59,59] ],
     ],
   1937 =>
     [
        [ [1937,4,18,2,0,0],[1937,4,18,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1937,10,3,1,59,59],[1937,10,3,2,59,59] ],
        [ [1937,10,3,2,0,0],[1937,10,3,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1938,4,10,1,59,59],[1938,4,10,1,59,59] ],
     ],
   1938 =>
     [
        [ [1938,4,10,2,0,0],[1938,4,10,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1938,10,2,1,59,59],[1938,10,2,2,59,59] ],
        [ [1938,10,2,2,0,0],[1938,10,2,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1939,4,16,1,59,59],[1939,4,16,1,59,59] ],
     ],
   1939 =>
     [
        [ [1939,4,16,2,0,0],[1939,4,16,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1939,11,19,1,59,59],[1939,11,19,2,59,59] ],
        [ [1939,11,19,2,0,0],[1939,11,19,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1940,2,25,1,59,59],[1940,2,25,1,59,59] ],
     ],
   1940 =>
     [
        [ [1940,2,25,2,0,0],[1940,2,25,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1946,10,6,0,59,59],[1946,10,6,1,59,59] ],
     ],
   1946 =>
     [
        [ [1946,10,6,1,0,0],[1946,10,6,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1947,3,16,1,59,59],[1947,3,16,1,59,59] ],
     ],
   1947 =>
     [
        [ [1947,3,16,2,0,0],[1947,3,16,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1947,11,2,0,59,59],[1947,11,2,1,59,59] ],
        [ [1947,11,2,1,0,0],[1947,11,2,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1948,4,18,1,59,59],[1948,4,18,1,59,59] ],
     ],
   1948 =>
     [
        [ [1948,4,18,2,0,0],[1948,4,18,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1948,10,31,1,59,59],[1948,10,31,2,59,59] ],
        [ [1948,10,31,2,0,0],[1948,10,31,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1949,4,3,1,59,59],[1949,4,3,1,59,59] ],
     ],
   1949 =>
     [
        [ [1949,4,3,2,0,0],[1949,4,3,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1949,10,30,1,59,59],[1949,10,30,2,59,59] ],
        [ [1949,10,30,2,0,0],[1949,10,30,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1950,4,16,1,59,59],[1950,4,16,1,59,59] ],
     ],
   1950 =>
     [
        [ [1950,4,16,2,0,0],[1950,4,16,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1950,10,22,1,59,59],[1950,10,22,2,59,59] ],
        [ [1950,10,22,2,0,0],[1950,10,22,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1951,4,15,1,59,59],[1951,4,15,1,59,59] ],
     ],
   1951 =>
     [
        [ [1951,4,15,2,0,0],[1951,4,15,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1951,10,21,1,59,59],[1951,10,21,2,59,59] ],
        [ [1951,10,21,2,0,0],[1951,10,21,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1952,4,20,1,59,59],[1952,4,20,1,59,59] ],
     ],
   1952 =>
     [
        [ [1952,4,20,2,0,0],[1952,4,20,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1952,10,26,1,59,59],[1952,10,26,2,59,59] ],
        [ [1952,10,26,2,0,0],[1952,10,26,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1953,4,19,1,59,59],[1953,4,19,1,59,59] ],
     ],
   1953 =>
     [
        [ [1953,4,19,2,0,0],[1953,4,19,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1953,10,4,1,59,59],[1953,10,4,2,59,59] ],
        [ [1953,10,4,2,0,0],[1953,10,4,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1954,4,11,1,59,59],[1954,4,11,1,59,59] ],
     ],
   1954 =>
     [
        [ [1954,4,11,2,0,0],[1954,4,11,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1954,10,3,1,59,59],[1954,10,3,2,59,59] ],
        [ [1954,10,3,2,0,0],[1954,10,3,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1955,4,17,1,59,59],[1955,4,17,1,59,59] ],
     ],
   1955 =>
     [
        [ [1955,4,17,2,0,0],[1955,4,17,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1955,10,2,1,59,59],[1955,10,2,2,59,59] ],
        [ [1955,10,2,2,0,0],[1955,10,2,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1956,4,22,1,59,59],[1956,4,22,1,59,59] ],
     ],
   1956 =>
     [
        [ [1956,4,22,2,0,0],[1956,4,22,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1956,10,7,1,59,59],[1956,10,7,2,59,59] ],
        [ [1956,10,7,2,0,0],[1956,10,7,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1957,4,14,1,59,59],[1957,4,14,1,59,59] ],
     ],
   1957 =>
     [
        [ [1957,4,14,2,0,0],[1957,4,14,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1957,10,6,1,59,59],[1957,10,6,2,59,59] ],
        [ [1957,10,6,2,0,0],[1957,10,6,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1958,4,20,1,59,59],[1958,4,20,1,59,59] ],
     ],
   1958 =>
     [
        [ [1958,4,20,2,0,0],[1958,4,20,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1958,10,5,1,59,59],[1958,10,5,2,59,59] ],
        [ [1958,10,5,2,0,0],[1958,10,5,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1959,4,19,1,59,59],[1959,4,19,1,59,59] ],
     ],
   1959 =>
     [
        [ [1959,4,19,2,0,0],[1959,4,19,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1959,10,4,1,59,59],[1959,10,4,2,59,59] ],
        [ [1959,10,4,2,0,0],[1959,10,4,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1960,4,10,1,59,59],[1960,4,10,1,59,59] ],
     ],
   1960 =>
     [
        [ [1960,4,10,2,0,0],[1960,4,10,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1960,10,2,1,59,59],[1960,10,2,2,59,59] ],
        [ [1960,10,2,2,0,0],[1960,10,2,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1961,3,26,1,59,59],[1961,3,26,1,59,59] ],
     ],
   1961 =>
     [
        [ [1961,3,26,2,0,0],[1961,3,26,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1961,10,29,1,59,59],[1961,10,29,2,59,59] ],
        [ [1961,10,29,2,0,0],[1961,10,29,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1962,3,25,1,59,59],[1962,3,25,1,59,59] ],
     ],
   1962 =>
     [
        [ [1962,3,25,2,0,0],[1962,3,25,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1962,10,28,1,59,59],[1962,10,28,2,59,59] ],
        [ [1962,10,28,2,0,0],[1962,10,28,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1963,3,31,1,59,59],[1963,3,31,1,59,59] ],
     ],
   1963 =>
     [
        [ [1963,3,31,2,0,0],[1963,3,31,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1963,10,27,1,59,59],[1963,10,27,2,59,59] ],
        [ [1963,10,27,2,0,0],[1963,10,27,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1964,3,22,1,59,59],[1964,3,22,1,59,59] ],
     ],
   1964 =>
     [
        [ [1964,3,22,2,0,0],[1964,3,22,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1964,10,25,1,59,59],[1964,10,25,2,59,59] ],
        [ [1964,10,25,2,0,0],[1964,10,25,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1965,3,21,1,59,59],[1965,3,21,1,59,59] ],
     ],
   1965 =>
     [
        [ [1965,3,21,2,0,0],[1965,3,21,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1965,10,24,1,59,59],[1965,10,24,2,59,59] ],
        [ [1965,10,24,2,0,0],[1965,10,24,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1966,3,20,1,59,59],[1966,3,20,1,59,59] ],
     ],
   1966 =>
     [
        [ [1966,3,20,2,0,0],[1966,3,20,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1966,10,23,1,59,59],[1966,10,23,2,59,59] ],
        [ [1966,10,23,2,0,0],[1966,10,23,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1967,3,19,1,59,59],[1967,3,19,1,59,59] ],
     ],
   1967 =>
     [
        [ [1967,3,19,2,0,0],[1967,3,19,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1967,10,29,1,59,59],[1967,10,29,2,59,59] ],
        [ [1967,10,29,2,0,0],[1967,10,29,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1968,2,18,1,59,59],[1968,2,18,1,59,59] ],
     ],
   1968 =>
     [
        [ [1968,2,18,2,0,0],[1968,2,18,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1968,10,26,22,59,59],[1968,10,26,23,59,59] ],
        [ [1968,10,26,23,0,0],[1968,10,27,0,0,0],'+01:00:00',[1,0,0],
          'IST',0,[1971,10,31,1,59,59],[1971,10,31,2,59,59] ],
     ],
   1971 =>
     [
        [ [1971,10,31,2,0,0],[1971,10,31,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1972,3,19,1,59,59],[1972,3,19,1,59,59] ],
     ],
   1972 =>
     [
        [ [1972,3,19,2,0,0],[1972,3,19,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1972,10,29,1,59,59],[1972,10,29,2,59,59] ],
        [ [1972,10,29,2,0,0],[1972,10,29,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1973,3,18,1,59,59],[1973,3,18,1,59,59] ],
     ],
   1973 =>
     [
        [ [1973,3,18,2,0,0],[1973,3,18,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1973,10,28,1,59,59],[1973,10,28,2,59,59] ],
        [ [1973,10,28,2,0,0],[1973,10,28,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1974,3,17,1,59,59],[1974,3,17,1,59,59] ],
     ],
   1974 =>
     [
        [ [1974,3,17,2,0,0],[1974,3,17,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1974,10,27,1,59,59],[1974,10,27,2,59,59] ],
        [ [1974,10,27,2,0,0],[1974,10,27,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1975,3,16,1,59,59],[1975,3,16,1,59,59] ],
     ],
   1975 =>
     [
        [ [1975,3,16,2,0,0],[1975,3,16,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1975,10,26,1,59,59],[1975,10,26,2,59,59] ],
        [ [1975,10,26,2,0,0],[1975,10,26,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1976,3,21,1,59,59],[1976,3,21,1,59,59] ],
     ],
   1976 =>
     [
        [ [1976,3,21,2,0,0],[1976,3,21,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1976,10,24,1,59,59],[1976,10,24,2,59,59] ],
        [ [1976,10,24,2,0,0],[1976,10,24,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1977,3,20,1,59,59],[1977,3,20,1,59,59] ],
     ],
   1977 =>
     [
        [ [1977,3,20,2,0,0],[1977,3,20,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1977,10,23,1,59,59],[1977,10,23,2,59,59] ],
        [ [1977,10,23,2,0,0],[1977,10,23,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1978,3,19,1,59,59],[1978,3,19,1,59,59] ],
     ],
   1978 =>
     [
        [ [1978,3,19,2,0,0],[1978,3,19,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1978,10,29,1,59,59],[1978,10,29,2,59,59] ],
        [ [1978,10,29,2,0,0],[1978,10,29,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1979,3,18,1,59,59],[1979,3,18,1,59,59] ],
     ],
   1979 =>
     [
        [ [1979,3,18,2,0,0],[1979,3,18,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1979,10,28,1,59,59],[1979,10,28,2,59,59] ],
        [ [1979,10,28,2,0,0],[1979,10,28,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1980,3,16,1,59,59],[1980,3,16,1,59,59] ],
     ],
   1980 =>
     [
        [ [1980,3,16,2,0,0],[1980,3,16,3,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1980,10,26,1,59,59],[1980,10,26,2,59,59] ],
        [ [1980,10,26,2,0,0],[1980,10,26,2,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1981,3,29,0,59,59],[1981,3,29,0,59,59] ],
     ],
   1981 =>
     [
        [ [1981,3,29,1,0,0],[1981,3,29,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1981,10,25,0,59,59],[1981,10,25,1,59,59] ],
        [ [1981,10,25,1,0,0],[1981,10,25,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1982,3,28,0,59,59],[1982,3,28,0,59,59] ],
     ],
   1982 =>
     [
        [ [1982,3,28,1,0,0],[1982,3,28,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1982,10,24,0,59,59],[1982,10,24,1,59,59] ],
        [ [1982,10,24,1,0,0],[1982,10,24,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1983,3,27,0,59,59],[1983,3,27,0,59,59] ],
     ],
   1983 =>
     [
        [ [1983,3,27,1,0,0],[1983,3,27,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1983,10,23,0,59,59],[1983,10,23,1,59,59] ],
        [ [1983,10,23,1,0,0],[1983,10,23,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1984,3,25,0,59,59],[1984,3,25,0,59,59] ],
     ],
   1984 =>
     [
        [ [1984,3,25,1,0,0],[1984,3,25,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1984,10,28,0,59,59],[1984,10,28,1,59,59] ],
        [ [1984,10,28,1,0,0],[1984,10,28,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1985,3,31,0,59,59],[1985,3,31,0,59,59] ],
     ],
   1985 =>
     [
        [ [1985,3,31,1,0,0],[1985,3,31,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1985,10,27,0,59,59],[1985,10,27,1,59,59] ],
        [ [1985,10,27,1,0,0],[1985,10,27,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1986,3,30,0,59,59],[1986,3,30,0,59,59] ],
     ],
   1986 =>
     [
        [ [1986,3,30,1,0,0],[1986,3,30,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1986,10,26,0,59,59],[1986,10,26,1,59,59] ],
        [ [1986,10,26,1,0,0],[1986,10,26,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1987,3,29,0,59,59],[1987,3,29,0,59,59] ],
     ],
   1987 =>
     [
        [ [1987,3,29,1,0,0],[1987,3,29,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1987,10,25,0,59,59],[1987,10,25,1,59,59] ],
        [ [1987,10,25,1,0,0],[1987,10,25,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1988,3,27,0,59,59],[1988,3,27,0,59,59] ],
     ],
   1988 =>
     [
        [ [1988,3,27,1,0,0],[1988,3,27,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1988,10,23,0,59,59],[1988,10,23,1,59,59] ],
        [ [1988,10,23,1,0,0],[1988,10,23,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1989,3,26,0,59,59],[1989,3,26,0,59,59] ],
     ],
   1989 =>
     [
        [ [1989,3,26,1,0,0],[1989,3,26,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1989,10,29,0,59,59],[1989,10,29,1,59,59] ],
        [ [1989,10,29,1,0,0],[1989,10,29,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1990,3,25,0,59,59],[1990,3,25,0,59,59] ],
     ],
   1990 =>
     [
        [ [1990,3,25,1,0,0],[1990,3,25,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1990,10,28,0,59,59],[1990,10,28,1,59,59] ],
        [ [1990,10,28,1,0,0],[1990,10,28,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1991,3,31,0,59,59],[1991,3,31,0,59,59] ],
     ],
   1991 =>
     [
        [ [1991,3,31,1,0,0],[1991,3,31,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1991,10,27,0,59,59],[1991,10,27,1,59,59] ],
        [ [1991,10,27,1,0,0],[1991,10,27,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1992,3,29,0,59,59],[1992,3,29,0,59,59] ],
     ],
   1992 =>
     [
        [ [1992,3,29,1,0,0],[1992,3,29,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1992,10,25,0,59,59],[1992,10,25,1,59,59] ],
        [ [1992,10,25,1,0,0],[1992,10,25,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1993,3,28,0,59,59],[1993,3,28,0,59,59] ],
     ],
   1993 =>
     [
        [ [1993,3,28,1,0,0],[1993,3,28,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1993,10,24,0,59,59],[1993,10,24,1,59,59] ],
        [ [1993,10,24,1,0,0],[1993,10,24,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1994,3,27,0,59,59],[1994,3,27,0,59,59] ],
     ],
   1994 =>
     [
        [ [1994,3,27,1,0,0],[1994,3,27,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1994,10,23,0,59,59],[1994,10,23,1,59,59] ],
        [ [1994,10,23,1,0,0],[1994,10,23,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1995,3,26,0,59,59],[1995,3,26,0,59,59] ],
     ],
   1995 =>
     [
        [ [1995,3,26,1,0,0],[1995,3,26,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1995,10,22,0,59,59],[1995,10,22,1,59,59] ],
        [ [1995,10,22,1,0,0],[1995,10,22,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1996,3,31,0,59,59],[1996,3,31,0,59,59] ],
     ],
   1996 =>
     [
        [ [1996,3,31,1,0,0],[1996,3,31,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1996,10,27,0,59,59],[1996,10,27,1,59,59] ],
        [ [1996,10,27,1,0,0],[1996,10,27,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1997,3,30,0,59,59],[1997,3,30,0,59,59] ],
     ],
   1997 =>
     [
        [ [1997,3,30,1,0,0],[1997,3,30,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1997,10,26,0,59,59],[1997,10,26,1,59,59] ],
        [ [1997,10,26,1,0,0],[1997,10,26,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1998,3,29,0,59,59],[1998,3,29,0,59,59] ],
     ],
   1998 =>
     [
        [ [1998,3,29,1,0,0],[1998,3,29,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1998,10,25,0,59,59],[1998,10,25,1,59,59] ],
        [ [1998,10,25,1,0,0],[1998,10,25,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[1999,3,28,0,59,59],[1999,3,28,0,59,59] ],
     ],
   1999 =>
     [
        [ [1999,3,28,1,0,0],[1999,3,28,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[1999,10,31,0,59,59],[1999,10,31,1,59,59] ],
        [ [1999,10,31,1,0,0],[1999,10,31,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2000,3,26,0,59,59],[2000,3,26,0,59,59] ],
     ],
   2000 =>
     [
        [ [2000,3,26,1,0,0],[2000,3,26,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2000,10,29,0,59,59],[2000,10,29,1,59,59] ],
        [ [2000,10,29,1,0,0],[2000,10,29,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2001,3,25,0,59,59],[2001,3,25,0,59,59] ],
     ],
   2001 =>
     [
        [ [2001,3,25,1,0,0],[2001,3,25,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2001,10,28,0,59,59],[2001,10,28,1,59,59] ],
        [ [2001,10,28,1,0,0],[2001,10,28,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2002,3,31,0,59,59],[2002,3,31,0,59,59] ],
     ],
   2002 =>
     [
        [ [2002,3,31,1,0,0],[2002,3,31,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2002,10,27,0,59,59],[2002,10,27,1,59,59] ],
        [ [2002,10,27,1,0,0],[2002,10,27,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2003,3,30,0,59,59],[2003,3,30,0,59,59] ],
     ],
   2003 =>
     [
        [ [2003,3,30,1,0,0],[2003,3,30,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2003,10,26,0,59,59],[2003,10,26,1,59,59] ],
        [ [2003,10,26,1,0,0],[2003,10,26,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2004,3,28,0,59,59],[2004,3,28,0,59,59] ],
     ],
   2004 =>
     [
        [ [2004,3,28,1,0,0],[2004,3,28,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2004,10,31,0,59,59],[2004,10,31,1,59,59] ],
        [ [2004,10,31,1,0,0],[2004,10,31,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2005,3,27,0,59,59],[2005,3,27,0,59,59] ],
     ],
   2005 =>
     [
        [ [2005,3,27,1,0,0],[2005,3,27,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2005,10,30,0,59,59],[2005,10,30,1,59,59] ],
        [ [2005,10,30,1,0,0],[2005,10,30,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2006,3,26,0,59,59],[2006,3,26,0,59,59] ],
     ],
   2006 =>
     [
        [ [2006,3,26,1,0,0],[2006,3,26,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2006,10,29,0,59,59],[2006,10,29,1,59,59] ],
        [ [2006,10,29,1,0,0],[2006,10,29,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2007,3,25,0,59,59],[2007,3,25,0,59,59] ],
     ],
   2007 =>
     [
        [ [2007,3,25,1,0,0],[2007,3,25,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2007,10,28,0,59,59],[2007,10,28,1,59,59] ],
        [ [2007,10,28,1,0,0],[2007,10,28,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2008,3,30,0,59,59],[2008,3,30,0,59,59] ],
     ],
   2008 =>
     [
        [ [2008,3,30,1,0,0],[2008,3,30,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2008,10,26,0,59,59],[2008,10,26,1,59,59] ],
        [ [2008,10,26,1,0,0],[2008,10,26,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2009,3,29,0,59,59],[2009,3,29,0,59,59] ],
     ],
   2009 =>
     [
        [ [2009,3,29,1,0,0],[2009,3,29,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2009,10,25,0,59,59],[2009,10,25,1,59,59] ],
        [ [2009,10,25,1,0,0],[2009,10,25,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2010,3,28,0,59,59],[2010,3,28,0,59,59] ],
     ],
   2010 =>
     [
        [ [2010,3,28,1,0,0],[2010,3,28,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2010,10,31,0,59,59],[2010,10,31,1,59,59] ],
        [ [2010,10,31,1,0,0],[2010,10,31,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2011,3,27,0,59,59],[2011,3,27,0,59,59] ],
     ],
   2011 =>
     [
        [ [2011,3,27,1,0,0],[2011,3,27,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2011,10,30,0,59,59],[2011,10,30,1,59,59] ],
        [ [2011,10,30,1,0,0],[2011,10,30,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2012,3,25,0,59,59],[2012,3,25,0,59,59] ],
     ],
   2012 =>
     [
        [ [2012,3,25,1,0,0],[2012,3,25,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2012,10,28,0,59,59],[2012,10,28,1,59,59] ],
        [ [2012,10,28,1,0,0],[2012,10,28,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2013,3,31,0,59,59],[2013,3,31,0,59,59] ],
     ],
   2013 =>
     [
        [ [2013,3,31,1,0,0],[2013,3,31,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2013,10,27,0,59,59],[2013,10,27,1,59,59] ],
        [ [2013,10,27,1,0,0],[2013,10,27,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2014,3,30,0,59,59],[2014,3,30,0,59,59] ],
     ],
   2014 =>
     [
        [ [2014,3,30,1,0,0],[2014,3,30,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2014,10,26,0,59,59],[2014,10,26,1,59,59] ],
        [ [2014,10,26,1,0,0],[2014,10,26,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2015,3,29,0,59,59],[2015,3,29,0,59,59] ],
     ],
   2015 =>
     [
        [ [2015,3,29,1,0,0],[2015,3,29,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2015,10,25,0,59,59],[2015,10,25,1,59,59] ],
        [ [2015,10,25,1,0,0],[2015,10,25,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2016,3,27,0,59,59],[2016,3,27,0,59,59] ],
     ],
   2016 =>
     [
        [ [2016,3,27,1,0,0],[2016,3,27,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2016,10,30,0,59,59],[2016,10,30,1,59,59] ],
        [ [2016,10,30,1,0,0],[2016,10,30,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2017,3,26,0,59,59],[2017,3,26,0,59,59] ],
     ],
   2017 =>
     [
        [ [2017,3,26,1,0,0],[2017,3,26,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2017,10,29,0,59,59],[2017,10,29,1,59,59] ],
        [ [2017,10,29,1,0,0],[2017,10,29,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2018,3,25,0,59,59],[2018,3,25,0,59,59] ],
     ],
   2018 =>
     [
        [ [2018,3,25,1,0,0],[2018,3,25,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2018,10,28,0,59,59],[2018,10,28,1,59,59] ],
        [ [2018,10,28,1,0,0],[2018,10,28,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2019,3,31,0,59,59],[2019,3,31,0,59,59] ],
     ],
   2019 =>
     [
        [ [2019,3,31,1,0,0],[2019,3,31,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2019,10,27,0,59,59],[2019,10,27,1,59,59] ],
        [ [2019,10,27,1,0,0],[2019,10,27,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2020,3,29,0,59,59],[2020,3,29,0,59,59] ],
     ],
   2020 =>
     [
        [ [2020,3,29,1,0,0],[2020,3,29,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2020,10,25,0,59,59],[2020,10,25,1,59,59] ],
        [ [2020,10,25,1,0,0],[2020,10,25,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2021,3,28,0,59,59],[2021,3,28,0,59,59] ],
     ],
   2021 =>
     [
        [ [2021,3,28,1,0,0],[2021,3,28,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2021,10,31,0,59,59],[2021,10,31,1,59,59] ],
        [ [2021,10,31,1,0,0],[2021,10,31,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2022,3,27,0,59,59],[2022,3,27,0,59,59] ],
     ],
   2022 =>
     [
        [ [2022,3,27,1,0,0],[2022,3,27,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2022,10,30,0,59,59],[2022,10,30,1,59,59] ],
        [ [2022,10,30,1,0,0],[2022,10,30,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2023,3,26,0,59,59],[2023,3,26,0,59,59] ],
     ],
   2023 =>
     [
        [ [2023,3,26,1,0,0],[2023,3,26,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2023,10,29,0,59,59],[2023,10,29,1,59,59] ],
        [ [2023,10,29,1,0,0],[2023,10,29,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2024,3,31,0,59,59],[2024,3,31,0,59,59] ],
     ],
   2024 =>
     [
        [ [2024,3,31,1,0,0],[2024,3,31,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2024,10,27,0,59,59],[2024,10,27,1,59,59] ],
        [ [2024,10,27,1,0,0],[2024,10,27,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2025,3,30,0,59,59],[2025,3,30,0,59,59] ],
     ],
   2025 =>
     [
        [ [2025,3,30,1,0,0],[2025,3,30,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2025,10,26,0,59,59],[2025,10,26,1,59,59] ],
        [ [2025,10,26,1,0,0],[2025,10,26,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2026,3,29,0,59,59],[2026,3,29,0,59,59] ],
     ],
   2026 =>
     [
        [ [2026,3,29,1,0,0],[2026,3,29,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2026,10,25,0,59,59],[2026,10,25,1,59,59] ],
        [ [2026,10,25,1,0,0],[2026,10,25,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2027,3,28,0,59,59],[2027,3,28,0,59,59] ],
     ],
   2027 =>
     [
        [ [2027,3,28,1,0,0],[2027,3,28,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2027,10,31,0,59,59],[2027,10,31,1,59,59] ],
        [ [2027,10,31,1,0,0],[2027,10,31,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2028,3,26,0,59,59],[2028,3,26,0,59,59] ],
     ],
   2028 =>
     [
        [ [2028,3,26,1,0,0],[2028,3,26,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2028,10,29,0,59,59],[2028,10,29,1,59,59] ],
        [ [2028,10,29,1,0,0],[2028,10,29,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2029,3,25,0,59,59],[2029,3,25,0,59,59] ],
     ],
   2029 =>
     [
        [ [2029,3,25,1,0,0],[2029,3,25,2,0,0],'+01:00:00',[1,0,0],
          'IST',1,[2029,10,28,0,59,59],[2029,10,28,1,59,59] ],
        [ [2029,10,28,1,0,0],[2029,10,28,1,0,0],'+00:00:00',[0,0,0],
          'GMT',0,[2030,3,31,0,59,59],[2030,3,31,0,59,59] ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+01:00:00',
                'stdoff' => '+00:00:00',

               },
   'rules'  => {
                '03' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'u',
                         'time'    => '01:00:00',
                         'isdst'   => '1',
                         'abb'     => 'IST',
                        },
                '10' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'u',
                         'time'    => '01:00:00',
                         'isdst'   => '0',
                         'abb'     => 'GMT',
                        },

               },
);

1;
