use strict;
use warnings;

use Module::Build;

my $build = Module::Build->new(
   module_name => 'Tickit::Async',
   requires => {
      'IO::Async' => '0.29',
      'IO::Async::Notifier' => '0.43',
      'IO::Async::Stream' => '0.34',
      'IO::Async::Test' => 0,
      'Term::TermKey::Async' => 0,
      'Tickit' => '0.09',
   },
   build_requires => {
      'Test::HexString' => 0,
      'Test::More' => 0,
      'Test::Refcount' => 0,
   },
   auto_configure_requires => 0, # Don't add M::B to configure_requires
   license => 'perl',
   create_makefile_pl => 'small',
   create_license => 1,
   create_readme  => 1,
);

$build->create_build_script;
