package DNS::Hetzner::API::Records;
$DNS::Hetzner::API::Records::VERSION = '0.03';
# ABSTRACT: Records

# ---
# This class is auto-generated by bin/get_hetzner_info.pl
# ---

use v5.20;

use Moo;
use Types::Standard qw(:all);

use Mojo::Base -strict, -signatures;

extends 'DNS::Hetzner::APIBase';

with 'MooX::Singleton';

use DNS::Hetzner::Schema;
use Carp;

has endpoint  => ( is => 'ro', isa => Str, default => sub { 'records' } );

sub bulk_create ($self, %params) {
    return $self->_do( 'BulkCreateRecords', \%params, '/bulk', { type => 'post' } );
}

sub bulk_update ($self, %params) {
    return $self->_do( 'BulkUpdateRecords', \%params, '/bulk', { type => 'put' } );
}

sub delete ($self, %params) {
    return $self->_do( 'DeleteRecord', \%params, '/:RecordID', { type => 'delete' } );
}

sub get ($self, %params) {
    return $self->_do( 'GetRecord', \%params, '/:RecordID', { type => 'get' } );
}

sub update ($self, %params) {
    return $self->_do( 'UpdateRecord', \%params, '/:RecordID', { type => 'put' } );
}

sub list ($self, %params) {
    return $self->_do( 'GetRecords', \%params, '', { type => 'get' } );
}

sub create ($self, %params) {
    return $self->_do( 'CreateRecord', \%params, '', { type => 'post' } );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

DNS::Hetzner::API::Records - Records

=head1 VERSION

version 0.03

=head1 SYNOPSIS

    use DNS::Hetzner;

    my $api_key = '1234abc';
    my $dns     = DNS::Hetzner->new(
        token => $api_key,
    );

    $dns->records->create(
    );

=head1 ATTRIBUTES

=over 4

=item * endpoint

=back

=head1 METHODS

=head2 bulk_create

Create several records at once.

    $dns->Records->bulk_create();

=head2 bulk_update

Update several records at once.

    $dns->Records->bulk_update();

=head2 delete

Deletes a record.

    $dns->Records->delete();

=head2 get

Returns information about a single record.

    $dns->Records->get();

=head2 update

Updates a record.

    $dns->Records->update();

=head2 list

Returns all records associated with user.

    $dns->Records->list();

=head2 create

Creates a new record.

    $dns->Records->create();

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
