package MyTypes::Recipients;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %To_of :ATTR(:get<To>);
my %Cc_of :ATTR(:get<Cc>);
my %Bcc_of :ATTR(:get<Bcc>);

__PACKAGE__->_factory(
    [ qw(        To
        Cc
        Bcc

    ) ],
    {
        'To' => \%To_of,
        'Cc' => \%Cc_of,
        'Bcc' => \%Bcc_of,
    },
    {
        'To' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Cc' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Bcc' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'To' => 'To',
        'Cc' => 'Cc',
        'Bcc' => 'Bcc',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::Recipients

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Recipients from the namespace http://tempuri2.org/.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * To


=item * Cc


=item * Bcc




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::Recipients
   To =>  $some_value, # string
   Cc =>  $some_value, # string
   Bcc =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

