#!/usr/bin/perl
use strict;
use warnings;

use Data::Dumper qw/Dumper/;
use Test::RequiresInternet qw/getstrike.net 443/;
use Test::More tests => 11;
use Try::Tiny;
BEGIN { use_ok('WebService::Strike') };

my ($t1, $t2, $t3);
try {
	($t1, $t2, $t3) = strike qw/B425907E5755031BDA4A8D1B6DCCACA97DA14C04 5D4FD5A64E436A831383773F85FB38B888B9ECC9 85DF191A921C20B2DDAFF72368CAB93BA18C5ACE/;
} catch {
	diag 'Error while calling strike:', "\n", Dumper $_
};

subtest 'order' => sub {
	plan tests => 3;
	is $t1->hash, 'B425907E5755031BDA4A8D1B6DCCACA97DA14C04', 'hash #1';
	is $t2->hash, '5D4FD5A64E436A831383773F85FB38B888B9ECC9', 'hash #2';
	is $t3->hash, '85DF191A921C20B2DDAFF72368CAB93BA18C5ACE', 'hash #3'
};

is $t1->date, 1420502400, 'date';
is $t2->title, 'FreeBSD 7.1 i386.DVD.iso', 'title';
like $t1->torrent, qr/^d/, 'torrent file starts with d';
like $t1->description, qr#GNU/Linux#, 'description contains GNU/Linux';

try {
	strike 'aaa';
} catch {
	is $_->{status}, 404, 'non-existent torrent status is 404';
};

my @debian = strike_search 'Debian';
ok @debian > 10, 'search for Debian returned more than 10 results';
try {
	strike_search "nosuchstring$$";
} catch {
	is $_->{status}, 404, "search for nosuchstring$$ returned 404"
};

my $p = strike_search 'Perl', 1;
is @{$p->file_names}, $p->count, 'file_names has count elements';

my $imdb = strike('ED70C185E3E3246F30B2FDB08D504EABED5EEA3F')->imdb;
is $imdb->{title}, 'The Walking Dead', 'imdb title';
