use strict;
use warnings;

package Mail::Transport::Mailx;
our $VERSION = 2.029;  # Part of Mail::Box
use base 'Mail::Transport::Send';

use Carp;

sub init($)
{   my ($self, $args) = @_;

    $args->{via} = 'mailx';

    $self->SUPER::init($args);

    $self->{MTM_program}
      = $args->{proxy}
     || $self->findBinary('mailx')
     || $self->findBinary('Mail')
     || $self->findBinary('mail')
     || return;

    $self->{MTM_style}
      = defined $args->{style}                       ? $args->{style}
      : $^O =~ m/linux|freebsd|bsdos|netbsd|openbsd/ ? 'BSD'
      :                                                'RFC822';

    $self;
}

sub _try_send_bsdish($$)
{   my ($self, $message, $args) = @_;

    my @options = ('-s' => $message->subject);

    {   local $" = ',';
        my @cc  = map {$_->format} $message->cc;
        push @options, ('-c' => "@cc")  if @cc;

        my @bcc = map {$_->format} $message->bcc;
        push @options, ('-b' => "@bcc") if @bcc;
    }

    my @to      = map {$_->format} $message->to;
    my $program = $self->{MTM_program};

    if((open MAILER, '|-')==0)
    {   close STDOUT;
        { exec $program, @options, @to }
        $self->log(NOTICE => "Cannot start contact to $program: $!");
        return 0;
    }

    $self->putContent($message, \*MAILER, body_only => 1);

    my $msgid = $message->messageId;

    if(close MAILER) { $self->log(PROGRESS => "Message $msgid send.") }
    else
    {   $self->log(NOTICE =>
            "Sending message $msgid via $program failed: $! ($?)");
        return 0;
    }

    1;
}

sub trySend($@)
{   my ($self, $message, %args) = @_;

    return $self->_try_send_bsdish($message, \%args)
        if $self->{MTM_style} eq 'BSD';

    my $program = $self->{MTM_program};
    unless(open MAILER, '|-', $program, '-t')
    {   $self->log(NOTICE => "Cannot start contact to $program: $!");
        return 0;
    }

    $self->putContent($message, \*MAILER);

    unless(close MAILER)
    {   $self->log(NOTICE => "Sending via $program failed: $! ($?)");
        return 0;
    }

    1;
}

1;
