package # hide from PAUSE
App::YTDL::Video_Info;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( print_video_infos );

use List::MoreUtils        qw( none );
use Term::ANSIScreen       qw( :cursor :screen );
use Term::Choose::LineFold qw( line_fold );
use Term::Choose::Util     qw( get_term_size );

use App::YTDL::GetData     qw( get_download_info );
use App::YTDL::ExtractData qw( extract_data_single );


sub print_video_infos {
    my ( $set, $opt, $data, $chosen ) = @_;
    my ( $cols, $rows ) = get_term_size();
    print "\n\n\n\n", '=' x $cols, "\n\n", "\n" x $rows;
    print locate( 1, 1 ), cldown;
    say 'Quality: ', $opt->{quality};
    say 'Agent  : ', $opt->{useragent} if $opt->{useragent};
    print "\n";
    my $count = 1;

    EXTRACTOR_KEY: for my $ex ( sort keys %$data ) {

        UPLOADER_URL: for my $up ( sort keys %{$data->{$ex}} ) {

            VIDEO_ID: for my $id ( @{$chosen->{$ex}{$up}} ) {
                my $key_len = 12;
                $data->{$ex}{$up}{$id}{count} = $count;
                my @print_array = _linefolded_print_info( $set, $opt, $data, $ex, $up, $id, $key_len );
                printf "%*.*s : %s\n", $key_len, $key_len, 'video', $count;
                say for @print_array;
                print "\n";
                $count++;
            }
        }
    }
    print "\n";
    return;
}


sub _prepare_print_info {
    my ( $set, $opt, $data, $ex, $up, $id ) = @_;
    my @keys = qw(title video_id extractor author duration raters avg_rating view_count published description); # video_id ?
    if ( ! exists $data->{$ex}{$up}{$id}{fmt_to_info} ) {
        my $url = $data->{$ex}{$up}{$id}{url};
        my $message = "** GET download info: ...";
        my $h_ref = get_download_info( $set, $opt, $url, $message, 0 );
        extract_data_single( $set, $opt, $data, $h_ref );
    }
    $data->{$ex}{$up}{$id}{published}  = $data->{$ex}{$up}{$id}{upload_date};
    $data->{$ex}{$up}{$id}{author}     = $data->{$ex}{$up}{$id}{uploader};
    $data->{$ex}{$up}{$id}{avg_rating} = $data->{$ex}{$up}{$id}{average_rating};
    if ( length $data->{$ex}{$up}{$id}{author} && length $data->{$ex}{$up}{$id}{uploader_id} ) {
        if ( $data->{$ex}{$up}{$id}{author} ne $data->{$ex}{$up}{$id}{uploader_id} ) {
            $data->{$ex}{$up}{$id}{author} .= ' (' . $data->{$ex}{$up}{$id}{uploader_id} . ')';
        }
    }
    for my $key ( @keys ) {
        next if ! $data->{$ex}{$up}{$id}{$key};
        $data->{$ex}{$up}{$id}{$key} =~ s/\R/ /g;
    }
    return @keys;
}


sub _linefolded_print_info {
    my ( $set, $opt, $data, $ex, $up, $id, $key_len ) = @_;
    my @keys = _prepare_print_info( $set, $opt, $data, $ex, $up, $id );
    my $s_tab = $key_len + length( ' : ' );
    my ( $maxcols, $maxrows ) = get_term_size();
    $maxcols -= $set->{right_margin};
    my $col_max = $maxcols > $opt->{max_info_width} ? $opt->{max_info_width} : $maxcols;
    my @print_array = ();
    for my $key ( @keys ) {
        next if ! length $data->{$ex}{$up}{$id}{$key};
        $data->{$ex}{$up}{$id}{$key} =~ s/\n+/\n/g;
        $data->{$ex}{$up}{$id}{$key} =~ s/^\s+//;
        $data->{$ex}{$up}{$id}{$key} =~ s/\s+\z//;
        ( my $kk = $key ) =~ s/_/ /g;
        my $pr_key = sprintf "%*.*s : ", $key_len, $key_len, $kk;
        push @print_array, line_fold(
            $pr_key . $data->{$ex}{$up}{$id}{$key},
            $col_max,
            { init_tab => '' , subseq_tab => ' ' x $s_tab, join => 0 }
        );
    }
    return @print_array if ! @print_array;
    # auto width:
    my $ratio = @print_array / $maxrows;
    my $begin = 0.70;
    my $end   = 1.50;
    my $step  = 0.0125;
    my $div   = ( $end - $begin ) / $step + 1;
    my $plus;
    if ( $ratio >= $begin ) {
        $ratio = $end if $ratio > $end;
        $plus = int( ( ( $maxcols - $col_max ) / $div ) * ( ( $ratio - $begin  ) / $step + 1 ) );
    }
    if ( $plus ) {
        $col_max += $plus;
        @print_array = ();
        for my $key ( @keys ) {
            next if ! length $data->{$ex}{$up}{$id}{$key};
            ( my $kk = $key ) =~ s/_/ /g;
            my $pr_key = sprintf "%*.*s : ", $key_len, $key_len, $kk;
            push @print_array, line_fold(
                $pr_key . $data->{$ex}{$up}{$id}{$key},
                $col_max,
                { init_tab => '' , subseq_tab => ' ' x $s_tab, join => 0 }
            );
        }
    }
    if ( @print_array > ( $maxrows - 6 ) ) {
        $col_max = $maxcols;
        @print_array = ();
        for my $key ( @keys ) {
            next if ! length $data->{$ex}{$up}{$id}{$key};
            ( my $kk = $key ) =~ s/_/ /g;
            my $pr_key = sprintf "%*.*s : ", $key_len, $key_len, $kk;
            push @print_array, line_fold(
                $pr_key . $data->{$ex}{$up}{$id}{$key},
                $col_max,
                { init_tab => '' , subseq_tab => ' ' x $s_tab, join => 0 }
            );
        }
    }
    return @print_array;
}




1;


__END__
