#!/usr/bin/perl -w

# Copyright 2012, 2013, 2014, 2015 Kevin Ryde

# This file is part of Math-PlanePath.
#
# Math-PlanePath is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3, or (at your option) any later
# version.
#
# Math-PlanePath is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Math-PlanePath.  If not, see <http://www.gnu.org/licenses/>.

use 5.004;
use strict;
use Test;
plan tests => 11;

use lib 't','xt';
use MyTestHelpers;
BEGIN { MyTestHelpers::nowarnings(); }
use MyOEIS;

use Math::PlanePath::Flowsnake;

# uncomment this to run the ### lines
#use Smart::Comments '###';


my $path = Math::PlanePath::Flowsnake->new;


#------------------------------------------------------------------------------
# A229214 - direction 1,2,3,-1,-2,-3
#
#   *---*---*    
#    \       \     /
#     *---*   *---*
#        /
#   *---*              
#     1, 2, -1, 3, 1, 1
{
  my %dxdy_to_dirpn3 = ('2,0' => 1,      #       3   2
                        '1,1' => 2,     #        \ /
                        '-1,1' => 3,    #   -1 ---*--- 1
                        '-2,0' => -1,    #        / \
                        '-1,-1' => -2,    #      -2   -3
                        '1,-1' => -3);
  MyOEIS::compare_values
      (anum => 'A229214',
       func => sub {
         my ($count) = @_;
         my @got;
         for (my $n = $path->n_start; @got < $count; $n++) {
           my ($dx,$dy) = $path->n_to_dxdy($n);
           my $dir = $dxdy_to_dirpn3{"$dx,$dy"};
           die if ! defined $dir;
           push @got, $dir;
         }
         return \@got;
       });
}

#------------------------------------------------------------------------------
exit 0;
