=head1

Locale::CLDR::Locales::Pa - Package for language Punjabi

=cut

package Locale::CLDR::Locales::Pa;
# This file auto generated from Data\common\main\pa.xml
#	on Wed 10 Feb  8:18:41 am GMT

use version;

our $VERSION = version->declare('v0.28.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'ab' => 'ਅਬਖਾਜ਼ੀਅਨ',
 				'ace' => 'ਅਚੀਨੀ',
 				'ach' => 'ਅਕੋਲੀ',
 				'af' => 'ਅਫ਼ਰੀਕੀ',
 				'agq' => 'ਅਗੇਮ',
 				'ak' => 'ਅਕਾਨ',
 				'am' => 'ਅਮਹਾਰਿਕ',
 				'ang' => 'ਪੁਰਾਣੀ ਅੰਗਰੇਜ਼ੀ',
 				'ar' => 'ਅਰਬੀ',
 				'ar_001' => 'ਆਧੁਨਿਕ ਮਿਆਰੀ ਅਰਬੀ',
 				'arn' => 'ਮਾਪੁਚੇ',
 				'as' => 'ਅਸਾਮੀ',
 				'asa' => 'ਅਸੂ',
 				'az' => 'ਅਜ਼ਰਬਾਈਜਾਨੀ',
 				'az@alt=short' => 'ਅਜ਼ੇਰੀ',
 				'ba' => 'ਬਸ਼ਕੀਰ',
 				'be' => 'ਬੇਲਾਰੂਸੀ',
 				'bem' => 'ਬੇਮਬਾ',
 				'bez' => 'ਬੇਨਾ',
 				'bg' => 'ਬੁਲਗਾਰੀਆਈ',
 				'bgn' => 'ਪੱਛਮੀ ਬਲੂਚੀ',
 				'bho' => 'ਭੋਜਪੁਰੀ',
 				'bm' => 'ਬੰਬਾਰਾ',
 				'bn' => 'ਬੰਗਾਲੀ',
 				'bo' => 'ਤਿੱਬਤੀ',
 				'br' => 'ਬਰੇਟਨ',
 				'brx' => 'ਬੋਡੋ',
 				'bs' => 'ਬੋਸਨੀਆਈ',
 				'ca' => 'ਕੈਟਾਲਾਨ',
 				'ce' => 'ਚੇਚਨ',
 				'cgg' => 'ਚੀਗਾ',
 				'chm' => 'ਮਾਰੀ',
 				'chr' => 'ਚੇਰੋਕੀ',
 				'ckb' => 'ਕੇਂਦਰੀ ਕੁਰਦਿਸ਼',
 				'co' => 'ਕੋਰਸੀਕਨ',
 				'cs' => 'ਚੈਕ',
 				'cv' => 'ਚੁਵਾਸ਼',
 				'cy' => 'ਵੈਲਜ਼',
 				'da' => 'ਡੈਨਿਸ਼',
 				'dav' => 'ਟੇਟਾ',
 				'de' => 'ਜਰਮਨ',
 				'de_AT' => 'ਆਸਟਰੀਆਈ ਜਰਮਨ',
 				'de_CH' => 'ਸਵਿਸ ਹਾਈ ਜਰਮਨ',
 				'dje' => 'ਜ਼ਾਰਮਾ',
 				'dsb' => 'ਲੋਅਰ ਸੋਰਬੀਅਨ',
 				'dua' => 'ਡੂਆਲਾ',
 				'dyo' => 'ਜੋਲਾ-ਫੋਇਨੀ',
 				'dz' => 'ਜ਼ੋਂਗਖਾ',
 				'ebu' => 'ਇੰਬੂ',
 				'ee' => 'ਈਵਈ',
 				'egy' => 'ਪੁਰਾਤਨ ਮਿਸਰੀ',
 				'el' => 'ਯੂਨਾਨੀ',
 				'en' => 'ਅੰਗਰੇਜ਼ੀ',
 				'en_AU' => 'ਆਸਟ੍ਰੇਲੀਆਈ ਅੰਗਰੇਜ਼ੀ',
 				'en_CA' => 'ਕੈਨੇਡੀਅਨ ਅੰਗਰੇਜ਼ੀ',
 				'en_GB' => 'ਬਰਤਾਨਵੀ ਅੰਗਰੇਜ਼ੀ',
 				'en_GB@alt=short' => 'ਯੂ.ਕੇ. ਅੰਗਰੇਜ਼ੀ',
 				'en_US' => 'ਅਮਰੀਕੀ ਅੰਗਰੇਜ਼ੀ',
 				'en_US@alt=short' => 'ਯੂ.ਐਸ. ਅੰਗਰੇਜ਼ੀ',
 				'eo' => 'ਇਸਪੇਰਾਂਟੋ',
 				'es' => 'ਸਪੇਨੀ',
 				'es_419' => 'ਲਾਤੀਨੀ ਅਮਰੀਕੀ ਸਪੇਨੀ',
 				'es_ES' => 'ਯੂਰਪੀ ਸਪੇਨੀ',
 				'es_MX' => 'ਮੈਕਸੀਕਨ ਸਪੈਨਿਸ਼',
 				'et' => 'ਇਸਟੋਨੀਆਈ',
 				'eu' => 'ਬਾਸਕ',
 				'fa' => 'ਫ਼ਾਰਸੀ',
 				'fi' => 'ਫਿਨਿਸ਼',
 				'fil' => 'ਫਿਲੀਪਿਨੋ',
 				'fj' => 'ਫ਼ਿਜ਼ੀ',
 				'fo' => 'ਫ਼ੇਰੋਸੇ',
 				'fr' => 'ਫਰਾਂਸੀਸੀ',
 				'fr_CA' => 'ਕੈਨੇਡੀਅਨ ਫਰਾਂਸੀਸੀ',
 				'fr_CH' => 'ਸਵਿਸ ਫਰਾਂਸੀਸੀ',
 				'fy' => 'ਪੱਛਮੀ ਫ੍ਰਿਸੀਅਨ',
 				'ga' => 'ਆਇਰੀ',
 				'gag' => 'ਗਾਗੌਜ਼',
 				'gl' => 'ਗੈਲਿਸ਼ਿਅਨ',
 				'gn' => 'ਗੁਆਰਾਨੀ',
 				'grc' => 'ਪੁਰਾਤਨ ਯੂਨਾਨੀ',
 				'gsw' => 'ਸਵਿਸ ਜਰਮਨ',
 				'gu' => 'ਗੁਜਰਾਤੀ',
 				'guz' => 'ਗੁਸੀ',
 				'gv' => 'ਮੈਂਕਸ',
 				'ha' => 'ਹੌਸਾ',
 				'haw' => 'ਹਵਾਈ',
 				'he' => 'ਹਿਬਰੂ',
 				'hi' => 'ਹਿੰਦੀ',
 				'hif' => 'ਫਿਜੀ ਹਿੰਦੀ',
 				'hr' => 'ਕ੍ਰੋਏਸ਼ਿਆਈ',
 				'hsb' => 'ਅੱਪਰ ਸੋਰਬੀਅਨ',
 				'ht' => 'ਹੈਤੀਆਈ',
 				'hu' => 'ਹੰਗਰੀਆਈ',
 				'hy' => 'ਅਰਮੀਨੀਆਈ',
 				'id' => 'ਇੰਡੋਨੇਸ਼ੀਆਈ',
 				'ig' => 'ਇਗਬੋ',
 				'ii' => 'ਸਿਚੁਆਨ ਯੀ',
 				'is' => 'ਆਈਸਲੈਂਡਿਕ',
 				'it' => 'ਇਤਾਲਵੀ',
 				'iu' => 'ਇੰਕਟੀਟੂਤ',
 				'ja' => 'ਜਪਾਨੀ',
 				'jgo' => 'ਨਗੋਂਬਾ',
 				'jmc' => 'ਮਚਾਮੇ',
 				'jv' => 'ਜਾਵਾਨੀਜ਼',
 				'ka' => 'ਜਾਰਜੀਆਈ',
 				'kab' => 'ਕਬਾਇਲ',
 				'kam' => 'ਕੰਬਾ',
 				'kde' => 'ਮਕੋਂਡ',
 				'kea' => 'ਕਾਬੁਵੇਰਦਿਆਨੂ',
 				'khq' => 'ਕੋਯਰਾ ਚੀਨੀ',
 				'ki' => 'ਕਿਕੂਯੂ',
 				'kk' => 'ਕਜ਼ਾਖ਼',
 				'kl' => 'ਕਲਾਅੱਲੀਸੁਟ',
 				'kln' => 'ਕਲੇਜਿਨ',
 				'km' => 'ਖਮੇਰ',
 				'kn' => 'ਕੰਨੜ',
 				'ko' => 'ਕੋਰੀਆਈ',
 				'koi' => 'ਕੋਮੀ-ਪੇਰਮਿਆਕ',
 				'kok' => 'ਕੋਂਕਣੀ',
 				'ks' => 'ਕਸ਼ਮੀਰੀ',
 				'ksb' => 'ਸ਼ੰਬਾਲਾ',
 				'ksf' => 'ਬਫ਼ੀਆ',
 				'ku' => 'ਕੁਰਦ',
 				'kw' => 'ਕੋਰਨਿਸ਼',
 				'ky' => 'ਕਿਰਗੀਜ਼',
 				'la' => 'ਲਾਤੀਨੀ',
 				'lag' => 'ਲੰਗਾਈ',
 				'lb' => 'ਲਕਜ਼ਮਬਰਗਿਸ਼',
 				'lg' => 'ਗਾਂਡਾ',
 				'lkt' => 'ਲਕੋਟਾ',
 				'ln' => 'ਲਿੰਗਾਲਾ',
 				'lo' => 'ਲਾਓ',
 				'lrc' => 'ਉੱਤਰੀ ਲੁਰੀ',
 				'lt' => 'ਲਿਥੁਆਨੀਅਨ',
 				'lu' => 'ਲੂਬਾ-ਕਾਟਾਂਗਾ',
 				'luo' => 'ਲੂਓ',
 				'luy' => 'ਲੂਈਆ',
 				'lv' => 'ਲਾਟਵਿਅਨ',
 				'mai' => 'ਮੈਥਲੀ',
 				'mas' => 'ਮਸਾਈ',
 				'mer' => 'ਮੇਰੂ',
 				'mfe' => 'ਮੋਰੀਸਿਅਨ',
 				'mg' => 'ਮੇਲੇਗਸੀ',
 				'mgh' => 'ਮਖੋਵਾ-ਮਿੱਟੋ',
 				'mgo' => 'ਮੇਟਾ',
 				'mi' => 'ਮਾਉਰੀ',
 				'mk' => 'ਮੈਕਡੋਨੀਆਈ',
 				'ml' => 'ਮਲਿਆਲਮ',
 				'mn' => 'ਮੰਗੋਲੀਅਨ',
 				'mni' => 'ਮਨੀਪੁਰੀ',
 				'moh' => 'ਮੋਹਾਵਕ',
 				'mr' => 'ਮਰਾਠੀ',
 				'ms' => 'ਮਲਯ',
 				'mt' => 'ਮਾਲਟੀਜ਼',
 				'mua' => 'ਮੁੰਡੇਂਗ',
 				'mul' => 'ਕਈ ਭਾਸ਼ਾਵਾਂ',
 				'my' => 'ਬਰਮੀ',
 				'mzn' => 'ਮੇਜ਼ੈਂਡਰਾਨੀ',
 				'naq' => 'ਨਾਮਾ',
 				'nb' => 'ਨਾਰਵੇਜਿਆਈ ਬੋਕਮਲ',
 				'nd' => 'ਉੱਤਰੀ ਨਡੇਬੇਲੇ',
 				'nds' => 'ਲੋ ਜਰਮਨ',
 				'nds_NL' => 'ਲੋ ਸੈਕਸਨ',
 				'ne' => 'ਨੇਪਾਲੀ',
 				'nl' => 'ਡੱਚ',
 				'nl_BE' => 'ਫਲੈਮਿਸ਼',
 				'nmg' => 'ਕਵਾਸਿਓ',
 				'nn' => 'ਨਾਰਵੇਜਿਆਈ ਨਿਓਨੌਰਸਕ',
 				'no' => 'ਨਾਰਵੇਜੀਅਨ',
 				'nqo' => 'ਐਂਕੋ',
 				'nus' => 'ਨੁਏਰ',
 				'nyn' => 'ਨਿਆਂਕੋਲੇ',
 				'om' => 'ਓਰੋਮੋ',
 				'or' => 'ਉੜੀਆ',
 				'pa' => 'ਪੰਜਾਬੀ',
 				'pi' => 'ਪਲੀ',
 				'pl' => 'ਪੋਲੈਂਡੀ',
 				'ps' => 'ਪਸ਼ਤੋ',
 				'pt' => 'ਪੁਰਤਗਾਲੀ',
 				'pt_BR' => 'ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਪੁਰਤਗਾਲੀ',
 				'pt_PT' => 'ਯੂਰਪੀ ਪੁਰਤਗਾਲੀ',
 				'qu' => 'ਕਕੇਸ਼ੁਆ',
 				'quc' => 'ਕੇਸ਼',
 				'raj' => 'ਰਾਜਸਥਾਨੀ',
 				'rm' => 'ਰੋਮਾਂਸ਼',
 				'rn' => 'ਰੁੰਡੀ',
 				'ro' => 'ਰੋਮਾਨੀਆਈ',
 				'ro_MD' => 'ਮੋਲਡਾਵੀਆਈ',
 				'rof' => 'ਰੋਮਬੋ',
 				'ru' => 'ਰੂਸੀ',
 				'rw' => 'ਕਿਨਿਆਰਵਾਂਡਾ',
 				'rwk' => 'ਰਵਾ',
 				'sa' => 'ਸੰਸਕ੍ਰਿਤ',
 				'saq' => 'ਸਮਬੁਰੂ',
 				'sat' => 'ਸੰਥਾਲੀ',
 				'sbp' => 'ਸੇਂਗੋ',
 				'sd' => 'ਸਿੰਧੀ',
 				'sdh' => 'ਦੱਖਣੀ ਕੁਰਦਿਸ਼',
 				'se' => 'ਉੱਤਰੀ ਸਾਮੀ',
 				'seh' => 'ਸੇਨਾ',
 				'ses' => 'ਕੋਇਰਾਬੋਰੋ ਸੇਂਨੀ',
 				'sg' => 'ਸਾਂਗੋ',
 				'shi' => 'ਟਚੇਲਹਿਟ',
 				'shn' => 'ਸ਼ਾਨ',
 				'si' => 'ਸਿੰਹਾਲਾ',
 				'sk' => 'ਸਲੋਵਾਕ',
 				'sl' => 'ਸਲੋਵੇਨੀਆਈ',
 				'sma' => 'ਦੱਖਣੀ ਸਾਮੀ',
 				'smj' => 'ਲਿਊਲ ਸਾਮੀ',
 				'smn' => 'ਇਨਾਰੀ ਸਾਮੀ',
 				'sms' => 'ਸਕੌਲਟ ਸਾਮੀ',
 				'sn' => 'ਸ਼ੋਨਾ',
 				'so' => 'ਸੋਮਾਲੀ',
 				'sq' => 'ਅਲਬਾਨੀਆਈ',
 				'sr' => 'ਸਰਬੀਆਈ',
 				'su' => 'ਸੂੰਡਾਨੀ',
 				'sv' => 'ਸਵੀਡਿਸ਼',
 				'sw' => 'ਸਵਾਹਿਲੀ',
 				'swc' => 'ਕਾਂਗੋ ਸਵਾਹਿਲੀ',
 				'ta' => 'ਤਮਿਲ',
 				'te' => 'ਤੇਲਗੂ',
 				'teo' => 'ਟੇਸੋ',
 				'tg' => 'ਤਾਜਿਕ',
 				'th' => 'ਥਾਈ',
 				'ti' => 'ਤਿਗ੍ਰੀਨਿਆ',
 				'tk' => 'ਤੁਰਕਮੇਨ',
 				'to' => 'ਟੌਂਗਨ',
 				'tr' => 'ਤੁਰਕੀ',
 				'tt' => 'ਤਤਾਰ',
 				'tw' => 'ਤ੍ਵਿ',
 				'twq' => 'ਤਾਸਾਵਿਕ',
 				'tzm' => 'ਮੱਧ ਐਟਲਸ ਤਮਾਜ਼ਿਤ',
 				'ug' => 'ਉਇਗੁਰ',
 				'uk' => 'ਯੂਕਰੇਨੀਆਈ',
 				'und' => 'ਅਗਿਆਤ ਭਾਸ਼ਾ',
 				'ur' => 'ਉਰਦੂ',
 				'uz' => 'ਉਜ਼ਬੇਕ',
 				'vai' => 'ਵਾਈ',
 				'vi' => 'ਵੀਅਤਨਾਮੀ',
 				'vun' => 'ਵੂੰਜੋ',
 				'wbp' => 'ਵਾਲਪੁਰੀ',
 				'wo' => 'ਵੋਲੋਫ',
 				'xh' => 'ਖੋਸਾ',
 				'xog' => 'ਸੋਗਾ',
 				'yo' => 'ਯੋਰੂਬਾ',
 				'zgh' => 'ਮਿਆਰੀ ਮੋਰੋਕੇਨ ਟਾਮਾਜ਼ਿਕ',
 				'zh' => 'ਚੀਨੀ',
 				'zh_Hans' => 'ਸਰਲ ਚੀਨੀ',
 				'zh_Hant' => 'ਰਵਾਇਤੀ ਚੀਨੀ',
 				'zu' => 'ਜ਼ੁਲੂ',
 				'zxx' => 'ਕੋਈ ਭਾਸ਼ਾਈ ਸਮੱਗਰੀ ਨਹੀਂ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'ਅਰਬੀ',
 			'Armn' => 'ਅਰਮੀਨੀਆਈ',
 			'Beng' => 'ਬੰਗਾਲੀ',
 			'Bopo' => 'ਬੋਪੋਮੋਫੋ',
 			'Brai' => 'ਬਰੇਲ',
 			'Cyrl' => 'ਸਿਰੀਲਿਕ',
 			'Deva' => 'ਦੇਵਨਾਗਰੀ',
 			'Ethi' => 'ਇਥੀਓਪਿਕ',
 			'Geor' => 'ਜਾਰਜੀਆਈ',
 			'Grek' => 'ਗ੍ਰੀਕ',
 			'Gujr' => 'ਗੁਜਰਾਤੀ',
 			'Guru' => 'ਗੁਰਮੁਖੀ',
 			'Hang' => 'ਹੰਗੁਲ',
 			'Hani' => 'ਹਾਨ',
 			'Hans' => 'ਸਰਲ',
 			'Hans@alt=stand-alone' => 'ਸਰਲ ਹਾਨ',
 			'Hant' => 'ਰਵਾਇਤੀ',
 			'Hant@alt=stand-alone' => 'ਰਵਾਇਤੀ ਹਾਨ',
 			'Hebr' => 'ਹਿਬਰੂ',
 			'Hira' => 'ਹਿਰਾਗਾਨਾ',
 			'Jpan' => 'ਜਪਾਨੀ',
 			'Kana' => 'ਕਾਟਾਕਾਨਾ',
 			'Khmr' => 'ਖਮੇਰ',
 			'Knda' => 'ਕੰਨੜ',
 			'Kore' => 'ਕੋਰੀਆਈ',
 			'Laoo' => 'ਲਾਓ',
 			'Latn' => 'ਲਾਤੀਨੀ',
 			'Mlym' => 'ਮਲਿਆਲਮ',
 			'Mong' => 'ਮੰਗੋਲੀਅਨ',
 			'Mymr' => 'ਮਿਆਂਮਾਰ',
 			'Orya' => 'ਉੜੀਆ',
 			'Sinh' => 'ਸਿੰਹਾਲਾ',
 			'Taml' => 'ਤਮਿਲ',
 			'Telu' => 'ਤੇਲਗੂ',
 			'Thaa' => 'ਥਾਨਾ',
 			'Thai' => 'ਥਾਈ',
 			'Tibt' => 'ਤਿੱਬਤੀ',
 			'Zmth' => 'ਗਣਿਤ ਚਿੰਨ੍ਹ-ਲਿਪੀ',
 			'Zsym' => 'ਚਿੰਨ੍ਹ',
 			'Zxxx' => 'ਅਲਿਖਤ',
 			'Zyyy' => 'ਸਧਾਰਨ',
 			'Zzzz' => 'ਅਣਪਛਾਤੀ ਲਿਪੀ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ਸੰਸਾਰ',
 			'002' => 'ਅਫ਼ਰੀਕਾ',
 			'003' => 'ਉੱਤਰ ਅਮਰੀਕਾ',
 			'005' => 'ਦੱਖਣੀ ਅਮਰੀਕਾ',
 			'009' => 'ਓਸ਼ੇਨੀਆ',
 			'011' => 'ਪੱਛਮੀ ਅਫ਼ਰੀਕਾ',
 			'013' => 'ਕੇਂਦਰੀ ਅਮਰੀਕਾ',
 			'014' => 'ਪੂਰਬੀ ਅਫ਼ਰੀਕਾ',
 			'015' => 'ਉੱਤਰੀ ਅਫ਼ਰੀਕਾ',
 			'017' => 'ਮੱਧ ਅਫ਼ਰੀਕਾ',
 			'018' => 'ਦੱਖਣੀ ਅਫ਼ਰੀਕਾ',
 			'019' => 'ਅਮਰੀਕਾ',
 			'021' => 'ਉੱਤਰੀ ਅਮਰੀਕਾ',
 			'029' => 'ਕੈਰੇਬੀਆਈ',
 			'030' => 'ਪੂਰਬੀ ਏਸ਼ੀਆ',
 			'034' => 'ਦੱਖਣੀ ਏਸ਼ੀਆ',
 			'035' => 'ਦੱਖਣ-ਪੂਰਬੀ ਏਸ਼ੀਆ',
 			'039' => 'ਦੱਖਣੀ ਯੂਰਪ',
 			'053' => 'ਆਸਟਰੇਲੇਸ਼ੀਆ',
 			'054' => 'ਮੇਲਾਨੇਸ਼ੀਆ',
 			'057' => 'ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆਈ ਖੇਤਰ',
 			'061' => 'ਪੋਲੀਨੇਸ਼ੀਆ',
 			'142' => 'ਏਸ਼ੀਆ',
 			'143' => 'ਕੇਂਦਰੀ ਏਸ਼ੀਆ',
 			'145' => 'ਪੱਛਮੀ ਏਸ਼ੀਆ',
 			'150' => 'ਯੂਰਪ',
 			'151' => 'ਪੂਰਬੀ ਯੂਰਪ',
 			'154' => 'ਉੱਤਰੀ ਯੂਰਪ',
 			'155' => 'ਪੱਛਮੀ ਯੂਰਪ',
 			'419' => 'ਲਾਤੀਨੀ ਅਮਰੀਕਾ',
 			'AC' => 'ਅਸੈਂਸ਼ਨ ਟਾਪੂ',
 			'AD' => 'ਅੰਡੋਰਾ',
 			'AE' => 'ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ',
 			'AF' => 'ਅਫ਼ਗਾਨਿਸਤਾਨ',
 			'AG' => 'ਐਂਟੀਗੁਆ ਅਤੇ ਬਾਰਬੁਡਾ',
 			'AI' => 'ਅੰਗੁਇਲਾ',
 			'AL' => 'ਅਲਬਾਨੀਆ',
 			'AM' => 'ਅਰਮੀਨੀਆ',
 			'AO' => 'ਅੰਗੋਲਾ',
 			'AQ' => 'ਅੰਟਾਰਕਟਿਕਾ',
 			'AR' => 'ਅਰਜਨਟੀਨਾ',
 			'AS' => 'ਅਮੈਰੀਕਨ ਸਮੋਆ',
 			'AT' => 'ਆਸਟਰੀਆ',
 			'AU' => 'ਆਸਟ੍ਰੇਲੀਆ',
 			'AW' => 'ਅਰੂਬਾ',
 			'AX' => 'ਅਲੈਂਡ ਟਾਪੂ',
 			'AZ' => 'ਅਜ਼ਰਬਾਈਜਾਨ',
 			'BA' => 'ਬੋਸਨੀਆ ਅਤੇ ਹਰਜ਼ੇਗੋਵੀਨਾ',
 			'BB' => 'ਬਾਰਬਾਡੋਸ',
 			'BD' => 'ਬੰਗਲਾਦੇਸ਼',
 			'BE' => 'ਬੈਲਜੀਅਮ',
 			'BF' => 'ਬੁਰਕੀਨਾ ਫ਼ਾਸੋ',
 			'BG' => 'ਬੁਲਗਾਰੀਆ',
 			'BH' => 'ਬਹਿਰੀਨ',
 			'BI' => 'ਬੁਰੁੰਡੀ',
 			'BJ' => 'ਬੇਨਿਨ',
 			'BL' => 'ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ',
 			'BM' => 'ਬਰਮੂਡਾ',
 			'BN' => 'ਬਰੂਨੇਈ',
 			'BO' => 'ਬੋਲੀਵੀਆ',
 			'BQ' => 'ਕੈਰੇਬੀਆਈ ਨੀਦਰਲੈਂਡ',
 			'BR' => 'ਬ੍ਰਾਜ਼ੀਲ',
 			'BS' => 'ਬਹਾਮਾਸ',
 			'BT' => 'ਭੂਟਾਨ',
 			'BV' => 'ਬੌਵੇਟ ਟਾਪੂ',
 			'BW' => 'ਬੋਟਸਵਾਨਾ',
 			'BY' => 'ਬੇਲਾਰੂਸ',
 			'BZ' => 'ਬੇਲੀਜ਼',
 			'CA' => 'ਕੈਨੇਡਾ',
 			'CC' => 'ਕੋਕੋਸ (ਕੀਲਿੰਗ) ਟਾਪੂ',
 			'CD' => 'ਕਾਂਗੋ - ਕਿੰਸ਼ਾਸਾ',
 			'CD@alt=variant' => 'ਕਾਂਗੋ ਲੋਕਤੰਤਰੀ ਗਣਰਾਜ',
 			'CF' => 'ਕੇਂਦਰੀ ਅਫ਼ਰੀਕੀ ਗਣਰਾਜ',
 			'CG' => 'ਕਾਂਗੋ - ਬ੍ਰਾਜ਼ਾਵਿਲੇ',
 			'CG@alt=variant' => 'ਕਾਂਗੋ ਗਣਰਾਜ',
 			'CH' => 'ਸਵਿਟਜ਼ਰਲੈਂਡ',
 			'CI' => 'ਕੋਟ ਡੀਵੋਆਰ',
 			'CI@alt=variant' => 'ਆਇਵਰੀ ਕੋਸਟ',
 			'CK' => 'ਕੁੱਕ ਟਾਪੂ',
 			'CL' => 'ਚਿਲੀ',
 			'CM' => 'ਕੈਮਰੂਨ',
 			'CN' => 'ਚੀਨ',
 			'CO' => 'ਕੋਲੰਬੀਆ',
 			'CP' => 'ਕਲਿੱਪਰਟਨ ਟਾਪੂ',
 			'CR' => 'ਕੋਸਟਾ ਰੀਕਾ',
 			'CU' => 'ਕਿਊਬਾ',
 			'CV' => 'ਕੇਪ ਵਰਡੇ',
 			'CW' => 'ਕੁਰਾਕਾਓ',
 			'CX' => 'ਕ੍ਰਿਸਮਿਸ ਟਾਪੂ',
 			'CY' => 'ਸਾਇਪ੍ਰਸ',
 			'CZ' => 'ਚੈਕ ਗਣਰਾਜ',
 			'DE' => 'ਜਰਮਨੀ',
 			'DG' => 'ਡੀਇਗੋ ਗਾਰਸੀਆ',
 			'DJ' => 'ਜ਼ੀਬੂਤੀ',
 			'DK' => 'ਡੈਨਮਾਰਕ',
 			'DM' => 'ਡੋਮੀਨਿਕਾ',
 			'DO' => 'ਡੋਮੀਨਿਕਾਈ ਗਣਰਾਜ',
 			'DZ' => 'ਅਲਜੀਰੀਆ',
 			'EA' => 'ਸਿਓਟਾ ਅਤੇ ਮੇਲਿੱਲਾ',
 			'EC' => 'ਇਕਵੇਡੋਰ',
 			'EE' => 'ਇਸਟੋਨੀਆ',
 			'EG' => 'ਮਿਸਰ',
 			'EH' => 'ਪੱਛਮੀ ਸਹਾਰਾ',
 			'ER' => 'ਇਰੀਟ੍ਰਿਆ',
 			'ES' => 'ਸਪੇਨ',
 			'ET' => 'ਇਥੋਪੀਆ',
 			'EU' => 'ਯੂਰਪੀ ਯੂਨੀਅਨ',
 			'FI' => 'ਫਿਨਲੈਂਡ',
 			'FJ' => 'ਫ਼ਿਜੀ',
 			'FK' => 'ਫ਼ਾਕਲੈਂਡ ਟਾਪੂ',
 			'FK@alt=variant' => 'ਫ਼ਾਕਲੈਂਡ ਟਾਪੂ (ਆਈਲਾਸ ਮਾਲਵਿਨਾਸ)',
 			'FM' => 'ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆ',
 			'FO' => 'ਫੈਰੋ ਟਾਪੂ',
 			'FR' => 'ਫ਼ਰਾਂਸ',
 			'GA' => 'ਗਬੋਨ',
 			'GB' => 'ਯੂਨਾਈਟਡ ਕਿੰਗਡਮ',
 			'GB@alt=short' => 'ਯੂ.ਕੇ.',
 			'GD' => 'ਗ੍ਰੇਨਾਡਾ',
 			'GE' => 'ਜਾਰਜੀਆ',
 			'GF' => 'ਫ਼ਰੈਂਚ ਗੁਆਨਾ',
 			'GG' => 'ਗਰਨਜੀ',
 			'GH' => 'ਘਾਨਾ',
 			'GI' => 'ਜਿਬਰਾਲਟਰ',
 			'GL' => 'ਗ੍ਰੀਨਲੈਂਡ',
 			'GM' => 'ਗੈਂਬੀਆ',
 			'GN' => 'ਗਿਨੀ',
 			'GP' => 'ਗੁਆਡੇਲੋਪ',
 			'GQ' => 'ਭੂ-ਖੰਡੀ ਗਿਨੀ',
 			'GR' => 'ਗ੍ਰੀਸ',
 			'GS' => 'ਦੱਖਣੀ ਜਾਰਜੀਆ ਅਤੇ ਦੱਖਣੀ ਸੈਂਡਵਿਚ ਟਾਪੂ',
 			'GT' => 'ਗੁਆਟੇਮਾਲਾ',
 			'GU' => 'ਗੁਆਮ',
 			'GW' => 'ਗਿਨੀ-ਬਿਸਾਉ',
 			'GY' => 'ਗੁਯਾਨਾ',
 			'HK' => 'ਹਾਂਗ ਕਾਂਗ ਐਸਏਆਰ ਚੀਨ',
 			'HK@alt=short' => 'ਹਾਂਗ ਕਾਂਗ',
 			'HM' => 'ਹਰਡ ਤੇ ਮੈਕਡੋਨਾਲਡ ਟਾਪੂ',
 			'HN' => 'ਹੋਂਡੁਰਸ',
 			'HR' => 'ਕਰੋਏਸ਼ੀਆ',
 			'HT' => 'ਹੈਤੀ',
 			'HU' => 'ਹੰਗਰੀ',
 			'IC' => 'ਕੇਨਾਰੀ ਟਾਪੂ',
 			'ID' => 'ਇੰਡੋਨੇਸ਼ੀਆ',
 			'IE' => 'ਆਇਰਲੈਂਡ',
 			'IL' => 'ਇਜ਼ਰਾਈਲ',
 			'IM' => 'ਆਇਲ ਆਫ ਮੈਨ',
 			'IN' => 'ਭਾਰਤ',
 			'IO' => 'ਬਰਤਾਨਵੀ ਹਿੰਦ ਮਹਾਂਸਾਗਰ ਪ੍ਰਦੇਸ਼',
 			'IQ' => 'ਇਰਾਕ',
 			'IR' => 'ਈਰਾਨ',
 			'IS' => 'ਆਈਸਲੈਂਡ',
 			'IT' => 'ਇਟਲੀ',
 			'JE' => 'ਜਰਸੀ',
 			'JM' => 'ਜਮਾਇਕਾ',
 			'JO' => 'ਜਾਰਡਨ',
 			'JP' => 'ਜਪਾਨ',
 			'KE' => 'ਕੀਨੀਆ',
 			'KG' => 'ਕਿਰਗਿਜ਼ਸਤਾਨ',
 			'KH' => 'ਕੰਬੋਡੀਆ',
 			'KI' => 'ਕਿਰਬਾਤੀ',
 			'KM' => 'ਕੋਮੋਰੋਸ',
 			'KN' => 'ਸੈਂਟ ਕਿਟਸ ਐਂਡ ਨੇਵਿਸ',
 			'KP' => 'ਉੱਤਰੀ ਕੋਰੀਆ',
 			'KR' => 'ਦੱਖਣੀ ਕੋਰੀਆ',
 			'KW' => 'ਕੁਵੈਤ',
 			'KY' => 'ਕੇਮੈਨ ਟਾਪੂ',
 			'KZ' => 'ਕਜ਼ਾਖਸਤਾਨ',
 			'LA' => 'ਲਾਓਸ',
 			'LB' => 'ਲੈਬਨਾਨ',
 			'LC' => 'ਸੇਂਟ ਲੂਸੀਆ',
 			'LI' => 'ਲਿਚੇਂਸਟਾਇਨ',
 			'LK' => 'ਸ੍ਰੀ ਲੰਕਾ',
 			'LR' => 'ਲਾਈਬੀਰੀਆ',
 			'LS' => 'ਲੇਸੋਥੋ',
 			'LT' => 'ਲਿਥੁਆਨੀਆ',
 			'LU' => 'ਲਕਜ਼ਮਬਰਗ',
 			'LV' => 'ਲਾਟਵੀਆ',
 			'LY' => 'ਲੀਬੀਆ',
 			'MA' => 'ਮੋਰੱਕੋ',
 			'MC' => 'ਮੋਨਾਕੋ',
 			'MD' => 'ਮੋਲਡੋਵਾ',
 			'ME' => 'ਮੋਂਟੇਨੇਗਰੋ',
 			'MF' => 'ਸੇਂਟ ਮਾਰਟਿਨ',
 			'MG' => 'ਮੈਡਾਗਾਸਕਰ',
 			'MH' => 'ਮਾਰਸ਼ਲ ਟਾਪੂ',
 			'MK' => 'ਮੈਕਡੋਨੀਆ',
 			'MK@alt=variant' => 'ਮੈਕਡੋਨੀਆ (ਪੂਰਵ ਯੂਗੋਸਲਾਵ ਮੈਕਡੋਨੀਆਈ ਗਣਰਾਜ)',
 			'ML' => 'ਮਾਲੀ',
 			'MM' => 'ਮਿਆਂਮਾਰ (ਬਰਮਾ)',
 			'MN' => 'ਮੰਗੋਲੀਆ',
 			'MO' => 'ਮਕਾਉ ਐਸਏਆਰ ਚੀਨ',
 			'MO@alt=short' => 'ਮਕਾਉ',
 			'MP' => 'ਉੱਤਰੀ ਮਾਰੀਆਨਾ ਟਾਪੂ',
 			'MQ' => 'ਮਾਰਟੀਨਿਕ',
 			'MR' => 'ਮੋਰਿਟਾਨੀਆ',
 			'MS' => 'ਮੋਂਟਸੇਰਾਤ',
 			'MT' => 'ਮਾਲਟਾ',
 			'MU' => 'ਮੌਰਿਸ਼ਸ',
 			'MV' => 'ਮਾਲਦੀਵ',
 			'MW' => 'ਮਲਾਵੀ',
 			'MX' => 'ਮੈਕਸੀਕੋ',
 			'MY' => 'ਮਲੇਸ਼ੀਆ',
 			'MZ' => 'ਮੋਜ਼ਾਮਬੀਕ',
 			'NA' => 'ਨਾਮੀਬੀਆ',
 			'NC' => 'ਨਿਊ ਕੈਲੇਡੋਨੀਆ',
 			'NE' => 'ਨਾਈਜਰ',
 			'NF' => 'ਨੋਰਫੌਕ ਟਾਪੂ',
 			'NG' => 'ਨਾਈਜੀਰੀਆ',
 			'NI' => 'ਨਿਕਾਰਾਗੁਆ',
 			'NL' => 'ਨੀਦਰਲੈਂਡ',
 			'NO' => 'ਨਾਰਵੇ',
 			'NP' => 'ਨੇਪਾਲ',
 			'NR' => 'ਨਾਉਰੂ',
 			'NU' => 'ਨਿਯੂ',
 			'NZ' => 'ਨਿਊਜ਼ੀਲੈਂਡ',
 			'OM' => 'ਓਮਾਨ',
 			'PA' => 'ਪਨਾਮਾ',
 			'PE' => 'ਪੇਰੂ',
 			'PF' => 'ਫਰੈਂਚ ਪੋਲੀਨੇਸ਼ੀਆ',
 			'PG' => 'ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ',
 			'PH' => 'ਫਿਲੀਪੀਂਸ',
 			'PK' => 'ਪਾਕਿਸਤਾਨ',
 			'PL' => 'ਪੋਲੈਂਡ',
 			'PM' => 'ਸੈਂਟ ਪੀਅਰੇ ਐਂਡ ਮਿਕੇਲਨ',
 			'PN' => 'ਪਿਟਕੇਰਨ ਟਾਪੂ',
 			'PR' => 'ਪਿਊਰਟੋ ਰਿਕੋ',
 			'PS' => 'ਫਿਲੀਸਤੀਨੀ ਖੇਤਰ',
 			'PS@alt=short' => 'ਫਿਲੀਸਤੀਨ',
 			'PT' => 'ਪੁਰਤਗਾਲ',
 			'PW' => 'ਪਲਾਉ',
 			'PY' => 'ਪੈਰਾਗਵੇ',
 			'QA' => 'ਕਤਰ',
 			'QO' => 'ਆਊਟਲਾਇੰਗ ਓਸ਼ੀਨੀਆ',
 			'RE' => 'ਰਿਯੂਨੀਅਨ',
 			'RO' => 'ਰੋਮਾਨੀਆ',
 			'RS' => 'ਸਰਬੀਆ',
 			'RU' => 'ਰੂਸ',
 			'RW' => 'ਰਵਾਂਡਾ',
 			'SA' => 'ਸਾਊਦੀ ਅਰਬ',
 			'SB' => 'ਸੋਲੋਮਨ ਟਾਪੂ',
 			'SC' => 'ਸੇਸ਼ਲਸ',
 			'SD' => 'ਸੂਡਾਨ',
 			'SE' => 'ਸਵੀਡਨ',
 			'SG' => 'ਸਿੰਗਾਪੁਰ',
 			'SH' => 'ਸੇਂਟ ਹੇਲੇਨਾ',
 			'SI' => 'ਸਲੋਵੇਨੀਆ',
 			'SJ' => 'ਸਵਾਲਬਰਡ ਅਤੇ ਜਾਨ ਮਾਯੇਨ',
 			'SK' => 'ਸਲੋਵਾਕੀਆ',
 			'SL' => 'ਸਿਏਰਾ ਲਿਓਨ',
 			'SM' => 'ਸੈਨ ਮਰੀਨੋ',
 			'SN' => 'ਸੇਨੇਗਲ',
 			'SO' => 'ਸੋਮਾਲੀਆ',
 			'SR' => 'ਸੂਰੀਨਾਮ',
 			'SS' => 'ਦੱਖਣੀ ਸੂਡਾਨ',
 			'ST' => 'ਸਾਓ ਟੋਮ ਅਤੇ ਪ੍ਰਿੰਸੀਪੇ',
 			'SV' => 'ਅਲ ਸਲਵਾਡੋਰ',
 			'SX' => 'ਸਿੰਟ ਮਾਰਟੀਨ',
 			'SY' => 'ਸੀਰੀਆ',
 			'SZ' => 'ਸਵਾਜ਼ੀਲੈਂਡ',
 			'TA' => 'ਟ੍ਰਿਸਟਾਨ ਦਾ ਕੁੰਹਾ',
 			'TC' => 'ਟੁਰਕਸ ਅਤੇ ਕੈਕੋਸ ਟਾਪੂ',
 			'TD' => 'ਚਾਡ',
 			'TF' => 'ਫਰੈਂਚ ਦੱਖਣੀ ਪ੍ਰਦੇਸ਼',
 			'TG' => 'ਟੋਗੋ',
 			'TH' => 'ਥਾਈਲੈਂਡ',
 			'TJ' => 'ਤਾਜਿਕਿਸਤਾਨ',
 			'TK' => 'ਟੋਕੇਲਾਉ',
 			'TL' => 'ਤਿਮੋਰ-ਲੇਸਤੇ',
 			'TL@alt=variant' => 'ਪੂਰਬੀ ਤਿਮੋਰ',
 			'TM' => 'ਤੁਰਕਮੇਨਿਸਤਾਨ',
 			'TN' => 'ਟਿਊਨੀਸ਼ੀਆ',
 			'TO' => 'ਟੌਂਗਾ',
 			'TR' => 'ਤੁਰਕੀ',
 			'TT' => 'ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ',
 			'TV' => 'ਟੁਵਾਲੂ',
 			'TW' => 'ਤਾਇਵਾਨ',
 			'TZ' => 'ਤਨਜ਼ਾਨੀਆ',
 			'UA' => 'ਯੂਕਰੇਨ',
 			'UG' => 'ਯੂਗਾਂਡਾ',
 			'UM' => 'ਯੂ.ਐਸ. ਦੂਰ-ਦੁਰਾਡੇ ਟਾਪੂ',
 			'US' => 'ਸੰਯੁਕਤ ਰਾਜ',
 			'US@alt=short' => 'ਯੂ.ਐਸ.',
 			'UY' => 'ਉਰੂਗਵੇ',
 			'UZ' => 'ਉਜ਼ਬੇਕਿਸਤਾਨ',
 			'VA' => 'ਵੈਟੀਕਨ ਸਿਟੀ',
 			'VC' => 'ਸੇਂਟ ਵਿਨਸੈਂਟ ਐਂਡ ਗ੍ਰੇਨਾਡੀਨਸ',
 			'VE' => 'ਵੇਨੇਜ਼ੂਏਲਾ',
 			'VG' => 'ਬ੍ਰਿਟਿਸ਼ ਵਰਜਿਨ ਟਾਪੂ',
 			'VI' => 'ਯੂ ਐਸ ਵਰਜਿਨ ਟਾਪੂ',
 			'VN' => 'ਵੀਅਤਨਾਮ',
 			'VU' => 'ਵਾਨੂਆਟੂ',
 			'WF' => 'ਵਾਲਿਸ ਅਤੇ ਫੂਟੂਨਾ',
 			'WS' => 'ਸਾਮੋਆ',
 			'XK' => 'ਕੋਸੋਵੋ',
 			'YE' => 'ਯਮਨ',
 			'YT' => 'ਮਾਯੋਟੀ',
 			'ZA' => 'ਦੱਖਣੀ ਅਫਰੀਕਾ',
 			'ZM' => 'ਜ਼ਾਮਬੀਆ',
 			'ZW' => 'ਜ਼ਿੰਬਾਬਵੇ',
 			'ZZ' => 'ਅਣਪਛਾਤਾ ਖੇਤਰ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'ਕੈਲੰਡਰ',
 			'collation' => 'ਲੜੀਬੱਧ ਕ੍ਰਮ',
 			'currency' => 'ਮੁਦਰਾ',
 			'hc' => 'ਘੰਟੇ ਦਾ ਚੱਕਰ (12 ਬਨਾਮ 24)',
 			'lb' => 'ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ',
 			'ms' => 'ਮਾਪ ਪ੍ਰਣਾਲੀ',
 			'numbers' => 'ਸੰਖਿਆਵਾਂ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ਬੋਧੀ ਕੈਲੰਡਰ},
 				'chinese' => q{ਚੀਨੀ ਕੈਲੰਡਰ},
 				'dangi' => q{ਡਾਂਗੀ ਕੈਲੰਡਰ},
 				'ethiopic' => q{ਇਥੀਓਪਿਕ ਕੈਲੰਡਰ},
 				'gregorian' => q{ਗਰੇਗੋਰੀਅਨ ਕੈਲੰਡਰ},
 				'hebrew' => q{ਹਿਬਰੂ ਕੈਲੰਡਰ},
 				'indian' => q{ਭਾਰਤੀ ਕੌਮੀ ਕੈਲੰਡਰ},
 				'islamic' => q{ਇਸਲਾਮੀ ਕੈਲੰਡਰ},
 				'iso8601' => q{(ISO-8601) ਕੈਲੰਡਰ},
 				'japanese' => q{ਜਪਾਨੀ ਕੈਲੰਡਰ},
 				'persian' => q{ਫ਼ਾਰਸੀ ਕੈਲੰਡਰ},
 				'roc' => q{ਮਿੰਗੂਓ ਕੈਲੰਡਰ},
 			},
 			'collation' => {
 				'dictionary' => q{ਸ਼ਬਦ-ਕੋਸ਼ ਲੜੀਬੱਧ ਕ੍ਰਮ},
 				'ducet' => q{ਮੂਲ ਯੂਨੀਕੋਡ ਲੜੀਬੱਧ ਕ੍ਰਮ},
 				'search' => q{ਆਮ-ਮੰਤਵ ਖੋਜ},
 				'standard' => q{ਸਧਾਰਨ ਲੜੀਬੱਧ ਕ੍ਰਮ},
 				'traditional' => q{ਰਵਾਇਤੀ ਲੜੀਬੱਧ ਕ੍ਰਮ},
 			},
 			'hc' => {
 				'h11' => q{12 ਘੰਟੇ ਦੀ ਪੱਧਤੀ (0–11)},
 				'h12' => q{12 ਘੰਟੇ ਦੀ ਪੱਧਤੀ (1–12)},
 				'h23' => q{24 ਘੰਟੇ ਦੀ ਪੱਧਤੀ (0–23)},
 				'h24' => q{24 ਘੰਟੇ ਦੀ ਪੱਧਤੀ (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ਖੁੱਲ੍ਹੀ ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ},
 				'normal' => q{ਸਧਾਰਨ ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ},
 				'strict' => q{ਪੱਕੀ ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ},
 			},
 			'ms' => {
 				'metric' => q{ਮੀਟਰਿਕ ਪ੍ਰਣਾਲੀ},
 				'uksystem' => q{ਇੰਪੀਰੀਅਲ ਮਾਪ ਪ੍ਰਣਾਲੀ},
 				'ussystem' => q{ਅਮਰੀਕੀ ਮਾਪ ਪ੍ਰਣਾਲੀ},
 			},
 			'numbers' => {
 				'arab' => q{ਅਰਬੀ-ਭਾਰਤੀ ਅੰਕ},
 				'arabext' => q{ਵਿਸਤਾਰਿਤ ਅਰਬੀ-ਭਾਰਤੀ ਅੰਕ},
 				'armn' => q{ਆਰਮੀਨੀਅਨ ਸੰਖਿਆਵਾਂ},
 				'armnlow' => q{ਆਰਮੀਨੀਅਨ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ},
 				'beng' => q{ਬੰਗਾਲੀ ਅੰਕ},
 				'brah' => q{ਬਰਾਹਮੀ ਅੰਕ},
 				'deva' => q{ਦੇਵਨਾਗਰੀ ਅੰਕ},
 				'ethi' => q{ਐਥਿਓਪਿਕ ਸੰਖਿਆਵਾਂ},
 				'fullwide' => q{ਪੂਰਨ ਵਿਸਤਾਰ ਅੰਕ},
 				'geor' => q{ਜਾਰਜੀਅਨ ਸੰਖਿਆਵਾਂ},
 				'grek' => q{ਗ੍ਰੀਕ ਸੰਖਿਆਵਾਂ},
 				'greklow' => q{ਗ੍ਰੀਕ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ},
 				'gujr' => q{ਗੁਜਰਾਤੀ ਅੰਕ},
 				'guru' => q{ਗੁਰਮੁਖੀ ਅੰਕ},
 				'hanidec' => q{ਚੀਨੀ ਦਸ਼ਮਲਵ ਸੰਖਿਆਵਾਂ},
 				'hans' => q{ਸਰਲ ਚੀਨੀ ਸੰਖਿਆਵਾਂ},
 				'hansfin' => q{ਸਰਲ ਚੀਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ},
 				'hant' => q{ਰਵਾਇਤੀ ਚੀਨੀ ਸੰਖਿਆਵਾਂ},
 				'hantfin' => q{ਰਵਾਇਤੀ ਚੀਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ},
 				'hebr' => q{ਹਿਬਰੂ ਸੰਖਿਆਵਾਂ},
 				'jpan' => q{ਜਾਪਾਨੀ ਸੰਖਿਆਵਾਂ},
 				'jpanfin' => q{ਜਾਪਾਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ},
 				'khmr' => q{ਖਮੇਰ ਅੰਕ},
 				'knda' => q{ਕੰਨੜ ਅੰਕ},
 				'laoo' => q{ਲਾਓ ਅੰਕ},
 				'latn' => q{ਪੱਛਮੀ ਅੰਕ},
 				'mlym' => q{ਮਲਿਆਲਮ ਅੰਕ},
 				'mong' => q{ਮੰਗੋਲ ਅੰਕ},
 				'mymr' => q{ਮਿਆਂਮਾਰ ਅੰਕ},
 				'orya' => q{ਉੜੀਆ ਅੰਕ},
 				'roman' => q{ਰੋਮਨ ਸੰਖਿਆਵਾਂ},
 				'romanlow' => q{ਰੋਮਨ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ},
 				'taml' => q{ਰਵਾਇਤੀ ਤਮਿਲ ਸੰਖਿਆਵਾਂ},
 				'tamldec' => q{ਤਮਿਲ ਅੰਕ},
 				'telu' => q{ਤੇਲਗੂ ਅੰਕ},
 				'thai' => q{ਥਾਈ ਅੰਕ},
 				'tibt' => q{ਤਿੱਬਤੀ ਅੰਕ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{ਮੀਟਰਿਕ},
 			'UK' => q{ਯੂ. ਕੇ.},
 			'US' => q{ਯੂ. ਐਸ.},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ਭਾਸ਼ਾ: {0}',
 			'script' => 'ਲਿਪੀ: {0}',
 			'region' => 'ਖੇਤਰ: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍ ਃ ਂ ਁ {ਲ਼}])},
			index => ['ੴ', 'ੳ', 'ਉ', 'ਊ', 'ਓ', 'ਅ', 'ਆ', 'ਐ', 'ਔ', 'ੲ', 'ਇ', 'ਈ', 'ਏ', 'ਸ', 'ਹ', 'ਕ', 'ਖ', 'ਗ', 'ਘ', 'ਙ', 'ਚ', 'ਛ', 'ਜ', 'ਝ', 'ਞ', 'ਟ', 'ਠ', 'ਡ', 'ਢ', 'ਣ', 'ਤ', 'ਥ', 'ਦ', 'ਧ', 'ਨ', 'ਪ', 'ਫ', 'ਬ', 'ਭ', 'ਮ', 'ਯ', 'ਰ', 'ਲ', 'ਵ', 'ੜ'],
			main => qr{(?^u:[ੱ ੰ ਼ ੦ ੧ ੨ ੩ ੪ ੫ ੬ ੭ ੮ ੯ ੴ ੳ ਉ ਊ ਓ ਅ ਆ ਐ ਔ ੲ ਇ ਈ ਏ ਸ {ਸ਼} ਹ ਕ ਖ {ਖ਼} ਗ {ਗ਼} ਘ ਙ ਚ ਛ ਜ {ਜ਼} ਝ ਞ ਟ ਠ ਡ ਢ ਣ ਤ ਥ ਦ ਧ ਨ ਪ ਫ {ਫ਼} ਬ ਭ ਮ ਯ ਰ ਲ ਵ ੜ ੍ ਾ ਿ ੀ ੁ ੂ ੇ ੈ ੋ ੌ])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . ' ‘ ’ " “ ” ( ) \[ \] / \& ′ ″])},
		};
	},
EOT
: sub {
		return { index => ['ੴ', 'ੳ', 'ਉ', 'ਊ', 'ਓ', 'ਅ', 'ਆ', 'ਐ', 'ਔ', 'ੲ', 'ਇ', 'ਈ', 'ਏ', 'ਸ', 'ਹ', 'ਕ', 'ਖ', 'ਗ', 'ਘ', 'ਙ', 'ਚ', 'ਛ', 'ਜ', 'ਝ', 'ਞ', 'ਟ', 'ਠ', 'ਡ', 'ਢ', 'ਣ', 'ਤ', 'ਥ', 'ਦ', 'ਧ', 'ਨ', 'ਪ', 'ਫ', 'ਬ', 'ਭ', 'ਮ', 'ਯ', 'ਰ', 'ਲ', 'ਵ', 'ੜ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'name' => q(ਏਕੜ),
						'one' => q({0} ਏਕੜ),
						'other' => q({0} ਏਕੜ),
					},
					'acre-foot' => {
						'name' => q(ਏਕੜ ਫੁੱਟ),
						'one' => q({0} ਏਕੜ ਫੁੱਟ),
						'other' => q({0} ਏਕੜ ਫੁੱਟ),
					},
					'ampere' => {
						'name' => q(ਐਮਪੀਅਰ),
						'one' => q({0} ਐਮਪੀਅਰ),
						'other' => q({0} ਐਮਪੀਅਰ),
					},
					'arc-minute' => {
						'name' => q(ਚਾਪ-ਮਿੰਟ),
						'one' => q({0} ਚਾਪ-ਮਿੰਟ),
						'other' => q({0} ਚਾਪ-ਮਿੰਟ),
					},
					'arc-second' => {
						'name' => q(ਚਾਪ-ਸਕਿੰਟ),
						'one' => q({0} ਚਾਪ-ਸਕਿੰਟ),
						'other' => q({0} ਚਾਪ-ਸਕਿੰਟ),
					},
					'astronomical-unit' => {
						'name' => q(ਖਗੋਲੀ ਇਕਾਈਆਂ),
						'one' => q({0} ਖਗੋਲੀ ਇਕਾਈ),
						'other' => q({0} ਖਗੋਲੀ ਇਕਾਈਆਂ),
					},
					'bit' => {
						'name' => q(ਬਿਟ),
						'one' => q({0} ਬਿਟ),
						'other' => q({0} ਬਿਟ),
					},
					'bushel' => {
						'name' => q(ਬੁਸ਼ਲ),
						'one' => q({0} ਬੁਸ਼ਲ),
						'other' => q({0} ਬੁਸ਼ਲ),
					},
					'byte' => {
						'name' => q(ਬਾਇਟ),
						'one' => q({0} ਬਾਇਟ),
						'other' => q({0} ਬਾਇਟ),
					},
					'calorie' => {
						'name' => q(ਕੈਲੋਰੀਆਂ),
						'one' => q({0} ਕੈਲੋਰੀ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'carat' => {
						'name' => q(ਕੈਰਟ),
						'one' => q({0} ਕੈਰਟ),
						'other' => q({0} ਕੈਰਟ),
					},
					'celsius' => {
						'name' => q(ਦਰਜੇ ਸੈਲਸੀਅਸ),
						'one' => q({0} ਦਰਜਾ ਸੈਲਸੀਅਸ),
						'other' => q({0} ਦਰਜੇ ਸੈਲਸੀਅਸ),
					},
					'centiliter' => {
						'name' => q(ਸੈਂਟੀਲਿਟਰ),
						'one' => q({0} ਸੈਂਟੀਲਿਟਰ),
						'other' => q({0} ਸੈਂਟੀਲਿਟਰ),
					},
					'centimeter' => {
						'name' => q(ਸੈਂਟੀਮੀਟਰ),
						'one' => q({0} ਸੈਂਟੀਮੀਟਰ),
						'other' => q({0} ਸੈਂਟੀਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਸੈਂਟੀਮੀਟਰ),
					},
					'century' => {
						'name' => q(ਸਦੀਆਂ),
						'one' => q({0} ਸਦੀ),
						'other' => q({0} ਸਦੀਆਂ),
					},
					'coordinate' => {
						'east' => q({0}ਪੂ),
						'north' => q({0}ਉ),
						'south' => q({0}ਦੱ),
						'west' => q({0}ਪੱ),
					},
					'cubic-centimeter' => {
						'name' => q(ਘਣ ਸੈਂਟੀਮੀਟਰ),
						'one' => q({0} ਘਣ ਸੈਂਟੀਮੀਟਰ),
						'other' => q({0} ਘਣ ਸੈਂਟੀਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਘਣ ਸੈਂਟੀਮੀਟਰ),
					},
					'cubic-foot' => {
						'name' => q(ਘਣ ਫੁੱਟ),
						'one' => q({0} ਘਣ ਫੁੱਟ),
						'other' => q({0} ਘਣ ਫੁੱਟ),
					},
					'cubic-inch' => {
						'name' => q(ਘਣ ਇੰਚ),
						'one' => q({0} ਘਣ ਇੰਚ),
						'other' => q({0} ਘਣ ਇੰਚ),
					},
					'cubic-kilometer' => {
						'name' => q(ਘਣ ਕਿਲੋਮੀਟਰ),
						'one' => q({0} ਘਣ ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਘਣ ਕਿਲੋਮੀਟਰ),
					},
					'cubic-meter' => {
						'name' => q(ਘਣ ਮੀਟਰ),
						'one' => q({0} ਘਣ ਮੀਟਰ),
						'other' => q({0} ਘਣ ਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਘਣ ਮੀਟਰ),
					},
					'cubic-mile' => {
						'name' => q(ਘਣ ਮੀਲ),
						'one' => q({0} ਘਣ ਮੀਲ),
						'other' => q({0} ਘਣ ਮੀਲ),
					},
					'cubic-yard' => {
						'name' => q(ਘਣ ਗਜ਼),
						'one' => q({0} ਘਣ ਗਜ਼),
						'other' => q({0} ਘਣ ਗਜ਼),
					},
					'cup' => {
						'name' => q(ਕੱਪ),
						'one' => q({0} ਕੱਪ),
						'other' => q({0} ਕੱਪ),
					},
					'cup-metric' => {
						'name' => q(ਮੀਟਰਿਕ ਕੱਪ),
						'one' => q({0} ਮੀਟਰਿਕ ਕੱਪ),
						'other' => q({0} ਮੀਟਰਿਕ ਕੱਪ),
					},
					'day' => {
						'name' => q(ਦਿਨ),
						'one' => q({0} ਦਿਨ),
						'other' => q({0} ਦਿਨ),
						'per' => q({0} ਪ੍ਰਤੀ ਦਿਨ),
					},
					'deciliter' => {
						'name' => q(ਡੈਸੀਲਿਟਰ),
						'one' => q({0} ਡੈਸੀਲਿਟਰ),
						'other' => q({0} ਡੈਸੀਲਿਟਰ),
					},
					'decimeter' => {
						'name' => q(ਡੈਸੀਮੀਟਰ),
						'one' => q({0} ਡੈਸੀਮੀਟਰ),
						'other' => q({0} ਡੈਸੀਮੀਟਰ),
					},
					'degree' => {
						'name' => q(ਡਿਗਰੀ),
						'one' => q({0} ਡਿਗਰੀ),
						'other' => q({0} ਡਿਗਰੀ),
					},
					'fahrenheit' => {
						'name' => q(ਦਰਜੇ ਫਾਰੇਨਹਾਈਟ),
						'one' => q({0} ਦਰਜਾ ਫਾਰੇਨਹਾਈਟ),
						'other' => q({0} ਦਰਜੇ ਫਾਰੇਨਹਾਈਟ),
					},
					'fathom' => {
						'name' => q(ਫ਼ੈਦਮ),
						'one' => q({0} ਫ਼ੈਦਮ),
						'other' => q({0} ਫ਼ੈਦਮ),
					},
					'fluid-ounce' => {
						'name' => q(ਤਰਲ ਔਂਸ),
						'one' => q({0} ਤਰਲ ਔਂਸ),
						'other' => q({0} ਤਰਲ ਔਂਸ),
					},
					'foodcalorie' => {
						'name' => q(ਕੈਲੋਰੀਆਂ),
						'one' => q({0} ਕੈਲੋਰੀ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'foot' => {
						'name' => q(ਫੁੱਟ),
						'one' => q({0} ਫੁੱਟ),
						'other' => q({0} ਫੁੱਟ),
						'per' => q({0} ਪ੍ਰਤੀ ਫੁੱਟ),
					},
					'furlong' => {
						'name' => q(ਫਰਲਾਂਗ),
						'one' => q({0} ਫਰਲਾਂਗ),
						'other' => q({0} ਫਰਲਾਂਗ),
					},
					'g-force' => {
						'name' => q(ਗੁਰੂਤਾਕਰਸ਼ਣ ਬਲ),
						'one' => q({0} ਗੁਰੂਤਾਕਰਸ਼ਣ ਬਲ),
						'other' => q({0} ਗੁਰੂਤਾਕਰਸ਼ਣ ਬਲ),
					},
					'gallon' => {
						'name' => q(ਗੈਲਨ),
						'one' => q({0} ਗੈਲਨ),
						'other' => q({0} ਗੈਲਨ),
						'per' => q({0} ਪ੍ਰਤੀ ਗੈਲਨ),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ਗੀਗਾਬਿਟ),
						'one' => q({0} ਗੀਗਾਬਿਟ),
						'other' => q({0} ਗੀਗਾਬਿਟ),
					},
					'gigabyte' => {
						'name' => q(ਗੀਗਾਬਾਇਟ),
						'one' => q({0} ਗੀਗਾਬਾਇਟ),
						'other' => q({0} ਗੀਗਾਬਾਇਟ),
					},
					'gigahertz' => {
						'name' => q(ਗੀਗਾਹਰਟਜ਼),
						'one' => q({0} ਗੀਗਾਹਰਟਜ਼),
						'other' => q({0} ਗੀਗਾਹਰਟਜ਼),
					},
					'gigawatt' => {
						'name' => q(ਗੀਗਾਵਾਟ),
						'one' => q({0} ਗੀਗਾਵਾਟ),
						'other' => q({0} ਗੀਗਾਵਾਟ),
					},
					'gram' => {
						'name' => q(ਗ੍ਰਾਮ),
						'one' => q({0} ਗ੍ਰਾਮ),
						'other' => q({0} ਗ੍ਰਾਮ),
						'per' => q({0} ਪ੍ਰਤੀ ਗ੍ਰਾਮ),
					},
					'hectare' => {
						'name' => q(ਹੈਕਟੇਅਰ),
						'one' => q({0} ਹੈਕਟੇਅਰ),
						'other' => q({0} ਹੈਕਟੇਅਰ),
					},
					'hectoliter' => {
						'name' => q(ਹੈਕਟੋਲਿਟਰ),
						'one' => q({0} ਹੈਕਟੋਲਿਟਰ),
						'other' => q({0} ਹੈਕਟੋਲਿਟਰ),
					},
					'hectopascal' => {
						'name' => q(ਹੈਕਟੋਪਾਸਕਲ),
						'one' => q({0} ਹੈਕਟੋਪਾਸਕਲ),
						'other' => q({0} ਹੈਕਟੋਪਾਸਕਲ),
					},
					'hertz' => {
						'name' => q(ਹਰਟਜ਼),
						'one' => q({0} ਹਰਟਜ਼),
						'other' => q({0} ਹਰਟਜ਼),
					},
					'horsepower' => {
						'name' => q(ਹੌਰਸਪਾਵਰ),
						'one' => q({0} ਹੌਰਸਪਾਵਰ),
						'other' => q({0} ਹੌਰਸਪਾਵਰ),
					},
					'hour' => {
						'name' => q(ਘੰਟੇ),
						'one' => q({0} ਘੰਟਾ),
						'other' => q({0} ਘੰਟੇ),
						'per' => q({0} ਪ੍ਰਤੀ ਘੰਟਾ),
					},
					'inch' => {
						'name' => q(ਇੰਚ),
						'one' => q({0} ਇੰਚ),
						'other' => q({0} ਇੰਚ),
						'per' => q({0} ਪ੍ਰਤੀ ਇੰਚ),
					},
					'inch-hg' => {
						'name' => q(ਇੰਚ ਪਾਰਾ),
						'one' => q({0} ਇੰਚ ਪਾਰਾ),
						'other' => q({0} ਇੰਚ ਪਾਰਾ),
					},
					'joule' => {
						'name' => q(ਜੂਲ),
						'one' => q({0} ਜੂਲ),
						'other' => q({0} ਜੂਲ),
					},
					'karat' => {
						'name' => q(ਕੇਰਟ),
						'one' => q({0} ਕੇਰਟ),
						'other' => q({0} ਕੇਰਟ),
					},
					'kelvin' => {
						'name' => q(ਕੈਲਵਿਨ),
						'one' => q({0} ਕੈਲਵਿਨ),
						'other' => q({0} ਕੈਲਵਿਨ),
					},
					'kilobit' => {
						'name' => q(ਕਿਲੋਬਿਟ),
						'one' => q({0} ਕਿਲੋਬਿਟ),
						'other' => q({0} ਕਿਲੋਬਿਟ),
					},
					'kilobyte' => {
						'name' => q(ਕਿਲੋਬਾਇਟ),
						'one' => q({0} ਕਿਲੋਬਾਇਟ),
						'other' => q({0} ਕਿਲੋਬਾਇਟ),
					},
					'kilocalorie' => {
						'name' => q(ਕਿਲੋਕੈਲੋਰੀਆਂ),
						'one' => q({0} ਕਿਲੋਕੈਲੋਰੀ),
						'other' => q({0} ਕਿਲੋਕੈਲੋਰੀਆਂ),
					},
					'kilogram' => {
						'name' => q(ਕਿਲੋਗ੍ਰਾਮ),
						'one' => q({0} ਕਿਲੋਗ੍ਰਾਮ),
						'other' => q({0} ਕਿਲੋਗ੍ਰਾਮ),
						'per' => q({0} ਪ੍ਰਤੀ ਕਿਲੋਗ੍ਰਾਮ),
					},
					'kilohertz' => {
						'name' => q(ਕਿਲੋਹਰਟਜ਼),
						'one' => q({0} ਕਿਲੋਹਰਟਜ਼),
						'other' => q({0} ਕਿਲੋਹਰਟਜ਼),
					},
					'kilojoule' => {
						'name' => q(ਕਿਲੋਜੂਲ),
						'one' => q({0} ਕਿਲੋਜੂਲ),
						'other' => q({0} ਕਿਲੋਜੂਲ),
					},
					'kilometer' => {
						'name' => q(ਕਿਲੋਮੀਟਰ),
						'one' => q({0} ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਕਿਲੋਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਕਿਲੋਮੀਟਰ),
					},
					'kilometer-per-hour' => {
						'name' => q(ਕਿਲੋਮੀਟਰ ਪ੍ਰਤੀ ਘੰਟਾ),
						'one' => q({0} ਕਿਲੋਮੀਟਰ ਪ੍ਰਤੀ ਘੰਟਾ),
						'other' => q({0} ਕਿਲੋਮੀਟਰ ਪ੍ਰਤੀ ਘੰਟਾ),
					},
					'kilowatt' => {
						'name' => q(ਕਿਲੋਵਾਟ),
						'one' => q({0} ਕਿਲੋਵਾਟ),
						'other' => q({0} ਕਿਲੋਵਾਟ),
					},
					'kilowatt-hour' => {
						'name' => q(ਕਿਲੋਵਾਟ-ਘੰਟੇ),
						'one' => q({0} ਕਿਲੋਵਾਟ ਘੰਟਾ),
						'other' => q({0} ਕਿਲੋਵਾਟ ਘੰਟੇ),
					},
					'knot' => {
						'name' => q(ਨੌਟ),
						'one' => q({0} ਨੌਟ),
						'other' => q({0} ਨੌਟ),
					},
					'light-year' => {
						'name' => q(ਪ੍ਰਕਾਸ਼ ਸਾਲ),
						'one' => q({0} ਪ੍ਰਕਾਸ਼ ਸਾਲ),
						'other' => q({0} ਪ੍ਰਕਾਸ਼ ਸਾਲ),
					},
					'liter' => {
						'name' => q(ਲਿਟਰ),
						'one' => q({0} ਲਿਟਰ),
						'other' => q({0} ਲਿਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਲਿਟਰ),
					},
					'liter-per-100kilometers' => {
						'name' => q(ਲਿਟਰ ਪ੍ਰਤੀ 100 ਕਿਲੋਮੀਟਰ),
						'one' => q({0} ਲਿਟਰ ਪ੍ਰਤੀ 100 ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਲਿਟਰ ਪ੍ਰਤੀ 100 ਕਿਲੋਮੀਟਰ),
					},
					'liter-per-kilometer' => {
						'name' => q(ਲਿਟਰ ਪ੍ਰਤੀ ਕਿਲੋਮੀਟਰ),
						'one' => q({0} ਲਿਟਰ ਪ੍ਰਤੀ ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਲਿਟਰ ਪ੍ਰਤੀ ਕਿਲੋਮੀਟਰ),
					},
					'lux' => {
						'name' => q(ਲਕਸ),
						'one' => q({0} ਲਕਸ),
						'other' => q({0} ਲਕਸ),
					},
					'megabit' => {
						'name' => q(ਮੈਗਾਬਿਟ),
						'one' => q({0} ਮੈਗਾਬਿਟ),
						'other' => q({0} ਮੈਗਾਬਿਟ),
					},
					'megabyte' => {
						'name' => q(ਮੈਗਾਬਾਇਟ),
						'one' => q({0} ਮੈਗਾਬਾਇਟ),
						'other' => q({0} ਮੈਗਾਬਾਇਟ),
					},
					'megahertz' => {
						'name' => q(ਮੈਗਾਹਰਟਜ਼),
						'one' => q({0} ਮੈਗਾਹਰਟਜ਼),
						'other' => q({0} ਮੈਗਾਹਰਟਜ਼),
					},
					'megaliter' => {
						'name' => q(ਮੈਗਾਲਿਟਰ),
						'one' => q({0} ਮੈਗਾਲਿਟਰ),
						'other' => q({0} ਮੈਗਾਲਿਟਰ),
					},
					'megawatt' => {
						'name' => q(ਮੈਗਾਵਾਟ),
						'one' => q({0} ਮੈਗਾਵਾਟ),
						'other' => q({0} ਮੈਗਾਵਾਟ),
					},
					'meter' => {
						'name' => q(ਮੀਟਰ),
						'one' => q({0} ਮੀਟਰ),
						'other' => q({0} ਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਮੀਟਰ),
					},
					'meter-per-second' => {
						'name' => q(ਮੀਟਰ ਪ੍ਰਤੀ ਸਕਿੰਟ),
						'one' => q({0} ਮੀਟਰ ਪ੍ਰਤੀ ਸਕਿੰਟ),
						'other' => q({0} ਮੀਟਰ ਪ੍ਰਤੀ ਸਕਿੰਟ),
					},
					'meter-per-second-squared' => {
						'name' => q(ਮੀਟਰ ਪ੍ਰਤੀ ਵਰਗ ਸਕਿੰਟ),
						'one' => q({0} ਮੀਟਰ ਪ੍ਰਤੀ ਵਰਗ ਸਕਿੰਟ),
						'other' => q({0} ਮੀਟਰ ਪ੍ਰਤੀ ਵਰਗ ਸਕਿੰਟ),
					},
					'metric-ton' => {
						'name' => q(ਮੀਟਰਿਕ ਟਨ),
						'one' => q({0} ਮੀਟਰਿਕ ਟਨ),
						'other' => q({0} ਮੀਟਰਿਕ ਟਨ),
					},
					'microgram' => {
						'name' => q(ਮਾਈਕਰੋਗ੍ਰਾਮ),
						'one' => q({0} ਮਾਈਕਰੋਗ੍ਰਾਮ),
						'other' => q({0} ਮਾਈਕਰੋਗ੍ਰਾਮ),
					},
					'micrometer' => {
						'name' => q(ਮਾਈਕਰੋਮੀਟਰ),
						'one' => q({0} ਮਾਈਕਰੋਮੀਟਰ),
						'other' => q({0} ਮਾਈਕਰੋਮੀਟਰ),
					},
					'microsecond' => {
						'name' => q(ਮਾਈਕਰੋਸਕਿੰਟ),
						'one' => q({0} ਮਾਈਕਰੋਸਕਿੰਟ),
						'other' => q({0} ਮਾਈਕਰੋਸਕਿੰਟ),
					},
					'mile' => {
						'name' => q(ਮੀਲ),
						'one' => q({0} ਮੀਲ),
						'other' => q({0} ਮੀਲ),
					},
					'mile-per-gallon' => {
						'name' => q(ਮੀਲ ਪ੍ਰਤੀ ਗੈਲਨ),
						'one' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਗੈਲਨ),
						'other' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਗੈਲਨ),
					},
					'mile-per-hour' => {
						'name' => q(ਮੀਲ ਪ੍ਰਤੀ ਘੰਟਾ),
						'one' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਘੰਟਾ),
						'other' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਘੰਟਾ),
					},
					'mile-scandinavian' => {
						'name' => q(ਮੀਲ-ਸਕੈਂਡਿਨੇਵਿਆਈ),
						'one' => q({0} ਮੀਲ-ਸਕੈਂਡਿਨੇਵਿਆਈ),
						'other' => q({0} ਮੀਲ-ਸਕੈਂਡਿਨੇਵਿਆਈ),
					},
					'milliampere' => {
						'name' => q(ਮਿਲੀਐਮਪੀਅਰ),
						'one' => q({0} ਮਿਲੀਐਮਪੀਅਰ),
						'other' => q({0} ਮਿਲੀਐਮਪੀਅਰ),
					},
					'millibar' => {
						'name' => q(ਮਿਲੀਬਾਰ),
						'one' => q({0} ਮਿਲੀਬਾਰ),
						'other' => q({0} ਮਿਲੀਬਾਰ),
					},
					'milligram' => {
						'name' => q(ਮਿਲੀਗ੍ਰਾਮ),
						'one' => q({0} ਮਿਲੀਗ੍ਰਾਮ),
						'other' => q({0} ਮਿਲੀਗ੍ਰਾਮ),
					},
					'milliliter' => {
						'name' => q(ਮਿਲੀਲਿਟਰ),
						'one' => q({0} ਮਿਲੀਲਿਟਰ),
						'other' => q({0} ਮਿਲੀਲਿਟਰ),
					},
					'millimeter' => {
						'name' => q(ਮਿਲੀਮੀਟਰ),
						'one' => q({0} ਮਿਲੀਮੀਟਰ),
						'other' => q({0} ਮਿਲੀਮੀਟਰ),
					},
					'millimeter-of-mercury' => {
						'name' => q(ਮਿਲੀਮੀਟਰ ਪਾਰਾ),
						'one' => q({0} ਮਿਲੀਮੀਟਰ ਪਾਰਾ),
						'other' => q({0} ਮਿਲੀਮੀਟਰ ਪਾਰਾ),
					},
					'millisecond' => {
						'name' => q(ਮਿਲੀਸਕਿੰਟ),
						'one' => q({0} ਮਿਲੀਸਕਿੰਟ),
						'other' => q({0} ਮਿਲੀਸਕਿੰਟ),
					},
					'milliwatt' => {
						'name' => q(ਮਿਲੀਵਾਟ),
						'one' => q({0} ਮਿਲੀਵਾਟ),
						'other' => q({0} ਮਿਲੀਵਾਟ),
					},
					'minute' => {
						'name' => q(ਮਿੰਟ),
						'one' => q({0} ਮਿੰਟ),
						'other' => q({0} ਮਿੰਟ),
						'per' => q({0} ਪ੍ਰਤੀ ਮਿੰਟ),
					},
					'month' => {
						'name' => q(ਮਹੀਨੇ),
						'one' => q({0} ਮਹੀਨਾ),
						'other' => q({0} ਮਹੀਨੇ),
						'per' => q({0} ਪ੍ਰਤੀ ਮਹੀਨਾ),
					},
					'nanometer' => {
						'name' => q(ਨੈਨੋਮੀਟਰ),
						'one' => q({0} ਨੈਨੋਮੀਟਰ),
						'other' => q({0} ਨੈਨੋਮੀਟਰ),
					},
					'nanosecond' => {
						'name' => q(ਨੈਨੋਸਕਿੰਟ),
						'one' => q({0} ਨੈਨੋਸਕਿੰਟ),
						'other' => q({0} ਨੈਨੋਸਕਿੰਟ),
					},
					'nautical-mile' => {
						'name' => q(ਨੋਟੀਕਲ ਮੀਲ),
						'one' => q({0} ਨੋਟੀਕਲ ਮੀਲ),
						'other' => q({0} ਨੋਟੀਕਲ ਮੀਲ),
					},
					'ohm' => {
						'name' => q(ਓਹਮ),
						'one' => q({0} ਓਹਮ),
						'other' => q({0} ਓਹਮ),
					},
					'ounce' => {
						'name' => q(ਔਂਸ),
						'one' => q({0} ਔਂਸ),
						'other' => q({0} ਔਂਸ),
						'per' => q({0} ਪ੍ਰਤੀ ਔਂਸ),
					},
					'ounce-troy' => {
						'name' => q(ਟਰੌਏ ਔਂਸ),
						'one' => q({0} ਟਰੌਏ ਔਂਸ),
						'other' => q({0} ਟਰੌਏ ਔਂਸ),
					},
					'parsec' => {
						'name' => q(ਪਾਸੈੱਕ),
						'one' => q({0} ਪਾਸੈੱਕ),
						'other' => q({0} ਪਾਸੈੱਕ),
					},
					'per' => {
						'1' => q({0} ਪ੍ਰਤੀ {1}),
					},
					'picometer' => {
						'name' => q(ਪਿਕੋਮੀਟਰ),
						'one' => q({0} ਪਿਕੋਮੀਟਰ),
						'other' => q({0} ਪਿਕੋਮੀਟਰ),
					},
					'pint' => {
						'name' => q(ਪਿੰਟ),
						'one' => q({0} ਪਿੰਟ),
						'other' => q({0} ਪਿੰਟ),
					},
					'pint-metric' => {
						'name' => q(ਮੀਟਰਿਕ ਪਿੰਟ),
						'one' => q({0} ਮੀਟਰਿਕ ਪਿੰਟ),
						'other' => q({0} ਮੀਟਰਿਕ ਪਿੰਟ),
					},
					'pound' => {
						'name' => q(ਪੌਂਡ),
						'one' => q({0} ਪੌਂਡ),
						'other' => q({0} ਪੌਂਡ),
						'per' => q({0} ਪ੍ਰਤੀ ਪੌਂਡ),
					},
					'pound-per-square-inch' => {
						'name' => q(ਪੌਂਡ ਪ੍ਰਤੀ ਵਰਗ ਇੰਚ),
						'one' => q({0} ਪੌਂਡ ਪ੍ਰਤੀ ਵਰਗ ਇੰਚ),
						'other' => q({0} ਪੌਂਡ ਪ੍ਰਤੀ ਵਰਗ ਇੰਚ),
					},
					'quart' => {
						'name' => q(ਕੁਆਟ),
						'one' => q({0} ਕੁਆਟ),
						'other' => q({0} ਕੁਆਟ),
					},
					'radian' => {
						'name' => q(ਰੇਡੀਅਨ),
						'one' => q({0} ਰੇਡੀਅਨ),
						'other' => q({0} ਰੇਡੀਅਨ),
					},
					'revolution' => {
						'name' => q(ਪਰਿਕਰਮਾ),
						'one' => q({0} ਪਰਿਕਰਮਾ),
						'other' => q({0} ਪਰਿਕਰਮਾ),
					},
					'second' => {
						'name' => q(ਸਕਿੰਟ),
						'one' => q({0} ਸਕਿੰਟ),
						'other' => q({0} ਸਕਿੰਟ),
						'per' => q({0} ਪ੍ਰਤੀ ਸਕਿੰਟ),
					},
					'square-centimeter' => {
						'name' => q(ਵਰਗ ਸੈਂਟੀਮੀਟਰ),
						'one' => q({0} ਵਰਗ ਸੈਂਟੀਮੀਟਰ),
						'other' => q({0} ਵਰਗ ਸੈਂਟੀਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਵਰਗ ਸੈਂਟੀਮੀਟਰ),
					},
					'square-foot' => {
						'name' => q(ਵਰਗ ਫੁੱਟ),
						'one' => q({0} ਵਰਗ ਫੁੱਟ),
						'other' => q({0} ਵਰਗ ਫੁੱਟ),
					},
					'square-inch' => {
						'name' => q(ਵਰਗ ਇੰਚ),
						'one' => q({0} ਵਰਗ ਇੰਚ),
						'other' => q({0} ਵਰਗ ਇੰਚ),
						'per' => q({0} ਪ੍ਰਤੀ ਵਰਗ ਇੰਚ),
					},
					'square-kilometer' => {
						'name' => q(ਵਰਗ ਕਿਲੋਮੀਟਰ),
						'one' => q({0} ਵਰਗ ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਵਰਗ ਕਿਲੋਮੀਟਰ),
					},
					'square-meter' => {
						'name' => q(ਵਰਗ ਮੀਟਰ),
						'one' => q({0} ਵਰਗ ਮੀਟਰ),
						'other' => q({0} ਵਰਗ ਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਵਰਗ ਮੀਟਰ),
					},
					'square-mile' => {
						'name' => q(ਵਰਗ ਮੀਲ),
						'one' => q({0} ਵਰਗ ਮੀਲ),
						'other' => q({0} ਵਰਗ ਮੀਲ),
					},
					'square-yard' => {
						'name' => q(ਵਰਗ ਗਜ਼),
						'one' => q({0} ਵਰਗ ਗਜ਼),
						'other' => q({0} ਵਰਗ ਗਜ਼),
					},
					'stone' => {
						'name' => q(ਸਟੋਨ),
						'one' => q({0} ਸਟੋਨ),
						'other' => q({0} ਸਟੋਨ),
					},
					'tablespoon' => {
						'name' => q(ਟੇਬਲ ਸਪੂਨ),
						'one' => q({0} ਟੇਬਲ ਸਪੂਨ),
						'other' => q({0} ਟੇਬਲ ਸਪੂਨ),
					},
					'teaspoon' => {
						'name' => q(ਟੀ ਸਪੂਨ),
						'one' => q({0} ਟੀ ਸਪੂਨ),
						'other' => q({0} ਟੀ ਸਪੂਨ),
					},
					'terabit' => {
						'name' => q(ਟੇਰਾਬਿਟ),
						'one' => q({0} ਟੇਰਾਬਿਟ),
						'other' => q({0} ਟੇਰਾਬਿਟ),
					},
					'terabyte' => {
						'name' => q(ਟੇਰਾਬਾਇਟ),
						'one' => q({0} ਟੇਰਾਬਾਇਟ),
						'other' => q({0} ਟੇਰਾਬਾਇਟ),
					},
					'ton' => {
						'name' => q(ਟਨ),
						'one' => q({0} ਟਨ),
						'other' => q({0} ਟਨ),
					},
					'volt' => {
						'name' => q(ਵੋਲਟ),
						'one' => q({0} ਵੋਲਟ),
						'other' => q({0} ਵੋਲਟ),
					},
					'watt' => {
						'name' => q(ਵਾਟ),
						'one' => q({0} ਵਾਟ),
						'other' => q({0} ਵਾਟ),
					},
					'week' => {
						'name' => q(ਹਫ਼ਤੇ),
						'one' => q({0} ਹਫ਼ਤਾ),
						'other' => q({0} ਹਫ਼ਤੇ),
						'per' => q({0} ਪ੍ਰਤੀ ਹਫ਼ਤਾ),
					},
					'yard' => {
						'name' => q(ਗਜ਼),
						'one' => q({0} ਗਜ਼),
						'other' => q({0} ਗਜ਼),
					},
					'year' => {
						'name' => q(ਸਾਲ),
						'one' => q({0} ਸਾਲ),
						'other' => q({0} ਸਾਲ),
						'per' => q({0} ਪ੍ਰਤੀ ਸਾਲ),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0}ਏਕੜ),
						'other' => q({0}ਏਕੜ),
					},
					'acre-foot' => {
						'one' => q({0}ਏਕੜ ਫੁੱਟ),
						'other' => q({0}ਏਕੜ ਫੁੱਟ),
					},
					'ampere' => {
						'one' => q({0}A),
						'other' => q({0}A),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'one' => q({0} au),
						'other' => q({0} au),
					},
					'bit' => {
						'one' => q({0}ਬਿਟ),
						'other' => q({0}ਬਿਟ),
					},
					'bushel' => {
						'name' => q(ਬੁਸ਼ਲ),
						'one' => q({0}ਬੁਸ਼ਲ),
						'other' => q({0}ਬੁਸ਼ਲ),
					},
					'byte' => {
						'one' => q({0}ਬਾਇਟ),
						'other' => q({0}ਬਾਇਟ),
					},
					'calorie' => {
						'one' => q({0} ਕੈਲੋਰੀਆਂ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'one' => q({0} ਸੈਂ.ਲਿ.),
						'other' => q({0} ਸੈਂ.ਲਿ.),
					},
					'centimeter' => {
						'name' => q(ਸੈਂ.ਮੀ.),
						'one' => q({0}ਸੈਂ.ਮੀ.),
						'other' => q({0}ਸੈਂ.ਮੀ.),
					},
					'coordinate' => {
						'east' => q({0}ਪੂ),
						'north' => q({0}ਉ),
						'south' => q({0}ਦੱ),
						'west' => q({0}ਪੱ),
					},
					'cubic-centimeter' => {
						'one' => q({0}ਸੈਮੀ³),
						'other' => q({0}ਸੈਮੀ³),
					},
					'cubic-foot' => {
						'one' => q({0}ਫੁੱਟ³),
						'other' => q({0}ਫੁੱਟ³),
					},
					'cubic-inch' => {
						'one' => q({0}ਇੰਚ³),
						'other' => q({0}ਇੰਚ³),
					},
					'cubic-kilometer' => {
						'one' => q({0}ਕਿਮੀ³),
						'other' => q({0}ਕਿਮੀ³),
					},
					'cubic-meter' => {
						'one' => q({0}ਮੀ³),
						'other' => q({0}ਮੀ³),
					},
					'cubic-mile' => {
						'one' => q({0}ਮੀਲ³),
						'other' => q({0}ਮੀਲ³),
					},
					'cubic-yard' => {
						'one' => q({0}ਗਜ਼³),
						'other' => q({0}ਗਜ਼³),
					},
					'cup' => {
						'one' => q({0}ਕੱਪ),
						'other' => q({0}ਕੱਪ),
					},
					'day' => {
						'name' => q(ਦਿਨ),
						'one' => q({0} ਦਿਨ),
						'other' => q({0} ਦਿਨ),
					},
					'deciliter' => {
						'one' => q({0} ਡੈ.ਲਿ.),
						'other' => q({0} ਡੈ.ਲਿ.),
					},
					'decimeter' => {
						'one' => q({0} ਡੈ.ਮੀ.),
						'other' => q({0} ਡੈ.ਮੀ.),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fathom' => {
						'name' => q(ਫ਼ੈਦਮ),
						'one' => q({0} ਫ਼ੈਦਮ),
						'other' => q({0} ਫ਼ੈਦਮ),
					},
					'fluid-ounce' => {
						'one' => q({0} ਤ. ਔਂਸ),
						'other' => q({0} ਤ. ਔਂਸ),
					},
					'foodcalorie' => {
						'one' => q({0} ਕੈਲੋਰੀਆਂ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'foot' => {
						'one' => q({0}'),
						'other' => q({0}'),
					},
					'furlong' => {
						'name' => q(ਫਰਲਾਂਗ),
						'one' => q({0} ਫਰਲਾਂਗ),
						'other' => q({0} ਫਰਲਾਂਗ),
					},
					'g-force' => {
						'one' => q({0}G),
						'other' => q({0}Gs),
					},
					'gallon' => {
						'one' => q({0}ਗੈਲਨ),
						'other' => q({0}ਗੈਲਨ),
					},
					'gigabit' => {
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'one' => q({0}GHz),
						'other' => q({0}GHz),
					},
					'gigawatt' => {
						'one' => q({0} ਗੀ.ਵਾਟ),
						'other' => q({0} ਗੀ.ਵਾਟ),
					},
					'gram' => {
						'name' => q(ਗ੍ਰਾਮ),
						'one' => q({0} ਗ੍ਰਾ.),
						'other' => q({0} ਗ੍ਰਾ.),
					},
					'hectare' => {
						'one' => q({0}ਹੈਕ),
						'other' => q({0}ਹੈਕ),
					},
					'hectoliter' => {
						'one' => q({0} ਹੈ.ਲਿ.),
						'other' => q({0} ਹੈ.ਲਿ.),
					},
					'hectopascal' => {
						'one' => q({0} ਹੈ.ਪਾ.),
						'other' => q({0} ਹੈ.ਪਾ.),
					},
					'hertz' => {
						'one' => q({0}Hz),
						'other' => q({0}Hz),
					},
					'horsepower' => {
						'one' => q({0}hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(ਘੰਟਾ),
						'one' => q({0} ਘੰਟਾ),
						'other' => q({0} ਘੰਟੇ),
					},
					'inch' => {
						'one' => q({0}"),
						'other' => q({0}"),
					},
					'inch-hg' => {
						'one' => q({0}" ਪਾਰਾ),
						'other' => q({0}" ਪਾਰਾ),
					},
					'joule' => {
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'one' => q({0} ਕੇਰਟ),
						'other' => q({0} ਕੇਰਟ),
					},
					'kelvin' => {
						'one' => q({0}°K),
						'other' => q({0}°K),
					},
					'kilobit' => {
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'one' => q({0}ਕਿ.ਕੈਲੋਰੀਆਂ),
						'other' => q({0}ਕਿ.ਕੈਲੋਰੀਆਂ),
					},
					'kilogram' => {
						'name' => q(ਕਿ ਗ੍ਰਾ),
						'one' => q({0} ਕਿ.ਗ੍ਰਾ.),
						'other' => q({0} ਕਿ.ਗ੍ਰਾ.),
					},
					'kilohertz' => {
						'one' => q({0}kHz),
						'other' => q({0}kHz),
					},
					'kilojoule' => {
						'one' => q({0} ਕਿ.ਜੂਲ),
						'other' => q({0} ਕਿ.ਜੂਲ),
					},
					'kilometer' => {
						'name' => q(ਕਿ.ਮੀ.),
						'one' => q({0} ਕਿ.ਮੀ.),
						'other' => q({0} ਕਿ.ਮੀ.),
					},
					'kilometer-per-hour' => {
						'name' => q(ਕਿ.ਮੀ./ਘੰਟਾ),
						'one' => q({0} ਕਿ.ਪ੍ਰ.ਘੰ.),
						'other' => q({0} ਕਿ.ਪ੍ਰ.ਘੰ.),
					},
					'kilowatt' => {
						'one' => q({0} ਕਿ. ਵਾਟ),
						'other' => q({0} ਕਿ. ਵਾਟ),
					},
					'kilowatt-hour' => {
						'one' => q({0} ਕਿ.ਵਾ.ਘੰ.),
						'other' => q({0} ਕਿ.ਵਾ.ਘੰ.),
					},
					'light-year' => {
						'one' => q({0} ਪ੍ਰ.ਸ.),
						'other' => q({0} ਪ੍ਰ.ਸ.),
					},
					'liter' => {
						'name' => q(ਲਿਟਰ),
						'one' => q({0} ਲਿ.),
						'other' => q({0} ਲਿ.),
					},
					'liter-per-100kilometers' => {
						'name' => q(ਲਿ./100ਕਿ.ਮੀ.),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'one' => q({0}ਲਿ./ਕਿ.ਮੀ.),
						'other' => q({0}ਲਿ./ਕਿ.ਮੀ.),
					},
					'lux' => {
						'one' => q({0} ਲਕਸ),
						'other' => q({0} ਲਕਸ),
					},
					'megabit' => {
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'one' => q({0}MHz),
						'other' => q({0}MHz),
					},
					'megaliter' => {
						'one' => q({0} ਮੈ.ਲਿ.),
						'other' => q({0} ਮੈ.ਲਿ.),
					},
					'megawatt' => {
						'one' => q({0} ਮੈ.ਵਾਟ),
						'other' => q({0} ਮੈ.ਵਾਟ),
					},
					'meter' => {
						'name' => q(ਮੀਟਰ),
						'one' => q({0} ਮੀ.),
						'other' => q({0} ਮੀ.),
					},
					'meter-per-second' => {
						'one' => q({0}ਮੀ/ਸ),
						'other' => q({0}ਮੀ/ਸ),
					},
					'meter-per-second-squared' => {
						'one' => q({0}ਮੀ/ਸ²),
						'other' => q({0}ਮੀ/ਸ²),
					},
					'micrometer' => {
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'one' => q({0} ਮੀਲ),
						'other' => q({0} ਮੀਲ),
					},
					'mile-per-gallon' => {
						'one' => q({0} ਮੀ.ਪ੍ਰ.ਗੈ.),
						'other' => q({0} ਮੀ.ਪ੍ਰ.ਗੈ.),
					},
					'mile-per-hour' => {
						'one' => q({0} ਮੀ.ਪ੍ਰ.ਘੰ.),
						'other' => q({0} ਮੀ.ਪ੍ਰ.ਘੰ.),
					},
					'milliampere' => {
						'one' => q({0}mA),
						'other' => q({0}mA),
					},
					'millibar' => {
						'one' => q({0} ਮਿ.ਬਾ.),
						'other' => q({0} ਮਿ.ਬਾ.),
					},
					'milliliter' => {
						'one' => q({0} ਮਿ.ਲਿ.),
						'other' => q({0} ਮਿ.ਲਿ.),
					},
					'millimeter' => {
						'name' => q(ਮਿ.ਮੀ.),
						'one' => q({0} ਮਿ.ਮੀ.),
						'other' => q({0} ਮਿ.ਮੀ.),
					},
					'millimeter-of-mercury' => {
						'one' => q({0} ਮਿ.ਮੀ. ਪਾਰਾ),
						'other' => q({0} ਮਿ.ਮੀ. ਪਾਰਾ),
					},
					'millisecond' => {
						'name' => q(ਮਿਲੀਸਕਿੰਟ),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'milliwatt' => {
						'one' => q({0} ਮਿ.ਵਾਟ),
						'other' => q({0} ਮਿ.ਵਾਟ),
					},
					'minute' => {
						'name' => q(ਮਿੰਟ),
						'one' => q({0} ਮਿੰਟ),
						'other' => q({0} ਮਿੰਟ),
					},
					'month' => {
						'name' => q(ਮਹੀਨਾ),
						'one' => q({0} ਮਹੀਨਾ),
						'other' => q({0} ਮਹੀਨੇ),
					},
					'nanometer' => {
						'one' => q({0} ਨੈ.ਮੀ.),
						'other' => q({0} ਨੈ.ਮੀ.),
					},
					'nanosecond' => {
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'one' => q({0} ਨੋ.ਮੀਲ),
						'other' => q({0} ਨੋ.ਮੀਲ),
					},
					'ohm' => {
						'one' => q({0}Ω),
						'other' => q({0}Ω),
					},
					'ounce' => {
						'one' => q({0} ਔਂਸ),
						'other' => q({0} ਔਂਸ),
					},
					'ounce-troy' => {
						'one' => q({0} ਔਂਸ ਟ.),
						'other' => q({0} ਔਂਸ ਟ.),
					},
					'parsec' => {
						'one' => q({0} ਪਾਸੈੱਕ),
						'other' => q({0} ਪਾਸੈੱਕ),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} ਪਿ.ਮੀ.),
						'other' => q({0} ਪਿ.ਮੀ.),
					},
					'pint' => {
						'one' => q({0}ਪਿੰਟ),
						'other' => q({0}ਪਿੰਟ),
					},
					'pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					'pound-per-square-inch' => {
						'one' => q({0} ਪੌਂ.ਵ.ਇੰਚ),
						'other' => q({0} ਪੌਂ.ਵ.ਇੰਚ),
					},
					'quart' => {
						'one' => q({0}ਕੁਆਟ),
						'other' => q({0}ਕੁਆਟ),
					},
					'radian' => {
						'one' => q({0} ਰੇਡੀ.),
						'other' => q({0} ਰੇਡੀ.),
					},
					'second' => {
						'name' => q(ਸਕਿੰਟ),
						'one' => q({0} ਸਕਿੰਟ),
						'other' => q({0} ਸਕਿੰਟ),
					},
					'square-centimeter' => {
						'one' => q({0}ਸੈਮੀ²),
						'other' => q({0}ਸੈਮੀ²),
					},
					'square-foot' => {
						'one' => q({0}ਫੁੱਟ²),
						'other' => q({0}ਫੁੱਟ²),
					},
					'square-inch' => {
						'one' => q({0}ਇੰਚ²),
						'other' => q({0}ਇੰਚ²),
					},
					'square-kilometer' => {
						'one' => q({0} ਕਿਮੀ²),
						'other' => q({0} ਕਿਮੀ²),
					},
					'square-meter' => {
						'one' => q({0} ਮੀ²),
						'other' => q({0} ਮੀ²),
					},
					'square-mile' => {
						'one' => q({0}ਮੀਲ²),
						'other' => q({0}ਮੀਲ²),
					},
					'square-yard' => {
						'one' => q({0} ਗਜ਼²),
						'other' => q({0} ਗਜ਼²),
					},
					'stone' => {
						'name' => q(ਸਟੋਨ),
						'one' => q({0}ਸਟੋਨ),
						'other' => q({0}ਸਟੋਨ),
					},
					'terabit' => {
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'one' => q({0}ਟਨ),
						'other' => q({0}ਟਨ),
					},
					'volt' => {
						'one' => q({0}V),
						'other' => q({0}V),
					},
					'watt' => {
						'one' => q({0} ਵਾਟ),
						'other' => q({0} ਵਾਟ),
					},
					'week' => {
						'name' => q(ਹਫ਼ਤਾ),
						'one' => q({0} ਹਫ਼ਤਾ),
						'other' => q({0} ਹਫ਼ਤੇ),
					},
					'yard' => {
						'one' => q({0} ਗਜ਼),
						'other' => q({0} ਗਜ਼),
					},
					'year' => {
						'name' => q(ਸਾਲ),
						'one' => q({0} ਸਾਲ),
						'other' => q({0} ਸਾਲ),
					},
				},
				'short' => {
					'acre' => {
						'name' => q(ਏਕੜ),
						'one' => q({0} ਏਕੜ),
						'other' => q({0} ਏਕੜ),
					},
					'acre-foot' => {
						'name' => q(ਏਕੜ ਫੁੱਟ),
						'one' => q({0} ਏਕੜ ਫੁੱਟ),
						'other' => q({0} ਏਕੜ ਫੁੱਟ),
					},
					'ampere' => {
						'name' => q(ਐਮਪੀਅਰ),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(ਚਾਪ-ਮਿੰਟ),
						'one' => q({0} ਚਾਪਮਿੰਟ),
						'other' => q({0} ਚਾਪ-ਮਿੰਟ),
					},
					'arc-second' => {
						'name' => q(ਚਾਪ-ਸਕਿੰਟ),
						'one' => q({0} ਚਾਪ-ਸਕਿੰਟ),
						'other' => q({0} ਚਾਪ-ਸਕਿੰਟ),
					},
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					'bit' => {
						'name' => q(ਬਿਟ),
						'one' => q({0} ਬਿਟ),
						'other' => q({0} ਬਿਟ),
					},
					'bushel' => {
						'name' => q(ਬੁਸ਼ਲ),
						'one' => q({0} ਬੁਸ਼ਲ),
						'other' => q({0} ਬੁਸ਼ਲ),
					},
					'byte' => {
						'name' => q(ਬਾਇਟ),
						'one' => q({0} ਬਾਇਟ),
						'other' => q({0} ਬਾਇਟ),
					},
					'calorie' => {
						'name' => q(ਕੈਲੋਰੀ),
						'one' => q({0} ਕੈਲੋਰੀ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'carat' => {
						'name' => q(ਕੈਰਟ),
						'one' => q({0} ਕੈਰਟ),
						'other' => q({0} ਕੈਰਟ),
					},
					'celsius' => {
						'name' => q(ਦਰਜਾ ਸੈਲਸੀਅਸ),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(ਸੈਂ.ਲਿ.),
						'one' => q({0} ਸੈਂ.ਲਿ.),
						'other' => q({0} ਸੈਂ.ਲਿ.),
					},
					'centimeter' => {
						'name' => q(ਸੈਂ.ਮੀ.),
						'one' => q({0} ਸੈਂ.ਮੀ.),
						'other' => q({0} ਸੈਂ.ਮੀ.),
						'per' => q({0}/ਸੈਂ.ਮੀ.),
					},
					'century' => {
						'name' => q(ਸਦੀ),
						'one' => q({0} ਸਦੀ),
						'other' => q({0} ਸਦੀ),
					},
					'coordinate' => {
						'east' => q({0}ਪੂ),
						'north' => q({0}ਉ),
						'south' => q({0}ਦੱ),
						'west' => q({0}ਪੱ),
					},
					'cubic-centimeter' => {
						'name' => q(ਸੈਮੀ³),
						'one' => q({0} ਸੈਮੀ³),
						'other' => q({0} ਸੈਮੀ³),
						'per' => q({0}/ਸੈਮੀ³),
					},
					'cubic-foot' => {
						'name' => q(ਫੁੱਟ³),
						'one' => q({0} ਫੁੱਟ³),
						'other' => q({0} ਫੁੱਟ³),
					},
					'cubic-inch' => {
						'name' => q(ਇੰਚ³),
						'one' => q({0} ਇੰਚ³),
						'other' => q({0} ਇੰਚ³),
					},
					'cubic-kilometer' => {
						'name' => q(ਕਿਮੀ³),
						'one' => q({0} ਕਿਮੀ³),
						'other' => q({0} ਕਿਮੀ³),
					},
					'cubic-meter' => {
						'name' => q(ਮੀ³),
						'one' => q({0} ਮੀ³),
						'other' => q({0} ਮੀ³),
						'per' => q({0}/ਮੀ³),
					},
					'cubic-mile' => {
						'name' => q(ਮੀਲ³),
						'one' => q({0} ਮੀਲ³),
						'other' => q({0} ਮੀਲ³),
					},
					'cubic-yard' => {
						'name' => q(ਗਜ਼³),
						'one' => q({0} ਗਜ਼³),
						'other' => q({0} ਗਜ਼³),
					},
					'cup' => {
						'name' => q(ਕੱਪ),
						'one' => q({0} ਕੱਪ),
						'other' => q({0} ਕੱਪ),
					},
					'cup-metric' => {
						'name' => q(ਮੀ ਕੱਪ),
						'one' => q({0} ਮੀ ਕੱਪ),
						'other' => q({0} ਮੀ ਕੱਪ),
					},
					'day' => {
						'name' => q(ਦਿਨ),
						'one' => q({0} ਦਿਨ),
						'other' => q({0} ਦਿਨ),
						'per' => q({0}/ਦਿਨ),
					},
					'deciliter' => {
						'name' => q(ਡੈ.ਲਿ.),
						'one' => q({0} ਡੈ.ਲਿ.),
						'other' => q({0} ਡੈ.ਲਿ.),
					},
					'decimeter' => {
						'name' => q(ਡੈ.ਮੀ.),
						'one' => q({0} ਡੈ.ਮੀ.),
						'other' => q({0} ਡੈ.ਮੀ.),
					},
					'degree' => {
						'name' => q(ਡਿਗਰੀ),
						'one' => q({0} ਡਿ.),
						'other' => q({0} ਡਿ.),
					},
					'fahrenheit' => {
						'name' => q(ਦਰਜਾ ਫਾਰੇਨਹਾਈਟ),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fathom' => {
						'name' => q(ਫ਼ੈਦਮ),
						'one' => q({0} ਫ਼ੈਦਮ),
						'other' => q({0} ਫ਼ੈਦਮ),
					},
					'fluid-ounce' => {
						'name' => q(ਤ. ਔਂਸ),
						'one' => q({0} ਤ. ਔਂਸ),
						'other' => q({0} ਤ. ਔਂਸ),
					},
					'foodcalorie' => {
						'name' => q(ਕੈਲੋਰੀ),
						'one' => q({0} ਕੈਲੋਰੀ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'foot' => {
						'name' => q(ਫੁੱਟ),
						'one' => q({0} ਫੁੱਟ),
						'other' => q({0} ਫੁੱਟ),
						'per' => q({0}/ਫੁੱਟ),
					},
					'furlong' => {
						'name' => q(ਫਰਲਾਂਗ),
						'one' => q({0} ਫਰਲਾਂਗ),
						'other' => q({0} ਫਰਲਾਂਗ),
					},
					'g-force' => {
						'name' => q(ਗੁਰੂਤਾਕਰਸ਼ਣ ਬਲ),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(ਗੈਲਨ),
						'one' => q({0} ਗੈਲਨ),
						'other' => q({0} ਗੈਲਨ),
						'per' => q({0}/ਗੈਲਨ),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(Gbit),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(ਗੀਗਾਬਾਇਟ),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'name' => q(ਗੀ.ਵਾਟ),
						'one' => q({0} ਗੀ.ਵਾਟ),
						'other' => q({0} ਗੀ.ਵਾਟ),
					},
					'gram' => {
						'name' => q(ਗ੍ਰਾਮ),
						'one' => q({0} ਗ੍ਰਾ.),
						'other' => q({0} ਗ੍ਰਾ.),
						'per' => q({0}/ਗ੍ਰਾ.),
					},
					'hectare' => {
						'name' => q(ਹੈਕਟੇਅਰ),
						'one' => q({0} ਹੈਕਟੇਅਰ),
						'other' => q({0} ਹੈਕਟੇਅਰ),
					},
					'hectoliter' => {
						'name' => q(ਹੈ.ਲਿ.),
						'one' => q({0} ਹੈ.ਲਿ.),
						'other' => q({0} ਹੈ.ਲਿ.),
					},
					'hectopascal' => {
						'name' => q(ਹੈ.ਪਾ.),
						'one' => q({0} ਹੈ.ਪਾ.),
						'other' => q({0} ਹੈ.ਪਾ.),
					},
					'hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'name' => q(hp),
						'one' => q({0} ਹੌਰਸਪਾਵਰ),
						'other' => q({0} ਹੌਰਸਪਾਵਰ),
					},
					'hour' => {
						'name' => q(ਘੰਟੇ),
						'one' => q({0} ਘੰਟਾ),
						'other' => q({0} ਘੰਟੇ),
						'per' => q({0} ਪ੍ਰ.ਘੰ.),
					},
					'inch' => {
						'name' => q(ਇੰਚ),
						'one' => q({0} ਇੰਚ),
						'other' => q({0} ਇੰਚ),
						'per' => q({0}/ਇੰਚ),
					},
					'inch-hg' => {
						'name' => q(ਇੰਚ ਪਾਰਾ),
						'one' => q({0} ਇੰਚ ਪਾਰਾ),
						'other' => q({0} ਇੰਚ ਪਾਰਾ),
					},
					'joule' => {
						'name' => q(ਜੂਲ),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'name' => q(ਕੇਰਟ),
						'one' => q({0} ਕੇਰਟ),
						'other' => q({0} ਕੇਰਟ),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(ਕਿਲੋਬਿਟ),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(ਕਿਲੋਬਾਇਟ),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'name' => q(ਕਿ.ਕੈਲੋਰੀ),
						'one' => q({0} ਕਿ.ਕੈਲੋਰੀ),
						'other' => q({0} ਕਿ.ਕੈਲੋਰੀਆਂ),
					},
					'kilogram' => {
						'name' => q(ਕਿ.ਗ੍ਰਾ.),
						'one' => q({0} ਕਿ.ਗ੍ਰਾ.),
						'other' => q({0} ਕਿ.ਗ੍ਰਾ.),
						'per' => q({0}/ਕਿ.ਗ੍ਰਾ.),
					},
					'kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'name' => q(ਕਿਲੋਜੂਲ),
						'one' => q({0} ਕਿ.ਜੂਲ),
						'other' => q({0} ਕਿ.ਜੂਲ),
					},
					'kilometer' => {
						'name' => q(ਕਿ.ਮੀ.),
						'one' => q({0} ਕਿ.ਮੀ.),
						'other' => q({0} ਕਿ.ਮੀ.),
						'per' => q({0}/ਕਿ.ਮੀ.),
					},
					'kilometer-per-hour' => {
						'name' => q(ਕਿ.ਮੀ./ਘੰਟਾ),
						'one' => q({0} ਕਿ.ਪ੍ਰ.ਘੰ.),
						'other' => q({0} ਕਿ.ਪ੍ਰ.ਘੰ.),
					},
					'kilowatt' => {
						'name' => q(ਕਿ.ਵਾਟ),
						'one' => q({0} ਕਿ. ਵਾਟ),
						'other' => q({0} ਕਿ. ਵਾਟ),
					},
					'kilowatt-hour' => {
						'name' => q(ਕਿ.ਵਾ.ਘੰ.),
						'one' => q({0} ਕਿ.ਵਾ.ਘੰ.),
						'other' => q({0} ਕਿ.ਵਾ.ਘੰ.),
					},
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(ਪ੍ਰਕਾਸ਼ ਸਾਲ),
						'one' => q({0} ਪ੍ਰ.ਸ.),
						'other' => q({0} ਪ੍ਰ.ਸ.),
					},
					'liter' => {
						'name' => q(ਲਿਟਰ),
						'one' => q({0} ਲਿ.),
						'other' => q({0} ਲਿ.),
						'per' => q({0}/ਲਿ.),
					},
					'liter-per-100kilometers' => {
						'name' => q(ਲਿ./100ਕਿ.ਮੀ.),
						'one' => q({0} ਲਿ./100 ਕਿ.ਮੀ.),
						'other' => q({0} ਲਿ./100 ਕਿ.ਮੀ.),
					},
					'liter-per-kilometer' => {
						'name' => q(ਲਿਟਰ/ਕਿ.ਮੀ.),
						'one' => q({0} ਲਿ./ਕਿ.ਮੀ.),
						'other' => q({0} ਲਿ./ਕਿ.ਮੀ.),
					},
					'lux' => {
						'name' => q(ਲਕਸ),
						'one' => q({0} ਲਕਸ),
						'other' => q({0} ਲਕਸ),
					},
					'megabit' => {
						'name' => q(ਮੈਗਾਬਿਟ),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(ਮੈਗਾਬਾਇਟ),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'name' => q(ਮੈ.ਲਿ.),
						'one' => q({0} ਮੈ.ਲਿ.),
						'other' => q({0} ਮੈ.ਲਿ.),
					},
					'megawatt' => {
						'name' => q(ਮੈ.ਵਾਟ),
						'one' => q({0} ਮੈ.ਵਾਟ),
						'other' => q({0} ਮੈ.ਵਾਟ),
					},
					'meter' => {
						'name' => q(ਮੀਟਰ),
						'one' => q({0} ਮੀ.),
						'other' => q({0} ਮੀ.),
						'per' => q({0}/ਮੀ.),
					},
					'meter-per-second' => {
						'name' => q(ਮੀਟਰ/ਸਕਿੰਟ),
						'one' => q({0} ਮੀ./ਸ.),
						'other' => q({0} ਮੀ./ਸ.),
					},
					'meter-per-second-squared' => {
						'name' => q(ਮੀਟਰ/ਸਕਿੰਟ²),
						'one' => q({0} ਮੀ/ਸ²),
						'other' => q({0} ਮੀ/ਸ²),
					},
					'metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					'microgram' => {
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(ਮਾਈਕਰੋਮੀਟਰ),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(ਮਾਈਕਰੋਸਕਿੰਟ),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(ਮੀਲ),
						'one' => q({0} ਮੀਲ),
						'other' => q({0} ਮੀਲ),
					},
					'mile-per-gallon' => {
						'name' => q(ਮੀਲ/ਗੈਲਨ),
						'one' => q({0} ਮੀ.ਪ੍ਰ.ਗੈ.),
						'other' => q({0} ਮੀ.ਪ੍ਰ.ਗੈ.),
					},
					'mile-per-hour' => {
						'name' => q(ਮੀਲ/ਘੰਟਾ),
						'one' => q({0} ਮੀ.ਪ੍ਰ.ਘੰ.),
						'other' => q({0} ਮੀ.ਪ੍ਰ.ਘੰ.),
					},
					'mile-scandinavian' => {
						'name' => q(ਸਕੈਂਡ. ਮੀਲ),
						'one' => q({0} ਸਕੈਂਡ. ਮੀਲ),
						'other' => q({0} ਸਕੈਂਡ. ਮੀਲ),
					},
					'milliampere' => {
						'name' => q(ਮਿਲੀਐਮਪੀਅਰ),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'name' => q(ਮਿਲੀਬਾਰ),
						'one' => q({0} ਮਿਲੀਬਾਰ),
						'other' => q({0} ਮਿਲੀਬਾਰ),
					},
					'milligram' => {
						'name' => q(ਮਿ.ਗ੍ਰਾ.),
						'one' => q({0} ਮਿ.ਗ੍ਰਾ.),
						'other' => q({0} ਮਿ.ਗ੍ਰਾ.),
					},
					'milliliter' => {
						'name' => q(ਮਿ.ਲਿ.),
						'one' => q({0} ਮਿ.ਲਿ.),
						'other' => q({0} ਮਿ.ਲਿ.),
					},
					'millimeter' => {
						'name' => q(ਮਿ.ਮੀ.),
						'one' => q({0} ਮਿ.ਮੀ.),
						'other' => q({0} ਮਿ.ਮੀ.),
					},
					'millimeter-of-mercury' => {
						'name' => q(ਮਿ.ਮੀ. ਪਾਰਾ),
						'one' => q({0} ਮਿ.ਮੀ. ਪਾਰਾ),
						'other' => q({0} ਮਿ.ਮੀ. ਪਾਰਾ),
					},
					'millisecond' => {
						'name' => q(ਮਿਲੀਸਕਿੰਟ),
						'one' => q({0} ਮਿਲੀਸਕਿੰਟ),
						'other' => q({0} ਮਿਲੀਸਕਿੰਟ),
					},
					'milliwatt' => {
						'name' => q(ਮਿ.ਵਾਟ),
						'one' => q({0} ਮਿ.ਵਾਟ),
						'other' => q({0} ਮਿ.ਵਾਟ),
					},
					'minute' => {
						'name' => q(ਮਿੰਟ),
						'one' => q({0} ਮਿੰਟ),
						'other' => q({0} ਮਿੰਟ),
						'per' => q({0}/ਮਿੰਟ),
					},
					'month' => {
						'name' => q(ਮਹੀਨੇ),
						'one' => q({0} ਮਹੀਨਾ),
						'other' => q({0} ਮਹੀਨੇ),
						'per' => q({0}/ਮਹੀਨਾ),
					},
					'nanometer' => {
						'name' => q(ਨੈ.ਮੀ.),
						'one' => q({0} ਨੈ.ਮੀ.),
						'other' => q({0} ਨੈ.ਮੀ.),
					},
					'nanosecond' => {
						'name' => q(ਨੈਨੋਸਕਿੰਟ),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'name' => q(ਨੋ.ਮੀਲ),
						'one' => q({0} ਨੋ.ਮੀਲ),
						'other' => q({0} ਨੋ.ਮੀਲ),
					},
					'ohm' => {
						'name' => q(ਓਹਮ),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(ਔਂਸ),
						'one' => q({0} ਔਂਸ),
						'other' => q({0} ਔਂਸ),
						'per' => q({0}/ਔਂਸ),
					},
					'ounce-troy' => {
						'name' => q(ਔਂਸ ਟਰੌਏ),
						'one' => q({0} ਔਂਸ ਟ.),
						'other' => q({0} ਔਂਸ ਟ.),
					},
					'parsec' => {
						'name' => q(ਪਾਸੈੱਕ),
						'one' => q({0} ਪਾਸੈੱਕ),
						'other' => q({0} ਪਾਸੈੱਕ),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(ਪਿ.ਮੀ.),
						'one' => q({0} ਪਿਕੋਮੀਟਰ),
						'other' => q({0} ਪਿਕੋਮੀਟਰ),
					},
					'pint' => {
						'name' => q(ਪਿੰਟ),
						'one' => q({0} ਪਿੰਟ),
						'other' => q({0} ਪਿੰਟ),
					},
					'pint-metric' => {
						'name' => q(ਮੀ ਪਿੰਟ),
						'one' => q({0} ਮੀ ਪਿੰਟ),
						'other' => q({0} ਮੀ ਪਿੰਟ),
					},
					'pound' => {
						'name' => q(ਪੌਂਡ),
						'one' => q({0} ਪੌਂਡ),
						'other' => q({0} ਪੌਂਡ),
						'per' => q({0}/ਪੌਂਡ),
					},
					'pound-per-square-inch' => {
						'name' => q(ਪੌਂ.ਵ.ਇੰਚ),
						'one' => q({0} ਪੌਂ.ਵ.ਇੰਚ),
						'other' => q({0} ਪੌਂ.ਵ.ਇੰਚ),
					},
					'quart' => {
						'name' => q(ਕੁਆਟ),
						'one' => q({0} ਕੁਆਟ),
						'other' => q({0} ਕੁਆਟ),
					},
					'radian' => {
						'name' => q(ਰੇਡੀਅਨ),
						'one' => q({0} ਰੇਡੀ.),
						'other' => q({0} ਰੇਡੀ.),
					},
					'revolution' => {
						'name' => q(ਪਰਿਕਰਮਾ),
						'one' => q({0} ਪਰਿਕਰਮਾ),
						'other' => q({0} ਪਰਿਕਰਮਾ),
					},
					'second' => {
						'name' => q(ਸਕਿੰਟ),
						'one' => q({0} ਸਕਿੰਟ),
						'other' => q({0} ਸਕਿੰਟ),
						'per' => q({0} ਪ੍ਰ.ਸ.),
					},
					'square-centimeter' => {
						'name' => q(ਸੈਮੀ²),
						'one' => q({0} ਸੈਮੀ²),
						'other' => q({0} ਸੈਮੀ²),
						'per' => q({0} ਪ੍ਰਤੀ ਸੈਮੀ²),
					},
					'square-foot' => {
						'name' => q(ਵ. ਫੁੱਟ),
						'one' => q({0} ਵ. ਫੁੱਟ),
						'other' => q({0} ਵ. ਫੁੱਟ),
					},
					'square-inch' => {
						'name' => q(ਇੰਚ²),
						'one' => q({0} ਇੰਚ²),
						'other' => q({0} ਇੰਚ²),
						'per' => q({0} ਪ੍ਰਤੀ ਇੰਚ²),
					},
					'square-kilometer' => {
						'name' => q(ਕਿਮੀ²),
						'one' => q({0} ਕਿਮੀ²),
						'other' => q({0} ਕਿਮੀ²),
					},
					'square-meter' => {
						'name' => q(ਮੀਟਰ²),
						'one' => q({0} ਮੀ²),
						'other' => q({0} ਮੀ²),
						'per' => q({0} ਪ੍ਰਤੀ ਮੀ²),
					},
					'square-mile' => {
						'name' => q(ਵਰਗ ਮੀਲ),
						'one' => q({0} ਵ. ਮੀਲ),
						'other' => q({0} ਵ. ਮੀਲ),
					},
					'square-yard' => {
						'name' => q(ਗਜ਼²),
						'one' => q({0} ਗਜ਼²),
						'other' => q({0} ਗਜ਼²),
					},
					'stone' => {
						'name' => q(ਸਟੋਨ),
						'one' => q({0} ਸਟੋਨ),
						'other' => q({0} ਸਟੋਨ),
					},
					'tablespoon' => {
						'name' => q(ਟੇਬਲ ਸਪੂਨ),
						'one' => q({0} ਟੇਬਲ ਸਪੂਨ),
						'other' => q({0} ਟੇਬਲ ਸਪੂਨ),
					},
					'teaspoon' => {
						'name' => q(ਟੀ ਸਪੂਨ),
						'one' => q({0} ਟੀ ਸਪੂਨ),
						'other' => q({0} ਟੀ ਸਪੂਨ),
					},
					'terabit' => {
						'name' => q(ਟੇਰਾਬਿਟ),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(ਟੇਰਾਬਾਇਟ),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(ਟਨ),
						'one' => q({0} ਟਨ),
						'other' => q({0} ਟਨ),
					},
					'volt' => {
						'name' => q(ਵੋਲਟ),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					'watt' => {
						'name' => q(ਵਾਟ),
						'one' => q({0} ਵਾਟ),
						'other' => q({0} ਵਾਟ),
					},
					'week' => {
						'name' => q(ਹਫ਼ਤੇ),
						'one' => q({0} ਹਫ਼ਤਾ),
						'other' => q({0} ਹਫ਼ਤੇ),
						'per' => q({0}/ਹਫ਼ਤਾ),
					},
					'yard' => {
						'name' => q(ਗਜ਼),
						'one' => q({0} ਗਜ਼),
						'other' => q({0} ਗਜ਼),
					},
					'year' => {
						'name' => q(ਸਾਲ),
						'one' => q({0} ਸਾਲ),
						'other' => q({0} ਸਾਲ),
						'per' => q({0}/ਸਾਲ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ਹਾਂ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ਨਹੀਂ|ਨ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'guru',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> 'Int',
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'decimal' => q(٫),
			'exponential' => q(×۱۰^),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(؉),
			'percentSign' => q(٪),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 ਹਜ਼ਾਰ',
					'other' => '0 ਹਜ਼ਾਰ',
				},
				'10000' => {
					'one' => '00 ਹਜ਼ਾਰ',
					'other' => '00 ਹਜ਼ਾਰ',
				},
				'100000' => {
					'one' => '0 ਲੱਖ',
					'other' => '0 ਲੱਖ',
				},
				'1000000' => {
					'one' => '00 ਲੱਖ',
					'other' => '00 ਲੱਖ',
				},
				'10000000' => {
					'one' => '0 ਕਰੋੜ',
					'other' => '0 ਕਰੋੜ',
				},
				'100000000' => {
					'one' => '00 ਕਰੋੜ',
					'other' => '00 ਕਰੋੜ',
				},
				'1000000000' => {
					'one' => '0 ਅਰਬ',
					'other' => '0 ਅਰਬ',
				},
				'10000000000' => {
					'one' => '00 ਅਰਬ',
					'other' => '00 ਅਰਬ',
				},
				'100000000000' => {
					'one' => '0 ਖਰਬ',
					'other' => '0 ਖਰਬ',
				},
				'1000000000000' => {
					'one' => '00 ਖਰਬ',
					'other' => '00 ਖਰਬ',
				},
				'10000000000000' => {
					'one' => '0 ਨੀਲ',
					'other' => '0 ਨੀਲ',
				},
				'100000000000000' => {
					'one' => '00 ਨੀਲ',
					'other' => '00 ਨੀਲ',
				},
				'standard' => {
					'' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ਹਜ਼ਾਰ',
					'other' => '0 ਹਜ਼ਾਰ',
				},
				'10000' => {
					'one' => '00 ਹਜ਼ਾਰ',
					'other' => '00 ਹਜ਼ਾਰ',
				},
				'100000' => {
					'one' => '0 ਲੱਖ',
					'other' => '0 ਲੱਖ',
				},
				'1000000' => {
					'one' => '00 ਲੱਖ',
					'other' => '00 ਲੱਖ',
				},
				'10000000' => {
					'one' => '0 ਕਰੋੜ',
					'other' => '0 ਕਰੋੜ',
				},
				'100000000' => {
					'one' => '00 ਕਰੋੜ',
					'other' => '00 ਕਰੋੜ',
				},
				'1000000000' => {
					'one' => '0 ਅਰਬ',
					'other' => '0 ਅਰਬ',
				},
				'10000000000' => {
					'one' => '00 ਅਰਬ',
					'other' => '00 ਅਰਬ',
				},
				'100000000000' => {
					'one' => '0 ਖਰਬ',
					'other' => '0 ਖਰਬ',
				},
				'1000000000000' => {
					'one' => '00 ਖਰਬ',
					'other' => '00 ਖਰਬ',
				},
				'10000000000000' => {
					'one' => '0 ਨੀਲ',
					'other' => '0 ਨੀਲ',
				},
				'100000000000000' => {
					'one' => '00 ਨੀਲ',
					'other' => '00 ਨੀਲ',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ਹਜ਼ਾਰ',
					'other' => '0 ਹਜ਼ਾਰ',
				},
				'10000' => {
					'one' => '00 ਹਜ਼ਾਰ',
					'other' => '00 ਹਜ਼ਾਰ',
				},
				'100000' => {
					'one' => '0 ਲੱਖ',
					'other' => '0 ਲੱਖ',
				},
				'1000000' => {
					'one' => '00 ਲੱਖ',
					'other' => '00 ਲੱਖ',
				},
				'10000000' => {
					'one' => '0 ਕਰੋੜ',
					'other' => '0 ਕਰੋੜ',
				},
				'100000000' => {
					'one' => '00 ਕਰੋੜ',
					'other' => '00 ਕਰੋੜ',
				},
				'1000000000' => {
					'one' => '0 ਅਰਬ',
					'other' => '0 ਅਰਬ',
				},
				'10000000000' => {
					'one' => '00 ਅਰਬ',
					'other' => '00 ਅਰਬ',
				},
				'100000000000' => {
					'one' => '0 ਖਰਬ',
					'other' => '0 ਖਰਬ',
				},
				'1000000000000' => {
					'one' => '00 ਖਰਬ',
					'other' => '00 ਖਰਬ',
				},
				'10000000000000' => {
					'one' => '0 ਨੀਲ',
					'other' => '0 ਨੀਲ',
				},
				'100000000000000' => {
					'one' => '00 ਨੀਲ',
					'other' => '00 ਨੀਲ',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'' => '[#E0]',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤#,##,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ),
				'one' => q(ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ),
				'other' => q(ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ),
				'one' => q(ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ),
				'other' => q(ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(ਅਲਬਾਨੀਆਈ ਲੇਕ),
				'one' => q(ਅਲਬਾਨੀਆਈ ਲੇਕ),
				'other' => q(ਅਲਬਾਨੀਆਈ ਲੇਕ),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(ਅਰਮੀਨੀਆਈ ਦਰਮ),
				'one' => q(ਅਰਮੀਨੀਆਈ ਦਰਮ),
				'other' => q(ਅਰਮੀਨੀਆਈ ਦਰਮ),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ),
				'one' => q(ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ),
				'other' => q(ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(ਅੰਗੋਲਾ ਕਵਾਂਜਾ),
				'one' => q(ਅੰਗੋਲਾ ਕਵਾਂਜਾ),
				'other' => q(ਅੰਗੋਲਾ ਕਵਾਂਜਾ),
			},
		},
		'ARA' => {
			symbol => 'ARA',
			display_name => {
				'currency' => q(ਅਰਜਨਟੀਨੀ ਅਸਟਰਾਲ),
				'one' => q(ਅਰਜਨਟੀਨੀ ਅਸਟਰਾਲ),
				'other' => q(ਅਰਜਨਟੀਨੀ ਅਸਟਰਾਲ),
			},
		},
		'ARL' => {
			symbol => 'ARL',
			display_name => {
				'currency' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ ਲੇ \(1970–1983\)),
				'one' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ ਲੇ \(1970–1983\)),
				'other' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ ਲੇ \(1970–1983\)),
			},
		},
		'ARM' => {
			symbol => 'ARM',
			display_name => {
				'currency' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1881–1970\)),
				'one' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1881–1970\)),
				'other' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1881–1970\)),
			},
		},
		'ARP' => {
			symbol => 'ARP',
			display_name => {
				'currency' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1983–1985\)),
				'one' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1983–1985\)),
				'other' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ),
				'one' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ),
				'other' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ),
				'one' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ),
				'other' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(ਅਰੂਬਨ ਫਲੋਰਿਨ),
				'one' => q(ਅਰੂਬਨ ਫਲੋਰਿਨ),
				'other' => q(ਅਰੂਬਨ ਫਲੋਰਿਨ),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(ਅਜ਼ਰਬਾਈਜਾਨ ਮਾਨਤ),
				'one' => q(ਅਜ਼ਰਬਾਈਜਾਨ ਮਾਨਤ),
				'other' => q(ਅਜ਼ਰਬਾਈਜਾਨ ਮਾਨਤ),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣਯੋਗ ਮਾਰਕ),
				'one' => q(ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣਯੋਗ ਮਾਰਕ),
				'other' => q(ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣਯੋਗ ਮਾਰਕ),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ),
				'one' => q(ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ),
				'other' => q(ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ),
				'one' => q(ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ),
				'other' => q(ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(ਬੁਲਗਾਰੀਆਈ ਲੇਵ),
				'one' => q(ਬੁਲਗਾਰੀਆਈ ਲੇਵ),
				'other' => q(ਬੁਲਗਾਰੀਆਈ ਲੇਵ),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(ਬਹਿਰੀਨੀ ਦਿਨਾਰ),
				'one' => q(ਬਹਿਰੀਨੀ ਦਿਨਾਰ),
				'other' => q(ਬਹਿਰੀਨੀ ਦਿਨਾਰ),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ),
				'one' => q(ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ),
				'other' => q(ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(ਬਰਮੂਡਾ ਡਾਲਰ),
				'one' => q(ਬਰਮੂਡਾ ਡਾਲਰ),
				'other' => q(ਬਰਮੂਡਾ ਡਾਲਰ),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ਬਰੂਨੇਈ ਡਾਲਰ),
				'one' => q(ਬਰੂਨੇਈ ਡਾਲਰ),
				'other' => q(ਬਰੂਨੇਈ ਡਾਲਰ),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ),
				'one' => q(ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ),
				'other' => q(ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ),
			},
		},
		'BOL' => {
			symbol => 'BOL',
			display_name => {
				'currency' => q(ਬੋਲੀਵੀਆਈ ਬੋਲੀਵੀਅਨੋ \(1863–1963\)),
				'one' => q(ਬੋਲੀਵੀਆਈ ਬੋਲੀਵੀਅਨੋ \(1863–1963\)),
				'other' => q(ਬੋਲੀਵੀਆਈ ਬੋਲੀਵੀਅਨੋ \(1863–1963\)),
			},
		},
		'BOP' => {
			symbol => 'BOP',
			display_name => {
				'currency' => q(ਬੋਲੀਵੀਆਈ ਪੇਸੋ),
				'one' => q(ਬੋਲੀਵੀਆਈ ਪੇਸੋ),
				'other' => q(ਬੋਲੀਵੀਆਈ ਪੇਸੋ),
			},
		},
		'BOV' => {
			symbol => 'BOV',
			display_name => {
				'currency' => q(ਬੋਲੀਵੀਆਈ ਮਵਡੋਲ),
				'one' => q(ਬੋਲੀਵੀਆਈ ਮਵਡੋਲ),
				'other' => q(ਬੋਲੀਵੀਆਈ ਮਵਡੋਲ),
			},
		},
		'BRB' => {
			symbol => 'BRB',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਿਰੋਸ \(1967–1986\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਿਰੋਸ \(1967–1986\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਿਰੋਸ \(1967–1986\)),
			},
		},
		'BRC' => {
			symbol => 'BRC',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਾਡੂ \(1986–1989\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਾਡੂ \(1986–1989\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਾਡੂ \(1986–1989\)),
			},
		},
		'BRE' => {
			symbol => 'BRE',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1990–1993\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1990–1993\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਰੀਅਲ),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਰੀਅਲ),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਰੀਅਲ),
			},
		},
		'BRN' => {
			symbol => 'BRN',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਾਡੂ \(1989–1990\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਾਡੂ \(1989–1990\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਾਡੂ \(1989–1990\)),
			},
		},
		'BRR' => {
			symbol => 'BRR',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1993–1994\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1993–1994\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1993–1994\)),
			},
		},
		'BRZ' => {
			symbol => 'BRZ',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1942–1967\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1942–1967\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1942–1967\)),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(ਬਾਹਾਮੀਅਨ ਡਾਲਰ),
				'one' => q(ਬਾਹਾਮੀਅਨ ਡਾਲਰ),
				'other' => q(ਬਾਹਾਮੀਅਨ ਡਾਲਰ),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ),
				'one' => q(ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ),
				'other' => q(ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ਬੋਟਸਵਾਨਾ ਪੁਲਾ),
				'one' => q(ਬੋਟਸਵਾਨਾ ਪੁਲਾ),
				'other' => q(ਬੋਟਸਵਾਨਾ ਪੁਲਾ),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ),
				'one' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ),
				'other' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(ਬੇਲੀਜ਼ ਡਾਲਰ),
				'one' => q(ਬੇਲੀਜ਼ ਡਾਲਰ),
				'other' => q(ਬੇਲੀਜ਼ ਡਾਲਰ),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(ਕੇਨੇਡਿਆਈ ਡਾਲਰ),
				'one' => q(ਕੇਨੇਡਿਆਈ ਡਾਲਰ),
				'other' => q(ਕੇਨੇਡਿਆਈ ਡਾਲਰ),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ),
				'one' => q(ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ),
				'other' => q(ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(ਸਵਿਸ ਫ੍ਰੈਂਕ),
				'one' => q(ਸਵਿਸ ਫ੍ਰੈਂਕ),
				'other' => q(ਸਵਿਸ ਫ੍ਰੈਂਕ),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(ਚਿਲੀ ਪੇਸੋ),
				'one' => q(ਚਿਲੀ ਪੇਸੋ),
				'other' => q(ਚਿਲੀ ਪੇਸੋ),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(ਚੀਨੀ ਯੁਆਨ),
				'one' => q(ਚੀਨੀ ਯੁਆਨ),
				'other' => q(ਚੀਨੀ ਯੁਆਨ),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(ਕੋਲੰਬਿਆਈ ਪੇਸੋ),
				'one' => q(ਕੋਲੰਬਿਆਈ ਪੇਸੋ),
				'other' => q(ਕੋਲੰਬਿਆਈ ਪੇਸੋ),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ),
				'one' => q(ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ),
				'other' => q(ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(ਕਿਊਬਨ ਬਦਲਣਯੋਗ ਪੇਸੋ),
				'one' => q(ਕਿਊਬਨ ਬਦਲਣਯੋਗ ਪੇਸੋ),
				'other' => q(ਕਿਊਬਨ ਬਦਲਣਯੋਗ ਪੇਸੋ),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(ਕਿਊਬਨ ਪੇਸੋ),
				'one' => q(ਕਿਊਬਨ ਪੇਸੋ),
				'other' => q(ਕਿਊਬਨ ਪੇਸੋ),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(ਕੇਪ ਵਰਡੀਅਨ ਸਕੂਡੋ),
				'one' => q(ਕੇਪ ਵਰਡੀਅਨ ਸਕੂਡੋ),
				'other' => q(ਕੇਪ ਵਰਡੀਅਨ ਸਕੂਡੋ),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ),
				'one' => q(ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ),
				'other' => q(ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ),
			},
		},
		'DEM' => {
			symbol => 'DEM',
			display_name => {
				'currency' => q(ਜਰਮਨ ਮਾਰਕ),
				'one' => q(ਜਰਮਨ ਮਾਰਕ),
				'other' => q(ਜਰਮਨ ਮਾਰਕ),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ),
				'one' => q(ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ),
				'other' => q(ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ਡੈਨਿਸ਼ ਕਰੌਨ),
				'one' => q(ਡੈਨਿਸ਼ ਕਰੌਨ),
				'other' => q(ਡੈਨਿਸ਼ ਕਰੌਨ),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ਡੌਮਿਨਿਕਨ ਪੇਸੋ),
				'one' => q(ਡੌਮਿਨਿਕਨ ਪੇਸੋ),
				'other' => q(ਡੌਮਿਨਿਕਨ ਪੇਸੋ),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ),
				'one' => q(ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ),
				'other' => q(ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(ਮਿਸਰੀ ਪੌਂਡ),
				'one' => q(ਮਿਸਰੀ ਪੌਂਡ),
				'other' => q(ਮਿਸਰੀ ਪੌਂਡ),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(ਇਰੀਟ੍ਰਿਆਈ ਨਾਫ਼ਾ),
				'one' => q(ਇਰੀਟ੍ਰਿਆਈ ਨਾਫ਼ਾ),
				'other' => q(ਇਰੀਟ੍ਰਿਆਈ ਨਾਫ਼ਾ),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ਇਥੋਪੀਆਈ ਬਿਰ),
				'one' => q(ਇਥੋਪੀਆਈ ਬਿਰ),
				'other' => q(ਇਥੋਪੀਆਈ ਬਿਰ),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ਯੂਰੋ),
				'one' => q(ਯੂਰੋ),
				'other' => q(ਯੂਰੋ),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ਫ਼ਿਜ਼ੀ ਡਾਲਰ),
				'one' => q(ਫ਼ਿਜ਼ੀ ਡਾਲਰ),
				'other' => q(ਫ਼ਿਜ਼ੀ ਡਾਲਰ),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪੌਂਡ),
				'one' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪੌਂਡ),
				'other' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪੌਂਡ),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ਬ੍ਰਿਟਿਸ਼ ਪੌਂਡ),
				'one' => q(ਬ੍ਰਿਟਿਸ਼ ਪੌਂਡ),
				'other' => q(ਬ੍ਰਿਟਿਸ਼ ਪੌਂਡ),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(ਜਾਰਜੀਆਈ ਲਾਰੀ),
				'one' => q(ਜਾਰਜੀਆਈ ਲਾਰੀ),
				'other' => q(ਜਾਰਜੀਆਈ ਲਾਰੀ),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ਘਾਨਾਈ ਸੇਡੀ),
				'one' => q(ਘਾਨਾਈ ਸੇਡੀ),
				'other' => q(ਘਾਨਾਈ ਸੇਡੀ),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(ਜਿਬਰਾਲਟਰ ਪੌਂਡ),
				'one' => q(ਜਿਬਰਾਲਟਰ ਪੌਂਡ),
				'other' => q(ਜਿਬਰਾਲਟਰ ਪੌਂਡ),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(ਗੈਂਬੀਆਈ ਦਲਾਸੀ),
				'one' => q(ਗੈਂਬੀਆਈ ਦਲਾਸੀ),
				'other' => q(ਗੈਂਬੀਆਈ ਦਲਾਸੀ),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(ਗਿਨੀ ਫ੍ਰੈਂਕ),
				'one' => q(ਗਿਨੀ ਫ੍ਰੈਂਕ),
				'other' => q(ਗਿਨੀ ਫ੍ਰੈਂਕ),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ),
				'one' => q(ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ),
				'other' => q(ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(ਗੁਆਨਾਆਈ ਡਾਲਰ),
				'one' => q(ਗੁਆਨਾਆਈ ਡਾਲਰ),
				'other' => q(ਗੁਆਨਾਆਈ ਡਾਲਰ),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ),
				'one' => q(ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ),
				'other' => q(ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ),
				'one' => q(ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ),
				'other' => q(ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ),
				'one' => q(ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ),
				'other' => q(ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(ਹੈਤੀ ਗੌਰਡੇ),
				'one' => q(ਹੈਤੀ ਗੌਰਡੇ),
				'other' => q(ਹੈਤੀ ਗੌਰਡੇ),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(ਹੰਗਰੀ ਫੋਰਿੰਟ),
				'one' => q(ਹੰਗਰੀ ਫੋਰਿੰਟ),
				'other' => q(ਹੰਗਰੀ ਫੋਰਿੰਟ),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ),
				'one' => q(ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ),
				'other' => q(ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ਆਇਰਿਸ਼ ਪੌਂਡ),
				'one' => q(ਆਇਰਿਸ਼ ਪੌਂਡ),
				'other' => q(ਆਇਰਿਸ਼ ਪੌਂਡ),
			},
		},
		'ILP' => {
			symbol => 'ILP',
			display_name => {
				'currency' => q(ਇਜ਼ਰਾਈਲੀ ਪੌਂਡ),
				'one' => q(ਇਜ਼ਰਾਈਲੀ ਪੌਂਡ),
				'other' => q(ਇਜ਼ਰਾਈਲੀ ਪੌਂਡ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ),
				'one' => q(ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ),
				'other' => q(ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ਭਾਰਤੀ ਰੁਪਇਆ),
				'one' => q(ਭਾਰਤੀ ਰੁਪਇਆ),
				'other' => q(ਭਾਰਤੀ ਰੁਪਏ),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ਇਰਾਕੀ ਦਿਨਾਰ),
				'one' => q(ਇਰਾਕੀ ਦਿਨਾਰ),
				'other' => q(ਇਰਾਕੀ ਦਿਨਾਰ),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ਈਰਾਨੀ ਰਿਆਲ),
				'one' => q(ਈਰਾਨੀ ਰਿਆਲ),
				'other' => q(ਈਰਾਨੀ ਰਿਆਲ),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(ਆਈਸਲੈਂਡਿਕ ਕਰੌਨ),
				'one' => q(ਆਈਸਲੈਂਡਿਕ ਕਰੌਨ),
				'other' => q(ਆਈਸਲੈਂਡਿਕ ਕਰੌਨ),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ਜਮਾਇਕਨ ਡਾਲਰ),
				'one' => q(ਜਮਾਇਕਨ ਡਾਲਰ),
				'other' => q(ਜਮਾਇਕਨ ਡਾਲਰ),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(ਜਾਰਡਨ ਦਿਨਾਰ),
				'one' => q(ਜਾਰਡਨ ਦਿਨਾਰ),
				'other' => q(ਜਾਰਡਨ ਦਿਨਾਰ),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ਜਪਾਨੀ ਯੇਨ),
				'one' => q(ਜਪਾਨੀ ਯੇਨ),
				'other' => q(ਜਪਾਨੀ ਯੇਨ),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ),
				'one' => q(ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ),
				'other' => q(ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(ਕੰਬੋਡੀਆਈ ਰੀਅਲ),
				'one' => q(ਕੰਬੋਡੀਆਈ ਰੀਅਲ),
				'other' => q(ਕੰਬੋਡੀਆਈ ਰੀਅਲ),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(ਕੋਮੋਰੀਅਨ ਫ੍ਰੈਂਕ),
				'one' => q(ਕੋਮੋਰੀਅਨ ਫ੍ਰੈਂਕ),
				'other' => q(ਕੋਮੋਰੀਅਨ ਫ੍ਰੈਂਕ),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ),
				'one' => q(ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ),
				'other' => q(ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ),
				'one' => q(ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ),
				'other' => q(ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(ਕੁਵੈਤੀ ਦਿਨਾਰ),
				'one' => q(ਕੁਵੈਤੀ ਦਿਨਾਰ),
				'other' => q(ਕੁਵੈਤੀ ਦਿਨਾਰ),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'one' => q(ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'other' => q(ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(ਕਜ਼ਾਖਸਤਾਨੀ ਤੇਂਗੇ),
				'one' => q(ਕਜ਼ਾਖਸਤਾਨੀ ਤੇਂਗੇ),
				'other' => q(ਕਜ਼ਾਖਸਤਾਨੀ ਤੇਂਗੇ),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(ਲਾਓਟਿਆਈ ਕਿਪ),
				'one' => q(ਲਾਓਟਿਆਈ ਕਿਪ),
				'other' => q(ਲਾਓਟਿਆਈ ਕਿਪ),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ਲੈਬਨਾਨੀ ਪੌਂਡ),
				'one' => q(ਲੈਬਨਾਨੀ ਪੌਂਡ),
				'other' => q(ਲੈਬਨਾਨੀ ਪੌਂਡ),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(ਸ੍ਰੀਲੰਕਾਈ ਰੁਪਇਆ),
				'one' => q(ਸ੍ਰੀਲੰਕਾਈ ਰੁਪਇਆ),
				'other' => q(ਸ੍ਰੀਲੰਕਾਈ ਰੁਪਏ),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ),
				'one' => q(ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ),
				'other' => q(ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ),
				'one' => q(ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ),
				'other' => q(ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(ਲਾਟਵਿਆਈ ਲਾਟਸ),
				'one' => q(ਲਾਟਵਿਆਈ ਲਾਟਸ),
				'other' => q(ਲਾਟਵਿਆਈ ਲਾਟਸ),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(ਲੀਬੀਅਨ ਦਿਨਾਰ),
				'one' => q(ਲੀਬੀਅਨ ਦਿਨਾਰ),
				'other' => q(ਲੀਬੀਅਨ ਦਿਨਾਰ),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(ਮੋਰੱਕਨ ਦਿਰਹਾਮ),
				'one' => q(ਮੋਰੱਕਨ ਦਿਰਹਾਮ),
				'other' => q(ਮੋਰੱਕਨ ਦਿਰਹਾਮ),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(ਮੋਲਡੋਵਨ ਲੇਉ),
				'one' => q(ਮੋਲਡੋਵਨ ਲੇਉ),
				'other' => q(ਮੋਲਡੋਵਨ ਲੇਉ),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ),
				'one' => q(ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ),
				'other' => q(ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ),
				'one' => q(ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ),
				'other' => q(ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(ਮਿਆਂਮਾਰ ਕਿਆਤ),
				'one' => q(ਮਿਆਂਮਾਰ ਕਿਆਤ),
				'other' => q(ਮਿਆਂਮਾਰ ਕਿਆਤ),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ),
				'one' => q(ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ),
				'other' => q(ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(ਮੇਕਾਨੀ ਪਟਾਕਾ),
				'one' => q(ਮੇਕਾਨੀ ਪਟਾਕਾ),
				'other' => q(ਮੇਕਾਨੀ ਪਟਾਕਾ),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ),
				'one' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ),
				'other' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਇਆ),
				'one' => q(ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਇਆ),
				'other' => q(ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਏ),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(ਮਾਲਦੀਵੀ ਰੁਫੀਆ),
				'one' => q(ਮਾਲਦੀਵੀ ਰੁਫੀਆ),
				'other' => q(ਮਾਲਦੀਵੀ ਰੁਫੀਆ),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ),
				'one' => q(ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ),
				'other' => q(ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(ਮੈਕਸੀਕਨ ਪੇਸੋ),
				'one' => q(ਮੈਕਸੀਕਨ ਪੇਸੋ),
				'other' => q(ਮੈਕਸੀਕਨ ਪੇਸੋ),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(ਮਲੇਸ਼ੀਆਈ ਰਿੰਗਿਟ),
				'one' => q(ਮਲੇਸ਼ੀਆਈ ਰਿੰਗਿਟ),
				'other' => q(ਮਲੇਸ਼ੀਆਈ ਰਿੰਗਿਟ),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ),
				'one' => q(ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ),
				'other' => q(ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(ਨਾਮੀਬੀਆਈ ਡਾਲਰ),
				'one' => q(ਨਾਮੀਬੀਆਈ ਡਾਲਰ),
				'other' => q(ਨਾਮੀਬੀਆਈ ਡਾਲਰ),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ),
				'one' => q(ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ),
				'other' => q(ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(ਨਿਕਾਰਾਗੁਆਈ ਕੋਰਡੋਬਾ),
				'one' => q(ਨਿਕਾਰਾਗੁਆਈ ਕੋਰਡੋਬਾ),
				'other' => q(ਨਿਕਾਰਾਗੁਆਈ ਕੋਰਡੋਬਾ),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(ਨਾਰਵੇਜੀਆਈ ਕਰੌਨ),
				'one' => q(ਨਾਰਵੇਜੀਆਈ ਕਰੌਨ),
				'other' => q(ਨਾਰਵੇਜੀਆਈ ਕਰੌਨ),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(ਨੇਪਾਲੀ ਰੁਪਇਆ),
				'one' => q(ਨੇਪਾਲੀ ਰੁਪਇਆ),
				'other' => q(ਨੇਪਾਲੀ ਰੁਪਏ),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ),
				'one' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ),
				'other' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ਓਮਾਨੀ ਰਿਆਲ),
				'one' => q(ਓਮਾਨੀ ਰਿਆਲ),
				'other' => q(ਓਮਾਨੀ ਰਿਆਲ),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ),
				'one' => q(ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ),
				'other' => q(ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(ਪੇਰੂਵੀਅਨ ਨਿਊਵੋ ਸੋਲ),
				'one' => q(ਪੇਰੂਵੀਅਨ ਨਿਊਵੋ ਸੋਲ),
				'other' => q(ਪੇਰੂਵੀਅਨ ਨਿਊਵੋ ਸੋਲ),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕੀਨਾ),
				'one' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕੀਨਾ),
				'other' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕੀਨਾ),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ਫਿਲਿਪੀਨੀ ਪੇਸੋ),
				'one' => q(ਫਿਲਿਪੀਨੀ ਪੇਸੋ),
				'other' => q(ਫਿਲਿਪੀਨੀ ਪੇਸੋ),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(ਪਾਕਿਸਤਾਨੀ ਰੁਪਇਆ),
				'one' => q(ਪਾਕਿਸਤਾਨੀ ਰੁਪਇਆ),
				'other' => q(ਪਾਕਿਸਤਾਨੀ ਰੁਪਏ),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(ਪੋਲੈਂਡੀ ਜ਼ਲੌਟੀ),
				'one' => q(ਪੋਲੈਂਡੀ ਜ਼ਲੌਟੀ),
				'other' => q(ਪੋਲੈਂਡੀ ਜ਼ਲੌਟੀ),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ),
				'one' => q(ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ),
				'other' => q(ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(ਕਤਰੀ ਰਿਆਲ),
				'one' => q(ਕਤਰੀ ਰਿਆਲ),
				'other' => q(ਕਤਰੀ ਰਿਆਲ),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(ਰੋਮਾਨੀਆਈ ਲੇਉ),
				'one' => q(ਰੋਮਾਨੀਆਈ ਲੇਉ),
				'other' => q(ਰੋਮਾਨੀਆਈ ਲੇਉ),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(ਸਰਬੀਆਈ ਦਿਨਾਰ),
				'one' => q(ਸਰਬੀਆਈ ਦਿਨਾਰ),
				'other' => q(ਸਰਬੀਆਈ ਦਿਨਾਰ),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(ਰੂਸੀ ਰੂਬਲ),
				'one' => q(ਰੂਸੀ ਰੂਬਲ),
				'other' => q(ਰੂਸੀ ਰੂਬਲ),
			},
		},
		'RUR' => {
			symbol => 'р.',
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ),
				'one' => q(ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ),
				'other' => q(ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(ਸਾਊਦੀ ਰਿਆਲ),
				'one' => q(ਸਾਊਦੀ ਰਿਆਲ),
				'other' => q(ਸਾਊਦੀ ਰਿਆਲ),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'one' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'other' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(ਸੇਸ਼ਲਸ ਰੁਪਇਆ),
				'one' => q(ਸੇਸ਼ਲਸ ਰੁਪਇਆ),
				'other' => q(ਸੇਸ਼ਲਸ ਰੁਪਏ),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(ਸੂਡਾਨੀ ਪੌਂਡ),
				'one' => q(ਸੂਡਾਨੀ ਪੌਂਡ),
				'other' => q(ਸੂਡਾਨੀ ਪੌਂਡ),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(ਸਵੀਡਿਸ਼ ਕਰੋਨਾ),
				'one' => q(ਸਵੀਡਿਸ਼ ਕਰੋਨਾ),
				'other' => q(ਸਵੀਡਿਸ਼ ਕਰੋਨਾ),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(ਸਿੰਗਾਪੁਰ ਡਾਲਰ),
				'one' => q(ਸਿੰਗਾਪੁਰ ਡਾਲਰ),
				'other' => q(ਸਿੰਗਾਪੁਰ ਡਾਲਰ),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(ਸੇਂਟ ਹੇਲੇਨਾ ਪੌਂਡ),
				'one' => q(ਸੇਂਟ ਹੇਲੇਨਾ ਪੌਂਡ),
				'other' => q(ਸੇਂਟ ਹੇਲੇਨਾ ਪੌਂਡ),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ),
				'one' => q(ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ),
				'other' => q(ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(ਸੂਰੀਨਾਮੀ ਡਾਲਰ),
				'one' => q(ਸੂਰੀਨਾਮੀ ਡਾਲਰ),
				'other' => q(ਸੂਰੀਨਾਮੀ ਡਾਲਰ),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(ਦੱਖਣੀ ਸੂਡਾਨੀ ਪੌਂਡ),
				'one' => q(ਦੱਖਣੀ ਸੂਡਾਨੀ ਪੌਂਡ),
				'other' => q(ਦੱਖਣੀ ਸੂਡਾਨੀ ਪੌਂਡ),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ),
				'one' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ),
				'other' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ),
			},
		},
		'SUR' => {
			symbol => 'SUR',
			display_name => {
				'currency' => q(ਸੋਵੀਅਤ ਰੂਬਲ),
				'one' => q(ਸੋਵੀਅਤ ਰੂਬਲ),
				'other' => q(ਸੋਵੀਅਤ ਰੂਬਲ),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(ਸੀਰੀਆਈ ਪੌਂਡ),
				'one' => q(ਸੀਰੀਆਈ ਪੌਂਡ),
				'other' => q(ਸੀਰੀਆਈ ਪੌਂਡ),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ),
				'one' => q(ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ),
				'other' => q(ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(ਥਾਈ ਬਾਹਤ),
				'one' => q(ਥਾਈ ਬਾਹਤ),
				'other' => q(ਥਾਈ ਬਾਹਤ),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ),
				'one' => q(ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ),
				'other' => q(ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ),
				'one' => q(ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ),
				'other' => q(ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ),
				'one' => q(ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ),
				'other' => q(ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(ਟੌਂਗਨ ਪੈਂਗਾ),
				'one' => q(ਟੌਂਗਨ ਪੈਂਗਾ),
				'other' => q(ਟੌਂਗਨ ਪੈਂਗਾ),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(ਤੁਰਕੀ ਲੀਰਾ),
				'one' => q(ਤੁਰਕੀ ਲੀਰਾ),
				'other' => q(ਤੁਰਕੀ ਲੀਰਾ),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ),
				'one' => q(ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ),
				'other' => q(ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ),
				'one' => q(ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ),
				'other' => q(ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ),
				'one' => q(ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ),
				'other' => q(ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(ਯੂਗਾਂਡੀਆਈ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਯੂਗਾਂਡੀਆਈ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਯੂਗਾਂਡੀਆਈ ਸ਼ਿਲਿੰਗ),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(ਯੂ.ਐਸ. ਡਾਲਰ),
				'one' => q(ਯੂ.ਐਸ. ਡਾਲਰ),
				'other' => q(ਯੂ.ਐਸ. ਡਾਲਰ),
			},
		},
		'UYI' => {
			symbol => 'UYI',
		},
		'UYP' => {
			symbol => 'UYP',
			display_name => {
				'currency' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ \(1975–1993\)),
				'one' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ \(1975–1993\)),
				'other' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ),
				'one' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ),
				'other' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ),
				'one' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ),
				'other' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ),
			},
		},
		'VEB' => {
			symbol => 'VEB',
			display_name => {
				'currency' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ \(1871–2008\)),
				'one' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ \(1871–2008\)),
				'other' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ),
				'one' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ),
				'other' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ),
				'one' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ),
				'other' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ),
			},
		},
		'VNN' => {
			symbol => 'VNN',
			display_name => {
				'currency' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ \(1978–1985\)),
				'one' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ \(1978–1985\)),
				'other' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ \(1978–1985\)),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(ਵਾਨੂਆਟੂ ਵਾਟੂ),
				'one' => q(ਵਾਨੂਆਟੂ ਵਾਟੂ),
				'other' => q(ਵਾਨੂਆਟੂ ਵਾਟੂ),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(ਸਾਮੋਆਈ ਤਾਲਾ),
				'one' => q(ਸਾਮੋਆਈ ਤਾਲਾ),
				'other' => q(ਸਾਮੋਆਈ ਤਾਲਾ),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(ਫ੍ਰੈਂਕ \(CFA BEAC\)),
				'one' => q(ਫ੍ਰੈਂਕ \(CFA BEAC\)),
				'other' => q(ਫ੍ਰੈਂਕ \(CFA BEAC\)),
			},
		},
		'XAG' => {
			symbol => 'XAG',
			display_name => {
				'currency' => q(ਚਾਂਦੀ),
				'one' => q(ਚਾਂਦੀ ਦਾ ਟਰੌਏ ਔਂਸ),
				'other' => q(ਚਾਂਦੀ ਦਾ ਟਰੌਏ ਔਂਸ),
			},
		},
		'XAU' => {
			symbol => 'XAU',
			display_name => {
				'currency' => q(ਸੋਨਾ),
				'one' => q(ਸੋਨੇ ਦਾ ਟਰੌਏ ਔਂਸ),
				'other' => q(ਸੋਨੇ ਦਾ ਟਰੌਏ ਔਂਸ),
			},
		},
		'XBA' => {
			symbol => 'XBA',
		},
		'XBB' => {
			symbol => 'XBB',
			display_name => {
				'currency' => q(ਯੂਰਪੀ ਵਿੱਤੀ ਇਕਾਈ),
				'one' => q(ਯੂਰਪੀ ਵਿੱਤੀ ਇਕਾਈ),
				'other' => q(ਯੂਰਪੀ ਵਿੱਤੀ ਇਕਾਈ),
			},
		},
		'XBC' => {
			symbol => 'XBC',
		},
		'XBD' => {
			symbol => 'XBD',
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ),
				'one' => q(ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ),
				'other' => q(ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ),
			},
		},
		'XEU' => {
			symbol => 'XEU',
			display_name => {
				'currency' => q(ਯੂਰਪੀ ਮੁਦਰਾ ਇਕਾਈ),
				'one' => q(XEU),
				'other' => q(ਯੂਰਪੀ ਮੁਦਰਾ ਇਕਾਈ),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(ਪੱਛਮੀ ਅਫ਼ਰੀਕੀ \(CFA\) ਫ੍ਰੈਂਕ),
				'one' => q(ਫ੍ਰੈਂਕ \(CFA BCEAO\)),
				'other' => q(ਫ੍ਰੈਂਕ \(CFA BCEAO\)),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ਫ੍ਰੈਂਕ \(CFP\)),
				'one' => q(ਫ੍ਰੈਂਕ \(CFP\)),
				'other' => q(ਫ੍ਰੈਂਕ \(CFP\)),
			},
		},
		'XXX' => {
			symbol => 'XXX',
			display_name => {
				'currency' => q(ਅਗਿਆਤ ਮੁਦਰਾ),
				'one' => q(\(ਮੁਦਰਾ ਦੀ ਅਗਿਆਤ ਇਕਾਈ\)),
				'other' => q(\(ਅਗਿਆਤ ਮੁਦਰਾ\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(ਯਮਨੀ ਰਿਆਲ),
				'one' => q(ਯਮਨੀ ਰਿਆਲ),
				'other' => q(ਯਮਨੀ ਰਿਆਲ),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ),
				'one' => q(ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ),
				'other' => q(ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ),
				'one' => q(ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ),
				'other' => q(ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ਜਨ',
							'ਫ਼ਰ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾ',
							'ਅਗ',
							'ਸਤੰ',
							'ਅਕਤੂ',
							'ਨਵੰ',
							'ਦਸੰ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ਜ',
							'ਫ਼',
							'ਮਾ',
							'ਅ',
							'ਮ',
							'ਜੂ',
							'ਜੁ',
							'ਅ',
							'ਸ',
							'ਅ',
							'ਨ',
							'ਦ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਜਨਵਰੀ',
							'ਫ਼ਰਵਰੀ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈਲ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾਈ',
							'ਅਗਸਤ',
							'ਸਤੰਬਰ',
							'ਅਕਤੂਬਰ',
							'ਨਵੰਬਰ',
							'ਦਸੰਬਰ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ਜਨ',
							'ਫ਼ਰ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾ',
							'ਅਗ',
							'ਸਤੰ',
							'ਅਕਤੂ',
							'ਨਵੰ',
							'ਦਸੰ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ਜ',
							'ਫ਼',
							'ਮਾ',
							'ਅ',
							'ਮ',
							'ਜੂ',
							'ਜੁ',
							'ਅ',
							'ਸ',
							'ਅ',
							'ਨ',
							'ਦ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਜਨਵਰੀ',
							'ਫ਼ਰਵਰੀ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈਲ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾਈ',
							'ਅਗਸਤ',
							'ਸਤੰਬਰ',
							'ਅਕਤੂਬਰ',
							'ਨਵੰਬਰ',
							'ਦਸੰਬਰ'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ਚੇਤ',
							'ਵੈਸਾਖ',
							'ਜੇਠ',
							'ਹਾੜ',
							'ਸਾਉਣ',
							'ਭਾਦੋਂ',
							'ਅੱਸੂ',
							'ਕੱਤਕ',
							'ਮੱਘਰ',
							'ਪੋਹ',
							'ਮਾਘ',
							'ਫੱਗਣ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'੧',
							'੨',
							'੩',
							'੪',
							'੫',
							'੬',
							'੭',
							'੮',
							'੯',
							'੧੦',
							'੧੧',
							'੧੨'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਚੇਤ',
							'ਵੈਸਾਖ',
							'ਜੇਠ',
							'ਹਾੜ',
							'ਸਾਉਣ',
							'ਭਾਦੋਂ',
							'ਅੱਸੂ',
							'ਕੱਤਕ',
							'ਮੱਘਰ',
							'ਪੋਹ',
							'ਮਾਘ',
							'ਫੱਗਣ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ਚੇਤ',
							'ਵੈਸਾਖ',
							'ਜੇਠ',
							'ਹਾੜ',
							'ਸਾਉਣ',
							'ਭਾਦੋਂ',
							'ਅੱਸੂ',
							'ਕੱਤਕ',
							'ਮੱਘਰ',
							'ਪੋਹ',
							'ਮਾਘ',
							'ਫੱਗਣ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'੧',
							'੨',
							'੩',
							'੪',
							'੫',
							'੬',
							'੭',
							'੮',
							'੯',
							'੧੦',
							'੧੧',
							'੧੨'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਚੇਤ',
							'ਵੈਸਾਖ',
							'ਜੇਠ',
							'ਹਾੜ',
							'ਸਾਉਣ',
							'ਭਾਦੋਂ',
							'ਅੱਸੂ',
							'ਕੱਤਕ',
							'ਮੱਘਰ',
							'ਪੋਹ',
							'ਮਾਘ',
							'ਫੱਗਣ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ਸੋਮ',
						tue => 'ਮੰਗਲ',
						wed => 'ਬੁੱਧ',
						thu => 'ਵੀਰ',
						fri => 'ਸ਼ੁੱਕਰ',
						sat => 'ਸ਼ਨਿੱਚਰ',
						sun => 'ਐਤ'
					},
					narrow => {
						mon => 'ਸੋ',
						tue => 'ਮੰ',
						wed => 'ਬੁੱ',
						thu => 'ਵੀ',
						fri => 'ਸ਼ੁੱ',
						sat => 'ਸ਼',
						sun => 'ਐ'
					},
					short => {
						mon => 'ਸੋਮ',
						tue => 'ਮੰਗ',
						wed => 'ਬੁੱਧ',
						thu => 'ਵੀਰ',
						fri => 'ਸ਼ੁੱਕ',
						sat => 'ਸ਼ਨਿੱ',
						sun => 'ਐਤ'
					},
					wide => {
						mon => 'ਸੋਮਵਾਰ',
						tue => 'ਮੰਗਲਵਾਰ',
						wed => 'ਬੁੱਧਵਾਰ',
						thu => 'ਵੀਰਵਾਰ',
						fri => 'ਸ਼ੁੱਕਰਵਾਰ',
						sat => 'ਸ਼ਨਿੱਚਰਵਾਰ',
						sun => 'ਐਤਵਾਰ'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ਸੋਮ',
						tue => 'ਮੰਗਲ',
						wed => 'ਬੁੱਧ',
						thu => 'ਵੀਰ',
						fri => 'ਸ਼ੁੱਕਰ',
						sat => 'ਸ਼ਨਿੱਚਰ',
						sun => 'ਐਤ'
					},
					narrow => {
						mon => 'ਸੋ',
						tue => 'ਮੰ',
						wed => 'ਬੁੱ',
						thu => 'ਵੀ',
						fri => 'ਸ਼ੁੱ',
						sat => 'ਸ਼',
						sun => 'ਐ'
					},
					short => {
						mon => 'ਸੋਮ',
						tue => 'ਮੰਗ',
						wed => 'ਬੁੱਧ',
						thu => 'ਵੀਰ',
						fri => 'ਸ਼ੁੱਕ',
						sat => 'ਸ਼ਨਿੱ',
						sun => 'ਐਤ'
					},
					wide => {
						mon => 'ਸੋਮਵਾਰ',
						tue => 'ਮੰਗਲਵਾਰ',
						wed => 'ਬੁੱਧਵਾਰ',
						thu => 'ਵੀਰਵਾਰ',
						fri => 'ਸ਼ੁੱਕਰਵਾਰ',
						sat => 'ਸ਼ਨਿੱਚਰਵਾਰ',
						sun => 'ਐਤਵਾਰ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ਤਿਮਾਹੀ1',
						1 => 'ਤਿਮਾਹੀ2',
						2 => 'ਤਿਮਾਹੀ3',
						3 => 'ਤਿਮਾਹੀ4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ਪਹਿਲੀ ਤਿਮਾਹੀ',
						1 => 'ਦੂਜੀ ਤਿਮਾਹੀ',
						2 => 'ਤੀਜੀ ਤਿਮਾਹੀ',
						3 => 'ਚੌਥੀ ਤਿਮਾਹੀ'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ਤਿਮਾਹੀ1',
						1 => 'ਤਿਮਾਹੀ2',
						2 => 'ਤਿਮਾਹੀ3',
						3 => 'ਤਿਮਾਹੀ4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ਪਹਿਲੀ ਤਿਮਾਹੀ',
						1 => 'ਦੂਜੀ ਤਿਮਾਹੀ',
						2 => 'ਤੀਜੀ ਤਿਮਾਹੀ',
						3 => 'ਚੌਥੀ ਤਿਮਾਹੀ'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	traits		=> ['Code'],
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	handles		=> { call => 'execute_method' },
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'selection') {
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'default') {
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'selection') {
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'default') {
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'selection') {
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'default') {
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				last SWITCH;
				}
		}
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{ਪੂ.ਦੁ.},
					'pm' => q{ਬਾ.ਦੁ.},
					'night1' => q{ਰਾਤ},
					'evening1' => q{ਸ਼ਾਮ},
					'afternoon1' => q{ਦੁਪਹਿਰ},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
					'morning1' => q{ਸਵੇਰ},
				},
				'narrow' => {
					'morning1' => q{ਸਵੇਰ},
					'night1' => q{ਰਾਤ},
					'afternoon1' => q{ਦੁਪ.},
					'evening1' => q{ਸ਼ਾਮ},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
					'pm' => q{ਸ਼.},
					'am' => q{ਸ.},
				},
				'abbreviated' => {
					'evening1' => q{ਸ਼ਾਮੀਂ},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
					'afternoon1' => q{ਦੁਪਹਿਰੇ},
					'night1' => q{ਰਾਤੀਂ},
					'morning1' => q{ਸਵੇਰੇ},
					'pm' => q{ਬਾ.ਦੁ.},
					'am' => q{ਪੂ.ਦੁ.},
				},
			},
			'stand-alone' => {
				'wide' => {
					'night1' => q{ਰਾਤ},
					'evening1' => q{ਸ਼ਾਮ},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
					'afternoon1' => q{ਦੁਪਹਿਰ},
					'morning1' => q{ਸਵੇਰ},
					'pm' => q{ਬਾ.ਦੁ.},
					'am' => q{ਪੂ.ਦੁ.},
				},
				'narrow' => {
					'pm' => q{ਬਾ.ਦੁ.},
					'am' => q{ਪੂ.ਦੁ.},
					'night1' => q{ਰਾਤ},
					'evening1' => q{ਸ਼ਾਮ},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
					'afternoon1' => q{ਦੁਪਹਿਰ},
					'morning1' => q{ਸਵੇਰ},
				},
				'abbreviated' => {
					'pm' => q{ਬਾ.ਦੁ.},
					'am' => q{ਪੂ.ਦੁ.},
					'afternoon1' => q{ਦੁਪਹਿਰ},
					'evening1' => q{ਸ਼ਾਮ},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
					'night1' => q{ਰਾਤ},
					'morning1' => q{ਸਵੇਰ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ਈ. ਪੂ.',
				'1' => 'ਸੰਨ'
			},
			narrow => {
				'0' => 'ਈ. ਪੂ.',
				'1' => 'ਸੰਨ'
			},
			wide => {
				'0' => 'ਈਸਵੀ ਪੂਰਵ',
				'1' => 'ਈਸਵੀ ਸੰਨ'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ਸਾਕਾ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, dd MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{dd/MM/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/yy},
		},
		'indian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{MMM, G y},
			GyMMMEd => q{E d MMM, G y},
			GyMMMd => q{d MMM y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, dd-MM.},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			mmss => q{mm:ss},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM y},
			yMMMM => q{y MMMM},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
		'generic' => {
			E => q{ccc},
			Ed => q{E, d},
			Gy => q{G y},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM y G},
			GyMMMd => q{d MMM,y G},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			ms => q{mm:ss},
			y => q{y G},
			yMMM => q{MMM y G},
			yQQQ => q{QQQ y G},
			yyyy => q{y G},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E, d/M/y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM y G},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{d/M/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y},
				d => q{E, d MMM – E, d MMM y},
				y => q{E, d MMM y – E, d MMM y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
		'generic' => {
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y GGGGG},
				d => q{E, d/M/y – E, d/M/y GGGGG},
				y => q{E, d/M/y – E, d/M/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y G},
				d => q{E, d MMM – E, d MMM y G},
				y => q{E, d MMM y – E, d MMM y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM y G},
				d => q{d – d, MMM y G},
				y => q{d, MMM y – d, MMM y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y GGGGG},
				d => q{d/M/y – d/M/y GGGGG},
				y => q{d/M/y – d/M/y GGGGG},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} ਸਮਾਂ),
		regionFormat => q({0} ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
		regionFormat => q({0} ਮਿਆਰੀ ਸਮਾਂ),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(ਅਫ਼ਗਾਨਿਸਤਾਨ ਸਮਾਂ),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ਅਬੀਦਜਾਨ#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ਅੱਕਰਾ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ਐਡਿਸ ਅਬਾਬਾ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ਅਲਜੀਅਰਸ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ਅਸਮਾਰਾ#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ਬਮੇਕੋ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ਬਾਂਗੁਈ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ਬਾਂਜੁਲ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ਬਿਸਾਉ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ਬਲੰਟਾਇਰ#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ਬ੍ਰਾਜ਼ਾਵਿਲੇ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ਬੁਜੁੰਬੁਰਾ#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ਕੈਰੋ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ਕਾਸਬਲੈਂਕਾ#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ਸੀਊਟਾ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ਕੋਨੇਕਰੀ#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ਡਕਾਰ#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ਦਾਰ ਏਸ ਸਲਾਮ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ਜ਼ੀਬੂਤੀ#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ਡੌਆਲਾ#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ਅਲ ਅਯੂਨ#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ਫਰੀਟਾਉਨ#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ਗਾਬੋਰੋਨ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ਹਰਾਰੇ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ਜੋਹਨਸਬਰਗ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ਜੂਬਾ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ਕੰਪਾਲਾ#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ਖਾਰਟੌਮ#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ਕਿਗਾਲੀ#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ਕਿੰਸ਼ਾਸਾ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ਲਾਗੋਸ#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ਲਿਬਰਵਿਲੇ#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ਲੋਮ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ਲੁਆਂਡਾ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ਲੁਬੁਮਬਾਸ਼ੀ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ਲੁਸਾਕਾ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ਮਾਲਾਬੋ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ਮਾਪੁਟੋ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ਮਸੇਰੂ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ਏਮਬਾਬਾਨੇ#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#ਮੋਗਾਦਿਸ਼ੂ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#ਮੋਨਰੋਵੀਆ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ਨੈਰੋਬੀ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ਐਂਜਾਮੇਨਾ#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ਨਿਆਮੇ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ਨੌਆਕਸ਼ਾਟ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ਉਆਗਾਡੂਗੂ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ਪੋਰਟੋ-ਨੋਵੋ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ਸਾਓ ਟੋਮ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ਤ੍ਰਿਪੋਲੀ#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ਟੁਨਿਸ#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ਵਿੰਡਹੋਇਕ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(ਕੇਂਦਰੀ ਅਫਰੀਕਾ ਸਮਾਂ),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(ਪੂਰਬੀ ਅਫਰੀਕਾ ਸਮਾਂ),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(ਦੱਖਣੀ ਅਫ਼ਰੀਕਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(ਪੱਛਮੀ ਅਫਰੀਕਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੱਛਮੀ ਅਫਰੀਕਾ ਸਮਾਂ),
				'standard' => q(ਪੱਛਮੀ ਅਫਰੀਕਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(ਅਲਾਸਕਾ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਅਲਾਸਕਾ ਸਮਾਂ),
				'standard' => q(ਅਲਾਸਕਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(ਅਲਮਾਟੀ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਲਮਾਟੀ ਸਮਾਂ),
				'standard' => q(ਅਲਮਾਟੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(ਅਮੇਜ਼ਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਮੇਜ਼ਨ ਸਮਾਂ),
				'standard' => q(ਅਮੇਜ਼ਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'America/Adak' => {
			exemplarCity => q#ਏਡਕ#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ਐਂਕਰੇਜ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ਅੰਗੁਇਲਾ#,
		},
		'America/Antigua' => {
			exemplarCity => q#ਐਂਟੀਗੁਆ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#ਆਰਗੁਆਇਨਾ#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ਲਾ ਰਿਉਜਾ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ਰਿਓ ਗੈਲੇਗੋਸ#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ਸਾਲਟਾ#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ਸੇਨ ਜੁਆਨ#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ਸੇਨ ਲੂਈਸ#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ਟੁਕੁਮਨ#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ਉਸ਼ਵਾਇਆ#,
		},
		'America/Aruba' => {
			exemplarCity => q#ਅਰੂਬਾ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#ਐਸੁੰਕੀਅਨ#,
		},
		'America/Bahia' => {
			exemplarCity => q#ਬਾਹੀਆ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ਬਾਹੀਆ ਬਾਂਦੇਰਸ#,
		},
		'America/Barbados' => {
			exemplarCity => q#ਬਾਰਬਾਡੋਸ#,
		},
		'America/Belem' => {
			exemplarCity => q#ਬੇਲੇਮ#,
		},
		'America/Belize' => {
			exemplarCity => q#ਬੇਲੀਜ਼#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ਬਲੈਂਕ-ਸੈਬਲਾਨ#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ਬੋਆ ਵਿਸਟਾ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ਬੋਗੋਟਾ#,
		},
		'America/Boise' => {
			exemplarCity => q#ਬੋਇਸ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ਬਿਉਨੋ ਆਇਰਸ#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ਕੈਮਬ੍ਰਿਜ ਬੇ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ਕੈਂਪੋ ਗ੍ਰਾਂਡੇ#,
		},
		'America/Cancun' => {
			exemplarCity => q#ਕੈਨਕੁਨ#,
		},
		'America/Caracas' => {
			exemplarCity => q#ਕੈਰਾਕਾਸ#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ਕੈਟਾਮਾਰਕਾ#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ਕੇਯੇਨੇ#,
		},
		'America/Cayman' => {
			exemplarCity => q#ਕੇਮੈਨ#,
		},
		'America/Chicago' => {
			exemplarCity => q#ਸ਼ਿਕਾਗੋ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ਚਿਹੁਆਹੁਆ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ਐਟੀਕੋਕਨ#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ਕੋਰਡੋਬਾ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ਕੋਸਟਾ ਰੀਕਾ#,
		},
		'America/Creston' => {
			exemplarCity => q#ਕ੍ਰੈਸਟਨ#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ਕਯੁਏਬਾ#,
		},
		'America/Curacao' => {
			exemplarCity => q#ਕੁਰਾਕਾਓ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ਡੈਨਮਾਰਕਸ਼ੌਨ#,
		},
		'America/Dawson' => {
			exemplarCity => q#ਡੌਅਸਨ#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ਡੌਅਸਨ ਕ੍ਰੀਕ#,
		},
		'America/Denver' => {
			exemplarCity => q#ਡੇਨਵਰ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ਡਿਟਰੋਇਟ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ਡੋਮੀਨਿਕਾ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ਐਡਮੋਂਟਨ#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ਯੁਰੂਨੀਪੇ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ਅਲ ਸਲਵਾਡੋਰ#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ਫੋਰਟਾਲੇਜ਼ਾ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ਗਲੇਸ ਬੇ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ਨੂਕ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ਗੂਜ਼ ਬੇ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ਗਰਾਂਡ ਤੁਰਕ#,
		},
		'America/Grenada' => {
			exemplarCity => q#ਗ੍ਰੇਨਾਡਾ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ਗੁਆਡੇਲੋਪ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ਗੁਆਟੇਮਾਲਾ#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ਗੁਆਇਕਵਿਲ#,
		},
		'America/Guyana' => {
			exemplarCity => q#ਗੁਆਨਾ#,
		},
		'America/Halifax' => {
			exemplarCity => q#ਹੈਲੀਫੈਕਸ#,
		},
		'America/Havana' => {
			exemplarCity => q#ਹਵਾਨਾ#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ਹਰਮੋਸਿੱਲੋ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ਨੋਕਸ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#ਮਾਰੇਂਗੋ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ਪੀਟਰਸਬਰਗ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ਟੈਲ ਸਿਟੀ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ਵੇਵੇ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ਵਿੰਸੇਨੇਸ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ਵਿਨਮੈਕ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ਇੰਡੀਆਨਾਪੋਲਿਸ#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ਇਨੁਵਿਕ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ਇਕਾਲੁਈਟ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ਜਮਾਇਕਾ#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ਜੂਜੁਏ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ਜਯੂਨੋ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ਮੋਂਟੀਸੈਲੋ, ਕੈਂਟਕੀ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ਕ੍ਰਾਲੇਂਦਿਜਕ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ਲਾ ਪਾਜ਼#,
		},
		'America/Lima' => {
			exemplarCity => q#ਲੀਮਾ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ਲਾਸ ਐਂਜਲਸ#,
		},
		'America/Louisville' => {
			exemplarCity => q#ਲੁਈਸਵਿਲੇ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ਲੋਅਰ ਪ੍ਰਿੰਸ’ਸ ਕਵਾਰਟਰ#,
		},
		'America/Maceio' => {
			exemplarCity => q#ਮੈਸੀਓ#,
		},
		'America/Managua' => {
			exemplarCity => q#ਮਨਾਗੁਆ#,
		},
		'America/Manaus' => {
			exemplarCity => q#ਮਨੌਸ#,
		},
		'America/Marigot' => {
			exemplarCity => q#ਮੈਰੀਗੋਟ#,
		},
		'America/Martinique' => {
			exemplarCity => q#ਮਾਰਟੀਨਿਕ#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ਮਾਟਾਮੋਰਸ#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ਮਜ਼ੇਤਲਾਨ#,
		},
		'America/Mendoza' => {
			exemplarCity => q#ਮੈਂਡੋਜ਼ਾ#,
		},
		'America/Menominee' => {
			exemplarCity => q#ਮੈਨੋਮਿਨੀ#,
		},
		'America/Merida' => {
			exemplarCity => q#ਮੇਰਿਡਾ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ਮੇਟਲਾਕਾਟਲਾ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ਮੈਕਸੀਕੋ ਸਿਟੀ#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ਮਿਕੇਲਨ#,
		},
		'America/Moncton' => {
			exemplarCity => q#ਮੋਂਕਟਨ#,
		},
		'America/Monterrey' => {
			exemplarCity => q#ਮੋਨਟੇਰੀ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#ਮੋਂਟੇਵੀਡੀਓ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#ਮੋਂਟਸੇਰਾਤ#,
		},
		'America/Nassau' => {
			exemplarCity => q#ਨਾਸਾਓ#,
		},
		'America/New_York' => {
			exemplarCity => q#ਨਿਊ ਯਾਰਕ#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ਨਿਪਿਗੌਨ#,
		},
		'America/Nome' => {
			exemplarCity => q#ਨੋਮ#,
		},
		'America/Noronha' => {
			exemplarCity => q#ਨੌਰੋਨਹਾ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ਬਿਉਲਾ, ਉੱਤਰੀ ਡਕੋਟਾ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#ਸੇਂਟਰ, ਉੱਤਰੀ ਡਕੋਟਾ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ਨਿਊ ਸਲੇਮ, ਉੱਤਰੀ ਡਕੋਟਾ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ਓਜੀਨਾਗਾ#,
		},
		'America/Panama' => {
			exemplarCity => q#ਪਨਾਮਾ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ਪੈਂਗਨਿਰਟੰਗ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ਪੈਰਾਮਰੀਬੋ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ਫਿਨਿਕਸ#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ਪੋਰਟ-ਔ-ਪ੍ਰਿੰਸ#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ਪੋਰਟ ਔਫ ਸਪੇਨ#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ਪੋਰਟੋ ਵੇਲ੍ਹੋ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ਪਿਊਰਟੋ ਰੀਕੋ#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ਰੇਨੀ ਰਿਵਰ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ਰੈਂਕਿਨ ਇਨਲੈਟ#,
		},
		'America/Recife' => {
			exemplarCity => q#ਰੇਸੀਫੇ#,
		},
		'America/Regina' => {
			exemplarCity => q#ਰੈਜੀਨਾ#,
		},
		'America/Resolute' => {
			exemplarCity => q#ਰੈਜ਼ੋਲਿਊਟ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ਰਿਓ ਬ੍ਰਾਂਕੋ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#ਸੈਂਟਾ ਇਸਾਬੇਲ#,
		},
		'America/Santarem' => {
			exemplarCity => q#ਸੇਂਟਾਰਮ#,
		},
		'America/Santiago' => {
			exemplarCity => q#ਸੇਂਟੀਆਗੋ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ਸੇਂਟੋ ਡੋਮਿੰਗੋ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ਸਾਓ ਪੌਲੋ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ਇੱਟੋਕੋਰਟੂਰਮੀਟ#,
		},
		'America/Sitka' => {
			exemplarCity => q#ਸਿਟਕਾ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ਸੇਂਟ ਜੌਨਸ#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ਸੇਂਟ ਕਿਟਸ#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ਸੇਂਟ ਲੁਸੀਆ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ਸੇਂਟ ਥੋਮਸ#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ਸੇਂਟ ਵਿਨਸੇਂਟ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ਸਵਿਫਟ ਕਰੈਂਟ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ਟੇਗੁਸੀਗਲਪਾ#,
		},
		'America/Thule' => {
			exemplarCity => q#ਥੁਲੇ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ਥੰਡਰ ਬੇ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ਟਿਜੂਆਨਾ#,
		},
		'America/Toronto' => {
			exemplarCity => q#ਟੋਰਾਂਟੋ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ਟੋਰਟੋਲਾ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ਵੈਨਕੂਵਰ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ਵਾਈਟਹੌਰਸ#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ਵਿਨੀਪੈਗ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ਯਕੁਤਤ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ਯੈਲੋਨਾਈਫ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਕੇਂਦਰੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਕੇਂਦਰੀ ਸਮਾਂ),
				'standard' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਕੇਂਦਰੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੂਰਬੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੂਰਬੀ ਸਮਾਂ),
				'standard' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੂਰਬੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਮਾਉਂਟੇਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਮਾਉਂਟੇਨ ਸਮਾਂ),
				'standard' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਮਾਉਂਟੇਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੈਸਿਫਿਕ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੈਸਿਫਿਕ ਸਮਾਂ),
				'standard' => q(ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੈਸਿਫਿਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ਕਾਸੇ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ਡੇਵਿਸ#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ਡਿਉਮੋਂਟ ਡਿਉਰਵਿਲੇ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ਮੈਕਕਵੈਰੀ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ਮੌਸਨ#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ਮੈਕਮੁਰਡੋ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ਪਾਮਰ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ਰੋਥੇਰਾ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ਸਵੋਯਾ#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ਟਰੋਲ#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ਵੋਸਟੋਕ#,
		},
		'Apia' => {
			long => {
				'daylight' => q(ਐਪੀਆ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਐਪੀਆ ਸਮਾਂ),
				'standard' => q(ਐਪੀਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q(ਅਕਤਾਉ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਕਤਾਉ ਸਮਾਂ),
				'standard' => q(ਅਕਤਾਉ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(ਅਕਤੋਬ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਕਤੋਬ ਸਮਾਂ),
				'standard' => q(ਅਕਤੋਬ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(ਅਰਬੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਅਰਬੀ ਸਮਾਂ),
				'standard' => q(ਅਰਬੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ਲੋਂਗਈਅਰਬਾਇਨ#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(ਅਰਜਨਟੀਨਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਰਜਨਟੀਨਾ ਸਮਾਂ),
				'standard' => q(ਅਰਜਨਟੀਨਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(ਪੱਛਮੀ ਅਰਜਨਟੀਨਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੱਛਮੀ ਅਰਜਨਟੀਨਾ ਸਮਾਂ),
				'standard' => q(ਪੱਛਮੀ ਅਰਜਨਟੀਨਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(ਅਰਮੀਨੀਆ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਰਮੀਨੀਆ ਸਮਾਂ),
				'standard' => q(ਅਰਮੀਨੀਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ਅਡੇਨ#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ਅਲਮੇਟੀ#,
		},
		'Asia/Amman' => {
			exemplarCity => q#ਅਮਾਨ#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#ਇਨਾਡਾਇਰ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#ਅਕਤੌ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#ਅਕਤੋਬੇ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#ਅਸ਼ਗਾਬਾਟ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ਬਗਦਾਦ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ਬਹਿਰੀਨ#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ਬਾਕੂ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ਬੈਂਕਾਕ#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ਬੈਰੂਤ#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ਬਿਸ਼ਕੇਕ#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ਬਰੂਨੇਈ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ਕੋਲਕਾਤਾ#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ਚਿਤਾ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ਚੋਇਲਬਾਲਸਨ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ਕੋਲੰਬੋ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ਡੈਮਸਕਸ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ਢਾਕਾ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ਡਿਲੀ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ਦੁਬਈ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ਦੁਸ਼ਾਂਬੇ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ਗਾਜ਼ਾ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ਹੇਬਰਾਨ#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ਹਾਂਗ ਕਾਂਗ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ਹੋਵਡ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ਇਰਕੁਤਸਕ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ਜਕਾਰਤਾ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ਜਯਾਪੁਰਾ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ਜੇਰੂਸਲਮ#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ਕਾਬੁਲ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ਕਮਚਟਕਾ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ਕਰਾਚੀ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ਕਾਠਮਾਂਡੂ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ਖਾਨਡਿਗਾ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ਕਰੈਸਨੇਜਰਸ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ਕੁਆਲਾਲੰਪੁਰ#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#ਕੁਚਿੰਗ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ਕੁਵੈਤ#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ਮਕਾਉ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ਮੈਗੇਡਨ#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ਮਕਸਾਰ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ਮਨੀਲਾ#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#ਮਸਕਟ#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ਨਿਕੋਸੀਆ#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ਨੋਵੋਕੁਜ਼ਨੇਟਸਕ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ਨੋਵੋਸਿਬੀਰਸਕ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ਓਮਸਕ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ਓਰਲ#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ਫਨੋਮ ਪੇਨਹ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ਪੌਂਟੀਆਨਾਕ#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ਪਯੋਂਗਯਾਂਗ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ਕਤਰ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ਕਿਜ਼ੀਲੋਰਡਾ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ਰੰਗੂਨ#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ਰਿਆਧ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ਹੋ ਚੀ ਮਿਨ੍ਹ ਸਿਟੀ#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ਸਖਲੀਨ#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ਸਮਰਕੰਦ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ਸਿਉਲ#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ਸ਼ੰਘਾਈ#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#ਸਿੰਗਾਪੁਰ#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ਸਰਿਡਨੀਕੋਲਿਸਕ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ਤੈਪਈ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ਤਾਸ਼ਕੈਂਟ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ਟਬਿਲਿਸੀ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ਤੇਹਰਾਨ#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ਥਿੰਫੂ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ਟੋਕੀਓ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ਉਲਾਨਬਾਤਰ#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ਊਰੂਮਕੀ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ਉਸਤ-ਨੇਰਾ#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ਵਾਏਨਟਿਆਨੇ#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ਵਲਾਦੀਵੋਸਤਕ#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ਯਕੁਤਸਕ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ਯਕੇਤਰਿਨਬਰਗ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ਯੇਰੇਵਨ#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(ਅਟਲਾਂਟਿਕ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਅਟਲਾਂਟਿਕ ਸਮਾਂ),
				'standard' => q(ਅਟਲਾਂਟਿਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ਅਜੋਰੇਸ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ਬਰਮੂਡਾ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ਕੇਨੇਰੀ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ਕੇਪ ਵਰਡ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ਫੈਰੋ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ਮਡੀਅਰਾ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ਰੇਕਜਾਵਿਕ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ਦੱਖਣੀ ਜਾਰਜੀਆ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ਸੇਂਟ ਹੇਲੇਨਾ#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ਸਟੇਨਲੀ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ਐਡੀਲੇਡ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ਬ੍ਰਿਸਬੇਨ#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ਬ੍ਰੋਕਨ ਹਿਲ#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ਕਰੀ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ਡਾਰਵਿਨ#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ਯੂਕਲਾ#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ਹੋਬਾਰਟ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ਲਿੰਡੇਮਨ#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ਲੌਰਡ ਹੋਵੇ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ਮੈਲਬੋਰਨ#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ਪਰਥ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ਸਿਡਨੀ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਕੇਂਦਰੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਕੇਂਦਰੀ ਆਸਟ੍ਰੇਲੀਆਈ ਸਮਾਂ),
				'standard' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਕੇਂਦਰੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਕੇਂਦਰੀ ਪੱਛਮੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਕੇਂਦਰੀ ਪੱਛਮੀ ਸਮਾਂ),
				'standard' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਕੇਂਦਰੀ ਪੱਛਮੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਪੂਰਬੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਪੂਰਬੀ ਆਸਟ੍ਰੇਲੀਆਈ ਸਮਾਂ),
				'standard' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਪੂਰਬੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਪੱਛਮੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਪੱਛਮੀ ਆਸਟ੍ਰੇਲੀਆਈ ਸਮਾਂ),
				'standard' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਪੱਛਮੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(ਅਜ਼ਰਬਾਈਜਾਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਜ਼ਰਬਾਈਜਾਨ ਸਮਾਂ),
				'standard' => q(ਅਜ਼ਰਬਾਈਜਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(ਅਜੋਰੇਸ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਜੋਰੇਸ ਸਮਾਂ),
				'standard' => q(ਅਜੋਰੇਸ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(ਬੰਗਲਾਦੇਸ਼ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਬੰਗਲਾਦੇਸ਼ ਸਮਾਂ),
				'standard' => q(ਬੰਗਲਾਦੇਸ਼ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(ਭੂਟਾਨ ਸਮਾਂ),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(ਬੋਲੀਵੀਆ ਸਮਾਂ),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ਬ੍ਰਾਜ਼ੀਲੀਆ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਬ੍ਰਾਜ਼ੀਲੀਆ ਸਮਾਂ),
				'standard' => q(ਬ੍ਰਾਜ਼ੀਲੀਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ਬਰੂਨੇਈ ਦਾਰੂਸਲਾਮ ਸਮਾਂ),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(ਕੇਪ ਵਰਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਕੇਪ ਵਰਡ ਸਮਾਂ),
				'standard' => q(ਕੇਪ ਵਰਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Casey' => {
			long => {
				'standard' => q(ਕੇਸੀ ਸਮਾਂ),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(ਚਾਮੋਰੋ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(ਚੈਥਮ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਚੈਥਮ ਸਮਾਂ),
				'standard' => q(ਚੈਥਮ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(ਚਿਲੀ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਚਿਲੀ ਸਮਾਂ),
				'standard' => q(ਚਿਲੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'China' => {
			long => {
				'daylight' => q(ਚੀਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਚੀਨ ਸਮਾਂ),
				'standard' => q(ਚੀਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(ਚੌਇਬਾਲਸਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਚੌਇਬਾਲਸਨ ਸਮਾਂ),
				'standard' => q(ਚੌਇਬਾਲਸਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(ਕ੍ਰਿਸਮਸ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(ਕੋਕਸ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(ਕੋਲੰਬੀਆ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਕੋਲੰਬੀਆ ਸਮਾਂ),
				'standard' => q(ਕੋਲੰਬੀਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(ਕੁੱਕ ਆਈਲੈਂਡ ਅਰਧ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਕੁੱਕ ਆਈਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਕੁੱਕ ਆਈਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(ਕਿਊਬਾ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਕਿਊਬਾ ਸਮਾਂ),
				'standard' => q(ਕਿਊਬਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(ਡੇਵਿਸ ਸਮਾਂ),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ਡਿਉਮੋਂਟ ਡਿਉਰਵਿਲੇ ਸਮਾਂ),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(ਪੂਰਬੀ ਤਿਮੂਰ ਸਮਾਂ),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ਈਸਟਰ ਆਈਲੈਂਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਈਸਟਰ ਆਈਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਈਸਟਰ ਆਈਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ਇਕਵੇਡੋਰ ਸਮਾਂ),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#ਅਗਿਆਤ ਸ਼ਹਿਰ#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ਐਮਸਟਰਡਮ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ਅੰਡੋਰਾ#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ਏਥਨਸ#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ਬੈਲਗ੍ਰੇਡ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ਬਰਲਿਨ#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ਬ੍ਰਟਿਸਲਾਵਾ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ਬਰੂਸੇਲਸ#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ਬੁਚਾਰੇਸਟ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ਬੁਡਾਪੇਸਟ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ਬੁਸਿੰਜੇਨ#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ਚਿਸਿਨੌ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ਕੋਪੇਨਹੇਗਨ#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ਡਬਲਿਨ#,
			long => {
				'daylight' => q(ਆਇਰਿਸ਼ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ਜਿਬਰਾਲਟਰ#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ਗਰਨਜੀ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ਹੇਲਸਿੰਕੀ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ਆਇਲ ਆਫ ਮੈਨ#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ਇਸਤਾਂਬੁਲ#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ਜਰਸੀ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ਕਲੀਨਿੰਗ੍ਰੇਡ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ਕੀਵ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ਲਿਸਬਨ#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ਲਜੁਬਲਜਾਨਾ#,
		},
		'Europe/London' => {
			exemplarCity => q#ਲੰਡਨ#,
			long => {
				'daylight' => q(ਬ੍ਰਿਟਿਸ਼ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ਲਕਜ਼ਮਬਰਗ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ਮੈਡ੍ਰਿਡ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#ਮਾਲਟਾ#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ਮਾਰੀਏਹਾਮੇਨ#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#ਮਿੰਸਕ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#ਮੋਨਾਕੋ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ਮਾਸਕੋ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ਓਸਲੋ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ਪੈਰਿਸ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ਪੋਡਗੋਰੀਕਾ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ਪ੍ਰਾਗ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ਰਿਗਾ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ਰੋਮ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ਸਮਾਰਾ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ਸੈਨ ਮਰੀਨੋ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ਸਾਰਾਜੇਵੋ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ਸਿਮਫਰੋਪੋਲ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ਸਕੋਪਜੇ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ਸੋਫੀਆ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ਸਟਾਕਹੋਮ#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ਟੱਲਿਨ#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ਤਿਰਾਨੇ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ਉਜ਼ਗੋਰੋਡ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ਵਾਡੁਜ਼#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ਵੈਟਿਕਨ#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ਵਿਆਨਾ#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ਵਿਲਨਿਅਸ#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ਵੋਲਗੋਗ੍ਰੇਡ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ਵਾਰਸਾਅ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ਜ਼ਗਰੇਬ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ਜਪੋਰੋਜ਼ਾਏ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ਜਿਊਰਿਖ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(ਮੱਧ ਯੂਰਪੀ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਮੱਧ ਯੂਰਪੀ ਸਮਾਂ),
				'standard' => q(ਮੱਧ ਯੂਰਪੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(ਪੂਰਬੀ ਯੂਰਪੀ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੂਰਬੀ ਯੂਰਪੀ ਸਮਾਂ),
				'standard' => q(ਪੂਰਬੀ ਯੂਰਪੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(ਹੋਰ-ਪੂਰਬੀ ਯੂਰਪੀ ਸਮਾਂ),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(ਪੱਛਮੀ ਯੂਰਪੀ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੱਛਮੀ ਯੂਰਪੀ ਸਮਾਂ),
				'standard' => q(ਪੱਛਮੀ ਯੂਰਪੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਸਮਾਂ),
				'standard' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ਫ਼ਿਜ਼ੀ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਫ਼ਿਜ਼ੀ ਸਮਾਂ),
				'standard' => q(ਫ਼ਿਜ਼ੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(ਫ੍ਰੈਂਚ ਗੁਏਨਾ ਸਮਾਂ),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ਫ੍ਰੈਂਚ ਦੱਖਣੀ ਅਤੇ ਐਂਟਾਰਟਿਕ ਸਮਾਂ),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(ਗ੍ਰੀਨਵਿਚ ਮੀਨ ਟਾਈਮ),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(ਗਲਾਪਾਗੋਸ ਸਮਾਂ),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(ਗੈਂਬੀਅਰ ਸਮਾਂ),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(ਜਾਰਜੀਆ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਜਾਰਜੀਆ ਸਮਾਂ),
				'standard' => q(ਜਾਰਜੀਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(ਗਿਲਬਰਟ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(ਪੂਰਬੀ ਗ੍ਰੀਨਲੈਂਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੂਰਬੀ ਗ੍ਰੀਨਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਪੂਰਬੀ ਗ੍ਰੀਨਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(ਪੱਛਮੀ ਗ੍ਰੀਨਲੈਂਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੱਛਮੀ ਗ੍ਰੀਨਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਪੱਛਮੀ ਗ੍ਰੀਨਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(ਗੁਆਮ ਸਮਾਂ),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(ਖਾੜੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(ਗੁਯਾਨਾ ਸਮਾਂ),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(ਹਵਾਈ-ਅਲੇਯੂਸ਼ਿਅਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਹਵਾਈ-ਅਲੇਯੂਸ਼ਿਅਨ ਸਮਾਂ),
				'standard' => q(ਹਵਾਈ-ਅਲੇਯੂਸ਼ਿਅਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(ਹਾਂਗ ਕਾਂਗ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਹਾਂਗ ਕਾਂਗ ਸਮਾਂ),
				'standard' => q(ਹਾਂਗ ਕਾਂਗ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(ਹੋਵਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਹੋਵਡ ਸਮਾਂ),
				'standard' => q(ਹੋਵਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'India' => {
			long => {
				'standard' => q(ਭਾਰਤੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
			short => {
				'standard' => q(IST),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ਅੰਟਾਨਨੇਰਿਵੋ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ਚਾਗੋਸ#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ਕ੍ਰਿਸਮਸ#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ਕੋਕੋਜ਼#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ਕੋਮੋਰੋ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ਕਰਗਯੂਲੇਨ#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ਮਾਹੇ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#ਮਾਲਦੀਵ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ਮੌਰਿਸ਼ਸ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#ਮਾਯੋਟੀ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ਰਿਯੂਨੀਅਨ#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(ਹਿੰਦ ਮਹਾਂਸਾਗਰ ਸਮਾਂ),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(ਇੰਡੋਚਾਈਨਾ ਸਮਾਂ),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(ਮੱਧ ਇੰਡੋਨੇਸ਼ੀਆਈ ਸਮਾਂ),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(ਪੂਰਬੀ ਇੰਡੋਨੇਸ਼ੀਆ ਸਮਾਂ),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(ਪੱਛਮੀ ਇੰਡੋਨੇਸ਼ੀਆ ਸਮਾਂ),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ਈਰਾਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਈਰਾਨ ਸਮਾਂ),
				'standard' => q(ਈਰਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(ਇਰਕੁਤਸਕ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਇਰਕੁਤਸਕ ਸਮਾਂ),
				'standard' => q(ਇਰਕੁਤਸਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(ਇਜ਼ਰਾਈਲ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਇਜ਼ਰਾਈਲ ਸਮਾਂ),
				'standard' => q(ਇਜ਼ਰਾਈਲ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(ਜਪਾਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਜਪਾਨ ਸਮਾਂ),
				'standard' => q(ਜਪਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(ਪੂਰਬੀ ਕਜ਼ਾਖ਼ਸਤਾਨ ਸਮਾਂ),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(ਪੱਛਮੀ ਕਜ਼ਾਖ਼ਸਤਾਨ ਸਮਾਂ),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(ਕੋਰੀਆਈ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਕੋਰੀਆਈ ਸਮਾਂ),
				'standard' => q(ਕੋਰੀਆਈ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(ਕੋਸਰੇ ਸਮਾਂ),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(ਕ੍ਰਾਸਨੋਯਾਰਸਕ ਗਰਮੀ -ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਕ੍ਰਾਸਨੋਯਾਰਸਕ ਸਮਾਂ),
				'standard' => q(ਕ੍ਰਾਸਨੋਯਾਰਸਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(ਕਿਰਗਿਸਤਾਨ ਸਮਾਂ),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(ਲੰਕਾ ਸਮਾਂ),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(ਲਾਈਨ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(ਲੌਰਡ ਹੋਵੇ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਲੌਰਡ ਹੋਵੇ ਸਮਾਂ),
				'standard' => q(ਲੌਰਡ ਹੋਵੇ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(ਮਕਾਉ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਮਕਾਉ ਸਮਾਂ),
				'standard' => q(ਮਕਾਉ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(ਮੈਕਕਵੇਰੀ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(ਮੈਗੇਡਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਮੈਗੇਡਨ ਸਮਾਂ),
				'standard' => q(ਮੈਗੇਡਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(ਮਲੇਸ਼ੀਆ ਸਮਾਂ),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(ਮਾਲਦੀਵ ਸਮਾਂ),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(ਮਾਰਕਿਸਾਸ ਸਮਾਂ),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(ਮਾਰਸ਼ਲ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(ਮੌਰਿਸ਼ਸ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਮੌਰਿਸ਼ਸ ਸਮਾਂ),
				'standard' => q(ਮੌਰਿਸ਼ਸ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(ਮੌਸਨ ਸਮਾਂ),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(ਉੱਤਰ ਪੱਛਮੀ ਮੈਕਸੀਕੋ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਉੱਤਰ ਪੱਛਮੀ ਮੈਕਸੀਕੋ ਸਮਾਂ),
				'standard' => q(ਉੱਤਰ ਪੱਛਮੀ ਮੈਕਸੀਕੋ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(ਮੈਕਸੀਕਨ ਪੈਸਿਫਿਕ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਮੈਕਸੀਕਨ ਪੈਸਿਫਿਕ ਸਮਾਂ),
				'standard' => q(ਮੈਕਸੀਕਨ ਪੈਸਿਫਿਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(ਉਲਨ ਬਟੋਰ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਉਲਨ ਬਟੋਰ ਸਮਾਂ),
				'standard' => q(ਉਲਨ ਬਟੋਰ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(ਮਾਸਕੋ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਮਾਸਕੋ ਸਮਾਂ),
				'standard' => q(ਮਾਸਕੋ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(ਮਿਆਂਮਾਰ ਸਮਾਂ),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(ਨਾਉਰੂ ਸਮਾਂ),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(ਨੇਪਾਲ ਸਮਾਂ),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(ਨਿਊ ਕੈਲੇਡੋਨੀਆ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਨਿਊ ਕੈਲੇਡੋਨੀਆ ਸਮਾਂ),
				'standard' => q(ਨਿਊ ਕੈਲੇਡੋਨੀਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(ਨਿਊਫਾਉਂਡਲੈਂਡ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਨਿਊਫਾਉਂਡਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਨਿਊਫਾਉਂਡਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(ਨਿਊ ਸਮਾਂ),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(ਨੋਰਫੌਕ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(ਫਰਨਾਂਡੋ ਡੇ ਨੋਰੋਨਹਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਫਰਨਾਂਡੋ ਡੇ ਨੋਰੋਨਹਾ ਸਮਾਂ),
				'standard' => q(ਫਰਨਾਂਡੋ ਡੇ ਨੋਰੋਨਹਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(ਉੱਤਰੀ ਮਰਿਆਨਾ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(ਨੌਵੋਸਿਬੀਰਸਕ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਨੌਵੋਸਿਬੀਰਸਕ ਸਮਾਂ),
				'standard' => q(ਨੌਵੋਸਿਬੀਰਸਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ਓਮਸਕ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਓਮਸਕ ਸਮਾਂ),
				'standard' => q(ਓਮਸਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ਐਪੀਆ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ਆਕਲੈਂਡ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ਬੋਗਨਵਿਲੇ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ਚੈਥਮ#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ਈਸਟਰ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ਇਫੇਟ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ਏਂਡਰਬਰੀ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ਫਕਾਉਫੋ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ਫ਼ਿਜੀ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ਫੁਨਾਫੁਟੀ#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ਗਲਪੇਗੋਸ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ਗੈਂਬੀਅਰ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ਗੁਆਡਾਕੇਨਲ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ਗੁਆਮ#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ਹੋਨੋਲੁਲੂ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ਜੋਨਸਟਨ#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ਕਿਰਿਤਿਮਤੀ#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ਕੋਸ੍ਰਾਏ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ਕਵਾਜਾਲੀਨ#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ਮੇਜੁਰੋ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#ਮਾਰਕਿਸਾਸ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ਮਿਡਵੇ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ਨਾਉਰੂ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ਨਿਯੂ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ਨੋਰਫੌਕ#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ਨੌਮਿਆ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ਪਾਗੋ ਪਾਗੋ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ਪਲਾਉ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ਪਿਟਕੈਰਨ#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ਪੋਹਨਪੇਈ#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ਪੋਰਟ ਮੋਰੇਸਬੀ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ਰਾਰੋਟੋਂਗਾ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ਸੈਪਾਨ#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ਤਹਿਤੀ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ਟਾਰਾਵਾ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ਟੋਂਗਾਟਾਪੂ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ਚੂਕ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ਵੇਕ#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ਵਾਲਿਸ#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(ਪਾਕਿਸਤਾਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪਾਕਿਸਤਾਨ ਸਮਾਂ),
				'standard' => q(ਪਾਕਿਸਤਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(ਪਲਾਉ ਸਮਾਂ),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ ਸਮਾਂ),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(ਪੈਰਾਗਵੇ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੈਰਾਗਵੇ ਸਮਾਂ),
				'standard' => q(ਪੈਰਾਗਵੇ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(ਪੇਰੂ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੇਰੂ ਸਮਾਂ),
				'standard' => q(ਪੇਰੂ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(ਫਿਲਿਪੀਨੀ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਫਿਲਿਪੀਨੀ ਸਮਾਂ),
				'standard' => q(ਫਿਲਿਪੀਨੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ਫਿਨਿਕਸ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(ਸੈਂਟ ਪੀਅਰੇ ਅਤੇ ਮਿਕੇਲਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਸੈਂਟ ਪੀਅਰੇ ਅਤੇ ਮਿਕੇਲਨ ਸਮਾਂ),
				'standard' => q(ਸੈਂਟ ਪੀਅਰੇ ਅਤੇ ਮਿਕੇਲਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(ਪਿਟਕੈਰਨ ਸਮਾਂ),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(ਪੋਨਾਪੇ ਸਮਾਂ),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(ਕਿਜ਼ਲੋਰਡਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਕਿਜ਼ਲੋਰਡਾ ਸਮਾਂ),
				'standard' => q(ਕਿਜ਼ਲੋਰਡਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(ਰਿਯੂਨੀਅਨ ਸਮਾਂ),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(ਰੋਥੇਰਾ ਸਮਾਂ),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(ਸਖਲੀਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਸਖਲੀਨ ਸਮਾਂ),
				'standard' => q(ਸਖਲੀਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(ਸਾਮੋਆ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਸਾਮੋਆ ਸਮਾਂ),
				'standard' => q(ਸਾਮੋਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(ਸੇਸ਼ਲਸ ਸਮਾਂ),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(ਸਿੰਗਾਪੁਰ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਸਮਾਂ),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(ਦੱਖਣੀ ਜਾਰਜੀਆ ਸਮਾਂ),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(ਸੂਰੀਨਾਮ ਸਮਾਂ),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(ਸਿਓਵਾ ਸਮਾਂ),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(ਤਹਿਤੀ ਸਮਾਂ),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(ਤੈਪਈ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਤੈਪਈ ਸਮਾਂ),
				'standard' => q(ਤੈਪਈ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(ਤਾਜਿਕਿਸਤਾਨ ਸਮਾਂ),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(ਟੋਕੇਲਾਉ ਸਮਾਂ),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(ਟੋਂਗਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਟੋਂਗਾ ਸਮਾਂ),
				'standard' => q(ਟੋਂਗਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(ਚੂਕ ਸਮਾਂ),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(ਤੁਰਕਮੇਨਿਸਤਾਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਤੁਰਕਮੇਨਿਸਤਾਨ ਸਮਾਂ),
				'standard' => q(ਤੁਰਕਮੇਨਿਸਤਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(ਟੁਵਾਲੂ ਸਮਾਂ),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(ਉਰੂਗਵੇ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਉਰੂਗਵੇ ਸਮਾਂ),
				'standard' => q(ਉਰੂਗਵੇ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸਮਾਂ),
				'standard' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(ਵਾਨੂਆਟੂ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਵਾਨੂਆਟੂ ਸਮਾਂ),
				'standard' => q(ਵਾਨੂਆਟੂ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(ਵੈਨੇਜ਼ੂਏਲਾ ਸਮਾਂ),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(ਵਲਾਦੀਵੋਸਤਕ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਵਲਾਦੀਵੋਸਤਕ ਸਮਾਂ),
				'standard' => q(ਵਲਾਦੀਵੋਸਤਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(ਵੋਲਗੋਗ੍ਰੇਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਵੋਲਗੋਗ੍ਰੇਡ ਸਮਾਂ),
				'standard' => q(ਵੋਲਗੋਗ੍ਰੇਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(ਵੋਸਟੋਕ ਸਮਾਂ),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(ਵੇਕ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(ਵਾਲਿਸ ਅਤੇ ਫੁਟੂਨਾ ਸਮਾਂ),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(ਯਕੁਤਸਕ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਯਕੁਤਸਕ ਸਮਾਂ),
				'standard' => q(ਯਕੁਤਸਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(ਯਕੇਤਰਿਨਬਰਗ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਯਕੇਤਰਿਨਬਰਗ ਸਮਾਂ),
				'standard' => q(ਯਕੇਤਰਿਨਬਰਗ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
