=encoding utf8

=head1

Locale::CLDR::Locales::Or - Package for language Odia

=cut

package Locale::CLDR::Locales::Or;
# This file auto generated from Data\common\main\or.xml
#	on Sun 16 Dec  4:32:22 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'ଅଫାର୍',
 				'ab' => 'ଆବ୍ଖାଜିଆନ୍',
 				'ace' => 'ଆଚାଇନୀଜ୍',
 				'ach' => 'ଆକୋଲି',
 				'ada' => 'ଆଦାଙ୍ଗେମ୍',
 				'ady' => 'ଅଦ୍ୟଘେ',
 				'ae' => 'ଅବେସ୍ତନ',
 				'af' => 'ଆଫ୍ରିକୀୟ',
 				'afh' => 'ଆଫ୍ରିହିଲି',
 				'agq' => 'ଆଘେମ',
 				'ain' => 'ଆଇନୁ',
 				'ak' => 'ଅକନ୍',
 				'akk' => 'ଆକାଡିଆନ୍',
 				'ale' => 'ଆଲେଇଟୁ',
 				'alt' => 'ଦକ୍ଷିଣ ଆଲ୍ଟାଇ',
 				'am' => 'ଆମହାରକି',
 				'an' => 'ଆର୍ଗୋନୀ',
 				'ang' => 'ପୁରୁଣା ଇଁରାଜୀ',
 				'anp' => 'ଅଁଗୀକା',
 				'ar' => 'ଆରବିକ୍',
 				'ar_001' => 'ଆଧୁନିକ ମାନାଙ୍କ ଆରବୀୟ',
 				'arc' => 'ଆରାମାଇକ୍',
 				'arn' => 'ମାପୁଚେ',
 				'arp' => 'ଆରାପାହୋ',
 				'arw' => 'ଆରୱକ',
 				'as' => 'ଆସାମୀୟ',
 				'asa' => 'ଆସୁ',
 				'ast' => 'ଆଷ୍ଟୁରିଆନ୍',
 				'av' => 'ଆଭାରିକ୍',
 				'awa' => 'ଆୱାଧି',
 				'ay' => 'ଆୟମାରା',
 				'az' => 'ଆଜେରବାଇଜାନି',
 				'az@alt=short' => 'ଆଜେରି',
 				'ba' => 'ବାଶକିର୍',
 				'bal' => 'ବାଲୁଚି',
 				'ban' => 'ବାଲିନୀଜ୍',
 				'bas' => 'ବାସା',
 				'be' => 'ବେଲାରୁଷିଆନ୍',
 				'bej' => 'ବେଜା',
 				'bem' => 'ବେମ୍ବା',
 				'bez' => 'ବେନା',
 				'bg' => 'ବୁଲଗେରିଆନ୍',
 				'bho' => 'ଭୋଜପୁରୀ',
 				'bi' => 'ବିସଲାମା',
 				'bik' => 'ବିକୋଲ୍',
 				'bin' => 'ବିନି',
 				'bla' => 'ସିକସିକା',
 				'bm' => 'ବାମ୍ବାରା',
 				'bn' => 'ବଙ୍ଗଳା',
 				'bo' => 'ତିବ୍ବତୀୟ',
 				'br' => 'ବ୍ରେଟନ୍',
 				'bra' => 'ବ୍ରାଜ୍',
 				'brx' => 'ବୋଡୋ',
 				'bs' => 'ବୋସନିଆନ୍',
 				'bua' => 'ବୁରିଆଟ୍',
 				'bug' => 'ବୁଗୀନୀଜ୍',
 				'byn' => 'ବ୍ଲିନ୍',
 				'ca' => 'କାଟାଲାନ୍',
 				'cad' => 'କାଡୋ',
 				'car' => 'କାରିବ୍',
 				'cch' => 'ଆତ୍ସମ୍',
 				'ce' => 'ଚେଚନ୍',
 				'ceb' => 'ସୀବୁଆନୋ',
 				'cgg' => 'ଚିଗା',
 				'ch' => 'ଚାମୋରୋ',
 				'chb' => 'ଚିବ୍ଚା',
 				'chg' => 'ଛଗତାଇ',
 				'chk' => 'ଚୁକୀସେ',
 				'chm' => 'ମାରୀ',
 				'chn' => 'ଚିନୁକ୍ ଜାରଗାଁନ୍',
 				'cho' => 'ଚୋଟୱା',
 				'chp' => 'ଚିପେୱାନ୍',
 				'chr' => 'ଚେରୋକୀ',
 				'chy' => 'ଚେଚେନା',
 				'ckb' => 'କେନ୍ଦ୍ରୀୟ କୁରଡିସ୍',
 				'co' => 'କୋର୍ସିକାନ୍',
 				'cop' => 'କପ୍ଟିକ୍',
 				'cr' => 'କ୍ରୀ',
 				'crh' => 'କ୍ରୀମିନ୍ ତୁର୍କୀସ୍',
 				'crs' => 'ସେସେଲୱା କ୍ରେଓଲେ ଫ୍ରେଞ୍ଚ୍',
 				'cs' => 'ଚେକ୍',
 				'csb' => 'କାଶୁବିଆନ୍',
 				'cu' => 'ଚର୍ଚ୍ଚ ସ୍ଲାଭିକ୍',
 				'cv' => 'ଚୁଭାଶ୍',
 				'cy' => 'ୱେଲ୍ସ',
 				'da' => 'ଡାନ୍ନିସ୍',
 				'dak' => 'ଡାକୋଟା',
 				'dar' => 'ଡାରାଗ୍ୱା',
 				'dav' => 'ତାଇତି',
 				'de' => 'ଜର୍ମାନ',
 				'de_AT' => 'ଅଷ୍ଟ୍ରିଆନ୍ ଜର୍ମାନ',
 				'de_CH' => 'ସ୍ୱିସ୍‌ ହାଇ ଜର୍ମାନ',
 				'del' => 'ଡେଲାୱେର୍',
 				'den' => 'ସ୍ଲେଭ୍',
 				'dgr' => 'ଡୋଗ୍ରିବ୍',
 				'din' => 'ଦିଙ୍କା',
 				'dje' => 'ଜର୍ମା',
 				'doi' => 'ଡୋଗ୍ରୀ',
 				'dsb' => 'ନିମ୍ନ ସର୍ବିଆନ୍‌',
 				'dua' => 'ଡୁଆନା',
 				'dum' => 'ମଧ୍ୟ ପର୍ତ୍ତୁଗାଲୀ',
 				'dv' => 'ଡିଭେହୀ',
 				'dyo' => 'ଜୋଲା-ଫୋନୟି',
 				'dyu' => 'ଡୁଆଲା',
 				'dz' => 'ଦଡଜୋଙ୍ଗଖା',
 				'dzg' => 'ଡାଜାଗା',
 				'ebu' => 'ଏମ୍ଵୁ',
 				'ee' => 'ଇୱେ',
 				'efi' => 'ଏଫିକ୍',
 				'egy' => 'ପ୍ରାଚୀନ୍ ମିଶିରି',
 				'eka' => 'ଏକାଜୁକ୍',
 				'el' => 'ଗ୍ରୀକ୍',
 				'elx' => 'ଏଲାମାଇଟ୍',
 				'en' => 'ଇଂରାଜୀ',
 				'en_AU' => 'ଅଷ୍ଟ୍ରେଲିୟ ଇଂରାଜୀ',
 				'en_CA' => 'କାନାଡିୟ ଇଂରାଜୀ',
 				'en_GB' => 'ବ୍ରିଟିଶ୍‌ ଇଂରାଜୀ',
 				'en_GB@alt=short' => 'ଯୁକ୍ତରାଜ୍ୟ ଇଂରାଜୀ',
 				'en_US' => 'ଆମେରିକୀୟ ଇଂରାଜୀ',
 				'en_US@alt=short' => 'ଯୁକ୍ତରାଷ୍ଟ୍ର ଇଂରାଜୀ',
 				'enm' => 'ମଧ୍ୟ ଇଁରାଜୀ',
 				'eo' => 'ଏସ୍ପାରେଣ୍ଟୋ',
 				'es' => 'ସ୍ପେନିୟ',
 				'es_419' => 'ଲାଟିନ୍‌ ଆମେରିକୀୟ ସ୍ପାନିସ୍‌',
 				'es_ES' => 'ୟୁରୋପୀୟ ସ୍ପାନିସ୍‌',
 				'es_MX' => 'ମେକ୍ସିକାନ ସ୍ପାନିସ୍‌',
 				'et' => 'ଏସ୍ତୋନିଆନ୍',
 				'eu' => 'ବାସ୍କ୍ୱି',
 				'ewo' => 'ଇୱୋଣ୍ଡୋ',
 				'fa' => 'ପର୍ସିଆନ୍',
 				'fan' => 'ଫାଙ୍ଗ',
 				'fat' => 'ଫାଣ୍ଟି',
 				'ff' => 'ଫୁଲାହ',
 				'fi' => 'ଫିନ୍ନିସ୍',
 				'fil' => 'ଫିଲିପିନୋ',
 				'fj' => 'ଫିଜି',
 				'fo' => 'ଫାରୋଏସେ',
 				'fon' => 'ଫନ୍',
 				'fr' => 'ଫରାସୀ',
 				'fr_CA' => 'କାନାଡିୟ ଫ୍ରେଞ୍ଚ',
 				'fr_CH' => 'ସ୍ୱିସ୍ ଫ୍ରେଞ୍ଚ',
 				'frm' => 'ମଧ୍ୟ ଫ୍ରେଞ୍ଚ',
 				'fro' => 'ପୁରୁଣା ଫ୍ରେଞ୍ଚ',
 				'frr' => 'ଉତ୍ତର ଫ୍ରିସିୟାନ୍',
 				'frs' => 'ପୂର୍ବ ଫ୍ରିସିୟାନ୍',
 				'fur' => 'ଫ୍ରିୟୁଲୀୟାନ୍',
 				'fy' => 'ପାଶ୍ଚାତ୍ୟ ଫ୍ରିସିଆନ୍',
 				'ga' => 'ଇରିସ୍',
 				'gaa' => 'ଗା',
 				'gay' => 'ଗାୟୋ',
 				'gba' => 'ଗବାୟା',
 				'gd' => 'ସ୍କଟିସ୍ ଗାଏଲିକ୍',
 				'gez' => 'ଗୀଜ୍',
 				'gil' => 'ଜିବ୍ରାଟୀଜ୍',
 				'gl' => 'ଗାଲସିଆନ୍',
 				'gmh' => 'ମିଡିଲ୍ ହାଇ ଜର୍ମାନ୍',
 				'gn' => 'ଗୁଆରାନୀ',
 				'goh' => 'ପୁରୁଣା ହାଇ ଜର୍ମାନ୍',
 				'gon' => 'ଗୋଣ୍ଡି',
 				'gor' => 'ଗୋରୋଣ୍ଟାଲୋ',
 				'got' => 'ଗୋଥିକ୍',
 				'grb' => 'ଗ୍ରେବୋ',
 				'grc' => 'ପ୍ରାଚୀନ୍ ୟୁନାନୀ',
 				'gsw' => 'ସୁଇସ୍ ଜର୍ମାନ୍',
 				'gu' => 'ଗୁଜୁରାଟୀ',
 				'guz' => 'ଗୁସି',
 				'gv' => 'ମାଁକ୍ସ',
 				'gwi' => 'ଗୱିଚ’ଇନ୍',
 				'ha' => 'ହୌସା',
 				'hai' => 'ହାଇଡା',
 				'haw' => 'ହାୱାଇନ୍',
 				'he' => 'ହେବ୍ର୍ୟୁ',
 				'hi' => 'ହିନ୍ଦୀ',
 				'hil' => 'ହିଲିଗୈନନ୍',
 				'hit' => 'ହିତୀତେ',
 				'hmn' => 'ହଁଙ୍ଗ',
 				'ho' => 'ହିରି ମୋଟୁ',
 				'hr' => 'କ୍ରୋଆଟିଆନ୍',
 				'hsb' => 'ଉପର ସର୍ବିଆନ୍',
 				'ht' => 'ହୈତାୟିନ୍',
 				'hu' => 'ହଙ୍ଗେରୀୟ',
 				'hup' => 'ହୁପା',
 				'hy' => 'ଆର୍ମେନିଆନ୍',
 				'hz' => 'ହେରେରୋ',
 				'ia' => 'ଇର୍ଣ୍ଟଲିଙ୍ଗୁଆ',
 				'iba' => 'ଇବାନ୍',
 				'ibb' => 'ଇବିବିଓ',
 				'id' => 'ଇଣ୍ଡୋନେସୀୟ',
 				'ie' => 'ଇର୍ଣ୍ଟରଲିଙ୍ଗୁଇ',
 				'ig' => 'ଇଗବୋ',
 				'ii' => 'ସିଚୁଆନ୍ ୟୀ',
 				'ik' => 'ଇନୁପିୟାକ୍',
 				'ilo' => 'ଇଲୋକୋ',
 				'inh' => 'ଇଁଙ୍ଗୁଶ୍',
 				'io' => 'ଇଡୋ',
 				'is' => 'ଆଇସଲାଣ୍ଡିକ୍',
 				'it' => 'ଇଟାଲୀୟ',
 				'iu' => 'ଇନୁକଟିଟୁତ୍‌',
 				'ja' => 'ଜାପାନୀ',
 				'jbo' => 'ଲୋଜବାନ୍',
 				'jgo' => 'ନାଗୋମ୍ଵା',
 				'jmc' => 'ମାଚେମେ',
 				'jpr' => 'ଜୁଡେଓ-ପର୍ସିଆନ୍',
 				'jrb' => 'ଜୁଡେଓ-ଆରବୀକ୍',
 				'jv' => 'ଜାଭାନୀଜ୍',
 				'ka' => 'ଜର୍ଜିୟ',
 				'kaa' => 'କାରା-କଲ୍ପକ୍',
 				'kab' => 'କବାଇଲ୍',
 				'kac' => 'କଚିନ୍',
 				'kaj' => 'ଜଜୁ',
 				'kam' => 'କମ୍ବା',
 				'kaw' => 'କାୱି',
 				'kbd' => 'କାବାର୍ଡିଆନ୍',
 				'kcg' => 'ତ୍ୟାପ୍',
 				'kde' => 'ମାକୋଣ୍ଡେ',
 				'kea' => 'କାବୁଭେରଡିଆନୁ',
 				'kfo' => 'କୋରୋ',
 				'kg' => 'କଙ୍ଗୋ',
 				'kha' => 'ଖାସୀ',
 				'kho' => 'ଖୋତାନୀଜ୍',
 				'khq' => 'କୋୟରା ଚିନି',
 				'ki' => 'କୀକୁୟୁ',
 				'kj' => 'କ୍ୱାନ୍ୟାମ୍',
 				'kk' => 'କାଜାକ୍',
 				'kkj' => 'କାକୋ',
 				'kl' => 'କାଲାଲିସୁଟ୍',
 				'kln' => 'କାଲେନଜିନ୍',
 				'km' => 'ଖାମେର୍',
 				'kmb' => 'କିମ୍ବୁଣ୍ଡୁ',
 				'kn' => 'କନ୍ନଡ',
 				'ko' => 'କୋରିଆନ୍',
 				'kok' => 'କୋଙ୍କଣି',
 				'kos' => 'କୋସରୈନ୍',
 				'kpe' => 'କୈପେଲେ',
 				'kr' => 'କନୁରୀ',
 				'krc' => 'କରାଚୟ-ବଲ୍କାର',
 				'krl' => 'କାରେଲିୟାନ୍',
 				'kru' => 'କୁରୁଖ',
 				'ks' => 'କାଶ୍ମିରୀ',
 				'ksb' => 'ଶାମବାଲା',
 				'ksf' => 'ବାଫଲା',
 				'ksh' => 'କୋଲୋବନିୟ',
 				'ku' => 'କୁର୍ଦ୍ଦିଶ୍',
 				'kum' => 'କୁମୀକ୍',
 				'kut' => 'କୁତେନାଉ',
 				'kv' => 'କୋମି',
 				'kw' => 'କୋର୍ନିସ୍',
 				'ky' => 'କୀରଗୀଜ୍',
 				'la' => 'ଲାଟିନ୍',
 				'lad' => 'ଲାଦିନୋ',
 				'lag' => 'ଲାନଗି',
 				'lah' => 'ଲାହାଣ୍ଡା',
 				'lam' => 'ଲାମ୍ବା',
 				'lb' => 'ଲକ୍ସେମବର୍ଗିସ୍',
 				'lez' => 'ଲେଜଗିୟାନ୍',
 				'lg' => 'ଗନ୍ଦା',
 				'li' => 'ଲିମ୍ବୁର୍ଗିସ୍',
 				'lkt' => 'ଲାକୋଟା',
 				'ln' => 'ଲିଙ୍ଗାଲା',
 				'lo' => 'ଲାଓ',
 				'lol' => 'ମଙ୍ଗୋ',
 				'loz' => 'ଲୋଜି',
 				'lrc' => 'ଉତ୍ତର ଲୁରି',
 				'lt' => 'ଲିଥୁଆନିଆନ୍',
 				'lu' => 'ଲ୍ୟୁବା-କାଟାଙ୍ଗା',
 				'lua' => 'ଲୁବା-ଲୁଲୁଆ',
 				'lui' => 'ଲୁଇସେନୋ',
 				'lun' => 'ଲୁଣ୍ଡା',
 				'luo' => 'ଲୁଓ',
 				'lus' => 'ମିଜୋ',
 				'luy' => 'ଲୁୟିଆ',
 				'lv' => 'ଲାଟଭିଆନ୍',
 				'mad' => 'ମାଦୁରୀସ୍',
 				'mag' => 'ମାଗାହୀ',
 				'mai' => 'ମୈଥିଳୀ',
 				'mak' => 'ମକାସର୍',
 				'man' => 'ମାଣ୍ଡିଙ୍ଗୋ',
 				'mas' => 'ମାସାଇ',
 				'mdf' => 'ମୋକ୍ଷ',
 				'mdr' => 'ମନ୍ଦାର',
 				'men' => 'ମେନଡେ',
 				'mer' => 'ମେରୁ',
 				'mfe' => 'ମୋରିସୟେନ୍',
 				'mg' => 'ମାଲାଗାସୀ',
 				'mga' => 'ମଧ୍ୟ ଇରିଶ୍',
 				'mgh' => 'ମଖୁୱା-ମେଟ୍ଟା',
 				'mgo' => 'ମେଟା',
 				'mh' => 'ମାର୍ଶାଲୀଜ୍',
 				'mi' => 'ମାଓରୀ',
 				'mic' => 'ମିକମୌକ୍',
 				'min' => 'ମିନାଙ୍ଗାବାଉ',
 				'mk' => 'ମାସେଡୋନିଆନ୍',
 				'ml' => 'ମାଲାୟଲମ୍',
 				'mn' => 'ମଙ୍ଗୋଳିୟ',
 				'mnc' => 'ମାଞ୍ଚୁ',
 				'mni' => 'ମଣିପୁରୀ',
 				'moh' => 'ମୋହୌକ',
 				'mos' => 'ମୋସି',
 				'mr' => 'ମରାଠୀ',
 				'ms' => 'ମାଲୟ',
 				'mt' => 'ମାଲଟୀଜ୍',
 				'mua' => 'ମୁନଡାଂ',
 				'mul' => 'ବିବିଧ ଭାଷାମାନ',
 				'mus' => 'କ୍ରୀକ୍',
 				'mwl' => 'ମିରାଣ୍ଡିଜ୍',
 				'mwr' => 'ମାରୱାରୀ',
 				'my' => 'ବର୍ମୀଜ୍',
 				'myv' => 'ଏର୍ଜୟା',
 				'mzn' => 'ମାଜାନଡେରାନି',
 				'na' => 'ନାଉରୁ',
 				'nap' => 'ନୀପୋଲିଟାନ୍',
 				'naq' => 'ନାମା',
 				'nb' => 'ନରୱେଜିଆନ୍ ବୋକମଲ୍',
 				'nd' => 'ଉତ୍ତର ନେଡବେଲେ',
 				'nds' => 'ଲୋ ଜର୍ମାନ୍',
 				'ne' => 'ନେପାଳୀ',
 				'new' => 'ନେୱାରୀ',
 				'ng' => 'ଡୋଙ୍ଗା',
 				'nia' => 'ନୀୟାସ୍',
 				'niu' => 'ନିୟୁଆନ୍',
 				'nl' => 'ଡଚ୍',
 				'nl_BE' => 'ଫ୍ଲେମିଶ୍',
 				'nmg' => 'କୱାସିଓ',
 				'nn' => 'ନରୱେଜିଆନ୍ ନିୟୋର୍ସ୍କ',
 				'nnh' => 'ନାଗିମବୋନ୍',
 				'no' => 'ନରୱେଜିଆନ୍',
 				'nog' => 'ନୋଗାଇ',
 				'non' => 'ପୁରୁଣା ନର୍ସ',
 				'nqo' => 'ଏନକୋ',
 				'nr' => 'ଦକ୍ଷିଣ ନେଡବେଲେ',
 				'nso' => 'ଉତ୍ତରୀ ସୋଥୋ',
 				'nus' => 'ନୁଏର',
 				'nv' => 'ନାଭାଜୋ',
 				'nwc' => 'ପାରମ୍ପରିକ ନେୱାରୀ',
 				'ny' => 'ନିୟାଞ୍ଜ',
 				'nym' => 'ନ୍ୟାମୱେଜୀ',
 				'nyn' => 'ନ୍ୟାନକୋଲ୍',
 				'nyo' => 'ନ୍ୟାରୋ',
 				'nzi' => 'ଞ୍ଜିମା',
 				'oc' => 'ଓସିଟାନ୍',
 				'oj' => 'ଓଜିୱା',
 				'om' => 'ଓରୋମୋ',
 				'or' => 'ଓଡ଼ିଆ',
 				'os' => 'ଓସେଟିକ୍',
 				'osa' => 'ୱୌସେଜ୍',
 				'ota' => 'ଓଟ୍ଟୋମନ୍ ତୁର୍କିସ୍',
 				'pa' => 'ପଞ୍ଜାବୀ',
 				'pag' => 'ପାଙ୍ଗାସିନିଆନ୍',
 				'pal' => 'ପାହ୍ଲାଭି',
 				'pam' => 'ପାମ୍ପାଙ୍ଗା',
 				'pap' => 'ପାପିଆମେଣ୍ଟୋ',
 				'pau' => 'ପାଲାଉଆନ୍',
 				'pcm' => 'ନାଇଜେରୀୟ ପିଡଗିନ୍',
 				'peo' => 'ପୁରୁଣା ପର୍ସିଆନ୍',
 				'phn' => 'ଫୋନେସିଆନ୍',
 				'pi' => 'ପାଲି',
 				'pl' => 'ପୋଲିଶ୍',
 				'pon' => 'ପୋହପିଏନ୍',
 				'prg' => 'ପ୍ରୁସିୟ',
 				'pro' => 'ପୁରୁଣା ପ୍ରେଭେନେସିଆଲ୍',
 				'ps' => 'ପାସ୍ତୋ',
 				'pt' => 'ପର୍ତ୍ତୁଗୀଜ୍‌',
 				'pt_BR' => 'ବ୍ରାଜିଲିଆନ୍ ପର୍ତ୍ତୁଗୀଜ୍',
 				'pt_PT' => 'ୟୁରୋପୀୟ ପର୍ତ୍ତୁଗୀଜ୍‌',
 				'qu' => 'କ୍ୱେଚୁଆ',
 				'quc' => 'କିଚେ',
 				'raj' => 'ରାଜସ୍ଥାନୀ',
 				'rap' => 'ରାପାନୁଇ',
 				'rar' => 'ରାରୋତୋଙ୍ଗନ୍',
 				'rm' => 'ରୋମାନଶ୍‌',
 				'rn' => 'ରୁଣ୍ଡି',
 				'ro' => 'ରୋମାନିଆନ୍',
 				'ro_MD' => 'ମୋଲଡୋଭିଆନ୍',
 				'rof' => 'ରୋମ୍ବୋ',
 				'rom' => 'ରୋମାନି',
 				'root' => 'ରୋଟ୍',
 				'ru' => 'ରୁଷିୟ',
 				'rup' => 'ଆରୋମାନିଆନ୍',
 				'rw' => 'କିନ୍ୟାରୱାଣ୍ଡା',
 				'rwk' => 'ଆରଡବ୍ୟୁଏ',
 				'sa' => 'ସଂସ୍କୃତ',
 				'sad' => 'ସଣ୍ଡାୱେ',
 				'sah' => 'ସାଖା',
 				'sam' => 'ସାମୌରିଟନ୍ ଆରମାଇକ୍',
 				'saq' => 'ସମବୁରୁ',
 				'sas' => 'ସାସାକ୍',
 				'sat' => 'ସାନ୍ତାଳି',
 				'sba' => 'ନଗାମବେ',
 				'sbp' => 'ସାନଗୁ',
 				'sc' => 'ସର୍ଦିନିଆନ୍',
 				'scn' => 'ସିଶିଲିଆନ୍',
 				'sco' => 'ସ୍କଟସ୍',
 				'sd' => 'ସିନ୍ଧୀ',
 				'se' => 'ଉତ୍ତର ସାମି',
 				'seh' => 'ସେନା',
 				'sel' => 'ସେଲ୍କପ୍',
 				'ses' => 'କୋୟରା ସେନ୍ନି',
 				'sg' => 'ସାଙ୍ଗୋ',
 				'sga' => 'ପୁରୁଣା ଇରିଶ୍',
 				'sh' => 'ସର୍ବୋ-କ୍ରୋଆଟିଆନ୍',
 				'shi' => 'ତାଚେଲହିଟ୍',
 				'shn' => 'ଶାନ୍',
 				'si' => 'ସିଂହଳ',
 				'sid' => 'ସିଦାମୋ',
 				'sk' => 'ସ୍ଲୋଭାକ୍',
 				'sl' => 'ସ୍ଲୋଭେନିଆନ୍',
 				'sm' => 'ସାମୋଆନ୍',
 				'sma' => 'ଦକ୍ଷିଣ ସାମି',
 				'smj' => 'ଲୁଲେ ସାମି',
 				'smn' => 'ଇନାରୀ ସାମି',
 				'sms' => 'ସ୍କୋଲ୍ଟ ସାମି',
 				'sn' => 'ଶୋନା',
 				'snk' => 'ସୋନିଙ୍କେ',
 				'so' => 'ସୋମାଲିଆ',
 				'sog' => 'ସୋଗଡିଏନ୍',
 				'sq' => 'ଆଲବାନିଆନ୍',
 				'sr' => 'ସର୍ବିୟ',
 				'srn' => 'ଶାରାନା ଟୋଙ୍ଗୋ',
 				'srr' => 'ଶେରେର୍',
 				'ss' => 'ସ୍ଵାତି',
 				'ssy' => 'ସହୋ',
 				'st' => 'ସେସୋଥୋ',
 				'su' => 'ସୁଦାନୀଜ୍',
 				'suk' => 'ସୁକୁମା',
 				'sus' => 'ଶୁଶୁ',
 				'sux' => 'ସୁମେରିଆନ୍',
 				'sv' => 'ସ୍ୱେଡିସ୍',
 				'sw' => 'ସ୍ୱାହିଲ୍',
 				'sw_CD' => 'କଙ୍ଗୋ ସ୍ୱାହିଲି',
 				'swb' => 'କୋମୋରିୟ',
 				'syc' => 'କ୍ଲାସିକାଲ୍ ସିରିକ୍',
 				'syr' => 'ସିରିକ୍',
 				'ta' => 'ତାମିଲ୍',
 				'te' => 'ତେଲୁଗୁ',
 				'tem' => 'ତିମନେ',
 				'teo' => 'ତେସା',
 				'ter' => 'ତେରେନୋ',
 				'tet' => 'ତେତୁମ୍',
 				'tg' => 'ତାଜିକ୍',
 				'th' => 'ଥାଇ',
 				'ti' => 'ଟ୍ରିଗିନିଆ',
 				'tig' => 'ଟାଇଗ୍ରେ',
 				'tiv' => 'ତୀଭ୍',
 				'tk' => 'ତୁର୍କମେନ୍',
 				'tkl' => 'ଟୋକେଲାଉ',
 				'tl' => 'ଟାଗାଲଗ୍',
 				'tlh' => 'କ୍ଲିଙ୍ଗନ୍',
 				'tli' => 'ତ୍ଲିଙ୍ଗିଟ୍',
 				'tmh' => 'ତାମାଶେକ୍',
 				'tn' => 'ସୱାନା',
 				'to' => 'ଟୋଙ୍ଗା',
 				'tog' => 'ନ୍ୟାସା ଟୋଙ୍ଗୋ',
 				'tpi' => 'ଟୋକ୍ ପିସିନ୍',
 				'tr' => 'ତୁର୍କିସ୍',
 				'trv' => 'ତାରୋକୋ',
 				'ts' => 'ସୋଙ୍ଗା',
 				'tsi' => 'ତିସିମିସିଆନ୍',
 				'tt' => 'ତାତାର୍',
 				'tum' => 'ଟୁମ୍ବୁକା',
 				'tvl' => 'ତୁଭାଲୁ',
 				'tw' => 'ତ୍ୱି',
 				'twq' => 'ତାସାୱାକ୍',
 				'ty' => 'ତାହିତିଆନ୍',
 				'tyv' => 'ତୁଭିନିଆନ୍',
 				'tzm' => 'କେନ୍ଦ୍ରୀୟ ଆଟଲାସ୍ ଟାମାଜିଘାଟ୍',
 				'udm' => 'ଉଦମୂର୍ତ୍ତ',
 				'ug' => 'ୟୁଘୁର୍',
 				'uga' => 'ୟୁଗୋରଟିକ୍',
 				'uk' => 'ୟୁକ୍ରାନିଆନ୍',
 				'umb' => 'ଉମ୍ବୁଣ୍ଡୁ',
 				'und' => 'ଅଜଣା ଭାଷା',
 				'ur' => 'ଉର୍ଦ୍ଦୁ',
 				'uz' => 'ଉଜବେକ୍',
 				'vai' => 'ଭାଇ',
 				've' => 'ଭେଣ୍ଡା',
 				'vi' => 'ଭିଏତନାମିଜ୍',
 				'vo' => 'ବୋଲାପୁକ',
 				'vot' => 'ଭୋଟିକ୍',
 				'vun' => 'ଭୁନଜୋ',
 				'wa' => 'ୱାଲୁନ୍',
 				'wae' => 'ୱାଲସେର୍',
 				'wal' => 'ୱାଲମୋ',
 				'war' => 'ୱାରୈ',
 				'was' => 'ୱାସୋ',
 				'wo' => 'ୱୋଲଫ୍',
 				'xal' => 'କାଲ୍ମୀକ୍',
 				'xh' => 'ଖୋସା',
 				'xog' => 'ସୋଗା',
 				'yao' => 'ୟାଓ',
 				'yap' => 'ୟାପୀସ୍',
 				'yav' => 'ୟାଂବେନ୍',
 				'ybb' => 'ୟେମବା',
 				'yi' => 'ୟିଡିସ୍',
 				'yo' => 'ୟୋରୁବା',
 				'yue' => 'କାନଟୋନେସେ',
 				'za' => 'ଜୁଆଙ୍ଗ',
 				'zap' => 'ଜାପୋଟେକ୍',
 				'zbl' => 'ବ୍ଲିସିମ୍ବଲସ୍',
 				'zen' => 'ଜେନାଗା',
 				'zgh' => 'ମାନାଙ୍କ ମରୋକିୟ ତାମାଜିଘାଟ୍',
 				'zh' => 'ଚାଇନିଜ୍‌',
 				'zh_Hans' => 'ସରଳୀକୃତ ଚାଇନିଜ୍‌',
 				'zh_Hant' => 'ପାରମ୍ପରିକ ଚାଇନିଜ୍‌',
 				'zu' => 'ଜୁଲୁ',
 				'zun' => 'ଜୁନୀ',
 				'zxx' => 'କୌଣସି ଲିଙ୍ଗୁଇଷ୍ଟ ସାମଗ୍ରୀ ନାହିଁ',
 				'zza' => 'ଜାଜା',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'ଆରବିକ୍',
 			'Armi' => 'ଇମ୍ପେରିଆଲ୍ ଆରମିକ୍',
 			'Armn' => 'ଆର୍ମେନୀୟ',
 			'Avst' => 'ଆବେସ୍ଥାନ୍',
 			'Bali' => 'ବାଲିନୀଜ୍',
 			'Batk' => 'ବାଟାକ୍',
 			'Beng' => 'ବଙ୍ଗାଳୀ',
 			'Blis' => 'ବ୍ଲିସିମ୍ବଲସ୍',
 			'Bopo' => 'ବୋପୋମୋଫୋ',
 			'Brah' => 'ବ୍ରାହ୍ମୀ',
 			'Brai' => 'ବ୍ରେଲ୍',
 			'Bugi' => 'ବୁଗାନୀଜ୍',
 			'Buhd' => 'ବୁହିଦ୍',
 			'Cakm' => 'ଚକମା',
 			'Cans' => 'ୟୁନିଫାଏଡ୍ କାନାଡିଆନ୍ ଆବ୍ରୋଜିନାଲ୍ ସିଲାବିକସ୍',
 			'Cari' => 'କୈରନ୍',
 			'Cham' => 'ଛମ୍',
 			'Cher' => 'ଚିରୁକୀ',
 			'Cirt' => 'ସିର୍ଥ',
 			'Copt' => 'କପଟିକ୍',
 			'Cprt' => 'ସିପ୍ରଅଟ୍',
 			'Cyrl' => 'ସିରିଲିକ୍',
 			'Cyrs' => 'ଓଲ୍ଡ ଚର୍ଚ୍ଚ ସାଲଭୋନିକ୍ ସିରିଲିକ୍',
 			'Deva' => 'ଦେବନଗରୀ',
 			'Dsrt' => 'ଡେସର୍ଟ',
 			'Egyd' => 'ଇଜିପ୍ଟିଆନ୍ ଡେମୋଟିକ୍',
 			'Egyh' => 'ଇଜିପ୍ଟିଆନ୍ ହାଇଅରଟିକ୍',
 			'Egyp' => 'ଇଜିପ୍ଟିଆନ୍ ହାଅରଗ୍ଲିପସ୍',
 			'Ethi' => 'ଇଥିଓପିକ୍‌',
 			'Geok' => 'ଜର୍ଜିଆନ୍ ଖୁଟସୁରୀ',
 			'Geor' => 'ଜର୍ଜିୟ',
 			'Glag' => 'ଗ୍ଲାଗ୍ଲୋଟିକ୍',
 			'Goth' => 'ଗୋଥିକ୍',
 			'Grek' => 'ଗ୍ରୀକ୍',
 			'Gujr' => 'ଗୁଜୁରାଟୀ',
 			'Guru' => 'ଗୁରମୁଖୀ',
 			'Hanb' => 'ବୋପୋମୋଫୋ ସହିତ ହାନ୍‌',
 			'Hang' => 'ହାଙ୍ଗୁଲ୍',
 			'Hani' => 'ହାନ୍',
 			'Hano' => 'ହାନୁନ୍',
 			'Hans' => 'ସରଳୀକୃତ',
 			'Hans@alt=stand-alone' => 'ସରଳୀକୃତ ହାନ୍‌',
 			'Hant' => 'ପାରମ୍ପରିକ',
 			'Hant@alt=stand-alone' => 'ପାରମ୍ପରିକ ହାନ୍‌',
 			'Hebr' => 'ହିବୃ',
 			'Hira' => 'ହିରାଗାନା',
 			'Hmng' => 'ପାହୋ ହୋଙ୍ଗ',
 			'Hrkt' => 'ଜାପାନୀ ସିଲାବରିଜ୍‌',
 			'Hung' => 'ପୁରୁଣା ହଙ୍ଗେରିଆନ୍',
 			'Inds' => 'ସିନ୍ଧୁ',
 			'Ital' => 'ପୁରୁଣା ଇଟାଲୀ',
 			'Jamo' => 'ଜାମୋ',
 			'Java' => 'ଜାଭାନୀଜ୍',
 			'Jpan' => 'ଜାପାନୀଜ୍',
 			'Kali' => 'କାୟାହା ଲୀ',
 			'Kana' => 'କାତାକାନା',
 			'Khar' => 'ଖାରୋସ୍ଥି',
 			'Khmr' => 'ଖମେର୍',
 			'Knda' => 'କନ୍ନଡ଼',
 			'Kore' => 'କୋରିଆନ୍',
 			'Kthi' => 'କୈଥି',
 			'Lana' => 'ଲାନା',
 			'Laoo' => 'ଲାଓ',
 			'Latf' => 'ଫ୍ରାକଥୁର୍ ଲାଟିନ୍',
 			'Latg' => 'ଗାଏଲିକ୍ ଲାଟିନ୍',
 			'Latn' => 'ଲାଟିନ୍',
 			'Lepc' => 'ଲେପଚା',
 			'Limb' => 'ଲିମ୍ବୁ',
 			'Lina' => 'ଲିନିୟର୍',
 			'Linb' => 'ଲିନିୟର୍ ବି',
 			'Lyci' => 'ଲିଶିୟନ୍',
 			'Lydi' => 'ଲିଡିୟନ୍',
 			'Mand' => 'ମାନଡେନ୍',
 			'Mani' => 'ମନଶୀନ୍',
 			'Maya' => 'ମୟାନ୍ ହାୟରଲଜିକସ୍',
 			'Mero' => 'ମେରୋଇଟିକ୍',
 			'Mlym' => 'ମାଲାୟଲମ୍',
 			'Mong' => 'ମଙ୍ଗୋଲିଆନ୍',
 			'Moon' => 'ଚନ୍ଦ୍ର',
 			'Mtei' => 'ମାଏତି ମାୟେକ୍',
 			'Mymr' => 'ମ୍ୟାନମାର୍',
 			'Nkoo' => 'ଏନ୍ କୋ',
 			'Ogam' => 'ଓଘାମା',
 			'Olck' => 'ଓଲ୍ ଚିକି',
 			'Orkh' => 'ଓରୋଖନ୍',
 			'Orya' => 'ଓଡ଼ିଆ',
 			'Osma' => 'ଓସୋମାନିୟା',
 			'Perm' => 'ଓଲ୍ଡ ପରମିକ୍',
 			'Phag' => 'ଫାଗସ୍-ପା',
 			'Phli' => 'ଇନସ୍କ୍ରୀପସାନଲ୍ ପାହାଲାୱୀ',
 			'Phlp' => 'ସ୍ଲାଟର୍ ପାହାଲାୱୀ',
 			'Phlv' => 'ବୁକ୍ ପାହାଲାୱୀ',
 			'Phnx' => 'ଫେନୋସିଆନ୍',
 			'Plrd' => 'ପୋଲାର୍ଡ ଫୋନେଟିକ୍',
 			'Prti' => 'ଇନସ୍କ୍ରୀପସାନଲ୍ ପାର୍ଥିଆନ୍',
 			'Rjng' => 'ରେଜାଙ୍ଗ',
 			'Roro' => 'ରୋଙ୍ଗୋରୋଙ୍ଗୋ',
 			'Runr' => 'ରନିକ୍',
 			'Samr' => 'ସମୌରିଟନ୍',
 			'Sara' => 'ସାରାତି',
 			'Saur' => 'ସୌରାଷ୍ଟ୍ର',
 			'Sgnw' => 'ସାଙ୍କେତିକ ଲିଖ',
 			'Shaw' => 'ସାବିୟାନ୍',
 			'Sinh' => 'ସିଂହଳ',
 			'Sund' => 'ସୁଦାନୀଜ୍',
 			'Sylo' => 'ସୀଲିତୋ ନଗରୀ',
 			'Syrc' => 'ସିରିୟାକ୍',
 			'Syre' => 'ଏଷ୍ଟ୍ରାଙ୍ଗେଲୋ ସିରିକ୍',
 			'Syrj' => 'ୱେଷ୍ଟର୍ନ ସିରିକ୍',
 			'Syrn' => 'ଇଷ୍ଟର୍ନ ସିରିକ୍',
 			'Tagb' => 'ତଗବାନ୍ୱା',
 			'Tale' => 'ତାଇ ଲେ',
 			'Talu' => 'ନୂତନ ତାଇ ଲୁଏ',
 			'Taml' => 'ତାମିଲ୍',
 			'Tavt' => 'ତାଇ ଭିଏତ୍',
 			'Telu' => 'ତେଲୁଗୁ',
 			'Teng' => 'ତେଙ୍ଗୱାର୍',
 			'Tfng' => 'ତିଫିଙ୍ଘା',
 			'Tglg' => 'ଟାଗାଲୋଗ୍',
 			'Thaa' => 'ଥାନା',
 			'Thai' => 'ଥାଇ',
 			'Tibt' => 'ତିବେତାନ୍',
 			'Ugar' => 'ୟୁଗାରିଟିକ୍',
 			'Vaii' => 'ୱାଇ',
 			'Visp' => 'ଭିଜିବଲ୍ ସ୍ପିଚ୍',
 			'Xpeo' => 'ପୁରୁଣା ଫରାସୀ',
 			'Xsux' => 'ସୁମେରୋ-ଆକ୍କାଡିଆନ୍ ସୁନିଫର୍ମ',
 			'Yiii' => 'ୟୀ',
 			'Zinh' => 'ବଂଶଗତ',
 			'Zmth' => 'ଗାଣିତିକ ନୋଟେସନ୍',
 			'Zsye' => 'ଇମୋଜି',
 			'Zsym' => 'ସଙ୍କେତଗୁଡ଼ିକ',
 			'Zxxx' => 'ଅଲିଖିତ',
 			'Zyyy' => 'ସାଧାରଣ',
 			'Zzzz' => 'ଅଜଣା ଲିପି',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ବିଶ୍ୱ',
 			'002' => 'ଆଫ୍ରିକା',
 			'003' => 'ଉତ୍ତର ଆମେରିକା',
 			'005' => 'ଦକ୍ଷିଣ ଆମେରିକା',
 			'009' => 'ଓସିନିଆ',
 			'011' => 'ପଶ୍ଚିମ ଆଫ୍ରିକା',
 			'013' => 'ମଧ୍ୟ ଆମେରିକା',
 			'014' => 'ପୂର୍ବ ଆଫ୍ରିକା',
 			'015' => 'ଉତ୍ତର ଆଫ୍ରିକା',
 			'017' => 'ମଧ୍ୟ ଆଫ୍ରିକା',
 			'018' => 'ଦକ୍ଷିଣସ୍ଥ ଆଫ୍ରିକା',
 			'019' => 'ଆମେରିକା',
 			'021' => 'ଉତ୍ତରସ୍ଥ ଆମେରିକା',
 			'029' => 'କାରିବିଆନ୍',
 			'030' => 'ପୂର୍ବ ଏସିଆ',
 			'034' => 'ଦକ୍ଷିଣ ଏସିଆ',
 			'035' => 'ଦକ୍ଷିଣପୂର୍ବ ଏସିଆ',
 			'039' => 'ଦକ୍ଷିଣ ୟୁରୋପ୍',
 			'053' => 'ଅଷ୍ଟ୍ରେଲେସିଆ',
 			'054' => 'ମେଲାନେସିଆ',
 			'057' => 'ମାଇକ୍ରୋନେସିଆନ୍ ଅଞ୍ଚଳ',
 			'061' => 'ପଲିନେସିଆ',
 			'142' => 'ଏସିଆ',
 			'143' => 'ମଧ୍ୟ ଏସିଆ',
 			'145' => 'ପଶ୍ଚିମ ଏସିଆ',
 			'150' => 'ୟୁରୋପ୍',
 			'151' => 'ପୂର୍ବ ୟୁରୋପ୍',
 			'154' => 'ଉତ୍ତର ୟୁରୋପ୍',
 			'155' => 'ପଶ୍ଚିମ ୟୁରୋପ୍',
 			'202' => 'ଉପ-ସାହାରା ଆଫ୍ରିକା',
 			'419' => 'ଲାଟିନ୍‌ ଆମେରିକା',
 			'AC' => 'ଆସେନସିଅନ୍‌ ଦ୍ୱୀପ',
 			'AD' => 'ଆଣ୍ଡୋରା',
 			'AE' => 'ସଂଯୁକ୍ତ ଆରବ ଏମିରେଟସ୍',
 			'AF' => 'ଆଫଗାନିସ୍ତାନ୍',
 			'AG' => 'ଆଣ୍ଟିଗୁଆ ଏବଂ ବାରବୁଦା',
 			'AI' => 'ଆଙ୍ଗୁଇଲ୍ଲା',
 			'AL' => 'ଆଲବାନିଆ',
 			'AM' => 'ଆର୍ମେନିଆ',
 			'AO' => 'ଆଙ୍ଗୋଲା',
 			'AQ' => 'ଆଣ୍ଟାର୍କାଟିକା',
 			'AR' => 'ଆର୍ଜେଣ୍ଟିନା',
 			'AS' => 'ଆମେରିକାନ୍ ସାମୋଆ',
 			'AT' => 'ଅଷ୍ଟ୍ରିଆ',
 			'AU' => 'ଅଷ୍ଟ୍ରେଲିଆ',
 			'AW' => 'ଆରୁବା',
 			'AX' => 'ଅଲାଣ୍ଡ ଦ୍ଵୀପପୁଞ୍ଜ',
 			'AZ' => 'ଆଜେରବାଇଜାନ୍',
 			'BA' => 'ବୋସନିଆ ଏବଂ ହର୍ଜଗୋଭିନା',
 			'BB' => 'ବାରବାଡୋସ୍',
 			'BD' => 'ବାଂଲାଦେଶ',
 			'BE' => 'ବେଲଜିୟମ୍',
 			'BF' => 'ବୁର୍କିନା ଫାସୋ',
 			'BG' => 'ବୁଲଗେରିଆ',
 			'BH' => 'ବାହାରିନ୍',
 			'BI' => 'ବୁରୁଣ୍ଡି',
 			'BJ' => 'ବେନିନ୍',
 			'BL' => 'ସେଣ୍ଟ ବାର୍ଥେଲେମି',
 			'BM' => 'ବର୍ମୁଡା',
 			'BN' => 'ବ୍ରୁନେଇ',
 			'BO' => 'ବୋଲଭିଆ',
 			'BQ' => 'କାରବିୟନ୍‌ ନେଦରଲ୍ୟାଣ୍ଡ',
 			'BR' => 'ବ୍ରାଜିଲ୍',
 			'BS' => 'ବାହାମାସ୍',
 			'BT' => 'ଭୁଟାନ',
 			'BV' => 'ବୌଭେଟ୍‌ ଦ୍ୱୀପ',
 			'BW' => 'ବୋଟସ୍ୱାନା',
 			'BY' => 'ବେଲାରୁଷ୍',
 			'BZ' => 'ବେଲିଜ୍',
 			'CA' => 'କାନାଡା',
 			'CC' => 'କୋକୋସ୍ (କୀଲିଂ) ଦ୍ଵୀପପୁଞ୍ଜ',
 			'CD' => 'କଙ୍ଗୋ-କିନସାସା',
 			'CD@alt=variant' => 'କଙ୍ଗୋ (ଡିଆରସି)',
 			'CF' => 'ମଧ୍ୟ ଆଫ୍ରିକୀୟ ସାଧାରଣତନ୍ତ୍ର',
 			'CG' => 'କଙ୍ଗୋ-ବ୍ରାଜିଭିଲ୍ଲେ',
 			'CG@alt=variant' => 'କଙ୍ଗୋ (ସାଧାରଣତନ୍ତ୍ର)',
 			'CH' => 'ସ୍ୱିଜରଲ୍ୟାଣ୍ଡ',
 			'CI' => 'କୋତ୍ ଡି ଭ୍ଵାର୍',
 			'CI@alt=variant' => 'ଆଇଭରୀ କୋଷ୍ଟ',
 			'CK' => 'କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'CL' => 'ଚିଲ୍ଲୀ',
 			'CM' => 'କାମେରୁନ୍',
 			'CN' => 'ଚିନ୍',
 			'CO' => 'କୋଲମ୍ବିଆ',
 			'CP' => 'କ୍ଲିପରଟନ୍‌ ଦ୍ୱୀପ',
 			'CR' => 'କୋଷ୍ଟା ରିକା',
 			'CU' => 'କ୍ୱିବା',
 			'CV' => 'କେପ୍ ଭର୍ଦେ',
 			'CW' => 'କୁରାକାଓ',
 			'CX' => 'ଖ୍ରୀଷ୍ଟମାସ ଦ୍ୱୀପ',
 			'CY' => 'ସାଇପ୍ରସ୍',
 			'CZ' => 'ଚେଚିଆ',
 			'CZ@alt=variant' => 'ଚେକ୍‌ ସାଧାରଣତନ୍ତ୍ର',
 			'DE' => 'ଜର୍ମାନୀ',
 			'DG' => 'ଡିଏଗୋ ଗାର୍ସିଆ',
 			'DJ' => 'ଜିବୋଟି',
 			'DK' => 'ଡେନମାର୍କ',
 			'DM' => 'ଡୋମିନିକା',
 			'DO' => 'ଡୋମିନିକାନ୍‌ ସାଧାରଣତନ୍ତ୍ର',
 			'DZ' => 'ଆଲଜେରିଆ',
 			'EA' => 'ସିଉଟା ଏବଂ ମେଲିଲା',
 			'EC' => 'ଇକ୍ୱାଡୋର୍',
 			'EE' => 'ଏସ୍ତୋନିଆ',
 			'EG' => 'ଇଜିପ୍ଟ',
 			'EH' => 'ପଶ୍ଚିମ ସାହାରା',
 			'ER' => 'ଇରିଟ୍ରିୟା',
 			'ES' => 'ସ୍ପେନ୍',
 			'ET' => 'ଇଥିଓପିଆ',
 			'EU' => 'ୟୁରୋପୀୟ ସଂଘ',
 			'EZ' => 'ୟୁରୋକ୍ଷେତ୍ର',
 			'FI' => 'ଫିନଲ୍ୟାଣ୍ଡ',
 			'FJ' => 'ଫିଜି',
 			'FK' => 'ଫକ୍‌ଲ୍ୟାଣ୍ଡ ଦ୍ଵୀପପୁଞ୍ଜ',
 			'FK@alt=variant' => 'ଫକଲ୍ୟାଣ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ (ଇସଲାସ୍‌ ମାଲଭିନାସ୍‌)',
 			'FM' => 'ମାଇକ୍ରୋନେସିଆ',
 			'FO' => 'ଫାରୋଇ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'FR' => 'ଫ୍ରାନ୍ସ',
 			'GA' => 'ଗାବୋନ୍',
 			'GB' => 'ଯୁକ୍ତରାଜ୍ୟ',
 			'GB@alt=short' => 'ୟୁକେ',
 			'GD' => 'ଗ୍ରେନାଡା',
 			'GE' => 'ଜର୍ଜିଆ',
 			'GF' => 'ଫ୍ରେଞ୍ଚ ଗୁଇନା',
 			'GG' => 'ଗୁଏରନେସି',
 			'GH' => 'ଘାନା',
 			'GI' => 'ଜିବ୍ରାଲ୍ଟର୍',
 			'GL' => 'ଗ୍ରୀନଲ୍ୟାଣ୍ଡ',
 			'GM' => 'ଗାମ୍ବିଆ',
 			'GN' => 'ଗୁଇନିଆ',
 			'GP' => 'ଗୁଆଡେଲୋପ୍',
 			'GQ' => 'ଇକ୍ବାଟେରିଆଲ୍ ଗୁଇନିଆ',
 			'GR' => 'ଗ୍ରୀସ୍',
 			'GS' => 'ଦକ୍ଷିଣ ଜର୍ଜିଆ ଏବଂ ଦକ୍ଷିଣ ସାଣ୍ଡୱିଚ୍ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'GT' => 'ଗୁଏତମାଲା',
 			'GU' => 'ଗୁଆମ୍',
 			'GW' => 'ଗୁଇନିଆ-ବିସାଉ',
 			'GY' => 'ଗୁଇନା',
 			'HK' => 'ହଂ କଂ ଏସଏଆର୍‌ ଚାଇନା',
 			'HK@alt=short' => 'ହଂ କଂ',
 			'HM' => 'ହାର୍ଡ୍‌ ଏବଂ ମ୍ୟାକଡୋନାଲ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'HN' => 'ହୋଣ୍ଡୁରାସ୍‌',
 			'HR' => 'କ୍ରୋଏସିଆ',
 			'HT' => 'ହାଇତି',
 			'HU' => 'ହଙ୍ଗେରୀ',
 			'IC' => 'କେନେରୀ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'ID' => 'ଇଣ୍ଡୋନେସିଆ',
 			'IE' => 'ଆୟରଲ୍ୟାଣ୍ଡ',
 			'IL' => 'ଇସ୍ରାଏଲ୍',
 			'IM' => 'ଆଇଲ୍‌ ଅଫ୍‌ ମ୍ୟାନ୍‌',
 			'IN' => 'ଭାରତ',
 			'IO' => 'ବ୍ରିଟିଶ୍‌ ଭାରତ ମାହାସାଗର କ୍ଷେତ୍ର',
 			'IQ' => 'ଇରାକ୍',
 			'IR' => 'ଇରାନ',
 			'IS' => 'ଆଇସଲ୍ୟାଣ୍ଡ',
 			'IT' => 'ଇଟାଲୀ',
 			'JE' => 'ଜର୍ସି',
 			'JM' => 'ଜାମାଇକା',
 			'JO' => 'ଜୋର୍ଡାନ୍',
 			'JP' => 'ଜାପାନ',
 			'KE' => 'କେନିୟା',
 			'KG' => 'କିର୍ଗିଜିସ୍ତାନ',
 			'KH' => 'କାମ୍ବୋଡିଆ',
 			'KI' => 'କିରିବାଟି',
 			'KM' => 'କୋମୋରସ୍',
 			'KN' => 'ସେଣ୍ଟ କିଟସ୍‌ ଏବଂ ନେଭିସ୍‌',
 			'KP' => 'ଉତ୍ତର କୋରିଆ',
 			'KR' => 'ଦକ୍ଷିଣ କୋରିଆ',
 			'KW' => 'କୁଏତ୍',
 			'KY' => 'କେମ୍ୟାନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'KZ' => 'କାଜାକାସ୍ତାନ',
 			'LA' => 'ଲାଓସ୍',
 			'LB' => 'ଲେବାନନ୍',
 			'LC' => 'ସେଣ୍ଟ ଲୁସିଆ',
 			'LI' => 'ଲିଚେଟନଷ୍ଟେଇନ୍',
 			'LK' => 'ଶ୍ରୀଲଙ୍କା',
 			'LR' => 'ଲାଇବେରିଆ',
 			'LS' => 'ଲେସୋଥୋ',
 			'LT' => 'ଲିଥୁଆନିଆ',
 			'LU' => 'ଲକ୍ସେମବର୍ଗ',
 			'LV' => 'ଲାଟଭିଆ',
 			'LY' => 'ଲିବ୍ୟା',
 			'MA' => 'ମୋରୋକ୍କୋ',
 			'MC' => 'ମୋନାକୋ',
 			'MD' => 'ମୋଲଡୋଭା',
 			'ME' => 'ମଣ୍ଟେନିଗ୍ରୋ',
 			'MF' => 'ସେଣ୍ଟ ମାର୍ଟିନ୍',
 			'MG' => 'ମାଡାଗାସ୍କର୍',
 			'MH' => 'ମାର୍ଶାଲ୍ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'MK' => 'ମାସେଡୋନିଆ',
 			'MK@alt=variant' => 'ମାସେଡୋନିଆ (ଏଫ୍‌‌ୱାଇଆର୍‌‌ଓଏମ୍)',
 			'ML' => 'ମାଲି',
 			'MM' => 'ମିଆଁମାର',
 			'MN' => 'ମଙ୍ଗୋଲିଆ',
 			'MO' => 'ମାକାଉ ଏସଏଆର୍‌ ଚାଇନା',
 			'MO@alt=short' => 'ମାକାଉ',
 			'MP' => 'ଉତ୍ତର ମାରିଆନା ଦ୍ୱୀପପୁଞ୍ଜ',
 			'MQ' => 'ମାର୍ଟିନିକ୍ୟୁ',
 			'MR' => 'ମୌରିଟାନିଆ',
 			'MS' => 'ମଣ୍ଟେସେରାଟ୍',
 			'MT' => 'ମାଲ୍ଟା',
 			'MU' => 'ମରିସସ',
 			'MV' => 'ମାଲଦିଭସ୍‌',
 			'MW' => 'ମାଲୱି',
 			'MX' => 'ମେକ୍ସିକୋ',
 			'MY' => 'ମାଲେସିଆ',
 			'MZ' => 'ମୋଜାମ୍ବିକ୍‌',
 			'NA' => 'ନାମିବିଆ',
 			'NC' => 'ନୂତନ କାଲେଡୋନିଆ',
 			'NE' => 'ନାଇଜର',
 			'NF' => 'ନର୍ଫକ୍ ଦ୍ଵୀପ',
 			'NG' => 'ନାଇଜେରିଆ',
 			'NI' => 'ନିକାରାଗୁଆ',
 			'NL' => 'ନେଦରଲ୍ୟାଣ୍ଡ',
 			'NO' => 'ନରୱେ',
 			'NP' => 'ନେପାଳ',
 			'NR' => 'ନାଉରୁ',
 			'NU' => 'ନିଉ',
 			'NZ' => 'ନ୍ୟୁଜିଲାଣ୍ଡ',
 			'OM' => 'ଓମାନ୍',
 			'PA' => 'ପାନାମା',
 			'PE' => 'ପେରୁ',
 			'PF' => 'ଫ୍ରେଞ୍ଚ ପଲିନେସିଆ',
 			'PG' => 'ପପୁଆ ନ୍ୟୁ ଗୁଏନିଆ',
 			'PH' => 'ଫିଲିପାଇନସ୍',
 			'PK' => 'ପାକିସ୍ତାନ',
 			'PL' => 'ପୋଲାଣ୍ଡ',
 			'PM' => 'ସେଣ୍ଟ ପିଏରେ ଏବଂ ମିକ୍ୱେଲନ୍‌',
 			'PN' => 'ପିଟକାଇରିନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'PR' => 'ପୁଏର୍ତ୍ତୋ ରିକୋ',
 			'PS' => 'ପାଲେଷ୍ଟେନିୟ ଭୂଭାଗ',
 			'PS@alt=short' => 'ପାଲେଷ୍ଟାଇନ୍',
 			'PT' => 'ପର୍ତ୍ତୁଗାଲ୍',
 			'PW' => 'ପାଲାଉ',
 			'PY' => 'ପାରାଗୁଏ',
 			'QA' => 'କତାର୍',
 			'QO' => 'ସୀମାନ୍ତବର୍ତ୍ତୀ ଓସିନିଆ',
 			'RE' => 'ରିୟୁନିଅନ୍',
 			'RO' => 'ରୋମାନିଆ',
 			'RS' => 'ସର୍ବିଆ',
 			'RU' => 'ରୁଷିଆ',
 			'RW' => 'ରାୱାଣ୍ଡା',
 			'SA' => 'ସାଉଦି ଆରବିଆ',
 			'SB' => 'ସୋଲୋମନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'SC' => 'ସେଚେଲସ୍',
 			'SD' => 'ସୁଦାନ',
 			'SE' => 'ସ୍ୱେଡେନ୍',
 			'SG' => 'ସିଙ୍ଗାପୁର୍',
 			'SH' => 'ସେଣ୍ଟ ହେଲେନା',
 			'SI' => 'ସ୍ଲୋଭେନିଆ',
 			'SJ' => 'ସାଲବାର୍ଡ ଏବଂ ଜାନ୍‌ ମାୟେନ୍‌',
 			'SK' => 'ସ୍ଲୋଭାକିଆ',
 			'SL' => 'ସିଏରା ଲିଓନ',
 			'SM' => 'ସାନ୍ ମାରିନୋ',
 			'SN' => 'ସେନେଗାଲ୍',
 			'SO' => 'ସୋମାଲିଆ',
 			'SR' => 'ସୁରିନାମ',
 			'SS' => 'ଦକ୍ଷିଣ ସୁଦାନ',
 			'ST' => 'ସାଓ ଟୋମେ ଏବଂ ପ୍ରିନସିପି',
 			'SV' => 'ଏଲ୍ ସାଲଭାଡୋର୍',
 			'SX' => 'ସିଣ୍ଟ ମାର୍ଟୀନ୍‌',
 			'SY' => 'ସିରିଆ',
 			'SZ' => 'ସ୍ୱାଜିଲ୍ୟାଣ୍ଡ',
 			'TA' => 'ଟ୍ରାଇଷ୍ଟନ୍‌ ଦା କୁନ୍‌ଚା',
 			'TC' => 'ତୁର୍କସ୍‌ ଏବଂ କାଇକୋସ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'TD' => 'ଚାଦ୍',
 			'TF' => 'ଫରାସୀ ଦକ୍ଷିଣ କ୍ଷେତ୍ର',
 			'TG' => 'ଟୋଗୋ',
 			'TH' => 'ଥାଇଲ୍ୟାଣ୍ଡ',
 			'TJ' => 'ତାଜିକିସ୍ଥାନ୍',
 			'TK' => 'ଟୋକେଲାଉ',
 			'TL' => 'ତିମୋର୍-ଲେଷ୍ଟେ',
 			'TL@alt=variant' => 'ପୂର୍ବ ତିମୋର୍‌',
 			'TM' => 'ତୁର୍କମେନିସ୍ତାନ',
 			'TN' => 'ଟ୍ୟୁନିସିଆ',
 			'TO' => 'ଟୋଙ୍ଗା',
 			'TR' => 'ତୁର୍କୀ',
 			'TT' => 'ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ',
 			'TV' => 'ତୁଭାଲୁ',
 			'TW' => 'ତାଇୱାନ',
 			'TZ' => 'ତାଞ୍ଜାନିଆ',
 			'UA' => 'ୟୁକ୍ରେନ୍',
 			'UG' => 'ଉଗାଣ୍ଡା',
 			'UM' => 'ଯୁକ୍ତରାଷ୍ଟ୍ର ଆଉଟ୍‌ଲାଇଙ୍ଗ ଦ୍ଵୀପପୁଞ୍ଜ',
 			'UN' => 'ଜାତିସଂଘ',
 			'US' => 'ଯୁକ୍ତ ରାଷ୍ଟ୍ର',
 			'US@alt=short' => 'ଯୁକ୍ତରାଷ୍ଟ୍ର',
 			'UY' => 'ଉରୁଗୁଏ',
 			'UZ' => 'ଉଜବେକିସ୍ତାନ',
 			'VA' => 'ଭାଟିକାନ୍ ସିଟି',
 			'VC' => 'ସେଣ୍ଟ ଭିନସେଣ୍ଟ ଏବଂ ଦି ଗ୍ରେନାଡିସ୍',
 			'VE' => 'ଭେନେଜୁଏଲା',
 			'VG' => 'ବ୍ରିଟିଶ୍‌ ଭର୍ଜିନ୍ ଦ୍ୱୀପପୁଞ୍ଜ',
 			'VI' => 'ଯୁକ୍ତରାଷ୍ଟ୍ର ଭିର୍ଜିନ୍ ଦ୍ଵୀପପୁଞ୍ଜ',
 			'VN' => 'ଭିଏତନାମ୍',
 			'VU' => 'ଭାନୁଆତୁ',
 			'WF' => 'ୱାଲିସ୍ ଏବଂ ଫୁତୁନା',
 			'WS' => 'ସାମୋଆ',
 			'XK' => 'କୋସୋଭୋ',
 			'YE' => 'ୟେମେନ୍',
 			'YT' => 'ମାୟୋଟେ',
 			'ZA' => 'ଦକ୍ଷିଣ ଆଫ୍ରିକା',
 			'ZM' => 'ଜାମ୍ବିଆ',
 			'ZW' => 'ଜିମ୍ବାୱେ',
 			'ZZ' => 'ଅଜଣା ଅଞ୍ଚଳ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'କ୍ୟାଲେଣ୍ଡର୍',
 			'cf' => 'ମୁଦ୍ରା ଫର୍ମାଟ୍‌',
 			'collation' => 'ସର୍ଟ୍‌ କ୍ରମ',
 			'currency' => 'ମୁଦ୍ରା',
 			'hc' => 'ଘଣ୍ଟା ଚକ୍ର (12 ବନାମ 24)',
 			'lb' => 'ଧାଡ଼ି ବିରତି ଶୈଳୀ',
 			'ms' => 'ମାପ ପଦ୍ଧତି',
 			'numbers' => 'ସଂଖ୍ୟାଗୁଡ଼ିକ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ବୌଦ୍ଧଧର୍ମାଲମ୍ବୀଙ୍କ କ୍ୟାଲେଣ୍ଡର୍‌},
 				'chinese' => q{ଚାଇନିଜ୍‌ କ୍ୟାଲେଣ୍ଡର୍‌},
 				'dangi' => q{ଦାଙ୍ଗି କ୍ୟାଲେଣ୍ଡର୍‌},
 				'ethiopic' => q{ଇଥିଓପିକ୍‌ କ୍ୟାଲେଣ୍ଡର୍‌},
 				'gregorian' => q{ଗ୍ରେଗୋରିୟ କ୍ୟାଲେଣ୍ଡର୍},
 				'hebrew' => q{ହିବୃ କ୍ୟାଲେଣ୍ଡର୍‌},
 				'islamic' => q{ଇସଲାମିକ୍‌ କ୍ୟାଲେଣ୍ଡର୍‌},
 				'iso8601' => q{ISO-8601 କ୍ୟାଲେଣ୍ଡର୍‌},
 				'japanese' => q{ଜାପାନିଜ୍‌ କ୍ୟାଲେଣ୍ଡର୍‌},
 				'persian' => q{ପର୍ସିଆନ୍‌ କ୍ୟାଲେଣ୍ଡର୍‌},
 				'roc' => q{ମିଙ୍ଗୋଓ କ୍ୟାଲେଣ୍ଡର୍‌},
 			},
 			'cf' => {
 				'account' => q{ଏକାଉଣ୍ଟିଂ ମୁଦ୍ରା ଫର୍ମାଟ୍‌},
 				'standard' => q{ମାନାଙ୍କ ମୁଦ୍ରା ଫର୍ମାଟ୍‌},
 			},
 			'collation' => {
 				'ducet' => q{ଡିଫଲ୍ଟ ୟୁନିକୋଡ୍‌ ସର୍ଟ୍‌ କ୍ରମ},
 				'search' => q{ସାଧାରଣ ଉଦ୍ଦେଶ୍ୟ-ବିଶିଷ୍ଟ ସନ୍ଧାନ},
 				'standard' => q{ମାନାଙ୍କ ସର୍ଟ୍‌ କ୍ରମ},
 			},
 			'hc' => {
 				'h11' => q{12 ଘଣ୍ଟିଆ ପଦ୍ଧତି (0–11)},
 				'h12' => q{12 ଘଣ୍ଟିଆ ପଦ୍ଧତି (1–12)},
 				'h23' => q{24 ଘଣ୍ଟିଆ ପଦ୍ଧତି (0–23)},
 				'h24' => q{24 ଘଣ୍ଟିଆ ପଦ୍ଧତି (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ଢିଲା ଧାଡ଼ି ବିରତି ଶୈଳୀ},
 				'normal' => q{ସାଧାରଣ ଧାଡ଼ି ବିରତି ଶୈଳୀ},
 				'strict' => q{କଠୋର ଧାଡ଼ି ବିରତି ଶୈଳୀ},
 			},
 			'ms' => {
 				'metric' => q{ମେଟ୍ରିକ୍‌ ପଦ୍ଧତି},
 				'uksystem' => q{ସାମ୍ରାଜ୍ୟ ସମ୍ବନ୍ଧୀୟ ମାପ ପଦ୍ଧତି},
 				'ussystem' => q{ୟୁଏସ୍‌ ମାପ ପଦ୍ଧତି},
 			},
 			'numbers' => {
 				'arab' => q{ଆରବିକ୍‌-ଇଣ୍ଡିକ୍‌ ଅଙ୍କଗୁଡ଼ିକ},
 				'arabext' => q{ପରିବର୍ଦ୍ଧିତ ଆରବିକ୍‌-ଇଣ୍ଡିକ୍‌ ଅଙ୍କଗୁଡ଼ିକ},
 				'armn' => q{ଆର୍ମେନିୟ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'armnlow' => q{ଆର୍ମେନିୟ ଛୋଟ ଅକ୍ଷର ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'beng' => q{ବଙ୍ଗଳା ଅଙ୍କଗୁଡ଼ିକ},
 				'deva' => q{ଦେବନାଗରୀ ଅଙ୍କଗୁଡ଼ିକ},
 				'ethi' => q{ଇଥିଓପିକ୍‌ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'fullwide' => q{ପୂର୍ଣ୍ଣ-ପ୍ରସ୍ଥ ଅଙ୍କଗୁଡ଼ିକ},
 				'geor' => q{ଜର୍ଜିଆନ୍‌ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'grek' => q{ଗ୍ରୀକ୍‌ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'greklow' => q{ଗ୍ରୀକ୍‌ ଛୋଟ ଅକ୍ଷର ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'gujr' => q{ଗୁଜରାଟୀ ଅଙ୍କଗୁଡ଼ିକ},
 				'guru' => q{ଗୁରମୁଖୀ ଅଙ୍କଗୁଡ଼ିକ},
 				'hanidec' => q{ଚିନି ଦଶମିକ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'hans' => q{ସରଳୀକୃତ ଚିନି ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'hansfin' => q{ସରଳୀକୃତ ଚିନି ଆର୍ଥିକ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'hant' => q{ପାରମ୍ପରିକ ଚିନି ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'hantfin' => q{ପାରମ୍ପରିକ ଚିନି ଆର୍ଥିକ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'hebr' => q{ହିବୃ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'jpan' => q{ଜାପାନୀ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'jpanfin' => q{ଜାପାନୀ ଆର୍ଥିକ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'khmr' => q{ଖିମର୍‌ ଅଙ୍କଗୁଡ଼ିକ},
 				'knda' => q{କନ୍ନଡ଼ ଅଙ୍କଗୁଡ଼ିକ},
 				'laoo' => q{ଲାଓ ଅଙ୍କଗୁଡ଼ିକ},
 				'latn' => q{ପାଶ୍ଚାତ୍ୟ ଅଙ୍କଗୁଡ଼ିକ},
 				'mlym' => q{ମଲୟାଲମ୍ ଅଙ୍କଗୁଡ଼ିକ},
 				'mymr' => q{ମିଆଁମାର୍‌ ଅଙ୍କଗୁଡ଼ିକ},
 				'orya' => q{ଓଡ଼ିଆ ଅଙ୍କଗୁଡ଼ିକ},
 				'roman' => q{ରୋମାନ୍‌ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'romanlow' => q{ରୋମାନ୍‌ ଛୋଟ ଅକ୍ଷର ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'taml' => q{ପାରମ୍ପରିକ ତାମିଲ୍ ସଂଖ୍ୟାଗୁଡ଼ିକ},
 				'tamldec' => q{ତାମିଲ୍ ଅଙ୍କଗୁଡ଼ିକ},
 				'telu' => q{ତେଲୁଗୁ ଅଙ୍କଗୁଡ଼ିକ},
 				'thai' => q{ଥାଇ ଅଙ୍କଗୁଡ଼ିକ},
 				'tibt' => q{ତିବତୀ ଅଙ୍କଗୁଡ଼ିକ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{ମେଟ୍ରିକ୍‌},
 			'UK' => q{ୟୁକେ},
 			'US' => q{ୟୁଏସ୍‌},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ଭାଷା: {0}',
 			'script' => 'ଲିପି: {0}',
 			'region' => 'ଅଞ୍ଚଳ: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍]},
			index => ['ଅ', 'ଆ', 'ଇ', 'ଈ', 'ଉ', 'ଊ', 'ଋ', 'ଏ', 'ଐ', 'ଓ', 'ଔ', 'କ', 'ଖ', 'ଗ', 'ଘ', 'ଙ', 'ଚ', 'ଛ', 'ଜ', 'ଝ', 'ଞ', 'ଟ', 'ଠ', 'ଡ', 'ଢ', 'ଣ', 'ତ', 'ଥ', 'ଦ', 'ଧ', 'ନ', 'ପ', 'ଫ', 'ବ', 'ଭ', 'ମ', 'ଯ', 'ର', 'ଲ', 'ଳ', 'ଶ', 'ଷ', 'ସ', 'ହ', '{କ\u0B4Dଷ}'],
			main => qr{[଼ ଅ ଆ ଇ ଈ ଉ ଊ ଋ ଏ ଐ ଓ ଔ ଁ ଂ ଃ କ ଖ ଗ ଘ ଙ ଚ ଛ ଜ ଝ ଞ ଟ ଠ ଡ {ଡ଼} ଢ {ଢ଼} ଣ ତ ଥ ଦ ଧ ନ ପ ଫ ବ ଭ ମ ଯ ୟ ର ଲ ଳ ଵ ୱ ଶ ଷ ସ ହ ା ି ୀ ୁ ୂ ୃ େ ୈ ୋ ୌ ୍]},
			numbers => qr{[\- , . % ‰ + 0୦ 1୧ 2୨ 3୩ 4୪ 5୫ 6୬ 7୭ 8୮ 9୯]},
			punctuation => qr{[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['ଅ', 'ଆ', 'ଇ', 'ଈ', 'ଉ', 'ଊ', 'ଋ', 'ଏ', 'ଐ', 'ଓ', 'ଔ', 'କ', 'ଖ', 'ଗ', 'ଘ', 'ଙ', 'ଚ', 'ଛ', 'ଜ', 'ଝ', 'ଞ', 'ଟ', 'ଠ', 'ଡ', 'ଢ', 'ଣ', 'ତ', 'ଥ', 'ଦ', 'ଧ', 'ନ', 'ପ', 'ଫ', 'ବ', 'ଭ', 'ମ', 'ଯ', 'ର', 'ଲ', 'ଳ', 'ଶ', 'ଷ', 'ସ', 'ହ', '{କ\u0B4Dଷ}'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(ପ୍ରଧାନ ଦିଶା),
					},
					'acre' => {
						'name' => q(ଏକର),
						'one' => q({0} ଏକର),
						'other' => q({0} ଏକର),
					},
					'acre-foot' => {
						'name' => q(ଏକର-ଫିଟ୍),
						'one' => q({0} ଏକର-ଫୁଟ),
						'other' => q({0} ଏକର-ଫିଟ୍),
					},
					'ampere' => {
						'name' => q(ଆମ୍ପିୟର୍),
						'one' => q({0} ଆମ୍ପିୟର୍),
						'other' => q({0} ଆମ୍ପିୟର୍),
					},
					'arc-minute' => {
						'name' => q(ଆର୍କମିନିଟ୍),
						'one' => q({0}′),
						'other' => q({0} ଆର୍କମିନିଟ୍),
					},
					'arc-second' => {
						'name' => q(ଆର୍କସେକେଣ୍ଡ୍),
						'one' => q({0} ଆର୍କସେକେଣ୍ଡ୍),
						'other' => q({0} ଆର୍କସେକେଣ୍ଡ୍),
					},
					'astronomical-unit' => {
						'name' => q(ଖଗୋଲୀୟ ଏକକ),
						'one' => q({0} ଖଗୋଲୀୟ ଏକକ),
						'other' => q({0} ଖଗୋଲୀୟ ଏକକ),
					},
					'atmosphere' => {
						'name' => q(ଆଟମୋସ୍ପିଅର),
						'one' => q({0} ଆଟମୋସ୍ପିଅର),
						'other' => q({0} ଆଟମୋସ୍ପିଅର),
					},
					'bit' => {
						'name' => q(ବିଟ୍),
						'one' => q({0} ବିଟ୍),
						'other' => q({0} ବିଟ୍),
					},
					'byte' => {
						'name' => q(ବାଇଟ୍),
						'one' => q({0} ବାଇଟ୍),
						'other' => q({0} ବାଇଟ୍),
					},
					'calorie' => {
						'name' => q(କ୍ୟାଲୋରୀ),
						'one' => q({0} କ୍ୟାଲୋରୀ),
						'other' => q({0} କ୍ୟାଲୋରୀ),
					},
					'carat' => {
						'name' => q(କ୍ୟାରେଟ୍),
						'one' => q({0} କ୍ୟାରେଟ୍),
						'other' => q({0} କ୍ୟାରେଟ୍),
					},
					'celsius' => {
						'name' => q(ଡିଗ୍ରୀ ସେଲସିୟସ୍),
						'one' => q({0} ଡିଗ୍ରୀ ସେଲସିୟସ୍),
						'other' => q({0} ଡିଗ୍ରୀ ସେଲସିୟସ୍),
					},
					'centiliter' => {
						'name' => q(ସେଣ୍ଟିଲିଟର୍),
						'one' => q({0} ସେଣ୍ଟିଲିଟର୍),
						'other' => q({0} ସେଣ୍ଟିଲିଟର୍),
					},
					'centimeter' => {
						'name' => q(ସେଣ୍ଟିମିଟର୍),
						'one' => q({0} ସେଣ୍ଟିମିଟର୍),
						'other' => q({0} ସେଣ୍ଟିମିଟର୍),
						'per' => q({0} ପ୍ରତି ସେଣ୍ଟିମିଟର୍),
					},
					'century' => {
						'name' => q(ଶତାବ୍ଦୀ),
						'one' => q({0} ଶତାବ୍ଦୀ),
						'other' => q({0} ଶତାବ୍ଦୀ),
					},
					'coordinate' => {
						'east' => q({0} ପୂର୍ବ),
						'north' => q({0} ଉତ୍ତର),
						'south' => q({0} ଦକ୍ଷିଣ),
						'west' => q({0} ପଶ୍ଚିମ),
					},
					'cubic-centimeter' => {
						'name' => q(କ୍ୟୁବିକ୍ ସେଣ୍ଟିମିଟର୍),
						'one' => q({0} କ୍ୟୁବିକ୍ ସେଣ୍ଟିମିଟର୍),
						'other' => q({0} କ୍ୟୁବିକ୍ ସେଣ୍ଟିମିଟର୍),
						'per' => q({0} ପ୍ରତି କ୍ୟୁବିକ୍ ସେଣ୍ଟିମିଟର୍),
					},
					'cubic-foot' => {
						'name' => q(କ୍ୟୁବିକ୍ ଫିଟ୍),
						'one' => q({0} କ୍ୟୁବିକ୍ ଫୁଟ୍),
						'other' => q({0} କ୍ୟୁବିକ୍ ଫିଟ୍),
					},
					'cubic-inch' => {
						'name' => q(କ୍ୟୁବିକ୍ ଇଞ୍ଚ୍),
						'one' => q({0} କ୍ୟୁବିକ୍ ଇଞ୍ଚ୍),
						'other' => q({0} କ୍ୟୁବିକ୍ ଇଞ୍ଚ୍),
					},
					'cubic-kilometer' => {
						'name' => q(କ୍ୟୁବିକ୍ କିଲୋମିଟର୍),
						'one' => q({0} କ୍ୟୁବିକ୍ କିଲୋମିଟର୍),
						'other' => q({0} କ୍ୟୁବିକ୍ କିଲୋମିଟର୍),
					},
					'cubic-meter' => {
						'name' => q(କ୍ୟୁବିକ୍ ମିଟର୍),
						'one' => q({0} କ୍ୟୁବିକ୍ ମିଟର୍),
						'other' => q({0} କ୍ୟୁବିକ୍ ମିଟର୍),
						'per' => q({0} ପ୍ରତି କ୍ୟୁବିକ୍ ମିଟର୍),
					},
					'cubic-mile' => {
						'name' => q(କ୍ୟୁବିକ୍ ମାଇଲ୍),
						'one' => q({0} କ୍ୟୁବିକ୍ ମାଇଲ୍),
						'other' => q({0} କ୍ୟୁବିକ୍ ମାଇଲ୍),
					},
					'cubic-yard' => {
						'name' => q(କ୍ୟୁବିକ୍ ୟାର୍ଡ୍),
						'one' => q({0} କ୍ୟୁବିକ୍ ୟାର୍ଡ୍),
						'other' => q({0} କ୍ୟୁବିକ୍ ୟାର୍ଡ୍),
					},
					'cup' => {
						'name' => q(କପ୍),
						'one' => q({0} କପ୍),
						'other' => q({0} କପ୍),
					},
					'cup-metric' => {
						'name' => q(ମେଟ୍ରିକ୍ କପ୍),
						'one' => q({0} ମେଟ୍ରିକ୍ କପ୍),
						'other' => q({0} ମେଟ୍ରିକ୍ କପ୍),
					},
					'day' => {
						'name' => q(ଦିନ),
						'one' => q({0} ଦିନ),
						'other' => q({0} ଦିନ),
						'per' => q(ଦିନକୁ {0}),
					},
					'deciliter' => {
						'name' => q(ଡେସିଲିଟର୍),
						'one' => q({0} ଡେସିଲିଟର୍),
						'other' => q({0} ଡେସିଲିଟର୍),
					},
					'decimeter' => {
						'name' => q(ଡେସିମିଟର୍),
						'one' => q({0} ଡେସିମିଟର୍),
						'other' => q({0} ଡେସିମିଟର୍),
					},
					'degree' => {
						'name' => q(ଡିଗ୍ରୀ),
						'one' => q({0} ଡିଗ୍ରୀ),
						'other' => q({0} ଡିଗ୍ରୀ),
					},
					'fahrenheit' => {
						'name' => q(ଡିଗ୍ରୀ ଫାରେନହାଇଟ୍),
						'one' => q({0} ଡିଗ୍ରୀ ଫାରେନହାଇଟ୍),
						'other' => q({0} ଡିଗ୍ରୀ ଫାରେନହାଇଟ୍),
					},
					'fluid-ounce' => {
						'name' => q(ଫ୍ଲୁଇଡ୍ ଆଉନ୍ସ),
						'one' => q({0} ଫ୍ଲୁଇଡ୍ ଆଉନ୍ସ),
						'other' => q({0} ଫ୍ଲୁଇଡ୍ ଆଉନ୍ସ),
					},
					'foodcalorie' => {
						'name' => q(କ୍ୟାଲୋରୀ),
						'one' => q({0} କ୍ୟାଲୋରୀ),
						'other' => q({0} କ୍ୟାଲୋରୀ),
					},
					'foot' => {
						'name' => q(ଫିଟ୍),
						'one' => q({0} ଫୁଟ୍),
						'other' => q({0} ଫିଟ୍),
						'per' => q({0} ପ୍ରତି ଫୁଟ୍),
					},
					'g-force' => {
						'name' => q(ଜି-ଫୋର୍ସ୍),
						'one' => q({0} ଜି-ଫୋର୍ସ୍),
						'other' => q({0} ଜି-ଫୋର୍ସ୍),
					},
					'gallon' => {
						'name' => q(ଗ୍ୟାଲନ୍),
						'one' => q({0} ଗ୍ୟାଲନ୍),
						'other' => q({0} ଗ୍ୟାଲନ୍),
						'per' => q({0} ପ୍ରତି ଗ୍ୟାଲନ୍),
					},
					'gallon-imperial' => {
						'name' => q(ଇମ୍ପେରିଆଲ୍ ଗ୍ୟାଲନ୍),
						'one' => q({0} ଇମ୍ପେରିଆଲ୍ ଗ୍ୟାଲନ୍),
						'other' => q({0} ଇମ୍ପେରିଆଲ୍ ଗ୍ୟାଲନ୍),
						'per' => q({0} ପ୍ରତି ଇମ୍ପେରିଆଲ୍ ଗ୍ୟାଲନ୍),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ଗିଗାବିଟ୍),
						'one' => q({0} ଗିଗାବିଟ୍),
						'other' => q({0} ଗିଗାବିଟ୍),
					},
					'gigabyte' => {
						'name' => q(ଗିଗାବାଇଟ୍),
						'one' => q({0} ଗିଗାବାଇଟ୍),
						'other' => q({0} ଗିଗାବାଇଟ୍),
					},
					'gigahertz' => {
						'name' => q(ଗିଗାହର୍ଜ୍),
						'one' => q({0} ଗିଗାହର୍ଜ୍),
						'other' => q({0} ଗିଗାହର୍ଜ୍),
					},
					'gigawatt' => {
						'name' => q(ଗିଗାୱାଟ୍),
						'one' => q({0} ଗିଗାୱାଟ୍),
						'other' => q({0} ଗିଗାୱାଟ୍),
					},
					'gram' => {
						'name' => q(ଗ୍ରାମ୍),
						'one' => q({0} ଗ୍ରାମ୍),
						'other' => q({0} ଗ୍ରାମ୍),
						'per' => q({0} ପ୍ରତି ଗ୍ରାମ୍),
					},
					'hectare' => {
						'name' => q(ହେକ୍ଟର୍),
						'one' => q({0} ହେକ୍ଟର୍),
						'other' => q({0} ହେକ୍ଟର୍),
					},
					'hectoliter' => {
						'name' => q(ହେକ୍ଟୋଲିଟର୍),
						'one' => q({0} ହେକ୍ଟୋଲିଟର୍),
						'other' => q({0} ହେକ୍ଟୋଲିଟର୍),
					},
					'hectopascal' => {
						'name' => q(ହେକ୍ଟୋପାସ୍କେଲ୍),
						'one' => q({0} ହେକ୍ଟୋପାସ୍କେଲ୍),
						'other' => q({0} ହେକ୍ଟୋପାସ୍କେଲ୍),
					},
					'hertz' => {
						'name' => q(ହର୍ଜ୍),
						'one' => q({0} ହର୍ଜ୍),
						'other' => q({0} ହର୍ଜ୍),
					},
					'horsepower' => {
						'name' => q(ହର୍ସପାୱାର୍),
						'one' => q({0} ହର୍ସପାୱାର୍),
						'other' => q({0} ହର୍ସପାୱାର୍),
					},
					'hour' => {
						'name' => q(ଘଣ୍ଟା),
						'one' => q({0} ଘଣ୍ଟା),
						'other' => q({0} ଘଣ୍ଟା),
						'per' => q(ଘଣ୍ଟା ପ୍ରତି {0}),
					},
					'inch' => {
						'name' => q(ଇଞ୍ଚ୍),
						'one' => q({0} ଇଞ୍ଚ୍),
						'other' => q({0} ଇଞ୍ଚ୍),
						'per' => q({0} ପ୍ରତି ଇଞ୍ଚ୍),
					},
					'inch-hg' => {
						'name' => q(ପାରାର ଇଞ୍ଜି),
						'one' => q(ପାରାର {0} ଇଞ୍ଜି),
						'other' => q(ପାରାର {0} ଇଞ୍ଜି),
					},
					'joule' => {
						'name' => q(ଜୁଲ୍),
						'one' => q({0} ଜୁଲ୍),
						'other' => q({0} ଜୁଲ୍),
					},
					'karat' => {
						'name' => q(କ୍ୟାରେଟ୍),
						'one' => q({0} କ୍ୟାରେଟ୍),
						'other' => q({0} କ୍ୟାରେଟ୍),
					},
					'kelvin' => {
						'name' => q(କେଲଭିନ୍),
						'one' => q({0} କେଲଭିନ୍),
						'other' => q({0} କେଲଭିନ୍),
					},
					'kilobit' => {
						'name' => q(କିଲୋବିଟ୍),
						'one' => q({0} କିଲୋବିଟ୍),
						'other' => q({0} କିଲୋବିଟ୍),
					},
					'kilobyte' => {
						'name' => q(କିଲୋବାଇଟ୍),
						'one' => q({0} କିଲୋବାଇଟ୍),
						'other' => q({0} କିଲୋବାଇଟ୍),
					},
					'kilocalorie' => {
						'name' => q(କିଲୋକ୍ୟାଲୋରୀ),
						'one' => q({0} କିଲୋକ୍ୟାଲୋରୀ),
						'other' => q({0} କିଲୋକ୍ୟାଲୋରୀ),
					},
					'kilogram' => {
						'name' => q(କିଲୋଗ୍ରାମ୍),
						'one' => q({0} କିଲୋଗ୍ରାମ୍),
						'other' => q({0} କିଲୋଗ୍ରାମ୍),
						'per' => q({0} ପ୍ରତି କିଲୋଗ୍ରାମ୍),
					},
					'kilohertz' => {
						'name' => q(କିଲୋହର୍ଜ୍),
						'one' => q({0} କିଲୋହର୍ଜ୍),
						'other' => q({0} କିଲୋହର୍ଜ୍),
					},
					'kilojoule' => {
						'name' => q(କିଲୋଜୁଲ୍),
						'one' => q({0} କିଲୋଜୁଲ୍),
						'other' => q({0} କିଲୋଜୁଲ୍),
					},
					'kilometer' => {
						'name' => q(କିଲୋମିଟର୍),
						'one' => q({0} କିଲୋମିଟର୍),
						'other' => q({0} କିଲୋମିଟର୍),
						'per' => q({0} ପ୍ରତି କିଲୋମିଟର୍),
					},
					'kilometer-per-hour' => {
						'name' => q(କିଲୋମିଟର୍ ପ୍ରତି ଘଣ୍ଟା),
						'one' => q({0} କିଲୋମିଟର୍ ପ୍ରତି ଘଣ୍ଟା),
						'other' => q({0} କିଲୋମିଟର୍ ପ୍ରତି ଘଣ୍ଟା),
					},
					'kilowatt' => {
						'name' => q(କିଲୋୱାଟ୍),
						'one' => q({0} କିଲୋୱାଟ୍),
						'other' => q({0} କିଲୋୱାଟ୍),
					},
					'kilowatt-hour' => {
						'name' => q(କିଲୋୱାଟ୍-ଘଣ୍ଟା),
						'one' => q({0} କିଲୋୱାଟ୍-ଘଣ୍ଟା),
						'other' => q({0} କିଲୋୱାଟ୍-ଘଣ୍ଟା),
					},
					'knot' => {
						'name' => q(ନଟ୍),
						'one' => q({0} ନଟ୍),
						'other' => q({0} ନଟ୍),
					},
					'light-year' => {
						'name' => q(ଆଲୋକ ବର୍ଷ),
						'one' => q({0} ଆଲୋକ ବର୍ଷ),
						'other' => q({0} ଆଲୋକ ବର୍ଷ),
					},
					'liter' => {
						'name' => q(ଲିଟର୍),
						'one' => q({0} ଲିଟର୍),
						'other' => q({0} ଲିଟର୍),
						'per' => q({0} ପ୍ରତି ଲିଟର୍),
					},
					'liter-per-100kilometers' => {
						'name' => q(100 କିଲୋମିଟର୍ ପ୍ରତି ଲିଟର୍),
						'one' => q(100 କିଲୋମିଟର୍ ପ୍ରତି {0} ଲିଟର୍),
						'other' => q(100 କିଲୋମିଟର୍ ପ୍ରତି {0} ଲିଟର୍),
					},
					'liter-per-kilometer' => {
						'name' => q(ଲିଟର୍ ପ୍ରତି କିଲୋମିଟର୍),
						'one' => q({0} ଲିଟର୍ ପ୍ରତି କିଲୋମିଟର୍),
						'other' => q({0} ଲିଟର୍ ପ୍ରତି କିଲୋମିଟର୍),
					},
					'lux' => {
						'name' => q(ଲକ୍ସ),
						'one' => q({0} ଲକ୍ସ),
						'other' => q({0} ଲକ୍ସ),
					},
					'megabit' => {
						'name' => q(ମେଗାବିଟ୍),
						'one' => q({0} ମେଗାବିଟ୍),
						'other' => q({0} ମେଗାବିଟ୍),
					},
					'megabyte' => {
						'name' => q(ମେଗାବାଇଟ୍),
						'one' => q({0} ମେଗାବାଇଟ୍),
						'other' => q({0} ମେଗାବାଇଟ୍),
					},
					'megahertz' => {
						'name' => q(ମେଗାହର୍ଜ୍),
						'one' => q({0} ମେଗାହର୍ଜ୍),
						'other' => q({0} ମେଗାହର୍ଜ୍),
					},
					'megaliter' => {
						'name' => q(ମେଗାଲିଟର୍),
						'one' => q({0} ମେଗାଲିଟର୍),
						'other' => q({0} ମେଗାଲିଟର୍),
					},
					'megawatt' => {
						'name' => q(ମେଗାୱାଟ୍),
						'one' => q({0} ମେଗାୱାଟ୍),
						'other' => q({0} ମେଗାୱାଟ୍),
					},
					'meter' => {
						'name' => q(ମିଟର୍),
						'one' => q({0} ମିଟର୍),
						'other' => q({0} ମିଟର୍),
						'per' => q({0} ପ୍ରତି ମିଟର୍),
					},
					'meter-per-second' => {
						'name' => q(ମିଟର୍ ପ୍ରତି ସେକେଣ୍ଡ୍),
						'one' => q({0} ମିଟର୍ ପ୍ରତି ସେକେଣ୍ଡ୍),
						'other' => q({0} ମିଟର୍ ପ୍ରତି ସେକେଣ୍ଡ୍),
					},
					'meter-per-second-squared' => {
						'name' => q(ମିଟର୍ ପ୍ରତି ସେକେଣ୍ଡ୍ ବର୍ଗ),
						'one' => q({0} ମିଟର୍ ପ୍ରତି ସେକେଣ୍ଡ୍ ବର୍ଗ),
						'other' => q({0} ମିଟର୍ ପ୍ରତି ସେକେଣ୍ଡ୍ ବର୍ଗ),
					},
					'metric-ton' => {
						'name' => q(ମେଟ୍ରିକ୍ ଟନ୍),
						'one' => q({0} ମେଟ୍ରିକ୍ ଟନ୍),
						'other' => q({0} ମେଟ୍ରିକ୍ ଟନ୍),
					},
					'microgram' => {
						'name' => q(ମାଇକ୍ରୋଗ୍ରାମ୍),
						'one' => q({0} ମାଇକ୍ରୋଗ୍ରାମ୍),
						'other' => q({0} ମାଇକ୍ରୋଗ୍ରାମ୍),
					},
					'micrometer' => {
						'name' => q(ମାଇକ୍ରୋମିଟର୍),
						'one' => q({0} ମାଇକ୍ରୋମିଟର୍),
						'other' => q({0} ମାଇକ୍ରୋମିଟର୍),
					},
					'microsecond' => {
						'name' => q(ମାଇକ୍ରୋସେକେଣ୍ଡ),
						'one' => q({0} ମାଇକ୍ରୋସେକେଣ୍ଡ),
						'other' => q({0} ମାଇକ୍ରୋସେକେଣ୍ଡ),
					},
					'mile' => {
						'name' => q(ମାଇଲ୍),
						'one' => q({0} ମାଇଲ୍),
						'other' => q({0} ମାଇଲ୍),
					},
					'mile-per-gallon' => {
						'name' => q(ମାଇଲ୍ ପ୍ରତି ଗ୍ୟାଲନ୍),
						'one' => q({0} ମାଇଲ୍ ପ୍ରତି ଗ୍ୟାଲନ୍),
						'other' => q({0} ମାଇଲ୍ ପ୍ରତି ଗ୍ୟାଲନ୍),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(ମାଇଲ୍ ପ୍ରତି ଇମ୍ପେରିଆଲ୍ ଗ୍ୟାଲନ୍),
						'one' => q({0} ମାଇଲ୍ ପ୍ରତି ଇମ୍ପେରିଆଲ୍ ଗ୍ୟାଲନ୍),
						'other' => q({0} ମାଇଲ୍ ପ୍ରତି ଇମ୍ପେରିଆଲ୍ ଗ୍ୟାଲନ୍),
					},
					'mile-per-hour' => {
						'name' => q(ମାଇଲ୍ ପ୍ରତି ଘଣ୍ଟା),
						'one' => q({0} ମାଇଲ୍ ପ୍ରତି ଘଣ୍ଟା),
						'other' => q({0} ମାଇଲ୍ ପ୍ରତି ଘଣ୍ଟା),
					},
					'mile-scandinavian' => {
						'name' => q(ମାଇଲ୍-ସ୍କାନଡିନାଭିୟ),
						'one' => q({0} ମାଇଲ୍-ସ୍କାନଡିନାଭିୟ),
						'other' => q({0} ମାଇଲ୍-ସ୍କାନଡିନାଭିୟ),
					},
					'milliampere' => {
						'name' => q(ମିଲିଆମ୍ପିୟର୍),
						'one' => q({0} ମିଲିଆମ୍ପିୟର୍),
						'other' => q({0} ମିଲିଆମ୍ପିୟର୍),
					},
					'millibar' => {
						'name' => q(ମିଲିବାର୍),
						'one' => q({0} ମିଲିବାର୍),
						'other' => q({0} ମିଲିବାର୍),
					},
					'milligram' => {
						'name' => q(ମିଲିଗ୍ରାମ୍),
						'one' => q({0} ମିଲିଗ୍ରାମ୍),
						'other' => q({0} ମିଲିଗ୍ରାମ୍),
					},
					'milligram-per-deciliter' => {
						'name' => q(ମିଲିଗ୍ରାମ୍ ପ୍ରତି ଡେସିଲିଟର୍),
						'one' => q({0} ମିଲିଗ୍ରାମ୍ ପ୍ରତି ଡେସିଲିଟର୍),
						'other' => q({0} ମିଲିଗ୍ରାମ୍ ପ୍ରତି ଡେସିଲିଟର୍),
					},
					'milliliter' => {
						'name' => q(ମିଲିଲିଟର୍),
						'one' => q({0} ମିଲିଲିଟର୍),
						'other' => q({0} ମିଲିଲିଟର୍),
					},
					'millimeter' => {
						'name' => q(ମିଲିମିଟର୍),
						'one' => q({0} ମିଲିମିଟର୍),
						'other' => q({0} ମିଲିମିଟର୍),
					},
					'millimeter-of-mercury' => {
						'name' => q(ପାରାର ମିଲିମିଟର୍),
						'one' => q(ପାରାର {0} ମିଲିମିଟର୍),
						'other' => q(ପାରାର {0} ମିଲିମିଟର୍),
					},
					'millimole-per-liter' => {
						'name' => q(ମିଲିମୋଲ୍ ପ୍ରତି ଲିଟର୍),
						'one' => q({0} ମିଲିମୋଲ୍ ପ୍ରତି ଲିଟର୍),
						'other' => q({0} ମିଲିମୋଲ୍ ପ୍ରତି ଲିଟର୍),
					},
					'millisecond' => {
						'name' => q(ମିଲିସେକେଣ୍ଡ),
						'one' => q({0} ମିଲିସେକେଣ୍ଡ),
						'other' => q({0} ମିଲିସେକେଣ୍ଡ),
					},
					'milliwatt' => {
						'name' => q(ମିଲିୱାଟ୍),
						'one' => q({0} ମିଲିୱାଟ୍),
						'other' => q({0} ମିଲିୱାଟ୍),
					},
					'minute' => {
						'name' => q(ମିନିଟ୍‌),
						'one' => q({0} ମିନିଟ୍‌),
						'other' => q({0} ମିନିଟ୍),
						'per' => q(ମିନିଟ୍‌ ପ୍ରତି {0}),
					},
					'month' => {
						'name' => q(ମାସ),
						'one' => q({0} ମାସ),
						'other' => q({0} ମାସ),
						'per' => q(ମାସକୁ {0}),
					},
					'nanometer' => {
						'name' => q(ନାନୋମିଟର୍),
						'one' => q({0} ନାନୋମିଟର୍),
						'other' => q({0} ନାନୋମିଟର୍),
					},
					'nanosecond' => {
						'name' => q(ନାନୋସେକେଣ୍ଡ),
						'one' => q({0} ନାନୋସେକେଣ୍ଡ),
						'other' => q({0} ନାନୋସେକେଣ୍ଡ),
					},
					'nautical-mile' => {
						'name' => q(ନଟିକାଲ୍ ମାଇଲ୍),
						'one' => q({0} ନଟିକାଲ୍ ମାଇଲ୍),
						'other' => q({0} ନଟିକାଲ୍ ମାଇଲ୍),
					},
					'ohm' => {
						'name' => q(ଓହମ୍),
						'one' => q({0} ଓହମ୍),
						'other' => q({0} ଓହମ୍),
					},
					'ounce' => {
						'name' => q(ଆଉନ୍ସ),
						'one' => q({0} ଆଉନ୍ସ),
						'other' => q({0} ଆଉନ୍ସ),
						'per' => q({0} ପ୍ରତି ଆଉନ୍ସ),
					},
					'ounce-troy' => {
						'name' => q(ଟ୍ରୋୟ ଆଉନ୍ସ),
						'one' => q({0} ଟ୍ରୋୟ ଆଉନ୍ସ),
						'other' => q({0} ଟ୍ରୋୟ ଆଉନ୍ସ),
					},
					'parsec' => {
						'name' => q(ପାରସେକ୍),
						'one' => q({0} ପାରସେକ୍),
						'other' => q({0} ପାରସେକ୍),
					},
					'part-per-million' => {
						'name' => q(ଅଂଶ ପ୍ରତି ନିୟୁତ),
						'one' => q({0} ଅଂଶ ପ୍ରତି ନିୟୁତ),
						'other' => q({0} ଅଂଶ ପ୍ରତି ନିୟୁତ),
					},
					'per' => {
						'1' => q({1} ପ୍ରତି {0}),
					},
					'percent' => {
						'name' => q(ଶତକଡ଼ା),
						'one' => q({0} ଶତକଡ଼ା),
						'other' => q({0} ଶତକଡ଼ା),
					},
					'permille' => {
						'name' => q(ପରମିଲ),
						'one' => q({0} ପରମିଲ),
						'other' => q({0} ପରମିଲ),
					},
					'petabyte' => {
						'name' => q(PB),
						'one' => q({0} PB),
						'other' => q({0} PB),
					},
					'picometer' => {
						'name' => q(ପିକୋମିଟର୍),
						'one' => q({0} ପିକୋମିଟର୍),
						'other' => q({0} ପିକୋମିଟର୍),
					},
					'pint' => {
						'name' => q(ପାଇଣ୍ଟ୍),
						'one' => q({0} ପାଇଣ୍ଟ୍),
						'other' => q({0} ପାଇଣ୍ଟ୍),
					},
					'pint-metric' => {
						'name' => q(ମେଟ୍ରିକ୍ ପାଇଣ୍ଟ୍),
						'one' => q({0} ମେଟ୍ରିକ୍ ପାଇଣ୍ଟ୍),
						'other' => q({0} ମେଟ୍ରିକ୍ ପାଇଣ୍ଟ୍),
					},
					'point' => {
						'name' => q(ପଏଣ୍ଟ୍),
						'one' => q({0} ପଏଣ୍ଟ୍),
						'other' => q({0} ପଏଣ୍ଟ୍),
					},
					'pound' => {
						'name' => q(ପାଉଣ୍ଡ୍),
						'one' => q({0} ପାଉଣ୍ଡ୍),
						'other' => q({0} ପାଉଣ୍ଡ୍),
						'per' => q({0} ପ୍ରତି ପାଉଣ୍ଡ୍),
					},
					'pound-per-square-inch' => {
						'name' => q(ପାଉଣ୍ଡ୍ ପ୍ରତି ବର୍ଗ ଇଞ୍ଚ),
						'one' => q(ପ୍ରତି ବର୍ଗ ଇଞ୍ଚ {0} ପାଉଣ୍ଡ୍),
						'other' => q(ପ୍ରତି ବର୍ଗ ଇଞ୍ଚ {0} ପାଉଣ୍ଡ୍),
					},
					'quart' => {
						'name' => q(କ୍ଵାର୍ଟ୍),
						'one' => q({0} କ୍ଵାର୍ଟ୍),
						'other' => q({0} କ୍ଵାର୍ଟ୍),
					},
					'radian' => {
						'name' => q(ରେଡିଆନ୍),
						'one' => q({0} ରେଡିଆନ୍),
						'other' => q({0} ରେଡିଆନ୍),
					},
					'revolution' => {
						'name' => q(ପରିକ୍ରମଣ),
						'one' => q({0} ପରିକ୍ରମଣ),
						'other' => q({0} ପରିକ୍ରମଣ),
					},
					'second' => {
						'name' => q(ସେକେଣ୍ଡ),
						'one' => q({0} ସେକେଣ୍ଡ),
						'other' => q({0} ସେକେଣ୍ଡ),
						'per' => q({0} ପ୍ରତି ସେକେଣ୍ଡ),
					},
					'square-centimeter' => {
						'name' => q(ବର୍ଗ ସେଣ୍ଟିମିଟର୍),
						'one' => q({0} ବର୍ଗ ସେଣ୍ଟିମିଟର୍),
						'other' => q({0} ବର୍ଗ ସେଣ୍ଟିମିଟର୍),
						'per' => q({0} ପ୍ରତି ବର୍ଗ ସେଣ୍ଟିମିଟର୍),
					},
					'square-foot' => {
						'name' => q(ବର୍ଗ ଫିଟ୍),
						'one' => q({0} ବର୍ଗ ଫୁଟ୍),
						'other' => q({0} ବର୍ଗ ଫିଟ୍),
					},
					'square-inch' => {
						'name' => q(ବର୍ଗ ଇଞ୍ଚ),
						'one' => q({0} ବର୍ଗ ଇଞ୍ଚ),
						'other' => q({0} ବର୍ଗ ଇଞ୍ଚ),
						'per' => q({0} ପ୍ରତି ବର୍ଗ ଇଞ୍ଚ),
					},
					'square-kilometer' => {
						'name' => q(ବର୍ଗ କିଲୋମିଟର୍),
						'one' => q({0} ବର୍ଗ କିଲୋମିଟର୍),
						'other' => q({0} ବର୍ଗ କିଲୋମିଟର୍),
						'per' => q({0} ପ୍ରତି ବର୍ଗ କିଲୋମିଟର୍),
					},
					'square-meter' => {
						'name' => q(ବର୍ଗ ମିଟର୍),
						'one' => q({0} ବର୍ଗ ମିଟର୍),
						'other' => q({0} ବର୍ଗ ମିଟର୍),
						'per' => q({0} ପ୍ରତି ବର୍ଗ ମିଟର୍),
					},
					'square-mile' => {
						'name' => q(ବର୍ଗ ମାଇଲ୍),
						'one' => q({0} ବର୍ଗ ମାଇଲ୍),
						'other' => q({0} ବର୍ଗ ମାଇଲ୍),
						'per' => q({0} ପ୍ରତି ବର୍ଗ ମାଇଲ୍),
					},
					'square-yard' => {
						'name' => q(ବର୍ଗ ଗଜ),
						'one' => q({0} ବର୍ଗ ଗଜ),
						'other' => q({0} ବର୍ଗ ଗଜ),
					},
					'tablespoon' => {
						'name' => q(ଖାଇବା ଚାମଚ),
						'one' => q({0} ଖାଇବା ଚାମଚ),
						'other' => q({0} ଖାଇବା ଚାମଚ),
					},
					'teaspoon' => {
						'name' => q(ଛୋଟ ଚାମଚ),
						'one' => q({0} ଛୋଟ ଚାମଚ),
						'other' => q({0} ଛୋଟ ଚାମଚ),
					},
					'terabit' => {
						'name' => q(ଟେରାବିଟ୍),
						'one' => q({0} ଟେରାବିଟ୍),
						'other' => q({0} ଟେରାବିଟ୍),
					},
					'terabyte' => {
						'name' => q(ଟେରାବାଇଟ୍),
						'one' => q({0} ଟେରାବାଇଟ୍),
						'other' => q({0} ଟେରାବାଇଟ୍),
					},
					'ton' => {
						'name' => q(ଟନ୍),
						'one' => q({0} ଟନ୍),
						'other' => q({0} ଟନ୍),
					},
					'volt' => {
						'name' => q(ଭୋଲ୍ଟ୍),
						'one' => q({0} ଭୋଲ୍ଟ୍),
						'other' => q({0} ଭୋଲ୍ଟ୍),
					},
					'watt' => {
						'name' => q(ୱାଟ୍),
						'one' => q({0} ୱାଟ୍),
						'other' => q({0} ୱାଟ୍),
					},
					'week' => {
						'name' => q(ସପ୍ତାହ),
						'one' => q({0} ସପ୍ତାହ),
						'other' => q({0} ସପ୍ତାହ),
						'per' => q(ସପ୍ତାହକୁ {0}),
					},
					'yard' => {
						'name' => q(ୟାର୍ଡ୍),
						'one' => q({0} ୟାର୍ଡ୍),
						'other' => q({0} ୟାର୍ଡ୍),
					},
					'year' => {
						'name' => q(ବର୍ଷ),
						'one' => q({0} ବର୍ଷ),
						'other' => q({0} ବର୍ଷ),
						'per' => q(ବର୍ଷକୁ {0}),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(ଦିଗ),
					},
					'celsius' => {
						'name' => q(°ସେ),
						'one' => q({0}°ସେ),
						'other' => q({0}°ସେ),
					},
					'centimeter' => {
						'name' => q(ସେମି),
						'one' => q({0} ସେମି),
						'other' => q({0}ସେମି),
					},
					'coordinate' => {
						'east' => q({0} ପୂ),
						'north' => q({0}ଉ),
						'south' => q({0} ଦ),
						'west' => q({0} ପ),
					},
					'day' => {
						'name' => q(ଦିନ),
						'one' => q({0}ଦିନ),
						'other' => q({0}ଦିନ),
					},
					'gram' => {
						'name' => q(ଗ୍ରାମ୍),
						'one' => q({0}ଗ୍ରା),
						'other' => q({0}ଗ୍ରା),
					},
					'hour' => {
						'name' => q(ଘଣ୍ଟା),
						'one' => q({0}ଘଣ୍ଟା),
						'other' => q({0}ଘଣ୍ଟା),
					},
					'kilogram' => {
						'name' => q(କିଗ୍ରା),
						'one' => q({0}କିଗ୍ରା),
						'other' => q({0}କିଗ୍ରା),
					},
					'kilometer' => {
						'name' => q(କିମି),
						'one' => q({0} କିମି),
						'other' => q({0} କିମି),
					},
					'kilometer-per-hour' => {
						'name' => q(କିମି/ଘ),
						'one' => q({0}କେପିଏଚ୍),
						'other' => q({0}କେପିଏଚ୍),
					},
					'liter' => {
						'name' => q(ଲିଟର୍),
						'one' => q({0}ଲି),
						'other' => q({0}ଲି),
					},
					'liter-per-100kilometers' => {
						'name' => q(ଲି/100କିମି),
						'one' => q({0}ଲି/100 କିମି),
						'other' => q({0}ଲି/100 କିମି),
					},
					'meter' => {
						'name' => q(ମି),
						'one' => q({0} ମି),
						'other' => q({0} ମି),
					},
					'millimeter' => {
						'name' => q(ମିମି),
						'one' => q({0}ମିମି),
						'other' => q({0}ମିମି),
					},
					'millisecond' => {
						'name' => q(ମିଲିସେକେଣ୍ଡ),
						'one' => q({0}ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'name' => q(ମିନିଟ୍‌),
						'one' => q({0}ମିନିଟ୍‌),
						'other' => q({0}ମିନିଟ୍‌),
					},
					'month' => {
						'name' => q(ମାସ),
						'one' => q({0}ମାସ),
						'other' => q({0}ମାସ),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'second' => {
						'name' => q(ସେକେଣ୍ଡ),
						'one' => q({0}ସେକ୍),
						'other' => q({0}ସେକ୍),
					},
					'week' => {
						'name' => q(ସପ୍ତାହ),
						'one' => q({0}ସପ୍),
						'other' => q({0} ସପ୍),
					},
					'year' => {
						'name' => q(yr),
						'one' => q({0}ବର୍ଷ),
						'other' => q({0}ବର୍ଷ),
					},
				},
				'short' => {
					'' => {
						'name' => q(ଦିଗ),
					},
					'acre' => {
						'name' => q(ଏକର),
						'one' => q({0} ଏକର),
						'other' => q({0} ଏକର),
					},
					'acre-foot' => {
						'name' => q(ଏକର ଫିଟ୍),
						'one' => q({0} ଏକର-ଫିଟ୍),
						'other' => q({0} ଏକର-ଫିଟ୍),
					},
					'ampere' => {
						'name' => q(ଆମ୍ପପ୍),
						'one' => q({0} ଏ),
						'other' => q({0} ଏ),
					},
					'arc-minute' => {
						'name' => q(ଆର୍କମି),
						'one' => q({0} ଆର୍କମି),
						'other' => q({0} ଆର୍କମି),
					},
					'arc-second' => {
						'name' => q(ଆର୍କସେ),
						'one' => q({0}″),
						'other' => q({0} ଆର୍କସେ),
					},
					'astronomical-unit' => {
						'name' => q(ଆୟୁ),
						'one' => q({0} ଆୟୁ),
						'other' => q({0} ଆୟୁ),
					},
					'atmosphere' => {
						'name' => q(atm),
						'one' => q({0} atm),
						'other' => q({0} atm),
					},
					'bit' => {
						'name' => q(ବିଟ୍),
						'one' => q({0} ବିଟ୍),
						'other' => q({0} ବିଟ୍),
					},
					'byte' => {
						'name' => q(ବାଇଟ୍),
						'one' => q({0} ବାଇଟ୍),
						'other' => q({0} ବାଇଟ୍),
					},
					'calorie' => {
						'name' => q(କ୍ୟାଲ୍),
						'one' => q({0} କ୍ୟାଲ୍),
						'other' => q({0} କ୍ୟାଲ୍),
					},
					'carat' => {
						'name' => q(କ୍ୟାରେଟ୍),
						'one' => q({0} ସିଡି),
						'other' => q({0} ସିଡି),
					},
					'celsius' => {
						'name' => q(ଡି. ସେ),
						'one' => q({0}°ସେ),
						'other' => q({0}°ସେ),
					},
					'centiliter' => {
						'name' => q(ସେଲି),
						'one' => q({0} ସେଲି),
						'other' => q({0} ସେଲି),
					},
					'centimeter' => {
						'name' => q(ସେମି),
						'one' => q({0} ସେମି),
						'other' => q({0} ସେମି),
						'per' => q({0}/ସେମି),
					},
					'century' => {
						'name' => q(c),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					'coordinate' => {
						'east' => q({0} ପୂ),
						'north' => q({0} ଉ),
						'south' => q({0} ଦ),
						'west' => q({0} ପ),
					},
					'cubic-centimeter' => {
						'name' => q(ସେମି³),
						'one' => q({0} ସେମି³),
						'other' => q({0} ସେମି³),
						'per' => q({0}/ସେମି³),
					},
					'cubic-foot' => {
						'name' => q(ଫିଟ୍³),
						'one' => q({0} ଫିଟ୍³),
						'other' => q({0} ଫିଟ୍³),
					},
					'cubic-inch' => {
						'name' => q(ଇଞ୍ଚ୍³),
						'one' => q({0} ଇଞ୍ଚ୍³),
						'other' => q({0} ଇଞ୍ଚ୍³),
					},
					'cubic-kilometer' => {
						'name' => q(କିମି³),
						'one' => q({0} କିମି³),
						'other' => q({0} କିମି³),
					},
					'cubic-meter' => {
						'name' => q(ମି³),
						'one' => q({0} ମି³),
						'other' => q({0} ମି³),
						'per' => q({0}/ମି³),
					},
					'cubic-mile' => {
						'name' => q(ମା³),
						'one' => q({0} ମା³),
						'other' => q({0} ମା³),
					},
					'cubic-yard' => {
						'name' => q(ୟାର୍ଡ୍³),
						'one' => q({0} ୟାର୍ଡ୍³),
						'other' => q({0} ୟାର୍ଡ୍³),
					},
					'cup' => {
						'name' => q(କପ୍),
						'one' => q({0} କ),
						'other' => q({0} କ),
					},
					'cup-metric' => {
						'name' => q(ମେକ),
						'one' => q({0} ମେକ),
						'other' => q({0} ମେକ),
					},
					'day' => {
						'name' => q(ଦିନ),
						'one' => q({0} ଦିନ),
						'other' => q({0} ଦିନ),
						'per' => q({0}/ଦିନ),
					},
					'deciliter' => {
						'name' => q(ଡେଲି),
						'one' => q({0} ଡେଲି),
						'other' => q({0} ଡେଲି),
					},
					'decimeter' => {
						'name' => q(ଡେମି),
						'one' => q({0} ଡେମି),
						'other' => q({0} ଡେମି),
					},
					'degree' => {
						'name' => q(ଡିଗ୍ରୀ),
						'one' => q({0} ଡି),
						'other' => q({0} ଡି),
					},
					'fahrenheit' => {
						'name' => q(ଡି. ଫା),
						'one' => q({0}°ଫା),
						'other' => q({0}°ଫା),
					},
					'fluid-ounce' => {
						'name' => q(ଫ୍ଲୁ ଓଜ୍),
						'one' => q({0} ଫ୍ଲୁ ଓଜ୍),
						'other' => q({0} ଫ୍ଲୁ ଓଜ୍),
					},
					'foodcalorie' => {
						'name' => q(କ୍ୟାଲ୍),
						'one' => q({0} କ୍ୟାଲ୍),
						'other' => q({0} କ୍ୟାଲ୍),
					},
					'foot' => {
						'name' => q(ଫିଟ୍),
						'one' => q({0} ଫିଟ୍),
						'other' => q({0} ଫିଟ୍),
						'per' => q({0}/ଫିଟ୍),
					},
					'g-force' => {
						'name' => q(ଜି-ଫୋର୍ସ୍),
						'one' => q({0} ଜି),
						'other' => q({0} ଜି),
					},
					'gallon' => {
						'name' => q(ଗ୍ୟାଲ୍),
						'one' => q({0} ଗ୍ୟାଲ୍),
						'other' => q({0} ଗ୍ୟାଲ୍),
						'per' => q({0}/ଗ୍ୟାଲ୍ ଯୁକ୍ତରାଷ୍ଟ୍ର),
					},
					'gallon-imperial' => {
						'name' => q(ଇମ୍ପେ. ଗ୍ୟା),
						'one' => q({0} ଇମ୍ପେ. ଗ୍ୟା),
						'other' => q({0} ଇମ୍ପେ. ଗ୍ୟା),
						'per' => q({0}/ଇମ୍ପେ. ଗ୍ୟା),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ଜିବିଟ୍),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(ଜିବାଇଟ୍),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'name' => q(ଗିୱା),
						'one' => q({0} ଗିୱା),
						'other' => q({0} ଗିୱା),
					},
					'gram' => {
						'name' => q(ଗ୍ରାମ୍),
						'one' => q({0} ଗ୍ରା),
						'other' => q({0} ଗ୍ରା),
						'per' => q({0}/ଗ୍ରା),
					},
					'hectare' => {
						'name' => q(ହେକ୍ଟର୍),
						'one' => q({0} ହେ),
						'other' => q({0} ହେ),
					},
					'hectoliter' => {
						'name' => q(ହେଲି),
						'one' => q({0} ହେଲି),
						'other' => q({0} ହେଲି),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'name' => q(ଏଚପି),
						'one' => q({0} ଏଚପି),
						'other' => q({0} ଏଚପି),
					},
					'hour' => {
						'name' => q(ଘଣ୍ଟା),
						'one' => q({0} ଘଣ୍ଟା),
						'other' => q({0} ଘଣ୍ଟା),
						'per' => q({0}/ଘଣ୍ଟା),
					},
					'inch' => {
						'name' => q(ଇଞ୍ଚ୍),
						'one' => q({0} ଇଞ୍ଚ୍),
						'other' => q({0} ଇଞ୍ଚ୍),
						'per' => q({0}/ଇଞ୍ଚ୍),
					},
					'inch-hg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(ଜୁଲ୍),
						'one' => q({0} ଜୁ),
						'other' => q({0} ଜୁ),
					},
					'karat' => {
						'name' => q(କ୍ୟାରେଟ୍),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					'kelvin' => {
						'name' => q(କେ),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(କେବିଟ୍),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(କେବାଇଟ୍),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'name' => q(କିଲୋକ୍ୟାଲ୍),
						'one' => q({0} କିଲୋକ୍ୟାଲ୍),
						'other' => q({0} କିଲୋକ୍ୟାଲ୍),
					},
					'kilogram' => {
						'name' => q(କିଗ୍ରା),
						'one' => q({0} କିଗ୍ରା),
						'other' => q({0} କିଗ୍ରା),
						'per' => q({0}/କିଗ୍ରା),
					},
					'kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'name' => q(କିଲୋଜୁଲ୍),
						'one' => q({0} କିଜୁ),
						'other' => q({0} କିଜୁ),
					},
					'kilometer' => {
						'name' => q(କିମି),
						'one' => q({0} କିମି),
						'other' => q({0} କିମି),
						'per' => q({0}/କିମି),
					},
					'kilometer-per-hour' => {
						'name' => q(କିମି/ଘଣ୍ଟା),
						'one' => q({0} କେପିଏଚ୍),
						'other' => q({0} କେପିଏଚ୍),
					},
					'kilowatt' => {
						'name' => q(କିୱା),
						'one' => q({0} କିୱା),
						'other' => q({0} କିୱା),
					},
					'kilowatt-hour' => {
						'name' => q(କିୱା-ଘଣ୍ଟା),
						'one' => q({0} କିୱାଘ),
						'other' => q({0} କିୱାଘ),
					},
					'knot' => {
						'name' => q(ନଟ୍),
						'one' => q({0} ନଟ୍),
						'other' => q({0} ନଟ୍),
					},
					'light-year' => {
						'name' => q(ଆଲୋକ ବର୍ଷ),
						'one' => q({0} ଆବ),
						'other' => q({0} ଆବ),
					},
					'liter' => {
						'name' => q(ଲିଟର୍),
						'one' => q({0} ଲି),
						'other' => q({0} ଲି),
						'per' => q({0}/ଲି),
					},
					'liter-per-100kilometers' => {
						'name' => q(ଲି/100 କିମି),
						'one' => q({0} ଲି/100 କିମି),
						'other' => q({0} ଲି/100 କିମି),
					},
					'liter-per-kilometer' => {
						'name' => q(ଲିଟର୍/କିମି),
						'one' => q({0} ଲି/କିମି),
						'other' => q({0} ଲି/କିମି),
					},
					'lux' => {
						'name' => q(ଲକ୍ସ),
						'one' => q({0} ଲକ୍ସ),
						'other' => q({0} ଲକ୍ସ),
					},
					'megabit' => {
						'name' => q(ମେବିଟ୍),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(ମେବାଇଟ୍),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'name' => q(ଏମଏଲ୍),
						'one' => q({0} ଏମଏଲ୍),
						'other' => q({0} ଏମଏଲ୍),
					},
					'megawatt' => {
						'name' => q(ମେୱା),
						'one' => q({0} ମେୱା),
						'other' => q({0} ମେୱା),
					},
					'meter' => {
						'name' => q(ମି),
						'one' => q({0} ମି),
						'other' => q({0} ମି),
						'per' => q({0}/ମି),
					},
					'meter-per-second' => {
						'name' => q(ମିଟର୍/ସେ),
						'one' => q({0} ମି/ସେ),
						'other' => q({0} ମି/ସେ),
					},
					'meter-per-second-squared' => {
						'name' => q(ମିଟର୍/ସେ²),
						'one' => q({0} ମି/ସେ²),
						'other' => q({0} ମି/ସେ²),
					},
					'metric-ton' => {
						'name' => q(ଟ),
						'one' => q({0} ଟ),
						'other' => q({0} ଟ),
					},
					'microgram' => {
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(µମିଟର୍),
						'one' => q({0} µମି),
						'other' => q({0} µମି),
					},
					'microsecond' => {
						'name' => q(μସେକେଣ୍ଡ),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(ମାଇଲ୍),
						'one' => q({0} ମା),
						'other' => q({0} ମା),
					},
					'mile-per-gallon' => {
						'name' => q(ମାଇଲ୍/ଗ୍ୟା),
						'one' => q({0} ଏମପିଜି),
						'other' => q({0} ଏମପିଜି),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(ମାଇଲ୍/ଇମ୍ପେ. ଗ୍ୟା),
						'one' => q({0} ଏମପିଜି ଇମ୍ପେ.),
						'other' => q({0} ଏମପିଜି ଇମ୍ପେ.),
					},
					'mile-per-hour' => {
						'name' => q(ମାଇଲ୍/ଘଣ୍ଟା),
						'one' => q({0} ଏମପିଏଚ୍),
						'other' => q({0} ଏମପିଏଚ୍),
					},
					'mile-scandinavian' => {
						'name' => q(ସମି),
						'one' => q({0} ସମି),
						'other' => q({0} ସମି),
					},
					'milliampere' => {
						'name' => q(ମିଲିଆମ୍ପ୍),
						'one' => q({0} ମିଆ),
						'other' => q({0} ମିଆ),
					},
					'millibar' => {
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'milligram' => {
						'name' => q(ମିଗ୍ରା),
						'one' => q({0} ମିଗ୍ରା),
						'other' => q({0} ମିଗ୍ରା),
					},
					'milligram-per-deciliter' => {
						'name' => q(ମିଗ୍ରା/ଡେଲି),
						'one' => q({0} ମିଗ୍ରା/ଡେଲି),
						'other' => q({0} ମିଗ୍ରା/ଡେଲି),
					},
					'milliliter' => {
						'name' => q(ମିଲି),
						'one' => q({0} ମିଲି),
						'other' => q({0} ମିଲି),
					},
					'millimeter' => {
						'name' => q(ମିମି),
						'one' => q({0} ମିମି),
						'other' => q({0} ମିମି),
					},
					'millimeter-of-mercury' => {
						'name' => q(mmHg),
						'one' => q({0} mmHg),
						'other' => q({0} mmHg),
					},
					'millimole-per-liter' => {
						'name' => q(ମିଲିମୋଲ୍/ଲିଟର୍),
						'one' => q({0} ମିଲିମୋଲ୍/ଲି),
						'other' => q({0} ମିଲିମୋଲ୍/ଲି),
					},
					'millisecond' => {
						'name' => q(ମିଲିସେକେଣ୍ଡ),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'milliwatt' => {
						'name' => q(ମିୱା),
						'one' => q({0} ମିୱା),
						'other' => q({0} ମିୱା),
					},
					'minute' => {
						'name' => q(ମିନିଟ୍‌),
						'one' => q({0} ମିନିଟ୍‌),
						'other' => q({0} ମିନିଟ୍‌),
						'per' => q({0}/ମିନିଟ୍‌),
					},
					'month' => {
						'name' => q(ମାସ),
						'one' => q({0} ମାସ),
						'other' => q({0} ମାସ),
						'per' => q({0}/ମାସ),
					},
					'nanometer' => {
						'name' => q(ନାମି),
						'one' => q({0} ନାମି),
						'other' => q({0} ନାମି),
					},
					'nanosecond' => {
						'name' => q(ns),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'name' => q(ନୌମି),
						'one' => q({0} ନୌମି),
						'other' => q({0} ନୌମି),
					},
					'ohm' => {
						'name' => q(ଓହମ୍),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(ଓଜ୍),
						'one' => q({0} ଓଜ୍),
						'other' => q({0} ଓଜ୍),
						'per' => q({0}/ଓଜ୍),
					},
					'ounce-troy' => {
						'name' => q(ଓଜ୍ ଟ୍ରୋୟ),
						'one' => q({0} ଓଜ୍ ଟ୍ରୋ),
						'other' => q({0} ଓଜ୍ ଟ୍ରୋ),
					},
					'parsec' => {
						'name' => q(ପାରସେକ୍),
						'one' => q({0} ପିସି),
						'other' => q({0} ପିସି),
					},
					'part-per-million' => {
						'name' => q(ଅଂଶ/ନିୟୁତ),
						'one' => q({0} ପିପିଏମ୍),
						'other' => q({0} ପିପିଏମ୍),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(ଶତକଡ଼ା),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'permille' => {
						'name' => q(ପରମିଲ),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(PByte),
						'one' => q({0} PB),
						'other' => q({0} PB),
					},
					'picometer' => {
						'name' => q(ପିମି),
						'one' => q({0} ପିମି),
						'other' => q({0} ପିମି),
					},
					'pint' => {
						'name' => q(ପାଇଣ୍ଟ୍),
						'one' => q({0} ପାଇଣ୍ଟ୍),
						'other' => q({0} ପାଇଣ୍ଟ୍),
					},
					'pint-metric' => {
						'name' => q(ମେପା),
						'one' => q({0} ମେପା),
						'other' => q({0} ମେପା),
					},
					'point' => {
						'name' => q(ପଏଣ୍ଟ୍),
						'one' => q({0} ପ),
						'other' => q({0} ପ),
					},
					'pound' => {
						'name' => q(ପାଉଣ୍ଡ୍),
						'one' => q({0} ପାଉଣ୍ଡ୍),
						'other' => q({0} ପାଉଣ୍ଡ୍),
						'per' => q({0}/ପାଉଣ୍ଡ୍),
					},
					'pound-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(କ୍ଵାର୍ଟ୍),
						'one' => q({0} କ୍ଵାର୍ଟ୍),
						'other' => q({0} କ୍ଵାର୍ଟ୍),
					},
					'radian' => {
						'name' => q(ରେଡିଆନ୍),
						'one' => q({0} ରେଡି),
						'other' => q({0} ରେଡି),
					},
					'revolution' => {
						'name' => q(ପରିକ୍ର),
						'one' => q({0} ପରିକ୍ର),
						'other' => q({0} ପରିକ୍ର),
					},
					'second' => {
						'name' => q(ସେକେଣ୍ଡ),
						'one' => q({0} ସେକେଣ୍ଡ),
						'other' => q({0} ସେକେଣ୍ଡ),
						'per' => q({0}/ସେକେଣ୍ଡ),
					},
					'square-centimeter' => {
						'name' => q(ସେମି²),
						'one' => q({0} ସେମି²),
						'other' => q({0} ସେମି²),
						'per' => q({0}/ସେମି²),
					},
					'square-foot' => {
						'name' => q(ବର୍ଗ ଫିଟ୍),
						'one' => q({0} ବର୍ଗ ଫିଟ୍),
						'other' => q({0} ବର୍ଗ ଫିଟ୍),
					},
					'square-inch' => {
						'name' => q(ଇଞ୍ଚ²),
						'one' => q({0} ଇଞ୍ଚ²),
						'other' => q({0} ଇଞ୍ଚ²),
						'per' => q({0}/ଇଞ୍ଚ²),
					},
					'square-kilometer' => {
						'name' => q(କିମି²),
						'one' => q({0} କିମି²),
						'other' => q({0} କିମି²),
						'per' => q({0}/କିମି²),
					},
					'square-meter' => {
						'name' => q(ମିଟର୍²),
						'one' => q({0} ମି²),
						'other' => q({0} ମି²),
						'per' => q({0}/ମି²),
					},
					'square-mile' => {
						'name' => q(ବର୍ଗ ମାଇଲ୍),
						'one' => q({0} ବର୍ଗ ମାଇଲ୍),
						'other' => q({0} ବର୍ଗ ମାଇଲ୍),
						'per' => q({0}/ମାଇଲ୍²),
					},
					'square-yard' => {
						'name' => q(ୟାର୍ଡ୍²),
						'one' => q({0} ୟାର୍ଡ୍²),
						'other' => q({0} ୟାର୍ଡ୍²),
					},
					'tablespoon' => {
						'name' => q(ଖାଇବା ଚାମଚ),
						'one' => q({0} ଖାଇବା ଚାମଚ),
						'other' => q({0} ଖାଇବା ଚାମଚ),
					},
					'teaspoon' => {
						'name' => q(ଛୋଟ ଚାମଚ),
						'one' => q({0} ଛୋଟ ଚାମଚ),
						'other' => q({0} ଛୋଟ ଚାମଚ),
					},
					'terabit' => {
						'name' => q(ଟିବିଟ୍),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(ଟିବାଇଟ୍),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(ଟନ୍),
						'one' => q({0} ଟନ୍),
						'other' => q({0} ଟନ୍),
					},
					'volt' => {
						'name' => q(ଭୋଲ୍ଟ୍),
						'one' => q({0} ଭୋ),
						'other' => q({0} ଭୋ),
					},
					'watt' => {
						'name' => q(ୱାଟ୍),
						'one' => q({0} ୱା),
						'other' => q({0} ୱା),
					},
					'week' => {
						'name' => q(ସପ୍ତାହ),
						'one' => q({0} ସପ୍ତାହ),
						'other' => q({0} ସପ୍ତାହ),
						'per' => q({0}/ସପ୍ତାହ),
					},
					'yard' => {
						'name' => q(ୟାର୍ଡ୍),
						'one' => q({0} ୟାର୍ଡ୍),
						'other' => q({0} ୟାର୍ଡ୍),
					},
					'year' => {
						'name' => q(ବର୍ଷ),
						'one' => q({0} ବର୍ଷ),
						'other' => q({0} ବର୍ଷ),
						'per' => q({0}/ବର୍ଷ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ହଁ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ନା|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'orya',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
		'orya' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0ହ',
					'other' => '0ହ',
				},
				'10000' => {
					'one' => '00ହ',
					'other' => '00ହ',
				},
				'100000' => {
					'one' => '000ହ',
					'other' => '000ହ',
				},
				'1000000' => {
					'one' => '0ନି',
					'other' => '0ନି',
				},
				'10000000' => {
					'one' => '00ନି',
					'other' => '00ନି',
				},
				'100000000' => {
					'one' => '000ନି',
					'other' => '000ନି',
				},
				'1000000000' => {
					'one' => '0ବି',
					'other' => '0ବି',
				},
				'10000000000' => {
					'one' => '00ବି',
					'other' => '00ବି',
				},
				'100000000000' => {
					'one' => '000ବି',
					'other' => '000ବି',
				},
				'1000000000000' => {
					'one' => '0ଟ୍ରି',
					'other' => '0ଟ୍ରି',
				},
				'10000000000000' => {
					'one' => '00ଟ୍ରି',
					'other' => '00ଟ୍ରି',
				},
				'100000000000000' => {
					'one' => '000ଟ୍ରି',
					'other' => '000ଟ୍ରି',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ହଜାର',
					'other' => '0 ହଜାର',
				},
				'10000' => {
					'one' => '00 ହଜାର',
					'other' => '00 ହଜାର',
				},
				'100000' => {
					'one' => '000 ହଜାର',
					'other' => '000 ହଜାର',
				},
				'1000000' => {
					'one' => '0 ନିୟୁତ',
					'other' => '0 ନିୟୁତ',
				},
				'10000000' => {
					'one' => '00 ନିୟୁତ',
					'other' => '00 ନିୟୁତ',
				},
				'100000000' => {
					'one' => '000 ନିୟୁତ',
					'other' => '000 ନିୟୁତ',
				},
				'1000000000' => {
					'one' => '0 ଶହକୋଟି',
					'other' => '0 ଶହକୋଟି',
				},
				'10000000000' => {
					'one' => '00 ଶହକୋଟି',
					'other' => '00 ଶହକୋଟି',
				},
				'100000000000' => {
					'one' => '000 ଶହକୋଟି',
					'other' => '000 ଶହକୋଟି',
				},
				'1000000000000' => {
					'one' => '0 ଲକ୍ଷକୋଟି',
					'other' => '0 ଲକ୍ଷକୋଟି',
				},
				'10000000000000' => {
					'one' => '00 ଲକ୍ଷକୋଟି',
					'other' => '00 ଲକ୍ଷକୋଟି',
				},
				'100000000000000' => {
					'one' => '000 ଲକ୍ଷକୋଟି',
					'other' => '000 ଲକ୍ଷକୋଟି',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0ହ',
					'other' => '0ହ',
				},
				'10000' => {
					'one' => '00ହ',
					'other' => '00ହ',
				},
				'100000' => {
					'one' => '000ହ',
					'other' => '000ହ',
				},
				'1000000' => {
					'one' => '0ନି',
					'other' => '0ନି',
				},
				'10000000' => {
					'one' => '00ନି',
					'other' => '00ନି',
				},
				'100000000' => {
					'one' => '000ନି',
					'other' => '000ନି',
				},
				'1000000000' => {
					'one' => '0ବି',
					'other' => '0ବି',
				},
				'10000000000' => {
					'one' => '00ବି',
					'other' => '00ବି',
				},
				'100000000000' => {
					'one' => '000ବି',
					'other' => '000ବି',
				},
				'1000000000000' => {
					'one' => '0ଟ୍ରି',
					'other' => '0ଟ୍ରି',
				},
				'10000000000000' => {
					'one' => '00ଟ୍ରି',
					'other' => '00ଟ୍ରି',
				},
				'100000000000000' => {
					'one' => '000ଟ୍ରି',
					'other' => '000ଟ୍ରି',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
		'orya' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(ଯୁକ୍ତ ଆରବ ଏମିରେଟସ୍ ଦିରହାମ୍),
				'one' => q(UAE ଦିରହାମ୍),
				'other' => q(UAE ଦିରହାମ୍),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(ଆଫଗାନ ଆଫଗାନି),
				'one' => q(ଆଫଗାନ ଆଫଗାନି),
				'other' => q(ଆଫଗାନ ଆଫଗାନି),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(ଆଲବାନିୟ ଲେକ୍),
				'one' => q(ଆଲବାନିୟ ଲେକ୍),
				'other' => q(ଆଲବାନିୟ ଲେକ୍),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(ଅର୍ମେନୀୟ ଡ୍ରାମ୍),
				'one' => q(ଅର୍ମେନୀୟ ଡ୍ରାମ୍),
				'other' => q(ଅର୍ମେନୀୟ ଡ୍ରାମ୍),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(ନେଦରଲ୍ୟାଣ୍ଡ୍ ଆଣ୍ଟିଲିୟ ଗିଲଡର୍),
				'one' => q(ନେଦରଲ୍ୟାଣ୍ଡ୍ ଆଣ୍ଟିଲିୟ ଗିଲଡର୍),
				'other' => q(ନେଦରଲ୍ୟାଣ୍ଡ୍ ଆଣ୍ଟିଲିୟ ଗିଲଡର୍),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(ଅଙ୍ଗୋଲୀୟ କୱାନଜା),
				'one' => q(ଅଙ୍ଗୋଲୀୟ କୱାନଜା),
				'other' => q(ଅଙ୍ଗୋଲୀୟ କୱାନଜା),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(ଆର୍ଜେଣ୍ଟାଇନ୍‍ ପେସୋ),
				'one' => q(ଆର୍ଜେଣ୍ଟାଇନ୍‍ ପେସୋ),
				'other' => q(ଆର୍ଜେଣ୍ଟାଇନ୍‍ ପେସୋ),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ଅଷ୍ଟ୍ରେଲିୟ ଡଲାର୍),
				'one' => q(ଅଷ୍ଟ୍ରେଲିୟ ଡଲାର୍),
				'other' => q(ଅଷ୍ଟ୍ରେଲିୟ ଡଲାର୍),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(ଆରୁବୀୟ ଫ୍ଲୋରିନ୍),
				'one' => q(ଆରୁବୀୟ ଫ୍ଲୋରିନ୍),
				'other' => q(ଆରୁବୀୟ ଫ୍ଲୋରିନ୍),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(ଆଜେରବାଇଜାନି ମନତ୍),
				'one' => q(ଆଜେରବାଇଜାନି ମନତ୍),
				'other' => q(ଆଜେରବାଇଜାନି ମନତ୍),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(ବୋସନିଆ-ହର୍ଜଗୋଭିନା କନଭର୍ଟିବଲ୍ ମାର୍କ୍),
				'one' => q(ବୋସନିଆ-ହର୍ଜଗୋଭିନା କନଭର୍ଟିବଲ୍ ମାର୍କ୍),
				'other' => q(ବୋସନିଆ-ହର୍ଜଗୋଭିନା କନଭର୍ଟିବଲ୍ ମାର୍କ୍),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(ବାର୍ବାଡୀୟ ଡଲାର୍),
				'one' => q(ବାର୍ବାଡୀୟ ଡଲାର୍),
				'other' => q(ବାର୍ବାଡୀୟ ଡଲାର୍),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(ବଙ୍ଗଳାଦେଶୀ ଟାକା),
				'one' => q(ବଙ୍ଗଳାଦେଶୀ ଟାକା),
				'other' => q(ବଙ୍ଗଳାଦେଶୀ ଟାକା),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(ବୁଲଗେରୀୟ ଲେଭ୍),
				'one' => q(ବୁଲଗେରୀୟ ଲେଭ୍),
				'other' => q(ବୁଲଗେରୀୟ ଲେଭ୍),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(ବାଃରେନି ଦିନାର୍),
				'one' => q(ବାଃରେନି ଦିନାର୍),
				'other' => q(ବାଃରେନି ଦିନାର୍),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(ବୁରୁଣ୍ଡିୟ ଫ୍ରାଙ୍କ୍),
				'one' => q(ବୁରୁଣ୍ଡିୟ ଫ୍ରାଙ୍କ୍),
				'other' => q(ବୁରୁଣ୍ଡିୟ ଫ୍ରାଙ୍କ୍),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(ବର୍ମ୍ୟୁଡା ଡଲାର୍),
				'one' => q(ବର୍ମ୍ୟୁଡା ଡଲାର୍),
				'other' => q(ବର୍ମ୍ୟୁଡା ଡଲାର୍),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ବ୍ରୁନେଇ ଡଲାର୍),
				'one' => q(ବ୍ରୁନେଇ ଡଲାର୍),
				'other' => q(ବ୍ରୁନେଇ ଡଲାର୍),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(ବୋଲିଭୀୟ ବୋଲିଭିଆନୋ),
				'one' => q(ବୋଲିଭୀୟ ବୋଲିଭିଆନୋ),
				'other' => q(ବୋଲିଭୀୟ ବୋଲିଭିଆନୋ),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ବ୍ରାଜିଲୀୟ ରିଏଲ୍),
				'one' => q(ବ୍ରାଜିଲୀୟ ରିଏଲ୍),
				'other' => q(ବ୍ରାଜିଲୀୟ ରିଏଲ୍),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(ବାହାମୀୟ ଡଲାର୍),
				'one' => q(ବାହାମୀୟ ଡଲାର୍),
				'other' => q(ବାହାମୀୟ ଡଲାର୍),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ଭୁଟାନୀ ଗଲଟ୍ରୁମ୍),
				'one' => q(ଭୁଟାନୀ ଗଲଟ୍ରୁମ୍),
				'other' => q(ଭୁଟାନୀ ଗଲଟ୍ରୁମ୍),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ବୋତ୍ସୱାନା ପୁଲା),
				'one' => q(ବୋତ୍ସୱାନା ପୁଲା),
				'other' => q(ବୋତ୍ସୱାନା ପୁଲା),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(ବେଲାରୁସି ରୁବଲ୍),
				'one' => q(ବେଲାରୁସି ରୁବଲ୍),
				'other' => q(ବେଲାରୁସି ରୁବଲ୍),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(ବେଲିଜ୍ ଡଲାର୍),
				'one' => q(ବେଲିଜ୍ ଡଲାର୍),
				'other' => q(ବେଲିଜ୍ ଡଲାର୍),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(କାନେଡିୟ ଡଲାର୍),
				'one' => q(କାନେଡିୟ ଡଲାର୍),
				'other' => q(କାନେଡିୟ ଡଲାର୍),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(କଙ୍ଗୋଲିଜ୍ ଫ୍ରାଙ୍କ୍),
				'one' => q(କଙ୍ଗୋଲିଜ୍ ଫ୍ରାଙ୍କ୍),
				'other' => q(କଙ୍ଗୋଲିଜ୍ ଫ୍ରାଙ୍କ୍),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(ସୁଇସ୍ ଫ୍ରାଙ୍କ୍),
				'one' => q(ସୁଇସ୍ ଫ୍ରାଙ୍କ୍),
				'other' => q(ସୁଇସ୍ ଫ୍ରାଙ୍କ୍),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(ଚିଲି ପେସୋ),
				'one' => q(ଚିଲି ପେସୋ),
				'other' => q(ଚିଲି ପେସୋ),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(ଚିନୀ ୟୁଆନ୍ \(ଅଫସୋର୍\)),
				'one' => q(ଚିନୀ ୟୁଆନ୍ \(ଉପକୂଳବର୍ତ୍ତୀ\)),
				'other' => q(ଚିନୀ ୟୁଆନ୍ \(ଅଫସୋର୍\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(ଚିନୀ ୟୁଆନ୍),
				'one' => q(ଚିନୀ ୟୁଆନ୍),
				'other' => q(ଚିନୀ ୟୁଆନ୍),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(କଲୋମ୍ବୀୟ ପେସୋ),
				'one' => q(କଲୋମ୍ବୀୟ ପେସୋ),
				'other' => q(କଲୋମ୍ବୀୟ ପେସୋ),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(କୋଷ୍ଟା ରିକୀୟ କୋଲୋନ୍),
				'one' => q(କୋଷ୍ଟା ରିକୀୟ କୋଲୋନ୍),
				'other' => q(କୋଷ୍ଟା ରିକୀୟ କୋଲୋନ୍),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(କ୍ୟୁବାନ୍ କନଭର୍ଟିବଲ୍ ପେସୋ),
				'one' => q(କ୍ୟୁବାନ୍ କନଭର୍ଟିବଲ୍ ପେସୋ),
				'other' => q(କ୍ୟୁବାନ୍ କନଭର୍ଟିବଲ୍ ପେସୋ),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(କ୍ୟୁବାନ୍ ପେସୋ),
				'one' => q(କ୍ୟୁବାନ୍ ପେସୋ),
				'other' => q(କ୍ୟୁବାନ୍ ପେସୋ),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(କେପ୍ ଭେର୍ଦେୟ ଏସ୍କୁଡୋ),
				'one' => q(କେପ୍ ଭେର୍ଦେୟ ଏସ୍କୁଡୋ),
				'other' => q(କେପ୍ ଭେର୍ଦେୟ ଏସ୍କୁଡୋ),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(ଚେକ୍ କୋରୁନା),
				'one' => q(ଚେକ୍ କୋରୁନା),
				'other' => q(ଚେକ୍ କୋରୁନା),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(ଜିବୌଟିୟ ଫ୍ରାଙ୍କ୍),
				'one' => q(ଜିବୌଟିୟ ଫ୍ରାଙ୍କ୍),
				'other' => q(ଜିବୌଟିୟ ଫ୍ରାଙ୍କ୍),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ଡାନିସ୍ କ୍ରୋନ୍),
				'one' => q(ଡାନିସ୍ କ୍ରୋନ୍),
				'other' => q(ଡାନିସ୍ କ୍ରୋନ୍),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ଡୋମିନିକୀୟ ପେସୋ),
				'one' => q(ଡୋମିନିକୀୟ ପେସୋ),
				'other' => q(ଡୋମିନିକୀୟ ପେସୋ),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(ଆଲଜେରୀୟ ଦିନାର୍),
				'one' => q(ଆଲଜେରୀୟ ଦିନାର୍),
				'other' => q(ଆଲଜେରୀୟ ଦିନାର୍),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(ଇଜିପ୍ଟିୟ ପାଉଣ୍ଡ୍),
				'one' => q(ଇଜିପ୍ଟିୟ ପାଉଣ୍ଡ୍),
				'other' => q(ଇଜିପ୍ଟିୟ ପାଉଣ୍ଡ୍),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(ଏରିଟ୍ରେୟ ନାକଫା),
				'one' => q(ଏରିଟ୍ରେୟ ନାକଫା),
				'other' => q(ଏରିଟ୍ରେୟ ନାକଫା),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ଇଥିଓପିୟ ବିର୍),
				'one' => q(ଇଥିଓପିୟ ବିର୍),
				'other' => q(ଇଥିଓପିୟ ବିର୍),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ୟୁରୋ),
				'one' => q(ୟୁରୋ),
				'other' => q(ୟୁରୋ),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ଫିଜି ଡଲାର୍),
				'one' => q(ଫିଜି ଡଲାର୍),
				'other' => q(ଫିଜି ଡଲାର୍),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ଫକଲ୍ୟାଣ୍ଡ୍ ଦ୍ଵୀପପୁଞ୍ଜ ପାଉଣ୍ଡ୍),
				'one' => q(ଫକଲ୍ୟାଣ୍ଡ୍ ଦ୍ଵୀପପୁଞ୍ଜ ପାଉଣ୍ଡ୍),
				'other' => q(ଫକଲ୍ୟାଣ୍ଡ୍ ଦ୍ଵୀପପୁଞ୍ଜ ପାଉଣ୍ଡ୍),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ବ୍ରିଟିଶ୍ ପାଉଣ୍ଡ୍),
				'one' => q(ବ୍ରିଟିଶ୍ ପାଉଣ୍ଡ୍),
				'other' => q(ବ୍ରିଟିଶ୍ ପାଉଣ୍ଡ୍),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(ଜର୍ଜିୟ ଲାରି),
				'one' => q(ଜର୍ଜିୟ ଲାରି),
				'other' => q(ଜର୍ଜିୟ ଲାରି),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ଘାନିୟ ସେଡି),
				'one' => q(ଘାନିୟ ସେଡି),
				'other' => q(ଘାନିୟ ସେଡି),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(ଗିବ୍ରାଲଟର୍ ପାଉଣ୍ଡ୍),
				'one' => q(ଗିବ୍ରାଲଟର୍ ପାଉଣ୍ଡ୍),
				'other' => q(ଗିବ୍ରାଲଟର୍ ପାଉଣ୍ଡ୍),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(ଗାମ୍ବିୟ ଡାଲାସି),
				'one' => q(ଗାମ୍ବିୟ ଡାଲାସି),
				'other' => q(ଗାମ୍ବିୟ ଡାଲାସି),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(ଗୁଇନେୟ ଫ୍ରାଙ୍କ୍),
				'one' => q(ଗୁଇନେୟ ଫ୍ରାଙ୍କ୍),
				'other' => q(ଗୁଇନେୟ ଫ୍ରାଙ୍କ୍),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(ଗୁଏଟମାଲୀୟ କ୍ଵେତଜାଲ୍),
				'one' => q(ଗୁଏଟମାଲୀୟ କ୍ଵେତଜାଲ୍),
				'other' => q(ଗୁଏଟମାଲୀୟ କ୍ଵେତଜାଲ୍),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(ଗାୟାନିସ୍ ଡଲାର୍),
				'one' => q(ଗାୟାନିସ୍ ଡଲାର୍),
				'other' => q(ଗାୟାନିସ୍ ଡଲାର୍),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ହଂ କଂ ଡଲାର୍),
				'one' => q(ହଂ କଂ ଡଲାର୍),
				'other' => q(ହଂ କଂ ଡଲାର୍),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ହୋଣ୍ଡୁରୀୟ ଲେମପିରା),
				'one' => q(ହୋଣ୍ଡୁରୀୟ ଲେମପିରା),
				'other' => q(ହୋଣ୍ଡୁରୀୟ ଲେମପିରା),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(କ୍ରୋଏସୀୟ କୁନା),
				'one' => q(କ୍ରୋଏସୀୟ କୁନା),
				'other' => q(କ୍ରୋଏସୀୟ କୁନା),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(ହାଇତୀୟ ଗୋରଡ୍),
				'one' => q(ହାଇତୀୟ ଗୋରଡ୍),
				'other' => q(ହାଇତୀୟ ଗୋରଡ୍),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(ହଙ୍ଗେରିୟ ଫୋରିଣ୍ଟ୍),
				'one' => q(ହଙ୍ଗେରିୟ ଫୋରିଣ୍ଟ୍),
				'other' => q(ହଙ୍ଗେରିୟ ଫୋରିଣ୍ଟ୍),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ଇଣ୍ଡୋନେସିୟ ରୁପିଆ),
				'one' => q(ଇଣ୍ଡୋନେସିୟ ରୁପିଆ),
				'other' => q(ଇଣ୍ଡୋନେସିୟ ରୁପିଆ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ଇସ୍ରାଇଲି ନ୍ୟୁ ଶେକେଲ୍),
				'one' => q(ଇସ୍ରାଇଲି ନ୍ୟୁ ଶେକେଲ୍),
				'other' => q(ଇସ୍ରାଇଲି ନ୍ୟୁ ଶେକେଲ୍),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ଭାରତୀୟ ଟଙ୍କା),
				'one' => q(ଭାରତୀୟ ଟଙ୍କା),
				'other' => q(ଭାରତୀୟ ଟଙ୍କା),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ଇରାକି ଦିନାର୍),
				'one' => q(ଇରାକି ଦିନାର୍),
				'other' => q(ଇରାକି ଦିନାର୍),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ଇରାନୀ ରିଆଲ୍),
				'one' => q(ଇରାନୀ ରିଆଲ୍),
				'other' => q(ଇରାନୀ ରିଆଲ୍),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(ଆଇସଲ୍ୟାଣ୍ଡିକ୍‍ କ୍ରୋନା),
				'one' => q(ଆଇସଲ୍ୟାଣ୍ଡିକ୍‍ କ୍ରୋନା),
				'other' => q(ଆଇସଲ୍ୟାଣ୍ଡିକ୍‍ କ୍ରୋନା),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ଜାମାଇକୀୟ ଡଲାର୍),
				'one' => q(ଜାମାଇକୀୟ ଡଲାର୍),
				'other' => q(ଜାମାଇକୀୟ ଡଲାର୍),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(ଜର୍ଡାନିୟ ଦିନାର୍),
				'one' => q(ଜର୍ଡାନିୟ ଦିନାର୍),
				'other' => q(ଜର୍ଡାନିୟ ଦିନାର୍),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(ଜାପାନୀ ୟେନ୍),
				'one' => q(ଜାପାନୀ ୟେନ୍),
				'other' => q(ଜାପାନୀ ୟେନ୍),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(କେନିୟ ଶିଲିଂ),
				'one' => q(କେନିୟ ଶିଲିଂ),
				'other' => q(କେନିୟ ଶିଲିଂ),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(କିର୍ଗିସ୍ତାନୀ ସୋମ୍),
				'one' => q(କିର୍ଗିସ୍ତାନୀ ସୋମ୍),
				'other' => q(କିର୍ଗିସ୍ତାନୀ ସୋମ୍),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(କାମ୍ଵୋଡିୟ ରିଏଲ୍),
				'one' => q(କାମ୍ଵୋଡିୟ ରିଏଲ୍),
				'other' => q(କାମ୍ଵୋଡିୟ ରିଏଲ୍),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(କୋମୋରୀୟ ଫ୍ରାଙ୍କ୍),
				'one' => q(କୋମୋରୀୟ ଫ୍ରାଙ୍କ୍),
				'other' => q(କୋମୋରୀୟ ଫ୍ରାଙ୍କ୍),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(ଉତ୍ତର କୋରିଆଇ ୱୋନ୍),
				'one' => q(ଉତ୍ତର କୋରିଆଇ ୱୋନ୍),
				'other' => q(ଉତ୍ତର କୋରିଆଇ ୱୋନ୍),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(ଦକ୍ଷିଣ କୋରିଆଇ ୱୋନ୍),
				'one' => q(ଦକ୍ଷିଣ କୋରିଆଇ ୱୋନ୍),
				'other' => q(ଦକ୍ଷିଣ କୋରିଆଇ ୱୋନ୍),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(କୁୱେତି ଦିନାର୍),
				'one' => q(କୁୱେତି ଦିନାର୍),
				'other' => q(କୁୱେତି ଦିନାର୍),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(କେମେନ୍ ଦ୍ଵୀପପୁଞ୍ଜ ଡଲାର୍),
				'one' => q(କେମେନ୍ ଦ୍ଵୀପପୁଞ୍ଜ ଡଲାର୍),
				'other' => q(କେମେନ୍ ଦ୍ଵୀପପୁଞ୍ଜ ଡଲାର୍),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(କାଜାକସ୍ତାନୀ ତେଙ୍ଗେ),
				'one' => q(କାଜାକସ୍ତାନୀ ତେଙ୍ଗେ),
				'other' => q(କାଜାକସ୍ତାନୀ ତେଙ୍ଗେ),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(ଲାଓଟିୟ କିପ୍),
				'one' => q(ଲାଓଟିୟ କିପ୍),
				'other' => q(ଲାଓଟିୟ କିପ୍),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ଲେବାନିଜ୍ ପାଉଣ୍ଡ୍),
				'one' => q(ଲେବାନିଜ୍ ପାଉଣ୍ଡ୍),
				'other' => q(ଲେବାନିଜ୍ ପାଉଣ୍ଡ୍),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(ଶ୍ରୀଲଙ୍କିୟ ରୁପି),
				'one' => q(ଶ୍ରୀଲଙ୍କିୟ ରୁପି),
				'other' => q(ଶ୍ରୀଲଙ୍କିୟ ରୁପି),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(ଲିବେରୀୟ ଡଲାର୍),
				'one' => q(ଲିବେରୀୟ ଡଲାର୍),
				'other' => q(ଲିବେରୀୟ ଡଲାର୍),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(ଲିବ୍ୟ ଦିନାର୍),
				'one' => q(ଲିବ୍ୟ ଦିନାର୍),
				'other' => q(ଲିବ୍ୟ ଦିନାର୍),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(ମୋରୋକୀୟ ଦିର୍ହାମ୍),
				'one' => q(ମୋରୋକୀୟ ଦିର୍ହାମ୍),
				'other' => q(ମୋରୋକୀୟ ଦିର୍ହାମ୍),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(ମୋଲଡୋଭାନ୍ ଲେୟୁ),
				'one' => q(ମୋଲଡୋଭାନ୍ ଲେୟୁ),
				'other' => q(ମୋଲଡୋଭାନ୍ ଲେୟୁ),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(ମାଲାଗାସି ଏରିଆରୀ),
				'one' => q(ମାଲାଗାସି ଏରିଆରୀ),
				'other' => q(ମାଲାଗାସି ଏରିଆରୀ),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(ମାସେଡୋନୀୟ ଡିନର୍),
				'one' => q(ମାସେଡୋନୀୟ ଡିନର୍),
				'other' => q(ମାସେଡୋନୀୟ ଡିନର୍),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(ମ୍ୟାନମାର୍ କ୍ୟାତ୍‌),
				'one' => q(ମ୍ୟାନମାର୍ କ୍ୟାତ୍‌),
				'other' => q(ମ୍ୟାନମାର୍ କ୍ୟାତ୍‌),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(ମଙ୍ଗୋଲିୟ ତୁଗ୍ରିକ୍),
				'one' => q(ମଙ୍ଗୋଲିୟ ତୁଗ୍ରିକ୍),
				'other' => q(ମଙ୍ଗୋଲିୟ ତୁଗ୍ରିକ୍),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(ମାକାନେଜ୍ ପାଟାକା),
				'one' => q(ମାକାନେଜ୍ ପାଟାକା),
				'other' => q(ମାକାନେଜ୍ ପାଟାକା),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(ମର୍ଟିନିୟ ଆଗୁଇଅ \(1973–2017\)),
				'one' => q(ମର୍ଟିନିୟ ଆଗୁଇଅ \(1973–2017\)),
				'other' => q(ମର୍ଟିନିୟ ଆଗୁଇଅ \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(ମର୍ଟିନିୟ ଆଗୁଇଅ),
				'one' => q(ମର୍ଟିନିୟ ଆଗୁଇଅ),
				'other' => q(ମର୍ଟିନିୟ ଆଗୁଇଅ),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(ମୌରିସୀୟ ରୁପି),
				'one' => q(ମୌରିସୀୟ ରୁପି),
				'other' => q(ମୌରିସୀୟ ରୁପି),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(ମାଲଡିଭିୟ ରୁଫିୟା),
				'one' => q(ମାଲଡିଭିୟ ରୁଫିୟା),
				'other' => q(ମାଲଡିଭିୟ ରୁଫିୟା),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(ମଲାୱି କ୍ୱାଚା),
				'one' => q(ମଲାୱି କ୍ୱାଚା),
				'other' => q(ମଲାୱି କ୍ୱାଚା),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(ମେକ୍ସିକୀୟ ପେସୋ),
				'one' => q(ମେକ୍ସିକୀୟ ପେସୋ),
				'other' => q(ମେକ୍ସିକୀୟ ପେସୋ),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(ମାଲେସିୟ ରିଙ୍ଗିଟ୍),
				'one' => q(ମାଲେସିୟ ରିଙ୍ଗିଟ୍),
				'other' => q(ମାଲେସିୟ ରିଙ୍ଗିଟ୍),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(ମୋଜାମ୍ବିକୀୟ ମେଟିକାଲ୍),
				'one' => q(ମୋଜାମ୍ବିକୀୟ ମେଟିକାଲ୍),
				'other' => q(ମୋଜାମ୍ବିକୀୟ ମେଟିକାଲ୍),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(ନାମିବିୟ ଡଲାର୍),
				'one' => q(ନାମିବିୟ ଡଲାର୍),
				'other' => q(ନାମିବିୟ ଡଲାର୍),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(ନାଇଜେରିଆଇ ନାଇରା),
				'one' => q(ନାଇଜେରିଆଇ ନାଇରା),
				'other' => q(ନାଇଜେରିଆଇ ନାଇରା),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(ନିକାରାଗୁଆ କୋର୍ଡୋବା),
				'one' => q(ନିକାରାଗୁଆ କୋର୍ଡୋବା),
				'other' => q(ନିକାରାଗୁଆ କୋର୍ଡୋବା),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(ନରୱେୟୀୟ କ୍ରୋନ୍),
				'one' => q(ନରୱେୟୀୟ କ୍ରୋନ୍),
				'other' => q(ନରୱେୟୀୟ କ୍ରୋନ୍),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(ନେପାଳି ରୁପି),
				'one' => q(ନେପାଳି ରୁପି),
				'other' => q(ନେପାଳି ରୁପି),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ନ୍ୟୁଜିଲ୍ୟାଣ୍ଡ୍ ଡଲାର୍),
				'one' => q(ନ୍ୟୁଜିଲ୍ୟାଣ୍ଡ୍ ଡଲାର୍),
				'other' => q(ନ୍ୟୁଜିଲ୍ୟାଣ୍ଡ୍ ଡଲାର୍),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ଓମାନି ରିଆଲ୍),
				'one' => q(ଓମାନି ରିଆଲ୍),
				'other' => q(ଓମାନି ରିଆଲ୍),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(ପାନାମାନିୟ ବାଲବୋଆ),
				'one' => q(ପାନାମାନିୟ ବାଲବୋଆ),
				'other' => q(ପାନାମାନିୟ ବାଲବୋଆ),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(ପେରୁଭୀୟ ସୋଲ୍),
				'one' => q(ପେରୁଭୀୟ ସୋଲ୍),
				'other' => q(ପେରୁଭୀୟ ସୋଲ୍),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(ପପୁଆ ନ୍ୟୁ ଗୁଇନିୟ କିନା),
				'one' => q(ପପୁଆ ନ୍ୟୁ ଗୁଇନିୟ କିନା),
				'other' => q(ପପୁଆ ନ୍ୟୁ ଗୁଇନିୟ କିନା),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ଫିଲିପିନି ପେସୋ),
				'one' => q(ଫିଲିପିନି ପେସୋ),
				'other' => q(ଫିଲିପିନି ପେସୋ),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(ପାକିସ୍ତାନୀ ରୁପି),
				'one' => q(ପାକିସ୍ତାନୀ ରୁପି),
				'other' => q(ପାକିସ୍ତାନୀ ରୁପି),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(ପୋଲିଶ୍ ଜ୍ଲଟୀ),
				'one' => q(ପୋଲିଶ୍ ଜ୍ଲଟୀ),
				'other' => q(ପୋଲିଶ୍ ଜ୍ଲଟୀ),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(ପାରାଗୁଆୟାନ୍ ଗୁଆରାନି),
				'one' => q(ପାରାଗୁଆୟାନ୍ ଗୁଆରାନି),
				'other' => q(ପାରାଗୁଆୟାନ୍ ଗୁଆରାନି),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(କ୍ଵାତାରି ରିଆଲ୍),
				'one' => q(କ୍ଵାତାରି ରିଆଲ୍),
				'other' => q(କ୍ଵାତାରି ରିଆଲ୍),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(ରୋମାନିୟ ଲେଉ),
				'one' => q(ରୋମାନିୟ ଲେଉ),
				'other' => q(ରୋମାନିୟ ଲେଉ),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(ସର୍ବିଆଇ ଦିନାର),
				'one' => q(ସର୍ବିଆଇ ଦିନାର),
				'other' => q(ସର୍ବିଆଇ ଦିନାର),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(ରୁଷି ରୁବଲ୍),
				'one' => q(ରୁଷି ରୁବଲ୍),
				'other' => q(ରୁଷି ରୁବଲ୍),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ରୁୱାଣ୍ଡା ଫ୍ରାଙ୍କ୍),
				'one' => q(ରୁୱାଣ୍ଡା ଫ୍ରାଙ୍କ୍),
				'other' => q(ରୁୱାଣ୍ଡା ଫ୍ରାଙ୍କ୍),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(ସୌଦି ରିୟାଲ୍),
				'one' => q(ସୌଦି ରିୟାଲ୍),
				'other' => q(ସୌଦି ରିୟାଲ୍),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(ସୋଲୋମୋନ୍ ଦ୍ଵୀପପୁଞ୍ଜ ଡଲାର୍),
				'one' => q(ସୋଲୋମୋନ୍ ଦ୍ଵୀପପୁଞ୍ଜ ଡଲାର୍),
				'other' => q(ସୋଲୋମୋନ ଦ୍ଵୀପପୁଞ୍ଜ ଡଲାର୍),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(ସେୟଚେଲୋଇସ୍ ରୁପି),
				'one' => q(ସେୟଚେଲୋଇସ୍ ରୁପି),
				'other' => q(ସେୟଚେଲୋଇସ୍ ରୁପି),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(ସୁଦାନୀଜ ପାଉଣ୍ଡ୍),
				'one' => q(ସୁଦାନୀଜ ପାଉଣ୍ଡ୍),
				'other' => q(ସୁଦାନୀୟ ପାଉଣ୍ଡ୍),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(ସ୍ୱେଡିଶ୍ କ୍ରୋନା),
				'one' => q(ସ୍ୱେଡିଶ୍ କ୍ରୋନା),
				'other' => q(ସ୍ୱେଡିଶ୍ କ୍ରୋନା),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(ସିଙ୍ଗାପୁର୍ ଡଲାର୍),
				'one' => q(ସିଙ୍ଗାପୁର୍ ଡଲାର୍),
				'other' => q(ସିଙ୍ଗାପୁର୍ ଡଲାର୍),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(ସେଣ୍ଟ୍. ହେଲେନା ପାଉଣ୍ଡ୍),
				'one' => q(ସେଣ୍ଟ୍. ହେଲେନା ପାଉଣ୍ଡ୍),
				'other' => q(ସେଣ୍ଟ୍. ହେଲେନା ପାଉଣ୍ଡ୍),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(ସିଏରା ଲିଓନୀୟ ଲେଓନ୍),
				'one' => q(ସିଏରା ଲିଓନୀୟ ଲେଓନ୍),
				'other' => q(ସିଏରା ଲିଓନୀୟ ଲେଓନ୍),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(ସୋମାଲି ସିଲିଂ),
				'one' => q(ସୋମାଲି ସିଲିଂ),
				'other' => q(ସୋମାଲି ସିଲିଂ),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(ସୁରିନାମିଜ୍ ଡଲାର୍),
				'one' => q(ସୁରିନାମିଜ୍ ଡଲାର୍),
				'other' => q(ସୁରିନାମିଜ୍ ଡଲାର୍),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(ଦକ୍ଷିଣ ସୁଡାନିଜ୍‍ ପାଉଣ୍ଡ୍),
				'one' => q(ଦକ୍ଷିଣ ସୁଡାନିଜ୍‍ ପାଉଣ୍ଡ୍),
				'other' => q(ଦକ୍ଷିଣ ସୁଡାନିଜ୍‍ ପାଉଣ୍ଡ୍),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(ସାଓ ତୋମେ & ପ୍ରିସିପ୍ ଡୋବ୍ରା \(1977–2017\)),
				'one' => q(ସାଓ ତୋମେ & ପ୍ରିସିପ୍ ଡୋବ୍ରା \(1977–2017\)),
				'other' => q(ସାଓ ତୋମେ & ପ୍ରିସିପ୍ ଡୋବ୍ରା \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(ସାଓ ତୋମେ & ପ୍ରିସିପ୍ ଡୋବ୍ରା),
				'one' => q(ସାଓ ତୋମେ & ପ୍ରିସିପ୍ ଡୋବ୍ରା),
				'other' => q(ସାଓ ତୋମେ & ପ୍ରିସିପ୍ ଡୋବ୍ରା),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(ସିରିୟ ପାଉଣ୍ଡ୍),
				'one' => q(ସିରିୟ ପାଉଣ୍ଡ୍),
				'other' => q(ସିରିୟ ପାଉଣ୍ଡ୍),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(ସ୍ଵାଜି ଲିଲାଞ୍ଜେନି),
				'one' => q(ସ୍ଵାଜି ଲିଲାଞ୍ଜେନି),
				'other' => q(ସ୍ଵାଜି ଇମାଲଞ୍ଜେନି),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(ଥାଇ ଭାଟ୍),
				'one' => q(ଥାଇ ଭାଟ୍),
				'other' => q(ଥାଇ ଭାଟ୍),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(ତାଜିକିସ୍ତାନୀ ସୋମୋନି),
				'one' => q(ତାଜିକିସ୍ତାନୀ ସୋମୋନି),
				'other' => q(ତାଜିକିସ୍ତାନୀ ସୋମୋନି),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(ତୁର୍କମେନିସ୍ତାନୀ ମନତ୍‌),
				'one' => q(ତୁର୍କମେନିସ୍ତାନୀ ମନତ୍‌),
				'other' => q(ତୁର୍କମେନିସ୍ତାନୀ ମନତ୍‌),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(ଟୁନେସିଆଇ ଦିନାର୍),
				'one' => q(ଟୁନେସିଆଇ ଦିନାର୍),
				'other' => q(ଟୁନେସିଆଇ ଦିନାର୍),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(ତୋଙ୍ଗିୟ ପାଙ୍ଗା),
				'one' => q(ତୋଙ୍ଗିୟ ପାଙ୍ଗା),
				'other' => q(ତୋଙ୍ଗିୟ ପାଙ୍ଗା),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(ତୁର୍କିୟ ଲିରା),
				'one' => q(ତୁର୍କିୟ ଲିରା),
				'other' => q(ତୁର୍କିୟ ଲିରା),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ ଡଲାର୍),
				'one' => q(ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ ଡଲାର୍),
				'other' => q(ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ ଡଲାର୍),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ନ୍ୟୁ ତାଇୱାନ୍ ଡଲାର୍),
				'one' => q(ନ୍ୟୁ ତାଇୱାନ୍ ଡଲାର୍),
				'other' => q(ନ୍ୟୁ ତାଇୱାନ୍ ଡଲାର୍),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(ତାନଜାନୀୟ ଶିଲିଂ),
				'one' => q(ତାନଜାନୀୟ ଶିଲିଂ),
				'other' => q(ତାନଜାନୀୟ ଶିଲିଂ),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ୟୁକ୍ରେନୀୟ ହ୍ରାଇଭନିଆ),
				'one' => q(ୟୁକ୍ରେନୀୟ ହ୍ରାଇଭନିଆ),
				'other' => q(ୟୁକ୍ରେନୀୟ ହ୍ରାଇଭନିଆ),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(ଉଗାଣ୍ଡିୟ ଶିଲିଂ),
				'one' => q(ଉଗାଣ୍ଡିୟ ଶିଲିଂ),
				'other' => q(ଉଗାଣ୍ଡିୟ ଶିଲିଂ),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(ଯୁକ୍ତରାଷ୍ଟ୍ର ଡଲାର୍),
				'one' => q(ଯୁକ୍ତରାଷ୍ଟ୍ର ଡଲାର୍),
				'other' => q(ଯୁକ୍ତରାଷ୍ଟ୍ର ଡଲାର୍),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(ଉରୁଗୁଇୟାନ୍ ପେସୋ),
				'one' => q(ଉରୁଗୁଇୟାନ୍ ପେସୋ),
				'other' => q(ଉରୁଗୁଇୟାନ୍ ପେସୋ),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ଉଜବେକିସ୍ତାନୀ ସୋମ୍),
				'one' => q(ଉଜବେକିସ୍ତାନୀ ସୋମ୍),
				'other' => q(ଉଜବେକିସ୍ତାନୀ ସୋମ୍),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(ଭେନେଜୁଏଲାନ୍ ବୋଲିଭାର୍ \(2008–2018\)),
				'one' => q(ଭେନେଜୁଏଲାନ୍ ବୋଲିଭାର୍ \(2008–2018\)),
				'other' => q(ଭେନେଜୁଏଲାନ୍ ବୋଲିଭାର୍ \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(ଭେନେଜୁଏଲାନ୍ ବୋଲିଭାର୍),
				'one' => q(ଭେନେଜୁଏଲାନ୍ ବୋଲିଭାର୍),
				'other' => q(ଭେନେଜୁଏଲାନ୍ ବୋଲିଭାର୍),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ଭୀଏତନାମୀୟ ଡଙ୍ଗ),
				'one' => q(ଭୀଏତନାମୀୟ ଡଙ୍ଗ),
				'other' => q(ଭୀଏତନାମୀୟ ଡଙ୍ଗ),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(ଭାନୁଆଟୁ ଭାଟୁ),
				'one' => q(ଭାନୁଆଟୁ ଭାଟୁ),
				'other' => q(ଭାନୁଆଟୁ ଭାଟୁ),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(ସାମୋୟିୟ ତାଲା),
				'one' => q(ସାମୋୟିୟ ତାଲା),
				'other' => q(ସାମୋୟିୟ ତାଲା),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(ମଧ୍ୟ ଆଫ୍ରିକୀ CFA ଫ୍ରାଙ୍କ୍),
				'one' => q(ମଧ୍ୟ ଆଫ୍ରିକୀ CFA ଫ୍ରାଙ୍କ୍),
				'other' => q(ମଧ୍ୟ ଆଫ୍ରିକୀ CFA ଫ୍ରାଙ୍କ୍),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(ପୂର୍ବ କାରିବୀୟ ଡଲାର୍),
				'one' => q(ପୂର୍ବ କାରିବୀୟ ଡଲାର୍),
				'other' => q(ପୂର୍ବ କାରିବୀୟ ଡଲାର୍),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(ପଶ୍ଚିମ ଆଫ୍ରିକିୟ CFA ଫ୍ରାଙ୍କ୍),
				'one' => q(ପଶ୍ଚିମ ଆଫ୍ରିକିୟ CFA ଫ୍ରାଙ୍କ୍),
				'other' => q(ପଶ୍ଚିମ ଆଫ୍ରିକିୟ CFA ଫ୍ରାଙ୍କ୍),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP ଫ୍ରାଙ୍କ୍),
				'one' => q(CFP ଫ୍ରାଙ୍କ୍),
				'other' => q(CFP ଫ୍ରାଙ୍କ୍),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(ଅଜଣା ମୁଦ୍ରା),
				'one' => q(\(ମୁଦ୍ରାର ଅଜଣା ଏକକ\)),
				'other' => q(\(ଅଜଣା ମୁଦ୍ରା\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(ୟେମେନି ରିଆଲ୍),
				'one' => q(ୟେମେନି ରିଆଲ୍),
				'other' => q(ୟେମେନି ରିଆଲ୍),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(ଦକ୍ଷିଣ ଆଫ୍ରିକିୟ ରାଣ୍ଡ୍),
				'one' => q(ଦକ୍ଷିଣ ଆଫ୍ରିକିୟ ରାଣ୍ଡ୍),
				'other' => q(ଦକ୍ଷିଣ ଆଫ୍ରିକିୟ ରାଣ୍ଡ୍),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(ଜାମ୍ବୀୟ କ୍ୱାଚା),
				'one' => q(ଜାମ୍ବୀୟ କ୍ୱାଚା),
				'other' => q(ଜାମ୍ବୀୟ କ୍ୱାଚା),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ଜାନୁଆରୀ',
							'ଫେବୃଆରୀ',
							'ମାର୍ଚ୍ଚ',
							'ଅପ୍ରେଲ',
							'ମଇ',
							'ଜୁନ',
							'ଜୁଲାଇ',
							'ଅଗଷ୍ଟ',
							'ସେପ୍ଟେମ୍ବର',
							'ଅକ୍ଟୋବର',
							'ନଭେମ୍ବର',
							'ଡିସେମ୍ବର'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ଜା',
							'ଫେ',
							'ମା',
							'ଅ',
							'ମଇ',
							'ଜୁ',
							'ଜୁ',
							'ଅ',
							'ସେ',
							'ଅ',
							'ନ',
							'ଡି'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ଜାନୁଆରୀ',
							'ଫେବୃଆରୀ',
							'ମାର୍ଚ୍ଚ',
							'ଅପ୍ରେଲ',
							'ମଇ',
							'ଜୁନ',
							'ଜୁଲାଇ',
							'ଅଗଷ୍ଟ',
							'ସେପ୍ଟେମ୍ବର',
							'ଅକ୍ଟୋବର',
							'ନଭେମ୍ବର',
							'ଡିସେମ୍ବର'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ଜାନୁଆରୀ',
							'ଫେବୃଆରୀ',
							'ମାର୍ଚ୍ଚ',
							'ଅପ୍ରେଲ',
							'ମଇ',
							'ଜୁନ',
							'ଜୁଲାଇ',
							'ଅଗଷ୍ଟ',
							'ସେପ୍ଟେମ୍ବର',
							'ଅକ୍ଟୋବର',
							'ନଭେମ୍ବର',
							'ଡିସେମ୍ବର'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ଜା',
							'ଫେ',
							'ମା',
							'ଅ',
							'ମଇ',
							'ଜୁ',
							'ଜୁ',
							'ଅ',
							'ସେ',
							'ଅ',
							'ନ',
							'ଡି'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ଜାନୁଆରୀ',
							'ଫେବୃଆରୀ',
							'ମାର୍ଚ୍ଚ',
							'ଅପ୍ରେଲ',
							'ମଇ',
							'ଜୁନ',
							'ଜୁଲାଇ',
							'ଅଗଷ୍ଟ',
							'ସେପ୍ଟେମ୍ବର',
							'ଅକ୍ଟୋବର',
							'ନଭେମ୍ବର',
							'ଡିସେମ୍ବର'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ସୋମ',
						tue => 'ମଙ୍ଗଳ',
						wed => 'ବୁଧ',
						thu => 'ଗୁରୁ',
						fri => 'ଶୁକ୍ର',
						sat => 'ଶନି',
						sun => 'ରବି'
					},
					narrow => {
						mon => 'ସୋ',
						tue => 'ମ',
						wed => 'ବୁ',
						thu => 'ଗୁ',
						fri => 'ଶୁ',
						sat => 'ଶ',
						sun => 'ର'
					},
					short => {
						mon => 'ସୋମ',
						tue => 'ମଙ୍ଗଳ',
						wed => 'ବୁଧ',
						thu => 'ଗୁରୁ',
						fri => 'ଶୁକ୍ର',
						sat => 'ଶନି',
						sun => 'ରବି'
					},
					wide => {
						mon => 'ସୋମବାର',
						tue => 'ମଙ୍ଗଳବାର',
						wed => 'ବୁଧବାର',
						thu => 'ଗୁରୁବାର',
						fri => 'ଶୁକ୍ରବାର',
						sat => 'ଶନିବାର',
						sun => 'ରବିବାର'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ସୋମ',
						tue => 'ମଙ୍ଗଳ',
						wed => 'ବୁଧ',
						thu => 'ଗୁରୁ',
						fri => 'ଶୁକ୍ର',
						sat => 'ଶନି',
						sun => 'ରବି'
					},
					narrow => {
						mon => 'ସୋ',
						tue => 'ମ',
						wed => 'ବୁ',
						thu => 'ଗୁ',
						fri => 'ଶୁ',
						sat => 'ଶ',
						sun => 'ର'
					},
					short => {
						mon => 'ସୋମ',
						tue => 'ମଙ୍ଗଳ',
						wed => 'ବୁଧ',
						thu => 'ଗୁରୁ',
						fri => 'ଶୁକ୍ର',
						sat => 'ଶନି',
						sun => 'ରବି'
					},
					wide => {
						mon => 'ସୋମବାର',
						tue => 'ମଙ୍ଗଳବାର',
						wed => 'ବୁଧବାର',
						thu => 'ଗୁରୁବାର',
						fri => 'ଶୁକ୍ରବାର',
						sat => 'ଶନିବାର',
						sun => 'ରବିବାର'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1ମ ତ୍ରୟମାସ',
						1 => '2ୟ ତ୍ରୟମାସ',
						2 => '3ୟ ତ୍ରୟମାସ',
						3 => '4ର୍ଥ ତ୍ରୟମାସ'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1ମ ତ୍ରୟମାସ',
						1 => '2ୟ ତ୍ରୟମାସ',
						2 => '3ୟ ତ୍ରୟମାସ',
						3 => '4ର୍ଥ ତ୍ରୟମାସ'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1ମ ତ୍ରୟମାସ',
						1 => '2ୟ ତ୍ରୟମାସ',
						2 => '3ୟ ତ୍ରୟମାସ',
						3 => '4ର୍ଥ ତ୍ରୟମାସ'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'am' => q{ପୂ},
					'pm' => q{ଅ},
				},
				'wide' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
				'abbreviated' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'pm' => q{ଅପରାହ୍ନ},
					'am' => q{ପୂର୍ବାହ୍ନ},
				},
				'wide' => {
					'am' => q{ପୂର୍ବାହ୍ନ},
					'pm' => q{ଅପରାହ୍ନ},
				},
				'narrow' => {
					'am' => q{AM},
					'pm' => q{ଅପରାହ୍ନ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'BC',
				'1' => 'AD'
			},
			wide => {
				'0' => 'ଖ୍ରୀଷ୍ଟପୂର୍ବ',
				'1' => 'ଖ୍ରୀଷ୍ଟାବ୍ଦ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, MMMM d, y G},
			'long' => q{MMMM d, y G},
			'medium' => q{MMM d, y G},
			'short' => q{M/d/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, MMMM d, y},
			'long' => q{MMMM d, y},
			'medium' => q{MMM d, y},
			'short' => q{M/d/yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} ରେ {0}},
			'long' => q{{1} ରେ {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{0} ଠାରେ {1}},
			'long' => q{{0} ଠାରେ {1}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, MMM d, y G},
			GyMMMd => q{MMM d, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, M/d},
			MMM => q{LLL},
			MMMEd => q{E, MMM d},
			MMMMW => q{MMMM ର ସପ୍ତାହ W},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			MMdd => q{dd-MM},
			Md => q{M/d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, M/d/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, MMM d, y},
			yMMMM => q{MMMM y},
			yMMMd => q{MMM d, y},
			yMd => q{M/d/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Y ର ସପ୍ତାହ w},
		},
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, MMM d, y G},
			GyMMMd => q{MMM d, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, M/d},
			MMM => q{LLL},
			MMMEd => q{E, MMM d},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			MMdd => q{dd-MM},
			Md => q{M/d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yMM => q{MM-y G},
			yMMMM => q{MMMM y G},
			yQQQ => q{QQQ y G},
			yyyy => q{y G},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E, M/d/y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, MMM d, y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{MMM d, y G},
			yyyyMd => q{M/d/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM-dd, E – MM-dd, E},
				d => q{MM-dd, E – MM-dd, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{y-MM – y-MM},
				y => q{y-MM – y-MM},
			},
			yMEd => {
				M => q{y-MM-dd, E – y-MM-dd, E},
				d => q{y-MM-dd, E – y-MM-dd, E},
				y => q{y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{y MMM–MMM},
				y => q{y MMM – y MMM},
			},
			yMMMEd => {
				M => q{y MMM d, E – MMM d, E},
				d => q{y MMM d, E – MMM d, E},
				y => q{y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{y MMMM–MMMM},
				y => q{y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{y MMM d – MMM d},
				d => q{y MMM d–d},
				y => q{y MMM d – y MMM d},
			},
			yMd => {
				M => q{y-MM-dd – y-MM-dd},
				d => q{y-MM-dd – y-MM-dd},
				y => q{y-MM-dd – y-MM-dd},
			},
		},
		'generic' => {
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, M/d – E, M/d},
				d => q{E, M/d – E, M/d},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, MMM d – E, MMM d},
				d => q{E, MMM d – E, MMM d},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d – d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{M/d – M/d},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			yMd => {
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} ସମୟ),
		regionFormat => q({0} ଦିବାଲୋକ ସମୟ),
		regionFormat => q({0} ମାନାଙ୍କ ସମୟ),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#ଆଫଗାନିସ୍ତାନ ସମୟ#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ଆବିଦଜାନ#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ଆକାରା#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ଆଦିସ୍‌ ଆବାବା#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ଅଲଜିୟର୍ସ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ଅସମରା#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ବାମାକୋ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ବାଙ୍ଗୁଇ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ବାଞ୍ଜୁଲ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ବିସାଉ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ବ୍ଲାଣ୍ଟାୟାର୍‌#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ବ୍ରାଜାଭିଲ୍ଲେ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ବୁଜୁମ୍ବୁରା#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#କାଇରୋ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#କାସାବ୍ଲାଙ୍କା#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ସେଉଟା#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#କୋନାକ୍ରି#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ଡକାର#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ଡର୍‌ ଇସ୍‌ ସାଲାମ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ଜିବୋଟି#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ଡଉଲା#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ଏଲ୍‌ ଏୟନ୍#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ଫ୍ରିଟାଉନ୍‌#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ଗାବୋର୍ଣ୍ଣ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ହରାରେ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ଜୋହାନ୍ସବର୍ଗ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ଜୁବା#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#କାମ୍ପାଲା#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ଖରଟୌମ୍‌#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#କିଗାଲି#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#କିନସାସ୍‌#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ଲାଗୋସ୍‌#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ଲିବ୍ରେଭିଲ୍ଲେ#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ଲୋମ୍‌#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ଲୁଆଣ୍ଡା#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ଲୁବୁମ୍ବାଶି#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ଲୁସାକା#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ମାଲାବୋ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ମାପୁତୋ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ମେସେରୁ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ବାବେନ୍‌#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#ମୋଗାଡିଶୁ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#ମନରୋଭିଆ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ନାଇରୋବି#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ଜାମେନା#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ନିଆମି#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ନୌକାଚୋଟ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ଅଉଗାଡଉଗଉ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ପୋଟୋ-ନୋଭୋ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ସାଓ ଟୋମେ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ତ୍ରିପୋଲି#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ଟୁନିସ୍‌#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ୱିଣ୍ଡହୋଏକ୍#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#ମଧ୍ୟ ଆଫ୍ରିକା ସମୟ#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#ପୂର୍ବ ଆଫ୍ରିକା ସମୟ#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#ଦକ୍ଷିଣ ଆଫ୍ରିକା ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#ପଶ୍ଚିମ ଆଫ୍ରିକା ଖରାଦିନ ସମୟ#,
				'generic' => q#ପଶ୍ଚିମ ଆଫ୍ରିକା ସମୟ#,
				'standard' => q#ପଶ୍ଚିମ ଆଫ୍ରିକା ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#ଆଲାସ୍କା ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଆଲାସ୍କା ସମୟ#,
				'standard' => q#ଆଲାସ୍କା ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ଆମାଜନ୍ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ#,
				'generic' => q#ଆମାଜନ୍ ସମୟ#,
				'standard' => q#ଆମାଜନ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ଆଡାକ୍#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ଆଙ୍କରେଜ୍#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ଆଙ୍ଗୁଇଲା#,
		},
		'America/Antigua' => {
			exemplarCity => q#ଆଣ୍ଟିଗୁଆ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#ଆରାଗୁଆନା#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ଲା ରିଓଜା#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ରିଓ ଗାଲ୍ଲେଗସ୍‌#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ସଲ୍ଟା#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ସାନ୍‌ ଜୁଆନ#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ସାନ୍‌ ଲୁଇସ୍‌#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ଟୁକୁମାନ୍‌#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ଉଶୁୟା#,
		},
		'America/Aruba' => {
			exemplarCity => q#ଆରୁବା#,
		},
		'America/Asuncion' => {
			exemplarCity => q#ଆସନସିଅନ୍‌#,
		},
		'America/Bahia' => {
			exemplarCity => q#ବାହିଆ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ବାହିଆ ବ୍ୟାଣ୍ଡେରାସ୍#,
		},
		'America/Barbados' => {
			exemplarCity => q#ବାର୍ବାଡୋସ୍#,
		},
		'America/Belem' => {
			exemplarCity => q#ବେଲେମ#,
		},
		'America/Belize' => {
			exemplarCity => q#ବେଲିଜେ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ବ୍ଲାଙ୍କ-ସାବଲୋନ୍#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ବୋଆ ଭିଷ୍ଟା#,
		},
		'America/Bogota' => {
			exemplarCity => q#ବୋଗୋଟା#,
		},
		'America/Boise' => {
			exemplarCity => q#ବୋଇସେ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ବୁଏନସ୍‌ ଏରିସ୍‌#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#କେମ୍ଵ୍ରିଜ୍ ବେ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#କାମ୍ପୋ ଗ୍ରାଣ୍ଡେ#,
		},
		'America/Cancun' => {
			exemplarCity => q#କାନକୁନ୍#,
		},
		'America/Caracas' => {
			exemplarCity => q#କାରକାସ୍‌#,
		},
		'America/Catamarca' => {
			exemplarCity => q#କାଟାମାର୍କା#,
		},
		'America/Cayenne' => {
			exemplarCity => q#କେୟେନ୍ନି#,
		},
		'America/Cayman' => {
			exemplarCity => q#କାୟମ୍ୟାନ୍#,
		},
		'America/Chicago' => {
			exemplarCity => q#ଚିକାଗୋ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ଚିହୁଆହୁଆ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ଆଟିକୋକାନ୍#,
		},
		'America/Cordoba' => {
			exemplarCity => q#କୋର୍ଡୋବା#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#କୋଷ୍ଟା ରିକା#,
		},
		'America/Creston' => {
			exemplarCity => q#କ୍ରେଷ୍ଟୋନ୍#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#କୁଇବା#,
		},
		'America/Curacao' => {
			exemplarCity => q#କୁରାକୋ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ଡାନମାର୍କସାଭନ୍#,
		},
		'America/Dawson' => {
			exemplarCity => q#ଡସନ୍‌#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ଡୱସନ୍ କ୍ରିକ୍#,
		},
		'America/Denver' => {
			exemplarCity => q#ଡେନଭିର୍#,
		},
		'America/Detroit' => {
			exemplarCity => q#ଡେଟ୍ରୋଇଟ୍#,
		},
		'America/Dominica' => {
			exemplarCity => q#ଡୋମିନିକା#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ଏଡମୋନଟୋନ୍#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ଇରୁନେପେ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ଏଲ୍ ସାଲଭାଡୋର୍#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ଫୋର୍ଟ୍ ନେଲସନ୍#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ଫୋର୍ଟେଲେଜା#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ଗ୍ଲାସେ ବେ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ନୁଉକ୍#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ଗୁସ୍ ବେ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ଗ୍ରାଣ୍ଡ୍ ଟର୍କ୍#,
		},
		'America/Grenada' => {
			exemplarCity => q#ଗ୍ରେନାଡା#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ଗୁଆଡେଲୋଉପେ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ଗୁଆତେମାଲା#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ଗୁୟାକ୍ୱିଲ#,
		},
		'America/Guyana' => {
			exemplarCity => q#ଗୁଏନା#,
		},
		'America/Halifax' => {
			exemplarCity => q#ହାଲିଫ୍ୟାକ୍ସ୍#,
		},
		'America/Havana' => {
			exemplarCity => q#ହାଭାନା#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ହେରମୋସିଲୋ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#କ୍ନୋକ୍ସ, ଇଣ୍ଡିଆନା#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#ମାରେନଗୋ, ଇଣ୍ଡିଆନା#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ପେଟେର୍ସବର୍ଗ୍, ଇଣ୍ଡିଆନା#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ଟେଲ୍ ସିଟି, ଇଣ୍ଡିଆନା#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ଭେଭାୟ, ଇଣ୍ଡିଆନା#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ଭିନସେନ୍ନେସ୍, ଇଣ୍ଡିଆନା#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ୱିନାମାକ୍, ଇଣ୍ଡିଆନା#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ଇଣ୍ଡିଆନାପୋଲିସ୍#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ଇନୁଭିକ୍#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ଇକ୍ଵାଲୁଇଟ୍#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ଜାମାଇକା#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ଜୁଜୁଇ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ଜୁନେଆଉ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ମୋଣ୍ଟିସେଲୋ, କେଣ୍ଟଉକିକେ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#କ୍ରାଲେଣ୍ଡଜିକ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ଲା ପାଜ୍‌#,
		},
		'America/Lima' => {
			exemplarCity => q#ଲିମା#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ଲସ୍ ଏଞ୍ଜେଲେସ୍#,
		},
		'America/Louisville' => {
			exemplarCity => q#ଲୌଇସଭିଲ୍ଲେ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ନିମ୍ନ ପ୍ରିନ୍ସ’ର କ୍ଵାଟର୍#,
		},
		'America/Maceio' => {
			exemplarCity => q#ମାସିଓ#,
		},
		'America/Managua' => {
			exemplarCity => q#ମାନାଗୁଆ#,
		},
		'America/Manaus' => {
			exemplarCity => q#ମାନାଉସ୍‌#,
		},
		'America/Marigot' => {
			exemplarCity => q#ମାରିଗୋଟ୍#,
		},
		'America/Martinique' => {
			exemplarCity => q#ମାର୍ଟିନିକ୍ୟୁ#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ମାଟାମୋରୋସ୍#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ମାନାଟଲାନ୍#,
		},
		'America/Mendoza' => {
			exemplarCity => q#ମେଣ୍ଡୋଜା#,
		},
		'America/Menominee' => {
			exemplarCity => q#ମେନୋମିନି#,
		},
		'America/Merida' => {
			exemplarCity => q#ମେରିଡା#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ମାଟଲାକାଟଲା#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ମେକ୍ସିକୋ ସିଟି#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ମିକ୍ଵେଲୋନ୍#,
		},
		'America/Moncton' => {
			exemplarCity => q#ମାନକଟୋନ୍#,
		},
		'America/Monterrey' => {
			exemplarCity => q#ମୋନଟେରିଏ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#ମଣ୍ଟେଭିଡିଓ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#ମୋନଟସେରରାଟ୍#,
		},
		'America/Nassau' => {
			exemplarCity => q#ନାସାଉ#,
		},
		'America/New_York' => {
			exemplarCity => q#ନ୍ୟୁ ୟୋର୍କ୍#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ନିପିଗୋନ୍#,
		},
		'America/Nome' => {
			exemplarCity => q#ନୋମେ#,
		},
		'America/Noronha' => {
			exemplarCity => q#ନୋରୋନ୍ନା#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ବେଉଲାହ, ଉତ୍ତର ଡାକୋଟା#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#କେନ୍ଦ୍ର, ଉତ୍ତର ଡାକୋଟା#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ନ୍ୟୁ ସାଲେମ୍, ଉତ୍ତର ଡାକୋଟା#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ଓଜିନାଗା#,
		},
		'America/Panama' => {
			exemplarCity => q#ପାନାମା#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ପାଙ୍ଗନିର୍ଟୁଙ୍ଗ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ପାରାମାରିବୋ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ଫୋଇନିକ୍ସ#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ପୋର୍ଟ୍-ଏୟୁ-ପ୍ରିନ୍ସ#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ପୋର୍ଟ୍ ଅଫ୍ ସ୍ପେନ୍#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ପୋର୍ଟୋ ଭେଲୋ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ପୁଏର୍ତୋ ରିକୋ#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#ପୁଣ୍ଟା ଏରିନାସ୍‌#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ରେଇନି ରିଭର୍#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ରାନକିନ୍ ଇନଲେଟ୍#,
		},
		'America/Recife' => {
			exemplarCity => q#ରେସିଫି#,
		},
		'America/Regina' => {
			exemplarCity => q#ରେଗିନା#,
		},
		'America/Resolute' => {
			exemplarCity => q#ରିସୋଲୁଟେ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ରିଓ ବ୍ରାଙ୍କୋ#,
		},
		'America/Santarem' => {
			exemplarCity => q#ସାଣ୍ଟାରେମ୍‌#,
		},
		'America/Santiago' => {
			exemplarCity => q#ସାଣ୍ଟିଆଗୋ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ସାଣ୍ଟୋ ଡୋମିଙ୍ଗୋ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ସାଓ ପାଓଲୋ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ଇଟ୍ଟୋକ୍ଵୋରଟୋରମିଟ୍#,
		},
		'America/Sitka' => {
			exemplarCity => q#ସିଟକା#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ସେଣ୍ଟ୍. ବାର୍ଥେଲେମି#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ସେଣ୍ଟ୍. ଜନସ୍#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ସେଣ୍ଟ୍ କିଟ୍ସ୍#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ସେଣ୍ଟ୍. ଲୁସିଆ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ସେଣ୍ଟ୍. ଥୋମାସ୍#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ସେଣ୍ଟ୍. ଭିନସେଣ୍ଟ୍#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ସୁଇଫ୍ଟ୍ କରେଣ୍ଟ୍#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ଟେଗୁସିଗାଲପା#,
		},
		'America/Thule' => {
			exemplarCity => q#ଥୁଲେ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ଥଣ୍ଡର୍ ବେ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ତିଜୁଆନା#,
		},
		'America/Toronto' => {
			exemplarCity => q#ଟୋରୋଣ୍ଟୋ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ଟୋରଟୋଲା#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ଭାଙ୍କୁଭର୍#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ହ୍ଵାଇଟହର୍ସ୍#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ୱିନିପେଗ୍#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ୟାକୁଟାଟ୍#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ୟେଲ୍ଲୋନାଇଫ୍#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#କେନ୍ଦ୍ରୀୟ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#କେନ୍ଦ୍ରୀୟ ସମୟ#,
				'standard' => q#କେନ୍ଦ୍ରୀୟ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ପୂର୍ବାଞ୍ଚଳ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ପୂର୍ବାଞ୍ଚଳ ସମୟ#,
				'standard' => q#ପୂର୍ବାଞ୍ଚଳ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#ପାର୍ବତ୍ୟ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ପାର୍ବତ୍ୟ ସମୟ#,
				'standard' => q#ପାର୍ବତ୍ୟ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#ପାସିଫିକ୍ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ପାସିଫିକ୍ ସମୟ#,
				'standard' => q#ପାସିଫିକ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#କାସେ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ଡେଭିସ୍‌#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ଡୁମୋଣ୍ଟ ଡି‘ଉରଭିଲ୍ଲେ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ମାକ୍ୱେରୀ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ମାୱସନ୍#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ମ୍ୟାକ୍‌ମୁର୍ଡୋ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ପାଲମର୍‌#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ରୋଥେରା#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ସୋୱା#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ଟ୍ରୋଲ୍#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ଭୋଷ୍ଟୋକ୍‌#,
		},
		'Apia' => {
			long => {
				'daylight' => q#ଆପିଆ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଆପିଆ ସମୟ#,
				'standard' => q#ଆପିଆ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#ଆରବୀୟ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଆରବୀୟ ସମୟ#,
				'standard' => q#ଆରବୀୟ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ଲଙ୍ଗୟେଆରବୟେନ୍#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ଆର୍ଜେଣ୍ଟିନା ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଆର୍ଜେଣ୍ଟିନା ସମୟ#,
				'standard' => q#ଆର୍ଜେଣ୍ଟିନା ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#ପଶ୍ଚିମ ଆର୍ଜେଣ୍ଟିନା ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ପଶ୍ଚିମ ଆର୍ଜେଣ୍ଟିନା ସମୟ#,
				'standard' => q#ପଶ୍ଚିମ ଆର୍ଜେଣ୍ଟିନା ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ଆର୍ମେନିଆ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଆର୍ମେନିଆ ସମୟ#,
				'standard' => q#ଆର୍ମେନିଆ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ଏଡେନ୍‌#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ଅଲମାଟି#,
		},
		'Asia/Amman' => {
			exemplarCity => q#ଅମ୍ମାନ#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#ଆନାଡୟାର୍#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#ଆକଟାଉ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#ଆକଟୋବ୍‌#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#ଆଶ୍‌ଗାବୋଟ୍‌#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#ଅତିରାଉ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ବାଗଦାଦ୍‌#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ବାହାରିନ୍#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ବାକୁ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ବ୍ୟାଙ୍ଗକକ୍‌#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#ବାରନାଉଲ୍#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ବୀରୁଟ୍‌#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ବିଶକେକ୍‌#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ବ୍ରୁନେଇ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#କୋଲକାତା#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ଚିଟା#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ଚୋଇବାଲସାନ୍‌#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#କଲମ୍ବୋ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ଡାମାସକସ୍‌#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ଢାକା#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ଦିଲ୍ଲୀ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ଦୁବାଇ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ଦୁଶାନବେ#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ଫାମାଗୁଷ୍ଟା#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ଗାଜା#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ହେବ୍ରନ୍‌#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ହଂ କଂ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ହୋଭଡ୍‌#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ଇରକୁଟସ୍କ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ଜାକର୍ତ୍ତା#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ଜୟପୁରା#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ଜେରୁଜେଲମ#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#କାବୁଲ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#କାମଚାଟକା#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#କରାଚି#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#କାଠମାଣ୍ଡୁ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ଖାନଡ୍ୟାଗା#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#କ୍ରାସନୋୟାରସ୍କ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#କ୍ୱାଲାଲମ୍ପୁର#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#କୁଚିଂ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#କୁଏତ#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ମାକାଉ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ମାଗାଡାନ୍#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ମାକାସାର୍‌#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ମାନିଲା#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#ମସ୍କାଟ୍‌#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ନିକୋସିଆ#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ନୋଭୋକୁଜନେଟସ୍କ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ନୋଭୋସିବିରସ୍କ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ଓମସ୍କ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ଓରାଲ୍‌#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ଫନୋମ୍‌ ପେନହ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ପୋଣ୍ଟିଆନାକ୍‌#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ପୋୟଙ୍ଗୟାଙ୍ଗ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#କତାର୍#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#କୀଜିଲୋର୍ଡା#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ୟାଙ୍ଗୁନ୍‌#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ରିଆଦ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ହୋ ଚି ମିନ୍‌ ସିଟି#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ସଖାଲିନ୍#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ସମରକନ୍ଦ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ସିଓଲ#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ସଂଘାଇ#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#ସିଙ୍ଗାପୁର୍‌#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ସ୍ରେଡନେକୋଲୟମସ୍କ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ତାଇପେଇ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ତାଶକେଣ୍ଟ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ଟିବିଲିସି#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ତେହେରାନ୍#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ଥିମ୍ପୁ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ଟୋକିଓ#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ଟୋମସ୍କ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ଉଲାନ୍‌ବାଟର୍‌#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ଉରୁମକି#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ୟୁଷ୍ଟ-ନେରା#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ଭିଏଣ୍ଟିଏନ୍‌#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ଭ୍ଲାଡିଭୋଷ୍ଟୋକ୍#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ୟାକୁଟସ୍କ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ୟେକାଟେରିନବର୍ଗ୍#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ୟେରେଭାନ୍#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#ଆଟଲାଣ୍ଟିକ୍ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଆଟଲାଣ୍ଟିକ୍ ସମୟ#,
				'standard' => q#ଆଟଲାଣ୍ଟିକ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ଆଜୋରେସ୍#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ବର୍ମୁଡା#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#କାନାରେ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#କେପ୍‌ ଭର୍ଦେ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ଫାରୋଏ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ମାଡେଇରା#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ରେୟକଜାଭିକ୍#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ଦକ୍ଷିଣ ଜର୍ଜିଆ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ସେଣ୍ଟ୍‌ ହେଲିନା#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ଷ୍ଟାନଲି#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ଆଡିଲେଡ୍‌#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ବ୍ରିସବେନ୍‌#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ବ୍ରୋକେନ୍‌ ହିଲ୍‌#,
		},
		'Australia/Currie' => {
			exemplarCity => q#କ୍ୟୁରୀ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ଡାରୱିନ୍‌#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ୟୁକଲା#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ହୋବାର୍ଟ୍‌#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ଲିଣ୍ଡେମ୍ୟାନ୍‌#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ଲର୍ଡ ହୋୱେ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ମେଲବୋର୍ଣ୍ଣ#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ପର୍ଥ୍‌#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ସିଡନୀ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#ଅଷ୍ଟ୍ରେଲିୟ ମଧ୍ୟ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ମଧ୍ୟ ଅଷ୍ଟ୍ରେଲିଆ ସମୟ#,
				'standard' => q#ଅଷ୍ଟ୍ରେଲିୟ ମଧ୍ୟ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#ଅଷ୍ଟ୍ରେଲିୟ ମଧ୍ୟ ପଶ୍ଚିମ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଅଷ୍ଟ୍ରେଲିୟ ମଧ୍ୟ ପଶ୍ଚିମ ସମୟ#,
				'standard' => q#ଅଷ୍ଟ୍ରେଲିୟ ମଧ୍ୟ ପଶ୍ଚିମ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#ଅଷ୍ଟ୍ରେଲିୟ ପୂର୍ବ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ପୂର୍ବ ଅଷ୍ଟ୍ରେଲିଆ ସମୟ#,
				'standard' => q#ଅଷ୍ଟ୍ରେଲିୟ ପୂର୍ବ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#ଅଷ୍ଟ୍ରେଲିୟ ପଶ୍ଚିମ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ପଶ୍ଚିମ ଅଷ୍ଟ୍ରେଲିଆ ସମୟ#,
				'standard' => q#ଅଷ୍ଟ୍ରେଲିୟ ପଶ୍ଚିମ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#ଆଜେରବାଇଜାନ ଖରାଦିନ ସମୟ#,
				'generic' => q#ଆଜେରବାଇଜାନ ସମୟ#,
				'standard' => q#ଆଜେରବାଇଜାନ ମାନଙ୍କ ସମୟ#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ଆଜୋରେସ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଆଜୋରେସ୍ ସମୟ#,
				'standard' => q#ଆଜୋରେସ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#ବାଂଲାଦେଶ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ବାଂଲାଦେଶ ସମୟ#,
				'standard' => q#ବାଂଲାଦେଶ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ଭୁଟାନ ସମୟ#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#ବଲିଭିଆ ସମୟ#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ବ୍ରାସିଲିଆ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ବ୍ରାସିଲିଆ ସମୟ#,
				'standard' => q#ବ୍ରାସିଲିଆ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ବ୍ରୁନେଇ ଡାରୁସାଲାମ ସମୟ#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#କେପ୍‌ ଭର୍ଦେ ଖରାଦିନ ସମୟ#,
				'generic' => q#କେପ୍‌ ଭର୍ଦେ ସମୟ#,
				'standard' => q#କେପ୍‌ ଭର୍ଦେ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#ଚାମୋରୋ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#ଚାଥାମ୍‌ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଚାଥାମ୍‌ ସମୟ#,
				'standard' => q#ଚାଥାମ୍‌ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#ଚିଲି ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଚିଲି ସମୟ#,
				'standard' => q#ଚିଲି ମାନାଙ୍କ ସମୟ#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#ଚୀନ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଚୀନ ସମୟ#,
				'standard' => q#ଚୀନ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#ଚୋଇବାଲସାନ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଚୋଇବାଲସାନ ସମୟ#,
				'standard' => q#ଚୋଇବାଲସାନ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ଖ୍ରୀଷ୍ଟମାସ ଦ୍ୱୀପ ସମୟ#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#କୋକୋସ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#କଲମ୍ବିଆ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#କଲମ୍ବିଆ ସମୟ#,
				'standard' => q#କଲମ୍ବିଆ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ଅର୍ଦ୍ଧ ଗୀଷ୍ମକାଳୀନ ସମୟ#,
				'generic' => q#କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ#,
				'standard' => q#କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#କ୍ୟୁବା ଦିବାଲୋକ ସମୟ#,
				'generic' => q#କ୍ୟୁବା ସମୟ#,
				'standard' => q#କ୍ୟୁବା ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ଡେଭିସ୍‌ ସମୟ#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ଡୁମୋଣ୍ଟ-ଡି‘ଉରଭିଲ୍ଲେ ସମୟ#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#ପୂର୍ବ ତିମୋର୍‌ ସମୟ#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ଇଷ୍ଟର୍‌ ଆଇଲ୍ୟାଣ୍ଡ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଇଷ୍ଟର୍‌ ଆଇଲ୍ୟାଣ୍ଡ ସମୟ#,
				'standard' => q#ଇଷ୍ଟର୍‌ ଆଇଲ୍ୟାଣ୍ଡ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ଇକ୍ୱେଡର ସମୟ#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#ସମନ୍ୱିତ ସାର୍ବଜନୀନ ସମୟ#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#ଅଜଣା ସହର#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ଆମଷ୍ଟ୍ରେଡାମ୍#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ଆନଡୋରା#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#ଆଷ୍ଟ୍ରାଖାନ୍#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ଏଥେନ୍ସ#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ବେଲଗ୍ରେଡେ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ବର୍ଲିନ୍#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ବ୍ରାଟିସଲାଭା#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ବ୍ରସଲ୍ସ୍#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ବୁଚାରେଷ୍ଟ୍#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ବୁଡାପେଷ୍ଟ୍#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ବୁସିନଗେନ୍#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ଚିସିନୌ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#କୋପେନହାଗେନ୍#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ଡବଲିନ୍#,
			long => {
				'daylight' => q#ଆଇରିଶ୍‌ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ଜିବ୍ରାଲଟର୍‌#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ଗୁଏରନସେ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ହେଲସିନକି#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ଇସଲେ ଅଫ୍ ମେନ୍#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ଇସ୍ତାନବୁଲ#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ଜର୍ସି#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#କାଲିନିନଗ୍ରାଡ୍#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#କିଏଭ୍#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#କିରୋଭ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ଲିସବୋନ୍#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ଲଜୁବ୍ଲଜାନ୍#,
		},
		'Europe/London' => {
			exemplarCity => q#ଲଣ୍ଡନ୍#,
			long => {
				'daylight' => q#ବ୍ରିଟିଶ୍‌ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ଲକ୍ସମବର୍ଗ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ମାଡ୍ରିଡ୍#,
		},
		'Europe/Malta' => {
			exemplarCity => q#ମାଲଟା#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ମାରିଏହାମନ୍#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#ମିନସ୍କ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#ମୋନାକୋ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ମସ୍କୋ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ଓସଲୋ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ପେରିସ୍#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ପୋଡଗୋରିକା#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ପ୍ରାଗ୍#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ରିଗା#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ରୋମ୍#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ସାମାରା#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ସାନ୍ ମାରିନୋ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ସାରାଜେଭୋ#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#ସାରାଟୋଭ୍#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ସିମଫେରୋପୋଲ୍#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ସ୍କୋପଜେ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ସୋଫିଆ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ଷ୍ଟକହୋମ୍‌#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ଟାଲିନ୍ନ#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ଟିରାନେ#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#ୟୁଲୟାନୋଭସ୍କ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ଉଜହୋରୋଦ୍#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ଭାଡୁଜ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ଭାଟିକାନ୍#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ଭିଏନା#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ଭିଲନିଉସ୍#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ଭୋଲଗୋଗ୍ରାଡ୍#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ୱାରସୱା#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ଜାଗ୍ରେବ୍#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ଜାପୋରୋଜହୟେ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ଜୁରିକ୍#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#କେନ୍ଦ୍ରୀୟ ୟୁରୋପୀୟ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#କେନ୍ଦ୍ରୀୟ ୟୁରୋପୀୟ ସମୟ#,
				'standard' => q#କେନ୍ଦ୍ରୀୟ ୟୁରୋପୀୟ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#ପୂର୍ବାଞ୍ଚଳ ୟୁରୋପୀୟ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ପୂର୍ବାଞ୍ଚଳ ୟୁରୋପୀୟ ସମୟ#,
				'standard' => q#ପୂର୍ବାଞ୍ଚଳ ୟୁରୋପୀୟ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#ପରବର୍ତ୍ତୀ-ପୂର୍ବାଞ୍ଚଳ ୟୁରୋପୀୟ ସମୟ#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#ପଶ୍ଚିମାଞ୍ଚଳ ୟୁରୋପୀୟ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ପଶ୍ଚିମାଞ୍ଚଳ ୟୁରୋପୀୟ ସମୟ#,
				'standard' => q#ପଶ୍ଚିମାଞ୍ଚଳ ୟୁରୋପୀୟ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ଫକଲ୍ୟାଣ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଫକଲ୍ୟାଣ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ#,
				'standard' => q#ଫକଲ୍ୟାଣ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ଫିଜି ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଫିଜି ସମୟ#,
				'standard' => q#ଫିଜି ମାନାଙ୍କ ସମୟ#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ଫ୍ରେଞ୍ଚ ଗୁଆନା ସମୟ#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ଫ୍ରେଞ୍ଚ ଦକ୍ଷିଣ ଏବଂ ଆଣ୍ଟାର୍କାଟିକ୍‌ ସମୟ#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#ଗାଲାପାଗୋସ୍ ସମୟ#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#ଗାମ୍ବିୟର୍ ସମୟ#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#ଜର୍ଜିଆ ଖରାଦିନ ସମୟ#,
				'generic' => q#ଜର୍ଜିଆ ସମୟ#,
				'standard' => q#ଜର୍ଜିଆ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#ଗିଲବର୍ଟ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#ପୂର୍ବ ଗ୍ରୀନଲ୍ୟାଣ୍ଡ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ପୂର୍ବ ଗ୍ରୀନଲ୍ୟାଣ୍ଡ୍ ସମୟ#,
				'standard' => q#ପୂର୍ବ ଗ୍ରୀନଲ୍ୟାଣ୍ଡ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#ପଶ୍ଚିମ ଗ୍ରୀନଲ୍ୟାଣ୍ଡ୍ ଗ୍ରୀଷ୍ମ ସମୟ#,
				'generic' => q#ପଶ୍ଚିମ ଗ୍ରୀନଲ୍ୟାଣ୍ଡ୍ ସମୟ#,
				'standard' => q#ପଶ୍ଚିମ ଗ୍ରୀନଲ୍ୟାଣ୍ଡ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#ଗଲ୍ଫ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#ଗୁଏନା ସମୟ#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ହୱାଇ-ଆଲେଉଟିୟ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ହୱାଇ-ଆଲେଉଟିୟ ସମୟ#,
				'standard' => q#ହୱାଇ-ଆଲେଉଟିୟ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#ହଂ କଂ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ହଂ କଂ ସମୟ#,
				'standard' => q#ହଂ କଂ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ହୋଭଡ୍‌ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ହୋଭଡ୍‌ ସମୟ#,
				'standard' => q#ହୋଭଡ୍‌ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ଭାରତ ମାନାଙ୍କ ସମୟ#,
			},
			short => {
				'standard' => q#IST#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ଆଣ୍ଟାନାନାରିଭୋ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ଚାଗୋସ୍‌#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ଖ୍ରୀଷ୍ଟମାସ#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#କୋକୋସ୍‌#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#କୋମୋରୋ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#କେରୁଗେଲେନ#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ମାହେ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#ମାଳଦ୍ୱୀପ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ମୌରିସସ୍#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#ମାୟୋଟେ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ରିୟୁନିଅନ୍‌#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ଭାରତ ମାହାସାଗର ସମୟ#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ଇଣ୍ଡୋଚାଇନା ସମୟ#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#ମଧ୍ୟ ଇଣ୍ଡୋନେସିଆ ସମୟ#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#ପୂର୍ବ ଇଣ୍ଡୋନେସିଆ ସମୟ#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#ପଶ୍ଚିମ ଇଣ୍ଡୋନେସିଆ ସମୟ#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ଇରାନ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଇରାନ ସମୟ#,
				'standard' => q#ଇରାନ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ଇର୍କୁଟସ୍କ୍ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ#,
				'generic' => q#ଇଅରକୁଟସ୍କ ସମୟ#,
				'standard' => q#ଇଅରକୁଟସ୍କ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ଇସ୍ରାଏଲ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଇସ୍ରାଏଲ ସମୟ#,
				'standard' => q#ଇସ୍ରାଏଲ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#ଜାପାନ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଜାପାନ ସମୟ#,
				'standard' => q#ଜାପାନ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#ପୂର୍ବ କାଜାକସ୍ତାନ୍ ସମୟ#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#ପଶ୍ଚିମ କାଜାକସ୍ତାନ ସମୟ#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#କୋରିୟ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#କୋରିୟ ସମୟ#,
				'standard' => q#କୋରିୟ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#କୋସରେଇ ସମୟ#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#କ୍ରାସନୋୟାରସ୍କ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#କ୍ରାସନୋୟାରସ୍କ ସମୟ#,
				'standard' => q#କ୍ରାସନୋୟାରସ୍କ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#କିର୍ଗିସ୍ତାନ ସମୟ#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#ଲାଇନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#ଲର୍ଡ ହୋୱେ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଲର୍ଡ ହୋୱେ ସମୟ#,
				'standard' => q#ଲର୍ଡ ହୋୱେ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#ମାକ୍ୱେରୀ ଦ୍ୱୀପ ସମୟ#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#ମାଗାଡାନ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ମାଗାଡାନ୍ ସମୟ#,
				'standard' => q#ମାଗାଡାନ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#ମାଲେସିଆ ସମୟ#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#ମାଳଦ୍ୱୀପ ସମୟ#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#ମାର୍କ୍ୱେସାସ୍‌ ସମୟ#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#ମାର୍ଶାଲ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#ମୌରିସସ୍‌ ଖରାଦିନ ସମୟ#,
				'generic' => q#ମୌରିସସ୍‌ ସମୟ#,
				'standard' => q#ମୌରିସସ୍‌ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#ମାୱସନ୍‌ ସମୟ#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#ଉତ୍ତରପଶ୍ଚିମ ମେକ୍ସିକୋ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ଉତ୍ତରପଶ୍ଚିମ ମେକ୍ସିକୋ ସମୟ#,
				'standard' => q#ଉତ୍ତରପଶ୍ଚିମ ମେକ୍ସିକୋ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#ମେକ୍ସିକାନ୍ ପାସିଫିକ୍ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ମେକ୍ସିକାନ୍ ପାସିଫିକ୍ ସମୟ#,
				'standard' => q#ମେକ୍ସିକାନ୍ ପାସିଫିକ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ଉଲାନ୍‌ ବାଟର୍‌ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଉଲାନ୍‌ବାଟର୍‌ ସମୟ#,
				'standard' => q#ଉଲାନ୍‌ବାଟର୍‌ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ମସ୍କୋ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ମସ୍କୋ ସମୟ#,
				'standard' => q#ମସ୍କୋ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#ମିଆଁମାର୍‌ ସମୟ#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ନାଉରୁ ସମୟ#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#ନେପାଳ ସମୟ#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#ନ୍ୟୁ କାଲେଡୋନିଆ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ନ୍ୟୁ କାଲେଡୋନିଆ ସମୟ#,
				'standard' => q#ନ୍ୟୁ କାଲେଡୋନିଆ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#ନ୍ୟୁଜିଲାଣ୍ଡ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ନ୍ୟୁଜିଲାଣ୍ଡ ସମୟ#,
				'standard' => q#ନ୍ୟୁଜିଲାଣ୍ଡ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#ନ୍ୟୁଫାଉଣ୍ଡଲ୍ୟାଣ୍ଡ୍ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ନ୍ୟୁଫାଉଣ୍ଡଲ୍ୟାଣ୍ଡ୍ ସମୟ#,
				'standard' => q#ନ୍ୟୁଫାଉଣ୍ଡଲ୍ୟାଣ୍ଡ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#ନିୟୁ ସମୟ#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#ନରଫୋକ୍‌ ଦ୍ୱୀପ ସମୟ#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ଫର୍ଣ୍ଣାଣ୍ଡୋ ଡି ନୋରୋନ୍ନା ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଫର୍ଣ୍ଣାଣ୍ଡୋ ଡି ନୋରୋନ୍ନା ସମୟ#,
				'standard' => q#ଫର୍ଣ୍ଣାଣ୍ଡୋ ଡି ନୋରୋନ୍ନା ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#ନୋଭୋସିବିରସ୍କ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ନୋଭୋସିବିରସ୍କ ସମୟ#,
				'standard' => q#ନୋଭୋସିବିରସ୍କ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ଓମସ୍କ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଓମସ୍କ ସମୟ#,
				'standard' => q#ଓମସ୍କ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ଆପିଆ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ଅକଲାଣ୍ଡ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ବୌଗେନ୍‌ଭିଲ୍ଲେ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ଚାଥାମ୍‌#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ଇଷ୍ଟର୍‌#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ଇଫେଟ୍‌#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ଏଣ୍ଡେରବୁରି#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ଫାକାଓଫୋ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ଫିଜି#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ଫୁନାଫୁଟି#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ଗାଲାପାଗୋସ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ଗାମ୍ବିୟର୍‌#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ଗୁଆଡାଲକାନାଲ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ଗୁଆମ#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ହୋନୋଲୁଲୁ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ଜନଷ୍ଟନ୍#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#କିରିତିମାଟି#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#କୋସରେଇ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#କ୍ୱାଜାଲେଇନ୍#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ମାଜୁରୋ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#ମାର୍କ୍ୱେସାସ୍‌#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ମିଡ୍‌ୱେ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ନାଉରୁ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ନିୟୂ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ନରଫୋକ୍‌#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ନୌମିୟ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ପାଗୋ ପାଗୋ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ପାଲାଉ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ପିଟକାରିନ୍‌#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ପୋହନପେଇ#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ପୋର୍ଟ୍‌ ମୋରେସବି#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ରାରୋଟୋଙ୍ଗା#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ସାଇପାନ୍#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ତାହିତି#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ତାରୱା#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ଟୋଙ୍ଗାଟାପୁ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ଚୂକ୍‌#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ୱେକ୍#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ୱାଲିସ୍‌#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#ପାକିସ୍ତାନ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ପାକିସ୍ତାନ ସମୟ#,
				'standard' => q#ପାକିସ୍ତାନ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#ପାଲାଉ ସମୟ#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#ପପୁଆ ନ୍ୟୁ ଗୁନିଆ ସମୟ#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#ପାରାଗୁଏ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ପାରାଗୁଏ ସମୟ#,
				'standard' => q#ପାରାଗୁଏ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#ପେରୁ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ପେରୁ ସମୟ#,
				'standard' => q#ପେରୁ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#ଫିଲିପାଇନ୍‌ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଫିଲିପାଇନ୍‌ ସମୟ#,
				'standard' => q#ଫିଲିପାଇନ୍‌ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ଫୋନିକ୍ସ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#ସେଣ୍ଟ. ପିଏରେ ଏବଂ ମିକ୍ୟୁଲୋନ୍ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ସେଣ୍ଟ. ପିଏରେ ଏବଂ ମିକ୍ୟୁଲୋନ୍ ସମୟ#,
				'standard' => q#ସେଣ୍ଟ. ପିଏରେ ଏବଂ ମିକ୍ୟୁଲୋନ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#ପିଟକାରିନ୍‌ ସମୟ#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#ପୋନାପେ ସମୟ#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#ପୋୟଙ୍ଗୟାଙ୍ଗ ସମୟ#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ରିୟୁନିଅନ୍‌ ସମୟ#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#ରୋଥେରା ସମୟ#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#ସଖାଲିନ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ସଖାଲିନ୍ ସମୟ#,
				'standard' => q#ସଖାଲିନ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ସାମୋଆ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ସାମୋଆ ସମୟ#,
				'standard' => q#ସାମୋଆ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#ସେଚେଲ୍ଲେସ୍‌ ସମୟ#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#ସିଙ୍ଗାପୁର୍‌ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#ସୋଲୋମନ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#ଦକ୍ଷିଣ ଜର୍ଜିଆ ସମୟ#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#ସୁରିନେମ୍‌ ସମୟ#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#ସୋୱା ସମୟ#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ତାହିତି ସମୟ#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ତାଇପେଇ ଦିବାଲୋକ ସମୟ#,
				'generic' => q#ତାଇପେଇ ସମୟ#,
				'standard' => q#ତାଇପେଇ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ତାଜିକିସ୍ତାନ ସମୟ#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ଟୋକେଲାଉ ସମୟ#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ଟୋଙ୍ଗା ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଟୋଙ୍ଗା ସମୟ#,
				'standard' => q#ଟୋଙ୍ଗା ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#ଚୂକ୍‌ ସମୟ#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ତୁର୍କମେନିସ୍ତାନ ଖରାଦିନ ସମୟ#,
				'generic' => q#ତୁର୍କମେନିସ୍ତାନ ସମୟ#,
				'standard' => q#ତୁର୍କମେନିସ୍ତାନ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ତୁଭାଲୁ ସମୟ#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ଉରୁଗୁଏ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଉରୁଗୁଏ ସମୟ#,
				'standard' => q#ଉରୁଗୁଏ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ଉଜବେକିସ୍ତାନ ଖରାଦିନ ସମୟ#,
				'generic' => q#ଉଜବେକିସ୍ତାନ ସମୟ#,
				'standard' => q#ଉଜବେକିସ୍ତାନ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ଭାନୁଆଟୁ ଖରାଦିନ ସମୟ#,
				'generic' => q#ଭାନୁଆଟୁ ସମୟ#,
				'standard' => q#ଭାନୁଆଟୁ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ଭେନିଜୁଏଲା ସମୟ#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ଭ୍ଲାଡିଭୋଷ୍ଟୋକ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଭ୍ଲାଡିଭୋଷ୍ଟୋକ୍ ସମୟ#,
				'standard' => q#ଭ୍ଲାଡିଭୋଷ୍ଟୋକ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ଭୋଲଗୋଗ୍ରାଡ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ଭୋଲଗୋଗ୍ରାଡ୍ ସମୟ#,
				'standard' => q#ଭୋଲଗୋଗ୍ରାଡ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ଭୋଷ୍ଟୋକ୍‌ ସମୟ#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ୱେକ୍‌ ଦ୍ୱୀପ ସମୟ#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ୱାଲିସ୍‌ ଏବଂ ଫୁଟୁନା ସମୟ#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ୟାକୁଟସ୍କ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ୟାକୁଟସ୍କ ସମୟ#,
				'standard' => q#ୟାକୁଟସ୍କ ମାନାଙ୍କ ସମୟ#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#ୟେକାଟେରିନବର୍ଗ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ#,
				'generic' => q#ୟେକାଟେରିନବର୍ଗ୍ ସମୟ#,
				'standard' => q#ୟେକାଟେରିନବର୍ଗ୍ ମାନାଙ୍କ ସମୟ#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
