use strict;

mkdir('lc', 0777);

my @c = (
    (map {chr($_)} (0x20..0x7E, 0xA1..0xDF)),
);

my $script = "lc\\lc.pl";
open(SCRIPT,">$script") || die "Can't open file: $script\n";

#----------------------------------------------------------------------------
# lc
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print lc;\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print lc;\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print lc;\n";
    }
}

#----------------------------------------------------------------------------
# lc $_
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print lc \$_;\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print lc \$_;\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print lc \$_;\n";
    }
}

#----------------------------------------------------------------------------
# lc($_)
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print lc(\$_);\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print lc(\$_);\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print lc(\$_);\n";
    }
}

#----------------------------------------------------------------------------
# lc $_, 'A', 'B', 'C'
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print lc \$_, 'A', 'B', 'C';\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print lc \$_, 'A', 'B', 'C';\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print lc \$_, 'A', 'B', 'C';\n";
    }
}

#----------------------------------------------------------------------------
# lc '*'
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "print lc '\\", $c, "';\n";
    }
    else {
        print SCRIPT "print lc '", $c, "';\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "print lc '", chr($c1), chr($c2), "';\n";
    }
}

#----------------------------------------------------------------------------
# lc('*')
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "print lc('\\", $c, "');\n";
    }
    else {
        print SCRIPT "print lc('", $c, "');\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "print lc('", chr($c1), chr($c2), "');\n";
    }
}

#----------------------------------------------------------------------------
# lc '*', 'A', 'B', 'C'
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "print lc '\\", $c, "', 'A', 'B', 'C';\n";
    }
    else {
        print SCRIPT "print lc '", $c, "', 'A', 'B', 'C';\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "print lc '", chr($c1), chr($c2), "', 'A', 'B', 'C';\n";
    }
}

close(SCRIPT);

#----------------------------------------------------------------------------
