
use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "RESTful web application framework based on Plack",
  "AUTHOR" => "Ido Perlmuter <ido\@ido50.net>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Leyland",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Leyland",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Data::Dumper" => 0,
    "Devel::Declare::Interface" => 0,
    "Devel::Declare::Parser" => 0,
    "Encode" => 0,
    "Exporter::Declare::Magic" => "0.107",
    "JSON" => 0,
    "Locale::Wolowitz" => 0,
    "Module::Load" => 0,
    "Moo" => 0,
    "Moo::Role" => 0,
    "Plack::Component" => 0,
    "Plack::Request" => 0,
    "Scalar::Util" => 0,
    "Tenjin" => "0.070001",
    "Text::SpanningTable" => 0,
    "Throwable" => 0,
    "Tie::IxHash" => 0,
    "Try::Tiny" => 0,
    "XML::TreePP" => 0,
    "base" => 0,
    "namespace::clean" => 0,
    "parent" => 0,
    "strict" => 0,
    "version" => "0.77",
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "HTTP::Request::Common" => 0,
    "Plack::Test" => 0,
    "Test::More" => 0,
    "lib" => 0
  },
  "VERSION" => "1.000000",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Carp" => 0,
  "Data::Dumper" => 0,
  "Devel::Declare::Interface" => 0,
  "Devel::Declare::Parser" => 0,
  "Encode" => 0,
  "Exporter::Declare::Magic" => "0.107",
  "HTTP::Request::Common" => 0,
  "JSON" => 0,
  "Locale::Wolowitz" => 0,
  "Module::Load" => 0,
  "Moo" => 0,
  "Moo::Role" => 0,
  "Plack::Component" => 0,
  "Plack::Request" => 0,
  "Plack::Test" => 0,
  "Scalar::Util" => 0,
  "Tenjin" => "0.070001",
  "Test::More" => 0,
  "Text::SpanningTable" => 0,
  "Throwable" => 0,
  "Tie::IxHash" => 0,
  "Try::Tiny" => 0,
  "XML::TreePP" => 0,
  "base" => 0,
  "lib" => 0,
  "namespace::clean" => 0,
  "parent" => 0,
  "strict" => 0,
  "version" => "0.77",
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



