#!/usr/bin/perl -w
#package nodefield1_06
use Test::More no_plan;
use strict;

BEGIN {
	$| = 1;
	chdir 't' if -d 't';
	unshift @INC, '../lib';
	use_ok 'X3D';
	use_ok 'TestNodeFields';
}

ok my $testNode = new TestNode;

ok !tied ${ tied $testNode->getFields->getTiedField('mfbool') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfcolor') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfcolorrgba') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfdouble') };
ok !tied ${ tied $testNode->getFields->getTiedField('mffloat') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfimage') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfint32') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfnode') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfrotation') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfstring') };
ok !tied ${ tied $testNode->getFields->getTiedField('mftime') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfvec2d') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfvec2f') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfvec3d') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfvec3f') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfvec4d') };
ok !tied ${ tied $testNode->getFields->getTiedField('mfvec4f') };

ok !tied ${ tied $testNode->getFields->getTiedField('sfbool') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfcolor') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfcolorrgba') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfdouble') };
ok !tied ${ tied $testNode->getFields->getTiedField('sffloat') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfimage') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfint32') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfnode') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfrotation') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfstring') };
ok !tied ${ tied $testNode->getFields->getTiedField('sftime') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfvec2d') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfvec2f') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfvec3d') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfvec3f') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfvec4d') };
ok !tied ${ tied $testNode->getFields->getTiedField('sfvec4f') };

isa_ok ${ tied $testNode->getFields->getTiedField('mfbool') }, 	  'MFBool';
isa_ok ${ tied $testNode->getFields->getTiedField('mfcolor') },	  'MFColor';
isa_ok ${ tied $testNode->getFields->getTiedField('mfcolorrgba') }, 'MFColorRGBA';
isa_ok ${ tied $testNode->getFields->getTiedField('mfdouble') },    'MFDouble';
isa_ok ${ tied $testNode->getFields->getTiedField('mffloat') },	  'MFFloat';
isa_ok ${ tied $testNode->getFields->getTiedField('mfimage') },	  'MFImage';
isa_ok ${ tied $testNode->getFields->getTiedField('mfint32') },	  'MFInt32';
isa_ok ${ tied $testNode->getFields->getTiedField('mfnode') }, 	  'MFNode';
isa_ok ${ tied $testNode->getFields->getTiedField('mfrotation') },  'MFRotation';
isa_ok ${ tied $testNode->getFields->getTiedField('mfbool') }, 	  'MFBool';
isa_ok ${ tied $testNode->getFields->getTiedField('mfcolor') },	  'MFColor';
isa_ok ${ tied $testNode->getFields->getTiedField('mfcolorrgba') }, 'MFColorRGBA';
isa_ok ${ tied $testNode->getFields->getTiedField('mfdouble') },    'MFDouble';
isa_ok ${ tied $testNode->getFields->getTiedField('mffloat') },	  'MFFloat';
isa_ok ${ tied $testNode->getFields->getTiedField('mfimage') },	  'MFImage';
isa_ok ${ tied $testNode->getFields->getTiedField('mfint32') },	  'MFInt32';
isa_ok ${ tied $testNode->getFields->getTiedField('mfnode') }, 	  'MFNode';
isa_ok ${ tied $testNode->getFields->getTiedField('mfrotation') },  'MFRotation';
isa_ok ${ tied $testNode->getFields->getTiedField('mfstring') },    'MFString';
isa_ok ${ tied $testNode->getFields->getTiedField('mftime') }, 	  'MFTime';
isa_ok ${ tied $testNode->getFields->getTiedField('mfvec2d') },	  'MFVec2d';
isa_ok ${ tied $testNode->getFields->getTiedField('mfvec2f') },	  'MFVec2f';
isa_ok ${ tied $testNode->getFields->getTiedField('mfvec3d') },	  'MFVec3d';
isa_ok ${ tied $testNode->getFields->getTiedField('mfvec3f') },	  'MFVec3f';
isa_ok ${ tied $testNode->getFields->getTiedField('mfvec4d') },	  'MFVec4d';
isa_ok ${ tied $testNode->getFields->getTiedField('mfvec4f') },	  'MFVec4f';

isa_ok ${ tied $testNode->getFields->getTiedField('sfbool') }, 	  'SFBool';
isa_ok ${ tied $testNode->getFields->getTiedField('sfcolor') },	  'SFColor';
isa_ok ${ tied $testNode->getFields->getTiedField('sfcolorrgba') }, 'SFColorRGBA';
isa_ok ${ tied $testNode->getFields->getTiedField('sfdouble') },    'SFDouble';
isa_ok ${ tied $testNode->getFields->getTiedField('sffloat') },	  'SFFloat';
isa_ok ${ tied $testNode->getFields->getTiedField('sfimage') },	  'SFImage';
isa_ok ${ tied $testNode->getFields->getTiedField('sfint32') },	  'SFInt32';
isa_ok ${ tied $testNode->getFields->getTiedField('sfnode') }, 	  'SFNode';
isa_ok ${ tied $testNode->getFields->getTiedField('sfrotation') },  'SFRotation';
isa_ok ${ tied $testNode->getFields->getTiedField('sfstring') },    'SFString';
isa_ok ${ tied $testNode->getFields->getTiedField('sftime') }, 	  'SFTime';
isa_ok ${ tied $testNode->getFields->getTiedField('sfvec2d') },	  'SFVec2d';
isa_ok ${ tied $testNode->getFields->getTiedField('sfvec2f') },	  'SFVec2f';
isa_ok ${ tied $testNode->getFields->getTiedField('sfvec3d') },	  'SFVec3d';
isa_ok ${ tied $testNode->getFields->getTiedField('sfvec3f') },	  'SFVec3f';
isa_ok ${ tied $testNode->getFields->getTiedField('mfstring') },    'MFString';
isa_ok ${ tied $testNode->getFields->getTiedField('mftime') }, 	  'MFTime';
isa_ok ${ tied $testNode->getFields->getTiedField('mfvec2d') },	  'MFVec2d';
isa_ok ${ tied $testNode->getFields->getTiedField('mfvec2f') },	  'MFVec2f';
isa_ok ${ tied $testNode->getFields->getTiedField('mfvec3d') },	  'MFVec3d';
isa_ok ${ tied $testNode->getFields->getTiedField('mfvec3f') },	  'MFVec3f';
isa_ok ${ tied $testNode->getFields->getTiedField('sfbool') }, 	  'SFBool';
isa_ok ${ tied $testNode->getFields->getTiedField('sfcolor') },	  'SFColor';
isa_ok ${ tied $testNode->getFields->getTiedField('sfcolorrgba') }, 'SFColorRGBA';
isa_ok ${ tied $testNode->getFields->getTiedField('sfdouble') },    'SFDouble';
isa_ok ${ tied $testNode->getFields->getTiedField('sffloat') },	  'SFFloat';
isa_ok ${ tied $testNode->getFields->getTiedField('sfimage') },	  'SFImage';
isa_ok ${ tied $testNode->getFields->getTiedField('sfint32') },	  'SFInt32';
isa_ok ${ tied $testNode->getFields->getTiedField('sfnode') }, 	  'SFNode';
isa_ok ${ tied $testNode->getFields->getTiedField('sfrotation') },  'SFRotation';
isa_ok ${ tied $testNode->getFields->getTiedField('sfstring') },    'SFString';
isa_ok ${ tied $testNode->getFields->getTiedField('sftime') }, 	  'SFTime';
isa_ok ${ tied $testNode->getFields->getTiedField('sfvec2d') },	  'SFVec2d';
isa_ok ${ tied $testNode->getFields->getTiedField('sfvec2f') },	  'SFVec2f';
isa_ok ${ tied $testNode->getFields->getTiedField('sfvec3d') },	  'SFVec3d';
isa_ok ${ tied $testNode->getFields->getTiedField('sfvec3f') },	  'SFVec3f';
isa_ok ${ tied $testNode->getFields->getTiedField('sfvec4d') },	  'SFVec4d';
isa_ok ${ tied $testNode->getFields->getTiedField('sfvec4f') },	  'SFVec4f';

isa_ok tied $testNode->getFields->getTiedField('mfbool'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfcolor'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfcolorrgba'), 'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfdouble'), 	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mffloat'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfimage'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfint32'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfnode'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfrotation'),  'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfstring'), 	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mftime'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfvec2d'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfvec2f'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfvec3d'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfvec3f'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfbool'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfcolor'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfcolorrgba'), 'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfdouble'), 	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sffloat'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfimage'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfint32'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfnode'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfrotation'),  'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfstring'), 	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sftime'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec2d'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec2f'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec3d'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec3f'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec4d'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec4f'),  	'X3D::Tie::Field';

isa_ok tied $testNode->getFields->getTiedField('mfbool'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfcolor'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfcolorrgba'), 'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfdouble'), 	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mffloat'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfimage'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfint32'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfnode'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfrotation'),  'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfstring'), 	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mftime'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfvec2d'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfvec2f'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfvec3d'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('mfvec3f'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfbool'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfcolor'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfcolorrgba'), 'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfdouble'), 	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sffloat'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfimage'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfint32'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfnode'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfrotation'),  'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfstring'), 	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sftime'),		'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec2d'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec2f'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec3d'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec3f'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec4d'),  	'X3D::Tie::Field';
isa_ok tied $testNode->getFields->getTiedField('sfvec4f'),  	'X3D::Tie::Field';

#ok tied $X3D->getValue->getFields->getTiedField('metadata');
ok tied $testNode->getFields->getTiedField('mfbool');
ok tied $testNode->getFields->getTiedField('mfcolor');
ok tied $testNode->getFields->getTiedField('mfcolorrgba');
ok tied $testNode->getFields->getTiedField('mfdouble');
ok tied $testNode->getFields->getTiedField('mffloat');
ok tied $testNode->getFields->getTiedField('mfimage');
ok tied $testNode->getFields->getTiedField('mfint32');
ok tied $testNode->getFields->getTiedField('mfnode');
ok tied $testNode->getFields->getTiedField('mfrotation');
ok tied $testNode->getFields->getTiedField('mfstring');
ok tied $testNode->getFields->getTiedField('mftime');
ok tied $testNode->getFields->getTiedField('mfvec2d');
ok tied $testNode->getFields->getTiedField('mfvec2f');
ok tied $testNode->getFields->getTiedField('mfvec3d');
ok tied $testNode->getFields->getTiedField('mfvec3f');
ok tied $testNode->getFields->getTiedField('mfvec4d');
ok tied $testNode->getFields->getTiedField('mfvec4f');

ok tied $testNode->getFields->getTiedField('sfbool');
ok tied $testNode->getFields->getTiedField('sfcolor');
ok tied $testNode->getFields->getTiedField('sfcolorrgba');
ok tied $testNode->getFields->getTiedField('sfdouble');
ok tied $testNode->getFields->getTiedField('sffloat');
ok tied $testNode->getFields->getTiedField('sfimage');
ok tied $testNode->getFields->getTiedField('sfint32');
ok tied $testNode->getFields->getTiedField('sfnode');
ok tied $testNode->getFields->getTiedField('sfrotation');
ok tied $testNode->getFields->getTiedField('sfstring');
ok tied $testNode->getFields->getTiedField('sftime');
ok tied $testNode->getFields->getTiedField('sfvec2d');
ok tied $testNode->getFields->getTiedField('sfvec2f');
ok tied $testNode->getFields->getTiedField('sfvec3d');
ok tied $testNode->getFields->getTiedField('sfvec3f');
ok tied $testNode->getFields->getTiedField('sfvec4d');
ok tied $testNode->getFields->getTiedField('sfvec4f');

#is ref $X3D->getValue->getField('metadata'), 'SFNode';
is ref $testNode->getField('mfbool'),  	 'MFBool';
is ref $testNode->getField('mfcolor'), 	 'MFColor';
is ref $testNode->getField('mfcolorrgba'), 'MFColorRGBA';
is ref $testNode->getField('mfdouble'),	 'MFDouble';
is ref $testNode->getField('mffloat'), 	 'MFFloat';
is ref $testNode->getField('mfimage'), 	 'MFImage';
is ref $testNode->getField('mfint32'), 	 'MFInt32';
is ref $testNode->getField('mfnode'),  	 'MFNode';
is ref $testNode->getField('mfrotation'),  'MFRotation';
is ref $testNode->getField('mfstring'),	 'MFString';
is ref $testNode->getField('mftime'),  	 'MFTime';
is ref $testNode->getField('mfvec2d'), 	 'MFVec2d';
is ref $testNode->getField('mfvec2f'), 	 'MFVec2f';
is ref $testNode->getField('mfvec3d'), 	 'MFVec3d';
is ref $testNode->getField('mfvec3f'), 	 'MFVec3f';
is ref $testNode->getField('mfvec4d'), 	 'MFVec4d';
is ref $testNode->getField('mfvec4f'), 	 'MFVec4f';

is ref $testNode->getField('sfbool'),  	 'SFBool';
is ref $testNode->getField('sfcolor'), 	 'SFColor';
is ref $testNode->getField('sfcolorrgba'), 'SFColorRGBA';
is ref $testNode->getField('sfdouble'),	 'SFDouble';
is ref $testNode->getField('sffloat'), 	 'SFFloat';
is ref $testNode->getField('sfimage'), 	 'SFImage';
is ref $testNode->getField('sfint32'), 	 'SFInt32';
is ref $testNode->getField('sfnode'),  	 'SFNode';
is ref $testNode->getField('sfrotation'),  'SFRotation';
is ref $testNode->getField('sfstring'),	 'SFString';
is ref $testNode->getField('sftime'),  	 'SFTime';
is ref $testNode->getField('sfvec2d'), 	 'SFVec2d';
is ref $testNode->getField('sfvec2f'), 	 'SFVec2f';
is ref $testNode->getField('sfvec3d'), 	 'SFVec3d';
is ref $testNode->getField('sfvec3f'), 	 'SFVec3f';
is ref $testNode->getField('sfvec4d'), 	 'SFVec4d';
is ref $testNode->getField('sfvec4f'), 	 'SFVec4f';

isa_ok $testNode->getField('mfbool'),  	 'MFBool';
isa_ok $testNode->getField('mfcolor'), 	 'MFColor';
isa_ok $testNode->getField('mfcolorrgba'), 'MFColorRGBA';
isa_ok $testNode->getField('mfdouble'),	 'MFDouble';
isa_ok $testNode->getField('mffloat'), 	 'MFFloat';
isa_ok $testNode->getField('mfimage'), 	 'MFImage';
isa_ok $testNode->getField('mfint32'), 	 'MFInt32';
isa_ok $testNode->getField('mfnode'),  	 'MFNode';
isa_ok $testNode->getField('mfrotation'),  'MFRotation';
isa_ok $testNode->getField('mfstring'),	 'MFString';
isa_ok $testNode->getField('mftime'),  	 'MFTime';
isa_ok $testNode->getField('mfvec2d'), 	 'MFVec2d';
isa_ok $testNode->getField('mfvec2f'), 	 'MFVec2f';
isa_ok $testNode->getField('mfvec3d'), 	 'MFVec3d';
isa_ok $testNode->getField('mfvec3f'), 	 'MFVec3f';
isa_ok $testNode->getField('mfvec4d'), 	 'MFVec4d';
isa_ok $testNode->getField('mfvec4f'), 	 'MFVec4f';

isa_ok $testNode->getField('sfbool'),  	 'SFBool';
isa_ok $testNode->getField('sfcolor'), 	 'SFColor';
isa_ok $testNode->getField('sfcolorrgba'), 'SFColorRGBA';
isa_ok $testNode->getField('sfdouble'),	 'SFDouble';
isa_ok $testNode->getField('sffloat'), 	 'SFFloat';
isa_ok $testNode->getField('sfimage'), 	 'SFImage';
isa_ok $testNode->getField('sfint32'), 	 'SFInt32';
isa_ok $testNode->getField('sfnode'),  	 'SFNode';
isa_ok $testNode->getField('sfrotation'),  'SFRotation';
isa_ok $testNode->getField('sfstring'),	 'SFString';
isa_ok $testNode->getField('sftime'),  	 'SFTime';
isa_ok $testNode->getField('sfvec2d'), 	 'SFVec2d';
isa_ok $testNode->getField('sfvec2f'), 	 'SFVec2f';
isa_ok $testNode->getField('sfvec3d'), 	 'SFVec3d';
isa_ok $testNode->getField('sfvec3f'), 	 'SFVec3f';
isa_ok $testNode->getField('sfvec4d'), 	 'SFVec4d';
isa_ok $testNode->getField('sfvec4f'), 	 'SFVec4f';

#is ref $X3D->metadata, 'SFNode';
is ref $testNode->mfbool,      'X3DArray';
is ref $testNode->mfcolor,     'X3DArray';
is ref $testNode->mfcolorrgba, 'X3DArray';
is ref $testNode->mfdouble,    'X3DArray';
is ref $testNode->mffloat,     'X3DArray';
is ref $testNode->mfimage,     'X3DArray';
is ref $testNode->mfint32,     'X3DArray';
is ref $testNode->mfnode,      'X3DArray';
is ref $testNode->mfrotation,  'X3DArray';
is ref $testNode->mfstring,    'X3DArray';
is ref $testNode->mftime,      'X3DArray';
is ref $testNode->mfvec2d,     'X3DArray';
is ref $testNode->mfvec2f,     'X3DArray';
is ref $testNode->mfvec3d,     'X3DArray';
is ref $testNode->mfvec3f,     'X3DArray';
is ref $testNode->mfvec4d,     'X3DArray';
is ref $testNode->mfvec4f,     'X3DArray';

is ref $testNode->sfbool->getValue, '';
isa_ok $testNode->sfcolor->getValue,     'X3DColor';
isa_ok $testNode->sfcolorrgba->getValue, 'X3DColorRGBA';
is ref $testNode->sfdouble->getValue, '';
is ref $testNode->sffloat->getValue,  '';
isa_ok $testNode->sfimage->getValue, 'X3DImage';
is ref $testNode->sfint32->getValue, '';
is $testNode->sfnode->getValue,         undef;
isa_ok $testNode->sfrotation->getValue, 'X3DRotation';
is ref $testNode->sfstring->getValue, '';
is ref $testNode->sftime->getValue,   '';
isa_ok $testNode->sfvec2d->getValue, 'X3DVec2';
isa_ok $testNode->sfvec2f->getValue, 'X3DVec2';
isa_ok $testNode->sfvec3d->getValue, 'X3DVec3';
isa_ok $testNode->sfvec3f->getValue, 'X3DVec3';
isa_ok $testNode->sfvec4d->getValue, 'X3DVec4';
isa_ok $testNode->sfvec4f->getValue, 'X3DVec4';

is $testNode->mfbool->getType,      'MFBool';
is $testNode->mfcolor->getType,     'MFColor';
is $testNode->mfcolorrgba->getType, 'MFColorRGBA';
is $testNode->mfdouble->getType,    'MFDouble';
is $testNode->mffloat->getType,     'MFFloat';
is $testNode->mfimage->getType,     'MFImage';
is $testNode->mfint32->getType,     'MFInt32';
is $testNode->mfnode->getType,      'MFNode';
is $testNode->mfrotation->getType,  'MFRotation';
is $testNode->mfstring->getType,    'MFString';
is $testNode->mftime->getType,      'MFTime';
is $testNode->mfvec2d->getType,     'MFVec2d';
is $testNode->mfvec2f->getType,     'MFVec2f';
is $testNode->mfvec3d->getType,     'MFVec3d';
is $testNode->mfvec3f->getType,     'MFVec3f';
is $testNode->mfvec4d->getType,     'MFVec4d';
is $testNode->mfvec4f->getType,     'MFVec4f';

is $testNode->sfbool->getType,      'SFBool';
is $testNode->sfcolor->getType,     'SFColor';
is $testNode->sfcolorrgba->getType, 'SFColorRGBA';
is $testNode->sfdouble->getType,    'SFDouble';
is $testNode->sffloat->getType,     'SFFloat';
is $testNode->sfimage->getType,     'SFImage';
is $testNode->sfint32->getType,     'SFInt32';
is $testNode->sfnode->getType,      'SFNode';
is $testNode->sfrotation->getType,  'SFRotation';
is $testNode->sfstring->getType,    'SFString';
is $testNode->sftime->getType,      'SFTime';
is $testNode->sfvec2d->getType,     'SFVec2d';
is $testNode->sfvec2f->getType,     'SFVec2f';
is $testNode->sfvec3d->getType,     'SFVec3d';
is $testNode->sfvec3f->getType,     'SFVec3f';
is $testNode->sfvec4d->getType,     'SFVec4d';
is $testNode->sfvec4f->getType,     'SFVec4f';

#isa_ok $X3D->metadata, 'X3DField';
isa_ok $testNode->mfbool,      'X3DArray';
isa_ok $testNode->mfcolor,     'X3DArray';
isa_ok $testNode->mfcolorrgba, 'X3DArray';
isa_ok $testNode->mfdouble,    'X3DArray';
isa_ok $testNode->mffloat,     'X3DArray';
isa_ok $testNode->mfimage,     'X3DArray';
isa_ok $testNode->mfint32,     'X3DArray';
isa_ok $testNode->mfnode,      'X3DArray';
isa_ok $testNode->mfrotation,  'X3DArray';
isa_ok $testNode->mfstring,    'X3DArray';
isa_ok $testNode->mftime,      'X3DArray';
isa_ok $testNode->mfvec2d,     'X3DArray';
isa_ok $testNode->mfvec2f,     'X3DArray';
isa_ok $testNode->mfvec3d,     'X3DArray';
isa_ok $testNode->mfvec3f,     'X3DArray';
isa_ok $testNode->mfvec4d,     'X3DArray';
isa_ok $testNode->mfvec4f,     'X3DArray';

$testNode->sfnode = new X3DBaseNode;

#isa_ok $testNode->sfbool,      'X3DField';
isa_ok $testNode->sfcolor,     'X3DColor';
isa_ok $testNode->sfcolorrgba, 'X3DColorRGBA';
#isa_ok $testNode->sfdouble,    'X3DField';
#isa_ok $testNode->sffloat,     'X3DField';
isa_ok $testNode->sfimage,     'X3DImage';
#isa_ok $testNode->sfint32,     'X3DField';
isa_ok $testNode->sfnode,      'X3DBaseNode';
isa_ok $testNode->sfrotation,  'X3DRotation';
#isa_ok $testNode->sfstring,    'X3DField';
#isa_ok $testNode->sftime,      'X3DField';
isa_ok $testNode->sfvec2d,     'X3DVec2';
isa_ok $testNode->sfvec2f,     'X3DVec2';
isa_ok $testNode->sfvec3d,     'X3DVec3';
isa_ok $testNode->sfvec3f,     'X3DVec3';
isa_ok $testNode->sfvec4d,     'X3DVec4';
isa_ok $testNode->sfvec4f,     'X3DVec4';

isa_ok my $vec3f = $testNode->sfvec3f, 'X3DVec3';
ok !tied $vec3f;

ok tied $testNode->mfbool;
ok tied $testNode->mfcolor;
ok tied $testNode->mfcolorrgba;
ok tied $testNode->mfdouble;
ok tied $testNode->mffloat;
ok tied $testNode->mfimage;
ok tied $testNode->mfint32;
ok tied $testNode->mfnode;
ok tied $testNode->mfrotation;
ok tied $testNode->mfstring;
ok tied $testNode->mftime;
ok tied $testNode->mfvec2d;
ok tied $testNode->mfvec2f;
ok tied $testNode->mfvec3d;
ok tied $testNode->mfvec3f;
ok tied $testNode->mfvec4d;
ok tied $testNode->mfvec4f;

ok tied $testNode->sfbool;
ok tied $testNode->sfcolor;
ok tied $testNode->sfcolorrgba;
ok tied $testNode->sfdouble;
ok tied $testNode->sffloat;
ok tied $testNode->sfimage;
ok tied $testNode->sfint32;
ok tied $testNode->sfnode;
ok tied $testNode->sfrotation;
ok tied $testNode->sfstring;
ok tied $testNode->sftime;
ok tied $testNode->sfvec2d;
ok tied $testNode->sfvec2f;
ok tied $testNode->sfvec3d;
ok tied $testNode->sfvec3f;
ok tied $testNode->sfvec4d;
ok tied $testNode->sfvec4f;

ok !tied ${ tied $testNode->mfbool };
ok !tied ${ tied $testNode->mfcolor };
ok !tied ${ tied $testNode->mfcolorrgba };
ok !tied ${ tied $testNode->mfdouble };
ok !tied ${ tied $testNode->mffloat };
ok !tied ${ tied $testNode->mfimage };
ok !tied ${ tied $testNode->mfint32 };
ok !tied ${ tied $testNode->mfnode };
ok !tied ${ tied $testNode->mfrotation };
ok !tied ${ tied $testNode->mfstring };
ok !tied ${ tied $testNode->mftime };
ok !tied ${ tied $testNode->mfvec2d };
ok !tied ${ tied $testNode->mfvec2f };
ok !tied ${ tied $testNode->mfvec3d };
ok !tied ${ tied $testNode->mfvec3f };
ok !tied ${ tied $testNode->mfvec4d };
ok !tied ${ tied $testNode->mfvec4f };

ok !tied ${ tied $testNode->sfbool };
ok !tied ${ tied $testNode->sfcolor };
ok !tied ${ tied $testNode->sfcolorrgba };
ok !tied ${ tied $testNode->sfdouble };
ok !tied ${ tied $testNode->sffloat };
ok !tied ${ tied $testNode->sfimage };
ok !tied ${ tied $testNode->sfint32 };
ok !tied ${ tied $testNode->sfnode };
ok !tied ${ tied $testNode->sfrotation };
ok !tied ${ tied $testNode->sfstring };
ok !tied ${ tied $testNode->sftime };
ok !tied ${ tied $testNode->sfvec2d };
ok !tied ${ tied $testNode->sfvec2f };
ok !tied ${ tied $testNode->sfvec3d };
ok !tied ${ tied $testNode->sfvec3f };
ok !tied ${ tied $testNode->sfvec4d };
ok !tied ${ tied $testNode->sfvec4f };

1;
__END__



