use Test;
BEGIN { plan tests => 73 };
use blib;
use Bot::CPAN;

my $bot = Bot::CPAN->new();
ok(ref $bot, 'Bot::CPAN');
ok($bot->phrase('NO_DISTRIBUTION', {distribution => 'Foo-Bar'}), 'No such distribution: Foo-Bar');
ok($bot->phrase('NO_MODULE', {module => 'Foo::Bar'}), 'No such module: Foo::Bar');
ok($bot->phrase('NO_AUTHOR', {author => 'FOO'}), 'No such author: FOO');
ok($bot->phrase('UNKNOWN'), 'Unknown');
ok($bot->phrase('COMMAND_FAILURE'), 'A command failure occured :(');
ok($bot->phrase('Bot::CPAN::status', {requests => 'requests', s => '', start_time => 'start_time'}), 'requests request since I started up at start_time');
ok($bot->phrase('CPANRATINGS_DOWN'), 'cpanratings.perl.org is unavailable');
ok($bot->phrase('Bot::CPAN::dist_ratings(no_ratings)', {module => 'module'}), 'No ratings for: module');
ok($bot->phrase('Bot::CPAN::dist_ratings(ratings)', {ratings => 'ratings', n => 'n', mean => 'mean', median => 'median', min => 'min', max => 'max', stddev => 'stddev', mode => 'mode'}), 'Recent ratings: ratings; Overall (n=n): mean mean, median median, min min, max max, stddev stddev, mode mode');
ok($bot->phrase('Bot::CPAN::botsnack'), '<3');
ok($bot->phrase('Bot::CPAN::config(adminhost)', {adminhost => 'foo'}), 'Adminhost: foo');
ok($bot->phrase('Bot::CPAN::config(alt_nicks)', {alt_nicks => 'foo'}), 'Alt Nicks: foo');
ok($bot->phrase('Bot::CPAN::config(channels)', {channels => 'foo'}), 'Channels: foo');
ok($bot->phrase('Bot::CPAN::config(ignore_list)', {ignore_list => 'foo'}), 'Ignore List: foo');
ok($bot->phrase('Bot::CPAN::config(debug)', {debug => 'foo'}), 'Debug: foo');
ok($bot->phrase('Bot::CPAN::config(group)', {group => 'foo'}), 'Group: foo');
ok($bot->phrase('Bot::CPAN::config(inform_channel_of_new_uploads)', {inform_channel_of_new_uploads => 'foo'}), 'Inform Channel of New Uploads Interval: foo');
ok($bot->phrase('Bot::CPAN::config(inform_channel_of_new_ratings)', {inform_channel_of_new_ratings => 'foo'}), 'Inform Channel of New Ratings Interval: foo');
ok($bot->phrase('Bot::CPAN::config(name)', {name => 'foo'}), 'Name: foo');
ok($bot->phrase('Bot::CPAN::config(news_server)', {news_server => 'foo'}), 'News Server: foo');
ok($bot->phrase('Bot::CPAN::config(nick)', {nick => 'foo'}), 'Nick: foo');
ok($bot->phrase('Bot::CPAN::config(port)', {port => 'foo'}), 'Port: foo');
ok($bot->phrase('Bot::CPAN::config(reload_indices_interval)', {reload_indices_interval => 'foo'}), 'Reload Indice Interval: foo');
ok($bot->phrase('Bot::CPAN::config(search_max_results)', {search_max_results => 'foo'}), 'Search Max Results: foo');
ok($bot->phrase('Bot::CPAN::config(servers)', {servers => 'foo'}), 'Servers: foo');
ok($bot->phrase('Bot::CPAN::config(username)', {username => 'foo'}), 'Username: foo');
ok($bot->phrase('Bot::CPAN::config(last_indice_reload)', {last_indice_reload => 'foo'}), 'Last indice reload: foo');
ok($bot->phrase('Bot::CPAN::config(nickserv_password)', {nickserv_password => 'foo'}), 'Nickserv Password: foo');
ok($bot->phrase('Bot::CPAN::help(by)', {nick => 'nick', pkg => 'pkg', vers => 'vers'}), 'nick is brought to you by pkg version vers');
ok($bot->phrase('Bot::CPAN::help(both)', {commands => 'commands'}), 'Channel and /msg commands: commands');
ok($bot->phrase('Bot::CPAN::help(channel)', {commands => 'commands'}), 'Channel only commands: commands');
ok($bot->phrase('Bot::CPAN::help(msg)', {commands => 'commands'}), '/msg only commands: commands');
ok($bot->phrase('Bot::CPAN::help(help)', {help => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::recent(just_got_here)'), 'I just got here. Give me a bit to get settled. :)');
ok($bot->phrase('Bot::CPAN::recent(results)', {results => 'foo'}), 'foo');
ok($bot->phrase('NO_RESULTS'), 'No results');
ok($bot->phrase('SEARCH_CPAN_ORG_DOWN'), 'search.cpan.org is unavailable');
ok($bot->phrase('BAD_SEARCH_TERMS'), 'Search term must match [A-Za-z0-9]+');
ok($bot->phrase('NO_MODULES_IN_DISTRIBUTION', {dist => 'FOO'}), 'No modules in distribution: FOO');
ok($bot->phrase('NO_CHAPTER_FOR_DISTRIBUTION', {dist => 'FOO'}), 'No chapter for distribution: FOO');
ok($bot->phrase('NO_TESTS_FOR_DIST', {distribution => 'FOO'}), 'No tests reported against: FOO');

ok($bot->phrase('Bot::CPAN::id_dists', {id_dists => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_tests', {tests => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_stage', {stage => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_support', {support => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_language', {language => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_style', {style => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_license', {license => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::top10', {top10 => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::id_name', {name => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::id_email', {email => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_version', {mod_version => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_rturl', {mod_rturl => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_docurl', {mod_docurl => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_dist', {mod_dist => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_id', {mod_id => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_desc', {mod_desc => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_chapter', {mod_chapter => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_dslip', {mod_dslip => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::mod_search', {mod_search => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_version', {dist_version => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_dlurl', {dist_dlurl => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_path', {dist_path => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_filename', {dist_filename => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_id', {dist_id => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_desc', {dist_desc => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_url', {dist_url => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_size', {dist_size => 'A'}), 'A bytes');
ok($bot->phrase('Bot::CPAN::dist_date', {dist_date => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_search', {dist_search => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_mods', {dist_mods => 'A'}), 'A');
ok($bot->phrase('Bot::CPAN::dist_chapter', {dist_chapter => 'A'}), 'A');
