use inc::Module::Install;

name            ('Foorum');
author          ('Fayland Lam<fayland@gmail.com>');
abstract        ('Foorum - forum system based on Catalyst');
license         ('perl');
version_from    ('lib/Foorum.pm');

requires 'Template' => '2.20';
requires 'DBIx::Class';
requires 'Catalyst' => '5.64';
requires 'Moose'    => '0.57';
requires 'Digest';
requires 'DateTime';
requires 'Date::Calc';
requires 'Encode::Guess';
requires 'File::Path';
requires 'File::Copy';
requires 'List::Util';
requires 'List::MoreUtils';
requires 'Catalyst::View::TT';
requires 'Catalyst::View::JSON';
requires 'Catalyst::Model::DBIC::Schema';
requires 'Catalyst::Plugin::Static::Simple';
requires 'Catalyst::Plugin::Config::YAML::XS';
requires 'Cache::FileCache';
requires 'Catalyst::Plugin::Cache';
requires 'Catalyst::Plugin::PageCache' => '0.21';
requires 'Set::Object';
requires 'Catalyst::Plugin::Authentication' => '0.10004';
requires 'Catalyst::Plugin::Authentication::Credential::Password';
requires 'Catalyst::Authentication::Store::FromSub::Hash' => '0.06';
requires 'Catalyst::Plugin::Session';
requires 'Catalyst::Plugin::Session::State::Cookie';
requires 'Catalyst::Plugin::Session::Store::Delegate'; # for DBIC next line
requires 'Catalyst::Plugin::Session::Store::DBIC';
requires 'Catalyst::Plugin::Session::DynamicExpiry';
requires 'Catalyst::Plugin::FormValidator::Simple';
requires 'Catalyst::Plugin::Captcha';
requires 'Catalyst::Plugin::I18N' => '0.08';
requires 'Template::Plugin::FillInForm';
requires 'Template::Plugin::Date';
requires 'File::Remove';
requires 'HTML::Email::Obfuscate';
requires 'Locale::Country::Multilingual' => '0.03'; # for tw lang
#requires 'File::Slurp';
requires 'Net::IP::Match::Regexp';
requires 'Net::CIDR::Lite';
requires 'WWW::Contact' => '0.17'; # the last version

# search
requires 'Sphinx::Search';

# cron
requires 'TheSchwartz::Moosified';
requires 'Schedule::Cron';
if ($^O ne 'MSWin32') {
    feature 'Cron script run-once',
        -default          => 0,
        'Proc::PID::File' => 0,
        'File::HomeDir'   => 0;
} else {
    feature 'Cron script run-once',
        -default          => 0,
        'File::HomeDir'   => 0;
}

# mail
requires 'MIME::Entity';
requires 'Email::Send';
feature 'Email::Send through Gmail',
    -default                 => 0,
    'Email::Send::SMTP::TLS' => 0;

# cron/misc|db
feature 'Be a Foorum developer',
    -default                => 0,
    'File::Next'            => 0,
    'CSS::Minifier'         => 0,
    'JavaScript::Minifier'  => 0,
    'Encode::HanConvert'    => 0,
    'Perl::Critic'          => 0,
    'Perl::Tidy'            => 0,
    'SQL::Translator'       => 0,
    'DBICx:::AutoDoc'       => 0,
    'Acme::PlayCode'        => '0.05',
    'Pod::From::GoogleWiki' => '0.05';

# formatter
requires 'Text::Textile';
requires 'Pod::Xhtml';
requires 'URI::Find::UTF8';
requires 'Text::GooglewikiFormat' => '0.04';

tests ( join ' ', ( glob('t/*.t'), glob('t/*/*.t') ) );

catalyst;

#install_script glob('script/*.pl');
auto_install;
WriteAll;
