use Test2::V0;
use Benchmark::DKbench;
use Capture::Tiny 'capture';

my $threads;
my @std = capture {$threads = system_identity()};
like($std[0], qr/CPU/, 'System identity');
warn $std[0];

my %opt = (
    iter       => 1,
    skip_bio   => 1,
    time       => 1,
    quick      => 1,
    exclude    => 'Math'
);
my (%stats1, %stats2);
@std = capture {%stats1 = suite_run({%opt, no_mce=>1})};
like($std[0], qr/Overall Time/, 'Bench');
warn $std[0];

if ($threads && $threads > 1) {
    $opt{include} = 'Astro';
    @std = capture {%stats2 = suite_run({%opt, threads=>2})};
    warn $std[0];
} else {
    %stats2 = %stats1;
    $stats2{threads} = 2;
}

@std = capture {calc_scalability(\%opt, \%stats1, \%stats2)};
like($std[0], qr/scalability/, 'Scalability');
warn $std[0];

@std = capture {
    %stats1 = suite_run({
            threads    => 1,
            skip_prove => 1,
            bio_codons => 1,
            skip_timep => 1,
            iter       => 2,
            no_mce     => 1,
            include    => 'Matrix'
        }
    )
};
like($std[0], qr/Overall Avg Score/, 'Aggregate');
warn $std[0];

%stats2 = %stats1;
$stats2{threads} = 2;
calc_scalability({}, \%stats1, \%stats2);

@std = capture {
    suite_run({
            threads => 1,
            time    => 1,
            quick   => 1,
            iter    => 2,
            repeat  => 1,
            no_mce  => 1,
            include => 'DCT',
        }
    )
};
like($std[0], qr/Overall Avg Time/, 'Aggregate');

@std = capture {
    suite_run({
            threads => 1,
            time    => 1,
            iter    => 1,
            repeat  => 1,
            no_mce  => 1,
            include => 'prove',
        }
    )
};
like($std[0], qr/Overall Time/, 'Single');

# Let's get some cover
is(Benchmark::DKbench::compare_hash({a=>1}, {a=>1, b=>1}), 0, 'Different num keys');
is(Benchmark::DKbench::compare_hash({a=>1, b=>2}, {a=>1, b=>1}), 0, 'Different values');
is(Benchmark::DKbench::compare_arr([1, 2], [1]), 0, 'Different size array');
is(Benchmark::DKbench::compare_arr([1, 2], [1, 1]), 0, 'Different vals array');
is(Benchmark::DKbench::compare_obj([], {}), 0, 'Different types of obj');
is([Benchmark::DKbench::_decode_jwt2(token=>1,decode_header=>1)], [undef, undef], 'No token');
my @arr = (10, 11, 9, 10, 11, 10, 10, 10, 10, 10, 10);
is([Benchmark::DKbench::drop_outliers([@arr, 1, 19])], [@arr], 'Drop outliers');
is([Benchmark::DKbench::drop_outliers([@arr, 1, 19],1)], [@arr, 1], 'Drop right side outliers');
is([Benchmark::DKbench::drop_outliers([@arr, 1, 19],-1)], [@arr, 19], 'Drop left side outliers');
is([Benchmark::DKbench::avg_stdev([])], [0, 0], 'Empty array');
is([Benchmark::DKbench::min_max_avg([])], [0, 0, 0], 'Empty array');
is(length(Benchmark::DKbench::_random_str()), 1, 'Default len 1');

done_testing();
