#! perl

use Test2::V0;

use Test::File::ShareDir -share =>
  { -dist => { 'CXC-Optics-Prescription-LVS' => 'share' } };

use CXC::Optics::Prescription::LVS::Mirror;
use YAML qw[ LoadFile ];
use File::Spec::Functions qw[ catfile ];
use Test2::Compare::Float;


my $model;
ok( lives { $model = CXC::Optics::Prescription::LVS::Mirror->load_mirror_model( 'ek05lvs' ) },
    'load ek05lvs' ) or note $@;

isa_ok( $model, 'CXC::Optics::Prescription::LVS::Mirror' );

for my $mth ( qw[ axial_distances dimensions grazing_angles osac_prescriptions prescriptions ] ) {

    subtest "$mth" => sub {

        my @expected = LoadFile( catfile( qw[ t data ek05lvs ], $mth . '.yaml' ) );

        if ( $mth eq 'dimensions' ) {

            foreach ( grep { defined $_ } @expected ) {
                $_->{primary}{length} = Test2::Compare::Float->new( input => $_->{primary}{length} );
                $_->{secondary}{length} = Test2::Compare::Float->new( input => $_->{secondary}{length} );
            }
        }

        my @got;
        ok( lives { @got = $model->$mth }, "call $mth" ) or note $@;
        is( \@got, \@expected, "$mth value" );
    };
}



done_testing;
