#!/usr/bin/perl -w -I ../../../lib

use 5.018;

use strict;

use Carp;

{ package Narwhal::Effect::Phaser;

    use Moose;
    use Moose::Util::TypeConstraints;

    extends 'Narwhal::Effect';
    
    enum 'Form', [qw(sinusoidal triangular)];
    
    our %gencmd_form = ('sinusoidal' => '-s','triangular' => '-t');
    
    has 'gain_in' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'gain_out' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'delay' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'decay' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'speed' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'form' => (
        is => 'rw',
        isa => 'Form',
    );

    sub gencmd {
        my $self = shift;        
        my $ret = sprintf("%s %s %s %s %s %s %s",$self->fx,$self->gain_in,$self->gain_out,$self->delay,$self->decay,$self->speed,$Narwhal::Effect::Phaser::gencmd_form{$self->form});
        return($ret);
    }
}

1;
