package Settlers::Asset::City;
$Settlers::Asset::City::VERSION = '0.07';
use strict;
use warnings;
use Settlers::Resource::Ore;
use Settlers::Resource::Grain;

sub new
{
  my ($class, $location) = @_;

  die __PACKAGE__ . 'new requires a location argument'
    unless $location && $location->isa('Settlers::Map::Intersection');

  return bless {
    location => $location,
    code     => 'C',
  }, $class;
}

sub code     { $_[0]->{code} }
sub location { $_[0]->{location} }

sub cost
{
  return [
    Settlers::Resource::Ore->new(-3),
    Settlers::Resource::Grain->new(-2),
  ];
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Settlers::Asset::City

=head1 VERSION

version 0.07

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
