package Image::ANSI::Font;

=head1 NAME

Image::ANSI::Font - The default font

=head1 SYNOPSIS

	$font = Image::ANSI::Font->new;

=cut

use strict;
use warnings;

use GD;
use File::Temp;

our $VERSION = '0.01';

my $font_25 = [
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7e, 0x81, 0xa5, 0x81, 0x81, 0xbd, 0x99, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7e, 0xff, 0xdb, 0xff, 0xff, 0xc3, 0xe7, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0xe7, 0xe7, 0xe7, 0x99, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff ],
	[ 0x00, 0x00, 0x1e, 0x0e, 0x1a, 0x32, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3f, 0x33, 0x3f, 0x30, 0x30, 0x30, 0x30, 0x70, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7f, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x67, 0xe7, 0xe6, 0xc0, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x18, 0x18, 0xdb, 0x3c, 0xe7, 0x3c, 0xdb, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfe, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x02, 0x06, 0x0e, 0x1e, 0x3e, 0xfe, 0x3e, 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7f, 0xdb, 0xdb, 0xdb, 0x7b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0c, 0xfe, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0xfe, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x6c, 0xfe, 0x6c, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x7c, 0x7c, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x7c, 0x7c, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x66, 0x66, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0xfe, 0x6c, 0x6c, 0x6c, 0xfe, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x18, 0x7c, 0xc6, 0xc2, 0xc0, 0x7c, 0x06, 0x86, 0xc6, 0x7c, 0x18, 0x18, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0xc2, 0xc6, 0x0c, 0x18, 0x30, 0x60, 0xc6, 0x86, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x38, 0x6c, 0x6c, 0x38, 0x76, 0xdc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x30, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xce, 0xd6, 0xd6, 0xe6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x18, 0x38, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0x3c, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x0c, 0x1c, 0x3c, 0x6c, 0xcc, 0xfe, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xfc, 0x0e, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x38, 0x60, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xfe, 0xc6, 0x06, 0x06, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x0c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xde, 0xde, 0xde, 0xdc, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xe6, 0x66, 0x6c, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xde, 0x7c, 0x0c, 0x0e, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xfe, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xfe, 0xc6, 0x86, 0x0c, 0x18, 0x30, 0x60, 0xc2, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0x70, 0x38, 0x1c, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x10, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00 ],
	[ 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xe0, 0x60, 0x60, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0xdc, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x38, 0x6c, 0x64, 0x60, 0xf0, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00 ],
	[ 0x00, 0x00, 0xe0, 0x60, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x06, 0x06, 0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00 ],
	[ 0x00, 0x00, 0xe0, 0x60, 0x60, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xfe, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x0c, 0x1e, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x62, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x6c, 0x38, 0x38, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x70, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x0c, 0x06, 0x7c, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xcc, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x0c, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x10, 0x38, 0x6c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x60, 0x30, 0x18, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x38, 0x6c, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x60, 0x60, 0x66, 0x3c, 0x0c, 0x06, 0x3c, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xc6, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x66, 0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x18, 0x3c, 0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x60, 0x30, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0xc6, 0xc6, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x38, 0x6c, 0x38, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x30, 0x60, 0x00, 0xfe, 0x66, 0x60, 0x7c, 0x60, 0x60, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x76, 0x36, 0x7e, 0xd8, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3e, 0x6c, 0xcc, 0xcc, 0xfe, 0xcc, 0xcc, 0xcc, 0xcc, 0xce, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xc6, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x30, 0x78, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x60, 0x30, 0x18, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0x78, 0x00 ], 
	[ 0x00, 0xc6, 0xc6, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0xc6, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x18, 0x18, 0x3c, 0x66, 0x60, 0x60, 0x60, 0x66, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x38, 0x6c, 0x64, 0x60, 0xf0, 0x60, 0x60, 0x60, 0x60, 0xe6, 0xfc, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0xf8, 0xcc, 0xcc, 0xf8, 0xc4, 0xcc, 0xde, 0xcc, 0xcc, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x0e, 0x1b, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0x70, 0x00, 0x00 ],
	[ 0x00, 0x18, 0x30, 0x60, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x0c, 0x18, 0x30, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x18, 0x30, 0x60, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x18, 0x30, 0x60, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x76, 0xdc, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x76, 0xdc, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x60, 0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x60, 0xce, 0x93, 0x06, 0x0c, 0x1f, 0x00, 0x00 ],
	[ 0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x66, 0xce, 0x9a, 0x3f, 0x06, 0x0f, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x66, 0xcc, 0x66, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x66, 0x33, 0x66, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44 ],
	[ 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa ],
	[ 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x30, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xf7, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 0xf7, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff ],
	[ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 ],
	[ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f ],
	[ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0xd8, 0xd8, 0xd8, 0xdc, 0x76, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xfc, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x80, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0xfe, 0xc6, 0x60, 0x30, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xc0, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x7e, 0x18, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0x6c, 0xee, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x1e, 0x30, 0x18, 0x0c, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xdb, 0xdb, 0xdb, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x03, 0x06, 0x7e, 0xcf, 0xdb, 0xf3, 0x7e, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x1c, 0x30, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xec, 0x6c, 0x6c, 0x3c, 0x1c, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0xd8, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x70, 0x98, 0x30, 0x60, 0xc8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ]
];

my $font_50 = [
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x7e, 0x81, 0xa5, 0x81, 0xbd, 0x99, 0x81, 0x7e ],
	[ 0x7e, 0xff, 0xdb, 0xff, 0xc3, 0xe7, 0xff, 0x7e ],
	[ 0x6c, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00 ],
	[ 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00 ],
	[ 0x38, 0x7c, 0x38, 0xfe, 0xfe, 0xd6, 0x10, 0x38 ],
	[ 0x10, 0x38, 0x7c, 0xfe, 0xfe, 0x7c, 0x10, 0x38 ],
	[ 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00 ],
	[ 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff ],
	[ 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00 ],
	[ 0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff ],
	[ 0x0f, 0x07, 0x0f, 0x7d, 0xcc, 0xcc, 0xcc, 0x78 ],
	[ 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18 ],
	[ 0x3f, 0x33, 0x3f, 0x30, 0x30, 0x70, 0xf0, 0xe0 ],
	[ 0x7f, 0x63, 0x7f, 0x63, 0x63, 0x67, 0xe6, 0xc0 ],
	[ 0x18, 0xdb, 0x3c, 0xe7, 0xe7, 0x3c, 0xdb, 0x18 ],
	[ 0x80, 0xe0, 0xf8, 0xfe, 0xf8, 0xe0, 0x80, 0x00 ],
	[ 0x02, 0x0e, 0x3e, 0xfe, 0x3e, 0x0e, 0x02, 0x00 ],
	[ 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x7e, 0x3c, 0x18 ],
	[ 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x00 ],
	[ 0x7f, 0xdb, 0xdb, 0x7b, 0x1b, 0x1b, 0x1b, 0x00 ],
	[ 0x3e, 0x61, 0x3c, 0x66, 0x66, 0x3c, 0x86, 0x7c ],
	[ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x00 ],
	[ 0x18, 0x3c, 0x7e, 0x18, 0x7e, 0x3c, 0x18, 0xff ],
	[ 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x00 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00 ],
	[ 0x00, 0x18, 0x0c, 0xfe, 0x0c, 0x18, 0x00, 0x00 ],
	[ 0x00, 0x30, 0x60, 0xfe, 0x60, 0x30, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00 ],
	[ 0x00, 0x24, 0x66, 0xff, 0x66, 0x24, 0x00, 0x00 ],
	[ 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x00, 0x00 ],
	[ 0x00, 0xff, 0xff, 0x7e, 0x3c, 0x18, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x18, 0x00 ],
	[ 0x66, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x6c, 0x6c, 0xfe, 0x6c, 0xfe, 0x6c, 0x6c, 0x00 ],
	[ 0x18, 0x3e, 0x60, 0x3c, 0x06, 0x7c, 0x18, 0x00 ],
	[ 0x00, 0xc6, 0xcc, 0x18, 0x30, 0x66, 0xc6, 0x00 ],
	[ 0x38, 0x6c, 0x38, 0x76, 0xdc, 0xcc, 0x76, 0x00 ],
	[ 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x0c, 0x18, 0x30, 0x30, 0x30, 0x18, 0x0c, 0x00 ],
	[ 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x00 ],
	[ 0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00 ],
	[ 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30 ],
	[ 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 ],
	[ 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80, 0x00 ],
	[ 0x38, 0x6c, 0xc6, 0xd6, 0xc6, 0x6c, 0x38, 0x00 ],
	[ 0x18, 0x38, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00 ],
	[ 0x7c, 0xc6, 0x06, 0x1c, 0x30, 0x66, 0xfe, 0x00 ],
	[ 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c, 0x00 ],
	[ 0x1c, 0x3c, 0x6c, 0xcc, 0xfe, 0x0c, 0x1e, 0x00 ],
	[ 0xfe, 0xc0, 0xc0, 0xfc, 0x06, 0xc6, 0x7c, 0x00 ],
	[ 0x38, 0x60, 0xc0, 0xfc, 0xc6, 0xc6, 0x7c, 0x00 ],
	[ 0xfe, 0xc6, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x00 ],
	[ 0x7c, 0xc6, 0xc6, 0x7c, 0xc6, 0xc6, 0x7c, 0x00 ],
	[ 0x7c, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0x78, 0x00 ],
	[ 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00 ],
	[ 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30 ],
	[ 0x06, 0x0c, 0x18, 0x30, 0x18, 0x0c, 0x06, 0x00 ],
	[ 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00 ],
	[ 0x60, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x60, 0x00 ],
	[ 0x7c, 0xc6, 0x0c, 0x18, 0x18, 0x00, 0x18, 0x00 ],
	[ 0x7c, 0xc6, 0xde, 0xde, 0xde, 0xc0, 0x78, 0x00 ],
	[ 0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00 ],
	[ 0xfc, 0x66, 0x66, 0x7c, 0x66, 0x66, 0xfc, 0x00 ],
	[ 0x3c, 0x66, 0xc0, 0xc0, 0xc0, 0x66, 0x3c, 0x00 ],
	[ 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00 ],
	[ 0xfe, 0x62, 0x68, 0x78, 0x68, 0x62, 0xfe, 0x00 ],
	[ 0xfe, 0x62, 0x68, 0x78, 0x68, 0x60, 0xf0, 0x00 ],
	[ 0x3c, 0x66, 0xc0, 0xc0, 0xce, 0x66, 0x3a, 0x00 ],
	[ 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00 ],
	[ 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00 ],
	[ 0x1e, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0x78, 0x00 ],
	[ 0xe6, 0x66, 0x6c, 0x78, 0x6c, 0x66, 0xe6, 0x00 ],
	[ 0xf0, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00 ],
	[ 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0x00 ],
	[ 0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0x00 ],
	[ 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00 ],
	[ 0xfc, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00 ],
	[ 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xce, 0x7c, 0x0e ],
	[ 0xfc, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0xe6, 0x00 ],
	[ 0x3c, 0x66, 0x30, 0x18, 0x0c, 0x66, 0x3c, 0x00 ],
	[ 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x3c, 0x00 ],
	[ 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00 ],
	[ 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x00 ],
	[ 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00 ],
	[ 0xc6, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0xc6, 0x00 ],
	[ 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x3c, 0x00 ],
	[ 0xfe, 0xc6, 0x8c, 0x18, 0x32, 0x66, 0xfe, 0x00 ],
	[ 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00 ],
	[ 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x02, 0x00 ],
	[ 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00 ],
	[ 0x10, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff ],
	[ 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00 ],
	[ 0xe0, 0x60, 0x7c, 0x66, 0x66, 0x66, 0xdc, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc6, 0x7c, 0x00 ],
	[ 0x1c, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00 ],
	[ 0x3c, 0x66, 0x60, 0xf8, 0x60, 0x60, 0xf0, 0x00 ],
	[ 0x00, 0x00, 0x76, 0xcc, 0xcc, 0x7c, 0x0c, 0xf8 ],
	[ 0xe0, 0x60, 0x6c, 0x76, 0x66, 0x66, 0xe6, 0x00 ],
	[ 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00 ],
	[ 0x06, 0x00, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c ],
	[ 0xe0, 0x60, 0x66, 0x6c, 0x78, 0x6c, 0xe6, 0x00 ],
	[ 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00 ],
	[ 0x00, 0x00, 0xec, 0xfe, 0xd6, 0xd6, 0xd6, 0x00 ],
	[ 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x00 ],
	[ 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00 ],
	[ 0x00, 0x00, 0xdc, 0x66, 0x66, 0x7c, 0x60, 0xf0 ],
	[ 0x00, 0x00, 0x76, 0xcc, 0xcc, 0x7c, 0x0c, 0x1e ],
	[ 0x00, 0x00, 0xdc, 0x76, 0x60, 0x60, 0xf0, 0x00 ],
	[ 0x00, 0x00, 0x7e, 0xc0, 0x7c, 0x06, 0xfc, 0x00 ],
	[ 0x30, 0x30, 0xfc, 0x30, 0x30, 0x36, 0x1c, 0x00 ],
	[ 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0x00 ],
	[ 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0xfc ],
	[ 0x00, 0x00, 0x7e, 0x4c, 0x18, 0x32, 0x7e, 0x00 ],
	[ 0x0e, 0x18, 0x18, 0x70, 0x18, 0x18, 0x0e, 0x00 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00 ],
	[ 0x70, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x70, 0x00 ],
	[ 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0x00 ],
	[ 0x7c, 0xc6, 0xc0, 0xc0, 0xc6, 0x7c, 0x0c, 0x78 ],
	[ 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00 ],
	[ 0x0c, 0x18, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00 ],
	[ 0x7c, 0x82, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00 ],
	[ 0xc6, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00 ],
	[ 0x30, 0x18, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00 ],
	[ 0x30, 0x30, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00 ],
	[ 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0x7e, 0x0c, 0x38 ],
	[ 0x7c, 0x82, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00 ],
	[ 0xc6, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00 ],
	[ 0x30, 0x18, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00 ],
	[ 0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00 ],
	[ 0x7c, 0x82, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00 ],
	[ 0x30, 0x18, 0x00, 0x38, 0x18, 0x18, 0x3c, 0x00 ],
	[ 0xc6, 0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0xc6, 0x00 ],
	[ 0x38, 0x6c, 0x7c, 0xc6, 0xfe, 0xc6, 0xc6, 0x00 ],
	[ 0x18, 0x30, 0xfe, 0xc0, 0xf8, 0xc0, 0xfe, 0x00 ],
	[ 0x00, 0x00, 0x7e, 0x18, 0x7e, 0xd8, 0x7e, 0x00 ],
	[ 0x3e, 0x6c, 0xcc, 0xfe, 0xcc, 0xcc, 0xce, 0x00 ],
	[ 0x7c, 0x82, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00 ],
	[ 0xc6, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00 ],
	[ 0x30, 0x18, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00 ],
	[ 0x78, 0x84, 0x00, 0xcc, 0xcc, 0xcc, 0x76, 0x00 ],
	[ 0x60, 0x30, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00 ],
	[ 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0xfc ],
	[ 0xc6, 0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x38, 0x00 ],
	[ 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00 ],
	[ 0x18, 0x18, 0x7e, 0xc0, 0xc0, 0x7e, 0x18, 0x18 ],
	[ 0x38, 0x6c, 0x64, 0xf0, 0x60, 0x66, 0xfc, 0x00 ],
	[ 0x66, 0x66, 0x3c, 0x7e, 0x18, 0x7e, 0x18, 0x18 ],
	[ 0xf8, 0xcc, 0xcc, 0xfa, 0xc6, 0xcf, 0xc6, 0xc7 ],
	[ 0x0e, 0x1b, 0x18, 0x3c, 0x18, 0xd8, 0x70, 0x00 ],
	[ 0x18, 0x30, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00 ],
	[ 0x0c, 0x18, 0x00, 0x38, 0x18, 0x18, 0x3c, 0x00 ],
	[ 0x0c, 0x18, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00 ],
	[ 0x18, 0x30, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00 ],
	[ 0x76, 0xdc, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x00 ],
	[ 0x76, 0xdc, 0x00, 0xe6, 0xf6, 0xde, 0xce, 0x00 ],
	[ 0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x7e, 0x00, 0x00 ],
	[ 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x7c, 0x00, 0x00 ],
	[ 0x18, 0x00, 0x18, 0x18, 0x30, 0x63, 0x3e, 0x00 ],
	[ 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x00, 0x00 ],
	[ 0x63, 0xe6, 0x6c, 0x7e, 0x33, 0x66, 0xcc, 0x0f ],
	[ 0x63, 0xe6, 0x6c, 0x7a, 0x36, 0x6a, 0xdf, 0x06 ],
	[ 0x18, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x18, 0x00 ],
	[ 0x00, 0x33, 0x66, 0xcc, 0x66, 0x33, 0x00, 0x00 ],
	[ 0x00, 0xcc, 0x66, 0x33, 0x66, 0xcc, 0x00, 0x00 ],
	[ 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88 ],
	[ 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa ],
	[ 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18 ],
	[ 0x36, 0x36, 0x36, 0x36, 0xf6, 0x36, 0x36, 0x36 ],
	[ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x36, 0x36, 0x36 ],
	[ 0x00, 0x00, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18 ],
	[ 0x36, 0x36, 0xf6, 0x06, 0xf6, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 ],
	[ 0x00, 0x00, 0xfe, 0x06, 0xf6, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0xf6, 0x06, 0xfe, 0x00, 0x00, 0x00 ],
	[ 0x36, 0x36, 0x36, 0x36, 0xfe, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18 ],
	[ 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x37, 0x30, 0x3f, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3f, 0x30, 0x37, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0xf7, 0x00, 0xff, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xff, 0x00, 0xf7, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36 ],
	[ 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00 ],
	[ 0x36, 0x36, 0xf7, 0x00, 0xf7, 0x36, 0x36, 0x36 ],
	[ 0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00 ],
	[ 0x36, 0x36, 0x36, 0x36, 0xff, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18 ],
	[ 0x00, 0x00, 0x00, 0x00, 0xff, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x36, 0x36, 0x3f, 0x00, 0x00, 0x00 ],
	[ 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x36, 0x36, 0x36 ],
	[ 0x36, 0x36, 0x36, 0x36, 0xff, 0x36, 0x36, 0x36 ],
	[ 0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18 ],
	[ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff ],
	[ 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff ],
	[ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 ],
	[ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f ],
	[ 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x76, 0xdc, 0xc8, 0xdc, 0x76, 0x00 ],
	[ 0x78, 0xcc, 0xcc, 0xd8, 0xcc, 0xc6, 0xcc, 0x00 ],
	[ 0xfe, 0xc6, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00 ],
	[ 0x00, 0x00, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x00 ],
	[ 0xfe, 0xc6, 0x60, 0x30, 0x60, 0xc6, 0xfe, 0x00 ],
	[ 0x00, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0x70, 0x00 ],
	[ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x7c, 0xc0 ],
	[ 0x00, 0x76, 0xdc, 0x18, 0x18, 0x18, 0x18, 0x00 ],
	[ 0x7e, 0x18, 0x3c, 0x66, 0x66, 0x3c, 0x18, 0x7e ],
	[ 0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0x6c, 0x38, 0x00 ],
	[ 0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x6c, 0xee, 0x00 ],
	[ 0x0e, 0x18, 0x0c, 0x3e, 0x66, 0x66, 0x3c, 0x00 ],
	[ 0x00, 0x00, 0x7e, 0xdb, 0xdb, 0x7e, 0x00, 0x00 ],
	[ 0x06, 0x0c, 0x7e, 0xdb, 0xdb, 0x7e, 0x60, 0xc0 ],
	[ 0x1e, 0x30, 0x60, 0x7e, 0x60, 0x30, 0x1e, 0x00 ],
	[ 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00 ],
	[ 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00 ],
	[ 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x7e, 0x00 ],
	[ 0x30, 0x18, 0x0c, 0x18, 0x30, 0x00, 0x7e, 0x00 ],
	[ 0x0c, 0x18, 0x30, 0x18, 0x0c, 0x00, 0x7e, 0x00 ],
	[ 0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x18 ],
	[ 0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0xd8, 0x70 ],
	[ 0x00, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x00, 0x00 ],
	[ 0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x00 ],
	[ 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00 ],
	[ 0x0f, 0x0c, 0x0c, 0x0c, 0xec, 0x6c, 0x3c, 0x1c ],
	[ 0x6c, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00 ],
	[ 0x78, 0x0c, 0x18, 0x30, 0x7c, 0x00, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00 ],
	[ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ],
];

=head1 METHODS

=head2 new( [$chars] )

Creates a new Image::ANSI::Font object.

=cut

sub new {
	my $class   = shift;
	my %options = @_;
	my $self    = {};

	bless $self, $class;

	my $font = ( defined $options{ height } and $options{ height } eq '80x50' ) ? $font_50 : $font_25 ;

	$self->chars( $font );

	return $self;
}

=head2 chars( [$chars] )

sets the character set. $chars should be an array (either 256 or 512 [the number of
characters]) of arrays (from 1 to 32 [1 bitmask per scanline]).

=cut

sub chars {
	my $self  = shift;
	my $chars = $_[ 0 ];

	if( @_ ) {
		if( @$chars == 0 ) {
			$self->{ _CHARS } = [];
			$self->height( 0 );
		}
		else {
			for( 0..@$chars - 1 ) {
				$self->char( $_, $chars->[ $_ ] );
			}
		}
	}

	return $self->{ _CHARS };
}

=head2 as_gd( )

Returns a GD::Font object.

=cut

sub as_gd {
	my $self = shift;
	my $temp = File::Temp->new;

	binmode( $temp );

	print $temp pack( 'LLLL', $self->characters, 0, $self->width, $self->height );
	for my $char ( @{ $self->chars } ) {
		print $temp pack( 'C*', split( //, sprintf( '%08b', $_ ) ) ) for @$char;
	}
	close $temp;

	return GD::Font->load( $temp->filename );
}

=head2 clear( )

Clears any in-memory data.

=cut

sub clear {
	my $self = shift;

	$self->chars( [] );
}

=head2 width( )

Returns "8".

=cut

sub width {
	return 8;
}

=head2 char( $index, [$char] )

Get / set a char in the font.

=cut

sub char {
	my $self  = shift;
	my $index = shift;
	my $char  = $_[ 0 ];

	if( @_ ) {
		$self->{ _CHARS }->[ $index ] = $char;
		$self->height( scalar @$char );
	}
	
	return $self->{ _CHARS }->[ $index ];
}

=head2 characters( )

returns the number of characters in the font

=cut

sub characters {
	return scalar @{ $_[ 0 ]->chars };
}

=head2 height( [$height] )

returns the number of scanlines in each of the characters in the font

=cut

sub height {
	my $self   = shift;
	my $height = $_[ 0 ];

	if( @_ ) {
		$self->{ _HEIGHT } = $height;
	}

	return $self->{ _HEIGHT };
}

=head1 AUTHOR

=over 4 

=item * Brian Cassidy E<lt>bricas@cpan.orgE<gt>

=back

=head1 COPYRIGHT AND LICENSE

Copyright 2004 by Brian Cassidy

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut

1;