package Local::Utils; {
    # ABSTRACT: miscellaneous utilities
    use 5.010;

    use strict;  use warnings;  use autodie qw/:all/;

    use parent 'Exporter';
    our (@EXPORT_OK, @EXPORT);
    BEGIN { # needs to happen at BEGIN time via use or BEGIN {}
        @EXPORT_OK = qw(fopen);  # symbols to export on request
        @EXPORT    = qw(), @EXPORT_OK;
    }

    our $VERSION = '0.001';

    use Carp qw/croak/;

    sub fopen {
        my $file = shift;
        my $mode = shift // '<';

        no autodie;
        open my $handle, $mode, $file
          or croak "Can't open '$file': $!";
        return $handle;
    }
};

1;
