# NAME

Catalog

# VERSION 0.022

# Description

A catalog of common Vote Counting Systems and their implementation in Vote::Count.

# Methods by Family

## Borda Count

The Borda Count implementation does not yet cover all common weighting rule variations.

* Borda Count: core Vote::Count
* Nansen: *needs example*
* Baldwin: *needs example*
* Minet: *needs example*
* Star: *needs Range Ballot support*

## Instant Runoff Voting

Also known as Alternative Vote or Hare System.

* Instant Runoff Voting: core Vote::Count
* Benham Condorcet IRV: HandCount methods documentation
* SmithSet IRV: Vote::Count::Method::CondorcetIRV

## Condorcet

### Simple Condorcet

* Benham Condorcet IRV: HandCount documentation
* Simple Dropping: Vote::Count::Method::CondorcetDropping
* SmithSet IRV: Vote::Count::Method::CondorcetIRV

### Complex Condorcet

* Condorcet vs IRV: Vote::Count::Method::CondorcetVsIRV
* Tiedeman: *unimplemented*
* SSD: *unimplemented*
* Kemmeny-Young: *unimplemented*

### Redacting Condorcet

* Condorcet vs IRV: Vote::Count::Method::CondorcetVsIRV

## AUTHOR

John Karr (BRAINBUZ) brainbuz@cpan.org

## CONTRIBUTORS

Copyright 2019 by John Karr (BRAINBUZ) brainbuz@cpan.org.

# LICENSE

This module is released under the GNU Public License Version 3. See license file for details. For more information on this license visit http://fsf.org.
