use 5.010;
use strict;
use warnings FATAL => 'all';
use ExtUtils::MakeMaker;
use File::ShareDir::Install;

install_share 'share';

WriteMakefile(
    NAME             => 'Finance::Asset',
    AUTHOR           => q{binary.com <perl@binary.com>},
    VERSION_FROM     => 'lib/Finance/Asset.pm',
    ABSTRACT         => 'Object representation of a financial asset',
    LICENSE          => 'Artistic_2_0',
    PL_FILES         => {},
    MIN_PERL_VERSION => 5.010,
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => 0,
    },
    BUILD_REQUIRES => {
        'Test::Most'        => 0,
        'Test::Exception'   => 0,
    },
    PREREQ_PM => {
        'Moose'             => 0,
        'YAML::CacheLoader' => 0,
        'File::ShareDir'    => 0,
    },
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'Finance-Asset-*' },
    (
        eval { ExtUtils::MakeMaker->VERSION(6.46) }
        ? (
            META_MERGE => {
                'meta-spec' => { version => 2 },
                resources   => {
                    repository => {
                        type => 'git',
                        url => 'https://github.com/binary-com/perl-Finance-Asset.git',
                        web => 'https://github.com/binary-com/perl-Finance-Asset',
                    },
                }
            }
          )
        : ()
      ),
);

package MY;
use File::ShareDir::Install qw(postamble);

