package Acme::CPANAuthors::CPAN::OneHundred;
use strict;
use warnings;

{
    no strict "vars";
    $VERSION = "1.01";
}

use Acme::CPANAuthors::Register (

    'SHARYANTO'     => 'Steven Haryanto',
    'RJBS'          => 'Ricardo SIGNES',
    'TOBYINK'       => 'Toby Inkster',
    'ADAMK'         => 'Adam Kennedy',
    'MIYAGAWA'      => 'Tatsuhiko Miyagawa',
    'FLORA'         => 'Florian Ragwitz',
    'BINGOS'        => 'Chris Williams',
    'SMUELLER'      => 'Steffen Mueller',
    'TOKUHIROM'     => 'Tokuhiro Matsuno',
    'INGY'          => 'Ingy dot Net',
    'DAGOLDEN'      => 'David Golden',
    'NUFFIN'        => 'Yuval Kogman',
    'MARCEL'        => 'Marcel Gruenauer',
    'BOBTFISH'      => 'Tomas Doran',
    'ETHER'         => 'Karen Etheridge',
    'DMAKI'         => 'Daisuke Maki',
    'DROLSKY'       => 'Dave Rolsky',
    'KENTNL'        => 'Kent Fredric',
    'GUGOD'         => 'Liu Kang Min',
    'SIMON'         => 'Simon Cozens',
    'AUTRIJUS'      => 'Audrey Tang',
    'BDFOY'         => 'brian d foy',
    'PEVANS'        => 'Paul Evans',
    'SHLOMIF'       => 'Shlomi Fish',
    'SALVA'         => 'Salvador Fandino Garcia',
    'LBROCARD'      => 'Leon Brocard',
    'MRAMBERG'      => 'Marcus Ramberg',
    'MLEHMANN'      => 'Marc Lehmann',

);

q<
We are programmed just to do
Anything you want us to

We are the robots, we are the robots
We are the robots, we are the robots

Lyrics copyright Ralf Htter
>

__END__

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::OneHundred - The CPAN Authors who have 100+ distributions on CPAN

=head1 DESCRIPTION

This class provides a hash of CPAN authors' PAUSE ID and name to be 
used with the C<Acme::CPANAuthors> module.

This module was created to capture all those CPAN Authors who have valiantly
submitted their modules and distributions to CPAN, and now have the honour of
currently maintaining 100 or more distributions on CPAN.

=head1 THE AUTHORS

   1.  329  SHARYANTO     Steven Haryanto
   2.  274  RJBS          Ricardo SIGNES
   3.  259  TOBYINK       Toby Inkster
   4.  248  ADAMK         Adam Kennedy
   5.  224  MIYAGAWA      Tatsuhiko Miyagawa
   6.  207  FLORA         Florian Ragwitz
   7.  204  BINGOS        Chris Williams
   8.  182  SMUELLER      Steffen Mueller
   9.  180  TOKUHIROM     Tokuhiro Matsuno
  10.  172  INGY          Ingy dot Net
  11.  161  DAGOLDEN      David Golden
  12.  158  NUFFIN        Yuval Kogman
  13.  157  MARCEL        Marcel Gruenauer
  14.  152  BOBTFISH      Tomas Doran
  15.  132  ETHER         Karen Etheridge
  16.  123  DMAKI         Daisuke Maki
  17.  123  DROLSKY       Dave Rolsky
  18.  121  KENTNL        Kent Fredric
  19.  119  GUGOD         Liu Kang Min
  20.  118  SIMON         Simon Cozens
  21.  112  AUTRIJUS      Audrey Tang
  22.  112  BDFOY         brian d foy
  23.  107  PEVANS        Paul Evans
  24.  105  SHLOMIF       Shlomi Fish
  25.  102  SALVA         Salvador Fandino Garcia
  26.  102  LBROCARD      Leon Brocard
  27.  101  MRAMBERG      Marcus Ramberg
  28.  100  MLEHMANN      Marc Lehmann

List last updated: 2014-06-01T07:48:10

=head1 MAINTENANCE

If you are aware of any CPAN author that has attained the heady heights of 100
distributions on CPAN, and who is not listed here, please send me their ID/name
via email or RT, and I will update the module. If there are any mistakes, 
please contact me as soon as possible, and I'll amend the entry right away.

=head1 SEE ALSO

L<Acme::CPANAuthors> - Main class to manipulate this one.

L<Acme::CPANAuthors::BackPAN::OneHundred> - 100+ distributions on BackPAN.

=head1 SUPPORT

Bugs, patches and feature requests can be reported at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Acme-CPANAuthors-CPAN-OneHundred>

=item * GitHub

L<http://github.com/barbie/acme-cpanauthors-cpan-onehundred>

=back

There are no known bugs at the time of this release. However, if you spot a
bug or are experiencing difficulties that are not explained within the POD
documentation, please send an email to barbie@cpan.org or submit a bug to 
the RT queue. However, it would help greatly if you are able to pinpoint 
problems or even supply a patch. 

Fixes are dependent upon their severity and my availability. Should a fix 
not be forthcoming, please feel free to (politely) remind me.

=head1 ACKNOWLEDGEMENTS

Thanks to Kenichi Ishigaki for writing C<Acme::CPANAuthors>.

=head1 AUTHOR

  Barbie, <barbie@cpan.org>
  for Miss Barbell Productions <http://www.missbarbell.co.uk>.

=head1 COPYRIGHT & LICENSE

  Copyright 2014 Barbie for Miss Barbell Productions.

  This distribution is free software; you can redistribute it and/or
  modify it under the Artistic License 2.0.

=cut
