package Shipment::FedEx::WSDL::ShipTypes::CompletedSmartPostDetail;
{
  $Shipment::FedEx::WSDL::ShipTypes::CompletedSmartPostDetail::VERSION = '0.01120790';
}
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://fedex.com/ws/ship/v9' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %PickUpCarrier_of :ATTR(:get<PickUpCarrier>);
my %Machinable_of :ATTR(:get<Machinable>);

__PACKAGE__->_factory(
    [ qw(        PickUpCarrier
        Machinable

    ) ],
    {
        'PickUpCarrier' => \%PickUpCarrier_of,
        'Machinable' => \%Machinable_of,
    },
    {
        'PickUpCarrier' => 'Shipment::FedEx::WSDL::ShipTypes::CarrierCodeType',
        'Machinable' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'PickUpCarrier' => 'PickUpCarrier',
        'Machinable' => 'Machinable',
    }
);

} # end BLOCK







1;




__END__
=pod

=head1 NAME

Shipment::FedEx::WSDL::ShipTypes::CompletedSmartPostDetail

=head1 VERSION

version 0.01120790

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CompletedSmartPostDetail from the namespace http://fedex.com/ws/ship/v9.

Provides reply information specific to SmartPost shipments.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * PickUpCarrier (min/maxOccurs: 0/1)

=item * Machinable (min/maxOccurs: 0/1)

=back

=head1 NAME

Shipment::FedEx::WSDL::ShipTypes::CompletedSmartPostDetail

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::ShipTypes::CompletedSmartPostDetail
   PickUpCarrier => $some_value, # CarrierCodeType
   Machinable =>  $some_value, # boolean
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHORS

=over 4

=item *

Andrew Baerg <baergaj@cpan.org>

=item *

Al Newkirk <awncorp@cpan.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2010 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

