# -*- cperl -*-

use Test::More;
use Lingua::PT::PLN;

use POSIX qw(locale_h);
setlocale(&POSIX::LC_ALL, "pt_PT");
use locale;

plan skip_all => 'Locale not good enough' unless "o" =~ /\w{3}/;

plan tests => 30;

is( syllable("ol")  , "o|l"   ,"syllable");
is( wordaccent("ol")  , "o|l:"   ,"wordaccent");
is( wordaccent("ol", 1)  , "o|\"l"   ,"wordaccent");

is( syllable("casa")  , "ca|sa"   ,"syllable");
is( wordaccent("casa")  , "ca:|sa"   ,"wordaccent");
is( wordaccent("casa", 1)  , "\"ca|sa"   ,"wordaccent");

is( syllable("beb")  , "be|b"   ,"syllable");
is( wordaccent("beb")  , "be|b:"   ,"wordaccent");
is( wordaccent("beb", 1)  , "be|\"b"   ,"wordaccent");

is( syllable("continue")  , "con|ti|nu|e"   ,"syllable");
is( wordaccent("continue")  , "con|ti|nu:|e"   ,"wordaccent");
is( wordaccent("continue", 1)  , "con|ti|\"nu|e"   ,"wordaccent");

is( syllable("quota")  , "quo|ta"   ,"syllable");
is( wordaccent("quota")  , "quo:|ta"   ,"wordaccent");
is( wordaccent("quota", 1)  , "\"quo|ta"   ,"wordaccent");

is( syllable("vcuo")  , "v|cu|o"   ,"syllable");
is( wordaccent("vcuo")  , "v:|cu|o"   ,"wordaccent");
is( wordaccent("vcuo", 1)  , "\"v|cu|o"   ,"wordaccent");

is( syllable("opo")  , "op|o"   ,"syllable");
is( wordaccent("opo")  , "op|:o"   ,"wordaccent");
is( wordaccent("opo", 1)  , "op|\"o"   ,"wordaccent");

is( syllable("aonde")  , "a|on|de"   ,"syllable");
is( wordaccent("aonde")  , "a|o:n|de"   ,"wordaccent");
is( wordaccent("aonde", 1)  , "a|\"on|de"   ,"wordaccent");

is( syllable("aerdromo")  , "a|e|r|dro|mo"   ,"syllable");
is( wordaccent("aerdromo")  , "a|e|r:|dro|mo"   ,"wordaccent");
is( wordaccent("aerdromo", 1)  , "a|e|\"r|dro|mo"   ,"wordaccent");

is( syllable("histria")  , "his|t|ri|a"   ,"syllable");
is( wordaccent("histria")  , "his|t:|ri|a"   ,"wordaccent");
is( wordaccent("histria", 1)  , "his|\"t|ri|a"   ,"wordaccent");

1;
