use Evo;
use Benchmark ':all';
use Test::More;
use Evo::Flow;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $N      = 10;
my $EXPECT = 9 * $ENV{TEST_EVO_PERF};
my ($t, $perf);

my $flow = Evo::Flow->new;

sub asap {
  $flow->asap(@_);
}
my ($L, $n);

sub recursive {
  $L--;
  return unless $L > 0;
  asap sub { recursive() };
}

$t = timeit(
  $N,
  sub {
    $L = 100_000;
    $n = $L;
    recursive();
    diag "$n calls";
  }
);

diag "$L: " . timestr $t;
$perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";


$t = timeit(
  $N,
  sub {
    $L = 100_000;
    $n = $L;
    asap sub { recursive() };
    diag "$n calls";
  }
);

diag "$L: " . timestr $t;
$perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";
done_testing;
