package main;
use Evo;
use Test::More;
use Evo::Util::Mdn ':all';
use Evo::Mdn;
{

  package My::Obj;
  use Evo -class;
}


my $to  = My::Obj->new;
my $me  = My::Obj->new;
my $mdn = Evo::Mdn->new;

ok !is_subscribed $mdn, $me, $to;
ok !is_stored $mdn,     $me, $to;

$mdn->subscribe($me, $to, 1, sub { });
ok is_subscribed $mdn, $me, $to;
ok is_stored $mdn,     $me, $to;

$mdn->unsubscribe($me, $to);
ok !is_subscribed $mdn, $me, $to;
ok !is_stored $mdn,     $me, $to;

$mdn->subscribe($me, $to, 0, sub { });
ok is_subscribed $mdn, $me, $to;
ok !is_stored $mdn,    $me, $to;
$mdn->unsubscribe($me, $to);

my $me2 = My::Obj->new;
$mdn->subscribe($me,  $to, 1, sub { });
$mdn->subscribe($me2, $to, 1, sub { });
is_deeply [sort (list_subscribers($mdn, $to))], [sort ($me, $me2)];
is_deeply [sort (list_stores($mdn, $to))], [sort ($me, $me2)];
$mdn->unsubscribe($me, $to);
is_deeply [sort (list_stores($mdn, $to))], [sort ($me2)];
is_deeply [sort (list_subscribers($mdn, $to))], [sort ($me2)];
$mdn->unsubscribe($me2, $to);


$mdn->subscribe($me,  $to, 1, sub { });
$mdn->subscribe($me2, $to, 0, sub { });
is_deeply [sort (list_subscribers($mdn, $to))], [sort ($me, $me2)];
is_deeply [sort (list_stores($mdn, $to))], [sort ($me)];

done_testing;
