package main;
use Evo;
use Test::More;
use Evo::Stash;

my (@destroyed, @created);
{

  package My::Obj;
  use Evo -class;

  package My::Foo;
  use Evo -class;
  sub new { my $self = shift->SUPER::new(@_); push @created, "$self"; $self; }
  sub DESTROY { my $self = shift; push @destroyed, "$self"; }
}

my $stash = Evo::Stash->new;
my $key   = My::Obj->new;
KEY: {
  my $me = My::Foo->new;
  $stash->set($key, $me, 1);
}

ok scalar @destroyed;
is_deeply [sort @destroyed], [sort @created];

done_testing;


