use Evo;
use Test::More;
use Evo::Spy;

my ($i, $spy);

sub virgin {
  $i   = 0;
  $spy = Evo::Spy->new;
}

virgin;
is $spy->origin, undef;

# store one arg
virgin;
$spy->('foo');
is_deeply $spy->calls->[0]->{args}, ['foo'];
$spy->fn->('foo');
is_deeply $spy->calls->[1]->{args}, ['foo'];

# store many args
virgin;
$spy->('foo', 'bar');
is_deeply $spy->calls->[0]->{args}, ['foo', 'bar'];
$spy->fn->('foo', 'bar');
is_deeply $spy->calls->[1]->{args}, ['foo', 'bar'];

# no args as empty array
virgin;
$spy->();
is_deeply $spy->calls->[0]->{args}, [];
$spy->fn->();
is_deeply $spy->calls->[1]->{args}, [];

done_testing;
