package main;
use Evo;
use Test::More;
use Evo::Flow;

my $flow = Evo::Flow->new;
my (@destroyed, @created, $res);

# create clousure and check if it's destroyed on the next step
# it should be because asap destroy passed stations

$flow->asap(
  sub {
    my $obj = MyFoo->new;
    $flow->asap(sub {$obj});
    $flow->asap(sub { $res = [@destroyed] });
  }
);

is scalar @$res, 1;
is_deeply [sort @$res], [sort @created];

{

  package MyFoo;
  use Evo -class;
  sub new { my $self = shift; push @created, $self; $self->SUPER::new(@_) }
  sub DESTROY { my $self = shift; push @destroyed, ref $self; }
}

done_testing;

