package main;
use Evo::Base -strict;
use Test::More tests => 4;
use Evo::MDN;

my (@destroyed, @created, $res, $fired, @MSGS);

my $mdn = Evo::MDN->new;
FOO: {
  my $from = MyFoo->new;
  my $to   = MyFoo->new;
  my $to2  = MyFoo->new;
  my @msgs;
  $mdn->subscribe($to2, $from, 0, sub { push @msgs, $_[1] });
  $mdn->subscribe($to, $from, 0);
  $mdn->broadcast($from, 'hello');
  $mdn->broadcast($from, $to);
  $mdn->broadcast($from, $from);
  is_deeply \@MSGS, ['hello', $to, $from];
  is_deeply \@msgs, ['hello', $to, $from];
  @MSGS = ();
  @msgs = ();
}

ok scalar @destroyed;
is_deeply [sort @destroyed], [sort @created];


{

  package MyFoo;
  use Evo::Base -base;
  sub when_message { shift; push @MSGS, shift }

  sub new { my $self = shift->SUPER::new(@_); push @created, "$self"; $self; }
  sub DESTROY { my $self = shift; push @destroyed, "$self"; }
}

done_testing;


