use Evo::Base -strict;
use Railway::Builder;
use Benchmark ':all';
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $bldr = Railway::Builder->new;

my $EXPECT = 1;
my $N      = 10;
my $L      = 100_000;

my $t = timeit(
  $N,
  sub {
    my $train = $bldr->build_train;
    my $k;
    $train->way->add(sub { $k++ }) for 1 .. $L;
    $train->start();
    ok $k == $L, "$k = $L";
  }
);

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;
