package Astro::Coord::ECI::VSOP87D::Saturn;

use 5.008;

use strict;
use warnings;

use base qw{ Astro::Coord::ECI::VSOP87D::_Superior };

our $VERSION = '0.005_02';

sub __model_definition {
    my ( undef, $key ) = @_;
    return {
      body => "Saturn",
      default_model_cutoff => {
        Meeus => {
                   B0   => 34,
                   B1   => 32,
                   B2   => 29,
                   B3   => 21,
                   B4   => 12,
                   B5   => 2,
                   L0   => 90,
                   L1   => 79,
                   L2   => 63,
                   L3   => 48,
                   L4   => 27,
                   L5   => 5,
                   name => "Meeus",
                   R0   => 44,
                   R1   => 38,
                   R2   => 32,
                   R3   => 28,
                   R4   => 23,
                   R5   => 18,
                 },
        none  => {
                   B0   => 500,
                   B1   => 260,
                   B2   => 111,
                   B3   => 58,
                   B4   => 26,
                   B5   => 11,
                   L0   => 1152,
                   L1   => 642,
                   L2   => 321,
                   L3   => 148,
                   L4   => 68,
                   L5   => 27,
                   name => "none",
                   R0   => 1205,
                   R1   => 639,
                   R2   => 342,
                   R3   => 157,
                   R4   => 64,
                   R5   => 28,
                 },
      },
      diameter => 116464,
      model => [
        [
          {
            series => "L0",
            terms  => [
                        [0.87401354029, 0, 0],
                        [0.1110765978, 3.96205090194, 213.299095438],
                        [0.01414150958, 4.58581515873, 7.1135470008],
                        [0.00398379386, 0.52112025957, 206.1855484372],
                        [0.00350769223, 3.30329903015, 426.598190876],
                        [0.00206816296, 0.24658366938, 103.0927742186],
                        [0.00079271288, 3.8400707853, 220.4126424388],
                        [0.00023990338, 4.6697693486, 110.2063212194],
                        [0.00016573583, 0.43719123541, 419.4846438752],
                        [0.00014906995, 5.76903283845, 316.3918696566],
                        [0.000158203, 0.9380895376, 632.7837393132],
                        [0.00014609562, 1.56518573691, 3.9321532631],
                        [0.00013160308, 4.44891180176, 14.2270940016],
                        [0.00015053509, 2.71670027883, 639.897286314],
                        [0.00013005305, 5.98119067061, 11.0457002639],
                        [0.00010725066, 3.12939596466, 202.2533951741],
                        [5.863207e-05, 0.23657028777, 529.6909650946],
                        [5.227771e-05, 4.2078316238, 3.1813937377],
                        [6.126308e-05, 1.76328499656, 277.0349937414],
                        [5.019658e-05, 3.17787919533, 433.7117378768],
                        [4.592541e-05, 0.61976424374, 199.0720014364],
                        [4.005862e-05, 2.24479893937, 63.7358983034],
                        [2.953815e-05, 0.98280385206, 95.9792272178],
                        [3.873696e-05, 3.22282692566, 138.5174968707],
                        [2.461172e-05, 2.03163631205, 735.8765135318],
                        [3.26949e-05, 0.77491895787, 949.1756089698],
                        [1.758143e-05, 3.26580514774, 522.5774180938],
                        [1.640183e-05, 5.50504966218, 846.0828347512],
                        [1.391336e-05, 4.02331978116, 323.5054166574],
                        [1.580641e-05, 4.3726631412, 309.2783226558],
                        [1.123515e-05, 2.83726793572, 415.5524906121],
                        [1.017258e-05, 3.71698151814, 227.5261894396],
                        [8.48643e-06, 3.19149825839, 209.3669421749],
                        [1.087237e-05, 4.18343232481, 2.4476805548],
                        [9.56752e-06, 0.50740889886, 1265.5674786264],
                        [7.89205e-06, 5.00745123149, 0.9632078465],
                        [6.86965e-06, 1.74714407827, 1052.2683831884],
                        [6.5447e-06, 1.59889331515, 0.0481841098],
                        [7.48811e-06, 2.14398149298, 853.196381752],
                        [6.3398e-06, 2.29889903023, 412.3710968744],
                        [7.43584e-06, 5.25276954625, 224.3447957019],
                        [8.52677e-06, 3.42141350697, 175.1660598002],
                        [5.79857e-06, 3.09259007048, 74.7815985673],
                        [6.24904e-06, 0.97046831256, 210.1177017003],
                        [5.29861e-06, 4.44938897119, 117.3198682202],
                        [5.42643e-06, 1.51824320514, 9.5612275556],
                        [4.74279e-06, 5.47527185987, 742.9900605326],
                        [4.48542e-06, 1.28990416161, 127.4717966068],
                        [5.46358e-06, 2.12678554211, 350.3321196004],
                        [4.78054e-06, 2.96488054338, 137.0330241624],
                        [3.54944e-06, 3.0128648303, 838.9692877504],
                        [4.51827e-06, 1.04436664241, 490.3340891794],
                        [3.47413e-06, 1.53928227764, 340.7708920448],
                        [3.43475e-06, 0.24604039134, 0.5212648618],
                        [3.09001e-06, 3.49486734909, 216.4804891757],
                        [3.22185e-06, 0.96137456104, 203.7378678824],
                        [3.72308e-06, 2.27819108625, 217.2312487011],
                        [3.21543e-06, 2.57182354537, 647.0108333148],
                        [3.30196e-06, 0.24715617844, 1581.959348283],
                        [2.49116e-06, 1.47010534421, 1368.660252845],
                        [2.86688e-06, 2.37043745859, 351.8165923087],
                        [2.20225e-06, 4.20422424873, 200.7689224658],
                        [2.77775e-06, 0.40020408926, 211.8146227297],
                        [2.045e-06, 6.010822066, 265.9892934775],
                        [2.07663e-06, 0.48349820488, 1162.4747044078],
                        [2.08655e-06, 1.34516255304, 625.6701923124],
                        [1.82454e-06, 5.49122292426, 2.9207613068],
                        [2.26609e-06, 4.91003163138, 12.5301729722],
                        [2.07659e-06, 1.283022189, 39.3568759152],
                        [1.73914e-06, 1.86305806814, 0.7507595254],
                        [1.8469e-06, 3.50344404958, 149.5631971346],
                        [1.83511e-06, 0.97254952728, 4.192785694],
                        [1.46068e-06, 6.23102544071, 195.1398481733],
                        [1.64541e-06, 0.4400551752, 5.4166259714],
                        [1.47526e-06, 1.53529320509, 5.6290742925],
                        [1.39666e-06, 4.29450260069, 21.3406410024],
                        [1.31283e-06, 4.06828961903, 10.2949407385],
                        [1.17283e-06, 2.67920400584, 1155.361157407],
                        [1.49299e-06, 5.73594349789, 52.6901980395],
                        [1.22373e-06, 1.97588777199, 4.665866446],
                        [1.13747e-06, 5.59427544714, 1059.3819301892],
                        [1.02702e-06, 1.19748124058, 1685.0521225016],
                        [1.18156e-06, 5.340729339, 554.0699874828],
                        [1.09275e-06, 3.43812715686, 536.8045120954],
                        [1.10399e-06, 0.1660402409, 1.4844727083],
                        [1.24969e-06, 6.27737805832, 1898.3512179396],
                        [8.9949e-07, 5.80392934702, 114.1384744825],
                        [1.03956e-06, 2.19210363069, 88.865680217],
                        [1.12437e-06, 1.10502663534, 191.2076949102],
                        [1.0657e-06, 4.01156608514, 956.2891559706],
                        [9.143e-07, 1.8752157751, 38.1330356378],
                        [8.3791e-07, 5.48810655641, 0.1118745846],
                        [8.3461e-07, 2.28972767279, 628.8515860501],
                        [9.6987e-07, 4.53666595763, 302.164775655],
                        [1.00631e-06, 4.96513666539, 269.9214467406],
                        [7.5491e-07, 2.18045274099, 728.762966531],
                        [9.633e-07, 2.8331918921, 275.5505210331],
                        [8.2363e-07, 3.05469876064, 440.8252848776],
                        [7.3888e-07, 5.08914205084, 1375.7737998458],
                        [7.1633e-07, 5.1094074343, 65.2203710117],
                        [7.0409e-07, 4.86846451411, 0.2124483211],
                        [6.976e-07, 3.71029022489, 14.977853527],
                        [8.8772e-07, 3.86334563977, 278.5194664497],
                        [6.809e-07, 0.7341546099, 1478.8665740644],
                        [6.6501e-07, 0.02677580336, 70.8494453042],
                        [6.5682e-07, 2.02165559602, 142.4496501338],
                        [7.5765e-07, 1.61410487792, 284.1485407422],
                        [6.3153e-07, 3.49493353034, 479.2883889155],
                        [6.2539e-07, 2.58713611532, 422.6660376129],
                        [6.9313e-07, 3.43979731402, 515.463871093],
                        [7.9021e-07, 4.45154941586, 35.4247226521],
                        [6.3664e-07, 3.31749528708, 62.2514255951],
                        [5.2939e-07, 5.51392725227, 0.2606324309],
                        [5.3011e-07, 3.18480701697, 8.0767548473],
                        [5.4492e-07, 2.45674090515, 22.0914005278],
                        [5.0514e-07, 4.26749346978, 99.1606209555],
                        [5.517e-07, 0.9679744615, 942.062061969],
                        [4.9288e-07, 2.38641424063, 1471.7530270636],
                        [4.7199e-07, 2.02515248245, 312.1990839626],
                        [6.108e-07, 1.50295092063, 210.8514148832],
                        [4.5126e-07, 0.93109376473, 2001.4439921582],
                        [6.0556e-07, 2.68715551585, 388.4651552382],
                        [4.3452e-07, 2.52602011714, 288.0806940053],
                        [4.2544e-07, 3.81793980322, 330.6189636582],
                        [3.9915e-07, 5.713786529, 408.4389436113],
                        [5.0145e-07, 6.03164759907, 2214.7430875962],
                        [4.586e-07, 0.54229721801, 212.3358875915],
                        [5.4165e-07, 0.78154835399, 191.9584544356],
                        [4.7016e-07, 4.59934671151, 437.6438911399],
                        [4.2362e-07, 1.90070070955, 430.5303441391],
                        [3.9722e-07, 1.63259419913, 1066.49547719],
                        [3.6345e-07, 0.84756992711, 213.3472795478],
                        [3.5468e-07, 4.18603772925, 215.7467759928],
                        [3.6344e-07, 3.93295730315, 213.2509113282],
                        [3.8005e-07, 0.31313803095, 423.4167971383],
                        [4.4746e-07, 1.12488341174, 6.1503391543],
                        [3.7902e-07, 1.19795851115, 2.7083129857],
                        [4.3402e-07, 1.37363944007, 563.6312150384],
                        [4.3764e-07, 3.93043802956, 525.4981794006],
                        [3.4825e-07, 1.01566605408, 203.0041546995],
                        [3.1755e-07, 1.69273634405, 0.1600586944],
                        [3.088e-07, 6.13525703832, 417.0369633204],
                        [3.6388e-07, 6.00586032647, 18.1592472647],
                        [2.9032e-07, 1.19660544505, 404.5067903482],
                        [3.2812e-07, 0.53649479713, 107.0249274817],
                        [3.0433e-07, 0.72335287989, 222.8603229936],
                        [3.2644e-07, 0.81204701486, 1795.258443721],
                        [3.7769e-07, 3.69666903716, 1272.6810256272],
                        [2.7679e-07, 1.45663979401, 7.1617311106],
                        [2.7187e-07, 1.89731951902, 1045.1548361876],
                        [3.7699e-07, 4.51997049537, 24.3790223882],
                        [3.4885e-07, 4.46095761791, 214.2623032845],
                        [3.265e-07, 0.66372395761, 692.5874843535],
                        [3.0324e-07, 5.30369950147, 33.9402499438],
                        [2.748e-07, 6.22702216249, 1.2720243872],
                        [2.6657e-07, 4.56713198392, 7.065362891],
                        [3.1745e-07, 5.49798599565, 56.6223513026],
                        [2.805e-07, 5.64447420566, 128.9562693151],
                        [2.4277e-07, 3.93966553574, 414.0680179038],
                        [3.2017e-07, 5.22260660455, 92.0470739547],
                        [2.6976e-07, 0.06705123981, 205.2223405907],
                        [2.2974e-07, 3.6581775177, 207.6700211455],
                        [3.1775e-07, 5.59198119173, 6069.7767545534],
                        [2.3153e-07, 2.10054506119, 1788.1448967202],
                        [3.1025e-07, 0.37190053329, 703.6331846174],
                        [2.9376e-07, 0.14742155778, 131.4039498699],
                        [2.2562e-07, 5.24009182383, 212.7778305762],
                        [2.6185e-07, 5.41311252822, 140.001969579],
                        [2.5673e-07, 4.36038885283, 32.2433289144],
                        [2.0392e-07, 2.8241390926, 429.7795846137],
                        [2.0659e-07, 0.67091805084, 2317.8358618148],
                        [2.4397e-07, 3.08740396398, 145.6310438715],
                        [2.3735e-07, 2.54365387567, 76.2660712756],
                        [2.0157e-07, 5.06708675157, 617.8058857862],
                        [2.3307e-07, 3.97357729211, 483.2205421786],
                        [2.2878e-07, 6.10452832642, 177.8743727859],
                        [2.2978e-07, 3.20140795404, 208.633228992],
                        [2.0638e-07, 5.22128727027, 6.592282139],
                        [2.1446e-07, 0.72034565528, 1258.4539316256],
                        [1.8034e-07, 6.11382719947, 210.3783341312],
                        [2.238e-07, 5.92299908546, 173.9422195228],
                        [1.9128e-07, 5.77772013766, 213.8203602998],
                        [2.0871e-07, 5.79126331864, 2531.1349572528],
                        [1.9327e-07, 1.64147367403, 565.1156877467],
                        [1.6806e-07, 3.27953583323, 98.8999885246],
                        [2.0833e-07, 2.01655935909, 860.3099287528],
                        [1.7939e-07, 3.14329498012, 831.8557407496],
                        [1.5653e-07, 3.10137669623, 106.2741679563],
                        [1.8235e-07, 5.22595172482, 73.297125859],
                        [1.9302e-07, 5.9394711405, 425.1137181677],
                        [1.4514e-07, 2.75049388379, 1.2238402774],
                        [1.4562e-07, 5.18795088579, 305.3461693927],
                        [1.4254e-07, 3.88079504939, 54.1746707478],
                        [1.4594e-07, 3.25016810034, 78.7137518304],
                        [1.3637e-07, 2.55486219141, 405.2575498736],
                        [1.3914e-07, 1.72356993808, 69.1525242748],
                        [1.3689e-07, 2.37430586272, 125.9873238985],
                        [1.3496e-07, 0.82683590985, 99.9113804809],
                        [1.8483e-07, 0.73171264866, 9999.986450773],
                        [1.3542e-07, 3.58584380924, 234.6397364404],
                        [1.3741e-07, 6.18458356845, 245.5424243524],
                        [1.6944e-07, 0.72200792996, 2111.6503133776],
                        [1.7441e-07, 0.23803796878, 134.5853436076],
                        [1.4181e-07, 4.51963935804, 59.8037450403],
                        [1.3598e-07, 2.53776983965, 1.6969210294],
                        [1.224e-07, 2.11973445754, 28.3111756513],
                        [1.1988e-07, 1.62114832786, 1361.5467058442],
                        [1.1974e-07, 4.0737873512, 280.9671470045],
                        [1.2758e-07, 5.31146919749, 344.7030453079],
                        [1.6051e-07, 3.97093160336, 355.7487455718],
                        [1.1427e-07, 5.51123470805, 192.6921676185],
                        [1.3133e-07, 4.69168003518, 767.3690829208],
                        [1.4746e-07, 3.28998910617, 1589.0728952838],
                        [1.1417e-07, 1.81615681635, 2104.5367663768],
                        [1.1626e-07, 2.79410384978, 362.8622925726],
                        [1.3234e-07, 4.16642914717, 225.8292684102],
                        [1.0599e-07, 5.50554288376, 199.2844497575],
                        [1.0558e-07, 3.57501718639, 1.4362885985],
                        [1.0485e-07, 2.84462532686, 85.8272988312],
                        [1.0296e-07, 0.22225264071, 198.321241911],
                        [1.0552e-07, 0.18716643576, 217.491881132],
                        [1.1853e-07, 0.11584857323, 7.6348118626],
                        [1.0248e-07, 0.2190415417, 144.1465711632],
                        [1.0403e-07, 1.68776321208, 31.019488637],
                        [1.0313e-07, 4.72132701805, 216.2198567448],
                        [1.0719e-07, 2.60869377832, 339.2864193365],
                        [9.636e-08, 3.66746262954, 212.5483359126],
                        [9.631e-08, 3.34275630477, 223.5940361765],
                        [9.684e-08, 0.41556436593, 2634.2277314714],
                        [9.885e-08, 4.01798130416, 207.1487562837],
                        [1.3212e-07, 6.00683506785, 214.7835681463],
                        [1.1346e-07, 2.61898383052, 7.8643065262],
                        [9.158e-08, 5.39855118256, 342.2553647531],
                        [1.1882e-07, 4.00188476744, 267.4737661858],
                        [1.2054e-07, 3.59904816676, 124.433415221],
                        [8.921e-08, 4.22716773496, 6.3627874754],
                        [1.0142e-07, 3.60807025662, 14.0146456805],
                        [9.35e-08, 0.72255756005, 347.8844390456],
                        [1.0529e-07, 2.36779614951, 831.1049812242],
                        [8.587e-08, 4.48439552745, 1692.1656695024],
                        [1.0142e-07, 3.93620624488, 207.8824694666],
                        [9.147e-08, 4.28032835242, 312.4597163935],
                        [8.088e-08, 0.81225752596, 264.5048207692],
                        [9.241e-08, 4.26402650779, 20.6069278195],
                        [9.614e-08, 0.64291347187, 218.9281697305],
                        [8.537e-08, 0.48756672382, 1574.8458012822],
                        [7.986e-08, 4.71088791079, 333.657345044],
                        [8.951e-08, 0.90641577433, 497.4476361802],
                        [7.959e-08, 2.73277594136, 4.1446015842],
                        [9.133e-08, 5.08250578843, 241.6102710893],
                        [9.669e-08, 1.60623316904, 0.8937718773],
                        [8.883e-08, 5.55491009279, 2847.5268269094],
                        [8.926e-08, 5.80857835271, 329.7251917809],
                        [7.226e-08, 0.60164771281, 206.233732547],
                        [7.655e-08, 5.53676341721, 116.4260963429],
                        [7.118e-08, 0.18747501525, 209.106309744],
                        [7.507e-08, 5.43555636173, 621.7380390493],
                        [8.885e-08, 5.36210591059, 343.2185725996],
                        [7.056e-08, 0.41911130648, 756.3233826569],
                        [8.124e-08, 4.05571025939, 237.6781178262],
                        [8.964e-08, 1.6502392713, 210.3301500214],
                        [6.961e-08, 3.17855200943, 543.0242872189],
                        [8.916e-08, 0.56503620503, 2428.0421830342],
                        [6.926e-08, 3.66869171435, 247.2393453818],
                        [8.982e-08, 4.25046722481, 46.470422916],
                        [7.089e-08, 5.14399672225, 231.4583427027],
                        [7.381e-08, 1.25092810119, 217.964961884],
                        [7.134e-08, 2.83090354854, 1148.2476104062],
                        [6.353e-08, 0.82582711056, 31.492569389],
                        [7.558e-08, 5.62617378543, 518.6452648307],
                        [6.383e-08, 3.54809945181, 244.318584075],
                        [6.914e-08, 3.70012837706, 206.1373643274],
                        [6.286e-08, 5.79144749096, 179.3588454942],
                        [6.639e-08, 4.55197585824, 120.358249606],
                        [5.823e-08, 1.40737990571, 214.0498549634],
                        [5.85e-08, 4.86725483749, 320.3240229197],
                        [6.213e-08, 1.07959478499, 251.4321310758],
                        [7.73e-08, 3.82244175824, 380.12776796],
                        [5.716e-08, 1.34909972549, 1677.9385755008],
                        [6.469e-08, 1.34776801494, 188.9200730498],
                        [5.668e-08, 2.28643368177, 20.4468691251],
                        [6.092e-08, 3.62275289839, 1169.5882514086],
                        [5.711e-08, 0.51687421521, 148.0787244263],
                        [5.804e-08, 1.54831552984, 2420.9286360334],
                        [5.703e-08, 5.0599348323, 2.9689454166],
                        [5.913e-08, 1.66225477547, 842.1506814881],
                        [7.449e-08, 1.36195943673, 166.828672522],
                        [6.482e-08, 1.94032041024, 357.4456666012],
                        [6.368e-08, 2.44556930837, 654.1243803156],
                        [6.327e-08, 0.40654591365, 168.0525127994],
                        [5.573e-08, 2.69383455663, 750.1036075334],
                        [7.216e-08, 2.22547711392, 488.8496164711],
                        [6.701e-08, 6.03737590382, 160.6088973985],
                        [6.938e-08, 5.7836203441, 700.6642392008],
                        [6.701e-08, 3.14738404371, 491.8185618877],
                        [5.684e-08, 2.59531540359, 1.6445314027],
                        [4.9e-08, 2.03902856851, 0.8031491521],
                        [5.147e-08, 4.10182033298, 196.6243208816],
                        [4.985e-08, 2.96765983996, 258.8757464767],
                        [5.911e-08, 1.81507526918, 252.6559713532],
                        [6.056e-08, 3.33431010543, 182.279606801],
                        [6.195e-08, 5.01900871714, 273.1028404783],
                        [6.316e-08, 5.49053160191, 206.706813299],
                        [5.529e-08, 3.31498938717, 1905.4647649404],
                        [5.102e-08, 3.9817145361, 254.9435932136],
                        [4.762e-08, 2.24463685255, 635.9651330509],
                        [5.213e-08, 0.53609344278, 135.5485514541],
                        [4.639e-08, 0.04466373027, 213.1872208534],
                        [5.951e-08, 0.5456548749, 51.2057253312],
                        [4.535e-08, 0.16088614438, 2950.619601128],
                        [4.639e-08, 4.73769153591, 213.4109700226],
                        [4.716e-08, 3.13636467789, 28.5718080822],
                        [4.748e-08, 1.12156952989, 6.2197751235],
                        [5.735e-08, 0.04425142145, 348.8476468921],
                        [4.334e-08, 2.68814219154, 81.7521332162],
                        [4.538e-08, 3.83676888638, 487.3651437628],
                        [5.582e-08, 3.63486861028, 248.7238180901],
                        [4.106e-08, 3.39164360376, 50.4025761791],
                        [5.657e-08, 3.59967787362, 282.4516197128],
                        [5.145e-08, 1.33329458239, 173.6815870919],
                        [3.898e-08, 4.11804949361, 213.5115437591],
                        [3.898e-08, 0.66430577257, 213.0866471169],
                        [4.418e-08, 0.10784811796, 905.8865797915],
                        [4.935e-08, 2.19060382431, 189.7232222019],
                        [3.799e-08, 2.60752583205, 546.956440482],
                        [3.96e-08, 1.6033988901, 218.7157214094],
                        [3.74e-08, 3.30724497407, 274.0660483248],
                        [3.778e-08, 0.26606330942, 636.7158925763],
                        [4.657e-08, 0.37532078548, 2744.4340526908],
                        [3.682e-08, 5.11587898667, 458.8415197904],
                        [4.23e-08, 5.18313062329, 27.0873353739],
                        [5.181e-08, 3.75590784411, 3127.3133312618],
                        [3.904e-08, 2.21738744557, 358.9301393095],
                        [4.784e-08, 4.60666675927, 72.0732855816],
                        [3.552e-08, 3.23789349146, 543.9180590962],
                        [3.502e-08, 3.68869576093, 41.6444977756],
                        [4.803e-08, 4.73553427126, 240.3864308119],
                        [3.768e-08, 3.86077796242, 2008.557539159],
                        [3.68e-08, 5.36657425183, 10.0343083076],
                        [4.298e-08, 3.15595944154, 738.7972748386],
                        [3.388e-08, 0.73176365772, 11.3063326948],
                        [3.507e-08, 2.62508475661, 13.3333221243],
                        [3.552e-08, 0.28967392251, 1891.2376709388],
                        [3.604e-08, 4.6932409048, 295.0512286542],
                        [3.621e-08, 6.25264336426, 129.9194771616],
                        [3.334e-08, 5.04221806054, 153.4953503977],
                        [3.837e-08, 5.31732096284, 3163.918696566],
                        [3.281e-08, 5.59031570352, 2.0057375701],
                        [4.042e-08, 2.3708130809, 176.6505325085],
                        [3.5e-08, 2.5474426836, 1464.6394800628],
                        [4.144e-08, 5.46982520458, 6.9010986797],
                        [3.691e-08, 4.07518441665, 969.6224780949],
                        [3.947e-08, 4.27108449197, 181.806526049],
                        [3.867e-08, 5.4864338631, 37.8724032069],
                        [3.339e-08, 6.05372370584, 9.4011688612],
                        [3.484e-08, 5.81097824751, 13.4933808187],
                        [3.033e-08, 2.38897886651, 221.3758502853],
                        [2.99e-08, 4.13995939326, 66.70484372],
                        [3.746e-08, 5.29902286106, 561.1835344836],
                        [3.233e-08, 4.27743802321, 593.426863398],
                        [3.17e-08, 1.7540047777, 235.3904959658],
                        [4.114e-08, 2.01006788412, 601.7642506762],
                        [2.937e-08, 4.76351448561, 213.5597278689],
                        [2.932e-08, 1.83671373509, 501.3797894433],
                        [2.937e-08, 0.01884528825, 213.0384630071],
                        [3.268e-08, 4.44653949711, 60.7669528868],
                        [3.608e-08, 0.14307251176, 552.5855147745],
                        [2.947e-08, 0.74753671556, 17.5261078183],
                        [3.979e-08, 0.76931722276, 424.1505103212],
                        [2.803e-08, 1.07518176128, 1994.3304451574],
                        [2.905e-08, 1.27201007426, 2737.32050569],
                        [3.61e-08, 0.22394084, 121.2520214833],
                        [2.846e-08, 5.11748545179, 205.6642835754],
                        [3.156e-08, 2.74955723696, 494.2662424425],
                        [3.576e-08, 4.49826302447, 167.0893049529],
                        [2.746e-08, 0.66908290712, 7.0016724162],
                        [2.78e-08, 2.10066625279, 894.8408795276],
                        [2.875e-08, 2.39009721774, 151.0476698429],
                        [3.02e-08, 0.2547582689, 40.8413486235],
                        [2.731e-08, 3.74814908509, 429.0458714308],
                        [2.793e-08, 4.1793883723, 292.0128472684],
                        [2.706e-08, 5.34438894925, 327.4375699205],
                        [2.965e-08, 0.61653881148, 643.8294395771],
                        [2.616e-08, 4.8190138756, 681.5417840896],
                        [2.548e-08, 3.7816258082, 1485.9801210652],
                        [3.483e-08, 5.76091147029, 141.2258098564],
                        [3.257e-08, 0.75722680616, 555.5544601911],
                        [2.887e-08, 6.15899159727, 425.6349830295],
                        [2.45e-08, 1.29619859767, 193.655375465],
                        [3.401e-08, 2.48137843009, 43.2890291783],
                        [3.208e-08, 0.6600284234, 776.9303104764],
                        [2.435e-08, 4.58097103726, 477.8039162072],
                        [2.577e-08, 1.41538858001, 100.6450936638],
                        [2.6e-08, 3.73139519973, 17.4084877393],
                        [2.428e-08, 1.04400815278, 1279.794572628],
                        [2.569e-08, 5.36004101928, 7.2254215854],
                        [2.844e-08, 2.4722876765, 280.003939158],
                        [2.847e-08, 1.52706408796, 17.2654753874],
                        [2.461e-08, 2.73899140465, 172.2452984934],
                        [3.228e-08, 4.10258705369, 618.5566453116],
                        [2.288e-08, 0.18365494079, 426.6463749858],
                        [2.952e-08, 3.97748947007, 650.9429865779],
                        [2.653e-08, 0.14255829255, 162.8965192589],
                        [2.291e-08, 3.26940117011, 426.5500067662],
                        [3.118e-08, 2.80941831445, 2221.856634597],
                        [2.343e-08, 4.24349768377, 113.3877149571],
                        [2.78e-08, 4.36271946528, 130.4407420234],
                        [2.539e-08, 5.58396427573, 381.3516082374],
                        [2.673e-08, 2.74210116623, 45.5766510387],
                        [3.017e-08, 3.7220807074, 228.276948965],
                        [2.781e-08, 0.36312756349, 8.5980197091],
                        [2.377e-08, 4.49193242045, 25.1297819136],
                        [2.14e-08, 5.43424670725, 630.3360587584],
                        [2.456e-08, 1.71617205116, 313.6835566709],
                        [2.071e-08, 2.40453395841, 16.4623262353],
                        [2.05e-08, 6.19704773331, 3267.0114707846],
                        [2.764e-08, 0.40107063007, 219.4494345923],
                        [2.307e-08, 2.61462153778, 26.826702943],
                        [2.65e-08, 0.05892373791, 5856.4776591154],
                        [1.974e-08, 2.15890150781, 746.9222137957],
                        [1.949e-08, 3.13157993205, 226.6324175623],
                        [2.063e-08, 0.75916097286, 472.1748419147],
                        [2.172e-08, 1.41622302638, 23.5758732361],
                        [2.378e-08, 3.45446288811, 241.8709035202],
                        [2.314e-08, 2.92766120608, 170.7608257851],
                        [2.409e-08, 1.55291842382, 112.6540017742],
                        [2.092e-08, 4.33481587531, 210.5907824523],
                        [1.883e-08, 4.75777119721, 115.6229471908],
                        [1.963e-08, 5.63940648232, 454.9093665273],
                        [1.871e-08, 2.14579836453, 135.336103133],
                        [2.304e-08, 0.11816226543, 3060.8259223474],
                        [2.221e-08, 4.34506511014, 556.5176680376],
                        [1.867e-08, 5.70943358261, 19.1224551112],
                        [2.269e-08, 3.36100653157, 696.5196376166],
                        [2.127e-08, 0.4475492931, 216.0074084237],
                        [1.807e-08, 6.1542731617, 5.8415226136],
                        [2.213e-08, 3.42223891884, 533.6231183577],
                        [1.866e-08, 3.90535444843, 220.364458329],
                        [1.767e-08, 0.94232357739, 213.4591541324],
                        [1.767e-08, 3.84003619647, 213.1390367436],
                        [1.91e-08, 3.72504487558, 104.0559820651],
                        [1.75e-08, 0.82378244287, 220.4608265486],
                        [1.838e-08, 0.06310147657, 436.1594184316],
                        [2.146e-08, 4.41415180481, 184.0941479094],
                        [1.73e-08, 2.21039276178, 416.3032501375],
                        [1.715e-08, 0.26601715797, 103.1409583284],
                        [1.71e-08, 0.6351540758, 181.0557665236],
                        [2.307e-08, 3.29544714308, 569.0478410098],
                        [1.906e-08, 5.30639447218, 405.9912630565],
                        [1.863e-08, 4.68613642432, 286.596221297],
                        [1.873e-08, 2.26516020863, 1781.0313497194],
                        [2.035e-08, 3.85188859267, 672.1406152284],
                        [2.236e-08, 3.01959133214, 105.5404547734],
                        [1.767e-08, 1.45800271562, 16.6747745564],
                        [1.633e-08, 0.16030477876, 18.9100067901],
                        [2.116e-08, 2.90186702031, 486.4019359163],
                        [2.202e-08, 3.88125957017, 427.5613987225],
                        [1.706e-08, 3.35213628354, 103.0445901088],
                        [1.604e-08, 2.48973273967, 55.6591434561],
                        [1.744e-08, 1.83791106739, 1044.4040766622],
                        [1.569e-08, 6.10089581118, 106.0135355254],
                        [2.081e-08, 6.03810192844, 916.9322800554],
                        [1.799e-08, 5.01592570405, 731.9443602687],
                        [1.737e-08, 1.49651330833, 25.8634950965],
                        [1.695e-08, 3.53314158403, 627.3671133418],
                        [1.543e-08, 0.81384993001, 2310.722314814],
                        [1.896e-08, 3.38169845451, 2324.9494088156],
                        [1.926e-08, 4.66519027283, 353.301065017],
                        [1.765e-08, 5.14740716994, 107.2855599126],
                        [1.556e-08, 1.12431826916, 230.8252032563],
                        [1.843e-08, 0.02435960281, 102.1295663721],
                        [1.501e-08, 4.18415120927, 194.1766403268],
                        [1.528e-08, 1.00328674046, 3053.7123753466],
                        [1.529e-08, 5.58893570479, 212.0270710508],
                        [1.684e-08, 5.08547245125, 3480.3105662226],
                        [1.461e-08, 2.31020597821, 721.6494195302],
                        [1.48e-08, 5.34331643017, 418.5214360287],
                        [1.601e-08, 5.53623000915, 391.1734682239],
                        [1.893e-08, 3.62340803433, 204.7010757289],
                        [1.529e-08, 6.06535432009, 77.962992305],
                        [1.529e-08, 5.47660937625, 214.5711198252],
                        [1.552e-08, 2.06693539836, 36.6485629295],
                        [1.453e-08, 6.04709831442, 165.6048322446],
                        [1.393e-08, 2.2825336906, 403.0223176399],
                        [1.444e-08, 2.90650214018, 447.9388318784],
                        [1.924e-08, 1.37028714759, 468.2426886516],
                        [1.426e-08, 0.13255011458, 2207.6295405954],
                        [1.389e-08, 2.21739183113, 643.0786800517],
                        [1.365e-08, 1.63853880518, 629.6023455755],
                        [1.362e-08, 3.35131049142, 93.531546663],
                        [1.376e-08, 5.3698953845, 180.1619946463],
                        [1.584e-08, 0.85642767335, 271.4059194489],
                        [1.405e-08, 5.69231057947, 25.2727942655],
                        [1.681e-08, 5.30308110734, 835.0371344873],
                        [1.598e-08, 3.04233449432, 42.5382696529],
                        [1.759e-08, 3.5904306694, 508.3503240922],
                        [1.394e-08, 4.5507086329, 426.0769260142],
                        [1.314e-08, 1.81147178081, 1382.8873468466],
                        [1.281e-08, 4.2650838804, 123.5396433437],
                        [1.742e-08, 5.71133189432, 22.8945496799],
                        [1.483e-08, 1.84687831602, 289.5651667136],
                        [1.257e-08, 3.01131200921, 409.9234163196],
                        [1.285e-08, 4.41168551011, 558.0021407459],
                        [1.355e-08, 3.87115897452, 1802.3719907218],
                        [1.333e-08, 0.08474224795, 411.620337349],
                        [1.235e-08, 4.08060394635, 28.4541880032],
                        [1.373e-08, 5.06955106471, 427.1194557378],
                        [1.565e-08, 2.32953532704, 41.0537969446],
                        [1.656e-08, 6.06169130804, 268.4369740323],
                        [1.212e-08, 3.05966957556, 420.9691165835],
                        [1.238e-08, 5.25936700679, 412.5835451955],
                        [1.22e-08, 3.92987038126, 2.6601288759],
                        [1.552e-08, 1.48184004773, 9786.687355335],
                        [1.24e-08, 1.46716327302, 291.262087743],
                        [1.133e-08, 5.39046583617, 423.6774295692],
                        [1.319e-08, 5.79905891015, 1108.1399749656],
                        [1.329e-08, 0.92291650117, 778.4147831847],
                        [1.399e-08, 2.55906860098, 421.93232443],
                        [1.12e-08, 3.86777259232, 1033.3583763983],
                        [1.164e-08, 4.10048660918, 685.4739373527],
                        [1.321e-08, 1.45843550806, 1073.6090241908],
                        [1.313e-08, 0.11761534168, 71.8126531507],
                        [1.438e-08, 2.57741975416, 100.3844612329],
                        [1.19e-08, 5.63379509659, 5.1078094307],
                        [1.289e-08, 5.20604565993, 278.2588340188],
                        [1.157e-08, 5.00101860101, 230.5645708254],
                        [1.233e-08, 2.70207317014, 282.6640680339],
                        [1.209e-08, 4.02230498135, 980.6681783588],
                        [1.07e-08, 5.17569455055, 313.2104759189],
                        [1.292e-08, 4.30946655209, 219.891377577],
                        [1.399e-08, 2.58476795858, 2538.2485042536],
                        [1.038e-08, 0.1421219968, 820.0592809603],
                        [1.245e-08, 4.0827889713, 525.7588118315],
                        [1.254e-08, 2.46275017735, 457.617679513],
                        [1.021e-08, 1.11239421009, 69.3649725959],
                        [1.009e-08, 1.01709171385, 143.9341228421],
                        [1.075e-08, 2.39196853318, 48.7580447764],
                        [1.18e-08, 6.18938910429, 3377.217792004],
                        [9.89e-09, 5.94928603657, 3583.4033404412],
                        [9.72e-09, 4.25434114756, 397.3932433474],
                        [9.83e-09, 0.04442608551, 140.9651774255],
                        [9.72e-09, 5.67683107883, 422.405405182],
                        [1.298e-08, 1.34524469231, 875.830299001],
                        [1.19e-08, 0.67933974618, 699.7010313543],
                        [9.5e-09, 2.669643407, 92.3077063856],
                        [9.33e-09, 0.6300065658, 406.954470903],
                        [9.59e-09, 1.77556884452, 67.6680515665],
                        [1.185e-08, 3.70140604185, 285.6330134505],
                        [9.56e-09, 5.18928530992, 319.3126309634],
                        [1.014e-08, 1.97449310063, 2097.423219376],
                        [1.048e-08, 3.69659410655, 117.9105690512],
                        [1.153e-08, 2.53320305623, 104.5772469269],
                        [1.258e-08, 2.51536062507, 694.0719570618],
                        [9.71e-09, 5.19147635849, 240.125798381],
                        [9.4e-09, 3.94701776697, 35.212274331],
                        [1.047e-08, 6.1236097946, 238.9019581036],
                        [1.185e-08, 5.28289734361, 638.4128136057],
                        [8.93e-09, 0.95364488395, 14.8177948326],
                        [1.094e-08, 3.9300967924, 945.2434557067],
                        [9.49e-09, 3.46451925897, 443.8636662634],
                        [1.002e-08, 3.18639902867, 337.732510659],
                        [1.017e-08, 2.87111101661, 211.6021744086],
                        [8.75e-09, 0.58638080067, 2.2876218604],
                        [9.25e-09, 1.54981519784, 19.643719973],
                        [1.152e-08, 1.6852860859, 691.1030116452],
                        [8.32e-09, 2.64637256467, 436.8931316145],
                        [8.34e-09, 3.8891352157, 331.2096644892],
                        [8.25e-09, 2.1543787221, 739.8086667949],
                        [8.48e-09, 3.182632391, 196.0336200506],
                        [1.044e-08, 3.87842686803, 532.6117264014],
                        [8.46e-09, 5.38853773752, 97.6761482472],
                        [1.021e-08, 2.93075488512, 184.9879197867],
                        [8.43e-09, 6.12012061227, 616.3214130779],
                        [8.2e-09, 1.01380400969, 480.7728616238],
                        [8.42e-09, 3.56523575381, 421.1815649046],
                        [1.076e-08, 3.28234305253, 5.6772584023],
                        [8.08e-09, 2.78227865672, 212.0752551606],
                        [8.12e-09, 0.94281737163, 108.7218485111],
                        [8.08e-09, 2.21202653278, 610.6923387854],
                        [8.08e-09, 2.00008111713, 214.5229357154],
                        [8.75e-09, 2.14897461363, 114.3991069134],
                        [7.91e-09, 2.35474255596, 1.3725981237],
                        [9.6e-09, 0.25496742364, 710.7467316182],
                        [1.001e-08, 2.34471240227, 16.04163511],
                        [9.94e-09, 0.63700664871, 84.9335269539],
                        [9.85e-09, 2.63664920104, 395.578702239],
                        [8.74e-09, 2.59112594967, 418.0001711669],
                        [7.58e-09, 0.58117487362, 2627.1141844706],
                        [8.94e-09, 1.48976897396, 760.25553592],
                        [7.68e-09, 5.25095392845, 305.0855369618],
                        [1.02e-08, 2.73153988233, 268.9582388941],
                        [9.03e-09, 0.13224671457, 238.4288773516],
                        [7.5e-09, 0.76128043194, 724.8308132679],
                        [9.03e-09, 3.3710532337, 526.5095713569],
                        [9.3e-09, 2.8362259411, 2641.3412784722],
                        [8.08e-09, 5.23759255053, 216.2680408546],
                        [8.64e-09, 1.22059443823, 570.7447620392],
                        [7.98e-09, 3.72388187653, 124.5028511902],
                        [7.53e-09, 0.72747041757, 3370.1042450032],
                        [8.44e-09, 2.0325176781, 511.5317178299],
                        [8.27e-09, 4.49936223096, 444.7574381407],
                        [8.48e-09, 3.74330244183, 2118.7638603784],
                        [7.95e-09, 0.27939057139, 101.8689339412],
                        [7.54e-09, 5.68583497533, 662.531203563],
                        [7.5e-09, 4.78778128003, 102.5715093568],
                        [7.09e-09, 1.64518562815, 159.1244246902],
                        [7.7e-09, 4.0240499195, 909.8187330546],
                        [7.65e-09, 1.62693133597, 465.9550667912],
                        [9.11e-09, 5.04635658282, 913.9633346388],
                        [8.61e-09, 2.78971410809, 495.7507151508],
                        [6.88e-09, 1.10207467005, 1.536862335],
                        [8.03e-09, 4.3304391909, 453.424893819],
                        [6.73e-09, 0.03439333853, 2524.021410252],
                        [8.56e-09, 3.50639182375, 439.1283638482],
                        [6.84e-09, 3.93906807606, 337.8019466282],
                        [7.16e-09, 6.18909854987, 310.7146112543],
                        [9.22e-09, 1.7063420032, 125.1841747464],
                        [8.85e-09, 1.69955870744, 6283.0758499914],
                        [6.56e-09, 1.28102954508, 432.0148168474],
                        [8.08e-09, 1.64410808383, 299.1263942692],
                        [6.56e-09, 1.4944916462, 849.2642284889],
                        [6.79e-09, 4.0296298449, 429.5189521828],
                        [8.54e-09, 3.04068731741, 298.2326223919],
                        [6.76e-09, 2.17631477883, 576.1613880106],
                        [8.81e-09, 5.47733557925, 220.9339073006],
                        [7.39e-09, 5.85330901725, 938.1299087059],
                        [6.37e-09, 2.96294462433, 425.8474313506],
                        [6.65e-09, 1.62998758015, 221.1634019642],
                        [6.93e-09, 3.538716976, 1182.9215735329],
                        [6.59e-09, 1.85319023888, 72.3339180125],
                        [6.31e-09, 2.01234919422, 58.1068240109],
                        [8.06e-09, 5.21763933753, 428.0826635843],
                        [8.04e-09, 5.94281804567, 26.0235537909],
                        [6.79e-09, 2.1178446094, 256.4280659219],
                        [6.92e-09, 1.88791537515, 214.9960164674],
                        [7.31e-09, 1.95762888351, 19.0105805266],
                        [7.86e-09, 0.91252523635, 518.3846323998],
                        [6.84e-09, 4.89288171806, 3796.7024358792],
                        [6.12e-09, 2.08511492036, 1038.0412891868],
                        [5.98e-09, 3.48814927085, 219.6618829134],
                        [8.28e-09, 0.316894722, 25.6028626656],
                        [7.73e-09, 4.57524006328, 624.919432787],
                        [7.75e-09, 6.12920077021, 432.2272651685],
                        [8.2e-09, 4.1132032613, 141.4864422873],
                        [5.88e-09, 1.95775535412, 211.8628068395],
                        [6.61e-09, 5.30100397707, 103.6140390804],
                        [5.88e-09, 2.82460441973, 214.7353840365],
                        [6.51e-09, 5.56732715834, 393.4610900843],
                        [5.64e-09, 4.01666572198, 850.0149880143],
                        [6.57e-09, 2.58166087726, 526.9826521089],
                        [7.22e-09, 0.6849421948, 953.1077622329],
                        [5.92e-09, 2.3719066249, 205.4347889118],
                        [7.38e-09, 1.07981019512, 239.1625905345],
                        [5.9e-09, 6.03587790219, 188.0263011725],
                        [5.59e-09, 5.76010635813, 430.79097657],
                        [5.35e-09, 5.80499883199, 100.1720129118],
                        [6.11e-09, 5.954393601, 3693.6096616606],
                        [5.91e-09, 4.22379888536, 505.3119427064],
                        [6.91e-09, 2.96568305933, 606.7601855223],
                        [6.48e-09, 2.33387623043, 30.7588562061],
                        [5.44e-09, 2.21686115865, 92.7978334801],
                        [5.17e-09, 2.68282421083, 262.0571402144],
                        [5.63e-09, 1.69735688719, 2413.8150890326],
                        [5.69e-09, 2.85075508949, 227.3137411185],
                        [5.31e-09, 2.17713708433, 263.0203480609],
                        [5.04e-09, 4.44947885193, 343.7398374614],
                        [5.78e-09, 3.31462999801, 33.7278016227],
                        [6.19e-09, 1.83409636127, 867.4234757536],
                        [5.46e-09, 4.82201187196, 1048.3362299253],
                        [5.17e-09, 1.42016110098, 1246.6574718363],
                        [6.81e-09, 1.94124532036, 25874.6040461362],
                        [5.51e-09, 5.70617358907, 1119.1856752295],
                        [5.23e-09, 5.78878978812, 366.7944458357],
                        [4.86e-09, 1.90063955671, 1063.3140834523],
                        [5.52e-09, 3.64325031166, 256.5881246163],
                        [6.12e-09, 2.39349965241, 2854.6403739102],
                        [4.95e-09, 3.4683358124, 597.3590166611],
                        [6.22e-09, 1.86539391351, 524.0137066923],
                        [4.8e-09, 5.33557742428, 29.2049475286],
                        [4.92e-09, 4.64109549618, 384.0599212231],
                        [5.2e-09, 2.32171681836, 2957.7331481288],
                        [5.45e-09, 0.5327477871, 431.264057322],
                        [4.79e-09, 2.1332517724, 319.5732633943],
                        [5.26e-09, 4.17771910249, 136.0698163159],
                        [6.12e-09, 4.56148986681, 774.4826299216],
                        [6.42e-09, 3.25195912708, 67.8804998876],
                        [5.27e-09, 4.00299045889, 2435.155730035],
                        [5.24e-09, 4.69817741494, 336.8387387817],
                        [4.95e-09, 5.95703962647, 765.8846102125],
                        [4.63e-09, 6.097803226, 54.3347294422],
                        [5.38e-09, 0.22116216124, 450.9772132642],
                        [4.65e-09, 1.87487942848, 958.576777831],
                        [5e-09, 1.54084756342, 572.2292347475],
                        [5.28e-09, 3.54764543325, 233.9060232575],
                        [4.51e-09, 5.72664397006, 3899.7952100978],
                        [5.14e-09, 5.00509609437, 273.8536000037],
                        [4.71e-09, 2.96871670899, 306.830642101],
                        [4.47e-09, 1.87279400375, 62.038977274],
                        [4.56e-09, 5.4552199852, 1171.875873269],
                        [4.99e-09, 1.9282177853, 217.4436970222],
                        [5.48e-09, 3.21873307934, 824.7421937488],
                        [5.79e-09, 2.29424247924, 810.6581120991],
                        [5.5e-09, 0.6787519659, 315.1680293792],
                        [5.56e-09, 1.30277646899, 133.1008708993],
                        [4.49e-09, 6.05954557724, 141.6988906084],
                        [4.47e-09, 5.83737433218, 823.9914342234],
                        [5.17e-09, 3.62832879827, 934.9485149682],
                        [4.82e-09, 1.04855231956, 1055.4497769261],
                        [4.82e-09, 4.07207792722, 195.8906076987],
                        [4.28e-09, 0.65142455407, 427.3489504014],
                        [5.85e-09, 5.48406138684, 376.1956146969],
                        [4.69e-09, 3.87344294455, 320.5846553506],
                        [4.88e-09, 2.8352396426, 460.5384408198],
                        [4.5e-09, 4.30419652064, 88.1149206916],
                        [5.37e-09, 0.85582040238, 214.1928673153],
                        [4.38e-09, 1.32216133929, 963.4027029714],
                        [5.6e-09, 2.50374228728, 952.0963702766],
                        [4.42e-09, 2.80002649649, 209.1544938538],
                        [4.43e-09, 4.31062007978, 9992.8729037722],
                        [4.69e-09, 0.45235276525, 464.7312265138],
                        [4.88e-09, 0.35817443686, 36.9091953604],
                        [4.18e-09, 4.81080887468, 775.233389447],
                        [4.17e-09, 4.93943593579, 306.0969289181],
                        [4.83e-09, 3.9284792242, 39.6175083461],
                        [4.67e-09, 1.89153069484, 30.0562807905],
                        [4.1e-09, 5.52148731635, 118.0706277456],
                        [4.06e-09, 1.35991757653, 945.9942152321],
                        [4.46e-09, 4.0665611248, 380.3884003909],
                        [4.66e-09, 3.65954736664, 988.532484885],
                        [4.18e-09, 1.40185532806, 313.9441891018],
                        [4.81e-09, 1.80873987903, 43.1289704839],
                        [4.37e-09, 0.86746182155, 170.9732741062],
                        [4.83e-09, 4.49894122772, 46.2097904851],
                        [3.98e-09, 2.90977731924, 131.5469622218],
                        [5.29e-09, 3.74604329884, 699.1797664925],
                        [3.96e-09, 0.34033987778, 2943.5060541272],
                        [5.45e-09, 2.97400965609, 305.6068018236],
                        [4.12e-09, 3.81935995126, 84.3428261229],
                        [4.25e-09, 2.60672101181, 121.8427223143],
                        [4.74e-09, 2.41769418569, 838.218528225],
                        [4.57e-09, 1.27246488727, 107.7586406646],
                        [5.19e-09, 3.12247974037, 10213.285546211],
                        [4.95e-09, 4.63705386984, 301.4140161296],
                        [5.37e-09, 3.92653937147, 212.4053235607],
                        [3.85e-09, 3.3347632505, 806.725958836],
                        [4.77e-09, 1.66001855277, 175.4266922311],
                        [3.78e-09, 0.47722247042, 200.5564741447],
                        [4.59e-09, 5.14821844812, 960.2213092337],
                        [4.01e-09, 4.36420932544, 739.0579072695],
                        [4.67e-09, 2.96423984091, 170.0100662597],
                        [4.57e-09, 4.45829983338, 33.1371007917],
                        [4.76e-09, 3.63257697985, 20.4950532349],
                        [4.62e-09, 3.57494442856, 71.6002048296],
                        [3.76e-09, 2.94770389653, 6062.6632075526],
                        [4.73e-09, 5.32759318114, 373.9079928365],
                        [3.83e-09, 1.84111991862, 346.3999663373],
                        [3.66e-09, 2.05039240297, 87.3117715395],
                        [3.83e-09, 2.00608370504, 3274.1250177854],
                        [3.74e-09, 5.65444305031, 540.7366653585],
                        [4.1e-09, 5.62629715297, 58.319272332],
                        [4.41e-09, 6.26992749567, 378.9039276826],
                        [4.51e-09, 3.05920369737, 898.7730327907],
                        [3.71e-09, 5.65787287655, 89.7594520943],
                        [3.67e-09, 5.71998148487, 96.8729990951],
                        [4.1e-09, 1.06290837961, 1257.7031721002],
                        [4.18e-09, 2.03053179312, 146.594251718],
                        [4.92e-09, 0.89529424356, 423.6292454594],
                        [4.74e-09, 2.43080822444, 705.1176573257],
                        [4.57e-09, 3.42347802916, 829.6205085159],
                        [4.19e-09, 0.32183412086, 90.5626012464],
                        [3.47e-09, 3.6011680744, 449.232108125],
                        [3.97e-09, 2.29159647723, 782.3469364478],
                        [4.33e-09, 3.40938468811, 32.4557772355],
                        [3.43e-09, 4.30952656038, 401.3253966105],
                        [3.51e-09, 0.42160026295, 3686.4961146598],
                        [3.6e-09, 5.83204569879, 491.5579294568],
                        [3.89e-09, 2.73429108352, 36.1754821775],
                        [4.34e-09, 0.33664392528, 55.1378785943],
                        [3.46e-09, 5.09191837323, 392.6579409322],
                        [3.36e-09, 2.38696934868, 295.1942410061],
                        [3.36e-09, 1.56832822829, 233.7459645631],
                        [4e-09, 3.08774286568, 745.9108218394],
                        [4.68e-09, 4.21298903633, 832.5894539325],
                        [4e-09, 1.32415028336, 551.1010420662],
                        [3.44e-09, 1.52193307438, 754.8389099486],
                        [4.33e-09, 3.06696455642, 885.4397106664],
                        [3.46e-09, 4.7697143387, 4113.0943055358],
                        [3.29e-09, 3.31034285904, 952.3570027075],
                        [4.25e-09, 2.90590905341, 462.0229135281],
                        [3.42e-09, 5.87738962422, 561.934294009],
                        [4.39e-09, 0.20791179302, 768.8535556291],
                        [3.3e-09, 2.08599193524, 614.6244920485],
                        [3.94e-09, 3.59805431851, 1261.6353253633],
                        [3.69e-09, 6.03075127328, 199.8057146193],
                        [3.75e-09, 2.56075851331, 732.6951197941],
                        [4.08e-09, 0.69233617038, 328.2407190726],
                        [3.31e-09, 4.2833330937, 541.5398145106],
                        [3.23e-09, 0.06694179304, 433.7599219866],
                        [4.31e-09, 4.5060334092, 2914.0142358238],
                        [3.43e-09, 2.18898146246, 80.1982245387],
                        [4.37e-09, 5.34124436008, 387.2413149608],
                        [3.71e-09, 4.82569229712, 103.3534066495],
                        [3.18e-09, 3.75720880396, 749.2098356561],
                        [3.44e-09, 0.70749566894, 229.9738699944],
                        [3.12e-09, 6.02741985422, 361.3778198643],
                        [3.4e-09, 0.64358874512, 303.8616966844],
                        [3.94e-09, 0.49801994278, 248.4631856592],
                        [3.09e-09, 5.83535487659, 236.1936451179],
                        [3.25e-09, 2.65292455786, 757.2171545342],
                        [3.65e-09, 0.56788400592, 402.2191684878],
                        [3.42e-09, 3.83450185886, 519.3960243561],
                        [3.06e-09, 0.35126074897, 354.9979860464],
                        [3.14e-09, 5.42086935152, 1151.4290041439],
                        [3.84e-09, 0.09367760642, 201.5196819912],
                        [3.07e-09, 5.62165090342, 426.4863162914],
                        [3.01e-09, 1.78550205039, 1354.4331588434],
                        [3e-09, 5.23426324539, 190.4045457581],
                        [2.96e-09, 3.15801280224, 192.8522263129],
                        [3.81e-09, 1.98600461808, 109.9456887885],
                        [3.7e-09, 5.57659190517, 562.1467423301],
                        [3.05e-09, 2.73187068494, 840.6662087798],
                        [3.74e-09, 3.73375594662, 420.4478517217],
                        [3.07e-09, 4.03149340189, 426.7100654606],
                        [3.2e-09, 1.426651801, 2730.2069586892],
                        [3.92e-09, 0.143432949, 206.3979967583],
                        [2.88e-09, 2.44787565138, 623.2225117576],
                        [3.44e-09, 1.57825843162, 6290.1893969922],
                        [3.17e-09, 1.84490263693, 214.9436268407],
                        [3.46e-09, 2.16849893508, 3171.0322435668],
                        [2.86e-09, 1.01623455966, 315.6411101312],
                        [3.61e-09, 3.44807605339, 259.769518354],
                        [2.8e-09, 4.64272946177, 254.1404440615],
                        [2.85e-09, 2.09430258387, 335.1418177523],
                        [2.81e-09, 4.72136141979, 317.142629182],
                        [2.89e-09, 4.70265740009, 29.7474642498],
                        [2.9e-09, 2.74360609522, 551.031606097],
                        [3e-09, 5.23308974173, 1321.4390704036],
                        [2.83e-09, 1.21193797828, 1699.2792165032],
                        [2.8e-09, 0.45877292284, 38.6061163898],
                        [2.73e-09, 1.81952809851, 1056.2005364515],
                        [3.36e-09, 5.63115066542, 95.2284676924],
                        [3.09e-09, 3.33676739908, 1193.9672737968],
                        [2.88e-09, 2.57603349418, 1166.4068576709],
                        [2.77e-09, 3.35359995343, 532.8723588323],
                        [2.87e-09, 0.37229115993, 114.9416236346],
                        [2.74e-09, 4.21164027953, 90.8232336773],
                        [2.67e-09, 5.61367132586, 870.4618571394],
                        [3.76e-09, 6.14391456675, 913.0001267923],
                        [2.96e-09, 5.75705165982, 4010.0015313172],
                        [3.04e-09, 1.97982468634, 495.9631634719],
                        [3.08e-09, 5.08911712262, 481.7360694703],
                        [2.65e-09, 0.02893016561, 172.4577468145],
                        [2.91e-09, 2.10106037916, 619.2903584945],
                        [2.73e-09, 4.78343050572, 771.3012361839],
                        [3.58e-09, 0.04093867464, 637.4496057592],
                        [2.72e-09, 5.86505586319, 332.1728723357],
                        [2.66e-09, 3.28626000731, 560.7104537316],
                        [3.12e-09, 3.91213951915, 1226.2106027112],
                        [2.58e-09, 3.41185135958, 426.8106391971],
                        [2.57e-09, 1.06772454181, 714.6788848813],
                        [2.58e-09, 6.24129294573, 426.3857425549],
                        [2.56e-09, 0.75289096697, 103.843533744],
                        [2.54e-09, 3.21116652124, 102.3420146932],
                        [2.54e-09, 6.14632777985, 620.253566341],
                        [2.66e-09, 2.54280196709, 132.8884225782],
                        [3.14e-09, 0.31303204249, 991.7138786227],
                        [3.17e-09, 2.93589163442, 357.2332182801],
                        [2.66e-09, 6.1228063667, 57.5161231799],
                        [2.54e-09, 2.99730079627, 642.3449668688],
                        [2.67e-09, 5.54663413439, 628.5909536192],
                        [3.48e-09, 1.33319249154, 815.0633461142],
                        [2.78e-09, 5.5957374192, 334.5511169213],
                        [3.03e-09, 3.22789148979, 409.1897031367],
                        [2.46e-09, 3.90430259983, 441.576044403],
                        [2.6e-09, 3.8635529353, 639.3760214522],
                        [2.5e-09, 0.07635434166, 2840.4132799086],
                        [2.46e-09, 5.71009371698, 476.3194434989],
                        [3.01e-09, 6.15272106984, 559.6990617753],
                        [2.68e-09, 3.73809606804, 658.0565335787],
                        [3.16e-09, 4.63035287047, 745.277682393],
                        [3.11e-09, 3.51827727424, 2751.5475996916],
                        [2.39e-09, 0.51133317457, 1041.2226829245],
                        [2.38e-09, 5.4634727942, 4216.1870797544],
                        [2.62e-09, 3.20254407166, 1251.3403846248],
                        [2.38e-09, 1.02679111743, 1262.3860848887],
                        [2.77e-09, 3.32996713394, 545.4719677737],
                        [2.71e-09, 0.49229846069, 419.532827985],
                        [3.03e-09, 3.77087511317, 285.3723810196],
                        [2.34e-09, 3.64328189368, 407.4757357648],
                        [2.7e-09, 3.93080966194, 313.4711083498],
                        [3.02e-09, 3.15201610429, 915.235359026],
                        [2.64e-09, 0.46127639727, 720.8986600048],
                        [2.35e-09, 1.74238582338, 369.0820676961],
                        [2.84e-09, 5.20345848078, 395.105621487],
                        [2.95e-09, 5.03016292492, 594.6507036754],
                        [2.9e-09, 1.94941528794, 907.3710524998],
                        [2.29e-09, 0.11049722694, 3259.8979237838],
                        [3.04e-09, 1.81516929363, 49.7212526229],
                        [2.68e-09, 5.54944666204, 12352.8526045448],
                        [2.48e-09, 4.39993603541, 385.5443939314],
                        [2.34e-09, 1.63365119249, 3590.516887442],
                        [3.17e-09, 4.74907646809, 420.005908737],
                        [2.28e-09, 4.89094697746, 1181.4371008246],
                        [2.58e-09, 2.41510535278, 550.1378342197],
                        [2.36e-09, 4.10002766188, 6467.9257579616],
                        [2.49e-09, 1.97767956861, 589.4947101349],
                        [2.26e-09, 1.60308230318, 316.279995072],
                        [2.86e-09, 6.10513234736, 484.7050148869],
                        [2.99e-09, 3.71741328977, 1123.1178284926],
                        [2.63e-09, 1.85502475341, 608.877797677],
                        [2.2e-09, 0.94624116595, 316.5037442412],
                        [2.92e-09, 3.12099513976, 47.6942631934],
                        [2.17e-09, 4.93010394323, 281.1795953256],
                        [2.95e-09, 3.18346450625, 1050.9963588012],
                        [2.48e-09, 5.48523310249, 638.9340784675],
                        [2.76e-09, 1.09325899753, 544.5087599272],
                        [2.79e-09, 2.65446123759, 134.1122628556],
                        [2.47e-09, 4.17284927352, 950.1388168163],
                        [2.12e-09, 2.45582771491, 1164.7623262682],
                        [2.66e-09, 2.30028827109, 314.9073969483],
                        [2.15e-09, 3.55148746518, 1097.0942747017],
                        [2.23e-09, 0.36862624591, 81.8951455681],
                        [2.83e-09, 0.35013012349, 1269.4996318895],
                        [2.63e-09, 0.58255768951, 386.9806825299],
                        [2.08e-09, 4.61303945066, 668.2084619653],
                        [2.22e-09, 4.51639912193, 304.1223291153],
                        [2.74e-09, 0.63572336701, 679.2541622292],
                        [2.15e-09, 0.74685271552, 1008.9793540101],
                        [2.68e-09, 3.43326489941, 598.8434893694],
                        [2.71e-09, 3.98364990268, 453.6855262499],
                        [2.15e-09, 2.24139383226, 661.2379273164],
                        [2.64e-09, 2.58516335032, 2527.2028039897],
                        [2.05e-09, 1.94472028389, 650.1922270525],
                        [2.58e-09, 1.50724315598, 1759.8337210689],
                        [2.72e-09, 6.27135287672, 990.2294059144],
                        [2.01e-09, 1.11891338895, 97.4155158163],
                        [2.36e-09, 4.13547185065, 348.635198571],
                        [2.01e-09, 2.67485193508, 1546.5346256309],
                        [2.5e-09, 5.44391862722, 1254.5217783625],
                        [2.03e-09, 5.48660442144, 557.0389328994],
                        [2.5e-09, 0.32142312427, 25448.0058552602],
                        [1.98e-09, 0.91019549387, 1310.3933701397],
                        [2e-09, 0.90438804926, 47.061123747],
                        [1.94e-09, 4.05730813129, 426.8588233069],
                        [1.97e-09, 0.58292199999, 156.6767441354],
                        [1.97e-09, 2.5938418852, 639.8491022042],
                        [2.01e-09, 1.49980256114, 827.9235874865],
                        [1.97e-09, 5.79126360809, 639.9454704238],
                        [2.66e-09, 1.45514683392, 109.2431133729],
                        [2.39e-09, 4.63640382863, 868.7167520002],
                        [1.94e-09, 5.59582424111, 426.3375584451],
                        [2.47e-09, 2.91348766248, 689.6185389369],
                        [2.05e-09, 1.04616771894, 448.6895914038],
                        [2.32e-09, 1.76503818816, 354.2642728635],
                        [2.24e-09, 3.45391027762, 1190.0351205337],
                        [2.21e-09, 6.27951545913, 1596.1864422846],
                        [2.37e-09, 1.24961141369, 882.9438460018],
                        [2.06e-09, 5.17010664247, 253.4591205053],
                        [2.03e-09, 0.25518217825, 4002.8879843164],
                        [2.45e-09, 3.94368773869, 769.8167634756],
                        [2.55e-09, 6.1179075155, 763.4369296577],
                        [1.94e-09, 2.83197251801, 263.7016716171],
                        [2.37e-09, 2.1400737388, 2700.7151403858],
                        [2.03e-09, 3.00078001542, 1385.174968707],
                        [2.03e-09, 3.88000057282, 419.4364597654],
                        [1.86e-09, 4.79530535895, 843.6351541964],
                        [2.03e-09, 0.16707173895, 535.9107402181],
                        [2.45e-09, 0.76762638475, 5643.1785636774],
                        [1.83e-09, 2.20151176434, 35.1640902212],
                        [2.42e-09, 3.41613986919, 864.2420820159],
                        [2.49e-09, 3.47840802421, 1045.8885493705],
                        [1.99e-09, 4.70077509959, 1276.6131788903],
                        [1.89e-09, 1.8424761039, 434.6749457233],
                        [1.92e-09, 3.83148077309, 666.723989257],
                        [2.01e-09, 1.34290804373, 1012.9115072732],
                        [2.1e-09, 5.12097279511, 3494.5376602242],
                        [1.92e-09, 1.36630036429, 904.4021070832],
                        [1.95e-09, 1.62629576534, 364.3467652809],
                        [1.79e-09, 1.6650299905, 244.791664827],
                        [1.86e-09, 4.55663748319, 347.4113582936],
                        [2.01e-09, 0.5021968074, 36.3879304986],
                        [1.79e-09, 4.55153097409, 97.4636999261],
                        [2e-09, 0.68398141887, 2015.6710861598],
                        [1.95e-09, 2.20599546209, 66.1835788582],
                        [1.86e-09, 4.48925201018, 611.4430983108],
                        [1.86e-09, 3.13663606153, 433.663553767],
                        [1.77e-09, 3.62811326217, 326.6868103951],
                        [2.06e-09, 0.38552475035, 857.1285350151],
                        [2.29e-09, 1.22330638216, 2906.900688823],
                        [2.13e-09, 6.08436923028, 271.61836777],
                        [1.74e-09, 6.18833529233, 3576.2897934404],
                        [2.2e-09, 2.89866380776, 322.6116447801],
                        [2.02e-09, 2.43755817264, 812.1425848074],
                        [2.11e-09, 4.27999470527, 1127.2624300768],
                        [1.88e-09, 0.97173474238, 1080.7225711916],
                        [1.68e-09, 0.65008064023, 1493.093668066],
                        [2.08e-09, 4.68942071563, 5429.8794682394],
                        [1.82e-09, 0.76058628096, 504.561183181],
                        [1.67e-09, 6.22608046965, 108.50940019],
                        [1.76e-09, 2.08816807487, 670.916774951],
                        [1.7e-09, 1.55680702386, 1670.8250285],
                        [1.87e-09, 4.12687876136, 9985.7593567714],
                        [1.66e-09, 1.5859635437, 1379.7059531089],
                        [1.7e-09, 1.30946662341, 837.6972633632],
                        [1.66e-09, 0.02413278965, 224.6054281328],
                        [2.04e-09, 6.12072939658, 9360.089164459],
                        [1.89e-09, 0.28191962964, 1175.8080265321],
                        [1.84e-09, 2.8746109364, 398.1440028728],
                        [1.72e-09, 5.41410693088, 2306.7901615509],
                        [1.74e-09, 0.94052578814, 632.0329797878],
                        [1.81e-09, 2.20017945285, 1049.0869894507],
                        [1.76e-09, 1.0985763266, 531.978586955],
                        [2.01e-09, 2.68411933635, 795.6802585721],
                        [1.97e-09, 1.43444932583, 347.3631741838],
                        [2e-09, 4.33954193534, 1364.7280995819],
                        [1.66e-09, 2.8393687284, 3553.9115221378],
                        [1.6e-09, 1.28778451384, 962.5089310941],
                        [2.06e-09, 3.02518737424, 1141.1340634054],
                        [2e-09, 5.54644533685, 308.3151148093],
                        [1.58e-09, 4.7546243761, 1534.7381658416],
                        [1.56e-09, 3.42359004405, 241.7532834412],
                        [1.82e-09, 5.26192506263, 968.1380053866],
                        [1.68e-09, 0.3705510874, 10007.0999977738],
                        [1.74e-09, 4.61279044571, 223.3334037456],
                        [1.58e-09, 4.23116519562, 821.703812363],
                        [2.12e-09, 5.98406058023, 432.7485300303],
                        [1.6e-09, 4.08093018212, 632.7355552034],
                        [1.79e-09, 5.74376301842, 924.0458270562],
                        [1.85e-09, 3.01715709315, 55.8715917772],
                        [1.85e-09, 0.75718598244, 1286.9081196288],
                        [1.7e-09, 3.46903106526, 1304.9243545416],
                        [1.67e-09, 3.19767851189, 635.231419868],
                        [1.53e-09, 3.8300620821, 318.679491517],
                        [1.56e-09, 1.61558494091, 110.2545053292],
                        [2.06e-09, 1.62702696825, 389.9496279465],
                        [1.84e-09, 3.31730160238, 1578.0271950199],
                        [1.84e-09, 6.19913208096, 731.6837278378],
                        [1.58e-09, 5.58628906712, 42.3258213318],
                        [1.59e-09, 2.00727485442, 702.1487119091],
                        [1.55e-09, 0.02889842368, 1357.6145525811],
                        [1.51e-09, 5.80616069064, 680.0573113813],
                        [1.57e-09, 5.67235483479, 77837.1112338466],
                        [1.56e-09, 2.78001360754, 1567.7322542814],
                        [2.03e-09, 5.91820261629, 971.1069508032],
                        [1.56e-09, 5.68482948401, 649.4585138696],
                        [1.86e-09, 5.72093247348, 664.2763087022],
                        [1.84e-09, 4.05878767739, 976.7360250957],
                        [1.59e-09, 3.10978439502, 230.7075831773],
                        [1.54e-09, 4.54479813612, 1239.5439248355],
                        [1.77e-09, 4.68148789757, 2921.1277828246],
                        [1.58e-09, 4.30854435851, 633.7469471597],
                        [1.95e-09, 5.33376523453, 1130.2313754934],
                        [1.88e-09, 2.04023570497, 1127.0499817557],
                        [1.74e-09, 2.88817750136, 25668.418497699],
                        [1.61e-09, 2.9630000889, 152.7445908723],
                        [1.7e-09, 1.7077956077, 493.303034596],
                        [1.56e-09, 3.05331862578, 913.7508863177],
                        [1.69e-09, 3.18325334507, 757.8078553652],
                        [1.45e-09, 0.8967219869, 632.831923423],
                        [1.49e-09, 2.69519361988, 203.2647871304],
                        [1.67e-09, 2.96547549589, 1201.831580323],
                        [1.87e-09, 3.17592113403, 842.9014410135],
                        [1.73e-09, 1.9152883635, 3487.4241132234],
                        [1.54e-09, 0.37169915171, 285.1117485887],
                        [1.98e-09, 3.14620903981, 640.8604941605],
                        [1.43e-09, 3.42760427364, 520.129737539],
                        [1.57e-09, 2.34913118792, 5959.570433334],
                        [1.78e-09, 5.34566184657, 272.5815756165],
                        [1.71e-09, 3.34185265551, 3067.9394693482],
                        [1.71e-09, 4.87848878292, 354.5249052944],
                        [1.89e-09, 0.07069084691, 1585.8915015461],
                        [1.37e-09, 1.28925665885, 214.1022445901],
                        [1.37e-09, 3.494384829, 212.4959462859],
                        [1.74e-09, 3.07450555579, 64.9597385808],
                        [1.81e-09, 0.78652249647, 657.1627617014],
                        [1.58e-09, 2.93809799392, 211.6545640353],
                        [1.33e-09, 5.70724173596, 469.7271613599],
                        [1.4e-09, 0.35530248121, 219.5188705615],
                        [1.32e-09, 1.60614108449, 1372.5924061081],
                        [1.64e-09, 1.68236348359, 707.5653378805],
                        [1.28e-09, 1.49742950959, 45.2465826386],
                        [1.32e-09, 4.98075995751, 238.5718897035],
                        [1.4e-09, 3.62845435388, 423.8898778903],
                        [1.34e-09, 1.41837795083, 3906.9087570986],
                        [1.27e-09, 1.48966646069, 856.3777754897],
                        [1.58e-09, 2.57990141197, 369.9758395734],
                        [1.32e-09, 2.39662455993, 184.7272873558],
                        [1.4e-09, 4.36785639279, 207.0793203145],
                        [1.57e-09, 4.56655940808, 251.1714986449],
                        [1.25e-09, 4.60433583965, 6076.8903015542],
                        [1.21e-09, 1.59513269211, 184.8449074348],
                        [1.45e-09, 5.85121885906, 221.8971151471],
                        [1.37e-09, 0.76499603885, 476.1069951778],
                        [1.39e-09, 6.02467582226, 429.3065038617],
                        [1.17e-09, 0.23611722307, 426.7582495704],
                        [1.17e-09, 3.13382984215, 426.4381321816],
                        [1.16e-09, 4.3480144872, 418.9633790134],
                        [1.35e-09, 2.69789181467, 455.1699989582],
                        [1.34e-09, 1.19058772772, 502.8642621516],
                        [1.23e-09, 3.97560160218, 499.895316735],
                        [1.1e-09, 2.37032413718, 439.9315130003],
                        [1.09e-09, 6.20303291896, 220.3007678542],
                        [1.09e-09, 1.38979633175, 325.9530972122],
                        [1.15e-09, 0.05845336809, 631.8205314667],
                        [1.39e-09, 2.21086387259, 9573.388259897],
                        [1.42e-09, 6.14666228712, 3340.6124266998],
                        [1.22e-09, 4.77182119272, 604.4725636619],
                        [1.19e-09, 3.03461367061, 528.2064923863],
                        [1.27e-09, 2.97263950543, 498.9321088885],
                        [1.11e-09, 5.01192320232, 220.2001941177],
                        [1.26e-09, 3.95743516129, 566.600160455],
                        [9.8e-10, 2.36210526249, 634.2682120215],
                        [1.08e-09, 2.46872857126, 83.3796182764],
                        [1.01e-09, 4.88259474274, 425.3261664888],
                        [1.27e-09, 4.89006771254, 162.0933701068],
                        [9.9e-10, 0.90073463816, 586.3133163972],
                        [9.9e-10, 0.16310526294, 394.3548619616],
                        [1.15e-09, 0.49160291262, 517.1607921224],
                        [1.01e-09, 3.86043866859, 198.1087935899],
                        [1.05e-09, 3.48222097813, 5863.5912061162],
                        [1.04e-09, 4.61148354671, 220.5245170234],
                        [1.01e-09, 4.77041950285, 427.8702152632],
                        [9.8e-10, 2.90784721214, 199.9657733137],
                        [1.27e-09, 0.14136936897, 2332.0629558164],
                        [9.1e-10, 6.22628300117, 211.2933578679],
                        [1e-09, 5.14847283436, 226.7924762567],
                        [9.1e-10, 4.84054379386, 215.3048330081],
                        [9.9e-10, 4.375834924, 640.4185511758],
                        [9.3e-10, 5.30395179617, 222.7002642992],
                        [8.6e-10, 4.57481701854, 636.9765250072],
                        [1.11e-09, 0.61102669309, 1089.129394439],
                        [8.6e-10, 4.50969293872, 625.8826406335],
                        [8.8e-10, 0.36828594935, 444.1242986943],
                        [9.3e-10, 5.76287499885, 203.8979265768],
                        [8.2e-10, 2.85558603378, 318.8395502114],
                        [8.2e-10, 5.19618475111, 1467.8208738005],
                        [8.6e-10, 0.97633784601, 200.0352092829],
                        [8.2e-10, 4.78557953017, 195.7729876197],
                        [1.06e-09, 2.29520624233, 799.6124118352],
                        [8.1e-10, 3.57727166766, 205.9731001161],
                        [7.8e-10, 5.5034351258, 262.8078997398],
                        [8.7e-10, 0.76830756075, 201.9927627432],
                        [1.02e-09, 2.11516755277, 206.9363079626],
                        [8.1e-10, 5.29639775054, 111.1695290659],
                        [7.5e-10, 2.77117107886, 255.8373650909],
                        [7.4e-10, 5.81587984729, 316.4400537664],
                        [7.6e-10, 1.78743197928, 171.6545976624],
                        [9.4e-10, 4.99996904753, 378.6432952517],
                        [8.9e-10, 5.85818860151, 807.9497991134],
                        [7.2e-10, 0.99858616883, 280.2163874791],
                        [9.9e-10, 0.15018241445, 186.2117600641],
                        [7.2e-10, 5.15715918322, 110.1581371096],
                      ],
          },
          {
            series => "L1",
            terms  => [
                        [213.54295595986, 0, 0],
                        [0.01296855005, 1.82820544701, 213.299095438],
                        [0.00564347566, 2.88500136429, 7.1135470008],
                        [0.0009832303, 1.08070061328, 426.598190876],
                        [0.0010767877, 2.27769911872, 206.1855484372],
                        [0.00040254586, 2.0412825709, 220.4126424388],
                        [0.00019941734, 1.27954662736, 103.0927742186],
                        [0.00010511706, 2.748803928, 14.2270940016],
                        [6.939233e-05, 0.40493079985, 639.897286314],
                        [4.803325e-05, 2.44194097666, 419.4846438752],
                        [4.056325e-05, 2.92166618776, 110.2063212194],
                        [3.76863e-05, 3.6496563146, 3.9321532631],
                        [3.384684e-05, 2.41694251653, 3.1813937377],
                        [3.3022e-05, 1.26256486715, 433.7117378768],
                        [3.071382e-05, 2.3273931775, 199.0720014364],
                        [1.953036e-05, 3.563946833, 11.0457002639],
                        [1.249348e-05, 2.62803737519, 95.9792272178],
                        [9.21683e-06, 1.9608983425, 227.5261894396],
                        [7.05587e-06, 4.4168924933, 529.6909650946],
                        [6.49654e-06, 6.17418093659, 202.2533951741],
                        [6.27603e-06, 6.11088227167, 309.2783226558],
                        [4.86843e-06, 6.03998200305, 853.196381752],
                        [4.68377e-06, 4.61707843907, 63.7358983034],
                        [4.78501e-06, 4.98776987984, 522.5774180938],
                        [4.1701e-06, 2.11708169277, 323.5054166574],
                        [4.0763e-06, 1.29949556676, 209.3669421749],
                        [3.43826e-06, 3.95854178574, 412.3710968744],
                        [3.39724e-06, 3.63396398752, 316.3918696566],
                        [3.35936e-06, 3.77173072712, 735.8765135318],
                        [3.31933e-06, 2.86077699882, 210.1177017003],
                        [3.52489e-06, 2.31707079463, 632.7837393132],
                        [2.89429e-06, 2.73263080235, 117.3198682202],
                        [2.65801e-06, 0.54344631312, 647.0108333148],
                        [2.30493e-06, 1.64428879621, 216.4804891757],
                        [2.80911e-06, 5.74398845416, 2.4476805548],
                        [1.91667e-06, 2.96512946582, 224.3447957019],
                        [1.72891e-06, 4.07695221044, 846.0828347512],
                        [1.67131e-06, 2.59745202658, 21.3406410024],
                        [1.36328e-06, 2.28580246629, 10.2949407385],
                        [1.31364e-06, 3.44108355646, 742.9900605326],
                        [1.27838e-06, 4.09533471247, 217.2312487011],
                        [1.08862e-06, 6.16141072262, 415.5524906121],
                        [9.3909e-07, 3.48397279899, 1052.2683831884],
                        [9.2482e-07, 3.94755499926, 88.865680217],
                        [9.7584e-07, 4.72845436677, 838.9692877504],
                        [8.66e-07, 1.21951325061, 440.8252848776],
                        [8.3463e-07, 3.11269504725, 625.6701923124],
                        [7.7588e-07, 6.24408938835, 302.164775655],
                        [6.1557e-07, 1.82789612597, 195.1398481733],
                        [6.19e-07, 4.29344363385, 127.4717966068],
                        [6.7106e-07, 0.28961738595, 4.665866446],
                        [5.6919e-07, 5.01889578112, 137.0330241624],
                        [5.416e-07, 5.12628572382, 490.3340891794],
                        [5.4585e-07, 0.28356341456, 74.7815985673],
                        [5.1425e-07, 1.45766406064, 536.8045120954],
                        [6.5843e-07, 5.64757042732, 9.5612275556],
                        [5.778e-07, 2.47630552035, 191.9584544356],
                        [4.4444e-07, 2.70873627665, 5.4166259714],
                        [4.6799e-07, 1.1772121105, 149.5631971346],
                        [4.038e-07, 3.88870105683, 728.762966531],
                        [3.7768e-07, 2.53379013859, 12.5301729722],
                        [4.6649e-07, 5.14818326902, 515.463871093],
                        [4.5891e-07, 2.23198878761, 956.2891559706],
                        [4.04e-07, 0.4128152044, 269.9214467406],
                        [3.7191e-07, 3.78239026411, 2.9207613068],
                        [3.3778e-07, 3.21070688046, 1368.660252845],
                        [3.7969e-07, 0.6466596718, 422.6660376129],
                        [3.2857e-07, 0.30063884563, 351.8165923087],
                        [3.305e-07, 5.43038091186, 1066.49547719],
                        [3.0276e-07, 2.84067004928, 203.0041546995],
                        [3.5116e-07, 6.08421794089, 5.6290742925],
                        [2.9667e-07, 3.39052569135, 1059.3819301892],
                        [3.3217e-07, 4.64063092111, 277.0349937414],
                        [3.1876e-07, 4.3862292377, 1155.361157407],
                        [2.8913e-07, 2.02614760507, 330.6189636582],
                        [2.8264e-07, 2.74178953996, 265.9892934775],
                        [3.0089e-07, 6.18684614308, 284.1485407422],
                        [3.1329e-07, 2.43455855525, 52.6901980395],
                        [2.6493e-07, 4.51214170121, 340.7708920448],
                        [2.1983e-07, 5.14437352579, 4.192785694],
                        [2.223e-07, 1.96481952451, 203.7378678824],
                        [2.0824e-07, 6.16048095923, 860.3099287528],
                        [2.169e-07, 2.67578768862, 942.062061969],
                        [2.2552e-07, 5.88579123, 210.8514148832],
                        [1.9807e-07, 2.31345263487, 437.6438911399],
                        [1.9447e-07, 4.76573277668, 70.8494453042],
                        [1.931e-07, 4.10209060369, 18.1592472647],
                        [2.2662e-07, 4.13732273379, 191.2076949102],
                        [1.8209e-07, 0.90310796389, 429.7795846137],
                        [1.7667e-07, 1.84954766042, 234.6397364404],
                        [1.7547e-07, 2.44735118493, 423.4167971383],
                        [1.5428e-07, 4.23790088205, 1162.4747044078],
                        [1.4608e-07, 3.59713247857, 1045.1548361876],
                        [1.4111e-07, 2.94262468353, 1685.0521225016],
                        [1.6328e-07, 4.05665272725, 949.1756089698],
                        [1.3348e-07, 6.2450959224, 38.1330356378],
                        [1.5918e-07, 1.06434204938, 56.6223513026],
                        [1.4059e-07, 1.43503954068, 408.4389436113],
                        [1.3093e-07, 5.75815864257, 138.5174968707],
                        [1.5772e-07, 5.59350835225, 6.1503391543],
                        [1.4962e-07, 5.77192239389, 22.0914005278],
                        [1.6024e-07, 1.93900586533, 1272.6810256272],
                        [1.6751e-07, 5.96673627422, 628.8515860501],
                        [1.2843e-07, 4.24658666814, 405.2575498736],
                        [1.3628e-07, 4.09892958087, 1471.7530270636],
                        [1.5067e-07, 0.74142807591, 200.7689224658],
                        [1.0961e-07, 1.55022573283, 223.5940361765],
                        [1.1695e-07, 1.81237511034, 124.433415221],
                        [1.0346e-07, 3.46814088412, 1375.7737998458],
                        [1.2056e-07, 1.85655834555, 131.4039498699],
                        [1.0123e-07, 2.38221133049, 107.0249274817],
                        [9.855e-08, 3.95166998848, 430.5303441391],
                        [9.803e-08, 2.55389483994, 99.9113804809],
                        [1.0614e-07, 5.36692189034, 215.7467759928],
                        [1.208e-07, 4.84549317054, 831.8557407496],
                        [1.021e-07, 6.0769296137, 32.2433289144],
                        [9.245e-08, 3.6541746727, 142.4496501338],
                        [8.984e-08, 1.23808405498, 106.2741679563],
                        [9.336e-08, 5.81062768434, 7.1617311106],
                        [9.717e-08, 1.38703872827, 145.6310438715],
                        [8.394e-08, 4.42341211111, 703.6331846174],
                        [8.37e-08, 5.64015188458, 62.2514255951],
                        [8.244e-08, 2.42225929772, 1258.4539316256],
                        [7.784e-08, 0.52562994711, 654.1243803156],
                        [7.626e-08, 3.75258725596, 312.1990839626],
                        [7.222e-08, 0.28429555677, 0.7507595254],
                        [8.236e-08, 6.22250515902, 14.977853527],
                        [7.054e-08, 0.5317781074, 388.4651552382],
                        [6.567e-08, 3.48657341701, 35.4247226521],
                        [9.011e-08, 4.9491962691, 208.633228992],
                        [8.98e-08, 0.08138173719, 288.0806940053],
                        [6.421e-08, 3.32905264657, 1361.5467058442],
                        [6.489e-08, 2.89389587598, 114.1384744825],
                        [6.244e-08, 0.54973852782, 65.2203710117],
                        [6.154e-08, 2.67885860584, 2001.4439921582],
                        [6.742e-08, 0.23586769279, 8.0767548473],
                        [7.297e-08, 4.85321224483, 222.8603229936],
                        [6.302e-08, 3.80651124694, 1788.1448967202],
                        [5.824e-08, 4.39327457448, 81.7521332162],
                        [6.102e-08, 0.88585782895, 92.0470739547],
                        [6.914e-08, 2.04631426723, 99.1606209555],
                        [5.363e-08, 5.47995103139, 563.6312150384],
                        [5.172e-08, 2.11968421583, 214.2623032845],
                        [5.117e-08, 5.76987684107, 565.1156877467],
                        [6.197e-08, 1.625536888, 1589.0728952838],
                        [4.97e-08, 0.41949366126, 76.2660712756],
                        [6.64e-08, 5.82582210639, 483.2205421786],
                        [5.277e-08, 4.57975789757, 134.5853436076],
                        [4.974e-08, 4.20243895902, 404.5067903482],
                        [5.15e-08, 4.67582673243, 212.3358875915],
                        [4.764e-08, 4.59303997414, 554.0699874828],
                        [4.573e-08, 3.24875415786, 231.4583427027],
                        [4.811e-08, 0.46206327592, 362.8622925726],
                        [5.148e-08, 3.33570646174, 1.4844727083],
                        [4.654e-08, 5.80233066659, 217.964961884],
                        [4.509e-08, 5.37581684215, 497.4476361802],
                        [4.443e-08, 0.11349392292, 295.0512286542],
                        [4.943e-08, 3.78020789259, 1265.5674786264],
                        [4.211e-08, 4.8830602196, 98.8999885246],
                        [4.252e-08, 5.00120115113, 213.3472795478],
                        [4.774e-08, 4.53259894142, 1148.2476104062],
                        [3.911e-08, 0.58582192963, 750.1036075334],
                        [5.069e-08, 2.20305668335, 207.8824694666],
                        [3.553e-08, 0.35374030841, 333.657345044],
                        [3.771e-08, 0.98542435766, 24.3790223882],
                        [3.458e-08, 1.84990273999, 225.8292684102],
                        [3.401e-08, 5.31342401626, 347.8844390456],
                        [3.347e-08, 0.21414641376, 635.9651330509],
                        [3.637e-08, 1.61315058382, 245.5424243524],
                        [3.416e-08, 2.19551489078, 1574.8458012822],
                        [3.655e-08, 0.8054424569, 343.2185725996],
                        [4.26e-08, 1.80258750109, 213.2509113282],
                        [3.11e-08, 3.03815175282, 1677.9385755008],
                        [3.052e-08, 1.33858964447, 543.9180590962],
                        [3.694e-08, 0.81606028298, 344.7030453079],
                        [3.016e-08, 3.36219319026, 7.8643065262],
                        [2.937e-08, 4.86927342776, 144.1465711632],
                        [2.768e-08, 2.42707131609, 2317.8358618148],
                        [3.059e-08, 4.30820099442, 6062.6632075526],
                        [3.65e-08, 5.12802531219, 218.9281697305],
                        [2.963e-08, 3.53480751374, 2104.5367663768],
                        [3.23e-08, 2.88057019783, 216.2198567448],
                        [2.984e-08, 2.52971310583, 1692.1656695024],
                        [2.897e-08, 5.7325648224, 9992.8729037722],
                        [2.591e-08, 3.79880285744, 17.2654753874],
                        [3.495e-08, 5.29902525443, 350.3321196004],
                        [2.859e-08, 3.72804950659, 6076.8903015542],
                        [2.775e-08, 0.23549396237, 357.4456666012],
                        [2.976e-08, 2.48769315964, 46.470422916],
                        [2.487e-08, 4.3786807853, 217.491881132],
                        [2.711e-08, 5.1537684015, 10007.0999977738],
                        [3.127e-08, 1.92343235583, 17.4084877393],
                        [3.181e-08, 1.72419900322, 1169.5882514086],
                        [2.348e-08, 0.77373103004, 414.0680179038],
                        [2.606e-08, 3.4283691344, 31.019488637],
                        [2.556e-08, 0.91735028377, 479.2883889155],
                        [2.399e-08, 4.82440545738, 1279.794572628],
                        [2.245e-08, 3.76323995584, 425.1137181677],
                        [3.02e-08, 0.25310250109, 120.358249606],
                        [2.503e-08, 2.10679832121, 168.0525127994],
                        [2.564e-08, 1.63158205055, 182.279606801],
                        [2.221e-08, 3.15472373256, 212.7778305762],
                        [2.357e-08, 2.33145013714, 218.7157214094],
                        [2.51e-08, 4.51903989011, 198.321241911],
                        [2.715e-08, 5.76330259543, 618.5566453116],
                        [2.204e-08, 3.35952557362, 160.6088973985],
                        [2.648e-08, 0.71962005233, 85.8272988312],
                        [2.029e-08, 5.28642331696, 125.9873238985],
                        [2.497e-08, 1.36671447252, 1905.4647649404],
                        [2.017e-08, 1.11498225426, 447.9388318784],
                        [2.052e-08, 1.27587874735, 14.0146456805],
                        [2.254e-08, 3.2244767419, 273.1028404783],
                        [2.014e-08, 0.39787014152, 358.9301393095],
                        [1.981e-08, 2.33696859021, 28.4541880032],
                        [2.197e-08, 5.93386789705, 13.3333221243],
                        [2.237e-08, 3.64433751164, 213.8203602998],
                        [1.93e-08, 1.8567174034, 1.2720243872],
                        [2.037e-08, 5.05300562628, 424.1505103212],
                        [1.994e-08, 1.35690802366, 20.6069278195],
                        [1.911e-08, 3.44106886717, 69.1525242748],
                        [1.925e-08, 3.75243031545, 28.3111756513],
                        [2.297e-08, 4.24557050896, 1464.6394800628],
                        [2.117e-08, 2.25897766314, 116.4260963429],
                        [1.847e-08, 5.40631472802, 31.492569389],
                        [1.841e-08, 1.56916484272, 650.9429865779],
                        [1.884e-08, 6.27233535258, 25.1297819136],
                        [1.96e-08, 4.8948401484, 275.5505210331],
                        [2.016e-08, 5.45791785675, 842.1506814881],
                        [2.282e-08, 4.9627694744, 258.8757464767],
                        [1.709e-08, 3.99098237135, 416.3032501375],
                        [2.176e-08, 0.00746756006, 0.8937718773],
                        [1.634e-08, 5.30978165487, 251.4321310758],
                        [1.687e-08, 0.41586020065, 54.1746707478],
                        [1.91e-08, 2.5982575579, 329.7251917809],
                        [2.113e-08, 2.56582292726, 59.8037450403],
                        [1.921e-08, 2.42279051938, 113.3877149571],
                        [1.658e-08, 5.4732365154, 1073.6090241908],
                        [1.59e-08, 2.7754529735, 1994.3304451574],
                        [1.936e-08, 3.47558926847, 1581.959348283],
                        [1.649e-08, 1.82779010589, 128.9562693151],
                        [1.598e-08, 1.718064653, 129.9194771616],
                        [1.967e-08, 1.25160413795, 621.7380390493],
                        [1.702e-08, 1.910761028, 278.5194664497],
                        [1.569e-08, 0.16491194947, 643.0786800517],
                        [1.989e-08, 5.28799230992, 508.3503240922],
                        [1.52e-08, 0.56950979689, 320.3240229197],
                        [1.501e-08, 1.99815894193, 1891.2376709388],
                        [1.532e-08, 3.27362317849, 2420.9286360334],
                        [1.701e-08, 2.72041261115, 767.3690829208],
                        [1.561e-08, 6.09424459628, 280.9671470045],
                        [1.331e-08, 4.2094444379, 546.956440482],
                        [1.381e-08, 2.0676810083, 192.6921676185],
                        [1.368e-08, 6.28049502257, 1795.258443721],
                        [1.519e-08, 2.20299556153, 2008.557539159],
                        [1.356e-08, 4.01521042413, 721.6494195302],
                        [1.296e-08, 4.84815978742, 45.5766510387],
                        [1.267e-08, 5.28146654999, 173.9422195228],
                        [1.402e-08, 6.1295155155, 39.3568759152],
                        [1.252e-08, 2.19169926554, 2634.2277314714],
                        [1.466e-08, 4.16354845643, 26.826702943],
                        [1.285e-08, 3.76170874847, 2.2876218604],
                        [1.5e-08, 5.41022492529, 214.0498549634],
                        [1.396e-08, 4.78595583428, 219.4494345923],
                        [1.43e-08, 0.70934745161, 254.9435932136],
                        [1.195e-08, 3.71281085322, 264.5048207692],
                        [1.181e-08, 0.42635230882, 41.6444977756],
                        [1.19e-08, 2.02079286787, 1485.9801210652],
                        [1.16e-08, 5.23649231796, 181.0557665236],
                        [1.535e-08, 3.62746990294, 561.1835344836],
                        [1.12e-08, 1.0912792213, 6.592282139],
                        [1.1e-08, 0.27844612141, 184.0941479094],
                        [1.227e-08, 1.3996968127, 209.106309744],
                        [1.353e-08, 6.12903657666, 207.6700211455],
                        [1.124e-08, 6.05105541765, 291.262087743],
                        [1.194e-08, 4.79565407023, 1478.8665740644],
                        [1.082e-08, 4.73602931755, 78.7137518304],
                        [1.202e-08, 3.47301104146, 51.2057253312],
                        [1.298e-08, 2.34761557822, 210.3783341312],
                        [1.166e-08, 4.20037524355, 417.0369633204],
                        [1.228e-08, 3.94985981275, 1781.0313497194],
                        [1.401e-08, 2.41318931513, 636.7158925763],
                        [1.009e-08, 6.17414889934, 2111.6503133776],
                        [1.084e-08, 3.68958647346, 274.0660483248],
                        [1.068e-08, 0.80258823981, 436.8931316145],
                        [1.007e-08, 3.4279250886, 629.6023455755],
                        [9.98e-09, 5.57130056835, 205.2223405907],
                        [1.058e-08, 1.05742945779, 237.6781178262],
                        [1.02e-08, 3.336672903, 166.828672522],
                        [9.65e-09, 6.08359503243, 601.7642506762],
                        [1.005e-08, 3.56310748091, 643.8294395771],
                        [9.87e-09, 0.97129012811, 305.3461693927],
                        [9.27e-09, 3.87717400791, 135.336103133],
                        [1.129e-08, 5.94840103961, 196.6243208816],
                        [1.118e-08, 5.25415059584, 189.7232222019],
                        [1.2e-08, 1.16671933467, 2221.856634597],
                        [9.09e-09, 2.14001565047, 617.8058857862],
                        [8.99e-09, 2.31811625712, 312.4597163935],
                        [1.081e-08, 0.91006048421, 313.2104759189],
                        [8.91e-09, 3.74923531791, 916.9322800554],
                        [8.86e-09, 4.76066858907, 776.9303104764],
                        [9.12e-09, 0.99592540858, 491.8185618877],
                        [8.8e-09, 3.67349449376, 25.2727942655],
                        [1.203e-08, 1.3974926741, 337.732510659],
                        [8.67e-09, 0.11684071625, 267.4737661858],
                        [8.79e-09, 6.12222682852, 867.4234757536],
                        [1.08e-08, 0.15038819285, 175.1660598002],
                        [9.88e-09, 3.12456192471, 214.7835681463],
                        [8.89e-09, 4.70508769146, 148.0787244263],
                        [8.27e-09, 6.08977582217, 488.8496164711],
                        [8.89e-09, 5.05124166027, 220.4608265486],
                        [8.28e-09, 6.27262544155, 1382.8873468466],
                        [1.04e-08, 5.76735098196, 501.3797894433],
                        [1.103e-08, 0.4870647723, 692.5874843535],
                        [8.1e-09, 2.5036238508, 2310.722314814],
                        [8.5e-09, 4.55410385197, 77.962992305],
                        [1.108e-08, 5.31792012163, 235.3904959658],
                        [7.9e-09, 0.89213206336, 342.2553647531],
                        [7.75e-09, 2.85873930879, 211.8146227297],
                        [8.42e-09, 2.99884993009, 2737.32050569],
                        [7.84e-09, 0.0574845924, 543.0242872189],
                        [7.54e-09, 5.18317747668, 244.318584075],
                        [9.69e-09, 1.31760425414, 486.4019359163],
                        [9.43e-09, 5.48641674428, 339.2864193365],
                        [7.59e-09, 6.25347177163, 151.0476698429],
                        [7.1e-09, 2.4161996881, 247.2393453818],
                        [7.94e-09, 2.59522645936, 1.6445314027],
                        [8.57e-09, 1.99318788624, 248.7238180901],
                        [7.17e-09, 4.56798357445, 121.2520214833],
                        [6.71e-09, 2.50955477476, 444.7574381407],
                        [6.83e-09, 5.51033310275, 487.3651437628],
                        [6.84e-09, 0.01892628603, 228.276948965],
                        [6.65e-09, 1.47172657769, 427.5613987225],
                        [7.61e-09, 4.61079808671, 23.5758732361],
                        [8.07e-09, 3.2151371812, 1898.3512179396],
                        [6.45e-09, 1.92436523628, 2950.619601128],
                        [6.24e-09, 6.05830190539, 241.6102710893],
                        [6.99e-09, 4.02804515616, 425.6349830295],
                        [6.24e-09, 5.85966148394, 696.5196376166],
                        [6.2e-09, 1.86426453489, 2207.6295405954],
                        [6.41e-09, 5.69868017561, 319.5732633943],
                        [6.46e-09, 3.78920578728, 1038.0412891868],
                        [6.72e-09, 2.54160055954, 271.4059194489],
                        [7.68e-09, 1.80484245332, 2324.9494088156],
                        [7.37e-09, 1.50539891226, 268.4369740323],
                        [8.36e-09, 1.2658381101, 212.5483359126],
                        [7.53e-09, 5.2753616624, 204.7010757289],
                        [6.33e-09, 2.19920009577, 1802.3719907218],
                        [7.2e-09, 2.58587107868, 472.1748419147],
                        [6.83e-09, 3.8322386642, 43.2890291783],
                        [7.4e-09, 6.21601938401, 556.5176680376],
                        [7.95e-09, 1.14460330178, 381.3516082374],
                        [6.78e-09, 3.65930963429, 2097.423219376],
                        [5.68e-09, 5.9215866109, 2428.0421830342],
                        [5.7e-09, 1.18024241664, 131.5469622218],
                        [5.66e-09, 4.74157739398, 380.12776796],
                        [5.86e-09, 5.71168743146, 570.7447620392],
                        [5.5e-09, 4.92413290959, 188.9200730498],
                        [7.12e-09, 2.69456114358, 16.6747745564],
                        [5.45e-09, 5.387255296, 206.233732547],
                        [5.72e-09, 5.79167804981, 195.8906076987],
                        [6.02e-09, 5.81756794592, 963.4027029714],
                        [5.88e-09, 4.25026865253, 426.6463749858],
                        [5.63e-09, 3.28295055824, 193.655375465],
                        [5.83e-09, 5.44099997963, 526.5095713569],
                        [6.79e-09, 4.45748326743, 105.5404547734],
                        [5.16e-09, 5.99843937287, 289.5651667136],
                        [5.2e-09, 2.19322568805, 180.1619946463],
                        [5.43e-09, 4.19333695628, 213.1872208534],
                        [5.86e-09, 3.03470168346, 6275.9623029906],
                        [5.72e-09, 3.96788877624, 140.001969579],
                        [6.11e-09, 4.1539223987, 436.1594184316],
                        [5.05e-09, 2.95739392583, 135.5485514541],
                        [5.87e-09, 4.55320395537, 5863.5912061162],
                        [4.92e-09, 2.71595874382, 84.9335269539],
                        [5.76e-09, 5.98300938454, 9793.8009023358],
                        [4.89e-09, 5.68450383182, 533.6231183577],
                        [5.19e-09, 3.09688510923, 327.4375699205],
                        [4.86e-09, 5.24220804875, 5849.3641121146],
                        [4.75e-09, 4.51295931678, 411.620337349],
                        [5.4e-09, 4.44843952768, 10206.1719992102],
                        [4.79e-09, 0.87707794164, 207.1487562837],
                        [4.68e-09, 0.46572028197, 306.0969289181],
                        [5.86e-09, 0.86387928244, 2538.2485042536],
                        [4.75e-09, 6.19152982788, 397.3932433474],
                        [5.41e-09, 1.47958133221, 42.5382696529],
                        [4.96e-09, 6.07879620658, 576.1613880106],
                        [4.47e-09, 2.59259132013, 7.2254215854],
                        [4.45e-09, 5.0682730047, 778.4147831847],
                        [5.6e-09, 0.00461017471, 221.3758502853],
                        [4.56e-09, 4.60143715337, 710.7467316182],
                        [4.49e-09, 5.79223649465, 685.4739373527],
                        [5.01e-09, 1.91370965325, 831.1049812242],
                        [5.95e-09, 4.90329839607, 824.7421937488],
                        [4.47e-09, 4.88662794571, 429.0458714308],
                        [4.45e-09, 1.74764943142, 525.7588118315],
                        [4.57e-09, 0.8089271253, 458.8415197904],
                        [5.43e-09, 2.60317945475, 213.4109700226],
                        [4.93e-09, 0.61947189193, 41.0537969446],
                        [4.55e-09, 2.69847252264, 3053.7123753466],
                        [4.29e-09, 3.89071982978, 92.7978334801],
                        [4.11e-09, 1.34981168865, 27.0873353739],
                        [4.48e-09, 1.84775051361, 980.6681783588],
                        [4.45e-09, 4.21745990439, 905.8865797915],
                        [4.03e-09, 2.33067250642, 2627.1141844706],
                        [4.04e-09, 5.00179215709, 431.264057322],
                        [3.84e-09, 1.65634584042, 241.7532834412],
                        [4.1e-09, 0.76907037678, 395.578702239],
                        [4.56e-09, 1.98353741244, 213.5115437591],
                        [4.59e-09, 2.04878772547, 285.6330134505],
                        [3.96e-09, 5.04141834913, 298.2326223919],
                        [3.77e-09, 5.68073822097, 2744.4340526908],
                        [4.15e-09, 4.41600504868, 179.3588454942],
                        [3.96e-09, 4.2987285195, 206.706813299],
                        [3.89e-09, 5.69091953122, 849.2642284889],
                        [3.69e-09, 1.36192003466, 835.0371344873],
                        [3.74e-09, 0.41402282126, 9779.5738083342],
                        [3.79e-09, 1.72255764532, 184.9879197867],
                        [3.65e-09, 5.88205574821, 19.643719973],
                        [4.56e-09, 4.81297899859, 213.0866471169],
                        [3.59e-09, 1.06819138836, 206.1373643274],
                        [3.67e-09, 1.14184327929, 569.0478410098],
                        [3.52e-09, 3.04388401587, 638.4128136057],
                        [4.63e-09, 1.55834877017, 421.1815649046],
                        [4.59e-09, 5.34648461645, 699.7010313543],
                        [3.83e-09, 4.05921035379, 739.8086667949],
                        [3.54e-09, 1.09760553168, 738.7972748386],
                        [3.82e-09, 0.05348541587, 252.6559713532],
                        [3.44e-09, 1.18536656224, 439.1283638482],
                        [3.82e-09, 2.10483762147, 532.6117264014],
                        [3.61e-09, 0.50215018154, 50.4025761791],
                        [3.51e-09, 3.49546336297, 1354.4331588434],
                        [3.95e-09, 4.2627887156, 432.2272651685],
                        [3.45e-09, 2.38455893509, 426.0769260142],
                        [3.5e-09, 1.51541607946, 259.769518354],
                        [4.26e-09, 5.29998227949, 934.9485149682],
                        [3.39e-09, 5.59774645356, 519.3960243561],
                        [3.88e-09, 3.40083809779, 2413.8150890326],
                        [3.24e-09, 3.68352014131, 72.0732855816],
                        [3.23e-09, 1.79597508586, 405.9912630565],
                        [3.66e-09, 3.56764349139, 1119.1856752295],
                        [3.58e-09, 4.11241839677, 37.8724032069],
                        [4.23e-09, 1.45116702108, 2641.3412784722],
                        [3.14e-09, 0.68465789313, 757.2171545342],
                        [3.2e-09, 3.12697568936, 945.9942152321],
                        [3.38e-09, 4.89782013581, 898.7730327907],
                        [3.19e-09, 5.76881401291, 69.3649725959],
                        [3.1e-09, 5.35598720822, 815.0633461142],
                        [3.69e-09, 4.46143610142, 421.93232443],
                        [3.11e-09, 2.19275640712, 5856.4776591154],
                        [3.06e-09, 2.99917010799, 1130.2313754934],
                        [3.3e-09, 0.64102961163, 558.0021407459],
                        [3.05e-09, 0.40963115602, 661.2379273164],
                        [3.2e-09, 3.2926731994, 760.25553592],
                        [2.98e-09, 5.48693246086, 702.1487119091],
                        [3.52e-09, 2.18179692198, 2118.7638603784],
                        [2.99e-09, 5.94980651345, 572.2292347475],
                        [3.43e-09, 2.6290008365, 213.5597278689],
                        [2.96e-09, 4.12563821701, 73.297125859],
                        [3.6e-09, 2.94387423457, 2214.7430875962],
                        [2.93e-09, 5.71837797264, 60.7669528868],
                        [3.26e-09, 1.93806509331, 480.7728616238],
                        [3.35e-09, 2.60120542851, 518.3846323998],
                        [3.22e-09, 2.89685459163, 427.1194557378],
                        [3.67e-09, 2.2048984833, 518.6452648307],
                        [3.61e-09, 3.31464351282, 630.3360587584],
                        [2.88e-09, 0.8776047815, 887.7273325268],
                        [2.9e-09, 0.24071300709, 705.1176573257],
                        [3.32e-09, 5.96464701829, 100.6450936638],
                        [2.84e-09, 1.58760551116, 681.5417840896],
                        [2.81e-09, 1.68339116394, 3267.0114707846],
                        [2.87e-09, 3.54730637851, 756.3233826569],
                        [3.31e-09, 2.74250642576, 22.8945496799],
                        [2.81e-09, 4.79802388453, 409.9234163196],
                        [3.72e-09, 1.08754087151, 426.5500067662],
                        [3.4e-09, 0.59629116557, 627.3671133418],
                        [3.25e-09, 4.07319450014, 511.5317178299],
                        [2.73e-09, 0.71334827688, 305.0855369618],
                        [2.72e-09, 1.76124839309, 945.2434557067],
                        [2.95e-09, 4.00327005783, 432.7485300303],
                        [2.71e-09, 5.28903262032, 1080.7225711916],
                        [2.76e-09, 3.89192411657, 610.6923387854],
                        [2.94e-09, 2.80121651058, 724.8308132679],
                        [3.19e-09, 5.24824059915, 229.9738699944],
                        [2.64e-09, 2.36406383589, 731.9443602687],
                        [2.88e-09, 4.6781884493, 170.7608257851],
                        [3.26e-09, 3.81328980623, 525.4981794006],
                        [2.83e-09, 3.52027709716, 319.3126309634],
                        [2.64e-09, 0.25871603855, 494.2662424425],
                        [2.61e-09, 4.08135671345, 25.8634950965],
                        [2.96e-09, 4.49129913731, 693.5506922],
                        [2.92e-09, 0.65370180027, 25867.4904991354],
                        [2.92e-09, 0.12510953311, 25881.717593137],
                        [2.54e-09, 4.03912322565, 990.2294059144],
                        [2.88e-09, 3.98604904657, 707.7777862016],
                        [2.85e-09, 1.92328297431, 3134.4268782626],
                        [2.84e-09, 2.45411523294, 3120.199784261],
                        [2.56e-09, 3.6328275778, 430.79097657],
                        [2.83e-09, 2.51091647682, 286.596221297],
                        [3.25e-09, 4.33261281211, 732.6951197941],
                        [2.64e-09, 0.05450228136, 650.1922270525],
                        [2.73e-09, 4.90735780421, 409.1897031367],
                        [3.04e-09, 4.61759348542, 468.2426886516],
                        [2.85e-09, 5.7246790389, 33.9402499438],
                        [2.42e-09, 5.28336514054, 403.0223176399],
                        [2.7e-09, 0.51583145648, 263.7016716171],
                        [2.63e-09, 4.81670787366, 1055.4497769261],
                        [2.37e-09, 2.92617048443, 913.9633346388],
                        [2.46e-09, 2.19675150666, 2943.5060541272],
                        [2.78e-09, 4.58404840578, 398.1440028728],
                        [2.34e-09, 2.64374114605, 739.0579072695],
                        [2.29e-09, 3.80445074468, 58.1068240109],
                        [3e-09, 2.06111081979, 429.5189521828],
                        [2.23e-09, 3.39888651505, 188.0263011725],
                        [3.01e-09, 2.96411385108, 624.919432787],
                        [2.21e-09, 1.79137414078, 2524.021410252],
                        [2.2e-09, 0.95686592581, 1894.4190646765],
                        [2.25e-09, 4.30669421945, 637.4496057592],
                        [2.14e-09, 1.70442143644, 658.0565335787],
                        [2.27e-09, 3.22613053351, 638.9340784675],
                        [2.2e-09, 2.66798936385, 953.1077622329],
                        [2.53e-09, 3.09377787768, 29.2049475286],
                        [2.44e-09, 3.15828383212, 7.0016724162],
                        [2.95e-09, 4.95843934543, 714.6788848813],
                        [2.09e-09, 0.94525938634, 864.2420820159],
                        [2.16e-09, 0.1222123618, 28.5718080822],
                        [2.14e-09, 2.80190604605, 373.9079928365],
                        [2.12e-09, 2.07343849515, 1357.6145525811],
                        [2.16e-09, 1.25531205533, 477.8039162072],
                        [2.06e-09, 5.35971491902, 3060.8259223474],
                        [2.04e-09, 3.0857941046, 67.6680515665],
                        [2.1e-09, 1.91489853604, 938.1299087059],
                        [2.09e-09, 1.46554109301, 952.3570027075],
                        [2.02e-09, 3.57670882297, 334.5511169213],
                        [2.28e-09, 5.66209641464, 1699.2792165032],
                        [1.97e-09, 4.61055255182, 464.7312265138],
                        [1.93e-09, 4.24606721746, 141.6988906084],
                        [2.66e-09, 0.69665031373, 2854.6403739102],
                        [2.27e-09, 1.31845358943, 230.7075831773],
                        [1.92e-09, 5.26739976413, 504.561183181],
                        [1.87e-09, 0.8553719223, 273.8536000037],
                        [1.99e-09, 3.91291687807, 418.5214360287],
                        [1.92e-09, 6.15674105214, 611.4430983108],
                        [2.1e-09, 1.47873602747, 205.4347889118],
                        [1.94e-09, 2.37167703302, 3370.1042450032],
                        [2.28e-09, 2.15266015145, 55.1378785943],
                        [2.01e-09, 2.71380671608, 586.3133163972],
                        [1.94e-09, 3.29560033731, 1670.8250285],
                        [2.01e-09, 4.23447633663, 1493.093668066],
                        [1.81e-09, 3.61567262848, 9786.687355335],
                        [1.81e-09, 2.83211558346, 1262.3860848887],
                        [2.42e-09, 4.69869158516, 1141.1340634054],
                        [1.84e-09, 4.66807336402, 1251.3403846248],
                        [2.21e-09, 2.25887876254, 355.7487455718],
                        [2e-09, 1.17340443616, 4952.0635932862],
                        [2.22e-09, 2.23360866067, 2435.155730035],
                        [1.75e-09, 0.04701598422, 107.7586406646],
                        [1.71e-09, 5.0250074269, 93.531546663],
                        [1.84e-09, 5.19723697138, 835.7878940127],
                        [2.21e-09, 4.49141283681, 913.0001267923],
                        [1.95e-09, 0.92088046109, 551.031606097],
                        [1.66e-09, 5.01778115937, 354.9979860464],
                        [1.65e-09, 2.26267552932, 406.954470903],
                        [1.89e-09, 0.31221126958, 420.9691165835],
                        [1.96e-09, 2.70333585839, 774.4826299216],
                        [1.76e-09, 6.12029409039, 181.806526049],
                        [1.72e-09, 1.94132177757, 3259.8979237838],
                        [1.6e-09, 0.55319954265, 5429.8794682394],
                        [1.61e-09, 2.88623631474, 184.8449074348],
                        [1.92e-09, 0.26639534884, 295.1942410061],
                        [1.67e-09, 3.71345214172, 1056.2005364515],
                        [1.95e-09, 4.83926717598, 1596.1864422846],
                        [1.56e-09, 2.81916058733, 428.0826635843],
                        [2.15e-09, 1.88276472005, 220.364458329],
                        [1.67e-09, 2.68872854428, 423.6774295692],
                        [1.54e-09, 1.66553954375, 115.6229471908],
                        [1.75e-09, 0.20216461467, 384.0599212231],
                        [2.01e-09, 4.38095931887, 418.0001711669],
                        [1.67e-09, 1.86485857353, 393.4610900843],
                        [1.55e-09, 0.92480392431, 282.6640680339],
                        [1.46e-09, 1.97663966745, 9360.089164459],
                        [1.6e-09, 2.62483919699, 353.301065017],
                        [1.86e-09, 1.37307151419, 292.0128472684],
                        [1.98e-09, 1.15631374887, 2957.7331481288],
                        [1.44e-09, 4.82956915076, 453.424893819],
                        [1.49e-09, 3.60682821788, 205.6642835754],
                        [1.47e-09, 4.48377791879, 81.8951455681],
                        [1.47e-09, 5.74795037748, 856.3777754897],
                        [1.42e-09, 3.53823120158, 212.0270710508],
                        [1.4e-09, 0.70476909062, 640.8604941605],
                        [1.39e-09, 1.39047667205, 1261.6353253633],
                        [1.53e-09, 3.29559426243, 391.1734682239],
                        [1.58e-09, 1.79872341304, 326.6868103951],
                        [1.74e-09, 3.98677435872, 1049.0869894507],
                        [1.71e-09, 4.16825100469, 213.0384630071],
                        [1.33e-09, 4.74095454922, 0.0481841098],
                        [1.55e-09, 5.3231361873, 2015.6710861598],
                        [1.58e-09, 2.67557086253, 2531.1349572528],
                        [1.58e-09, 4.64622526567, 427.3489504014],
                        [1.23e-09, 2.20103444636, 210.5907824523],
                        [1.6e-09, 1.85888551524, 201.5196819912],
                        [1.19e-09, 3.12572799769, 238.5718897035],
                        [1.2e-09, 4.62897224203, 203.2647871304],
                        [1.29e-09, 4.92592016162, 1286.9081196288],
                        [1.32e-09, 3.44682160054, 156.6767441354],
                        [1.43e-09, 0.67951827513, 425.8474313506],
                        [1.14e-09, 5.46519773276, 552.5855147745],
                        [1.32e-09, 1.76335093671, 432.0148168474],
                        [1.13e-09, 0.68933513038, 450.9772132642],
                        [1.28e-09, 2.13986068877, 2751.5475996916],
                        [1.23e-09, 4.59695145319, 216.0074084237],
                        [1.19e-09, 1.04688666457, 462.0229135281],
                        [1.08e-09, 5.36873170289, 3377.217792004],
                        [1.42e-09, 6.24626256472, 299.1263942692],
                        [1.18e-09, 0.6344825351, 369.9758395734],
                        [1.05e-09, 2.31570619675, 200.5564741447],
                        [1.24e-09, 1.8711081514, 850.0149880143],
                        [1.06e-09, 0.5562366257, 114.3991069134],
                        [1.02e-09, 3.95315219638, 361.3778198643],
                        [9.5e-10, 4.10658529323, 10213.285546211],
                        [9.7e-10, 1.13534710734, 387.2413149608],
                        [9.6e-10, 4.46689094543, 401.3253966105],
                        [1.19e-09, 2.33636675091, 318.8395502114],
                        [1.15e-09, 3.37508073115, 313.9441891018],
                        [1.06e-09, 3.7358621165, 220.9339073006],
                        [9e-10, 0.59788492023, 227.3137411185],
                        [1.03e-09, 5.09172929383, 213.4591541324],
                        [9.7e-10, 5.95268532215, 1044.4040766622],
                        [1.03e-09, 1.70625660572, 213.1390367436],
                        [8e-10, 0.86872596168, 233.9060232575],
                        [8.9e-10, 5.3599093223, 214.1928673153],
                        [8e-10, 2.69565238975, 540.7366653585],
                        [9.5e-10, 1.19504849611, 460.5384408198],
                        [1.05e-09, 0.58624363205, 481.7360694703],
                        [9.9e-10, 2.68841109007, 219.891377577],
                        [9.8e-10, 1.59923557478, 484.7050148869],
                        [8.1e-10, 1.12279793521, 420.4478517217],
                        [7.5e-10, 4.58892231446, 394.3548619616],
                        [9.9e-10, 4.6889585175, 448.6895914038],
                        [7.6e-10, 1.66929798365, 196.0336200506],
                        [8.7e-10, 3.1247719509, 857.1285350151],
                        [7.8e-10, 5.5981938746, 364.3467652809],
                        [7.9e-10, 3.53267171729, 969.6224780949],
                      ],
          },
          {
            series => "L2",
            terms  => [
                        [0.00116441181, 1.17987850633, 7.1135470008],
                        [0.00091920844, 0.07425261094, 213.299095438],
                        [0.00090592251, 0, 0],
                        [0.00015276909, 4.06492007503, 206.1855484372],
                        [0.00010631396, 0.25778277414, 220.4126424388],
                        [0.00010604979, 5.40963595885, 426.598190876],
                        [4.265368e-05, 1.0459555663, 14.2270940016],
                        [1.215527e-05, 2.91860042123, 103.0927742186],
                        [1.164684e-05, 4.60942128971, 639.897286314],
                        [1.081967e-05, 5.6913035167, 433.7117378768],
                        [1.020079e-05, 0.63369182642, 3.1813937377],
                        [1.044754e-05, 4.04206453611, 199.0720014364],
                        [6.33582e-06, 4.38825410036, 419.4846438752],
                        [5.49329e-06, 5.57303134242, 3.9321532631],
                        [4.56914e-06, 1.26840971349, 110.2063212194],
                        [4.251e-06, 0.20935499279, 227.5261894396],
                        [2.73739e-06, 4.28841011784, 95.9792272178],
                        [1.61571e-06, 1.3813914942, 11.0457002639],
                        [1.29494e-06, 1.5658688417, 309.2783226558],
                        [1.17008e-06, 3.88120915956, 853.196381752],
                        [1.05415e-06, 4.90003203599, 647.0108333148],
                        [1.00967e-06, 0.892704931, 21.3406410024],
                        [9.5227e-07, 5.62561150598, 412.3710968744],
                        [8.1948e-07, 1.02477558315, 117.3198682202],
                        [7.4857e-07, 4.76178468163, 210.1177017003],
                        [8.2727e-07, 6.05030934786, 216.4804891757],
                        [9.5659e-07, 2.91093561539, 316.3918696566],
                        [6.3696e-07, 0.35179804917, 323.5054166574],
                        [8.486e-07, 5.73472777961, 209.3669421749],
                        [6.0647e-07, 4.8751785019, 632.7837393132],
                        [6.6459e-07, 0.48297940601, 10.2949407385],
                        [6.7184e-07, 0.45648612616, 522.5774180938],
                        [5.3281e-07, 2.74730541387, 529.6909650946],
                        [4.5827e-07, 5.69296621745, 440.8252848776],
                        [4.5293e-07, 1.66856699796, 202.2533951741],
                        [4.233e-07, 5.70768187703, 88.865680217],
                        [3.214e-07, 0.07050050346, 63.7358983034],
                        [3.1573e-07, 1.67190022213, 302.164775655],
                        [3.115e-07, 4.16379537691, 191.9584544356],
                        [2.4631e-07, 5.6556472857, 735.8765135318],
                        [2.6558e-07, 0.83256214407, 224.3447957019],
                        [2.0108e-07, 5.94364609981, 217.2312487011],
                        [1.7511e-07, 4.90014736798, 625.6701923124],
                        [1.713e-07, 1.62593421274, 742.9900605326],
                        [1.3744e-07, 3.764971673, 195.1398481733],
                        [1.2236e-07, 4.71789723976, 203.0041546995],
                        [1.194e-07, 0.12620714199, 234.6397364404],
                        [1.604e-07, 0.57886320845, 515.463871093],
                        [1.1154e-07, 5.9221684478, 536.8045120954],
                        [1.4068e-07, 0.206752937, 838.9692877504],
                        [1.1013e-07, 5.60207982774, 728.762966531],
                        [1.1718e-07, 3.12098483554, 846.0828347512],
                        [9.962e-08, 4.15472049127, 860.3099287528],
                        [1.0601e-07, 3.20327613035, 1066.49547719],
                        [1.0072e-07, 0.25709351996, 330.6189636582],
                        [9.49e-08, 0.46379969328, 956.2891559706],
                        [1.024e-07, 4.9873665607, 422.6660376129],
                        [8.287e-08, 2.13990364272, 269.9214467406],
                        [7.238e-08, 5.39724715258, 1052.2683831884],
                        [7.73e-08, 5.24602742309, 429.7795846137],
                        [6.353e-08, 4.46211130731, 284.1485407422],
                        [5.935e-08, 5.40967847103, 149.5631971346],
                        [7.55e-08, 4.03401153929, 9.5612275556],
                        [5.779e-08, 4.2938089111, 415.5524906121],
                        [6.082e-08, 5.93416924841, 405.2575498736],
                        [5.711e-08, 0.01824076994, 124.433415221],
                        [5.676e-08, 6.0223568215, 223.5940361765],
                        [4.757e-08, 4.92804854717, 654.1243803156],
                        [4.727e-08, 2.27461984667, 18.1592472647],
                        [4.509e-08, 4.40688707557, 942.062061969],
                        [5.621e-08, 0.29694719379, 127.4717966068],
                        [5.453e-08, 5.53868222772, 949.1756089698],
                        [4.13e-08, 4.68673560379, 74.7815985673],
                        [4.098e-08, 5.308512622, 1045.1548361876],
                        [4.223e-08, 2.89014939299, 56.6223513026],
                        [4.887e-08, 3.20022991216, 277.0349937414],
                        [3.905e-08, 3.30270187305, 490.3340891794],
                        [3.923e-08, 6.09732996823, 81.7521332162],
                        [3.755e-08, 4.93065184796, 52.6901980395],
                        [4.602e-08, 6.13908576681, 1155.361157407],
                        [3.714e-08, 0.40648076787, 137.0330241624],
                        [3.407e-08, 4.28514461015, 99.9113804809],
                        [3.579e-08, 0.20402442077, 1272.6810256272],
                        [3.946e-08, 0.36500928968, 12.5301729722],
                        [3.246e-08, 1.56761884227, 1059.3819301892],
                        [4.063e-08, 0.29084229143, 831.8557407496],
                        [3.688e-08, 0.15467406177, 437.6438911399],
                        [2.895e-08, 3.13473183482, 70.8494453042],
                        [2.8e-08, 0.32727938074, 191.2076949102],
                        [2.672e-08, 1.87612402267, 295.0512286542],
                        [3.454e-08, 4.77197610696, 423.4167971383],
                        [2.623e-08, 5.15237415384, 1368.660252845],
                        [2.457e-08, 3.89612890177, 210.8514148832],
                        [2.461e-08, 1.5852287676, 32.2433289144],
                        [2.595e-08, 3.59007068361, 131.4039498699],
                        [2.289e-08, 4.76825865118, 351.8165923087],
                        [2.357e-08, 5.83099000562, 106.2741679563],
                        [2.221e-08, 5.98277491515, 6062.6632075526],
                        [2.221e-08, 2.05930402282, 6076.8903015542],
                        [2.183e-08, 5.94985336393, 145.6310438715],
                        [2.718e-08, 3.37801252354, 408.4389436113],
                        [2.288e-08, 3.1400061932, 22.0914005278],
                        [2.09e-08, 1.12304173562, 9992.8729037722],
                        [2.089e-08, 3.48276230686, 10007.0999977738],
                        [2.57e-08, 5.12167203704, 265.9892934775],
                        [1.835e-08, 4.15379879659, 1258.4539316256],
                        [1.82e-08, 5.05340615445, 1361.5467058442],
                        [1.76e-08, 4.13532689228, 107.0249274817],
                        [1.921e-08, 4.51790997496, 138.5174968707],
                        [1.707e-08, 1.3586459328, 231.4583427027],
                        [1.956e-08, 5.87006093798, 1471.7530270636],
                        [2.133e-08, 5.2340984872, 1265.5674786264],
                        [1.595e-08, 5.61962698786, 447.9388318784],
                        [1.609e-08, 3.74893709671, 628.8515860501],
                        [1.49e-08, 0.4835240494, 340.7708920448],
                        [1.56e-08, 5.97095003614, 430.5303441391],
                        [1.352e-08, 0.71405348653, 28.4541880032],
                        [1.355e-08, 2.91219493604, 215.7467759928],
                        [1.298e-08, 5.84254169775, 543.9180590962],
                        [1.664e-08, 6.23834873469, 1148.2476104062],
                        [1.205e-08, 2.83373725021, 200.7689224658],
                        [1.192e-08, 3.52219428945, 497.4476361802],
                        [1.122e-08, 2.6057103027, 1279.794572628],
                        [1.217e-08, 6.23528359211, 1589.0728952838],
                        [1.42e-08, 0.85079202155, 6069.7767545534],
                        [1.12e-08, 4.95656566453, 1685.0521225016],
                        [1.01e-08, 3.39689646619, 1073.6090241908],
                        [1.352e-08, 2.27575429523, 9999.986450773],
                        [9.79e-09, 1.58571463442, 1375.7737998458],
                        [1.159e-08, 0.71823181781, 508.3503240922],
                        [1.014e-08, 2.40759054741, 703.6331846174],
                        [9.56e-09, 2.66256831556, 134.5853436076],
                        [1.11e-08, 1.19713920197, 618.5566453116],
                        [9.45e-09, 4.68155456977, 362.8622925726],
                        [9.53e-09, 4.20749172571, 288.0806940053],
                        [1.033e-08, 1.08781255146, 184.8449074348],
                        [9.42e-09, 2.4346522346, 222.8603229936],
                        [9.09e-09, 4.5176938536, 38.1330356378],
                        [1.002e-08, 1.38543153271, 483.2205421786],
                        [1.082e-08, 4.52832816548, 635.9651330509],
                        [1.008e-08, 4.91325851448, 750.1036075334],
                        [8.62e-09, 4.79998518474, 1677.9385755008],
                        [8.28e-09, 2.21940849017, 333.657345044],
                        [7.45e-09, 3.97279299984, 1574.8458012822],
                        [9.03e-09, 5.58963782799, 1788.1448967202],
                        [7.35e-09, 2.28191723259, 1162.4747044078],
                        [7.73e-09, 5.82270096882, 416.3032501375],
                        [7.34e-09, 2.35356586018, 120.358249606],
                        [7.45e-09, 4.84266000843, 76.2660712756],
                        [7.65e-09, 2.50840146722, 343.2185725996],
                        [9.08e-09, 5.01046293458, 1581.959348283],
                        [7.07e-09, 3.66631544506, 347.8844390456],
                        [8.7e-09, 0.77106152694, 113.3877149571],
                        [6.86e-09, 2.88543836068, 92.0470739547],
                        [6.73e-09, 3.75650667651, 203.7378678824],
                        [6.56e-09, 3.77718582702, 217.964961884],
                        [6.75e-09, 5.62875135263, 17.2654753874],
                        [6.91e-09, 0.21330089609, 99.1606209555],
                        [7.86e-09, 4.49318079175, 643.0786800517],
                        [6.41e-09, 0.67588390141, 46.470422916],
                        [6.63e-09, 5.74837848383, 721.6494195302],
                        [8.09e-09, 5.94893988352, 1464.6394800628],
                        [6.38e-09, 4.86195439622, 357.4456666012],
                        [7.4e-09, 6.00053422445, 337.732510659],
                        [5.55e-09, 4.95858934298, 358.9301393095],
                        [5.81e-09, 3.87669679805, 565.1156877467],
                        [5.41e-09, 1.22296838713, 62.2514255951],
                        [6.97e-09, 0.00715950269, 1169.5882514086],
                        [5.24e-09, 1.53830423608, 195.8906076987],
                        [5.18e-09, 5.41992758537, 312.1990839626],
                        [6.26e-09, 5.26580317026, 436.8931316145],
                        [5.37e-09, 6.170316576, 182.279606801],
                        [5.74e-09, 5.98607898826, 1905.4647649404],
                        [5.41e-09, 0.30589337713, 98.8999885246],
                        [6.03e-09, 3.26888470585, 208.633228992],
                        [5.04e-09, 3.80930996688, 168.0525127994],
                        [4.77e-09, 3.56642391994, 563.6312150384],
                        [5.11e-09, 4.70719837179, 2001.4439921582],
                        [4.75e-09, 1.06025557585, 5856.4776591154],
                        [5.4e-09, 0.87230551412, 1692.1656695024],
                        [4.54e-09, 2.48128029368, 9786.687355335],
                        [4.56e-09, 3.18303484133, 218.9281697305],
                        [4.62e-09, 0.71358186864, 258.8757464767],
                        [4.24e-09, 4.89778948357, 636.7158925763],
                        [5.37e-09, 2.59376221736, 313.2104759189],
                        [4.1e-09, 4.22147787617, 867.4234757536],
                        [4.08e-09, 3.06057772788, 424.1505103212],
                        [4.07e-09, 3.79376013938, 24.3790223882],
                        [5.69e-09, 3.68547825941, 350.3321196004],
                        [4.04e-09, 0.91401255827, 114.1384744825],
                        [3.95e-09, 3.50478374207, 129.9194771616],
                        [3.95e-09, 2.86309689622, 212.3358875915],
                        [3.86e-09, 5.00762729432, 388.4651552382],
                        [3.93e-09, 6.26835522096, 241.7532834412],
                        [4.01e-09, 4.60258908692, 1994.3304451574],
                        [3.85e-09, 0.91582119643, 160.6088973985],
                        [4.67e-09, 0.54876489832, 404.5067903482],
                        [3.68e-09, 0.35674031808, 214.2623032845],
                        [4.71e-09, 0.67360047481, 207.8824694666],
                        [3.79e-09, 0.92901327825, 767.3690829208],
                        [4.2e-09, 5.69797398044, 225.8292684102],
                        [3.56e-09, 3.10092792842, 842.1506814881],
                        [4.28e-09, 5.35375368944, 2104.5367663768],
                        [4.22e-09, 2.67975581832, 77.962992305],
                        [3.7e-09, 5.46144813372, 1038.0412891868],
                        [3.79e-09, 5.56429091578, 131.5469622218],
                        [4.41e-09, 5.68196668399, 1781.0313497194],
                        [3.61e-09, 5.20616019966, 629.6023455755],
                        [3.41e-09, 5.92928351979, 26.826702943],
                        [4.19e-09, 5.26851686707, 85.8272988312],
                        [3.22e-09, 0.80223983857, 6283.0758499914],
                        [3.23e-09, 3.86700993914, 576.1613880106],
                        [3.21e-09, 2.1718603297, 10213.285546211],
                        [3.55e-09, 2.80560859177, 344.7030453079],
                        [3.11e-09, 3.77477255556, 1891.2376709388],
                        [3.18e-09, 5.22020784209, 142.4496501338],
                        [3.15e-09, 0.52272202855, 5849.3641121146],
                        [4.28e-09, 4.63722058283, 1898.3512179396],
                        [3.37e-09, 0.68198429948, 45.5766510387],
                        [3.16e-09, 0.54074780109, 444.7574381407],
                        [3.1e-09, 1.41032075652, 273.1028404783],
                        [3.11e-09, 3.5374455623, 251.4321310758],
                        [2.95e-09, 1.93253015677, 436.1594184316],
                        [2.96e-09, 1.97705648834, 9779.5738083342],
                        [3.26e-09, 3.67854047003, 963.4027029714],
                        [3.89e-09, 5.76841276132, 39.3568759152],
                        [2.77e-09, 5.73995694175, 92.7978334801],
                        [3.15e-09, 4.96371610197, 757.2171545342],
                        [2.95e-09, 1.816388339, 1493.093668066],
                        [2.87e-09, 0.97698377929, 685.4739373527],
                        [2.81e-09, 2.66463042095, 1286.9081196288],
                        [3.3e-09, 5.7977692276, 650.9429865779],
                        [2.92e-09, 3.97858181479, 472.1748419147],
                        [2.66e-09, 4.1371611132, 601.7642506762],
                        [2.62e-09, 0.91887592474, 245.5424243524],
                        [2.78e-09, 3.08964256591, 778.4147831847],
                        [2.77e-09, 3.0875091688, 621.7380390493],
                        [2.55e-09, 3.93981592051, 181.0557665236],
                        [3.33e-09, 2.04835822938, 561.1835344836],
                        [2.47e-09, 2.92754257675, 219.4494345923],
                        [3.06e-09, 0.36127922606, 824.7421937488],
                        [2.53e-09, 1.80130756458, 5643.1785636774],
                        [3.37e-09, 4.97764462199, 175.1660598002],
                        [2.73e-09, 0.66599369335, 2008.557539159],
                        [2.27e-09, 4.87285356383, 661.2379273164],
                        [2.49e-09, 3.14202895058, 144.1465711632],
                        [2.2e-09, 3.93526603081, 319.5732633943],
                        [2.12e-09, 5.85248164087, 546.956440482],
                        [2.34e-09, 1.65314711167, 554.0699874828],
                        [2.04e-09, 0.88373842674, 31.492569389],
                        [2.05e-09, 2.93169866171, 1596.1864422846],
                        [2.01e-09, 3.36504567824, 1080.7225711916],
                        [2.24e-09, 4.34612745705, 1382.8873468466],
                        [1.92e-09, 5.13697232918, 329.7251917809],
                        [2.08e-09, 3.08549771485, 41.6444977756],
                        [2.36e-09, 0.0799874286, 1141.1340634054],
                        [2.03e-09, 4.13011580915, 2627.1141844706],
                        [2.03e-09, 0.13969067385, 1485.9801210652],
                        [2.04e-09, 3.38137545713, 699.7010313543],
                        [2.12e-09, 4.52370676085, 2310.722314814],
                        [2.18e-09, 5.79277335862, 2221.856634597],
                        [2.13e-09, 0.50441377637, 934.9485149682],
                        [2.1e-09, 5.04017633795, 2420.9286360334],
                        [2.14e-09, 4.64286758581, 2317.8358618148],
                        [1.78e-09, 0.84588580004, 128.3655684841],
                        [1.7e-09, 2.75006619605, 710.7467316182],
                        [1.71e-09, 4.32615182967, 291.262087743],
                        [1.72e-09, 3.4697130692, 501.3797894433],
                        [1.7e-09, 1.05408992106, 526.5095713569],
                        [1.62e-09, 1.1568304295, 519.3960243561],
                        [1.8e-09, 4.96266204107, 1670.8250285],
                        [1.72e-09, 1.65385549578, 916.9322800554],
                        [1.7e-09, 2.30821101766, 429.0458714308],
                        [1.7e-09, 5.98716489326, 643.8294395771],
                        [1.73e-09, 5.19933564968, 1354.4331588434],
                        [1.95e-09, 4.50165508529, 2214.7430875962],
                        [1.56e-09, 4.16290662749, 572.2292347475],
                        [1.53e-09, 1.23776248578, 2413.8150890326],
                        [1.5e-09, 0.63076983213, 1478.8665740644],
                        [1.69e-09, 4.28090123029, 305.3461693927],
                        [1.74e-09, 6.23077892653, 3384.3313390048],
                        [1.49e-09, 3.13274908516, 9573.388259897],
                        [1.62e-09, 6.25601818345, 213.2509113282],
                        [1.49e-09, 4.81749019484, 945.9942152321],
                        [1.62e-09, 0.8861012919, 216.2198567448],
                        [1.33e-09, 2.31915371262, 156.6767441354],
                        [1.65e-09, 6.06456216591, 732.6951197941],
                        [1.41e-09, 6.14293754333, 1795.258443721],
                        [1.33e-09, 0.06530337135, 218.7157214094],
                        [1.62e-09, 3.17058130506, 213.3472795478],
                        [1.25e-09, 2.07143636845, 425.1137181677],
                        [1.46e-09, 1.88627500632, 211.8146227297],
                        [1.13e-09, 2.79541965778, 235.3904959658],
                        [1.17e-09, 0.76464798684, 479.2883889155],
                        [1.08e-09, 3.95650672786, 570.7447620392],
                        [1.06e-09, 0.12820734703, 188.0263011725],
                        [1.34e-09, 3.58244908862, 849.2642284889],
                        [1.14e-09, 0.25990388555, 398.1440028728],
                        [1.12e-09, 2.39181495831, 217.491881132],
                        [9.1e-10, 2.50716605179, 121.2520214833],
                        [9.1e-10, 1.75367948574, 213.8203602998],
                        [8.8e-10, 5.26121947108, 395.578702239],
                        [9.6e-10, 3.98832609364, 289.5651667136],
                        [9.1e-10, 0.35318362186, 312.4597163935],
                        [1.12e-09, 1.14387590923, 1802.3719907218],
                        [8.2e-10, 3.73605217214, 207.6700211455],
                        [8.2e-10, 6.06283262812, 210.3783341312],
                        [8.4e-10, 3.34470673492, 67.6680515665],
                        [8.6e-10, 2.7391730018, 5863.5912061162],
                        [8.3e-10, 2.81499116485, 776.9303104764],
                        [9.1e-10, 1.2616009317, 212.7778305762],
                        [9e-10, 2.08722491981, 2111.6503133776],
                        [8e-10, 2.13136842916, 421.93232443],
                        [8.2e-10, 4.16358350281, 9793.8009023358],
                        [7.7e-10, 2.96973341607, 431.264057322],
                        [7.9e-10, 3.42790361067, 417.0369633204],
                        [7.9e-10, 3.18693585419, 320.3240229197],
                        [8e-10, 0.78975763683, 204.7010757289],
                        [7.7e-10, 1.89354243952, 556.5176680376],
                        [7.3e-10, 4.85923277221, 2118.7638603784],
                        [7.1e-10, 3.64551577433, 198.321241911],
                      ],
          },
          {
            series => "L3",
            terms  => [
                        [0.00016038734, 5.73945377424, 7.1135470008],
                        [4.249793e-05, 4.58539675603, 213.299095438],
                        [1.906524e-05, 4.76082050205, 220.4126424388],
                        [1.465687e-05, 5.91326678323, 206.1855484372],
                        [1.162041e-05, 5.61973132428, 14.2270940016],
                        [1.066581e-05, 3.60816533142, 426.598190876],
                        [2.39377e-06, 3.86088273439, 433.7117378768],
                        [2.36975e-06, 5.76826451465, 199.0720014364],
                        [1.65641e-06, 5.11641150216, 3.1813937377],
                        [1.31409e-06, 4.74327544615, 227.5261894396],
                        [1.51352e-06, 2.73594641861, 639.897286314],
                        [6.163e-07, 4.74287052463, 103.0927742186],
                        [6.3365e-07, 0.22850089497, 419.4846438752],
                        [4.0437e-07, 5.47298059144, 21.3406410024],
                        [4.0205e-07, 5.9642026672, 95.9792272178],
                        [3.8746e-07, 5.83386199529, 110.2063212194],
                        [2.8025e-07, 3.01235311514, 647.0108333148],
                        [2.5029e-07, 0.9880817074, 3.9321532631],
                        [1.8101e-07, 1.02506397063, 412.3710968744],
                        [1.7879e-07, 3.31913418974, 309.2783226558],
                        [1.6208e-07, 3.89825272754, 440.8252848776],
                        [1.5763e-07, 5.61667809625, 117.3198682202],
                        [1.9014e-07, 1.91614237463, 853.196381752],
                        [1.8262e-07, 4.96738415934, 10.2949407385],
                        [1.2947e-07, 1.18068953942, 88.865680217],
                        [1.7919e-07, 4.20376505349, 216.4804891757],
                        [1.1453e-07, 5.57520615096, 11.0457002639],
                        [1.0548e-07, 5.92906266269, 191.9584544356],
                        [1.0389e-07, 3.94838736947, 209.3669421749],
                        [8.65e-08, 3.39335369698, 302.164775655],
                        [7.58e-08, 4.87736913157, 323.5054166574],
                        [6.697e-08, 0.38198725552, 632.7837393132],
                        [5.864e-08, 1.05621157685, 210.1177017003],
                        [5.449e-08, 4.64268475485, 234.6397364404],
                        [6.327e-08, 2.25492722762, 522.5774180938],
                        [3.602e-08, 2.30677010956, 515.463871093],
                        [3.229e-08, 2.20309400066, 860.3099287528],
                        [3.701e-08, 3.14159265359, 0],
                        [2.583e-08, 4.93447677059, 224.3447957019],
                        [2.543e-08, 0.42393884183, 625.6701923124],
                        [2.213e-08, 3.19814958289, 202.2533951741],
                        [2.421e-08, 4.76621391814, 330.6189636582],
                        [2.85e-08, 0.5860439501, 529.6909650946],
                        [1.965e-08, 4.39525359412, 124.433415221],
                        [2.154e-08, 1.35488209144, 405.2575498736],
                        [2.296e-08, 3.34809165905, 429.7795846137],
                        [2.018e-08, 3.06693569701, 654.1243803156],
                        [1.979e-08, 1.02981005658, 728.762966531],
                        [1.868e-08, 3.09383546177, 422.6660376129],
                        [1.846e-08, 4.1522598545, 536.8045120954],
                        [2.194e-08, 1.18918501013, 1066.49547719],
                        [2.09e-08, 4.15631351317, 223.5940361765],
                        [1.481e-08, 0.37916705169, 316.3918696566],
                        [1.72e-08, 5.82865773356, 195.1398481733],
                        [1.46e-08, 1.57663426355, 81.7521332162],
                        [1.623e-08, 6.03706764648, 742.9900605326],
                        [1.286e-08, 1.66154726117, 63.7358983034],
                        [1.304e-08, 5.02409881054, 956.2891559706],
                        [1.446e-08, 2.10575519127, 838.9692877504],
                        [1.245e-08, 3.8810975277, 269.9214467406],
                        [1.018e-08, 3.72599601656, 295.0512286542],
                        [1.323e-08, 1.38492882986, 735.8765135318],
                        [1.318e-08, 2.33460998999, 217.2312487011],
                        [9.43e-09, 2.75813531246, 284.1485407422],
                        [9.06e-09, 0.71155526266, 846.0828347512],
                        [8.86e-09, 3.83754799777, 447.9388318784],
                        [9.43e-09, 3.31480217015, 18.1592472647],
                        [8e-09, 4.71386673963, 56.6223513026],
                        [9.08e-09, 2.02119147951, 831.8557407496],
                        [7.87e-09, 0.80410269937, 1045.1548361876],
                        [7.09e-09, 4.27064410504, 437.6438911399],
                        [6.51e-09, 6.17565900032, 942.062061969],
                        [7.85e-09, 2.40767785311, 203.0041546995],
                        [7.02e-09, 1.64585301418, 423.4167971383],
                        [5.43e-09, 2.86326941725, 184.8449074348],
                        [5.32e-09, 6.25762144463, 1059.3819301892],
                        [5.21e-09, 3.43013038466, 149.5631971346],
                        [4.84e-09, 4.8836606072, 1272.6810256272],
                        [4.37e-09, 5.40220619672, 408.4389436113],
                        [3.88e-09, 2.57589594168, 508.3503240922],
                        [4.21e-09, 4.05836524024, 543.9180590962],
                        [3.75e-09, 1.22747948298, 2324.9494088156],
                        [3.47e-09, 0.59237194522, 22.0914005278],
                        [4.33e-09, 1.69090148012, 1155.361157407],
                        [3.89e-09, 1.46170367972, 1073.6090241908],
                        [3.07e-09, 1.82185086955, 628.8515860501],
                        [4.09e-09, 1.21858750514, 1052.2683831884],
                        [3.09e-09, 0.33610530663, 6076.8903015542],
                        [3.09e-09, 1.42279282226, 6062.6632075526],
                        [3.4e-09, 1.8332577031, 1141.1340634054],
                        [3.03e-09, 2.4158474733, 127.4717966068],
                        [3.05e-09, 5.34154702988, 131.4039498699],
                        [2.98e-09, 2.28594631393, 635.9651330509],
                        [3.72e-09, 1.0372391139, 313.2104759189],
                        [3.38e-09, 0.69100012338, 1361.5467058442],
                        [3.25e-09, 1.78816356937, 1148.2476104062],
                        [3.22e-09, 1.1862880501, 721.6494195302],
                        [2.71e-09, 2.4566315646, 415.5524906121],
                        [2.51e-09, 3.12046701975, 1382.8873468466],
                        [2.54e-09, 3.00353256829, 618.5566453116],
                        [2.95e-09, 0.35280179538, 2730.2069586892],
                        [2.42e-09, 1.52154324392, 70.8494453042],
                        [2.96e-09, 0.89576757167, 2104.5367663768],
                        [2.64e-09, 3.00987438634, 661.2379273164],
                        [2.67e-09, 0.31623829657, 1677.9385755008],
                        [2.7e-09, 2.56774718753, 643.0786800517],
                        [2.61e-09, 1.55058302472, 1457.525933062],
                        [2.46e-09, 2.29214585472, 867.4234757536],
                        [2.69e-09, 3.18157515051, 750.1036075334],
                        [2.72e-09, 1.12208982319, 1788.1448967202],
                        [2.56e-09, 0.37673546414, 1279.794572628],
                        [2.06e-09, 1.81129778306, 497.4476361802],
                        [2.51e-09, 0.61933213502, 2413.8150890326],
                        [2.37e-09, 3.35941544147, 436.8931316145],
                        [2.47e-09, 0.10102936687, 99.9113804809],
                        [2.47e-09, 0.93125798111, 52.6901980395],
                        [2.21e-09, 2.07880035795, 824.7421937488],
                        [1.97e-09, 6.16682223437, 1258.4539316256],
                        [2.29e-09, 5.5791753484, 2943.5060541272],
                        [2.27e-09, 0.43324651601, 2737.32050569],
                        [2.03e-09, 4.12623986247, 337.732510659],
                        [2.14e-09, 3.57607524509, 934.9485149682],
                        [2.12e-09, 1.25688162158, 1773.9178027186],
                        [2.15e-09, 0.8886764788, 1038.0412891868],
                        [2.44e-09, 5.5157208457, 231.4583427027],
                        [1.81e-09, 2.13821830481, 416.3032501375],
                        [2.1e-09, 4.19139167658, 2221.856634597],
                        [1.78e-09, 2.91685344537, 74.7815985673],
                        [2.01e-09, 0.46214583002, 2854.6403739102],
                        [2.36e-09, 4.64388694899, 1905.4647649404],
                        [1.99e-09, 1.54991619669, 1471.7530270636],
                        [1.99e-09, 0.70725247497, 2420.9286360334],
                        [1.62e-09, 2.5148834502, 430.5303441391],
                        [1.6e-09, 1.23508694599, 1596.1864422846],
                        [1.75e-09, 4.14605894816, 2090.3096723752],
                        [1.52e-09, 0.05796022559, 32.2433289144],
                        [1.76e-09, 1.29002070623, 490.3340891794],
                        [1.54e-09, 3.60622857548, 650.9429865779],
                        [1.85e-09, 4.74969742128, 319.5732633943],
                        [1.54e-09, 1.54587199996, 1464.6394800628],
                        [1.08e-09, 4.251257865, 145.6310438715],
                        [1.06e-09, 1.04047809351, 1162.4747044078],
                        [1.14e-09, 2.640557371, 362.8622925726],
                        [9.3e-10, 3.36746275886, 483.2205421786],
                        [9.1e-10, 2.05796248692, 210.8514148832],
                        [9.1e-10, 4.53336314765, 241.7532834412],
                        [7.2e-10, 3.74361312157, 1485.9801210652],
                        [7.6e-10, 3.33892447677, 195.8906076987],
                      ],
          },
          {
            series => "L4",
            terms  => [
                        [1.661894e-05, 3.99826248978, 7.1135470008],
                        [2.57107e-06, 2.98436499013, 220.4126424388],
                        [2.36344e-06, 3.90241428075, 14.2270940016],
                        [1.49418e-06, 2.74110824208, 213.299095438],
                        [1.09598e-06, 1.51515739251, 206.1855484372],
                        [1.13953e-06, 3.14159265359, 0],
                        [6.839e-07, 1.72120953337, 426.598190876],
                        [3.7699e-07, 1.23795458356, 199.0720014364],
                        [4.006e-07, 2.04644897412, 433.7117378768],
                        [3.1219e-07, 3.0109418409, 227.5261894396],
                        [1.5111e-07, 0.82897064529, 639.897286314],
                        [9.444e-08, 3.71485300868, 21.3406410024],
                        [5.69e-08, 2.41995290633, 419.4846438752],
                        [4.47e-08, 1.45120818748, 95.9792272178],
                        [5.608e-08, 1.1560709574, 647.0108333148],
                        [4.463e-08, 2.11783225176, 440.8252848776],
                        [3.229e-08, 4.09278077834, 110.2063212194],
                        [2.871e-08, 2.77203153866, 412.3710968744],
                        [2.796e-08, 3.00730249564, 88.865680217],
                        [2.638e-08, 0.00255721254, 853.196381752],
                        [2.574e-08, 0.39246854091, 103.0927742186],
                        [1.862e-08, 5.07955457727, 309.2783226558],
                        [2.225e-08, 3.77689198137, 117.3198682202],
                        [1.769e-08, 5.19176876406, 302.164775655],
                        [1.921e-08, 2.82884328662, 234.6397364404],
                        [1.805e-08, 2.23816036743, 216.4804891757],
                        [1.211e-08, 1.54685246534, 191.9584544356],
                        [7.65e-09, 3.44501766503, 323.5054166574],
                        [7.63e-09, 4.83197222448, 210.1177017003],
                        [6.13e-09, 4.19052656353, 515.463871093],
                        [6.48e-09, 2.28591710303, 209.3669421749],
                        [6.16e-09, 4.03194472161, 522.5774180938],
                        [6.3e-09, 2.37952532019, 632.7837393132],
                        [6.39e-09, 0.29772678242, 860.3099287528],
                        [5.59e-09, 2.1711006053, 124.433415221],
                        [4.42e-09, 2.23500083592, 447.9388318784],
                        [4.07e-09, 5.4451597099, 1066.49547719],
                        [4.69e-09, 1.26889429317, 654.1243803156],
                        [4.88e-09, 3.20329778617, 405.2575498736],
                        [4.15e-09, 3.12435410343, 330.6189636582],
                        [4.42e-09, 3.38933498625, 81.7521332162],
                        [3.32e-09, 4.12464206608, 838.9692877504],
                        [3.2e-09, 3.18332026736, 529.6909650946],
                        [3.12e-09, 1.40962796637, 429.7795846137],
                        [2.91e-09, 3.18885372262, 1464.6394800628],
                        [3.33e-09, 2.94355912397, 728.762966531],
                        [2.35e-09, 3.67049647573, 1148.2476104062],
                        [2.86e-09, 2.57895004576, 1045.1548361876],
                        [2.23e-09, 3.57980034401, 1155.361157407],
                        [2.61e-09, 2.04564143519, 1677.9385755008],
                        [2.18e-09, 2.61967125327, 536.8045120954],
                        [2.62e-09, 2.48322150677, 625.6701923124],
                        [1.91e-09, 4.39064160974, 1574.8458012822],
                        [1.76e-09, 1.26161895188, 422.6660376129],
                        [1.9e-09, 2.326931712, 223.5940361765],
                        [1.85e-09, 1.08713469614, 742.9900605326],
                        [1.68e-09, 0.69946458053, 824.7421937488],
                        [1.77e-09, 5.02663339078, 203.0041546995],
                        [2.18e-09, 0.40426546037, 867.4234757536],
                        [1.78e-09, 3.67593243311, 831.8557407496],
                        [1.75e-09, 5.75326979098, 1073.6090241908],
                        [1.56e-09, 3.02120117572, 1781.0313497194],
                        [1.48e-09, 2.28313808274, 295.0512286542],
                        [1.5e-09, 3.48436135302, 956.2891559706],
                        [1.52e-09, 1.91404443241, 942.062061969],
                        [1.46e-09, 6.1651969664, 316.3918696566],
                        [9.6e-10, 2.93247663741, 224.3447957019],
                        [8.8e-10, 4.48383632427, 423.4167971383],
                      ],
          },
          {
            series => "L5",
            terms  => [
                        [1.23615e-06, 2.25923345732, 7.1135470008],
                        [3.419e-07, 2.16250652689, 14.2270940016],
                        [2.7546e-07, 1.19868150215, 220.4126424388],
                        [5.818e-08, 1.21584270184, 227.5261894396],
                        [5.318e-08, 0.23550400093, 433.7117378768],
                        [3.677e-08, 6.22669694355, 426.598190876],
                        [3.057e-08, 2.97372046322, 199.0720014364],
                        [2.861e-08, 4.28710932685, 206.1855484372],
                        [1.617e-08, 6.25265362286, 213.299095438],
                        [1.279e-08, 5.27612561266, 639.897286314],
                        [9.32e-09, 5.56741549127, 647.0108333148],
                        [7.56e-09, 6.17716234487, 191.9584544356],
                        [7.6e-09, 0.69475544472, 302.164775655],
                        [1.038e-08, 0.23516951637, 440.8252848776],
                        [1.007e-08, 3.14159265359, 0],
                        [5.49e-09, 4.87733288264, 88.865680217],
                        [5.04e-09, 4.77955496203, 419.4846438752],
                        [3.46e-09, 4.31847547394, 853.196381752],
                        [3.92e-09, 5.69922389094, 654.1243803156],
                        [2.42e-09, 2.05052677361, 323.5054166574],
                        [2.66e-09, 1.11384528244, 234.6397364404],
                        [1.99e-09, 0.88505901097, 309.2783226558],
                        [2.58e-09, 5.10074489186, 95.9792272178],
                        [1.66e-09, 2.40063312194, 515.463871093],
                        [1.55e-09, 4.70433216164, 860.3099287528],
                        [8.9e-10, 1.3637107038, 412.3710968744],
                        [1.02e-09, 0.49450039082, 117.3198682202],
                      ],
          },
        ],
        [
          {
            series => "B0",
            terms  => [
                        [0.0433067804, 3.60284428399, 213.299095438],
                        [0.00240348303, 2.8523848939, 426.598190876],
                        [0.00084745939, 0, 0],
                        [0.00030863357, 3.48441504465, 220.4126424388],
                        [0.00034116063, 0.57297307844, 206.1855484372],
                        [0.0001473407, 2.1184659787, 639.897286314],
                        [9.916668e-05, 5.79003189405, 419.4846438752],
                        [6.993564e-05, 4.73604689179, 7.1135470008],
                        [4.807587e-05, 5.43305315602, 316.3918696566],
                        [4.788392e-05, 4.9651292742, 110.2063212194],
                        [3.432125e-05, 2.73255752123, 433.7117378768],
                        [1.506129e-05, 6.01304536144, 103.0927742186],
                        [1.060298e-05, 5.63099292414, 529.6909650946],
                        [9.69071e-06, 5.20434966103, 632.7837393132],
                        [9.4205e-06, 1.39646678088, 853.196381752],
                        [7.07645e-06, 3.80302329547, 323.5054166574],
                        [5.52313e-06, 5.13149109045, 202.2533951741],
                        [3.99675e-06, 3.35891413961, 227.5261894396],
                        [3.16063e-06, 1.99716764199, 647.0108333148],
                        [3.1938e-06, 3.6257155098, 209.3669421749],
                        [2.84494e-06, 4.88648481625, 224.3447957019],
                        [3.14225e-06, 0.4651027241, 217.2312487011],
                        [2.36442e-06, 2.13887472281, 11.0457002639],
                        [2.15354e-06, 5.94982610103, 846.0828347512],
                        [2.08522e-06, 2.12003893769, 415.5524906121],
                        [1.78958e-06, 2.95361514672, 63.7358983034],
                        [2.07213e-06, 0.73021462851, 199.0720014364],
                        [1.3914e-06, 1.9982199094, 735.8765135318],
                        [1.34884e-06, 5.24500819605, 742.9900605326],
                        [1.40585e-06, 0.64417620299, 490.3340891794],
                        [1.21669e-06, 3.11537140876, 522.5774180938],
                        [1.3924e-06, 4.59535168021, 14.2270940016],
                        [1.15524e-06, 3.10891547171, 216.4804891757],
                        [1.14218e-06, 0.96261442133, 210.1177017003],
                        [9.6376e-07, 4.48164339766, 117.3198682202],
                        [8.0593e-07, 1.3169275015, 277.0349937414],
                        [7.2952e-07, 3.0598848237, 536.8045120954],
                        [6.9261e-07, 4.92378633635, 309.2783226558],
                        [7.4302e-07, 2.8937653962, 149.5631971346],
                        [6.804e-07, 2.18002263974, 351.8165923087],
                        [6.1734e-07, 0.67728106562, 1066.49547719],
                        [5.6598e-07, 2.60963391288, 440.8252848776],
                        [4.8864e-07, 5.78725874107, 95.9792272178],
                        [4.8243e-07, 2.1821183743, 74.7815985673],
                        [3.8304e-07, 5.29151303843, 1059.3819301892],
                        [3.6323e-07, 1.63348365121, 628.8515860501],
                        [3.5055e-07, 1.71279210041, 1052.2683831884],
                        [3.427e-07, 2.45740470599, 422.6660376129],
                        [3.4313e-07, 5.97994514798, 412.3710968744],
                        [3.3787e-07, 1.14073392951, 949.1756089698],
                        [3.1633e-07, 4.14722153007, 437.6438911399],
                        [3.6833e-07, 6.27769966148, 1162.4747044078],
                        [2.698e-07, 1.2715481681, 860.3099287528],
                        [2.3516e-07, 2.74936525342, 838.9692877504],
                        [2.346e-07, 0.98962849901, 210.8514148832],
                        [2.36e-07, 4.11386961467, 3.9321532631],
                        [2.3631e-07, 3.07427204313, 215.7467759928],
                        [2.0813e-07, 3.51084686918, 330.6189636582],
                        [1.9509e-07, 2.81857577372, 127.4717966068],
                        [1.7103e-07, 3.89784279922, 214.2623032845],
                        [1.7635e-07, 6.19715516746, 703.6331846174],
                        [1.7824e-07, 2.28524493886, 388.4651552382],
                        [2.0935e-07, 0.14356167048, 430.5303441391],
                        [1.6551e-07, 1.66649120724, 38.1330356378],
                        [1.91e-07, 2.97699096081, 137.0330241624],
                        [1.5517e-07, 4.54798410406, 956.2891559706],
                        [1.7065e-07, 0.16611115812, 212.3358875915],
                        [1.4169e-07, 0.48937283445, 213.3472795478],
                        [1.9027e-07, 6.27326062836, 423.4167971383],
                        [1.3344e-07, 2.37136126257, 429.7795846137],
                        [1.2565e-07, 1.03178071173, 563.6312150384],
                        [1.4173e-07, 3.57477564831, 213.2509113282],
                        [1.1374e-07, 1.45300927024, 1368.660252845],
                        [1.0585e-07, 6.1763342593, 200.7689224658],
                        [1.06e-07, 3.84358958373, 138.5174968707],
                        [1.0263e-07, 2.17423692422, 76.2660712756],
                        [1.0072e-07, 1.33197220789, 565.1156877467],
                        [1.2058e-07, 0.441492427, 222.8603229936],
                        [1.0367e-07, 1.85278552549, 350.3321196004],
                        [8.706e-08, 2.58144528603, 1155.361157407],
                        [8.47e-08, 1.97890349826, 625.6701923124],
                        [8.518e-08, 4.51649648578, 3.1813937377],
                        [7.439e-08, 4.92597321442, 212.7778305762],
                        [7.409e-08, 2.03506679104, 288.0806940053],
                        [8.137e-08, 3.98500592467, 85.8272988312],
                        [7.985e-08, 2.20794292064, 362.8622925726],
                        [6.61e-08, 6.14944028835, 417.0369633204],
                        [7.753e-08, 6.2366454907, 1478.8665740644],
                        [6.318e-08, 1.87388481013, 654.1243803156],
                        [6.319e-08, 1.17328438271, 1265.5674786264],
                        [5.841e-08, 2.35829915285, 750.1036075334],
                        [5.808e-08, 5.01602242794, 479.2883889155],
                        [8.079e-08, 0.42574715104, 554.0699874828],
                        [6.014e-08, 5.58952234348, 425.1137181677],
                        [7.444e-08, 5.41859596459, 213.8203602998],
                        [7.567e-08, 2.68446523795, 191.2076949102],
                        [7.421e-08, 4.19354269508, 9.5612275556],
                        [5.466e-08, 3.21737829505, 234.6397364404],
                        [5.661e-08, 1.4698271355, 265.9892934775],
                        [5.851e-08, 4.81776629912, 1.4844727083],
                        [5.341e-08, 3.45755372717, 203.7378678824],
                        [4.96e-08, 1.04628615559, 12.5301729722],
                        [4.92e-08, 3.85622235967, 173.9422195228],
                        [4.883e-08, 1.94823282939, 195.1398481733],
                        [5.621e-08, 0.81869581274, 52.6901980395],
                        [5.2e-08, 3.32827437636, 515.463871093],
                        [4.927e-08, 3.81806549732, 225.8292684102],
                        [5.033e-08, 0.10756875163, 252.6559713532],
                        [4.416e-08, 5.45506938037, 408.4389436113],
                        [4.169e-08, 1.21145214135, 1685.0521225016],
                        [4.066e-08, 6.24213578122, 1279.794572628],
                        [3.972e-08, 6.13850317719, 217.491881132],
                        [5.398e-08, 5.67212179194, 1375.7737998458],
                        [3.916e-08, 5.96105725915, 210.3783341312],
                        [4.017e-08, 0.99840226682, 842.1506814881],
                        [3.899e-08, 4.58983662507, 1272.6810256272],
                        [3.764e-08, 3.30663337976, 212.5483359126],
                        [4.345e-08, 3.1856224183, 414.0680179038],
                        [3.565e-08, 4.75262007127, 207.8824694666],
                        [3.542e-08, 2.30814954338, 1471.7530270636],
                        [3.732e-08, 1.61040235688, 635.9651330509],
                        [3.709e-08, 2.97082943086, 223.5940361765],
                        [3.576e-08, 3.83436862558, 483.2205421786],
                        [4.053e-08, 3.72105017218, 942.062061969],
                        [3.756e-08, 0.74987556308, 214.0498549634],
                        [3.162e-08, 3.64550741, 207.6700211455],
                        [3.149e-08, 2.27647454229, 728.762966531],
                        [3.971e-08, 4.37874143597, 216.2198567448],
                        [3.541e-08, 5.62281936827, 218.7157214094],
                        [2.965e-08, 3.40117024932, 650.9429865779],
                        [3.949e-08, 4.1972891245, 209.106309744],
                        [2.853e-08, 4.81077453523, 231.4583427027],
                        [2.826e-08, 0.86682282341, 217.964961884],
                        [2.97e-08, 5.75162134301, 160.6088973985],
                        [2.724e-08, 0.47941267764, 497.4476361802],
                        [2.787e-08, 4.03144791896, 62.2514255951],
                        [2.605e-08, 5.04152791794, 65.2203710117],
                        [2.652e-08, 0.30602610654, 424.1505103212],
                        [2.543e-08, 2.76499056123, 543.9180590962],
                        [2.485e-08, 5.78396049817, 99.1606209555],
                        [3.209e-08, 0.42853440759, 218.9281697305],
                        [2.509e-08, 2.947045891, 70.8494453042],
                        [2.308e-08, 0.63861650866, 251.4321310758],
                        [2.869e-08, 4.31959346745, 767.3690829208],
                        [2.232e-08, 0.56929937568, 1073.6090241908],
                        [2.245e-08, 1.69945964547, 488.8496164711],
                        [2.283e-08, 1.55589787463, 601.7642506762],
                        [2.384e-08, 4.4458349331, 21.3406410024],
                        [2.096e-08, 5.77425542767, 88.865680217],
                        [2.363e-08, 3.35786310868, 124.433415221],
                        [2.162e-08, 6.24029269257, 1795.258443721],
                        [2.452e-08, 3.19804814047, 208.633228992],
                        [2.033e-08, 4.87029603776, 327.4375699205],
                        [1.95e-08, 5.56004000293, 18.1592472647],
                        [2.283e-08, 4.22375355881, 22.0914005278],
                        [2.217e-08, 4.6143309463, 302.164775655],
                        [1.888e-08, 5.45600788064, 142.4496501338],
                        [2.075e-08, 3.55622165076, 1169.5882514086],
                        [2.069e-08, 2.75786819366, 491.8185618877],
                        [1.81e-08, 5.96568495526, 213.1872208534],
                        [1.813e-08, 1.39785500313, 211.8146227297],
                        [1.843e-08, 1.15001484281, 203.0041546995],
                        [1.854e-08, 1.41350087782, 1581.959348283],
                        [1.697e-08, 3.23613719814, 427.5613987225],
                        [1.736e-08, 5.45933992115, 916.9322800554],
                        [1.714e-08, 6.14729146384, 643.8294395771],
                        [1.948e-08, 5.70817363392, 425.6349830295],
                        [1.77e-08, 3.36194411768, 248.7238180901],
                        [1.611e-08, 0.97888081762, 2001.4439921582],
                        [1.971e-08, 2.59654430358, 429.0458714308],
                        [1.628e-08, 0.74011617198, 177.8743727859],
                        [1.564e-08, 2.04342011485, 1788.1448967202],
                        [1.574e-08, 6.01995224314, 426.6463749858],
                        [1.939e-08, 5.4813466938, 636.7158925763],
                        [1.651e-08, 4.61629429952, 621.7380390493],
                        [1.552e-08, 2.55542734908, 692.5874843535],
                        [1.484e-08, 6.17173980637, 56.6223513026],
                        [1.782e-08, 3.26122906302, 175.1660598002],
                        [1.503e-08, 2.59953333916, 228.276948965],
                        [1.559e-08, 0.36281050773, 776.9303104764],
                        [1.799e-08, 3.4639597697, 1258.4539316256],
                        [1.521e-08, 3.75588462293, 213.5115437591],
                        [1.81e-08, 4.37552745264, 213.4109700226],
                        [1.521e-08, 0.30214462385, 213.0866471169],
                        [1.608e-08, 4.66724132818, 269.9214467406],
                        [1.525e-08, 1.47939329423, 198.321241911],
                        [1.408e-08, 1.3849184675, 501.3797894433],
                        [1.327e-08, 0.23760037979, 148.0787244263],
                        [1.305e-08, 2.41201772023, 275.5505210331],
                        [1.578e-08, 2.82443242444, 426.5500067662],
                        [1.203e-08, 1.36928065935, 235.3904959658],
                        [1.296e-08, 5.75203277385, 1692.1656695024],
                        [1.295e-08, 3.04090959062, 831.8557407496],
                        [1.283e-08, 1.62400181159, 643.0786800517],
                        [1.617e-08, 1.31181209458, 214.7835681463],
                        [1.346e-08, 4.01262069353, 278.5194664497],
                        [1.166e-08, 0.09590019561, 340.7708920448],
                        [1.115e-08, 2.20460481017, 221.3758502853],
                        [1.176e-08, 1.07528227869, 312.1990839626],
                        [1.107e-08, 1.50329021421, 289.5651667136],
                        [1.143e-08, 4.40125874383, 213.5597278689],
                        [1.253e-08, 0.21632769953, 404.5067903482],
                        [1.074e-08, 3.17412275025, 98.8999885246],
                        [1.103e-08, 0.23626839162, 617.8058857862],
                        [1.077e-08, 3.51670933532, 312.4597163935],
                        [1.039e-08, 0.53953974796, 778.4147831847],
                        [1.195e-08, 2.11232088496, 205.2223405907],
                        [1.093e-08, 5.16243153571, 630.3360587584],
                        [1.143e-08, 5.93977485365, 213.0384630071],
                        [1.04e-08, 4.79631324365, 106.2741679563],
                        [1.1e-08, 0.02509241739, 219.4494345923],
                        [1.311e-08, 5.93900415785, 436.1594184316],
                        [1.26e-08, 0.72481995446, 355.7487455718],
                        [9.5e-09, 2.00801292252, 1045.1548361876],
                        [1.186e-08, 1.84906064486, 151.0476698429],
                        [9.74e-09, 3.01092368346, 696.5196376166],
                        [9.24e-09, 4.88158186437, 39.3568759152],
                        [9.61e-09, 2.80113869315, 738.7972748386],
                        [1.011e-08, 6.27004359435, 121.2520214833],
                        [9.04e-09, 4.15218356485, 426.0769260142],
                        [9.04e-09, 4.24232505252, 10.2949407385],
                        [8.95e-09, 2.47587956888, 447.9388318784],
                        [1.186e-08, 0.85270715988, 525.4981794006],
                        [8.24e-09, 3.97540449663, 210.5907824523],
                        [8.31e-09, 4.05299295705, 207.1487562837],
                        [9.37e-09, 5.44353432307, 344.7030453079],
                        [8.23e-09, 2.08766677969, 358.9301393095],
                        [9.71e-09, 5.09512804595, 1589.0728952838],
                        [1.037e-08, 1.04152859909, 2.4476805548],
                        [8.16e-09, 0.62175655307, 188.9200730498],
                        [7.98e-09, 3.36396062989, 237.6781178262],
                        [7.55e-09, 5.90983584858, 284.1485407422],
                        [8.7e-09, 1.62765846893, 114.1384744825],
                        [7.34e-09, 6.23523714922, 2111.6503133776],
                        [7.67e-09, 2.73651219269, 627.3671133418],
                        [7.01e-09, 0.72526525525, 10213.285546211],
                        [8.01e-09, 5.84130533519, 905.8865797915],
                        [7.1e-09, 1.78740818763, 2104.5367663768],
                        [6.7e-09, 0.7583937489, 2317.8358618148],
                        [7.2e-09, 4.95645178898, 638.4128136057],
                        [7.96e-09, 4.87623914638, 342.2553647531],
                        [7.03e-09, 0.35096991676, 220.4608265486],
                        [8.35e-09, 3.1949282564, 1574.8458012822],
                        [8.24e-09, 0.08813665925, 216.0074084237],
                        [6.53e-09, 4.1959963539, 247.2393453818],
                        [8.26e-09, 4.66845240923, 427.1194557378],
                        [6.9e-09, 0.41873449575, 5856.4776591154],
                        [6.9e-09, 1.34023204821, 6283.0758499914],
                        [6.9e-09, 0.58291546593, 213.4591541324],
                        [6.39e-09, 1.20304559619, 867.4234757536],
                        [8.3e-09, 1.57233214789, 1898.3512179396],
                        [7.53e-09, 1.5118797088, 576.1613880106],
                        [6.29e-09, 2.83598833891, 420.9691165835],
                        [6.9e-09, 3.48062808501, 213.1390367436],
                        [6e-09, 5.22938546212, 212.0270710508],
                        [5.65e-09, 5.28099337758, 423.6774295692],
                        [5.52e-09, 5.83265103738, 84.3428261229],
                        [5.46e-09, 3.56588711151, 1485.9801210652],
                        [6.42e-09, 6.15007145598, 179.3588454942],
                        [6.97e-09, 1.91977327925, 134.5853436076],
                        [6.48e-09, 5.15917450752, 8.0767548473],
                        [5.51e-09, 3.33109164145, 980.6681783588],
                        [5.11e-09, 3.87073988213, 125.9873238985],
                        [5.06e-09, 0.80261216855, 181.0557665236],
                        [5.64e-09, 4.05871107615, 831.1049812242],
                        [6.81e-09, 3.45804290093, 220.364458329],
                        [5.41e-09, 2.39252901431, 421.93232443],
                        [4.98e-09, 3.11515053568, 439.1283638482],
                        [5.17e-09, 2.754300048, 1148.2476104062],
                        [4.91e-09, 4.47199498503, 558.0021407459],
                        [4.67e-09, 4.18144797677, 444.7574381407],
                        [4.58e-09, 0.60848440253, 206.233732547],
                        [5.42e-09, 3.28613020157, 245.5424243524],
                        [4.77e-09, 5.48556902348, 35.4247226521],
                        [4.74e-09, 2.42545073874, 436.8931316145],
                        [4.81e-09, 3.72498040536, 206.1373643274],
                        [4.35e-09, 1.61732308614, 191.9584544356],
                        [4.88e-09, 0.2605996965, 416.3032501375],
                        [4.93e-09, 4.13699180247, 518.6452648307],
                        [5.95e-09, 5.11706007934, 214.5711198252],
                        [4.86e-09, 5.17710069856, 67.6680515665],
                        [4.63e-09, 5.53192185211, 418.5214360287],
                        [4.21e-09, 5.57377685121, 430.79097657],
                        [4.46e-09, 6.20735049659, 73.297125859],
                        [4.21e-09, 4.65837340438, 543.0242872189],
                        [4.35e-09, 2.9525655435, 5.4166259714],
                        [4.16e-09, 4.36391909218, 113.3877149571],
                        [4.95e-09, 5.38121485133, 391.1734682239],
                        [5.2e-09, 3.99939347071, 618.5566453116],
                        [4.29e-09, 3.26903461513, 144.1465711632],
                        [4.35e-09, 1.60816661416, 2214.7430875962],
                        [3.98e-09, 2.38329818919, 299.1263942692],
                        [3.99e-09, 0.06301179341, 206.706813299],
                        [3.94e-09, 2.75496219113, 425.8474313506],
                        [5.08e-09, 2.86873328929, 337.732510659],
                        [4.75e-09, 5.68530292289, 320.3240229197],
                        [4.32e-09, 0.68132398291, 116.4260963429],
                        [4.04e-09, 1.84249441289, 9786.687355335],
                        [3.71e-09, 5.83382962844, 2008.557539159],
                        [3.82e-09, 4.24995364794, 387.2413149608],
                        [4.16e-09, 3.81986946256, 429.5189521828],
                        [4.91e-09, 4.18623117082, 219.891377577],
                        [3.52e-09, 1.65610545221, 963.4027029714],
                        [3.53e-09, 5.5020900346, 305.3461693927],
                        [4.31e-09, 4.39380503963, 353.301065017],
                        [3.75e-09, 2.67828133567, 319.5732633943],
                        [3.59e-09, 3.54801032661, 421.1815649046],
                        [3.39e-09, 5.19074405462, 69.1525242748],
                        [3.58e-09, 1.11857595997, 1044.4040766622],
                        [3.34e-09, 1.8426099474, 1361.5467058442],
                        [3.28e-09, 6.07106596408, 710.7467316182],
                        [3.28e-09, 1.48618893585, 2420.9286360334],
                        [3.59e-09, 5.62797136991, 78.7137518304],
                        [4.05e-09, 2.91366762549, 1891.2376709388],
                        [3.98e-09, 2.08900381937, 4.665866446],
                        [3.26e-09, 1.62373774313, 5.6290742925],
                        [4.05e-09, 1.87470341223, 114.3991069134],
                        [3.93e-09, 0.56487847337, 128.9562693151],
                        [3.12e-09, 5.29291124448, 347.8844390456],
                        [3.1e-09, 0.31232452686, 427.3489504014],
                        [3.08e-09, 2.84912656825, 487.3651437628],
                        [2.91e-09, 3.2597776278, 494.2662424425],
                        [3.03e-09, 4.9396287369, 373.9079928365],
                        [2.89e-09, 2.83591185309, 212.0752551606],
                        [2.89e-09, 2.0537143135, 214.5229357154],
                        [3.98e-09, 6.03822674845, 432.2272651685],
                        [2.88e-09, 6.16001418475, 969.6224780949],
                        [2.96e-09, 0.3033252409, 1055.4497769261],
                        [2.8e-09, 1.29728455136, 241.6102710893],
                        [2.8e-09, 5.41630221077, 1493.093668066],
                        [3.15e-09, 6.24003908326, 465.9550667912],
                        [2.74e-09, 5.03981944861, 458.8415197904],
                        [2.96e-09, 3.04457317761, 211.6021744086],
                        [2.74e-09, 2.72607352851, 145.6310438715],
                        [2.93e-09, 1.32452002382, 159.1244246902],
                        [2.63e-09, 6.11559198968, 2428.0421830342],
                        [3.23e-09, 1.17502395659, 815.0633461142],
                        [3.45e-09, 5.37083374878, 428.0826635843],
                        [2.58e-09, 0.43205106363, 2634.2277314714],
                        [2.75e-09, 0.91628212149, 849.2642284889],
                        [3.4e-09, 1.29378813067, 329.7251917809],
                        [2.94e-09, 4.29399534634, 4.192785694],
                        [3.39e-09, 1.03883773894, 32.2433289144],
                        [2.44e-09, 3.52504227332, 184.9879197867],
                        [2.43e-09, 3.13047989401, 525.7588118315],
                        [2.6e-09, 5.99216785208, 20.6069278195],
                        [3.03e-09, 3.96772261614, 934.9485149682],
                        [2.85e-09, 5.69474711283, 220.9339073006],
                        [2.39e-09, 2.09516779457, 292.0128472684],
                        [2.42e-09, 0.98744748894, 282.4516197128],
                        [2.78e-09, 2.81667003542, 87.3117715395],
                        [2.85e-09, 4.76303256917, 54.1746707478],
                        [2.36e-09, 5.79560286324, 280.9671470045],
                        [2.46e-09, 1.83689902078, 214.9960164674],
                        [2.21e-09, 0.48302467341, 153.4953503977],
                        [2.38e-09, 3.52738705554, 267.4737661858],
                        [2.93e-09, 5.91401607974, 14.977853527],
                        [2.35e-09, 0.29884419224, 14.0146456805],
                        [2.29e-09, 3.91975580405, 182.279606801],
                        [2.17e-09, 3.9632856194, 894.8408795276],
                        [2.18e-09, 1.46057992688, 2531.1349572528],
                        [2.1e-09, 2.01138855049, 211.8628068395],
                        [2.1e-09, 2.8782376161, 214.7353840365],
                        [2.23e-09, 2.49651288358, 1464.6394800628],
                        [2.17e-09, 4.03234048538, 835.0371344873],
                        [2.09e-09, 2.97542058241, 273.1028404783],
                        [2.1e-09, 2.56849303008, 593.426863398],
                        [2.18e-09, 1.7185910151, 0.9632078465],
                        [2.32e-09, 1.86083014117, 221.1634019642],
                        [1.99e-09, 3.53454927143, 219.6618829134],
                        [1.97e-09, 2.65338829617, 864.2420820159],
                        [2.19e-09, 3.46267185338, 1182.9215735329],
                        [1.99e-09, 2.56046317223, 264.5048207692],
                        [1.99e-09, 2.035087089, 757.2171545342],
                        [2.37e-09, 5.05443109284, 254.9435932136],
                        [1.91e-09, 2.07106909876, 756.3233826569],
                        [1.92e-09, 1.67985944172, 1677.9385755008],
                        [1.91e-09, 1.05067348453, 702.1487119091],
                        [1.81e-09, 1.89151852263, 6.1503391543],
                        [2.05e-09, 1.98151360584, 199.2844497575],
                        [1.81e-09, 1.25381796494, 2737.32050569],
                        [1.86e-09, 2.81416016738, 569.0478410098],
                        [2.15e-09, 4.52373060846, 3060.8259223474],
                        [2.22e-09, 2.90133577623, 205.4347889118],
                        [2.46e-09, 3.55891849574, 1251.3403846248],
                        [1.91e-09, 4.20221553993, 556.5176680376],
                        [2.17e-09, 2.6450996717, 2207.6295405954],
                        [2.25e-09, 0.14271906959, 131.4039498699],
                        [1.89e-09, 1.27260556263, 192.6921676185],
                        [1.79e-09, 6.15189171649, 2.9207613068],
                        [1.78e-09, 2.01622328964, 705.1176573257],
                        [1.81e-09, 3.62483757675, 233.9060232575],
                        [1.88e-09, 2.9283680984, 227.3137411185],
                        [1.64e-09, 3.50682537694, 1382.8873468466],
                        [1.66e-09, 5.85452227121, 637.4496057592],
                        [1.6e-09, 0.13309484488, 431.264057322],
                        [1.58e-09, 5.92242110049, 96.8729990951],
                        [1.78e-09, 4.55557913565, 46.470422916],
                        [1.57e-09, 1.35908014451, 51.2057253312],
                        [1.55e-09, 6.24092514222, 464.7312265138],
                        [1.55e-09, 6.02684189458, 1286.9081196288],
                        [1.55e-09, 1.36669731999, 206.9363079626],
                        [1.75e-09, 4.95121713507, 1905.4647649404],
                        [1.53e-09, 6.06094547271, 561.1835344836],
                        [2.08e-09, 4.50537355579, 24.3790223882],
                        [1.85e-09, 5.49802440713, 205.6642835754],
                        [1.6e-09, 4.18196878816, 3340.6124266998],
                        [1.6e-09, 2.85370771355, 209.1544938538],
                        [1.61e-09, 4.98020340619, 2648.454825473],
                        [1.52e-09, 0.85558875667, 570.7447620392],
                        [1.56e-09, 2.03601440129, 217.4436970222],
                        [1.92e-09, 3.98017256784, 212.4053235607],
                        [1.92e-09, 0.90945359875, 214.1928673153],
                        [1.98e-09, 3.54289000289, 533.6231183577],
                        [1.6e-09, 2.51522796187, 3127.3133312618],
                        [1.45e-09, 0.93414637377, 1994.3304451574],
                        [1.41e-09, 5.66801998888, 120.358249606],
                        [1.41e-09, 3.88995778619, 454.9093665273],
                        [1.52e-09, 1.01453902153, 2840.4132799086],
                        [1.72e-09, 4.15145223592, 2.9689454166],
                        [1.46e-09, 5.26789260159, 7.065362891],
                        [1.77e-09, 0.43196690516, 140.001969579],
                        [1.44e-09, 3.95680110579, 300.6108669775],
                        [1.52e-09, 4.29475572258, 555.5544601911],
                        [1.43e-09, 4.15264164139, 31.019488637],
                        [1.38e-09, 4.20096561019, 731.9443602687],
                        [1.39e-09, 0.79924371385, 166.828672522],
                        [1.35e-09, 1.27192121638, 92.940845832],
                        [1.65e-09, 1.94881873062, 107.0249274817],
                        [1.53e-09, 3.07590434707, 3480.3105662226],
                        [1.25e-09, 3.41796878361, 1802.3719907218],
                        [1.28e-09, 5.83700968658, 2324.9494088156],
                        [1.29e-09, 2.75851443754, 480.7728616238],
                        [1.22e-09, 4.75728514255, 2854.6403739102],
                        [1.29e-09, 4.67730374872, 913.9633346388],
                        [1.21e-09, 1.19957548726, 572.2292347475],
                        [1.46e-09, 3.7123287785, 546.956440482],
                        [1.2e-09, 4.59083886034, 339.2864193365],
                        [1.27e-09, 6.19372294369, 59.8037450403],
                        [1.23e-09, 5.9848439397, 477.8039162072],
                        [1.22e-09, 5.82973501131, 990.2294059144],
                        [1.51e-09, 2.39413061881, 2524.021410252],
                        [1.47e-09, 4.9819929177, 850.0149880143],
                        [1.27e-09, 0.47350572907, 6.592282139],
                        [1.16e-09, 4.71488890981, 1130.2313754934],
                        [1.29e-09, 5.42665311725, 2538.2485042536],
                        [1.11e-09, 4.51520219898, 1699.2792165032],
                        [1.14e-09, 2.06120434865, 952.0963702766],
                        [1.12e-09, 4.14736642579, 422.405405182],
                        [1.11e-09, 5.53230411085, 857.1285350151],
                        [1.09e-09, 3.00005651288, 420.4478517217],
                        [1.12e-09, 2.20667724213, 395.578702239],
                        [1.47e-09, 1.52324472511, 552.5855147745],
                        [1.18e-09, 5.47495367121, 2957.7331481288],
                        [1.13e-09, 2.57036693965, 462.0229135281],
                        [1.22e-09, 4.96246567897, 638.9340784675],
                        [1.04e-09, 1.91139383428, 472.1748419147],
                        [1.16e-09, 2.82742160564, 450.9772132642],
                        [1.15e-09, 2.26043201622, 1781.0313497194],
                        [1.1e-09, 4.86686492403, 2914.0142358238],
                        [1.09e-09, 4.4384872728, 405.9912630565],
                        [1.02e-09, 5.90112611078, 99.9113804809],
                        [1.01e-09, 2.5339241033, 640.8604941605],
                        [1.12e-09, 5.53802838779, 381.3516082374],
                        [9.9e-10, 5.92199927896, 411.620337349],
                        [1e-09, 5.21941099517, 426.4863162914],
                        [1.37e-09, 2.20269111622, 7.1617311106],
                        [9.7e-10, 1.27914551364, 2847.5268269094],
                        [1.15e-09, 5.22953781515, 1119.1856752295],
                        [9.5e-10, 4.26135357007, 540.7366653585],
                        [9.8e-10, 5.27107833435, 639.9454704238],
                        [1.07e-09, 4.38879925113, 412.5835451955],
                        [9.3e-10, 5.35954173624, 334.5511169213],
                        [9.4e-10, 1.16749092536, 5643.1785636774],
                        [1.06e-09, 4.19443004843, 486.4019359163],
                        [9.6e-10, 0.59816870672, 714.6788848813],
                        [9.4e-10, 0.54205024076, 423.6292454594],
                        [1.09e-09, 2.82817225044, 468.2426886516],
                        [8.3e-10, 6.12100285205, 380.12776796],
                        [8.4e-10, 2.20217125255, 909.8187330546],
                        [8.5e-10, 5.20920130934, 562.1467423301],
                        [1.05e-09, 2.66415710279, 460.5384408198],
                        [8.4e-10, 0.14646013561, 681.5417840896],
                        [8e-10, 3.03551986945, 409.9234163196],
                        [9.7e-10, 5.09373549436, 92.0470739547],
                        [1.1e-09, 2.03622569317, 642.3449668688],
                        [8e-10, 5.71035549752, 361.3778198643],
                        [8.4e-10, 3.00961145133, 426.8106391971],
                        [8.5e-10, 4.28770375688, 135.5485514541],
                        [9.3e-10, 5.32943472274, 432.0148168474],
                        [8.6e-10, 1.51247258028, 760.25553592],
                        [8.4e-10, 5.83905303748, 426.3857425549],
                        [1e-09, 3.62925349363, 426.7100654606],
                        [9.4e-10, 4.30151510535, 3377.217792004],
                        [9.8e-10, 2.07334671974, 639.8491022042],
                        [8e-10, 4.11576173565, 774.4826299216],
                        [7.5e-10, 2.8912265661, 806.725958836],
                        [8e-10, 0.88468467902, 856.3777754897],
                        [7.2e-10, 4.85259171933, 392.6579409322],
                        [8.3e-10, 0.11133738383, 402.2191684878],
                      ],
          },
          {
            series => "B1",
            terms  => [
                        [0.00397554998, 5.33289992556, 213.299095438],
                        [0.00049478641, 3.14159265359, 0],
                        [0.00018571607, 6.09919206378, 426.598190876],
                        [0.00014800587, 2.3058606052, 206.1855484372],
                        [9.643981e-05, 1.6967466012, 220.4126424388],
                        [3.757161e-05, 1.25429514018, 419.4846438752],
                        [2.716647e-05, 5.91166664787, 639.897286314],
                        [1.455309e-05, 0.85161616532, 433.7117378768],
                        [1.290595e-05, 2.9177085709, 7.1135470008],
                        [8.5263e-06, 0.43572078997, 316.3918696566],
                        [2.84386e-06, 1.61881754773, 227.5261894396],
                        [2.92185e-06, 5.3157425127, 853.196381752],
                        [2.7509e-06, 3.88864137336, 103.0927742186],
                        [2.97726e-06, 0.91909206723, 632.7837393132],
                        [1.72359e-06, 0.05215146556, 647.0108333148],
                        [1.27731e-06, 1.20711452525, 529.6909650946],
                        [1.66237e-06, 2.44351613165, 199.0720014364],
                        [1.5822e-06, 5.20850125766, 110.2063212194],
                        [1.09839e-06, 2.45695551627, 217.2312487011],
                        [8.1759e-07, 2.75839171353, 210.1177017003],
                        [8.101e-07, 2.86038377187, 14.2270940016],
                        [6.8658e-07, 1.65537623146, 202.2533951741],
                        [5.9281e-07, 1.82410768234, 323.5054166574],
                        [6.5161e-07, 1.25527521313, 216.4804891757],
                        [6.1024e-07, 1.25273412095, 209.3669421749],
                        [4.6386e-07, 0.81534705304, 440.8252848776],
                        [3.6163e-07, 1.81851057689, 224.3447957019],
                        [3.4041e-07, 2.83971297997, 117.3198682202],
                        [3.2164e-07, 1.18676132343, 846.0828347512],
                        [3.3114e-07, 1.3055708001, 412.3710968744],
                        [2.7282e-07, 4.64744847591, 1066.49547719],
                        [2.2805e-07, 4.12923703368, 415.5524906121],
                        [2.7128e-07, 4.44228739187, 11.0457002639],
                        [1.81e-07, 5.56392353608, 860.3099287528],
                        [2.0851e-07, 1.4099927374, 309.2783226558],
                        [1.4947e-07, 1.34302610607, 95.9792272178],
                        [1.5316e-07, 1.22393617996, 63.7358983034],
                        [1.4601e-07, 1.0075370497, 536.8045120954],
                        [1.2842e-07, 2.27059911053, 742.9900605326],
                        [1.2832e-07, 4.88898877901, 522.5774180938],
                        [1.3137e-07, 2.45991904379, 490.3340891794],
                        [1.1883e-07, 1.87308666696, 423.4167971383],
                        [1.3027e-07, 3.21731634178, 277.0349937414],
                        [9.946e-08, 3.11650057543, 625.6701923124],
                        [1.271e-07, 0.29501589197, 422.6660376129],
                        [9.644e-08, 1.74586356703, 330.6189636582],
                        [8.079e-08, 2.41931187953, 430.5303441391],
                        [8.245e-08, 4.68121931659, 215.7467759928],
                        [8.958e-08, 0.46482448501, 429.7795846137],
                        [6.547e-08, 3.01351967549, 949.1756089698],
                        [7.251e-08, 5.97098186912, 149.5631971346],
                        [6.056e-08, 1.491150111, 234.6397364404],
                        [5.791e-08, 5.36720639912, 735.8765135318],
                        [5.994e-08, 0.02442871989, 654.1243803156],
                        [6.647e-08, 3.90879134581, 351.8165923087],
                        [6.824e-08, 1.52456408861, 437.6438911399],
                        [5.134e-08, 3.81149834833, 74.7815985673],
                        [3.959e-08, 5.63505813057, 210.8514148832],
                        [3.811e-08, 2.63992803111, 3.1813937377],
                        [3.643e-08, 1.73267151007, 1059.3819301892],
                        [3.554e-08, 4.98621474362, 3.9321532631],
                        [4.568e-08, 4.33599514584, 628.8515860501],
                        [3.145e-08, 2.51404811765, 1162.4747044078],
                        [3.522e-08, 1.16093567319, 223.5940361765],
                        [2.933e-08, 2.06057834252, 956.2891559706],
                        [2.644e-08, 5.62559379305, 203.7378678824],
                        [2.992e-08, 5.06312015437, 515.463871093],
                        [2.304e-08, 2.73123930535, 21.3406410024],
                        [2.168e-08, 2.91805928238, 203.0041546995],
                        [2.398e-08, 3.99421633537, 1279.794572628],
                        [2.146e-08, 0.87500689888, 408.4389436113],
                        [2.074e-08, 1.65731069687, 137.0330241624],
                        [1.797e-08, 1.56879308343, 124.433415221],
                        [2.088e-08, 1.85721384366, 138.5174968707],
                        [1.769e-08, 4.82294294946, 1073.6090241908],
                        [1.635e-08, 1.20387813348, 88.865680217],
                        [2.202e-08, 5.93027042684, 1052.2683831884],
                        [1.843e-08, 0.22126910774, 750.1036075334],
                        [1.851e-08, 2.4547040929, 340.7708920448],
                        [1.89e-08, 0.41025631859, 127.4717966068],
                        [1.582e-08, 5.63360832372, 214.2623032845],
                        [1.92e-08, 3.77935901504, 350.3321196004],
                        [1.786e-08, 5.78644477326, 635.9651330509],
                        [1.497e-08, 3.1302689321, 703.6331846174],
                        [1.583e-08, 3.46882532865, 38.1330356378],
                        [1.577e-08, 4.02973226017, 388.4651552382],
                        [1.645e-08, 5.59115773632, 483.2205421786],
                        [1.405e-08, 4.07880624509, 728.762966531],
                        [1.498e-08, 5.87094430469, 362.8622925726],
                        [1.317e-08, 2.22386203585, 213.3472795478],
                        [1.321e-08, 2.91534782718, 1265.5674786264],
                        [1.307e-08, 5.41748323885, 217.964961884],
                        [1.483e-08, 0.91111666841, 543.9180590962],
                        [1.291e-08, 2.6233380107, 554.0699874828],
                        [1.406e-08, 0.34582712649, 85.8272988312],
                        [1.287e-08, 2.82247279651, 231.4583427027],
                        [1.563e-08, 4.88438049382, 208.633228992],
                        [1.316e-08, 5.30963570131, 213.2509113282],
                        [1.164e-08, 1.39531381032, 210.3783341312],
                        [1.295e-08, 2.46089213219, 200.7689224658],
                        [1.236e-08, 3.03659580871, 838.9692877504],
                        [1.449e-08, 4.00934078371, 195.1398481733],
                        [1.251e-08, 1.46674521697, 218.7157214094],
                        [1.568e-08, 1.89939852487, 212.3358875915],
                        [1.067e-08, 5.34734443894, 207.6700211455],
                        [1.111e-08, 0.70962013461, 447.9388318784],
                        [1.012e-08, 1.3721722064, 636.7158925763],
                        [1.163e-08, 6.00108996618, 191.2076949102],
                        [8.87e-09, 2.84483069917, 191.9584544356],
                        [1.005e-08, 2.72373040634, 1478.8665740644],
                        [8.79e-09, 1.19585734916, 417.0369633204],
                        [8.29e-09, 4.94182950387, 497.4476361802],
                        [8.78e-09, 6.24981924813, 265.9892934775],
                        [7.81e-09, 4.61973017912, 424.1505103212],
                        [9.24e-09, 3.64210508536, 222.8603229936],
                        [9.71e-09, 2.89404568581, 563.6312150384],
                        [9.46e-09, 5.72987725592, 1368.660252845],
                        [8.34e-09, 6.12384852532, 209.106309744],
                        [9.11e-09, 1.06795057723, 650.9429865779],
                        [7.31e-09, 0.81660632103, 142.4496501338],
                        [7.95e-09, 5.54574074566, 76.2660712756],
                        [1.012e-08, 5.97140626297, 643.0786800517],
                        [7.03e-09, 2.41479303782, 10.2949407385],
                        [7.26e-09, 4.52598413209, 565.1156877467],
                        [6.91e-09, 2.31682364985, 160.6088973985],
                        [6.95e-09, 0.37889317398, 212.7778305762],
                        [6.76e-09, 4.436062709, 842.1506814881],
                        [7.69e-09, 4.47368582271, 52.6901980395],
                        [6.58e-09, 0.32331118921, 621.7380390493],
                        [8.38e-09, 4.68035046143, 288.0806940053],
                        [6.74e-09, 5.63961963995, 867.4234757536],
                        [6.95e-09, 1.32062509205, 1169.5882514086],
                        [8.41e-09, 2.46995220838, 1375.7737998458],
                        [6.33e-09, 3.46145143241, 18.1592472647],
                        [7.22e-09, 0.04119071457, 269.9214467406],
                        [7.57e-09, 2.15030650611, 207.8824694666],
                        [6.92e-09, 0.87072324976, 213.8203602998],
                        [6.02e-09, 0.85288769518, 225.8292684102],
                        [6.35e-09, 4.76109030475, 831.8557407496],
                        [7.01e-09, 1.20410854661, 479.2883889155],
                        [6.24e-09, 2.30585779534, 643.8294395771],
                        [5.82e-09, 0.18811617696, 1.4844727083],
                        [5.13e-09, 2.5652596784, 404.5067903482],
                        [5.02e-09, 4.97423814367, 212.5483359126],
                        [6.44e-09, 2.10955154583, 1272.6810256272],
                        [4.67e-09, 4.47217820662, 235.3904959658],
                        [5.66e-09, 4.44740324446, 429.0458714308],
                        [4.48e-09, 0.57491120802, 22.0914005278],
                        [5.2e-09, 1.15131866397, 337.732510659],
                        [4.76e-09, 4.78513362967, 218.9281697305],
                        [5.19e-09, 0.61616177345, 436.8931316145],
                        [4.42e-09, 2.10204008144, 416.3032501375],
                        [5.36e-09, 1.08779067908, 344.7030453079],
                        [4.77e-09, 2.42483193385, 216.2198567448],
                        [4.69e-09, 5.22622034028, 942.062061969],
                        [3.92e-09, 0.41137926465, 302.164775655],
                        [4e-09, 5.1721647847, 414.0680179038],
                        [3.83e-09, 3.58419227076, 1045.1548361876],
                        [4.43e-09, 1.11051326413, 425.1137181677],
                        [5.17e-09, 3.44547026103, 12.5301729722],
                        [3.69e-09, 1.60095273908, 56.6223513026],
                        [3.54e-09, 2.79123486392, 1581.959348283],
                        [4.05e-09, 5.93402105921, 173.9422195228],
                        [3.19e-09, 4.31850876624, 219.4494345923],
                        [3.3e-09, 0.62529198264, 358.9301393095],
                        [3.05e-09, 0.8240442342, 1485.9801210652],
                        [3.91e-09, 2.59385552893, 1795.258443721],
                        [2.91e-09, 3.12019266878, 217.491881132],
                        [2.94e-09, 2.18552193901, 444.7574381407],
                        [2.81e-09, 0.77791302266, 757.2171545342],
                        [3.55e-09, 5.44570491928, 1685.0521225016],
                        [3.05e-09, 2.65927043884, 355.7487455718],
                        [2.69e-09, 6.00323720265, 934.9485149682],
                        [2.87e-09, 2.60486363576, 113.3877149571],
                        [3.48e-09, 0.98872551635, 70.8494453042],
                        [3.31e-09, 5.62133883922, 9.5612275556],
                        [2.55e-09, 4.1408660503, 284.1485407422],
                        [3.11e-09, 6.27145060602, 207.1487562837],
                        [2.67e-09, 4.72606312146, 696.5196376166],
                        [3.19e-09, 4.68828119248, 1155.361157407],
                        [2.27e-09, 3.10352674343, 1361.5467058442],
                        [2.28e-09, 1.19253095837, 1589.0728952838],
                        [2.44e-09, 5.3632797601, 245.5424243524],
                        [2.18e-09, 2.16069250901, 177.8743727859],
                        [2.54e-09, 4.51652534648, 1148.2476104062],
                        [2.11e-09, 2.82699627326, 106.2741679563],
                        [2.3e-09, 4.63171743406, 107.0249274817],
                        [2.01e-09, 4.52152562223, 508.3503240922],
                        [2.3e-09, 5.93560798508, 618.5566453116],
                        [2.53e-09, 2.08074949572, 252.6559713532],
                        [2.34e-09, 2.43423283339, 1692.1656695024],
                        [1.96e-09, 1.01284131123, 114.3991069134],
                        [1.96e-09, 2.73629728926, 214.0498549634],
                        [1.91e-09, 1.51642829677, 6069.7767545534],
                        [2.52e-09, 5.10097595426, 1258.4539316256],
                        [2.4e-09, 2.93712394928, 916.9322800554],
                        [2.24e-09, 4.42406538277, 251.4321310758],
                        [2.23e-09, 2.34400676548, 1677.9385755008],
                        [2.28e-09, 5.00073557208, 1574.8458012822],
                        [1.83e-09, 5.09056895026, 220.4608265486],
                        [1.78e-09, 6.05669760153, 206.1373643274],
                        [1.85e-09, 3.73859309582, 114.1384744825],
                        [2e-09, 1.89409546254, 2420.9286360334],
                        [1.58e-09, 2.78517362162, 2008.557539159],
                        [1.91e-09, 2.28724146195, 2435.155730035],
                        [1.88e-09, 4.29343910228, 1471.7530270636],
                        [1.55e-09, 5.3519412342, 576.1613880106],
                        [1.74e-09, 2.80423114755, 1781.0313497194],
                        [1.66e-09, 5.32531835813, 2001.4439921582],
                        [1.65e-09, 2.62993712087, 525.4981794006],
                        [1.41e-09, 4.73916921092, 501.3797894433],
                        [1.61e-09, 5.8336852375, 181.0557665236],
                        [1.37e-09, 1.45135867137, 131.5469622218],
                        [1.57e-09, 3.22870773657, 1493.093668066],
                        [1.36e-09, 4.20279658293, 710.7467316182],
                        [1.44e-09, 4.61003572124, 121.2520214833],
                        [1.31e-09, 5.85409245557, 175.1660598002],
                        [1.44e-09, 0.96056164245, 214.7835681463],
                        [1.46e-09, 3.95687956474, 421.93232443],
                        [1.38e-09, 1.0308057361, 4.665866446],
                        [1.67e-09, 1.97508934614, 62.2514255951],
                        [1.23e-09, 2.28640485589, 1898.3512179396],
                        [1.68e-09, 4.63122081226, 1891.2376709388],
                        [1.29e-09, 0.05327999225, 211.8146227297],
                        [1.34e-09, 3.49720535944, 488.8496164711],
                        [1.17e-09, 3.43819501459, 436.1594184316],
                        [1.25e-09, 5.87007326241, 963.4027029714],
                        [1.2e-09, 0.70795300239, 81.7521332162],
                        [1.25e-09, 4.50999471095, 2317.8358618148],
                        [1.16e-09, 6.11600926571, 558.0021407459],
                        [1.17e-09, 4.78666549046, 601.7642506762],
                        [1.08e-09, 0.45464469172, 1802.3719907218],
                        [1.11e-09, 1.44669239244, 2531.1349572528],
                        [1.09e-09, 6.14289264597, 151.0476698429],
                        [1.13e-09, 4.05600865495, 1286.9081196288],
                        [1.29e-09, 5.1393694616, 849.2642284889],
                        [1.27e-09, 3.88189432056, 98.8999885246],
                        [1.33e-09, 2.3829063407, 2111.6503133776],
                        [1.22e-09, 4.40757611742, 778.4147831847],
                        [9.5e-10, 0.07909774752, 213.4109700226],
                        [9.5e-10, 1.66925524906, 213.1872208534],
                        [1.03e-09, 1.88058957173, 99.1606209555],
                        [1.19e-09, 3.62785705509, 248.7238180901],
                        [9e-10, 4.63029999228, 228.276948965],
                        [9.2e-10, 5.48700119144, 767.3690829208],
                        [8.9e-10, 4.61331934339, 431.264057322],
                        [9.9e-10, 3.60670326134, 776.9303104764],
                        [8.5e-10, 4.93878023673, 2.4476805548],
                        [8.9e-10, 6.24541644164, 661.2379273164],
                        [8.5e-10, 0.4589634906, 1382.8873468466],
                        [8.8e-10, 3.81144552178, 1788.1448967202],
                        [1.03e-09, 3.20558404998, 312.1990839626],
                        [8e-10, 2.28889729136, 213.0866471169],
                        [8e-10, 5.74264101239, 213.5115437591],
                        [8.2e-10, 3.23546757052, 198.321241911],
                        [7.8e-10, 6.0384119105, 835.0371344873],
                        [8e-10, 0.22601918692, 427.5613987225],
                        [7.2e-10, 2.05164614795, 2634.2277314714],
                        [9.1e-10, 5.97938003596, 556.5176680376],
                        [8.7e-10, 2.71469794199, 617.8058857862],
                      ],
          },
          {
            series => "B2",
            terms  => [
                        [0.00020629977, 0.50482422817, 213.299095438],
                        [3.719555e-05, 3.99833475829, 206.1855484372],
                        [1.627158e-05, 6.181899395, 220.4126424388],
                        [1.346067e-05, 0, 0],
                        [7.05842e-06, 3.03914308836, 419.4846438752],
                        [3.65042e-06, 5.09928680706, 426.598190876],
                        [3.29632e-06, 5.27899210039, 433.7117378768],
                        [2.19335e-06, 3.82841533795, 639.897286314],
                        [1.39393e-06, 1.04272623499, 7.1135470008],
                        [1.0398e-06, 6.15730992966, 227.5261894396],
                        [9.2961e-07, 1.97994412845, 316.3918696566],
                        [7.1242e-07, 4.14754353431, 199.0720014364],
                        [5.1927e-07, 2.88364833898, 632.7837393132],
                        [4.8961e-07, 4.43390206741, 647.0108333148],
                        [4.1373e-07, 3.15927770079, 853.196381752],
                        [2.8602e-07, 4.52978327558, 210.1177017003],
                        [2.3969e-07, 1.11595912146, 14.2270940016],
                        [2.0511e-07, 4.35095844197, 217.2312487011],
                        [1.9532e-07, 5.30779711223, 440.8252848776],
                        [1.8263e-07, 0.85391476786, 110.2063212194],
                        [1.5742e-07, 4.25767226302, 103.0927742186],
                        [1.684e-07, 5.68112084135, 216.4804891757],
                        [1.3613e-07, 2.99904334066, 412.3710968744],
                        [1.1567e-07, 2.5267992841, 529.6909650946],
                        [7.963e-08, 3.3151242392, 202.2533951741],
                        [6.599e-08, 0.28766025146, 323.5054166574],
                        [6.312e-08, 1.16121321336, 117.3198682202],
                        [5.891e-08, 3.58260177246, 309.2783226558],
                        [6.648e-08, 5.55714129949, 209.3669421749],
                        [5.59e-08, 2.47783944511, 1066.49547719],
                        [6.192e-08, 3.61231886519, 860.3099287528],
                        [4.231e-08, 3.02212363572, 846.0828347512],
                        [3.612e-08, 4.79935735435, 625.6701923124],
                        [3.398e-08, 3.76732731354, 423.4167971383],
                        [3.387e-08, 6.04222745633, 234.6397364404],
                        [2.578e-08, 5.63610668746, 735.8765135318],
                        [2.831e-08, 4.81642822334, 429.7795846137],
                        [2.817e-08, 4.47516563908, 654.1243803156],
                        [2.573e-08, 0.22467245054, 522.5774180938],
                        [2.61e-08, 3.29126967191, 95.9792272178],
                        [2.419e-08, 0.02986335489, 415.5524906121],
                        [2.112e-08, 4.55964179603, 422.6660376129],
                        [2.304e-08, 6.25081073546, 330.6189636582],
                        [1.758e-08, 5.53430456858, 536.8045120954],
                        [1.814e-08, 5.05675881426, 277.0349937414],
                        [1.55e-08, 5.60375604692, 223.5940361765],
                        [1.457e-08, 4.47767649852, 430.5303441391],
                        [1.607e-08, 5.535995501, 224.3447957019],
                        [1.172e-08, 4.71017775994, 203.0041546995],
                        [1.231e-08, 0.2511593188, 3.9321532631],
                        [1.105e-08, 1.01595427676, 21.3406410024],
                        [8.68e-09, 4.84623483952, 949.1756089698],
                        [9.39e-09, 1.35429452093, 742.9900605326],
                        [6.93e-09, 6.03599130692, 124.433415221],
                        [7.12e-09, 4.45550701473, 191.9584544356],
                        [6.9e-09, 5.44243765037, 437.6438911399],
                        [8.1e-09, 0.46198177342, 515.463871093],
                        [6.94e-09, 5.23748122403, 447.9388318784],
                        [6.04e-09, 2.95749705544, 88.865680217],
                        [6.69e-09, 0.08457977809, 215.7467759928],
                        [5.79e-09, 0.65329445948, 3.1813937377],
                        [7.12e-09, 6.05964117622, 11.0457002639],
                        [6.98e-09, 2.91371419321, 1073.6090241908],
                        [5.26e-09, 2.24947851818, 1059.3819301892],
                        [5.11e-09, 2.86838724347, 408.4389436113],
                        [5.89e-09, 5.79268515755, 63.7358983034],
                        [5.19e-09, 1.76641574095, 1279.794572628],
                        [5.03e-09, 5.73762297081, 728.762966531],
                        [4.82e-09, 4.68234512154, 838.9692877504],
                        [4.94e-09, 4.04363805503, 490.3340891794],
                        [4.58e-09, 1.17998315936, 210.8514148832],
                        [3.8e-09, 5.28045750432, 1052.2683831884],
                        [4.04e-09, 4.58953258519, 302.164775655],
                        [3.77e-09, 5.20131800999, 74.7815985673],
                        [3.28e-09, 0.11893501088, 956.2891559706],
                        [2.9e-09, 3.99300398632, 1162.4747044078],
                        [2.62e-09, 2.04320741578, 1471.7530270636],
                        [2.59e-09, 3.76206113036, 635.9651330509],
                        [2.54e-09, 0.16694559092, 195.1398481733],
                        [3.09e-09, 5.4492117596, 543.9180590962],
                        [2.37e-09, 1.27761853769, 231.4583427027],
                        [2.88e-09, 1.32449995239, 203.7378678824],
                        [2.29e-09, 4.19748765966, 1265.5674786264],
                        [2.38e-09, 4.02925601887, 643.0786800517],
                        [2.38e-09, 0.49997895983, 10.2949407385],
                        [2.57e-09, 3.69107889837, 867.4234757536],
                        [1.91e-09, 0.17807919948, 628.8515860501],
                        [2.46e-09, 5.62469599682, 351.8165923087],
                        [1.83e-09, 3.38184740572, 636.7158925763],
                        [1.72e-09, 3.8317349403, 1581.959348283],
                        [2.2e-09, 1.03443668151, 483.2205421786],
                        [2.17e-09, 4.65210162713, 750.1036075334],
                        [1.43e-09, 2.31969979791, 18.1592472647],
                        [1.37e-09, 5.50046852846, 1169.5882514086],
                        [1.2e-09, 3.70151294359, 416.3032501375],
                        [1.36e-09, 3.38453909352, 1155.361157407],
                        [1.49e-09, 0.85459831932, 1375.7737998458],
                        [1.5e-09, 5.71949902293, 618.5566453116],
                        [1.25e-09, 4.82446274394, 436.8931316145],
                        [1.2e-09, 3.26968058035, 1478.8665740644],
                        [1.31e-09, 0.11496484259, 1898.3512179396],
                        [9.9e-10, 4.57241894541, 643.8294395771],
                        [9.5e-10, 4.92115458463, 650.9429865779],
                        [9e-10, 2.09300085806, 621.7380390493],
                        [1.11e-09, 0.11975665259, 831.8557407496],
                        [8.9e-10, 2.54351587616, 85.8272988312],
                        [8e-10, 5.09103451442, 340.7708920448],
                        [7.8e-10, 3.17395501851, 497.4476361802],
                        [8.5e-10, 0.18997660997, 1258.4539316256],
                        [8.1e-10, 1.16732337173, 217.964961884],
                        [7.2e-10, 5.47328223678, 337.732510659],
                      ],
          },
          {
            series => "B3",
            terms  => [
                        [6.66252e-06, 1.99006340181, 213.299095438],
                        [6.3235e-06, 5.69778316807, 206.1855484372],
                        [3.98051e-06, 0, 0],
                        [1.87838e-06, 4.33779804809, 220.4126424388],
                        [9.1884e-07, 4.84104208217, 419.4846438752],
                        [4.2369e-07, 2.38073239056, 426.598190876],
                        [5.1548e-07, 3.42149490328, 433.7117378768],
                        [2.5661e-07, 4.40167213109, 227.5261894396],
                        [2.0551e-07, 5.85313509872, 199.0720014364],
                        [1.8081e-07, 1.99321433229, 639.897286314],
                        [1.0874e-07, 5.37344546547, 7.1135470008],
                        [9.59e-08, 2.54901825866, 647.0108333148],
                        [7.085e-08, 3.45518372721, 316.3918696566],
                        [6.002e-08, 4.80055225135, 632.7837393132],
                        [5.778e-08, 0.01680378777, 210.1177017003],
                        [4.881e-08, 5.63719730884, 14.2270940016],
                        [4.501e-08, 1.2242441901, 853.196381752],
                        [5.542e-08, 3.51756747774, 440.8252848776],
                        [3.548e-08, 4.7129937089, 412.3710968744],
                        [2.851e-08, 0.62679207578, 103.0927742186],
                        [2.173e-08, 3.71982274459, 216.4804891757],
                        [1.991e-08, 6.10867071657, 217.2312487011],
                        [1.435e-08, 1.69177141453, 860.3099287528],
                        [1.217e-08, 4.30778838827, 234.6397364404],
                        [1.157e-08, 5.75027789902, 309.2783226558],
                        [7.95e-09, 5.69026441157, 117.3198682202],
                        [7.33e-09, 0.59842720676, 1066.49547719],
                        [7.13e-09, 0.21700311697, 625.6701923124],
                        [7.73e-09, 5.4836198199, 202.2533951741],
                        [8.97e-09, 2.65577866867, 654.1243803156],
                        [5.09e-09, 2.86079833766, 429.7795846137],
                        [4.62e-09, 4.17742567173, 529.6909650946],
                        [3.9e-09, 6.11288036049, 191.9584544356],
                        [5.05e-09, 4.51905764563, 323.5054166574],
                        [3.79e-09, 3.74436004151, 223.5940361765],
                        [3.32e-09, 5.4937089057, 21.3406410024],
                        [3.77e-09, 5.25624813434, 95.9792272178],
                        [3.84e-09, 4.48187414769, 330.6189636582],
                        [3.67e-09, 5.0319092968, 846.0828347512],
                        [2.81e-09, 1.14133888637, 735.8765135318],
                        [2.45e-09, 5.8161825325, 423.4167971383],
                        [2.41e-09, 1.7033512018, 522.5774180938],
                        [2.58e-09, 3.69110118716, 447.9388318784],
                        [2.31e-09, 4.15697626494, 110.2063212194],
                        [3.05e-09, 5.97746884029, 302.164775655],
                        [2.84e-09, 0.66224572127, 203.0041546995],
                        [2.04e-09, 1.54683820621, 209.3669421749],
                        [1.94e-09, 4.21193801453, 124.433415221],
                        [1.45e-09, 4.79689259614, 88.865680217],
                        [1.51e-09, 3.82010884134, 536.8045120954],
                        [1e-09, 0.03596545368, 949.1756089698],
                        [9.7e-10, 0.91303450276, 1073.6090241908],
                        [1.1e-09, 2.21197473966, 515.463871093],
                        [8.4e-10, 2.53842533109, 422.6660376129],
                        [8.5e-10, 5.11102520704, 3.9321532631],
                        [7.7e-10, 6.04074586787, 838.9692877504],
                        [8.5e-10, 1.18898817378, 728.762966531],
                        [8.4e-10, 4.10158366806, 224.3447957019],
                      ],
          },
          {
            series => "B4",
            terms  => [
                        [8.0384e-07, 1.11918414679, 206.1855484372],
                        [3.166e-07, 3.12218745098, 213.299095438],
                        [1.7143e-07, 2.48073200414, 220.4126424388],
                        [1.1844e-07, 3.14159265359, 0],
                        [9.005e-08, 0.38441424927, 419.4846438752],
                        [6.164e-08, 1.56186379537, 433.7117378768],
                        [4.66e-08, 1.2823563957, 199.0720014364],
                        [4.775e-08, 2.63498295487, 227.5261894396],
                        [1.487e-08, 1.43096671616, 426.598190876],
                        [1.424e-08, 0.66988083613, 647.0108333148],
                        [1.075e-08, 6.18092274059, 639.897286314],
                        [1.145e-08, 1.72041928134, 440.8252848776],
                        [6.82e-09, 3.8484109818, 14.2270940016],
                        [6.55e-09, 3.49486258327, 7.1135470008],
                        [4.56e-09, 0.47338193402, 632.7837393132],
                        [5.09e-09, 0.31432285584, 412.3710968744],
                        [3.43e-09, 5.86413875355, 853.196381752],
                        [2.7e-09, 2.50125594913, 234.6397364404],
                        [1.97e-09, 5.39156324804, 316.3918696566],
                        [2.36e-09, 2.11084590211, 210.1177017003],
                        [1.72e-09, 6.09682874401, 860.3099287528],
                        [1.59e-09, 5.95049154821, 216.4804891757],
                        [1e-09, 1.98534903594, 625.6701923124],
                        [1.12e-09, 0.85526419268, 654.1243803156],
                        [1.15e-09, 5.03884718594, 117.3198682202],
                        [1.15e-09, 0.44589613974, 110.2063212194],
                      ],
          },
          {
            series => "B5",
            terms  => [
                        [7.895e-08, 2.81927558645, 206.1855484372],
                        [1.014e-08, 0.5118721027, 220.4126424388],
                        [7.72e-09, 2.99484124049, 199.0720014364],
                        [9.67e-09, 3.14159265359, 0],
                        [5.83e-09, 5.96456944075, 433.7117378768],
                        [5.88e-09, 0.78008666397, 227.5261894396],
                        [4.45e-09, 2.38630799074, 419.4846438752],
                        [9.8e-10, 5.10622131539, 647.0108333148],
                        [9.1e-10, 5.81659714144, 7.1135470008],
                        [8.8e-10, 6.17828532308, 440.8252848776],
                        [8.9e-10, 0.5839686453, 213.299095438],
                      ],
          },
        ],
        [
          {
            series => "R0",
            terms  => [
                        [9.55758135801, 0, 0],
                        [0.52921382465, 2.39226219733, 213.299095438],
                        [0.01873679934, 5.23549605091, 206.1855484372],
                        [0.01464663959, 1.64763045468, 426.598190876],
                        [0.00821891059, 5.93520025371, 316.3918696566],
                        [0.00547506899, 5.01532628454, 103.0927742186],
                        [0.00371684449, 2.27114833428, 220.4126424388],
                        [0.00361778433, 3.13904303264, 7.1135470008],
                        [0.00140617548, 5.70406652991, 632.7837393132],
                        [0.00108974737, 3.29313595577, 110.2063212194],
                        [0.00069007015, 5.94099622447, 419.4846438752],
                        [0.0006105335, 0.94037761156, 639.897286314],
                        [0.00048913044, 1.55733388472, 202.2533951741],
                        [0.00034143794, 0.19518550682, 277.0349937414],
                        [0.00032401718, 5.47084606947, 949.1756089698],
                        [0.00020936573, 0.46349163993, 735.8765135318],
                        [0.00020839118, 1.5210259064, 433.7117378768],
                        [0.00020746678, 5.33255667599, 199.0720014364],
                        [0.00015298457, 3.05943652881, 529.6909650946],
                        [0.00014296479, 2.60433537909, 323.5054166574],
                        [0.00011993314, 5.98051421881, 846.0828347512],
                        [0.00011380261, 1.73105746566, 522.5774180938],
                        [0.00012884128, 1.64892310393, 138.5174968707],
                        [7.752769e-05, 5.85191318903, 95.9792272178],
                        [9.796061e-05, 5.20475863996, 1265.5674786264],
                        [6.465967e-05, 0.17733160145, 1052.2683831884],
                        [6.770621e-05, 3.00433479284, 14.2270940016],
                        [5.850443e-05, 1.45519636076, 415.5524906121],
                        [5.307481e-05, 0.5973753405, 63.7358983034],
                        [4.695746e-05, 2.14919036956, 227.5261894396],
                        [4.043988e-05, 1.64010323863, 209.3669421749],
                        [3.688132e-05, 0.7801613317, 412.3710968744],
                        [3.376457e-05, 3.69528478828, 224.3447957019],
                        [2.885348e-05, 1.38764077631, 838.9692877504],
                        [2.976033e-05, 5.68467931117, 210.1177017003],
                        [3.419551e-05, 4.94549148887, 1581.959348283],
                        [3.460943e-05, 1.85088802878, 175.1660598002],
                        [3.400616e-05, 0.55386747515, 350.3321196004],
                        [2.50763e-05, 3.53851863255, 742.9900605326],
                        [2.448325e-05, 6.18412386316, 1368.660252845],
                        [2.406138e-05, 2.96559220267, 117.3198682202],
                        [2.881181e-05, 0.17960757891, 853.196381752],
                        [2.173959e-05, 0.01508587396, 340.7708920448],
                        [2.024483e-05, 5.05411271271, 11.0457002639],
                        [1.740254e-05, 2.34657043464, 309.2783226558],
                        [1.861397e-05, 5.93361638244, 625.6701923124],
                        [1.888436e-05, 0.02968443389, 3.9321532631],
                        [1.610859e-05, 1.17302463549, 74.7815985673],
                        [1.462631e-05, 1.92588134017, 216.4804891757],
                        [1.474547e-05, 5.6767046113, 203.7378678824],
                        [1.395109e-05, 5.93669404929, 127.4717966068],
                        [1.781165e-05, 0.76314388077, 217.2312487011],
                        [1.817186e-05, 5.77713225779, 490.3340891794],
                        [1.472392e-05, 1.40064915651, 137.0330241624],
                        [1.304089e-05, 0.77235613966, 647.0108333148],
                        [1.149773e-05, 5.74021249703, 1162.4747044078],
                        [1.126667e-05, 4.46707803791, 265.9892934775],
                        [1.277489e-05, 2.98412586423, 1059.3819301892],
                        [1.207053e-05, 0.7528593316, 351.8165923087],
                        [1.071399e-05, 1.13567265104, 1155.361157407],
                        [1.020922e-05, 5.91233512844, 1685.0521225016],
                        [1.315042e-05, 5.11202572637, 211.8146227297],
                        [1.295553e-05, 4.69184139933, 1898.3512179396],
                        [1.099037e-05, 1.81765118601, 149.5631971346],
                        [9.98462e-06, 2.63131596867, 200.7689224658],
                        [9.85869e-06, 2.25992849742, 956.2891559706],
                        [9.32434e-06, 3.66980793184, 554.0699874828],
                        [6.64481e-06, 0.60297724821, 728.762966531],
                        [6.5985e-06, 4.66635439533, 195.1398481733],
                        [6.1774e-06, 5.62092000007, 942.062061969],
                        [6.26382e-06, 5.9420823259, 1478.8665740644],
                        [4.8223e-06, 1.84070179496, 479.2883889155],
                        [4.87689e-06, 2.79373616806, 3.1813937377],
                        [4.70086e-06, 0.8384775504, 1471.7530270636],
                        [4.51817e-06, 5.64468459871, 2001.4439921582],
                        [5.53128e-06, 3.41088600844, 269.9214467406],
                        [5.34397e-06, 1.26443331367, 275.5505210331],
                        [4.72572e-06, 1.8819858466, 515.463871093],
                        [4.05434e-06, 1.64001413521, 536.8045120954],
                        [5.17196e-06, 4.44310450526, 2214.7430875962],
                        [4.52848e-06, 3.00349117198, 302.164775655],
                        [4.9434e-06, 2.28626675074, 278.5194664497],
                        [4.89825e-06, 5.80631420383, 191.2076949102],
                        [4.27459e-06, 0.05741344372, 284.1485407422],
                        [3.39763e-06, 1.40198657693, 440.8252848776],
                        [3.40627e-06, 0.89091104306, 628.8515860501],
                        [3.85974e-06, 1.99700402508, 1272.6810256272],
                        [2.88298e-06, 1.12160250272, 422.6660376129],
                        [2.94444e-06, 0.42577061903, 312.1990839626],
                        [2.6249e-06, 0.31753439818, 1045.1548361876],
                        [2.95331e-06, 0.67144493789, 88.865680217],
                        [3.42968e-06, 5.85600322299, 1795.258443721],
                        [3.41117e-06, 2.3758524725, 525.4981794006],
                        [2.34018e-06, 4.22756813216, 114.1384744825],
                        [2.23729e-06, 2.28129446763, 330.6189636582],
                        [2.75814e-06, 0.47832439352, 38.1330356378],
                        [2.24592e-06, 0.54754005675, 1788.1448967202],
                        [3.033e-06, 0.87946670205, 6069.7767545534],
                        [2.92103e-06, 6.2142061192, 210.8514148832],
                        [2.26121e-06, 0.37495223398, 142.4496501338],
                        [2.77257e-06, 5.31917702012, 692.5874843535],
                        [2.42911e-06, 5.37187983246, 1258.4539316256],
                        [2.05571e-06, 0.95755250527, 288.0806940053],
                        [2.07567e-06, 5.38126259725, 2317.8358618148],
                        [1.86835e-06, 6.03591766061, 404.5067903482],
                        [2.18536e-06, 5.25607043545, 212.3358875915],
                        [2.22155e-06, 5.94588016768, 39.3568759152],
                        [1.79673e-06, 4.41045924362, 408.4389436113],
                        [2.4144e-06, 1.1252586811, 388.4651552382],
                        [1.97093e-06, 3.9014194285, 52.6901980395],
                        [2.36639e-06, 0.90802744873, 1375.7737998458],
                        [1.71915e-06, 5.56318632797, 213.3472795478],
                        [1.69865e-06, 2.8566755401, 99.1606209555],
                        [2.14398e-06, 4.20253525974, 2531.1349572528],
                        [1.7201e-06, 2.36537801012, 213.2509113282],
                        [1.65707e-06, 2.63679789706, 215.7467759928],
                        [2.30892e-06, 5.49463421262, 191.9584544356],
                        [1.77585e-06, 0.38155817719, 430.5303441391],
                        [1.91514e-06, 2.95906900704, 437.6438911399],
                        [1.6325e-06, 3.4583251728, 617.8058857862],
                        [1.62305e-06, 5.73050678664, 203.0041546995],
                        [1.75108e-06, 5.71404465044, 1066.49547719],
                        [1.83041e-06, 5.66851947172, 2111.6503133776],
                        [1.50077e-06, 4.40663921925, 417.0369633204],
                        [1.87935e-06, 6.07916265661, 563.6312150384],
                        [1.45127e-06, 5.08176368814, 423.4167971383],
                        [1.37491e-06, 5.43912787991, 222.8603229936],
                        [1.72824e-06, 1.8492099409, 1589.0728952838],
                        [1.65478e-06, 2.89132196119, 214.2623032845],
                        [1.45727e-06, 1.56565192483, 831.8557407496],
                        [1.76864e-06, 2.30323752987, 9999.986450773],
                        [1.28877e-06, 2.55338644107, 414.0680179038],
                        [1.20093e-06, 0.04329750542, 1361.5467058442],
                        [1.43441e-06, 0.9981735772, 76.2660712756],
                        [1.08747e-06, 2.09282278191, 207.6700211455],
                        [1.32106e-06, 2.85902597898, 312.4597163935],
                        [1.12238e-06, 0.26221759151, 2104.5367663768],
                        [1.25186e-06, 4.78354048063, 205.2223405907],
                        [1.04427e-06, 3.63671899047, 65.2203710117],
                        [1.07447e-06, 3.67064138701, 212.7778305762],
                        [1.08642e-06, 2.85492389024, 21.3406410024],
                        [9.7743e-07, 5.12231845599, 2634.2277314714],
                        [1.09097e-06, 1.63231061493, 208.633228992],
                        [9.6852e-07, 4.19928280035, 305.3461693927],
                        [9.6507e-07, 2.56002066845, 1692.1656695024],
                        [8.5829e-07, 4.54545085982, 210.3783341312],
                        [9.9249e-07, 5.13816222131, 1574.8458012822],
                        [1.12532e-06, 5.03109281265, 703.6331846174],
                        [8.4023e-07, 1.18337717265, 429.7795846137],
                        [8.9021e-07, 5.38791571457, 107.0249274817],
                        [1.10191e-06, 2.43656081234, 355.7487455718],
                        [9.0659e-07, 4.20908809746, 213.8203602998],
                        [9.5885e-07, 5.44594259071, 2428.0421830342],
                        [9.4109e-07, 2.39786381418, 483.2205421786],
                        [8.5609e-07, 0.03354346966, 860.3099287528],
                        [8.8796e-07, 4.0576630675, 128.9562693151],
                        [8.1951e-07, 1.66499731549, 62.2514255951],
                        [9.124e-07, 3.96942332591, 2847.5268269094],
                        [8.3961e-07, 4.60845858022, 177.8743727859],
                        [8.8376e-07, 3.86800515885, 140.001969579],
                        [9.3308e-07, 0.73846639887, 831.1049812242],
                        [9.1872e-07, 2.9497760532, 35.4247226521],
                        [8.7077e-07, 1.33390590052, 1905.4647649404],
                        [9.6584e-07, 4.84438390997, 131.4039498699],
                        [7.101e-07, 0.99334817658, 405.2575498736],
                        [9.5266e-07, 2.51506908152, 2.4476805548],
                        [7.2514e-07, 4.63213873657, 245.5424243524],
                        [8.258e-07, 1.52823217919, 145.6310438715],
                        [7.6693e-07, 3.15240783008, 767.3690829208],
                        [7.0317e-07, 4.0425370727, 173.9422195228],
                        [8.6015e-07, 2.3010372727, 85.8272988312],
                        [6.6529e-07, 4.75053522835, 70.8494453042],
                        [6.5835e-07, 2.46869725001, 280.9671470045],
                        [6.4824e-07, 0.09343869325, 9.5612275556],
                        [7.1557e-07, 0.01212415296, 565.1156877467],
                        [6.6533e-07, 1.08034871114, 339.2864193365],
                        [6.3488e-07, 2.01740971153, 234.6397364404],
                        [6.0786e-07, 5.12026947473, 756.3233826569],
                        [5.8123e-07, 6.05732868566, 1677.9385755008],
                        [6.4236e-07, 1.28586474622, 1148.2476104062],
                        [7.3124e-07, 4.37810889148, 425.1137181677],
                        [5.5012e-07, 3.85865703217, 342.2553647531],
                        [5.7101e-07, 6.26689214029, 2420.9286360334],
                        [6.409e-07, 4.09854757476, 327.4375699205],
                        [5.5306e-07, 1.60456896521, 543.0242872189],
                        [5.7987e-07, 5.4726912434, 347.8844390456],
                        [7.3581e-07, 3.72292337326, 92.0470739547],
                        [7.376e-07, 3.57045342615, 1.4844727083],
                        [6.494e-07, 2.44739629174, 267.4737661858],
                        [5.4414e-07, 3.71479080197, 344.7030453079],
                        [4.9783e-07, 3.93453970179, 192.6921676185],
                        [4.9537e-07, 3.22831070579, 333.657345044],
                        [4.7539e-07, 3.92925402178, 199.2844497575],
                        [4.9368e-07, 4.90341763553, 217.491881132],
                        [6.2711e-07, 4.40120079629, 214.7835681463],
                        [4.6359e-07, 2.09430260266, 212.5483359126],
                        [4.6289e-07, 2.6403845348, 10.2949407385],
                        [5.4335e-07, 1.07179534996, 362.8622925726],
                        [5.8742e-07, 2.62270940799, 225.8292684102],
                        [4.8457e-07, 3.15166418511, 216.2198567448],
                        [4.6316e-07, 4.8622664277, 2950.619601128],
                        [4.597e-07, 4.97297391881, 198.321241911],
                        [4.6678e-07, 2.44960215701, 207.1487562837],
                        [4.4905e-07, 1.77616995803, 223.5940361765],
                        [4.4521e-07, 5.55987055442, 264.5048207692],
                        [5.5914e-07, 4.29520232351, 329.7251917809],
                        [4.9643e-07, 5.20789299388, 2744.4340526908],
                        [5.8829e-07, 4.23073947869, 700.6642392008],
                        [5.2629e-07, 3.7923062907, 343.2185725996],
                        [4.1532e-07, 0.74488808688, 125.9873238985],
                        [4.7767e-07, 2.39260015876, 207.8824694666],
                        [5.6157e-07, 2.07214273531, 124.433415221],
                        [4.3345e-07, 1.83707598036, 106.2741679563],
                        [3.9793e-07, 4.00870764324, 12.5301729722],
                        [5.3882e-07, 4.97905460628, 134.5853436076],
                        [5.0135e-07, 5.75914508514, 320.3240229197],
                        [4.496e-07, 5.35721924134, 218.9281697305],
                        [4.1089e-07, 4.92252591399, 1891.2376709388],
                        [4.6509e-07, 2.06623129884, 2008.557539159],
                        [4.2949e-07, 0.39856812529, 357.4456666012],
                        [3.7992e-07, 2.06495914285, 247.2393453818],
                        [4.8733e-07, 5.32762223699, 3127.3133312618],
                        [3.4583e-07, 5.62555932761, 99.9113804809],
                        [4.1092e-07, 2.4726489737, 237.6781178262],
                        [4.0763e-07, 4.08408559215, 621.7380390493],
                        [3.4213e-07, 0.73077393007, 750.1036075334],
                        [3.3967e-07, 5.31264617621, 206.233732547],
                        [3.6509e-07, 1.6882677575, 22.0914005278],
                        [3.9361e-07, 3.4573071999, 241.6102710893],
                        [3.4796e-07, 2.24780137629, 487.3651437628],
                        [3.3049e-07, 4.86593901955, 209.106309744],
                        [3.2584e-07, 2.22713131846, 319.5732633943],
                        [3.9035e-07, 3.73870591196, 3163.918696566],
                        [3.2722e-07, 1.06640549236, 252.6559713532],
                        [3.8671e-07, 4.39617126814, 18.1592472647],
                        [3.4514e-07, 1.8260750069, 380.12776796],
                        [4.1539e-07, 0.08136234251, 210.3301500214],
                        [3.3527e-07, 5.80475568528, 251.4321310758],
                        [3.1221e-07, 1.96489151107, 244.318584075],
                        [3.0521e-07, 2.26854188579, 1169.5882514086],
                        [3.4828e-07, 5.96324553131, 217.964961884],
                        [3.8481e-07, 4.43707551964, 160.6088973985],
                        [3.5998e-07, 3.83262381556, 56.6223513026],
                        [3.1041e-07, 4.89914223233, 144.1465711632],
                        [3.2342e-07, 3.58191018804, 231.4583427027],
                        [2.8838e-07, 5.80081031514, 1994.3304451574],
                        [3.2175e-07, 2.13166877923, 206.1373643274],
                        [3.2643e-07, 1.93131580544, 98.8999885246],
                        [3.4917e-07, 5.65276617691, 497.4476361802],
                        [2.8928e-07, 2.2165328892, 14.977853527],
                        [3.1569e-07, 3.81846560564, 73.297125859],
                        [3.2199e-07, 0.9981184629, 1464.6394800628],
                        [2.9153e-07, 5.98414099408, 2737.32050569],
                        [3.6706e-07, 4.75493516597, 348.8476468921],
                        [2.8665e-07, 1.68732054583, 78.7137518304],
                        [2.7501e-07, 6.12086395418, 214.0498549634],
                        [2.8795e-07, 0.04448605904, 5.6290742925],
                        [2.7205e-07, 0.24587543816, 313.2104759189],
                        [3.2441e-07, 3.77921585847, 33.9402499438],
                        [2.7088e-07, 5.2031009802, 148.0787244263],
                        [3.4956e-07, 3.43886187587, 273.1028404783],
                        [3.3076e-07, 2.44662095168, 969.6224780949],
                        [2.7745e-07, 1.44598606685, 258.8757464767],
                        [2.7178e-07, 4.2591859622, 179.3588454942],
                        [2.7872e-07, 0.78772093522, 546.956440482],
                        [2.9106e-07, 4.83947711462, 905.8865797915],
                        [2.7417e-07, 2.44930366818, 254.9435932136],
                        [3.4296e-07, 6.00920969644, 166.828672522],
                        [2.8859e-07, 6.0291724991, 188.9200730498],
                        [2.6001e-07, 0.65046992484, 654.1243803156],
                        [3.356e-07, 1.23732329127, 2221.856634597],
                        [2.4356e-07, 0.5224875133, 894.8408795276],
                        [2.7767e-07, 5.17820678484, 5.4166259714],
                        [2.5568e-07, 3.35897159622, 0.9632078465],
                        [2.2879e-07, 3.5129348069, 458.8415197904],
                        [2.4496e-07, 0.00976884124, 69.1525242748],
                        [2.8794e-07, 0.75545700854, 488.8496164711],
                        [3.1228e-07, 2.05299907796, 282.4516197128],
                        [2.5438e-07, 5.2903772925, 636.7158925763],
                        [2.5332e-07, 4.9700796945, 3060.8259223474],
                        [2.3596e-07, 2.54766434769, 196.6243208816],
                        [2.9602e-07, 3.92688207792, 206.706813299],
                        [2.8255e-07, 2.72125009693, 32.2433289144],
                        [2.2115e-07, 4.75775237642, 213.1872208534],
                        [2.213e-07, 3.25436709191, 681.5417840896],
                        [2.1675e-07, 4.61403328597, 3267.0114707846],
                        [2.2115e-07, 3.16759500067, 213.4109700226],
                        [2.6912e-07, 2.86269769133, 24.3790223882],
                        [2.0737e-07, 1.66895754198, 274.0660483248],
                        [2.8309e-07, 4.73122154345, 552.5855147745],
                        [2.5252e-07, 5.11986371899, 168.0525127994],
                        [2.6364e-07, 1.59272536419, 491.8185618877],
                        [2.1995e-07, 0.8807900928, 635.9651330509],
                        [2.7076e-07, 5.53694832022, 555.5544601911],
                        [1.9683e-07, 2.14388519695, 54.1746707478],
                        [2.7266e-07, 3.57891326986, 561.1835344836],
                        [2.5162e-07, 1.78070903718, 182.279606801],
                        [2.1386e-07, 3.86030772476, 116.4260963429],
                        [2.5572e-07, 1.62093861709, 2324.9494088156],
                        [2.0025e-07, 2.90618582553, 120.358249606],
                        [1.9882e-07, 5.59203696008, 4.192785694],
                        [1.9454e-07, 0.10623632006, 218.7157214094],
                        [2.5617e-07, 2.09931460158, 248.7238180901],
                        [1.9804e-07, 2.52180124343, 1485.9801210652],
                        [1.8516e-07, 2.54810951896, 213.5115437591],
                        [1.9831e-07, 0.07955320843, 842.1506814881],
                        [1.8516e-07, 5.3775511051, 213.0866471169],
                        [2.3655e-07, 1.59974907716, 738.7972748386],
                        [2.0375e-07, 2.94653107321, 59.8037450403],
                        [2.4247e-07, 3.15387696867, 240.3864308119],
                        [1.8294e-07, 3.18715992969, 295.0512286542],
                        [1.7464e-07, 2.90471803626, 477.8039162072],
                        [2.0698e-07, 1.07232100334, 494.2662424425],
                        [2.04e-07, 1.83665590916, 533.6231183577],
                        [2.1285e-07, 0.63341794388, 189.7232222019],
                        [1.6116e-07, 0.60069688498, 746.9222137957],
                        [1.6297e-07, 3.98317294128, 2.9207613068],
                        [1.6922e-07, 4.74266972033, 2207.6295405954],
                        [2.0479e-07, 6.05098286202, 173.6815870919],
                        [1.5447e-07, 1.49120311247, 543.9180590962],
                        [1.9944e-07, 4.9408663275, 121.2520214833],
                        [1.7127e-07, 0.71458025372, 1781.0313497194],
                        [1.724e-07, 0.67749766724, 151.0476698429],
                        [1.5574e-07, 5.70296527381, 3053.7123753466],
                        [1.5036e-07, 5.52770334605, 2310.722314814],
                        [1.5928e-07, 4.45642717299, 643.8294395771],
                        [1.6165e-07, 0.63286131026, 358.9301393095],
                        [1.4589e-07, 5.26158292613, 472.1748419147],
                        [1.6545e-07, 3.52813228069, 3480.3105662226],
                        [1.8912e-07, 0.55218675639, 4.665866446],
                        [1.7595e-07, 2.26495491189, 672.1406152284],
                        [1.8104e-07, 2.71285673689, 181.806526049],
                        [1.5918e-07, 5.23446779429, 135.5485514541],
                        [1.3931e-07, 3.19357128657, 213.5597278689],
                        [1.4058e-07, 0.82375896652, 221.3758502853],
                        [1.3931e-07, 4.73208739639, 213.0384630071],
                        [1.469e-07, 2.65882838685, 292.0128472684],
                        [1.4454e-07, 0.21819892811, 235.3904959658],
                        [1.6168e-07, 0.91025406068, 280.003939158],
                        [1.3327e-07, 3.54947442109, 205.6642835754],
                        [1.6104e-07, 0.82547975762, 176.6505325085],
                        [1.6441e-07, 5.39398801335, 424.1505103212],
                        [1.2747e-07, 0.75780958758, 721.6494195302],
                        [1.2754e-07, 3.55466871752, 153.4953503977],
                        [1.4448e-07, 0.12049617049, 313.6835566709],
                        [1.6499e-07, 3.26383140489, 6283.0758499914],
                        [1.6564e-07, 1.62649604519, 5856.4776591154],
                        [1.495e-07, 1.23923264394, 2641.3412784722],
                        [1.5724e-07, 1.18874754834, 486.4019359163],
                        [1.1893e-07, 0.91693668558, 416.3032501375],
                        [1.1684e-07, 1.11385455828, 81.7521332162],
                        [1.2985e-07, 4.74373293725, 3377.217792004],
                        [1.1864e-07, 0.64411806416, 28.3111756513],
                        [1.3216e-07, 4.9590402443, 1279.794572628],
                        [1.6121e-07, 0.98185208328, 2538.2485042536],
                        [1.49e-07, 1.76649832526, 569.0478410098],
                        [1.1337e-07, 4.36555105334, 3583.4033404412],
                        [1.1253e-07, 5.98638731448, 193.655375465],
                        [1.4753e-07, 2.92291248767, 167.0893049529],
                        [1.3774e-07, 2.50808183571, 1802.3719907218],
                        [1.1068e-07, 0.00471764868, 629.6023455755],
                        [1.2781e-07, 3.62178749219, 67.6680515665],
                        [1.2238e-07, 0.27163151602, 1044.4040766622],
                        [1.1021e-07, 0.15223056578, 501.3797894433],
                        [1.4206e-07, 2.63254885854, 618.5566453116],
                        [1.4365e-07, 0.37819794671, 601.7642506762],
                        [1.5034e-07, 2.67095006272, 46.470422916],
                        [1.2248e-07, 2.19751851112, 650.9429865779],
                        [1.0783e-07, 2.86375137884, 113.3877149571],
                        [1.1418e-07, 1.20874560246, 172.2452984934],
                        [1.4613e-07, 6.05645353059, 468.2426886516],
                        [1.058e-07, 2.05903854864, 429.0458714308],
                        [1.3721e-07, 2.20936291526, 228.276948965],
                        [1.218e-07, 1.82585577726, 241.8709035202],
                        [1.0787e-07, 5.06924118186, 162.8965192589],
                        [1.2056e-07, 3.20018724042, 72.0732855816],
                        [1.2233e-07, 4.5074193097, 425.6349830295],
                        [1.2101e-07, 4.14977794161, 1108.1399749656],
                        [9.843e-08, 1.49451039604, 226.6324175623],
                        [1.0287e-07, 2.10680007784, 1033.3583763983],
                        [9.975e-08, 2.81640446254, 518.6452648307],
                        [9.597e-08, 4.80028087522, 426.6463749858],
                        [1.0746e-07, 4.66838299108, 129.9194771616],
                        [1.2961e-07, 5.11568581806, 219.4494345923],
                        [1.2302e-07, 5.335685477, 776.9303104764],
                        [9.484e-08, 4.85702954575, 820.0592809603],
                        [1.1441e-07, 3.85769732764, 405.9912630565],
                        [9.625e-08, 1.60280478656, 426.5500067662],
                        [9.164e-08, 0.7020456798, 403.0223176399],
                        [1.0112e-07, 2.7648687563, 210.5907824523],
                        [1.0816e-07, 1.36864298163, 170.7608257851],
                        [1.0187e-07, 2.36063948382, 685.4739373527],
                        [1.2397e-07, 6.06349943525, 875.830299001],
                        [1.2146e-07, 2.04060386262, 508.3503240922],
                        [9.574e-08, 3.19555214859, 286.596221297],
                        [1.0193e-07, 4.01123146905, 381.3516082374],
                        [8.9e-08, 3.6326023588, 319.3126309634],
                        [1.0052e-07, 5.1610725104, 216.0074084237],
                        [8.528e-08, 3.88076551354, 630.3360587584],
                        [8.875e-08, 5.46623776078, 3370.1042450032],
                        [8.401e-08, 5.65557131026, 213.4591541324],
                        [1.0033e-07, 5.97497644283, 6.1503391543],
                        [8.401e-08, 2.27009862215, 213.1390367436],
                        [1.1661e-07, 0.95163302252, 694.0719570618],
                        [8.696e-08, 2.33868966556, 220.364458329],
                        [8.141e-08, 5.5405974715, 220.4608265486],
                        [9.615e-08, 2.75755414306, 556.5176680376],
                        [9.12e-08, 0.44322374149, 2097.423219376],
                        [8.109e-08, 5.53989498262, 181.0557665236],
                        [1.0763e-07, 0.05616402982, 691.1030116452],
                        [9.579e-08, 2.84979792871, 184.0941479094],
                        [9.958e-08, 2.38581008546, 945.2434557067],
                        [8.526e-08, 0.17821781104, 289.5651667136],
                        [7.7e-08, 0.0048137541, 7.1617311106],
                        [8.613e-08, 0.82900327241, 2957.7331481288],
                        [9.517e-08, 2.27516458273, 8.0767548473],
                        [9.049e-08, 3.3733502579, 731.9443602687],
                        [7.888e-08, 5.78452089815, 230.8252032563],
                        [7.684e-08, 3.10462250617, 7.065362891],
                        [7.391e-08, 5.29648701813, 2627.1141844706],
                        [9.875e-08, 4.69411059509, 10213.285546211],
                        [7.328e-08, 0.09051133382, 100.6450936638],
                        [7.999e-08, 1.60928374337, 696.5196376166],
                        [7.6e-08, 4.90078510977, 51.2057253312],
                        [9.928e-08, 5.25713005643, 699.7010313543],
                        [7.333e-08, 5.61982406824, 31.492569389],
                        [7.376e-08, 4.52737009022, 616.3214130779],
                        [9.422e-08, 2.44475274779, 2118.7638603784],
                        [7.3e-08, 4.0188547501, 212.0270710508],
                        [7.502e-08, 4.71301501745, 436.1594184316],
                        [9.071e-08, 2.75662160229, 130.4407420234],
                        [8.913e-08, 2.19608557019, 427.5613987225],
                        [8.801e-08, 4.26655882704, 141.2258098564],
                        [6.853e-08, 5.69082635009, 480.7728616238],
                        [7.765e-08, 3.27218537808, 3796.7024358792],
                        [9.159e-08, 3.0471367165, 9786.687355335],
                        [9.034e-08, 2.04165937353, 204.7010757289],
                        [6.902e-08, 4.61962635489, 2524.021410252],
                        [6.728e-08, 0.58794595002, 739.8086667949],
                        [6.741e-08, 0.52362906624, 135.336103133],
                        [8.201e-08, 5.03994203224, 411.620337349],
                        [7.24e-08, 3.90653111215, 214.5711198252],
                        [6.887e-08, 4.11954799957, 662.531203563],
                        [6.566e-08, 2.67659365854, 194.1766403268],
                        [6.539e-08, 6.25585361704, 31.019488637],
                        [7.484e-08, 5.56871021201, 271.4059194489],
                        [8.078e-08, 3.0995581756, 353.301065017],
                        [7.072e-08, 1.10066698352, 282.6640680339],
                        [6.089e-08, 0.79684364835, 593.426863398],
                        [6.14e-08, 3.79672343724, 180.1619946463],
                        [6.703e-08, 3.8285424862, 412.5835451955],
                        [6.024e-08, 5.46288776207, 724.8308132679],
                        [8.102e-08, 4.51051495778, 268.4369740323],
                        [6.033e-08, 1.24326252021, 447.9388318784],
                        [7.425e-08, 2.29394888999, 532.6117264014],
                        [6.007e-08, 2.87215425398, 426.0769260142],
                        [7.568e-08, 0.79147591036, 2854.6403739102],
                        [5.816e-08, 1.70824982811, 50.4025761791],
                        [7.534e-08, 5.3859829268, 953.1077622329],
                        [5.863e-08, 2.04201456623, 454.9093665273],
                        [7.291e-08, 0.88044346877, 457.617679513],
                        [6.235e-08, 4.51960341418, 3693.6096616606],
                        [6.359e-08, 6.27053660532, 313.9441891018],
                        [5.722e-08, 0.47241118592, 610.6923387854],
                        [5.704e-08, 0.45599464136, 643.0786800517],
                        [6.176e-08, 3.98739420856, 835.0371344873],
                        [5.73e-08, 0.5081424249, 1038.0412891868],
                        [6.812e-08, 4.2046338569, 938.1299087059],
                        [5.62e-08, 4.08049141112, 3899.7952100978],
                        [6.77e-08, 4.22172125738, 916.9322800554],
                        [6.069e-08, 3.46762401122, 278.2588340188],
                        [5.875e-08, 5.51773010551, 1073.6090241908],
                        [5.558e-08, 3.29478679376, 20.6069278195],
                        [6.274e-08, 4.88767368263, 0.5212648618],
                        [5.794e-08, 4.09991767938, 391.1734682239],
                        [5.442e-08, 2.79802608247, 397.3932433474],
                        [5.754e-08, 4.42718264879, 165.6048322446],
                        [5.879e-08, 6.17871525366, 291.262087743],
                        [6.716e-08, 2.1866384773, 627.3671133418],
                        [5.761e-08, 0.62536160332, 114.3991069134],
                        [5.359e-08, 2.29390692216, 331.2096644892],
                        [6.21e-08, 4.92273259045, 450.9772132642],
                        [6.686e-08, 2.13438181268, 285.6330134505],
                        [5.173e-08, 4.10128119721, 6.592282139],
                        [5.707e-08, 3.48716972669, 230.5645708254],
                        [6.363e-08, 5.64626069194, 518.3846323998],
                        [5.241e-08, 3.78081098206, 418.5214360287],
                        [5.191e-08, 4.39595146262, 84.3428261229],
                        [6.71e-08, 2.96748528229, 624.919432787],
                        [4.931e-08, 2.71959451867, 558.0021407459],
                        [5.225e-08, 4.65463431385, 310.7146112543],
                        [4.857e-08, 2.61373582429, 66.70484372],
                        [4.847e-08, 3.76991373317, 423.6774295692],
                        [5.284e-08, 1.96024672163, 1182.9215735329],
                        [5.933e-08, 2.74003948393, 219.891377577],
                        [6.373e-08, 1.4129634646, 606.7601855223],
                        [4.728e-08, 0.23421038001, 1063.3140834523],
                        [6.408e-08, 1.1668741968, 268.9582388941],
                        [4.782e-08, 1.56813683227, 420.9691165835],
                        [5.399e-08, 4.57611449409, 238.9019581036],
                        [5.161e-08, 0.14436456585, 2413.8150890326],
                        [4.858e-08, 5.21378840436, 3686.4961146598],
                        [5.086e-08, 1.73392381835, 337.732510659],
                        [4.65e-08, 3.7102912129, 305.0855369618],
                        [4.896e-08, 3.6778653184, 240.125798381],
                        [5.949e-08, 0.29956165181, 524.0137066923],
                        [4.968e-08, 2.53258931342, 980.6681783588],
                        [4.944e-08, 2.16189522746, 104.0559820651],
                        [5.366e-08, 3.54867806985, 107.2855599126],
                        [4.917e-08, 0.48641512683, 3274.1250177854],
                        [5.617e-08, 6.27593478237, 112.6540017742],
                        [4.524e-08, 5.09539085552, 103.1409583284],
                        [5.643e-08, 1.5272433648, 105.5404547734],
                        [4.504e-08, 1.68251875362, 196.0336200506],
                        [4.897e-08, 4.90011892854, 102.1295663721],
                        [4.525e-08, 1.88735156553, 103.0445901088],
                        [4.327e-08, 1.4540722938, 409.9234163196],
                        [5.095e-08, 3.40640608336, 427.1194557378],
                        [5.782e-08, 3.55197606731, 25874.6040461362],
                        [4.192e-08, 0.16603430914, 958.576777831],
                        [4.976e-08, 0.50639895683, 511.5317178299],
                        [4.167e-08, 5.9472576207, 316.4400537664],
                        [4.353e-08, 3.78587101731, 1171.875873269],
                        [5.387e-08, 2.03693287651, 2435.155730035],
                        [4.067e-08, 4.6659260313, 106.0135355254],
                        [4.817e-08, 3.53529781673, 960.2213092337],
                        [4.048e-08, 3.20024146722, 775.233389447],
                        [4.016e-08, 6.00569143107, 945.9942152321],
                        [3.989e-08, 3.15130319196, 115.6229471908],
                        [4.559e-08, 5.59555355771, 778.4147831847],
                        [4.153e-08, 2.75042736587, 316.3436855468],
                        [3.983e-08, 2.00842137744, 597.3590166611],
                        [4.212e-08, 4.16852690218, 823.9914342234],
                        [5.193e-08, 0.71717111984, 810.6581120991],
                        [3.927e-08, 5.04361736754, 2943.5060541272],
                        [4.225e-08, 0.02571003853, 0.7507595254],
                        [4.926e-08, 1.12994881124, 526.9826521089],
                        [4.17e-08, 3.94116290117, 422.405405182],
                        [4.432e-08, 3.995990468, 393.4610900843],
                        [3.84e-08, 1.21234108241, 212.0752551606],
                        [3.866e-08, 4.20930793423, 97.6761482472],
                        [4.44e-08, 1.35536679738, 211.6021744086],
                        [3.84e-08, 0.43014354282, 214.5229357154],
                        [4.724e-08, 3.62039208608, 638.4128136057],
                        [4.87e-08, 5.7587459962, 1246.6574718363],
                        [4.449e-08, 1.43384065964, 184.9879197867],
                        [3.931e-08, 2.36660272585, 909.8187330546],
                        [3.787e-08, 5.98932416906, 325.9530972122],
                        [3.665e-08, 0.72917314141, 20.4468691251],
                        [4.243e-08, 2.29103096797, 453.424893819],
                        [3.73e-08, 6.24831601183, 159.1244246902],
                        [3.9e-08, 1.31013240315, 850.0149880143],
                        [5.134e-08, 1.97348901289, 526.5095713569],
                        [3.621e-08, 2.77435773661, 123.5396433437],
                        [3.607e-08, 5.3205884271, 406.954470903],
                        [3.802e-08, 1.94444523548, 421.1815649046],
                        [3.906e-08, 3.02475451573, 317.3550775031],
                        [4.473e-08, 0.80804073855, 838.218528225],
                        [4.081e-08, 2.0873246818, 988.532484885],
                        [3.843e-08, 4.99347148246, 7.6348118626],
                        [4.467e-08, 6.09037793116, 760.25553592],
                        [3.514e-08, 3.97285766412, 426.4863162914],
                        [3.504e-08, 0.85064201666, 299.1263942692],
                        [4.397e-08, 1.68577228317, 824.7421937488],
                        [3.581e-08, 2.35235960566, 337.8019466282],
                        [4.606e-08, 3.48411642192, 913.9633346388],
                        [3.79e-08, 3.64538213705, 216.2680408546],
                        [3.496e-08, 0.95035381131, 436.8931316145],
                        [4.422e-08, 0.82822191292, 43.2890291783],
                        [3.688e-08, 2.837854438, 739.0579072695],
                        [4.439e-08, 1.19409419107, 421.93232443],
                        [3.572e-08, 2.77298538478, 444.7574381407],
                        [4.42e-08, 5.44308967028, 963.4027029714],
                        [4.443e-08, 3.73070830296, 37.8724032069],
                        [4.322e-08, 4.75680702521, 40.8413486235],
                        [3.724e-08, 0.59005210557, 256.4280659219],
                        [4.471e-08, 2.22367643527, 318.8395502114],
                        [4.184e-08, 1.5271919664, 298.2326223919],
                        [3.534e-08, 5.0193759957, 386.9806825299],
                        [3.4e-08, 3.22663067085, 4113.0943055358],
                        [4.556e-08, 1.35715974815, 495.7507151508],
                        [4.453e-08, 1.80417064247, 829.6205085159],
                        [3.617e-08, 1.51036385224, 41.6444977756],
                        [3.789e-08, 4.80357656146, 238.4288773516],
                        [3.514e-08, 2.38272766645, 426.7100654606],
                        [3.208e-08, 1.74465274123, 952.3570027075],
                        [4.398e-08, 2.65839000906, 832.5894539325],
                        [4.092e-08, 3.07954777295, 60.7669528868],
                        [3.813e-08, 5.63047104819, 315.4286618101],
                        [3.219e-08, 6.22278803635, 754.8389099486],
                        [3.102e-08, 2.69222024257, 343.7398374614],
                        [4.045e-08, 4.024637721, 376.1956146969],
                        [3.576e-08, 0.3853278728, 214.9960164674],
                        [3.291e-08, 5.49542015261, 143.9341228421],
                        [3.981e-08, 5.75449411958, 239.1625905345],
                        [3.249e-08, 0.58789568678, 619.2903584945],
                        [3.114e-08, 0.02831060137, 221.1634019642],
                        [3.555e-08, 3.12207684735, 1048.3362299253],
                        [3.01e-08, 1.91180343491, 93.531546663],
                        [3.384e-08, 1.81702854004, 443.8636662634],
                        [3.222e-08, 2.37342117781, 429.5189521828],
                        [3.431e-08, 5.92099840679, 570.7447620392],
                        [3.271e-08, 2.04947945059, 806.725958836],
                        [3.207e-08, 5.44018976766, 402.2191684878],
                        [3.091e-08, 0.10717557454, 3590.516887442],
                        [2.951e-08, 1.76365810296, 426.8106391971],
                        [2.958e-08, 0.23653889192, 1354.4331588434],
                        [2.948e-08, 4.59289832104, 426.3857425549],
                        [3.506e-08, 5.43222584214, 84.9335269539],
                        [2.894e-08, 5.69678330542, 1262.3860848887],
                        [3.682e-08, 1.07122313007, 395.578702239],
                        [2.983e-08, 5.25093816048, 313.4711083498],
                        [3.117e-08, 4.18767239237, 366.7944458357],
                        [2.873e-08, 4.45472312727, 361.3778198643],
                        [3.521e-08, 2.05528981993, 1261.6353253633],
                        [3.496e-08, 1.87950759078, 439.1283638482],
                        [3.012e-08, 0.64439385874, 263.0203480609],
                        [2.849e-08, 1.12491777974, 262.0571402144],
                        [2.91e-08, 2.76192171681, 541.5398145106],
                        [3.322e-08, 6.08893948791, 108.7218485111],
                        [3.181e-08, 1.01419299056, 418.0001711669],
                        [2.793e-08, 0.38781777981, 211.8628068395],
                        [3.091e-08, 2.18216748751, 306.830642101],
                        [3.748e-08, 3.89145855821, 220.9339073006],
                        [2.982e-08, 1.99831689446, 117.9105690512],
                        [2.793e-08, 1.25466684542, 214.7353840365],
                        [3.512e-08, 1.50965040301, 885.4397106664],
                        [2.716e-08, 0.80710391613, 757.2171545342],
                        [3.137e-08, 2.09889265033, 2751.5475996916],
                        [2.738e-08, 4.89270330923, 464.7312265138],
                        [2.875e-08, 4.28436709414, 4010.0015313172],
                        [3.313e-08, 3.01452486457, 336.8387387817],
                        [2.746e-08, 2.69963506928, 380.3884003909],
                        [3.132e-08, 2.19562786872, 2.9689454166],
                        [3.233e-08, 0.60809684558, 3171.0322435668],
                        [3.034e-08, 0.93246285284, 205.4347889118],
                        [3.006e-08, 5.91067479448, 2.7083129857],
                        [3.643e-08, 5.58302397259, 423.6292454594],
                        [2.625e-08, 1.07042050691, 23.5758732361],
                        [3.495e-08, 0.1988756203, 576.1613880106],
                        [2.59e-08, 0.2125277375, 110.2545053292],
                        [2.704e-08, 6.12908233599, 572.2292347475],
                        [2.568e-08, 0.17571588314, 1056.2005364515],
                        [2.583e-08, 2.96927378731, 384.0599212231],
                        [2.555e-08, 3.96441052072, 430.79097657],
                        [2.786e-08, 2.54945911818, 195.8906076987],
                        [2.869e-08, 4.82964665921, 710.7467316182],
                        [2.534e-08, 5.31005598763, 427.3489504014],
                        [2.618e-08, 1.22081401503, 36.6485629295],
                        [3.464e-08, 2.328113282, 285.3723810196],
                        [3.374e-08, 3.34109586766, 162.0933701068],
                        [2.694e-08, 4.64149271687, 140.9651774255],
                        [2.603e-08, 0.99527295832, 92.3077063856],
                        [3.14e-08, 5.4079027758, 328.2407190726],
                        [2.603e-08, 4.3153279088, 561.934294009],
                        [2.987e-08, 0.82758128867, 45.5766510387],
                        [2.959e-08, 3.35623851523, 273.8536000037],
                        [2.561e-08, 0.54160683162, 107.7586406646],
                        [2.9e-08, 1.20691455948, 462.0229135281],
                        [2.648e-08, 1.90547819027, 88.1149206916],
                        [2.461e-08, 4.68211868869, 2840.4132799086],
                        [2.534e-08, 5.00311256556, 431.264057322],
                        [2.521e-08, 3.3216047231, 136.0698163159],
                        [2.945e-08, 1.06452531856, 732.6951197941],
                        [2.654e-08, 1.36744710395, 460.5384408198],
                        [3.297e-08, 1.33975572602, 305.6068018236],
                        [2.634e-08, 2.299955338, 519.3960243561],
                        [2.805e-08, 5.62255444533, 1699.2792165032],
                        [2.439e-08, 5.14733660159, 303.8616966844],
                        [2.434e-08, 3.71460437051, 4216.1870797544],
                        [2.416e-08, 3.76296045457, 77.7505439839],
                        [2.803e-08, 2.55280894914, 505.3119427064],
                        [2.592e-08, 3.32836551071, 110.1581371096],
                        [3.074e-08, 1.71462387764, 256.5881246163],
                        [3.295e-08, 0.81766682522, 705.1176573257],
                        [3.183e-08, 6.15742006608, 109.2431133729],
                        [2.908e-08, 5.38534195293, 315.1680293792],
                        [2.326e-08, 1.42604031905, 131.5469622218],
                        [2.427e-08, 2.0462785074, 124.5028511902],
                        [2.632e-08, 1.41253794767, 211.6545640353],
                        [2.297e-08, 1.38016674676, 425.8474313506],
                        [2.318e-08, 6.27716072818, 317.142629182],
                        [2.31e-08, 4.86442292404, 3259.8979237838],
                        [2.873e-08, 1.10206537875, 7.8643065262],
                        [2.616e-08, 0.11849676899, 133.1008708993],
                        [3.213e-08, 4.4932046169, 432.2272651685],
                        [2.276e-08, 6.04688191978, 214.1022445901],
                        [2.276e-08, 1.96882478275, 212.4959462859],
                        [2.917e-08, 0.96774661857, 100.3844612329],
                        [2.89e-08, 5.72610904534, 322.0209439491],
                        [2.829e-08, 2.66887892162, 141.4864422873],
                        [2.695e-08, 1.4748857107, 42.5382696529],
                        [2.697e-08, 5.34002228297, 432.0148168474],
                        [2.229e-08, 4.40717937246, 540.7366653585],
                        [2.214e-08, 2.43714413196, 426.8588233069],
                        [2.512e-08, 4.68291916658, 1596.1864422846],
                        [2.202e-08, 5.91122030007, 867.4234757536],
                        [2.856e-08, 0.94736445171, 41.0537969446],
                        [2.396e-08, 0.10516628717, 206.9363079626],
                        [2.345e-08, 1.1668526778, 640.8604941605],
                        [2.263e-08, 4.62327588198, 188.0263011725],
                        [2.214e-08, 3.97566024178, 426.3375584451],
                        [2.274e-08, 4.9405583072, 4002.8879843164],
                        [2.541e-08, 0.837056152, 12352.8526045448],
                        [2.145e-08, 3.40120044084, 111.1695290659],
                        [2.895e-08, 6.07389082608, 2914.0142358238],
                        [2.52e-08, 1.05396310009, 184.7272873558],
                        [2.448e-08, 3.49820841117, 481.7360694703],
                        [2.343e-08, 2.86472924644, 207.0793203145],
                        [2.964e-08, 5.96264929181, 465.9550667912],
                        [2.122e-08, 4.04560058177, 118.0706277456],
                        [2.452e-08, 4.35251210402, 1382.8873468466],
                        [2.131e-08, 0.61211416273, 335.1418177523],
                        [2.116e-08, 4.76181734842, 765.8846102125],
                        [2.245e-08, 5.67078632283, 6467.9257579616],
                        [2.425e-08, 0.84789834075, 550.1378342197],
                        [2.227e-08, 1.15684015463, 227.3137411185],
                        [2.314e-08, 6.13104971819, 2730.2069586892],
                        [2.344e-08, 0.35844885568, 217.4436970222],
                        [2.529e-08, 3.07975959821, 774.4826299216],
                        [2.523e-08, 1.75026771081, 1578.0271950199],
                        [2.111e-08, 4.24637589094, 96.8729990951],
                        [2.826e-08, 1.01974994073, 87.3117715395],
                        [2.906e-08, 3.75374302356, 428.0826635843],
                        [2.113e-08, 2.19787343926, 449.232108125],
                        [2.142e-08, 1.19671359858, 209.1544938538],
                        [2.882e-08, 2.59371585952, 39.6175083461],
                        [2.078e-08, 2.87503604503, 14.0146456805],
                        [2.09e-08, 1.99032225653, 441.576044403],
                        [2.519e-08, 2.99001165551, 745.277682393],
                        [2.035e-08, 5.37147785849, 1041.2226829245],
                        [2.054e-08, 1.11817372961, 842.9014410135],
                        [2.023e-08, 2.94559148702, 668.2084619653],
                        [2.529e-08, 4.34280159004, 221.8971151471],
                        [2.554e-08, 5.56906955622, 214.1928673153],
                        [2.712e-08, 1.60469055827, 1050.9963588012],
                        [2.35e-08, 3.36541706919, 220.2001941177],
                        [2.015e-08, 2.60446576036, 315.6411101312],
                        [2.158e-08, 1.64945261993, 219.6618829134],
                        [2.12e-08, 2.93968038721, 304.1223291153],
                        [2.357e-08, 1.94433441808, 233.9060232575],
                        [2.579e-08, 4.54124062411, 484.7050148869],
                        [2.046e-08, 5.45531068264, 200.5564741447],
                        [2.04e-08, 2.04492641594, 1097.0942747017],
                        [2.675e-08, 1.20234167733, 28.5718080822],
                        [2.528e-08, 4.69268465973, 637.4496057592],
                        [2.314e-08, 2.81193072994, 25.1297819136],
                        [2.689e-08, 5.03868493349, 1269.4996318895],
                        [2.115e-08, 3.10772296248, 1276.6131788903],
                        [2.712e-08, 1.49710379127, 3340.6124266998],
                        [2.138e-08, 4.52114042624, 378.9039276826],
                        [2.708e-08, 0.01014338204, 389.9496279465],
                        [2.56e-08, 5.75783882561, 544.5087599272],
                        [2.028e-08, 0.24331359951, 146.594251718],
                        [2.096e-08, 1.44475430956, 864.2420820159],
                        [1.897e-08, 4.63194412388, 220.3007678542],
                        [1.901e-08, 1.78319572727, 192.8522263129],
                        [2.011e-08, 4.11578325523, 315.8706047948],
                        [2.014e-08, 2.26726355818, 198.1087935899],
                        [1.905e-08, 2.15527255015, 326.6868103951],
                        [1.949e-08, 3.95440811214, 103.6140390804],
                        [2.098e-08, 5.24613314798, 175.4266922311],
                        [1.884e-08, 5.66018186202, 1310.3933701397],
                        [1.911e-08, 2.606654466, 301.4140161296],
                        [2.16e-08, 3.42888079793, 420.005908737],
                        [2.325e-08, 5.896321781, 815.0633461142],
                        [1.914e-08, 0.22451332248, 171.6545976624],
                        [1.854e-08, 0.04278915026, 233.7459645631],
                        [1.973e-08, 2.6864025948, 769.8167634756],
                        [1.941e-08, 0.61369890353, 3487.4241132234],
                        [1.836e-08, 3.41496980986, 195.7729876197],
                        [2.554e-08, 2.35660179716, 212.4053235607],
                        [1.822e-08, 4.05510232882, 639.9454704238],
                        [1.883e-08, 6.27079329518, 16.6747745564],
                        [1.865e-08, 0.17460226411, 244.791664827],
                        [2.097e-08, 4.58369520569, 316.9131345184],
                        [1.879e-08, 2.76480572708, 28.4541880032],
                        [2.111e-08, 2.92457831824, 328.9220426288],
                        [2.077e-08, 0.3594303358, 589.4947101349],
                        [1.825e-08, 4.04945265223, 190.4045457581],
                        [1.895e-08, 3.89414880651, 334.5511169213],
                        [2.425e-08, 3.76754213762, 25558.2121764796],
                        [2.218e-08, 1.85341154236, 635.231419868],
                        [1.782e-08, 0.86927461254, 92.7978334801],
                        [2.432e-08, 3.78026263567, 1254.5217783625],
                        [2.106e-08, 0.17285594964, 354.2642728635],
                        [1.791e-08, 6.23892012939, 1670.8250285],
                        [1.996e-08, 1.40940081042, 230.7075831773],
                        [1.753e-08, 1.86660297451, 241.7532834412],
                        [2.093e-08, 2.3936677788, 187.4356003415],
                        [2.007e-08, 3.54083120293, 226.7924762567],
                        [1.949e-08, 1.36533052698, 1385.174968707],
                        [1.737e-08, 2.67583588366, 6.3627874754],
                        [1.868e-08, 4.24454204649, 1119.1856752295],
                        [1.896e-08, 3.81474515719, 310.9752436852],
                        [1.86e-08, 3.67887919389, 1321.4390704036],
                        [2.305e-08, 3.53252557028, 1570.9136480191],
                        [2.008e-08, 3.88504783546, 638.9340784675],
                        [1.928e-08, 2.64393870433, 525.7588118315],
                        [1.807e-08, 0.76057354967, 66.1835788582],
                        [1.824e-08, 0.85822155861, 639.8491022042],
                        [2.221e-08, 4.8221041383, 1585.8915015461],
                        [2.227e-08, 4.58488941022, 271.61836777],
                        [1.897e-08, 0.6433475825, 55.6591434561],
                        [1.792e-08, 0.00514800434, 827.9235874865],
                        [1.831e-08, 3.69768852728, 172.4577468145],
                        [1.79e-08, 4.8006297772, 3576.2897934404],
                        [1.698e-08, 0.72475212282, 295.1942410061],
                        [1.744e-08, 3.4525618329, 238.5718897035],
                        [2.334e-08, 1.51845210531, 170.0100662597],
                        [1.669e-08, 4.44620549295, 4319.279853973],
                        [1.939e-08, 3.43927826945, 102.5715093568],
                        [1.733e-08, 5.96815907422, 837.6972633632],
                        [1.686e-08, 2.12870436615, 491.5579294568],
                        [1.651e-08, 3.20586624475, 281.1795953256],
                        [1.884e-08, 4.2444781245, 13.4933808187],
                        [1.88e-08, 0.33845094634, 214.9436268407],
                        [1.817e-08, 3.07678560214, 220.5245170234],
                        [1.872e-08, 3.79328892492, 392.6579409322],
                        [2.195e-08, 1.93786776664, 259.769518354],
                        [1.881e-08, 4.49314034712, 199.8057146193],
                        [1.662e-08, 0.29659841675, 314.9073969483],
                        [1.626e-08, 2.29697402942, 3067.9394693482],
                        [1.927e-08, 1.00706624515, 26.826702943],
                        [1.621e-08, 0.01495920679, 1379.7059531089],
                        [1.655e-08, 4.15494230496, 4326.3934009738],
                        [1.719e-08, 5.9744386099, 152.5321425512],
                        [1.653e-08, 5.65633302949, 448.6895914038],
                        [1.79e-08, 3.73709604091, 10.0343083076],
                        [1.6e-08, 2.28430251221, 749.2098356561],
                        [1.77e-08, 0.03256515992, 364.3467652809],
                        [1.939e-08, 5.93191442558, 249.9476583675],
                        [1.988e-08, 4.78810872536, 101.8689339412],
                        [1.667e-08, 5.52149899431, 229.9738699944],
                        [2.215e-08, 3.55121116323, 594.6507036754],
                        [1.95e-08, 0.80878923373, 1049.0869894507],
                        [1.773e-08, 2.55608046714, 9985.7593567714],
                        [2.088e-08, 2.33165208016, 420.4478517217],
                        [2.107e-08, 2.43624356568, 453.6855262499],
                        [1.907e-08, 4.72569972805, 857.1285350151],
                        [1.609e-08, 4.96540433043, 285.1117485887],
                        [2.152e-08, 4.87024306306, 186.2117600641],
                        [1.685e-08, 5.68609178354, 200.0352092829],
                        [1.752e-08, 5.21532265401, 25448.0058552602],
                        [1.87e-08, 6.14683645342, 347.3631741838],
                        [1.731e-08, 1.95944272122, 934.9485149682],
                        [1.68e-08, 5.562466977, 170.9732741062],
                        [1.652e-08, 1.2452135105, 398.1440028728],
                        [1.548e-08, 0.38524522125, 17.2654753874],
                        [1.577e-08, 0.23430114545, 434.6749457233],
                        [1.652e-08, 2.84480428863, 385.5443939314],
                        [1.77e-08, 1.1505799628, 199.9657733137],
                        [1.528e-08, 4.02240583348, 236.1936451179],
                        [2.118e-08, 5.47803429266, 369.0820676961],
                        [1.543e-08, 2.54353574089, 632.7355552034],
                        [1.504e-08, 5.94300855424, 280.2163874791],
                        [1.495e-08, 2.19380669867, 407.4757357648],
                        [1.894e-08, 1.88797605501, 598.8434893694],
                        [1.515e-08, 4.70072295492, 211.2933578679],
                        [1.767e-08, 3.11910667879, 2921.1277828246],
                        [1.515e-08, 3.31498374761, 215.3048330081],
                        [1.728e-08, 5.28095966912, 219.5188705615],
                        [1.906e-08, 5.24236020775, 248.4631856592],
                        [1.607e-08, 0.80041605735, 642.3449668688],
                        [1.64e-08, 2.93387205029, 1364.7280995819],
                        [1.585e-08, 0.77219822539, 661.2379273164],
                        [1.458e-08, 5.67666822477, 632.831923423],
                        [1.866e-08, 4.40562835971, 971.1069508032],
                        [1.838e-08, 0.4849219076, 1127.0499817557],
                        [1.903e-08, 5.18692835916, 2015.6710861598],
                        [1.59e-08, 2.8004320807, 633.7469471597],
                        [1.489e-08, 4.10155671855, 77837.1112338466],
                        [1.573e-08, 4.23741356107, 203.8979265768],
                        [1.69e-08, 0.65475720351, 2700.7151403858],
                        [1.872e-08, 3.54376036064, 354.5249052944],
                        [1.419e-08, 4.53129346734, 224.6054281328],
                        [1.575e-08, 3.52476647615, 373.9079928365],
                        [1.817e-08, 3.9520388555, 6076.8903015542],
                        [1.446e-08, 5.41423319377, 317.8763423649],
                        [1.552e-08, 1.89030720529, 1304.9243545416],
                        [1.394e-08, 1.86243646383, 913.7508863177],
                        [1.94e-08, 4.36562864826, 432.7485300303],
                        [1.655e-08, 1.31748248488, 25668.418497699],
                        [1.438e-08, 5.12958189872, 71.8126531507],
                        [1.929e-08, 4.90721606846, 206.3979967583],
                        [1.533e-08, 2.10965059985, 378.6432952517],
                        [1.421e-08, 6.22897936063, 904.4021070832],
                        [1.45e-08, 1.98065714692, 205.9731001161],
                        [1.584e-08, 5.94110940455, 1226.2106027112],
                        [1.51e-08, 3.77771207288, 222.7002642992],
                        [1.67e-08, 2.51954641624, 976.7360250957],
                        [1.823e-08, 1.60093991502, 1141.1340634054],
                        [1.564e-08, 3.94804398924, 9566.2747128962],
                        [1.406e-08, 3.65940442223, 316.5037442412],
                        [1.653e-08, 3.62394476466, 968.1380053866],
                        [1.495e-08, 0.7783227917, 5959.570433334],
                        [1.408e-08, 5.2497092498, 316.279995072],
                        [1.724e-08, 0.25483952164, 125.1841747464],
                        [1.426e-08, 2.26871672572, 17.4084877393],
                        [1.881e-08, 4.12588105003, 562.1467423301],
                        [1.37e-08, 4.7447486688, 1357.6145525811],
                        [1.485e-08, 2.18712736768, 9889.7801295536],
                        [1.369e-08, 1.31846306523, 1160.8301730051],
                        [1.394e-08, 5.6692451786, 1736.9915610157],
                        [1.375e-08, 0.16983286236, 346.3999663373],
                        [1.525e-08, 2.40244831911, 419.4364597654],
                        [1.359e-08, 2.68668516027, 310.7627953641],
                        [1.396e-08, 3.6705539794, 253.4591205053],
                        [1.454e-08, 5.4935626244, 504.561183181],
                        [1.813e-08, 0.2188206686, 263.7016716171],
                        [1.33e-08, 3.01736059716, 254.1404440615],
                        [1.498e-08, 0.17578085903, 155.7829722581],
                        [1.509e-08, 5.13129901759, 768.8535556291],
                        [1.55e-08, 1.44225397189, 1894.4190646765],
                        [1.447e-08, 1.44933809994, 893.3564068193],
                        [1.306e-08, 5.76425101758, 714.6788848813],
                        [1.66e-08, 1.34160526151, 322.6116447801],
                        [1.347e-08, 3.00388920953, 843.6351541964],
                        [1.432e-08, 3.43786149731, 251.1714986449],
                        [1.51e-08, 4.39762427873, 25.2727942655],
                        [1.587e-08, 5.17106904014, 141.6988906084],
                        [1.477e-08, 5.4751837761, 226.0417167313],
                        [1.356e-08, 4.24406292182, 332.1728723357],
                        [1.644e-08, 1.74367211793, 67.8804998876],
                        [1.407e-08, 5.79229630947, 188.1693135244],
                        [1.575e-08, 0.09808372057, 702.1487119091],
                        [1.765e-08, 4.93410889383, 201.5196819912],
                        [1.318e-08, 4.91605557404, 17.5261078183],
                        [1.701e-08, 4.47360878108, 384.2723695442],
                        [1.304e-08, 6.04155032791, 25.8634950965],
                        [1.269e-08, 4.91035989349, 354.9979860464],
                        [1.62e-08, 5.54960841244, 260.360219185],
                        [1.263e-08, 1.16521999431, 255.8373650909],
                        [1.744e-08, 3.70453251764, 147.1155165798],
                        [1.579e-08, 4.31561365365, 2228.9701815978],
                        [1.557e-08, 0.57740217353, 3178.1457905676],
                        [1.302e-08, 0.32055726013, 119.767548775],
                        [1.405e-08, 3.2040748604, 395.105621487],
                        [1.234e-08, 2.34766954239, 318.679491517],
                        [1.519e-08, 4.74629629688, 100.1720129118],
                        [1.573e-08, 4.00132484524, 1264.2954542392],
                        [1.222e-08, 0.10709243166, 1372.5924061081],
                        [1.205e-08, 0.24105241435, 466.7582159433],
                        [1.188e-08, 1.27112537278, 1184.4060462412],
                        [1.28e-08, 4.85454052139, 535.9107402181],
                        [1.482e-08, 4.4716669291, 763.4369296577],
                        [1.233e-08, 1.64803509193, 433.663553767],
                        [1.476e-08, 3.7663439911, 272.5815756165],
                        [1.199e-08, 1.78020373551, 102.3420146932],
                        [1.186e-08, 4.72162748523, 795.6802585721],
                        [1.291e-08, 4.42697938285, 10220.3990932118],
                        [1.576e-08, 2.40263038916, 348.635198571],
                        [1.497e-08, 3.44614317326, 3024.2205570432],
                        [1.175e-08, 4.85145058205, 433.7599219866],
                        [1.262e-08, 5.79416346069, 531.978586955],
                        [1.486e-08, 4.39599352105, 1055.4497769261],
                        [1.351e-08, 0.46461977407, 707.5653378805],
                        [1.23e-08, 5.18147817992, 752.3912293938],
                        [1.175e-08, 4.35535063059, 3892.681663097],
                        [1.581e-08, 5.49361132323, 419.532827985],
                        [1.247e-08, 4.22328749428, 113.1270825262],
                        [1.145e-08, 2.26067253357, 199.1201855462],
                        [1.385e-08, 0.89711064123, 6073.7089078165],
                        [1.228e-08, 4.55057016747, 680.0573113813],
                        [1.47e-08, 1.58708185256, 409.1897031367],
                        [1.366e-08, 3.99684537321, 6065.8446012903],
                        [1.131e-08, 1.56474593118, 196.8367692027],
                        [1.163e-08, 5.75528918663, 2303.6087678132],
                        [1.142e-08, 4.35845106342, 1834.6153196362],
                        [1.244e-08, 1.93187654929, 623.2225117576],
                        [1.136e-08, 3.13253323524, 611.4430983108],
                        [1.425e-08, 2.65840274172, 1253.7710188371],
                        [1.114e-08, 3.43048279234, 771.3012361839],
                        [1.314e-08, 0.15326588489, 493.303034596],
                        [1.109e-08, 2.9580840286, 1091.6252591036],
                        [1.177e-08, 3.88159541809, 128.3655684841],
                        [1.15e-08, 4.6914056969, 1.2720243872],
                        [1.527e-08, 1.09983755253, 683.0262567979],
                        [1.304e-08, 5.24544813643, 5650.2921106782],
                        [1.347e-08, 4.11616699496, 97.4636999261],
                        [1.085e-08, 0.70231952018, 1166.4068576709],
                        [1.224e-08, 4.2299482253, 827.1728279611],
                        [1.142e-08, 5.36157631813, 199.0238173266],
                        [1.373e-08, 0.89371361814, 799.6124118352],
                        [1.085e-08, 1.15969472512, 398.2870152247],
                        [1.098e-08, 3.75659421786, 318.3976072267],
                        [1.136e-08, 1.35127769399, 205.9249160063],
                        [1.108e-08, 6.03201954623, 206.4461808681],
                        [1.146e-08, 0.18236094571, 6386.16862421],
                        [1.216e-08, 0.49809632153, 1178.9894202698],
                        [1.295e-08, 2.32056477953, 10003.9186040361],
                        [1.082e-08, 1.966110692, 3700.7232086614],
                        [1.094e-08, 5.12244388591, 314.3861320865],
                        [1.464e-08, 4.54056066665, 1248.1419445446],
                        [1.277e-08, 5.42029902662, 9996.0542975099],
                        [1.248e-08, 0.21625135029, 101.6083015103],
                        [1.055e-08, 5.5372537326, 1578.7779545453],
                        [1.265e-08, 5.85587479852, 82.8583534146],
                        [1.058e-08, 0.73824266822, 670.916774951],
                        [1.127e-08, 3.6345849801, 582.3811631341],
                        [1.188e-08, 2.10062104535, 423.8898778903],
                        [1.217e-08, 2.49656109071, 311.7260032106],
                        [1.08e-08, 3.96349373526, 118.8737768977],
                        [1.175e-08, 0.91096377814, 740.0692992258],
                        [1.087e-08, 5.46774426742, 494.4786907636],
                        [1.08e-08, 3.49168860514, 847.0460425977],
                        [1.095e-08, 0.97418295319, 1159.2933106701],
                        [1.078e-08, 1.75579678521, 1457.525933062],
                        [1.087e-08, 4.81206824168, 109.6850563576],
                        [1.293e-08, 0.02397468965, 2723.0934116884],
                        [1.19e-08, 4.49552956868, 429.3065038617],
                        [1.127e-08, 0.84707518843, 48.7580447764],
                        [1.047e-08, 4.58416926615, 89.7594520943],
                        [1.251e-08, 1.16783030789, 455.1699989582],
                        [1.122e-08, 5.7216130664, 78263.7094247226],
                        [1.027e-08, 0.16330222064, 229.7614216733],
                        [1.069e-08, 2.37188773221, 848.530515306],
                        [1.252e-08, 5.28238896229, 6080.8224548173],
                        [1.181e-08, 5.22299379363, 1459.9565672743],
                        [1.382e-08, 0.51603096285, 774.0095491696],
                        [1.064e-08, 5.95222326171, 1144.3154571431],
                        [1.083e-08, 5.04862249728, 629.8629780064],
                        [1.061e-08, 3.38604454777, 27.0873353739],
                        [1.415e-08, 4.85796248007, 2332.0629558164],
                        [1.082e-08, 4.07686503205, 1245.172999128],
                        [1.112e-08, 6.07617329506, 870.4618571394],
                        [1.072e-08, 0.73647405514, 1482.7987273275],
                        [1.322e-08, 2.81015928946, 223.3334037456],
                        [1.398e-08, 1.55232715558, 25771.5112719176],
                        [1.065e-08, 3.98884050015, 683.1863154923],
                        [1.008e-08, 5.19594380826, 316.1312372257],
                        [1.197e-08, 0.79148395839, 9580.5018068978],
                        [1.402e-08, 4.82957073563, 883.7951792637],
                        [1.064e-08, 4.65334775068, 201.9927627432],
                        [1.108e-08, 5.88857586823, 657.1627617014],
                        [9.96e-09, 4.99081076034, 426.7582495704],
                        [9.96e-09, 1.60533807224, 426.4381321816],
                        [1.028e-08, 5.9212831945, 108.50940019],
                        [1.004e-08, 3.5425959786, 754.0357607965],
                        [1.214e-08, 0.81213286478, 1773.9178027186],
                        [1.318e-08, 0.6026917613, 1123.1178284926],
                        [1.327e-08, 4.758850089, 321.808495628],
                        [1.014e-08, 5.79119811472, 6460.8122109608],
                        [1.178e-08, 0.47169015111, 495.9631634719],
                        [9.99e-09, 5.95030119388, 3906.9087570986],
                        [1.033e-08, 3.75433174131, 414.8187774292],
                        [1.002e-08, 1.39171012432, 1251.3403846248],
                        [9.9e-09, 1.32621236288, 1268.7488723641],
                        [1.275e-08, 1.95417923977, 757.8078553652],
                        [1.174e-08, 6.04352585298, 225.0785088848],
                        [1.174e-08, 5.43253033568, 849.2642284889],
                        [1.004e-08, 5.33434806968, 46.2097904851],
                        [1.108e-08, 1.28177889943, 294.3004691288],
                        [9.76e-09, 1.83523959034, 5.8897067234],
                        [9.71e-09, 3.38563950019, 306.0969289181],
                        [1.05e-08, 3.88449467091, 632.2624744514],
                        [1.05e-08, 3.26096036982, 159.7151255212],
                        [1.041e-08, 2.36429894351, 821.5437536686],
                        [1.218e-08, 4.61739999906, 990.2294059144],
                        [1.342e-08, 1.55614528399, 498.9321088885],
                        [9.67e-09, 3.84645372731, 604.4725636619],
                        [1.171e-08, 0.42265751679, 10011.0321510369],
                        [9.65e-09, 0.05396772193, 962.5089310941],
                        [1.096e-08, 3.04685199735, 608.404716925],
                        [1.166e-08, 6.14999706886, 737.3128021303],
                        [9.86e-09, 3.71830385737, 1235.6117715724],
                        [9.53e-09, 0.79704964354, 16.4623262353],
                        [9.76e-09, 1.05304205075, 8.3373872782],
                        [1.142e-08, 1.06057209808, 369.9758395734],
                        [1.06e-08, 4.36236322604, 633.305004175],
                        [1.138e-08, 4.31859245106, 98.4269077726],
                        [1.006e-08, 5.89037944896, 10007.0999977738],
                        [9.67e-09, 1.56852913547, 157.6399519819],
                        [1.082e-08, 0.99548769517, 4.1446015842],
                        [1.009e-08, 6.15037679495, 401.3253966105],
                        [9.81e-09, 2.37620383333, 35.212274331],
                        [1.011e-08, 5.42685471402, 110.7275860812],
                        [9.89e-09, 4.11575312649, 413.8555695827],
                        [1.024e-08, 1.90798238649, 1175.8080265321],
                        [1.079e-08, 4.95981991427, 631.8205314667],
                        [9.82e-09, 3.02842195594, 347.4113582936],
                        [9.79e-09, 3.74615289445, 700.4517908797],
                        [9.28e-09, 5.22236951137, 1173.5204046717],
                        [9.12e-09, 4.14451390992, 469.7271613599],
                        [9.38e-09, 1.18273838991, 254.3528923826],
                        [9.77e-09, 1.26684849112, 104.5772469269],
                        [1.134e-08, 5.87478488618, 6058.7310542895],
                        [1.092e-08, 4.51789158271, 532.1386456494],
                        [1.132e-08, 4.5542002715, 1912.5783119412],
                        [9.15e-09, 4.87266214195, 18.9100067901],
                        [9.15e-09, 5.96624579967, 1987.2168981566],
                        [1.039e-08, 2.40020830681, 6475.0393049624],
                        [9.65e-09, 4.98927479154, 394.3548619616],
                        [9.64e-09, 3.609037159, 3281.2385647862],
                        [8.97e-09, 2.81660605059, 316.2318109622],
                        [1.008e-08, 5.78024010734, 502.8642621516],
                        [1.005e-08, 6.12431717236, 6275.9623029906],
                        [8.95e-09, 6.09245508513, 316.551928351],
                        [1.224e-08, 1.73535287415, 5120.6011455836],
                        [1.138e-08, 2.92901543353, 1037.2905296614],
                        [9.24e-09, 5.70601816488, 614.8369403696],
                        [8.93e-09, 5.25155704274, 475.3562356524],
                        [1.042e-08, 1.10027795842, 1518.2234499796],
                        [8.9e-09, 4.03192782386, 1314.3255234028],
                        [9.26e-09, 3.35110915055, 635.70450062],
                        [1.13e-08, 5.49282680494, 92.940845832],
                        [8.9e-09, 2.12933822393, 3384.3313390048],
                        [9.67e-09, 5.86215202069, 13.3333221243],
                        [1.004e-08, 1.73116475997, 10316.3783204296],
                        [1.226e-08, 3.52834223937, 80.4106728598],
                        [1.029e-08, 4.90620832171, 19.1224551112],
                        [9.96e-09, 0.76740358631, 733.428832977],
                        [9.1e-09, 4.08904906301, 3333.498879699],
                        [1.235e-08, 1.23871819142, 357.2332182801],
                        [1.218e-08, 0.18349810348, 1090.4014188262],
                        [8.64e-09, 4.71917415767, 620.253566341],
                        [9.35e-09, 1.45887009044, 1042.9196039539],
                        [8.66e-09, 4.04792682992, 522.529233984],
                        [1.158e-08, 5.4332220911, 1089.129394439],
                        [8.6e-09, 0.49220052417, 64.9597385808],
                        [1.19e-08, 5.5896536965, 2810.9214616052],
                        [9.57e-09, 3.1291404701, 628.5909536192],
                        [8.61e-09, 5.69790389801, 103.843533744],
                        [1.037e-08, 5.91424823262, 11.3063326948],
                        [9.18e-09, 0.21424702155, 373.0142209592],
                        [8.36e-09, 3.02501867546, 387.2413149608],
                        [1.158e-08, 3.33343863758, 6290.1893969922],
                        [8.56e-09, 0.81593288669, 907.3710524998],
                        [1.036e-08, 3.11936047271, 5429.8794682394],
                        [8.53e-09, 6.23618175592, 938.8806682313],
                        [9.82e-09, 3.39082880963, 521.6142102473],
                        [8.51e-09, 5.14029961564, 802.7938055729],
                        [8.28e-09, 0.28399876908, 338.4832701844],
                        [8.68e-09, 1.89151676387, 627.1546650207],
                        [8.78e-09, 2.67671626912, 688.6553310904],
                        [9.21e-09, 0.18441593712, 3803.81598288],
                        [8.21e-09, 0.74694467095, 1152.1797636693],
                        [8.41e-09, 2.42616504698, 625.8826406335],
                        [8.62e-09, 3.35273419872, 425.3261664888],
                        [8.87e-09, 3.46938383985, 1748.788020805],
                        [8.15e-09, 5.95428642326, 321.0577361026],
                        [9.58e-09, 1.35525670354, 1201.831580323],
                        [9.05e-09, 5.43093361027, 236.8749686741],
                        [8.62e-09, 3.24167644516, 427.8702152632],
                        [7.93e-09, 5.01131700831, 109.9938728983],
                        [7.91e-09, 2.21809404489, 110.4187695405],
                        [8.42e-09, 5.04957483651, 444.1242986943],
                        [8.87e-09, 4.23752031714, 3553.9115221378],
                        [8.51e-09, 4.64229745145, 4105.980758535],
                        [1.067e-08, 4.69271921916, 559.6990617753],
                        [9.66e-09, 4.55013458162, 9360.089164459],
                        [9.77e-09, 1.50925667031, 186.472392495],
                        [1.092e-08, 0.5815374794, 203.2647871304],
                        [9.97e-09, 0.24589891452, 439.9315130003],
                        [7.86e-09, 3.84829878956, 194.3890886479],
                        [7.74e-09, 3.7605063931, 219.1406180516],
                        [8.45e-09, 4.21602090805, 2648.454825473],
                        [9.62e-09, 0.30590569897, 229.340730548],
                        [7.63e-09, 0.05577842075, 846.131018861],
                        [8.39e-09, 5.68124142701, 2620.0006374698],
                        [8.18e-09, 2.5260962654, 26301.2022370122],
                        [9.29e-09, 0.71906225883, 740.2817475469],
                        [8.95e-09, 5.83218231202, 4539.6924964118],
                        [9.39e-09, 3.68460642343, 817.7716590999],
                        [7.55e-09, 4.90024080821, 532.8723588323],
                        [7.84e-09, 1.14096100609, 551.031606097],
                        [8.99e-09, 1.85252071775, 835.7878940127],
                        [7.53e-09, 0.04254534997, 1534.7381658416],
                        [1.033e-08, 1.0013799327, 134.1122628556],
                        [8.51e-09, 6.1227286454, 1475.6851803267],
                        [7.97e-09, 5.14322789256, 473.659314623],
                        [7.29e-09, 4.94931618796, 476.1069951778],
                        [8.52e-09, 3.11058720799, 232.4215505492],
                        [7.83e-09, 4.50805467439, 1151.4290041439],
                        [7.51e-09, 0.92289775523, 1884.124123938],
                        [8.32e-09, 4.19686348297, 29.2049475286],
                        [7.2e-09, 0.4096104103, 522.6256022036],
                        [7.22e-09, 3.96121088528, 1474.9344208013],
                        [7.88e-09, 0.99170388242, 121.8427223143],
                        [7.22e-09, 4.16734185316, 232.2091022281],
                        [9.7e-09, 2.32204039048, 566.600160455],
                        [8.14e-09, 5.19337022083, 948.2124011233],
                        [7.24e-09, 2.30837674225, 949.12742486],
                        [7.7e-09, 5.89605163084, 156.6767441354],
                        [7.05e-09, 5.40102118863, 1193.9672737968],
                        [8.09e-09, 3.56474059969, 845.3320752258],
                        [7.55e-09, 3.94580797273, 451.7279727896],
                        [7.31e-09, 6.11847213487, 1239.5439248355],
                        [7.47e-09, 1.40599730465, 782.3469364478],
                        [8.61e-09, 1.84312374221, 984.6003316219],
                        [6.95e-09, 4.78088165969, 10419.4710946482],
                        [8.04e-09, 1.079984374, 89.0086925689],
                        [8.28e-09, 5.86080569334, 845.1196269047],
                        [6.92e-09, 3.38736418117, 6489.2613984286],
                        [6.94e-09, 3.07863807714, 316.6043179777],
                        [6.9e-09, 5.8668131138, 316.1794213355],
                        [7.14e-09, 5.38707933404, 567.8240007324],
                        [7.67e-09, 0.1208184965, 485.8806710545],
                        [8.2e-09, 1.87877245664, 499.895316735],
                        [7.05e-09, 0.57839934869, 1053.7528558967],
                        [6.84e-09, 4.8844227063, 2545.3620512544],
                        [6.89e-09, 6.14296395253, 622.4887985747],
                        [8.23e-09, 3.50224755884, 877.5754041402],
                        [8.27e-09, 2.59300433753, 232.942815411],
                        [7.35e-09, 3.05650026582, 66.9172920411],
                      ],
          },
          {
            series => "R1",
            terms  => [
                        [0.06182981282, 0.25843515034, 213.299095438],
                        [0.00506577574, 0.71114650941, 206.1855484372],
                        [0.00341394136, 5.7963577396, 426.598190876],
                        [0.00188491375, 0.47215719444, 220.4126424388],
                        [0.0018626154, 3.14159265359, 0],
                        [0.00143891176, 1.40744864239, 7.1135470008],
                        [0.00049621111, 6.0174446958, 103.0927742186],
                        [0.00020928189, 5.0924565447, 639.897286314],
                        [0.00019952612, 1.17560125007, 419.4846438752],
                        [0.00018839639, 1.60819563173, 110.2063212194],
                        [0.00012892827, 5.94330258435, 433.7117378768],
                        [0.00013876565, 0.75886204364, 199.0720014364],
                        [5.396699e-05, 1.28852405908, 14.2270940016],
                        [4.869308e-05, 0.86793894213, 323.5054166574],
                        [4.247455e-05, 0.39299384543, 227.5261894396],
                        [3.252084e-05, 1.25853470491, 95.9792272178],
                        [2.856006e-05, 2.16731405366, 735.8765135318],
                        [2.909411e-05, 4.60679154788, 202.2533951741],
                        [3.081408e-05, 3.43662557418, 522.5774180938],
                        [1.987689e-05, 2.45054204795, 412.3710968744],
                        [1.941309e-05, 6.02393385142, 209.3669421749],
                        [1.581446e-05, 1.29191789712, 210.1177017003],
                        [1.339511e-05, 4.30801821806, 853.196381752],
                        [1.31559e-05, 1.25296446023, 117.3198682202],
                        [1.203085e-05, 1.86654673794, 316.3918696566],
                        [1.091088e-05, 0.07527246854, 216.4804891757],
                        [9.54403e-06, 5.15173410519, 647.0108333148],
                        [9.66012e-06, 0.47991379141, 632.7837393132],
                        [8.81827e-06, 1.88471724478, 1052.2683831884],
                        [8.74215e-06, 1.40224683864, 224.3447957019],
                        [8.97512e-06, 0.98343776092, 529.6909650946],
                        [7.84866e-06, 3.06377517461, 838.9692877504],
                        [7.39892e-06, 1.38225356694, 625.6701923124],
                        [6.12961e-06, 3.03307306767, 63.7358983034],
                        [6.5821e-06, 4.1436293098, 309.2783226558],
                        [6.496e-06, 1.7248948616, 742.9900605326],
                        [5.99236e-06, 2.54924174765, 217.2312487011],
                        [5.02886e-06, 2.12958819475, 3.9321532631],
                        [4.13017e-06, 4.59334402271, 415.5524906121],
                        [3.56117e-06, 2.30312127651, 728.762966531],
                        [3.44777e-06, 5.88787577835, 440.8252848776],
                        [3.95004e-06, 0.53349091102, 956.2891559706],
                        [3.35526e-06, 1.61614647174, 1368.660252845],
                        [3.62772e-06, 4.70691652867, 302.164775655],
                        [3.21611e-06, 0.97931764923, 3.1813937377],
                        [2.77783e-06, 0.26007031431, 195.1398481733],
                        [2.91173e-06, 2.83129427918, 1155.361157407],
                        [2.64971e-06, 2.42670902733, 88.865680217],
                        [2.64864e-06, 5.82860588985, 149.5631971346],
                        [3.16777e-06, 3.58395655749, 515.463871093],
                        [2.94324e-06, 2.81632778983, 11.0457002639],
                        [2.44864e-06, 1.04493438899, 942.062061969],
                        [2.15368e-06, 3.56535574833, 490.3340891794],
                        [2.64047e-06, 1.28547685567, 1059.3819301892],
                        [2.46245e-06, 0.90730313861, 191.9584544356],
                        [2.22077e-06, 5.1319321205, 269.9214467406],
                        [1.94973e-06, 4.56665009915, 846.0828347512],
                        [1.82802e-06, 2.67913220473, 127.4717966068],
                        [1.81645e-06, 4.93431600689, 74.7815985673],
                        [1.74651e-06, 3.44560172182, 137.0330241624],
                        [1.65515e-06, 5.99775895715, 536.8045120954],
                        [1.54809e-06, 1.19720845085, 265.9892934775],
                        [1.69743e-06, 4.63464467495, 284.1485407422],
                        [1.51526e-06, 0.52928231044, 330.6189636582],
                        [1.52461e-06, 5.43886711695, 422.6660376129],
                        [1.57687e-06, 2.99559914619, 340.7708920448],
                        [1.4063e-06, 2.02069760726, 1045.1548361876],
                        [1.39834e-06, 1.3528295939, 1685.0521225016],
                        [1.40977e-06, 1.27099900689, 203.0041546995],
                        [1.36013e-06, 5.01678984678, 351.8165923087],
                        [1.53391e-06, 0.26968607873, 1272.6810256272],
                        [1.29476e-06, 1.14344730612, 21.3406410024],
                        [1.27831e-06, 2.53876158952, 1471.7530270636],
                        [1.26538e-06, 3.00310970076, 277.0349937414],
                        [1.00277e-06, 3.61360169153, 1066.49547719],
                        [1.03169e-06, 0.38175114761, 203.7378678824],
                        [1.07527e-06, 4.31870663477, 210.8514148832],
                        [9.5934e-07, 0.79463744168, 1258.4539316256],
                        [8.2663e-07, 0.28181414606, 234.6397364404],
                        [9.7986e-07, 2.56085956186, 191.2076949102],
                        [9.7389e-07, 3.26245865063, 831.8557407496],
                        [7.2227e-07, 4.3798463038, 860.3099287528],
                        [7.0639e-07, 0.7319151392, 437.6438911399],
                        [7.0447e-07, 0.87698401733, 423.4167971383],
                        [7.2057e-07, 5.58013290518, 429.7795846137],
                        [7.3332e-07, 0.62505906432, 1375.7737998458],
                        [6.6433e-07, 2.68414462465, 405.2575498736],
                        [6.3812e-07, 1.7505149818, 1361.5467058442],
                        [6.1601e-07, 1.09332288242, 2001.4439921582],
                        [6.7006e-07, 0.06872766216, 408.4389436113],
                        [6.8945e-07, 2.47127505057, 949.1756089698],
                        [6.0456e-07, 2.25094790113, 1788.1448967202],
                        [6.7074e-07, 5.45365870159, 200.7689224658],
                        [6.5579e-07, 0.05539079332, 1589.0728952838],
                        [4.932e-07, 4.17243429807, 138.5174968707],
                        [5.0648e-07, 6.26867505289, 223.5940361765],
                        [5.5166e-07, 4.59491533823, 628.8515860501],
                        [4.7916e-07, 0.83929741626, 10.2949407385],
                        [4.6691e-07, 2.17322569098, 312.1990839626],
                        [5.4179e-07, 0.28360076018, 124.433415221],
                        [4.9511e-07, 3.79960349195, 215.7467759928],
                        [4.0136e-07, 5.18161452756, 1478.8665740644],
                        [3.9302e-07, 0.56257369109, 1574.8458012822],
                        [3.4962e-07, 4.68487505703, 38.1330356378],
                        [4.277e-07, 2.98582069454, 1148.2476104062],
                        [3.6521e-07, 0.63453270366, 52.6901980395],
                        [3.9752e-07, 0.28412706854, 131.4039498699],
                        [3.1777e-07, 5.19036499973, 76.2660712756],
                        [3.3041e-07, 1.9796484643, 142.4496501338],
                        [4.2053e-07, 4.830179518, 288.0806940053],
                        [3.0757e-07, 1.47903923433, 1677.9385755008],
                        [4.2829e-07, 3.38225543528, 208.633228992],
                        [2.9245e-07, 5.09869866956, 654.1243803156],
                        [2.9165e-07, 4.95664881649, 1795.258443721],
                        [2.9136e-07, 2.74747553685, 404.5067903482],
                        [3.2689e-07, 6.12099521344, 145.6310438715],
                        [2.8008e-07, 0.83185907283, 2317.8358618148],
                        [2.7725e-07, 2.24364073545, 430.5303441391],
                        [2.9939e-07, 1.96415498448, 2104.5367663768],
                        [3.2982e-07, 3.28236160491, 222.8603229936],
                        [3.1772e-07, 6.02453027348, 1905.4647649404],
                        [2.6959e-07, 5.24308283338, 388.4651552382],
                        [2.6514e-07, 0.99638302878, 107.0249274817],
                        [2.5421e-07, 2.87336642463, 703.6331846174],
                        [2.4908e-07, 1.07713811775, 99.9113804809],
                        [2.4955e-07, 6.23974037842, 106.2741679563],
                        [2.4894e-07, 0.81040976807, 312.4597163935],
                        [2.434e-07, 0.54867402916, 214.2623032845],
                        [2.8441e-07, 0.82630052794, 1692.1656695024],
                        [2.3219e-07, 5.07995629354, 479.2883889155],
                        [2.4362e-07, 3.10643455533, 212.3358875915],
                        [2.1951e-07, 6.06688237952, 85.8272988312],
                        [2.2046e-07, 3.89863665506, 563.6312150384],
                        [2.2596e-07, 4.86725457223, 295.0512286542],
                        [2.1256e-07, 5.10797617452, 333.657345044],
                        [2.5985e-07, 2.20813879137, 1265.5674786264],
                        [2.0904e-07, 3.28855303434, 70.8494453042],
                        [2.1505e-07, 3.79541155976, 347.8844390456],
                        [2.2067e-07, 4.22716352578, 217.964961884],
                        [2.0629e-07, 1.68732248608, 231.4583427027],
                        [2.1429e-07, 3.08914428467, 554.0699874828],
                        [2.131e-07, 0.38868340861, 319.5732633943],
                        [2.0521e-07, 2.45651851283, 18.1592472647],
                        [2.6055e-07, 4.27554951169, 483.2205421786],
                        [2.0703e-07, 5.1205793632, 362.8622925726],
                        [2.2047e-07, 5.51249354809, 343.2185725996],
                        [1.9443e-07, 2.02441679295, 313.2104759189],
                        [2.0163e-07, 5.0848137311, 750.1036075334],
                        [2.0125e-07, 3.42997916125, 213.3472795478],
                        [2.4196e-07, 0.64787472796, 207.8824694666],
                        [2.1977e-07, 0.72894956852, 99.1606209555],
                        [2.112e-07, 2.69286728009, 1464.6394800628],
                        [1.7192e-07, 4.71525117969, 2111.6503133776],
                        [1.854e-07, 0.04817255506, 245.5424243524],
                        [1.7521e-07, 3.83662880684, 497.4476361802],
                        [1.6107e-07, 4.22374822303, 565.1156877467],
                        [2.1607e-07, 4.16647257628, 2.4476805548],
                        [1.5979e-07, 0.27376396113, 225.8292684102],
                        [1.6831e-07, 1.41134653939, 114.1384744825],
                        [1.5626e-07, 2.82768623405, 81.7521332162],
                        [1.5499e-07, 1.20606390539, 1994.3304451574],
                        [1.5168e-07, 3.84591816174, 1162.4747044078],
                        [1.6436e-07, 3.04752365976, 134.5853436076],
                        [1.587e-07, 0.33026420429, 1891.2376709388],
                        [2.037e-07, 0.23170286692, 213.2509113282],
                        [1.6291e-07, 1.70643197929, 2420.9286360334],
                        [1.628e-07, 4.9415942732, 357.4456666012],
                        [1.8076e-07, 5.69515344123, 56.6223513026],
                        [1.3724e-07, 0.5724019003, 2634.2277314714],
                        [1.7355e-07, 3.55311137444, 218.9281697305],
                        [1.374e-07, 5.70545527289, 92.0470739547],
                        [1.5328e-07, 1.3133869285, 216.2198567448],
                        [1.2538e-07, 5.19222019427, 635.9651330509],
                        [1.2815e-07, 1.6015113087, 320.3240229197],
                        [1.3043e-07, 0.45068441373, 1169.5882514086],
                        [1.1984e-07, 5.9491612357, 543.9180590962],
                        [1.1753e-07, 2.80279347133, 217.491881132],
                        [1.4746e-07, 5.56520105813, 344.7030453079],
                        [1.2762e-07, 1.63557330778, 273.1028404783],
                        [1.1855e-07, 2.46234840263, 721.6494195302],
                        [1.3309e-07, 5.75641013916, 2221.856634597],
                        [1.4471e-07, 0.45316163629, 2008.557539159],
                        [1.184e-07, 1.7572077238, 160.6088973985],
                        [1.2374e-07, 1.01456317602, 329.7251917809],
                        [1.0747e-07, 1.58065203003, 212.7778305762],
                        [1.2758e-07, 1.9195237324, 1581.959348283],
                        [1.1944e-07, 4.44720922423, 32.2433289144],
                        [1.1865e-07, 5.10696147162, 4.665866446],
                        [1.1861e-07, 4.30847607078, 618.5566453116],
                        [1.0036e-07, 0.48709852137, 305.3461693927],
                        [1.2777e-07, 3.74412991331, 508.3503240922],
                        [1.0677e-07, 0.76645916273, 218.7157214094],
                        [1.1351e-07, 3.00009819697, 198.321241911],
                        [1.0249e-07, 2.40923650192, 546.956440482],
                        [9.984e-08, 2.63882014753, 416.3032501375],
                        [9.345e-08, 5.4591731786, 414.0680179038],
                        [9.317e-08, 4.46380159546, 2428.0421830342],
                        [9.928e-08, 4.04821559448, 62.2514255951],
                        [1.2767e-07, 3.43273835457, 258.8757464767],
                        [9.733e-08, 1.6106632468, 327.4375699205],
                        [1.1163e-07, 2.40665325234, 1781.0313497194],
                        [1.0608e-07, 2.0748002083, 213.8203602998],
                        [9.125e-08, 2.92369523159, 1279.794572628],
                        [9.525e-08, 1.10338403136, 113.3877149571],
                        [9.805e-08, 3.28427768485, 275.5505210331],
                        [1.1263e-07, 1.89402915826, 561.1835344836],
                        [8.572e-08, 2.17858055966, 425.1137181677],
                        [8.577e-08, 1.95484887975, 35.4247226521],
                        [1.0157e-07, 0.09037368733, 182.279606801],
                        [1.1807e-07, 3.71278037583, 350.3321196004],
                        [8.595e-08, 1.83382454431, 629.6023455755],
                        [8.396e-08, 3.76782674303, 251.4321310758],
                        [8.46e-08, 0.35676476459, 617.8058857862],
                        [8.25e-08, 5.31140994372, 65.2203710117],
                        [8.342e-08, 1.3830766388, 1.4844727083],
                        [7.987e-08, 5.1362289817, 22.0914005278],
                        [8.377e-08, 0.91817077859, 1485.9801210652],
                        [7.98e-08, 0.94199750915, 2310.722314814],
                        [8.898e-08, 0.54037636841, 168.0525127994],
                        [8.233e-08, 3.45785310349, 424.1505103212],
                        [8.034e-08, 3.38451795597, 144.1465711632],
                        [7.871e-08, 5.14041888473, 358.9301393095],
                        [8.868e-08, 6.13541788772, 621.7380390493],
                        [7.523e-08, 5.75475671698, 447.9388318784],
                        [7.515e-08, 2.18967849979, 264.5048207692],
                        [8.083e-08, 1.42661116937, 2737.32050569],
                        [8.199e-08, 0.96419579079, 767.3690829208],
                        [8.232e-08, 0.35471613534, 278.5194664497],
                        [8.226e-08, 5.44467204721, 254.9435932136],
                        [6.779e-08, 1.19567671732, 5.4166259714],
                        [8.928e-08, 4.88240256153, 120.358249606],
                        [7.845e-08, 4.56376829397, 280.9671470045],
                        [6.566e-08, 3.50152072308, 9.5612275556],
                        [6.398e-08, 0.33471834269, 2950.619601128],
                        [6.881e-08, 3.39438820076, 98.8999885246],
                        [7.418e-08, 4.52451404934, 5.6290742925],
                        [8.021e-08, 0.94470052446, 636.7158925763],
                        [6.134e-08, 0.18013315689, 2207.6295405954],
                        [7.153e-08, 3.85218295688, 214.0498549634],
                        [6.046e-08, 4.66733263196, 543.0242872189],
                        [6.365e-08, 2.12000811873, 274.0660483248],
                        [6.481e-08, 5.31032923608, 6076.8903015542],
                        [5.935e-08, 6.16808119163, 650.9429865779],
                        [5.752e-08, 3.55773840903, 1073.6090241908],
                        [6.438e-08, 0.44934410249, 10007.0999977738],
                        [6.283e-08, 3.20942251433, 219.4494345923],
                        [5.542e-08, 3.61193204407, 125.9873238985],
                        [5.522e-08, 3.84217355164, 181.0557665236],
                        [5.777e-08, 3.00590926498, 121.2520214833],
                        [6.67e-08, 1.65236689367, 1898.3512179396],
                        [7.591e-08, 0.10483002359, 2324.9494088156],
                        [5.881e-08, 1.04006410206, 9992.8729037722],
                        [5.609e-08, 4.83142709229, 643.0786800517],
                        [5.569e-08, 2.23863483508, 1038.0412891868],
                        [5.755e-08, 5.91598458372, 6062.6632075526],
                        [5.845e-08, 6.10234689502, 209.106309744],
                        [5.577e-08, 0.81426649853, 472.1748419147],
                        [5.247e-08, 0.56496127013, 192.6921676185],
                        [5.493e-08, 5.81071309534, 237.6781178262],
                        [5.148e-08, 4.85160826999, 267.4737661858],
                        [6.122e-08, 2.11480301005, 2097.423219376],
                        [6.188e-08, 4.59441762166, 207.6700211455],
                        [6.303e-08, 0.75806431119, 210.3783341312],
                        [5.102e-08, 4.01017179605, 205.2223405907],
                        [6.583e-08, 1.79054357427, 12.5301729722],
                        [4.902e-08, 0.8509952186, 247.2393453818],
                        [4.918e-08, 4.03512681632, 487.3651437628],
                        [5.818e-08, 5.48495503489, 2538.2485042536],
                        [4.855e-08, 4.18197778083, 2744.4340526908],
                        [4.885e-08, 0.25103933716, 129.9194771616],
                        [5.748e-08, 0.55968589618, 116.4260963429],
                        [4.901e-08, 4.48628916012, 291.262087743],
                        [4.72e-08, 5.57686152365, 342.2553647531],
                        [5.962e-08, 5.12885837444, 692.5874843535],
                        [5.629e-08, 4.39847572369, 196.6243208816],
                        [5.596e-08, 0.94874135403, 1802.3719907218],
                        [6.197e-08, 3.80364010966, 339.2864193365],
                        [4.668e-08, 3.16816375033, 148.0787244263],
                        [4.891e-08, 2.67234862638, 417.0369633204],
                        [4.959e-08, 1.63453587065, 166.828672522],
                        [4.408e-08, 4.95179678525, 184.0941479094],
                        [4.449e-08, 5.69134789394, 252.6559713532],
                        [4.943e-08, 0.85358212806, 46.470422916],
                        [5.153e-08, 3.82176885491, 842.1506814881],
                        [5.93e-08, 5.95484153666, 486.4019359163],
                        [4.206e-08, 2.97664198894, 380.12776796],
                        [4.467e-08, 0.249149784, 128.9562693151],
                        [5.419e-08, 6.19106890918, 337.732510659],
                        [4.499e-08, 4.71434958315, 151.0476698429],
                        [4.233e-08, 4.18702525973, 685.4739373527],
                        [4.695e-08, 1.54881559549, 214.7835681463],
                        [4.084e-08, 4.871732264, 14.977853527],
                        [4.321e-08, 5.4261516886, 436.8931316145],
                        [5.145e-08, 0.49931857511, 248.7238180901],
                        [3.897e-08, 0.74661138504, 2627.1141844706],
                        [3.995e-08, 3.07750371135, 710.7467316182],
                        [4.089e-08, 5.81996977038, 491.8185618877],
                        [4.532e-08, 3.67494714028, 189.7232222019],
                        [3.69e-08, 1.26565281569, 211.8146227297],
                        [4.036e-08, 1.15473702593, 3053.7123753466],
                        [3.672e-08, 4.52661018437, 488.8496164711],
                        [3.662e-08, 2.87243745783, 411.620337349],
                        [3.653e-08, 3.06205147988, 409.9234163196],
                        [3.908e-08, 3.45947158106, 220.4608265486],
                        [4.989e-08, 3.36376245705, 824.7421937488],
                        [3.677e-08, 3.55713278092, 244.318584075],
                        [3.58e-08, 1.57825591891, 643.8294395771],
                        [3.546e-08, 2.1984624503, 135.336103133],
                        [3.56e-08, 4.51362022045, 601.7642506762],
                        [3.843e-08, 0.98567531677, 271.4059194489],
                        [3.559e-08, 1.11005765159, 6283.0758499914],
                        [4.266e-08, 6.19696005871, 268.4369740323],
                        [3.442e-08, 4.27628882392, 867.4234757536],
                        [4.844e-08, 3.73706907228, 235.3904959658],
                        [3.659e-08, 2.21859531609, 2.9207613068],
                        [3.958e-08, 5.17084570945, 114.3991069134],
                        [3.609e-08, 5.54387488088, 458.8415197904],
                        [4.47e-08, 3.742569309, 699.7010313543],
                        [3.293e-08, 4.48068043469, 289.5651667136],
                        [3.24e-08, 5.94728881707, 131.5469622218],
                        [3.477e-08, 3.54553285172, 963.4027029714],
                        [3.838e-08, 4.77967877681, 175.1660598002],
                        [3.223e-08, 1.95410765469, 212.0270710508],
                        [4.053e-08, 4.19011281964, 501.3797894433],
                        [3.1e-08, 2.11956558345, 916.9322800554],
                        [3.183e-08, 1.93201605379, 1354.4331588434],
                        [3.301e-08, 1.80825506815, 756.3233826569],
                        [4.187e-08, 5.96622666047, 212.5483359126],
                        [3.716e-08, 3.70660462807, 204.7010757289],
                        [3e-08, 6.15443664698, 3267.0114707846],
                        [2.993e-08, 4.20888489881, 533.6231183577],
                        [4.125e-08, 6.09715151219, 2641.3412784722],
                        [3.145e-08, 2.55483540896, 905.8865797915],
                        [2.982e-08, 1.52760656472, 945.9942152321],
                        [3.015e-08, 1.76012152992, 28.3111756513],
                        [3.453e-08, 1.42473508236, 2214.7430875962],
                        [2.926e-08, 5.50138147476, 24.3790223882],
                        [2.978e-08, 4.2744005991, 195.8906076987],
                        [3.526e-08, 3.63935401565, 229.9738699944],
                        [2.86e-08, 4.52551886503, 241.6102710893],
                        [3.059e-08, 5.68165832697, 282.6640680339],
                        [3.415e-08, 5.26311934884, 67.6680515665],
                        [2.819e-08, 5.42053027567, 305.0855369618],
                        [3.503e-08, 1.31670335802, 69.1525242748],
                        [2.746e-08, 0.82597971627, 444.7574381407],
                        [2.796e-08, 0.0702104716, 681.5417840896],
                        [3.366e-08, 4.03843228994, 6.1503391543],
                        [3.242e-08, 2.63461047831, 739.8086667949],
                        [2.718e-08, 3.40899287465, 188.9200730498],
                        [2.741e-08, 3.22092213412, 776.9303104764],
                        [2.793e-08, 3.39766347322, 431.264057322],
                        [2.966e-08, 3.9142937295, 526.5095713569],
                        [2.693e-08, 3.38996413068, 778.4147831847],
                        [2.68e-08, 3.82192393959, 3060.8259223474],
                        [2.954e-08, 2.69669880207, 426.6463749858],
                        [2.681e-08, 1.04615621583, 28.4541880032],
                        [3.182e-08, 2.72333374876, 432.2272651685],
                        [2.633e-08, 2.55029306465, 10213.285546211],
                        [2.923e-08, 0.85695094024, 2435.155730035],
                        [2.596e-08, 5.42890752137, 207.1487562837],
                        [3.225e-08, 0.9653861573, 2118.7638603784],
                        [2.774e-08, 0.3326084427, 326.6868103951],
                        [2.55e-08, 5.88893697427, 439.1283638482],
                        [2.716e-08, 3.15505406487, 170.7608257851],
                        [2.942e-08, 4.88555233562, 397.3932433474],
                        [3.121e-08, 1.87815629157, 2413.8150890326],
                        [3.263e-08, 2.59868619716, 213.0384630071],
                        [2.518e-08, 0.15471130491, 945.2434557067],
                        [3.169e-08, 5.70993651497, 381.3516082374],
                        [2.515e-08, 0.06248441393, 427.5613987225],
                        [3.279e-08, 4.95751323467, 313.9441891018],
                        [2.595e-08, 5.13169797457, 299.1263942692],
                        [2.572e-08, 3.42558391509, 4.192785694],
                        [2.58e-08, 2.03280916494, 319.3126309634],
                        [3.294e-08, 6.24566168486, 421.1815649046],
                        [2.58e-08, 2.62721090534, 213.1872208534],
                        [2.879e-08, 0.45679876898, 285.6330134505],
                        [2.406e-08, 4.57473098758, 228.276948965],
                        [2.518e-08, 2.5550008583, 140.001969579],
                        [2.422e-08, 2.36310658303, 84.3428261229],
                        [2.374e-08, 2.25544718932, 17.2654753874],
                        [2.627e-08, 1.26370339212, 724.8308132679],
                        [2.346e-08, 3.77641630157, 206.233732547],
                        [2.463e-08, 5.4209427824, 395.578702239],
                        [2.352e-08, 0.63041319237, 210.5907824523],
                        [3.166e-08, 0.26273580642, 201.5196819912],
                        [2.405e-08, 0.78919759458, 426.0769260142],
                        [2.39e-08, 5.89523812458, 738.7972748386],
                        [2.515e-08, 0.70044371265, 2943.5060541272],
                        [2.332e-08, 4.06963624306, 519.3960243561],
                        [3.132e-08, 2.7933163219, 732.6951197941],
                        [2.658e-08, 3.34020209714, 1141.1340634054],
                        [2.258e-08, 0.1240330973, 2524.021410252],
                        [2.697e-08, 2.58404587754, 425.6349830295],
                        [2.416e-08, 3.85003724506, 696.5196376166],
                        [2.597e-08, 2.54164936697, 436.1594184316],
                        [2.192e-08, 3.07202313269, 203.2647871304],
                        [2.424e-08, 2.60715310452, 511.5317178299],
                        [2.126e-08, 0.14811901148, 405.9912630565],
                        [2.306e-08, 1.25068142377, 427.1194557378],
                        [2.121e-08, 0.43505808954, 184.9879197867],
                        [2.755e-08, 3.02380019321, 468.2426886516],
                        [2.333e-08, 3.02634928771, 216.0074084237],
                        [2.182e-08, 4.27912012069, 7.1617311106],
                        [2.101e-08, 4.31781498012, 572.2292347475],
                        [2.362e-08, 4.8291434111, 556.5176680376],
                        [2.218e-08, 0.82936075453, 3370.1042450032],
                        [2.103e-08, 5.25950154713, 661.2379273164],
                        [2.58e-08, 1.0370534038, 213.4109700226],
                        [2.366e-08, 6.14368355608, 205.4347889118],
                        [2.042e-08, 0.21462094901, 3259.8979237838],
                        [2.547e-08, 4.69969204009, 221.3758502853],
                        [1.987e-08, 3.22670561632, 1382.8873468466],
                        [2.213e-08, 0.89932827487, 286.596221297],
                        [2.191e-08, 0.08759174058, 259.769518354],
                        [1.968e-08, 0.57824086026, 180.1619946463],
                        [2.037e-08, 2.35713099759, 610.6923387854],
                        [1.959e-08, 2.18553775379, 72.0732855816],
                        [2.061e-08, 1.68041202479, 1670.8250285],
                        [1.94e-08, 0.62951066481, 406.954470903],
                        [2.043e-08, 4.39130144045, 576.1613880106],
                        [1.936e-08, 1.0528693453, 1262.3860848887],
                        [1.975e-08, 0.3194583516, 938.1299087059],
                        [2.015e-08, 1.66410213484, 193.655375465],
                        [1.971e-08, 0.72639439054, 200.5564741447],
                        [1.952e-08, 6.25320630177, 241.7532834412],
                        [1.976e-08, 1.31263772699, 135.5485514541],
                        [2.448e-08, 0.52850194172, 429.5189521828],
                        [1.977e-08, 3.13944703383, 421.93232443],
                        [1.853e-08, 0.17184530353, 196.0336200506],
                        [2.552e-08, 5.39764879348, 2854.6403739102],
                        [1.83e-08, 1.47821899466, 638.4128136057],
                        [2.245e-08, 6.0042716427, 230.7075831773],
                        [1.822e-08, 6.08626100417, 1261.6353253633],
                        [2.168e-08, 0.41741136149, 213.5115437591],
                        [1.869e-08, 3.67791368036, 403.0223176399],
                        [1.866e-08, 1.59662677545, 391.1734682239],
                        [2.034e-08, 1.21814866092, 3046.5988283458],
                        [1.929e-08, 4.93193335031, 420.9691165835],
                        [1.746e-08, 5.09757251683, 107.7586406646],
                        [2.168e-08, 3.24685294764, 213.0866471169],
                        [2.178e-08, 5.09777299346, 558.0021407459],
                        [1.992e-08, 2.29524873043, 1773.9178027186],
                        [1.761e-08, 2.8865562467, 141.6988906084],
                        [1.769e-08, 5.47051542758, 206.1373643274],
                        [1.734e-08, 2.11941015901, 430.79097657],
                        [2.377e-08, 1.0763352157, 59.8037450403],
                        [1.797e-08, 2.90984583978, 92.7978334801],
                        [1.725e-08, 5.22827286197, 757.2171545342],
                        [2.305e-08, 5.88235807192, 426.5500067662],
                        [1.751e-08, 5.2899080347, 87.3117715395],
                        [2.202e-08, 1.28096946505, 624.919432787],
                        [2.043e-08, 0.46193065602, 831.1049812242],
                        [1.931e-08, 1.26974971942, 219.891377577],
                        [1.953e-08, 2.96900002385, 398.1440028728],
                        [1.676e-08, 4.81683149512, 181.806526049],
                        [1.902e-08, 2.74426125465, 4952.0635932862],
                        [2.133e-08, 5.37177705284, 627.3671133418],
                        [1.962e-08, 3.52111949662, 213.4591541324],
                        [1.709e-08, 6.14073761844, 952.3570027075],
                        [1.784e-08, 1.05243716682, 353.301065017],
                        [1.7e-08, 1.1741886417, 739.0579072695],
                        [1.609e-08, 1.35009554392, 84.9335269539],
                        [2.038e-08, 2.47570829812, 26.826702943],
                        [1.87e-08, 5.61729116529, 2957.7331481288],
                        [1.962e-08, 0.13564680851, 213.1390367436],
                        [2.041e-08, 3.31354526279, 1596.1864422846],
                        [1.612e-08, 6.19495100885, 432.0148168474],
                        [1.742e-08, 2.87947098602, 179.3588454942],
                        [1.964e-08, 2.84253666387, 429.0458714308],
                        [1.805e-08, 0.60932632638, 532.6117264014],
                        [1.647e-08, 0.82347900016, 214.5711198252],
                        [1.893e-08, 4.33962647901, 173.9422195228],
                        [1.689e-08, 1.13037158144, 586.3133163972],
                        [1.523e-08, 2.71561930244, 73.297125859],
                        [1.524e-08, 5.26558677448, 5429.8794682394],
                        [1.582e-08, 2.79533721474, 842.9014410135],
                        [1.608e-08, 2.33230359324, 418.5214360287],
                        [1.579e-08, 1.15182102801, 731.9443602687],
                        [1.689e-08, 1.91915438546, 630.3360587584],
                        [1.99e-08, 5.23790221176, 550.1378342197],
                        [1.772e-08, 2.95372411478, 172.2452984934],
                        [1.596e-08, 0.99004701777, 953.1077622329],
                        [1.784e-08, 3.9139103236, 159.1244246902],
                        [1.592e-08, 2.99690086808, 45.5766510387],
                        [1.968e-08, 0.23073879009, 220.364458329],
                        [1.549e-08, 5.88699595922, 60.5545045657],
                        [1.459e-08, 5.51999778036, 273.8536000037],
                        [1.909e-08, 2.78415262815, 418.0001711669],
                        [1.445e-08, 3.25530914937, 453.424893819],
                        [1.454e-08, 0.16250693313, 115.6229471908],
                        [1.566e-08, 2.24077018103, 1056.2005364515],
                        [1.412e-08, 3.45442909885, 354.9979860464],
                        [1.564e-08, 3.38591337689, 409.1897031367],
                        [1.631e-08, 1.06286709889, 213.5597278689],
                        [1.415e-08, 1.3209187759, 373.9079928365],
                        [1.389e-08, 0.40584159469, 9360.089164459],
                        [1.663e-08, 2.33357114562, 188.0263011725],
                        [1.426e-08, 5.44677783737, 864.2420820159],
                        [1.716e-08, 3.96056093028, 1699.2792165032],
                        [1.682e-08, 0.3974767032, 17.4084877393],
                        [1.368e-08, 5.83289186692, 569.0478410098],
                        [1.416e-08, 3.65464640816, 6.8529145699],
                        [1.469e-08, 3.4906919383, 934.9485149682],
                        [1.33e-08, 4.41794310534, 3914.0223040994],
                        [1.309e-08, 1.29979865382, 428.0826635843],
                        [1.3e-08, 1.57748627871, 238.5718897035],
                        [1.389e-08, 1.31202796503, 6275.9623029906],
                        [1.384e-08, 0.67585082323, 2751.5475996916],
                        [1.471e-08, 1.21149871903, 2531.1349572528],
                        [1.334e-08, 4.11154515525, 206.9363079626],
                        [1.601e-08, 0.93356520728, 355.7487455718],
                        [1.259e-08, 2.56678207309, 850.0149880143],
                        [1.277e-08, 0.41764451386, 100.6450936638],
                        [1.436e-08, 4.06045514506, 177.8743727859],
                        [1.308e-08, 1.01324076289, 423.6774295692],
                        [1.541e-08, 6.03020449918, 292.0128472684],
                        [1.307e-08, 5.83815678434, 5863.5912061162],
                        [1.613e-08, 2.45074803642, 1049.0869894507],
                        [1.249e-08, 3.01518429832, 464.7312265138],
                        [1.25e-08, 6.23516728885, 823.9914342234],
                        [1.275e-08, 2.68217384213, 637.4496057592],
                        [1.249e-08, 2.97028182853, 51749.2080922724],
                        [1.24e-08, 2.66940683813, 2700.7151403858],
                        [1.456e-08, 1.85558224828, 96.8729990951],
                        [1.491e-08, 4.98649587341, 295.1942410061],
                        [1.23e-08, 4.27283851216, 12139.5535091068],
                        [1.292e-08, 2.73196017809, 10206.1719992102],
                        [1.247e-08, 3.77399749791, 504.561183181],
                        [1.408e-08, 1.02955773079, 518.3846323998],
                        [1.223e-08, 1.1220209384, 221.1634019642],
                        [1.42e-08, 4.39795293289, 606.7601855223],
                        [1.19e-08, 1.57292553631, 820.0592809603],
                        [1.247e-08, 0.99102599652, 9793.8009023358],
                        [1.234e-08, 1.10826361423, 2303.6087678132],
                        [1.186e-08, 4.55984967028, 9808.5381846614],
                        [1.346e-08, 4.94456950019, 384.0599212231],
                        [1.514e-08, 3.6039229173, 2015.6710861598],
                        [1.432e-08, 2.28704432909, 525.4981794006],
                        [1.129e-08, 0.8710034062, 162.0933701068],
                        [1.196e-08, 5.1348521485, 227.3137411185],
                        [1.339e-08, 2.48923887712, 206.706813299],
                        [1.421e-08, 1.65379789078, 857.1285350151],
                        [1.162e-08, 1.92099315083, 220.9339073006],
                        [1.277e-08, 4.85435999187, 54.1746707478],
                        [1.153e-08, 5.33028034679, 233.9060232575],
                        [1.214e-08, 4.11324721963, 3377.217792004],
                        [1.109e-08, 5.68915582674, 162.8965192589],
                        [1.068e-08, 4.85383480876, 611.4430983108],
                        [1.119e-08, 1.40805686363, 1987.2168981566],
                        [1.085e-08, 0.6420814819, 731.6837278378],
                        [1.435e-08, 3.20880139888, 835.7878940127],
                        [1.184e-08, 2.99776919968, 199.2844497575],
                        [1.281e-08, 3.1224533951, 427.3489504014],
                        [1.058e-08, 5.17851282929, 306.0969289181],
                        [1.152e-08, 4.39244449554, 199.9657733137],
                        [1.036e-08, 3.68027119804, 597.3590166611],
                        [1.055e-08, 3.25561743426, 394.3548619616],
                        [1.127e-08, 4.3325537196, 552.5855147745],
                        [1.213e-08, 6.2144761211, 42.5382696529],
                        [1.117e-08, 3.74367882111, 214.1928673153],
                        [1.023e-08, 3.84199833949, 894.8408795276],
                        [1.042e-08, 5.3012007859, 450.9772132642],
                        [1.29e-08, 3.96221234564, 318.8395502114],
                        [1.073e-08, 4.10012122884, 188.1693135244],
                        [1.204e-08, 0.3770236575, 393.4610900843],
                        [1.214e-08, 2.01826978554, 401.3253966105],
                        [1.018e-08, 0.02946649279, 2840.4132799086],
                        [1.237e-08, 5.41088851225, 425.8474313506],
                        [1.187e-08, 5.16511890602, 838.218528225],
                        [1.276e-08, 2.93572146232, 1457.525933062],
                        [9.94e-09, 3.40079885702, 211.6021744086],
                        [1.042e-08, 2.42209320898, 361.3778198643],
                        [1.093e-08, 3.66289018246, 226.6324175623],
                        [9.78e-09, 3.76334208607, 5856.4776591154],
                        [1.263e-08, 2.09195268609, 78.7137518304],
                        [1.009e-08, 5.85963705048, 1268.7488723641],
                        [1.148e-08, 4.39543895068, 570.7447620392],
                        [1.051e-08, 3.27272240682, 153.4953503977],
                        [9.75e-09, 3.42924642244, 105.5404547734],
                        [9.97e-09, 4.30943991893, 212.4053235607],
                        [9.54e-09, 3.88548755058, 171.6545976624],
                        [9.6e-09, 1.9018000528, 1159.2933106701],
                        [9.53e-09, 3.40787141587, 244.791664827],
                        [9.69e-09, 1.93369993197, 525.7588118315],
                        [9.18e-09, 1.73738789723, 223.3334037456],
                        [1.164e-08, 5.05392864346, 263.7016716171],
                        [9.51e-09, 4.23581224839, 92.940845832],
                        [1.16e-08, 5.80630916592, 460.5384408198],
                        [1.186e-08, 4.46262000755, 465.9550667912],
                        [9.31e-09, 2.09868057209, 205.6642835754],
                        [9.42e-09, 3.86810837922, 238.4288773516],
                        [1.02e-08, 5.53181822898, 0.0481841098],
                        [9.95e-09, 2.0345788549, 6290.1893969922],
                        [8.88e-09, 2.6095759299, 1912.5783119412],
                        [8.73e-09, 5.7843339302, 480.7728616238],
                        [8.54e-09, 1.63255087291, 328.2407190726],
                        [1.123e-08, 4.07401922216, 3693.6096616606],
                        [9.34e-09, 3.52355235083, 10220.3990932118],
                        [8.33e-09, 3.0330222784, 532.8723588323],
                        [1.007e-08, 2.73615455688, 4841.8572720668],
                        [8.7e-09, 1.06968760644, 51.2057253312],
                        [8.91e-09, 1.36817544763, 700.4517908797],
                        [8.33e-09, 5.39754715806, 159.7151255212],
                        [8.54e-09, 1.91765015557, 622.4887985747],
                        [9.76e-09, 3.09106001923, 2332.0629558164],
                        [8.19e-09, 5.55683690482, 462.0229135281],
                        [8e-09, 1.4704267746, 969.6224780949],
                        [9.33e-09, 1.40166917666, 287.9376816534],
                        [7.84e-09, 1.6923516277, 477.8039162072],
                        [7.82e-09, 3.98153416585, 702.1487119091],
                        [8.1e-09, 5.87689161549, 561.934294009],
                        [8.58e-09, 4.02964773169, 41.6444977756],
                        [8.19e-09, 0.98885784755, 960.2213092337],
                        [8.82e-09, 1.49559638306, 760.25553592],
                        [7.67e-09, 2.46787654531, 402.2191684878],
                        [8.51e-09, 3.64678001195, 348.635198571],
                        [8.52e-09, 1.03470840672, 2620.0006374698],
                        [7.7e-09, 4.67090683753, 16.6747745564],
                        [8.49e-09, 5.27994730935, 74.6385862154],
                        [8.54e-09, 2.56811257488, 432.7485300303],
                        [7.67e-09, 1.11806243753, 2847.5268269094],
                        [7.29e-09, 0.4417199071, 898.7730327907],
                        [7.76e-09, 5.54603607568, 3171.0322435668],
                        [7.21e-09, 6.05392551158, 91.7864415238],
                        [7.39e-09, 3.57172839746, 775.233389447],
                        [7.3e-09, 4.98865345688, 705.1176573257],
                        [7.05e-09, 0.4494244575, 219.6618829134],
                        [7.08e-09, 0.69014726046, 1048.3362299253],
                        [7.06e-09, 2.22974712805, 29.2049475286],
                        [7.11e-09, 0.00981284716, 2115.5824666407],
                        [7.22e-09, 4.14075205197, 225.0785088848],
                        [7.35e-09, 1.54083195463, 201.9927627432],
                        [7.46e-09, 4.08997409526, 849.2642284889],
                        [7.29e-09, 2.81779134868, 419.532827985],
                        [8.37e-09, 1.00844734156, 4127.3213995374],
                        [9.39e-09, 0.46037763932, 5488.8681053816],
                        [9.39e-09, 1.85473712038, 5062.2699145056],
                        [7.21e-09, 1.62872794201, 2200.5159935946],
                      ],
          },
          {
            series => "R2",
            terms  => [
                        [0.00436902464, 4.78671673044, 213.299095438],
                        [0.0007192276, 2.50069994874, 206.1855484372],
                        [0.00049766792, 4.9716815087, 220.4126424388],
                        [0.00043220894, 3.86940443794, 426.598190876],
                        [0.00029645554, 5.96310264282, 7.1135470008],
                        [4.14165e-05, 4.10670940823, 433.7117378768],
                        [4.720909e-05, 2.47527992423, 199.0720014364],
                        [3.78937e-05, 3.09771025067, 639.897286314],
                        [2.96399e-05, 1.37206248846, 103.0927742186],
                        [2.556363e-05, 2.85065721526, 419.4846438752],
                        [2.208457e-05, 6.27588858707, 110.2063212194],
                        [2.187621e-05, 5.85545832218, 14.2270940016],
                        [1.956896e-05, 4.92448618045, 227.5261894396],
                        [2.326801e-05, 0, 0],
                        [9.2384e-06, 5.46392422737, 323.5054166574],
                        [7.05936e-06, 2.97081280098, 95.9792272178],
                        [5.46115e-06, 4.12854181522, 412.3710968744],
                        [3.73838e-06, 5.83435991809, 117.3198682202],
                        [3.60882e-06, 3.27703082368, 647.0108333148],
                        [3.5635e-06, 3.19152043942, 210.1177017003],
                        [3.90627e-06, 4.48106176893, 216.4804891757],
                        [4.31485e-06, 5.17825414612, 522.5774180938],
                        [3.25598e-06, 2.26867601656, 853.196381752],
                        [4.05018e-06, 4.17294157872, 209.3669421749],
                        [2.04494e-06, 0.0877484859, 202.2533951741],
                        [2.06854e-06, 4.02188336738, 735.8765135318],
                        [1.78474e-06, 4.09716541453, 440.8252848776],
                        [1.80143e-06, 3.59704903955, 632.7837393132],
                        [1.53656e-06, 3.13470530382, 625.6701923124],
                        [1.47779e-06, 0.13614300541, 302.164775655],
                        [1.23189e-06, 4.18895309647, 88.865680217],
                        [1.33076e-06, 2.5935046942, 191.9584544356],
                        [1.00367e-06, 5.46056190585, 3.1813937377],
                        [1.31975e-06, 5.93293968941, 309.2783226558],
                        [9.7235e-07, 4.01832604356, 728.762966531],
                        [1.10709e-06, 4.77853798276, 838.9692877504],
                        [1.19053e-06, 5.55385105975, 224.3447957019],
                        [9.3852e-07, 4.38395529912, 217.2312487011],
                        [1.08701e-06, 5.29310899841, 515.463871093],
                        [7.8609e-07, 5.72525447528, 21.3406410024],
                        [8.1468e-07, 5.10897365253, 956.2891559706],
                        [9.6412e-07, 6.25859229567, 742.9900605326],
                        [6.9228e-07, 4.04901237761, 3.9321532631],
                        [6.5168e-07, 3.77713343518, 1052.2683831884],
                        [6.4088e-07, 5.81235002453, 529.6909650946],
                        [6.2541e-07, 2.18445116349, 195.1398481733],
                        [5.6987e-07, 3.14666549033, 203.0041546995],
                        [5.5979e-07, 4.8410842286, 234.6397364404],
                        [5.294e-07, 5.07780548444, 330.6189636582],
                        [5.0635e-07, 2.77318570728, 942.062061969],
                        [4.1649e-07, 4.79014211005, 63.7358983034],
                        [4.4858e-07, 0.56460613593, 269.9214467406],
                        [4.1357e-07, 3.73496404402, 316.3918696566],
                        [5.2847e-07, 3.92623831484, 949.1756089698],
                        [3.8398e-07, 3.73966157784, 1045.1548361876],
                        [3.7583e-07, 4.18924633757, 536.8045120954],
                        [3.5285e-07, 2.90795856092, 284.1485407422],
                        [3.3576e-07, 3.80465978802, 149.5631971346],
                        [4.1073e-07, 4.57870454147, 1155.361157407],
                        [3.0412e-07, 2.48140171991, 860.3099287528],
                        [3.1373e-07, 4.84075951849, 1272.6810256272],
                        [3.0218e-07, 4.3518629447, 405.2575498736],
                        [3.943e-07, 3.50858482049, 422.6660376129],
                        [2.9658e-07, 1.58886982096, 1066.49547719],
                        [3.5202e-07, 5.94478241578, 1059.3819301892],
                        [2.5829e-07, 3.54946335477, 1368.660252845],
                        [2.6283e-07, 4.81567477177, 124.433415221],
                        [2.9963e-07, 3.66312205813, 429.7795846137],
                        [3.3011e-07, 4.96879544579, 831.8557407496],
                        [2.4305e-07, 5.31133255082, 10.2949407385],
                        [2.6332e-07, 4.4525327339, 223.5940361765],
                        [2.2108e-07, 2.76092021113, 415.5524906121],
                        [2.7187e-07, 1.66347897738, 277.0349937414],
                        [2.1639e-07, 1.03836302307, 11.0457002639],
                        [1.9713e-07, 2.52194629263, 1258.4539316256],
                        [1.7062e-07, 3.27669927228, 654.1243803156],
                        [1.7261e-07, 3.49414816663, 1361.5467058442],
                        [1.6097e-07, 1.73396878598, 490.3340891794],
                        [2.1099e-07, 3.62102032955, 1265.5674786264],
                        [1.7692e-07, 4.31141612385, 1471.7530270636],
                        [1.3458e-07, 0.32327889681, 295.0512286542],
                        [1.2586e-07, 3.13794576887, 74.7815985673],
                        [1.2023e-07, 2.32917797741, 210.8514148832],
                        [1.512e-07, 3.59558424278, 265.9892934775],
                        [1.2959e-07, 4.62359706368, 1589.0728952838],
                        [1.5424e-07, 5.01335704925, 127.4717966068],
                        [1.1193e-07, 4.54981248285, 81.7521332162],
                        [1.3449e-07, 4.88710089777, 437.6438911399],
                        [1.0673e-07, 5.05234757424, 191.2076949102],
                        [1.3963e-07, 3.04990968366, 423.4167971383],
                        [1.0614e-07, 5.02845923229, 137.0330241624],
                        [1.4382e-07, 4.68720080027, 1148.2476104062],
                        [1.347e-07, 1.90280407135, 408.4389436113],
                        [1.0077e-07, 5.20426583827, 340.7708920448],
                        [1.0323e-07, 3.34460279759, 1685.0521225016],
                        [9.563e-08, 3.17317920222, 351.8165923087],
                        [1.1295e-07, 5.47808960704, 1375.7737998458],
                        [8.617e-08, 2.81294528041, 99.9113804809],
                        [8.46e-08, 3.22691940753, 1677.9385755008],
                        [7.914e-08, 2.35624291874, 1574.8458012822],
                        [7.587e-08, 6.08171425316, 231.4583427027],
                        [9.175e-08, 3.40072244924, 1581.959348283],
                        [7.337e-08, 2.00393601815, 131.4039498699],
                        [8.24e-08, 4.04095881407, 1788.1448967202],
                        [7.579e-08, 3.68311134272, 846.0828347512],
                        [6.691e-08, 4.37253800717, 145.6310438715],
                        [7.539e-08, 3.29482043104, 750.1036075334],
                        [6.367e-08, 4.00239137708, 447.9388318784],
                        [6.249e-08, 4.5560367194, 106.2741679563],
                        [6.489e-08, 1.33782087599, 215.7467759928],
                        [6.501e-08, 3.78204726337, 313.2104759189],
                        [5.978e-08, 0.55276980086, 18.1592472647],
                        [6.171e-08, 2.84712795642, 138.5174968707],
                        [6.837e-08, 4.83481646949, 319.5732633943],
                        [6.678e-08, 5.43046031699, 508.3503240922],
                        [7.175e-08, 4.37855723752, 1464.6394800628],
                        [5.753e-08, 4.14268749228, 543.9180590962],
                        [5.727e-08, 4.35383078313, 1905.4647649404],
                        [5.101e-08, 2.63866058897, 288.0806940053],
                        [5.311e-08, 3.6252084951, 6076.8903015542],
                        [5.498e-08, 4.19972735173, 721.6494195302],
                        [5.089e-08, 5.04845206653, 10007.0999977738],
                        [5.505e-08, 1.13479635941, 56.6223513026],
                        [4.82e-08, 3.30043078578, 76.2660712756],
                        [4.915e-08, 6.17790518458, 483.2205421786],
                        [5.048e-08, 2.44627820757, 628.8515860501],
                        [4.534e-08, 1.19648682598, 200.7689224658],
                        [4.817e-08, 3.11549733365, 2001.4439921582],
                        [4.712e-08, 1.26507812515, 6062.6632075526],
                        [4.811e-08, 5.78388270496, 184.8449074348],
                        [4.775e-08, 0.76197795755, 333.657345044],
                        [4.514e-08, 0.95293919611, 343.2185725996],
                        [4.525e-08, 2.68827745072, 9992.8729037722],
                        [4.378e-08, 0.80241129896, 222.8603229936],
                        [4.873e-08, 5.92092913946, 618.5566453116],
                        [4.142e-08, 1.91878383159, 497.4476361802],
                        [5.112e-08, 4.50449287745, 416.3032501375],
                        [4.125e-08, 1.98204847532, 347.8844390456],
                        [4.045e-08, 2.87666810085, 38.1330356378],
                        [4.133e-08, 2.90478811425, 107.0249274817],
                        [4.035e-08, 2.92972681787, 1994.3304451574],
                        [4.916e-08, 3.12316267561, 1898.3512179396],
                        [3.657e-08, 3.24680246734, 362.8622925726],
                        [3.753e-08, 0.87719890943, 703.6331846174],
                        [3.576e-08, 3.48080143501, 388.4651552382],
                        [3.555e-08, 4.08436297683, 430.5303441391],
                        [3.598e-08, 0.05255328597, 32.2433289144],
                        [3.561e-08, 5.46414552453, 6283.0758499914],
                        [3.48e-08, 1.81622589595, 70.8494453042],
                        [3.827e-08, 3.1204122849, 635.9651330509],
                        [3.399e-08, 0.54882815021, 10213.285546211],
                        [3.399e-08, 3.5183335608, 629.6023455755],
                        [3.364e-08, 3.27821747958, 357.4456666012],
                        [3.26e-08, 1.97623748027, 203.7378678824],
                        [3.118e-08, 2.18465627368, 1891.2376709388],
                        [3.163e-08, 1.26040995242, 134.5853436076],
                        [4.004e-08, 5.45434102599, 1692.1656695024],
                        [3.18e-08, 2.46319174788, 867.4234757536],
                        [3.389e-08, 4.20503159673, 337.732510659],
                        [3.026e-08, 2.19331614526, 217.964961884],
                        [3.573e-08, 5.5509724081, 113.3877149571],
                        [3.682e-08, 3.78966280284, 2104.5367663768],
                        [3.125e-08, 4.09203641264, 1478.8665740644],
                        [2.881e-08, 3.9081065024, 312.1990839626],
                        [3.199e-08, 3.92123638342, 1038.0412891868],
                        [4.014e-08, 5.17826893553, 404.5067903482],
                        [3.907e-08, 4.1176719178, 1781.0313497194],
                        [3.144e-08, 1.61185684069, 1073.6090241908],
                        [3.072e-08, 5.00675625396, 312.4597163935],
                        [3.034e-08, 5.46288652854, 258.8757464767],
                        [2.884e-08, 2.38477237305, 181.0557665236],
                        [2.986e-08, 0.88783591586, 1279.794572628],
                        [2.683e-08, 0.00956197492, 195.8906076987],
                        [3.081e-08, 5.6003473733, 216.2198567448],
                        [2.626e-08, 6.12701960244, 273.1028404783],
                        [2.665e-08, 2.31576422128, 565.1156877467],
                        [3.245e-08, 3.87540558646, 85.8272988312],
                        [2.74e-08, 5.73784096806, 160.6088973985],
                        [2.876e-08, 4.74720607366, 213.2509113282],
                        [2.523e-08, 5.30458920892, 444.7574381407],
                        [2.752e-08, 5.0898453993, 1169.5882514086],
                        [2.889e-08, 1.66674437398, 213.3472795478],
                        [2.923e-08, 4.21481009033, 650.9429865779],
                        [3.036e-08, 2.5542667535, 6069.7767545534],
                        [3.116e-08, 2.67220972004, 52.6901980395],
                        [2.371e-08, 0.89591351822, 121.2520214833],
                        [2.993e-08, 3.96957827454, 9999.986450773],
                        [3.088e-08, 0.40656113014, 561.1835344836],
                        [2.385e-08, 4.74063881551, 218.7157214094],
                        [2.632e-08, 1.12706218927, 344.7030453079],
                        [2.316e-08, 4.08445262041, 131.5469622218],
                        [2.214e-08, 3.37726228553, 22.0914005278],
                        [2.129e-08, 3.32497715011, 358.9301393095],
                        [2.679e-08, 1.6897140187, 208.633228992],
                        [2.607e-08, 5.10250482155, 824.7421937488],
                        [2.25e-08, 2.60474848767, 305.3461693927],
                        [2.087e-08, 3.37293958793, 320.3240229197],
                        [2.693e-08, 3.6215945647, 436.8931316145],
                        [2.492e-08, 2.96129217279, 2214.7430875962],
                        [2.704e-08, 2.88483697319, 643.0786800517],
                        [2.124e-08, 1.61210282593, 218.9281697305],
                        [2.037e-08, 4.63481160778, 188.0263011725],
                        [2.394e-08, 3.46386258552, 6275.9623029906],
                        [1.973e-08, 2.28886138203, 2627.1141844706],
                        [1.937e-08, 5.67082364247, 28.4541880032],
                        [1.92e-08, 4.25647211328, 546.956440482],
                        [2.498e-08, 3.57572154405, 2420.9286360334],
                        [1.898e-08, 1.30987536388, 212.3358875915],
                        [1.852e-08, 1.58508015515, 424.1505103212],
                        [1.85e-08, 3.57830449726, 329.7251917809],
                        [2.128e-08, 3.95329215734, 1795.258443721],
                        [2.236e-08, 4.22073549375, 2221.856634597],
                        [1.933e-08, 1.68771499202, 350.3321196004],
                        [1.799e-08, 2.06541260431, 144.1465711632],
                        [1.904e-08, 4.60953896857, 182.279606801],
                        [2.236e-08, 5.17945392885, 99.1606209555],
                        [1.755e-08, 2.73425330428, 291.262087743],
                        [2.231e-08, 5.42548168745, 207.8824694666],
                        [1.848e-08, 2.24194286719, 168.0525127994],
                        [1.726e-08, 1.31878655393, 219.4494345923],
                        [1.709e-08, 5.55913931846, 92.7978334801],
                        [1.693e-08, 1.95360003617, 129.9194771616],
                        [2.064e-08, 4.84900344498, 1141.1340634054],
                        [1.758e-08, 5.05088656436, 214.2623032845],
                        [1.781e-08, 2.8588015334, 636.7158925763],
                        [1.9e-08, 2.90295578617, 2310.722314814],
                        [1.759e-08, 5.34657858395, 45.5766510387],
                        [1.654e-08, 6.14450664508, 554.0699874828],
                        [1.578e-08, 4.50941374663, 210.3783341312],
                        [1.681e-08, 3.55136706992, 1354.4331588434],
                        [1.862e-08, 3.01276783582, 2317.8358618148],
                        [1.589e-08, 1.1577344835, 235.3904959658],
                        [1.551e-08, 2.15558953807, 207.6700211455],
                        [1.874e-08, 4.12861627986, 225.8292684102],
                        [1.621e-08, 3.29992957653, 1670.8250285],
                        [1.911e-08, 0.1772431914, 12.5301729722],
                        [1.477e-08, 5.9027026057, 1.4844727083],
                        [1.618e-08, 5.72513459206, 1485.9801210652],
                        [1.446e-08, 1.7810458992, 1382.8873468466],
                        [1.683e-08, 3.43534671475, 2428.0421830342],
                        [1.542e-08, 5.51223038941, 204.7010757289],
                        [1.42e-08, 2.07339356364, 198.321241911],
                        [1.444e-08, 5.56032454849, 128.3655684841],
                        [1.476e-08, 6.12782257368, 212.7778305762],
                        [1.474e-08, 0.33626790634, 213.8203602998],
                        [1.428e-08, 3.25039966249, 945.9942152321],
                        [1.41e-08, 0.68747644676, 429.0458714308],
                        [1.752e-08, 2.70090942746, 12.7426212933],
                        [1.681e-08, 4.97526853273, 2008.557539159],
                        [1.408e-08, 0.80461100746, 1585.1407420207],
                        [1.485e-08, 0.49674043855, 120.358249606],
                        [1.49e-08, 2.68459799437, 207.1487562837],
                        [1.411e-08, 4.36399216092, 5863.5912061162],
                        [1.315e-08, 4.73430848989, 241.7532834412],
                        [1.516e-08, 4.99488503706, 1162.4747044078],
                        [1.31e-08, 1.98714265058, 563.6312150384],
                        [1.286e-08, 2.12891372062, 251.4321310758],
                        [1.271e-08, 5.70165238307, 2.9207613068],
                        [1.312e-08, 1.68811514551, 2207.6295405954],
                        [1.259e-08, 0.35924965717, 334.5511169213],
                        [1.252e-08, 2.14513440216, 1055.4497769261],
                        [1.401e-08, 6.13250261735, 1802.3719907218],
                        [1.343e-08, 5.79995727295, 9793.8009023358],
                        [1.228e-08, 3.29059284057, 661.2379273164],
                        [1.202e-08, 2.88792018909, 2413.8150890326],
                        [1.286e-08, 5.72360160371, 298.2326223919],
                        [1.357e-08, 0.93175963411, 217.491881132],
                        [1.356e-08, 2.28121627817, 601.7642506762],
                        [1.19e-08, 1.94993809928, 501.3797894433],
                        [1.304e-08, 0.3733792328, 3473.1970192218],
                        [1.35e-08, 2.8723562232, 142.4496501338],
                        [1.349e-08, 3.21102203937, 175.1660598002],
                        [1.312e-08, 3.70149813509, 2111.6503133776],
                        [1.129e-08, 1.08860603834, 842.1506814881],
                        [1.237e-08, 0.08698781252, 526.5095713569],
                        [1.217e-08, 3.8983534984, 209.106309744],
                        [1.467e-08, 1.16228775027, 621.7380390493],
                        [1.044e-08, 0.30512759901, 436.1594184316],
                        [1.14e-08, 5.33720637097, 114.1384744825],
                        [1.295e-08, 4.70261675421, 9786.687355335],
                        [1.037e-08, 4.07846687083, 156.6767441354],
                        [1.391e-08, 4.73554028436, 398.1440028728],
                        [1.167e-08, 5.68899703631, 479.2883889155],
                        [1.035e-08, 5.34279429465, 327.4375699205],
                        [9.97e-09, 1.19323192891, 710.7467316182],
                        [1.193e-08, 5.17722376816, 98.8999885246],
                        [1.165e-08, 4.58588490135, 732.6951197941],
                        [1.161e-08, 4.90854984994, 10206.1719992102],
                        [1.144e-08, 0.5039478414, 3906.9087570986],
                        [1.182e-08, 3.69482624364, 2854.6403739102],
                        [9.7e-09, 2.89031410383, 1987.2168981566],
                        [1.039e-08, 0.48694895443, 525.4981794006],
                        [1.079e-08, 3.61750956217, 2097.423219376],
                        [1.148e-08, 3.31015591733, 5856.4776591154],
                        [1.241e-08, 4.31971543677, 230.7075831773],
                        [9.1e-09, 4.59825926062, 380.12776796],
                        [9.07e-09, 1.34912454077, 685.4739373527],
                        [1.166e-08, 1.61085609717, 5849.3641121146],
                        [8.82e-09, 6.12045540405, 519.3960243561],
                        [9.63e-09, 4.96065454054, 699.7010313543],
                        [1.062e-08, 5.13323858077, 2751.5475996916],
                        [8.65e-09, 6.12821112133, 245.5424243524],
                        [1.1e-08, 2.18435744407, 1699.2792165032],
                        [8.22e-09, 5.55083534581, 739.0579072695],
                        [9.26e-09, 2.01158276144, 417.0369633204],
                        [8.13e-09, 5.18401872205, 214.7835681463],
                        [1.033e-08, 5.48677848094, 3995.7744373156],
                        [8.72e-09, 3.02363724703, 306.0969289181],
                        [7.96e-09, 0.4434366454, 486.4019359163],
                        [8.78e-09, 1.82164034386, 135.336103133],
                        [7.91e-09, 2.14989417962, 2620.0006374698],
                        [8.81e-09, 2.39697554334, 289.5651667136],
                        [7.82e-09, 4.50471317138, 980.6681783588],
                        [7.83e-09, 1.14229319753, 540.7366653585],
                        [8.31e-09, 0.69937251013, 421.93232443],
                        [7.7e-09, 2.40292326155, 576.1613880106],
                        [9.5e-09, 5.97621460162, 196.6243208816],
                        [8.14e-09, 4.19303098086, 831.1049812242],
                        [9.69e-09, 4.78071024754, 326.6868103951],
                        [7.6e-09, 0.4486053353, 425.6349830295],
                        [9.07e-09, 0.94781730418, 525.7588118315],
                        [7.88e-09, 0.14287187051, 916.9322800554],
                        [8.01e-09, 1.863831191, 3039.485281345],
                        [8.01e-09, 0.46947170994, 3466.083472221],
                        [7.47e-09, 6.05374861925, 211.8146227297],
                        [9.68e-09, 3.02618272726, 2634.2277314714],
                        [7.39e-09, 2.27110740297, 2303.6087678132],
                        [7.5e-09, 5.48554383902, 173.9422195228],
                        [1.024e-08, 1.9156492556, 229.9738699944],
                        [8.16e-09, 4.98990432666, 4209.0735327536],
                        [7.28e-09, 1.30997967935, 511.5317178299],
                        [7.16e-09, 3.74192651696, 3053.7123753466],
                        [7.27e-09, 0.39191881243, 1493.093668066],
                        [7.17e-09, 2.68899513085, 228.276948965],
                        [7.39e-09, 2.12749199443, 1176.7017984094],
                        [8.05e-09, 0.0718719391, 556.5176680376],
                        [8.35e-09, 3.482878557, 84.9335269539],
                        [7.9e-09, 0.48073040004, 4017.115078318],
                        [7.25e-09, 1.96643065215, 220.4608265486],
                        [6.83e-09, 2.68825142163, 151.0476698429],
                        [7.39e-09, 3.33688408107, 953.1077622329],
                        [7.45e-09, 6.22304530635, 1269.4996318895],
                      ],
          },
          {
            series => "R3",
            terms  => [
                        [0.00020315005, 3.02186626038, 213.299095438],
                        [8.923581e-05, 3.19144205755, 220.4126424388],
                        [6.908677e-05, 4.35174889353, 206.1855484372],
                        [4.087129e-05, 4.22406927376, 7.1135470008],
                        [3.879041e-05, 2.01056445995, 426.598190876],
                        [1.070788e-05, 4.20360341236, 199.0720014364],
                        [9.07332e-06, 2.28344368029, 433.7117378768],
                        [6.06121e-06, 3.17458570534, 227.5261894396],
                        [5.96639e-06, 4.13455753351, 14.2270940016],
                        [4.83181e-06, 1.17345973258, 639.897286314],
                        [3.93174e-06, 0, 0],
                        [2.29472e-06, 4.69838526383, 419.4846438752],
                        [1.8825e-06, 4.59003889007, 110.2063212194],
                        [1.49508e-06, 3.201994444, 103.0927742186],
                        [1.21442e-06, 3.76831374104, 323.5054166574],
                        [1.01215e-06, 5.81884137755, 412.3710968744],
                        [1.02146e-06, 4.70974422803, 95.9792272178],
                        [9.3078e-07, 1.43531270909, 647.0108333148],
                        [7.2601e-07, 4.15395598507, 117.3198682202],
                        [8.4347e-07, 2.63462379693, 216.4804891757],
                        [6.2198e-07, 2.31239345505, 440.8252848776],
                        [4.5145e-07, 4.37317047297, 191.9584544356],
                        [4.9536e-07, 2.38854232908, 209.3669421749],
                        [5.4829e-07, 0.30526468471, 853.196381752],
                        [4.0498e-07, 1.83836569765, 302.164775655],
                        [3.8089e-07, 5.94455115525, 88.865680217],
                        [3.2243e-07, 4.01146349387, 21.3406410024],
                        [4.0671e-07, 0.6884518321, 522.5774180938],
                        [2.8209e-07, 5.77193013961, 210.1177017003],
                        [2.4976e-07, 3.06249709014, 234.6397364404],
                        [2.0824e-07, 4.92570695678, 625.6701923124],
                        [2.507e-07, 0.73137425284, 515.463871093],
                        [1.7485e-07, 5.73135068691, 728.762966531],
                        [1.8009e-07, 1.45593152612, 309.2783226558],
                        [1.6927e-07, 3.52771580455, 3.1813937377],
                        [1.3437e-07, 3.36479898106, 330.6189636582],
                        [1.109e-07, 3.37212682914, 224.3447957019],
                        [1.1082e-07, 3.41719974793, 956.2891559706],
                        [9.978e-08, 1.58791582772, 202.2533951741],
                        [1.1551e-07, 5.99093726182, 735.8765135318],
                        [1.05e-07, 6.06911092266, 405.2575498736],
                        [9.144e-08, 2.93557421591, 124.433415221],
                        [8.737e-08, 4.65432480769, 632.7837393132],
                        [1.0023e-07, 0.58247011625, 860.3099287528],
                        [7.482e-08, 4.50669216436, 942.062061969],
                        [1.0091e-07, 0.28268774007, 838.9692877504],
                        [9.243e-08, 2.57034547708, 223.5940361765],
                        [8.652e-08, 1.75808100881, 429.7795846137],
                        [7.564e-08, 1.45635107202, 654.1243803156],
                        [7.058e-08, 5.47394786065, 1045.1548361876],
                        [6.97e-08, 1.51811695028, 422.6660376129],
                        [8.067e-08, 4.48457709292, 742.9900605326],
                        [6.817e-08, 4.83084424818, 316.3918696566],
                        [7.693e-08, 0.43769724671, 831.8557407496],
                        [7.934e-08, 4.20112367712, 195.1398481733],
                        [6.119e-08, 2.33960392135, 269.9214467406],
                        [5.589e-08, 1.14518720694, 284.1485407422],
                        [5.564e-08, 4.18123189068, 529.6909650946],
                        [5.034e-08, 2.12020038657, 295.0512286542],
                        [6.556e-08, 3.42459866876, 10.2949407385],
                        [5.544e-08, 2.46823271699, 536.8045120954],
                        [6.189e-08, 6.0143382752, 1066.49547719],
                        [5.649e-08, 0.82784598388, 217.2312487011],
                        [4.264e-08, 3.23245736673, 1272.6810256272],
                        [4.45e-08, 0.9247780859, 203.0041546995],
                        [3.268e-08, 4.32777516976, 1258.4539316256],
                        [3.655e-08, 0.05832123987, 81.7521332162],
                        [3.951e-08, 0.11124996745, 1155.361157407],
                        [3.773e-08, 6.01157059552, 1052.2683831884],
                        [2.915e-08, 5.64342950039, 3.9321532631],
                        [3.019e-08, 2.19411778004, 447.9388318784],
                        [2.977e-08, 1.8938734255, 149.5631971346],
                        [3.146e-08, 0.19215180096, 1148.2476104062],
                        [2.763e-08, 0.92363342001, 508.3503240922],
                        [2.79e-08, 4.97199778427, 1677.9385755008],
                        [2.608e-08, 2.99591016813, 1589.0728952838],
                        [2.881e-08, 5.40535671721, 1361.5467058442],
                        [2.337e-08, 1.30362271569, 184.8449074348],
                        [2.536e-08, 3.71412120849, 408.4389436113],
                        [2.45e-08, 3.22118361135, 319.5732633943],
                        [2.585e-08, 2.31346415454, 543.9180590962],
                        [2.324e-08, 5.87500715503, 721.6494195302],
                        [1.99e-08, 0.51565577383, 416.3032501375],
                        [2.49e-08, 4.24017800021, 1059.3819301892],
                        [1.935e-08, 2.41463084855, 337.732510659],
                        [1.886e-08, 0.53809070779, 635.9651330509],
                        [1.893e-08, 5.62352727352, 11.0457002639],
                        [2.389e-08, 5.73399981234, 313.2104759189],
                        [1.9e-08, 2.41000566465, 131.5469622218],
                        [1.743e-08, 4.57646237847, 1994.3304451574],
                        [1.913e-08, 5.17436386408, 2854.6403739102],
                        [1.946e-08, 6.23355845623, 1471.7530270636],
                        [1.963e-08, 6.17814558628, 1464.6394800628],
                        [1.838e-08, 5.59464577559, 1038.0412891868],
                        [1.541e-08, 0.60765337379, 210.8514148832],
                        [1.617e-08, 1.75479346067, 195.8906076987],
                        [1.577e-08, 0.55789908488, 2324.9494088156],
                        [1.492e-08, 0.26624235633, 497.4476361802],
                        [1.659e-08, 2.57526072926, 2090.3096723752],
                        [1.809e-08, 1.82317819973, 436.8931316145],
                        [1.566e-08, 6.15328100324, 490.3340891794],
                        [1.771e-08, 6.11741716855, 1073.6090241908],
                        [1.456e-08, 0.85374460914, 415.5524906121],
                        [1.645e-08, 2.95335775161, 437.6438911399],
                        [1.391e-08, 4.1202502856, 1574.8458012822],
                        [1.585e-08, 5.96841377266, 1781.0313497194],
                        [1.507e-08, 3.84895122542, 1251.3403846248],
                        [1.442e-08, 5.32547705924, 2538.2485042536],
                        [1.805e-08, 1.50973093681, 750.1036075334],
                        [1.462e-08, 3.28599831588, 1884.124123938],
                        [1.482e-08, 0.99340744053, 643.0786800517],
                        [1.312e-08, 3.79347668996, 1567.7322542814],
                        [1.665e-08, 0.02551523913, 423.4167971383],
                        [1.469e-08, 5.35285153471, 1354.4331588434],
                        [1.352e-08, 0.69945139243, 867.4234757536],
                        [1.124e-08, 1.79624810407, 618.5566453116],
                        [1.126e-08, 4.70052329245, 113.3877149571],
                        [1.122e-08, 3.9553722427, 1891.2376709388],
                        [1.458e-08, 1.50198846753, 430.5303441391],
                        [1.145e-08, 5.13093399117, 25.2727942655],
                        [1.178e-08, 2.97062300389, 241.7532834412],
                        [1.274e-08, 2.29089799814, 2420.9286360334],
                        [1.071e-08, 0.04888943982, 63.7358983034],
                        [1.377e-08, 5.58271514873, 1382.8873468466],
                        [1.145e-08, 3.10797488346, 2200.5159935946],
                        [1.076e-08, 0.79465514815, 127.4717966068],
                        [1.046e-08, 5.85060227045, 215.7467759928],
                        [1.082e-08, 3.7258944551, 131.4039498699],
                        [1.218e-08, 0.47504349592, 824.7421937488],
                        [1.116e-08, 3.78039049056, 1375.7737998458],
                        [9.69e-09, 5.90752273481, 265.9892934775],
                        [1.23e-08, 1.41325962069, 2634.2277314714],
                        [1.07e-08, 4.80334493874, 1987.2168981566],
                        [9.46e-09, 6.25968535931, 2015.6710861598],
                        [1.03e-08, 1.08973644893, 362.8622925726],
                        [1.072e-08, 5.41838042079, 1279.794572628],
                        [8.8e-09, 1.92224908504, 483.2205421786],
                        [8.78e-09, 2.96591300878, 934.9485149682],
                        [8.79e-09, 2.65659265685, 145.6310438715],
                        [8.72e-09, 6.26261969664, 2.4476805548],
                        [1.082e-08, 4.48298283322, 2214.7430875962],
                        [9.59e-09, 0.74479087918, 16.6747745564],
                        [1.035e-08, 4.05664979327, 231.4583427027],
                        [8.51e-09, 0.09360495322, 628.8515860501],
                        [8.88e-09, 5.98816755324, 2524.021410252],
                        [8.66e-09, 3.1625926563, 2207.6295405954],
                        [8.43e-09, 1.23731248821, 74.7815985673],
                        [8.09e-09, 2.89742868175, 2008.557539159],
                        [7.79e-09, 2.28434811609, 1478.8665740644],
                        [9.9e-09, 5.32604038017, 2428.0421830342],
                        [7.95e-09, 2.3817813581, 2228.9701815978],
                        [7.65e-09, 4.7003367494, 1670.8250285],
                        [1.024e-08, 4.23352869513, 1802.3719907218],
                        [8.31e-09, 5.87457134912, 1368.660252845],
                        [7.17e-09, 5.92144324994, 1685.0521225016],
                        [7.72e-09, 1.15596098579, 3053.7123753466],
                        [6.91e-09, 3.13193109668, 56.6223513026],
                      ],
          },
          {
            series => "R4",
            terms  => [
                        [1.20205e-05, 1.41499446465, 220.4126424388],
                        [7.07796e-06, 1.16153570102, 213.299095438],
                        [5.16121e-06, 6.2397356833, 206.1855484372],
                        [4.26664e-06, 2.46924890293, 7.1135470008],
                        [2.67736e-06, 0.18659206741, 426.598190876],
                        [1.70171e-06, 5.95926972384, 199.0720014364],
                        [1.45113e-06, 1.44211060143, 227.5261894396],
                        [1.50339e-06, 0.4797016714, 433.7117378768],
                        [1.21033e-06, 2.40527320817, 14.2270940016],
                        [4.7332e-07, 5.56857488676, 639.897286314],
                        [1.5745e-07, 2.90112466278, 110.2063212194],
                        [1.6668e-07, 0.52920774279, 440.8252848776],
                        [1.8954e-07, 5.85626429118, 647.0108333148],
                        [1.4074e-07, 1.30343550656, 412.3710968744],
                        [1.2708e-07, 2.09349305926, 323.5054166574],
                        [1.4724e-07, 0.29905316786, 419.4846438752],
                        [1.1133e-07, 2.4630482599, 117.3198682202],
                        [1.132e-07, 0.21785507019, 95.9792272178],
                        [9.233e-08, 2.28127318068, 21.3406410024],
                        [9.246e-08, 1.5649631283, 88.865680217],
                        [8.97e-08, 0.68301278041, 216.4804891757],
                        [7.674e-08, 3.59367715368, 302.164775655],
                        [7.823e-08, 4.48688804175, 853.196381752],
                        [8.36e-08, 1.27239488455, 234.6397364404],
                        [9.552e-08, 3.14159265359, 0],
                        [4.834e-08, 2.58836294602, 515.463871093],
                        [6.059e-08, 5.1677444874, 103.0927742186],
                        [4.41e-08, 0.02211643085, 191.9584544356],
                        [4.364e-08, 1.59622746023, 330.6189636582],
                        [3.676e-08, 3.29899839673, 210.1177017003],
                        [4.364e-08, 5.97349927933, 654.1243803156],
                        [4.447e-08, 4.97415112184, 860.3099287528],
                        [3.22e-08, 2.72684237392, 522.5774180938],
                        [4.005e-08, 1.59858435636, 405.2575498736],
                        [3.099e-08, 0.75235436533, 209.3669421749],
                        [2.464e-08, 1.19167306488, 124.433415221],
                        [3.088e-08, 1.32258934286, 728.762966531],
                        [2.22e-08, 3.28087994088, 203.0041546995],
                        [2.127e-08, 6.14648095022, 429.7795846137],
                        [2.11e-08, 0.75462855247, 295.0512286542],
                        [2.02e-08, 3.89394929749, 1066.49547719],
                        [2.248e-08, 0.49319150178, 447.9388318784],
                        [2.18e-08, 0.72761059998, 625.6701923124],
                        [1.809e-08, 0.09057839517, 942.062061969],
                        [1.672e-08, 1.39635398184, 224.3447957019],
                        [1.641e-08, 3.0246830755, 184.8449074348],
                        [1.772e-08, 0.81879250825, 223.5940361765],
                        [1.902e-08, 2.00472814984, 831.8557407496],
                        [1.6e-08, 5.41185167676, 824.7421937488],
                        [1.505e-08, 5.95520747253, 422.6660376129],
                        [1.133e-08, 1.11512973946, 838.9692877504],
                        [1.19e-08, 1.89600567803, 956.2891559706],
                        [1.487e-08, 2.11906469507, 529.6909650946],
                        [1.409e-08, 0.72254420236, 536.8045120954],
                        [1.125e-08, 0.89062692183, 721.6494195302],
                        [1.301e-08, 1.64867038984, 17.4084877393],
                        [1.164e-08, 5.9695798184, 195.1398481733],
                        [9.5e-09, 5.3608071329, 316.3918696566],
                        [9.85e-09, 3.05768671768, 1574.8458012822],
                        [1.05e-08, 1.59202481523, 735.8765135318],
                        [8.17e-09, 4.92838813598, 56.6223513026],
                        [7.8e-09, 2.72125404102, 508.3503240922],
                        [9.69e-09, 1.00708261792, 1045.1548361876],
                        [7.16e-09, 1.11042181341, 1169.5882514086],
                      ],
          },
          {
            series => "R5",
            terms  => [
                        [1.28612e-06, 5.91282565136, 220.4126424388],
                        [3.2273e-07, 0.69256228602, 7.1135470008],
                        [2.6698e-07, 5.91428528629, 227.5261894396],
                        [1.9923e-07, 0.67370653385, 14.2270940016],
                        [2.0223e-07, 4.95136801768, 433.7117378768],
                        [1.3537e-07, 1.45669521408, 199.0720014364],
                        [1.4097e-07, 2.67074280191, 206.1855484372],
                        [1.3364e-07, 4.5882699637, 426.598190876],
                        [7.257e-08, 4.62966127155, 213.299095438],
                        [4.876e-08, 3.61448275002, 639.897286314],
                        [3.136e-08, 4.65661021909, 191.9584544356],
                        [2.917e-08, 0.48665273315, 323.5054166574],
                        [3.759e-08, 4.89624165044, 440.8252848776],
                        [3.303e-08, 4.07190859545, 647.0108333148],
                        [2.883e-08, 3.18003019204, 419.4846438752],
                        [2.338e-08, 3.69553554327, 88.865680217],
                        [1.95e-08, 5.3272924778, 302.164775655],
                        [2.052e-08, 3.31663577368, 95.9792272178],
                        [1.591e-08, 2.67009215574, 853.196381752],
                        [2.028e-08, 0.56025552769, 117.3198682202],
                        [1.56e-08, 0.85608042681, 515.463871093],
                        [1.678e-08, 0, 0],
                        [1.102e-08, 5.98011943842, 3.1813937377],
                        [1.285e-08, 5.82563377753, 234.6397364404],
                        [8.96e-09, 5.22791858719, 216.4804891757],
                        [1.141e-08, 0.15741228205, 412.3710968744],
                        [7.98e-09, 0.37452846153, 28.4541880032],
                        [8.37e-09, 5.04769794123, 124.433415221],
                      ],
          },
        ],
      ],
      name => "VSOP87D",
      order => 6,
      sidereal_period => 929597044.234,
      tropical_period => 928535655.782,
    }->{$key};
}

1;

__END__

=head1 NAME

Astro::Coord::ECI::VSOP87D::Saturn - VSOP87D model of the position of Saturn

=head1 SYNOPSIS

 use Astro::Coord::ECI::VSOP87D::Saturn;
 use Astro::Coord::ECI::Utils qw{ deg2rad };
 use POSIX qw{ strftime };
 use Time::Local qw{ localtime };
 
 my $station = Astro::Coord::ECI->new(
     name => 'White House',
 )->geodetic(
     deg2rad( 38.899 ),  # radians
     deg2rad( -77.038 ), # radians
     16.68/1000,         # Kilometers
 );
 my $venus = Astro::Coord::ECI::VSOP87D::Saturn->new(
     station => $station,
 );
 my $today = timelocal( 0, 0, 0, ( localtime )[ 3 .. 5 ] );
 foreach my $item ( $venus->almanac( $today, $today + 86400 ) ) {
     local $\ = "\n";
     print strftime( '%d-%b-%Y %H:%M:%S', localtime $item->[0] ),
         $item->[3];
 }

=head1 DESCRIPTION

This Perl class computes the position of Saturn using the VSOP87D
model. It is a subclass of
L<Astro::Coord::ECI::VSOP87D::_Superior|Astro::Coord::ECI::VSOP87D::_Superior>.

=head1 METHODS

This class supports no additional public methods.

=head2 ATTRIBUTES

This class has no additional attributes.

=head1 SEE ALSO

L<Astro::Coord::ECI|Astro::Coord::ECI>

L<Astro::Coord::ECI::VSOP87D|Astro::Coord::ECI::VSOP87D>

=head1 SUPPORT

Support is by the author. Please file bug reports at
L<https://rt.cpan.org/Public/Dist/Display.html?Name=Astro-Coord-ECI-VSOP87D>,
L<https://github.com/trwyant/perl-Astro-Coord-ECI-VSOP87D/issues>, or in
electronic mail to the author.

=head1 AUTHOR

Thomas R. Wyant, III F<wyant at cpan dot org>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2018-2021 by Thomas R. Wyant, III

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl 5.10.0. For more details, see the full text
of the licenses in the directory LICENSES.

This program is distributed in the hope that it will be useful, but
without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.

=cut

# ex: set filetype=perl textwidth=72 :
