#!perl -T
use warnings; use strict;
use Test::More tests => 13;
use Test::Exception;

use lib '.';
use t::Elive::StandardV2;

use Elive::StandardV2;
use Elive::StandardV2::Connection;
use Elive::StandardV2::Session;

my $class = 'Elive::StandardV2::Session' ;

SKIP: {

    my %result = t::Elive::StandardV2->test_connection();
    my $auth = $result{auth};

    skip ($result{reason} || 'skipping live tests', 13)
	unless $auth;

    my $connection_class = $result{class};
    my $connection = $connection_class->connect(@$auth);
    Elive::StandardV2->connection($connection);

    my $session_start = Elive::Util::next_quarter_hour();
    my $session_end = Elive::Util::next_quarter_hour( $session_start );

    my %session_schedule = (
	startTime => $session_start .'000',
	endTime => $session_end . '000',
	recurrenceCount => 3,
	recurrenceDays => 7,
    );

    my %session_opts = (
	sessionName => 'test session, generated by t/soap-session-recurring.t',
	creatorId => $connection->user,
	);

    my @sessions;
    lives_ok (sub {@sessions = $class->insert({%session_schedule, %session_opts})}, 'creation of recurring sessions - lives');

    ok(@sessions == 3, 'got three session occurences')
	or die "session is not recurring - aborting test";

    my $n;
    foreach (@sessions) {
	isa_ok($_, $class, "** session occurence ".++$n." **");
	foreach my $prop (grep {!/^password$/} sort keys %session_opts) {
	    is($_->$prop, $session_opts{$prop}, "session $n, $prop as expected");
	}
    }

    my @start_times = map {substr($_->startTime, 0, -3)} @sessions;

    #
    # very approximate test on the dates being about a week apart. Allow
    # times to be out by over 1.5 hours due to daylight savings etc. 

    ok(t::Elive::StandardV2::a_week_between($start_times[0], $start_times[1]),
		       "sessions 1 & 2 separated by one week (approx)");

    ok(t::Elive::StandardV2::a_week_between($start_times[1], $start_times[2]),
       "sessions 2 & 3 separated by one week (approx)");

    foreach (@sessions) {
	$_->delete;
    }
}

Elive->disconnect;
