use Test::More tests => 3;

use Art::World;
use Config::Tiny;
use DDP;

my $f = Faker->new;

sub _new_person {
  return $f->person_first_name . ' ' . $f->person_last_name;
}

my $artist_01 = Art::World->new_artist(
  config => Config::Tiny->read( './t/test.conf' ),
  name => _new_person(), id => 55, reputation => 666,
);

# Here, we will empty the database
$artist_01->dbh->delete( 'agent', {} );

$artist_01->does( 'Art::World::Crud' );
my $insert = $artist_01->insert( 'agent', {  name => $artist_01->name,  reputation => $artist_01->reputation });

p $insert;

ok $insert,  'Inserted in DB';

my $artist_02 = Art::World->new_artist(
  config => Config::Tiny->read( './t/test.conf' ),
  name => _new_person(), id => 56, reputation => 555,
);

my $insert_02 = $artist_02->insert( 'agent', {  name => $artist_02->name,  reputation => $artist_02->reputation });

my @rows = $artist_02->dbh->search( 'Agent', {}, {});
p @rows;

is scalar @rows, 2, 'We retrieved two artists';

$artist_01->dbh->delete( 'agent', {} );

# # As far as I know, the module shouldn't be installed in a "Art-World"
# # directory on Gitlab-CI
# plan :skip-all<These tests must be executed with a running MongoDB>
#               unless $*CWD ~~ m/ \/Art\-World /;

# my $mongo = Art::ODM.new(
#     client-uri => 'mongodb://127.0.0.1:27017',
#     database-name => 'art-worlds'
# );

# does-ok $mongo, Art::Behavior::Connectable;
# isa-ok $mongo.database, 'MongoDB::Database';

# my MongoDB::Collection $artist-coll = $mongo.database.collection('artists');

# my MongoDB::Cursor $cursor = $artist-coll.find;

# my @artists;

# while $cursor.fetch -> BSON::Document $artist-doc {
#     my $artist = Art::Agent::Artist.new(
#         name => $artist-doc<name>,
#         database => $mongo.database
#     );
#     @artists.push($artist);
# }

# ok @artists[1].name eq "Seb Hu-Rillettes",
# @artists[0].name ~ ' has been found in the database';
# ok @artists[0].name eq "Amelia Butterfly",
# @artists[1].name ~ ' has been found in the database';

# for @artists -> $artist {
#     does-ok $artist, Art::Behavior::Crudable;
#     isa-ok $artist.database, "MongoDB::Database";
#     ok $artist.type-for-document eq 'artist', "split get-type() test";
#     $plan += 3;
# }

# my $artist = Art::Agent::Artist.new(
#     name => "Alice Wonder",
#     database => $mongo.database
# );

# ok $artist.save($artist.name), 'DB save was a success';
# ok $artist.save(@artists[1].name), 'DB save was a success';
# ok $artist.save(@artists[2].name), 'DB save was a success';

# say $artist.^attributes;


# does-ok $agent, Art::Behavior::Crudable;

SKIP: {
  skip 'Not implemented CRUD', 1;

  # does-ok $agent, Art::Behavior::CRUD;

  # for Art::Agent.^attributes {
  #     if $_ ~~ Art::Behavior::CRUD {
  #         ok $_ ~~ Art::Behavior::CRUD,
  #         'Attribute does CRUD through is crud trait';
  #     }
  # }

  # $agent = Art::Agent.new(
  #     id => 123456789,
  #     name => "Camelia Butterfly",
  #     reputation => 10
  # );

  # my @attributes = Art::Agent.^attributes;

  # ok @attributes[1] ~~ Art::Behavior::CRUD, 'attribute does CRUD through is crud trait';
  # ok $agent.name eq "Camelia Butterfly", 'Agent name contain the right value';

  # my @found;

  # for @attributes -> $attr {
  #     if $attr ~~ Art::Behavior::CRUD {
  #         @found.push($attr);
  #     }
  # }

  # ok @found.Int == 3,
  # 'The found number of attributes in the class is correct';

  # ok $agent.introspect-crud-attributes == @found,
  # '.introspect-crud-attributes returns the right number of elements';

  # ddt $agent.introspect-crud-attributes;
  ok 1;
}

done_testing;
