use v5.16;
use Test::More;
use Art;
use Data::Printer;
use Faker;

my $f = Faker->new;

use_ok 'Art';

my $gallerist = $f->person_name;

my $gallery = Art->new_gallery(
    space => 1000,
    exhibitions => [ 1, 2 ],
    owner => $gallerist,
    money => 10_000_000 );

ok $gallery->does('Art::Exhibit'), 'Gallery does role Exhibit';
ok $gallery->exhibitions, 'Gallery got an exhibitions attribute';
ok $gallery->owner, 'Gallery got an owner';

#ok $gallery->does('Art::Collectionable');
can_ok $gallery, 'acquire';
can_ok $gallery, 'serve';
can_ok $gallery, 'sale';


done_testing();
