[![MetaCPAN Release](https://badge.fury.io/pl/Art-World.svg)](https://metacpan.org/release/Art-World) [![Gitlab pipeline](https://gitlab.com/smonff/art-world/badges/master/pipeline.svg)](https://gitlab.com/smonff/art-world/-/commits/master) [![Gitlab coverage](https://gitlab.com/smonff/art-world/badges/master/coverage.svg)](https://gitlab.com/smonff/art-world/-/commits/master)
# NAME

Art::World - Agents interactions modeling  🎨

# SYNOPSIS

    use Art::World;

# OBJECTIVES

Art::World is an attempt to model and simulate a system describing the interactions and influences between the various _agents_ of the art world.

If a correct API is reached, we'll try to build a "game of art" frontend.

# DESCRIPTION

<div>
    <p>
      <img alt="Some illustrations sticked on a wall" src="https://gitlab.com/smonff/art-world/-/raw/master/spec/schema_v2.png"
        width="600px">
    </p>
</div>

- 01 Idea is the first step of process
- 02 Idea is inserted in the file (through process)
- 03 Idea comes from discourse (given about project)
- 04 Idea come when there is no time left
- 05 Ideas constitue the project

- 06 Process allows ideas to evolve
- 07 Process allows to fill the file (with ideas + discourse)
- 08 Process allows to generate some discourse
- 09 Process allows to save time
- 10 Process allows to set up the project

- 11 File is made of ideas
- 12 File is filled and emptied with the process
- 13 File is made of discourse
- 14 File archive ideas, that makes possible to forget them
- 15 File generate a project

- 16 Discourse steers ideas
- 17 Discourse analyze process
- 18 Discourse talks about the file
- 19 Discourse allows to link various stages of the projet
- 20 Discourse is a constituent of the project

- 21 From time to time, ideas appears
- 22 Time needed to apply the process
- 23 Time is suspended into file, process is off there
- 24 Discourse's time (reading time)
- 25 Various times contained in project give it's shape

- 26 Project is updated by new ideas
- 27 Project is constantly updated by the process
- 28 Project is set up when file is updated
- 29 Project and discourse are inseparable
- 30 Project is what takes the longuest time to set up

# HISTORY

This is a long term continuation of an art project started circa 2006.

In 2005, I got a metal box and colored carton cards and called this _Le
Fichier_. It was basically a database of artworks ideas. I was trashing all
ideas I could have of serious or weird potential artworks. It was inspired
either by Roland Barthes, who was actually working with those kind of cards,
Georges Perec, who was exploring _potentialities_, and Édouard Levé _Oeuvres_,
a huge catalog of potential artworks (he later commited suicide after describing
his own _Suicide_ in a book).

2006 I initiated a FileMaker database of artworks to put the old style carton
cards in computer form. I had no idea what I was doing at this time, being an
art school student, at this time, programming was not massively teached at art
school (unfortunately).

In 2008 I benefited of an artist residency in an agricultural college with a
creation grant of 10 000€. I urged to keep go on my _Art World and Creative
Processes schemas_ projects initiated during art school. It didn't went very well
because the then local state Plastic Art _Inspector_ didn't like what I was
doing with her money and strongly advised to change orientation. In my idea, it
was a perfect thing that the instutition itself would exhibit it's inherent
processes and operations. In the end, there were an exhibition, but she didn't
come to the opening.

Anyway, I ended up interviewing many _Agents_ of the college, and went
especially well with some natural sciences teacher. He recommended a manual were
I found some schemas that I made some _detournement_: I used the geology
science as a metaphor of art world. I used geology terms and language to
describe social interactions that are not described in the art sociology field.

<div>
    <p>
      <img alt="Pencil schema with mountains" src="https://gitlab.com/smonff/art-world/-/raw/master/spec/schema_v4.png"
        width="600px">
    </p>
</div>

The residency ended up with [the redaction of a rather precise documentation](https://files.balik.network/art/schema_v4_presentation.pdf) (maybe my first specification).  

Then I almost got hit by a fellow artist who was participating at a collective
exhibition mostly for the money and not for the fun. I guess he got a bit provocated by my situationist theory.

In 2008, I finally decided to start a training to learn programming and being
able to design a proper database and system for _managing a virtual Art
World_. I became a web developer, but I totally forgot the main aim.

Sometimes I thought about it:

- 2013 Perl try

    I bootstraped a Perl module with 5 abstract empty classes and then let it sleep on Github

- 2017 Raku try

    I restarted my project while getting into Raku
    (it was still Perl6 at this time), but learning Raku was too much effort and I
    abandonned again.

    Ten years later I am still on it. This project is [following me in my
    dreams](https://smonff.gitlab.io/art-school-story/). I'll give it another try.

# AUTHOR

Sébastien Feugère <sebastien@feugere.net>
Seb. Hu-Rillettes <shr@balik.network>

# COPYRIGHT AND LICENSE

Copyright 2006-2020 Seb. Hu-Rillettes

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.
