package Business::ID::BCA;

use 5.010001;
use strict;
use warnings;

use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $VERSION = '0.01'; # VERSION

our %SPEC;

our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(parse_bca_account);

#BEGIN SNIPPET id=data
# note: This section is generated by a script. Do not edit manually!
# src-file: /mnt/home/s1/repos/gudangdata/table/bca_branch/data.csv
# src-revision: 9224eb536d870734a1760dacf2d6c23b406bfd4d
# revision-date: Thu Apr 25 09:00:40 2013 +0700
# generate-date: Thu Apr 25 09:45:35 2013
# generated-by: /mnt/home/s1/repos/gudangdata/bin/gen-perl-data-snippet
our $data = [
    ['001','KCU KANTOR PUSAT OPS. Jln. Asemka 27-30 Jakarta 021-6901771 (hunting)','','','2013-04-25',''],
    ['002','KCU PASAR BARU Jln. KH Samanhudi 8 Jakarta 021-2310411 (hunting)','','','2013-04-25',''],
    ['003','KCU GUNSA 45 Jln. Gunung Sahari 45 Jakarta 021-6012123 (hunting), 6012129-30','','','2013-04-25',''],
    ['004','KCP Regional Tanah Abang Pasar Regional Tanah Abang Blok F, Lt. Dasar Jakarta 021-2303070, 338138','','','2013-04-25',''],
    ['005','KCU WISMA MILLENIA Jalan M.T. Haryono Kav. 16 Jakarta 0','','','2013-04-25',''],
    ['006','KCU WISMA GKBI Jln. Jend. Sudirman 28, Suite G 01 Jakarta 021-5722810 (hunting)','','','2013-04-25',''],
    ['007','KCU TANJUNG PRIOK Jln. Enggano 22-23 Jakarta 021-4301312 (hunting)','','','2013-04-25',''],
    ['008','KCU BANDUNG Jln. Asia Afrika 122-124 Bandung 022-4236303 (hunting)','','','2013-04-25',''],
    ['009','KCU SEMARANG Jln. Pemuda 90-92 Semarang 024-3510575(hunting) 3548003(hunti','','','2013-04-25',''],
    ['010','KCU VETERAN Jln. Veteran 18-24 Surabaya 031-3531136 (hunting)','','','2013-04-25',''],
    ['012','KCU GAJAH MADA Jln. Gajah Mada 112 B-C-D Jakarta 021-6302111 (hunting)','','','2013-04-25',''],
    ['013','KCU SALATIGA Jln. Diponegoro 15 Salatiga 0298-326060-61','','','2013-04-25',''],
    ['014','KCP Tunjungan Jln. Tunjungan 51 Atas Surabaya 031-5322901-03, 5319443, 5478901,','','','2013-04-25',''],
    ['015','KCU SOLO Jln. Brigjen Slamet Riyadi 3 Solo 0271-642225 (hunting)','','','2013-04-25',''],
    ['016','KCP Pasir Kaliki Jln. Pasir Kaliki No.66 Bandung 0','','','2013-04-25',''],
    ['017','KCP Kanjengan Jln. Kanjengan Blok A 24-25 Semarang 024-3548535, 3544564','','','2013-04-25',''],
    ['020','KCU BANDAR LAMPUNG Jln. Yos Sudarso 100 Bandar Lampung 0721-486205 (hunting)','','','2013-04-25',''],
    ['021','KCU PALEMBANG Jln. Kapten Rivai 22 Palembang 0711-312244 (hunting)','','','2013-04-25',''],
    ['022','KCU MEDAN Jln. Diponegoro 15 Medan 061-4155800 (hunting), 414880','','','2013-04-25',''],
    ['023','KCP Tanjung Karang Jln. Raden Intan No. 38 Bandar Lampung 0721-262379, 253749','','','2013-04-25',''],
    ['026','KCU MANADO Jln. Sam Ratulangi 17-19 Manado 0431-868438-43','','','2013-04-25',''],
    ['027','KCU SAMARINDA Jln. Jend. Sudirman 30 Samarinda 0541-738900 (hunting','','','2013-04-25',''],
    ['028','KCU WAHID HASYIM Jln. KH. Wahid Hasyim No. 183 A-B Jakarta 021-3150556, 324456 (hunting)','','','2013-04-25',''],
    ['029','KCU PONTIANAK Jln. A. Yani No. 1 Pontianak 0561-736305 (hunting)','','','2013-04-25',''],
    ['031','KCU KUDUS Jln. A Yani 91 Kudus 0291-432741-432744 (hunting','','','2013-04-25',''],
    ['032','KCU PADANG Jln. H. Agus Salim 10 A Padang 0751-32110-14','','','2013-04-25',''],
    ['034','KCU PEKANBARU Jln. Jend. Sudirman 448 Pekanbaru 0','','','2013-04-25',''],
    ['035','KCU SUDIRMAN Gedung Chase Plaza, Jln. Jend. Sudirman Kav. 21 Jakarta 021-25989898','','','2013-04-25',''],
    ['036','KCP Slompretan Jln. Slompretan 43 Surabaya 031-3534241, 3550728','','','2013-04-25',''],
    ['037','KCU YOGYAKARTA Jln. Jend. Sudirman 49-51 Yogyakarta 0274-517281 (hunting)','','','2013-04-25',''],
    ['040','KCU DENPASAR Jln. Hasanudin 58 Denpasar 0361-420186,421431,431012-14,434089','','','2013-04-25',''],
    ['041','KCU PANGKAL PINANG Jln. Masjid Jamik 15 Pangkal Pinang 0717-432122, 432139, 432144, 432160','','','2013-04-25',''],
    ['042','KCU TEBING TINGGI Jln. Jend.Sudirman 225-227-229 Tebing Tinggi 0621-21242 (hunting)','','','2013-04-25',''],
    ['043','KCU BANDA ACEH Jln. Panglima Polim 40 Banda Aceh 0','','','2013-04-25',''],
    ['044','KCU AMBON Jln. Sultan Hairun 24 Ambon 0911-352425-28','','','2013-04-25',''],
    ['045','KCP Mesjid Lama Jln. Mesjid Lama 27-31 Palembang 0711-360300 (hunting),357789','','','2013-04-25',''],
    ['046','KCU PURWOKERTO Jln. Jend. Sudirman 391 A Purwokerto 0281-632111 (hunting)','','','2013-04-25',''],
    ['047','KCU TEGAL Jln. AR. Hakim 2 Tegal 0283-356889 (hunting)','','','2013-04-25',''],
    ['049','KCP Maluku Jln. Maluku 10 Denpasar 0361-263441-42','','','2013-04-25',''],
    ['051','KCU BANJARMASIN Jln. Lambung Mangkurat 11-13 Banjarmasin 0511-3350711-15,4366989','','','2013-04-25',''],
    ['052','KCU TANJUNG BALAI Jln. Sisingamangaraja 12-16 Tanjung Balai 0623-92828 (hunting)','','','2013-04-25',''],
    ['053','KCP Bitung Jln. Sam Ratulangi No. 86 Bitung 0432-','','','2013-04-25',''],
    ['054','KCU TASIKMALAYA Jln. HZ Mustofa 300 Tasikmalaya 0265-332005 (hunting)','','','2013-04-25',''],
    ['055','KCU SUBANG Jln. Otto Iskandardinata 37 Subang 0260-411602, 411604, 411605','','','2013-04-25',''],
    ['056','KCU CAKRANEGARA Jln. Pejanggik 67 Mataram 0370-632588 (hunting)','','','2013-04-25',''],
    ['057','KCU LUBUK LINGGAU Jln. Yos Sudarso 294-296 Lubuk Linggau 0733-322072, 321322, 321419, 322271','','','2013-04-25',''],
    ['058','KCU BENGKULU Jln. S. Parman No. 66 Bengkulu 0736-21704, 20819, 22987','','','2013-04-25',''],
    ['059','KCP A. Yani Jln. A. Yani 41 C Pekanbaru 0761-32376, 32525','','','2013-04-25',''],
    ['060','KCP Pingit Jln. Magelang 188 (d/h No. 170) Yogyakarta 0','','','2013-04-25',''],
    ['061','KCU BATAM Jln. Raja Ali Haji 18, Sei Jodoh Batam 0778-421222 (hunting)','','','2013-04-25',''],
    ['063','KCP Suniaraja Jln. Suniaraja Timur 49 Bandung 0','','','2013-04-25',''],
    ['064','KCP Pucang Anom Jln. Pucang Anom Timur 18 Surabaya 031-5023571-72, 5023574, 5025684,','','','2013-04-25',''],
    ['065','KCU KELAPA GADING Jln. Kelapa Gading Boulevard Raya Blok L No.1 Jakarta 021-45850123 (hunting), 45850101 (','','','2013-04-25',''],
    ['066','KCU BEKASI Jln. Ir. H. Juanda 54 Bekasi 021-8802266, 8802377, 8803034','','','2013-04-25',''],
    ['067','KCP Ciputat Jln. Ir H. Juanda 5 Ciputat 021-7431003, 7444023, 7444025','','','2013-04-25',''],
    ['068','KCP Pasar Kenari Jln. Kenari II/8 Jakarta 021-3900543-44, 3900763','','','2013-04-25',''],
    ['069','KCU MUARA KARANG Jln. Muara Karang Timur Blok B VIII No.116-117 Jakarta 021-6603032 (hunting), 6679790 (hu','','','2013-04-25',''],
    ['070','KCP Melawai Jln. Melawai Raya 165 Blok C 1-3 Jakarta 021-7203033, 7254201','','','2013-04-25',''],
    ['071','KCP Fatmawati Jln. RS Fatmawati 1 Jakarta 021-7500199, 7503675','','','2013-04-25',''],
    ['072','KCP Tunjungan Center Komp. Pert. Tunjungan Center, Jln. Tunjungan 3 Surabaya 031-5314482-83, 5314494-95','','','2013-04-25',''],
    ['073','KCP Tomang Tol Jln. Arjuna Kav. 8 A/1 Jakarta 021-5666694, 5685976-77','','','2013-04-25',''],
    ['074','KCP Jembatan Dua Jln. Jembatan Dua 82 BB-BC Jakarta 021-6604438-40','','','2013-04-25',''],
    ['075','KCP Sabang Jln. H. Agus Salim 57 B Jakarta 021-31922488','','','2013-04-25',''],
    ['076','KCP Tanjung Duren Jln. Tanjung Duren 3 Jakarta 021-5668683-87, 5668690-92','','','2013-04-25',''],
    ['078','KCP Pasar Klewer Kios Pasar Klewer Bok H 2-4 Solo 0271-655778, 655779, 647301','','','2013-04-25',''],
    ['079','KCP Pasar Legi Kios Pasar Legi 167-171 Solo 0271-648505, 641466, 651875','','','2013-04-25',''],
    ['080','KCP Weleri Jln. Terminal Colt 4, Weleri Kendal 0294-641343, 641336','','','2013-04-25',''],
    ['082','KCP Glodok Plaza Pertokoan Glodok Plaza Blok E/7-8, Jln. Pinangsia Raya 1 Jakarta 021-2601123-26, 2601139-41','','','2013-04-25',''],
    ['083','KCP Jayakarta Jln. P. Jayakarta 26 Blok A/2-3 Jakarta 021-6499960 (hunting)','','','2013-04-25',''],
    ['084','KCU WISMA ASIA Wisma Asia, Jln. S. Parman Kav. 79 Jakarta 021-5638888 (hunting)','','','2013-04-25',''],
    ['085','KCP Sudirman Jln. Sudirman 239-241 Bandung 0','','','2013-04-25',''],
    ['086','KCP Riau Jln. Laks.R.E Martadinata 92 Bandung 0','','','2013-04-25',''],
    ['087','KCP Sungkono Komp. Darmo Park I No.4-6, Jln. Mayjen Sungkono Surabaya 031-5671483, 5681654, 5683202, 568','','','2013-04-25',''],
    ['088','KCU DARMO Jln. Raya Darmo 5 Surabaya 031-5671003-08 (hunting)','','','2013-04-25',''],
    ['091','KCP Senen Pusat Perdagangan Senen Blok I, lt. IV No.14 & 15 Jakarta 021-4210758 (hunting)','','','2013-04-25',''],
    ['092','KCP Tebet Gedung Gajah Tebet Unit N & O, Jln. Dr. Sahardjo Raya 111 Jakarta 021-83792161-64','','','2013-04-25',''],
    ['093','KCP Sunter Jln. Agung Utara Raya Blok A 360 D No.50-51, Sunter Agung Jakarta 021-64716327, 6518755','','','2013-04-25',''],
    ['094','KCU RAWAMANGUN Jln. Paus 81 Jakarta 021-4750073, 4750075, 4894602','','','2013-04-25',''],
    ['095','KCU BOGOR Jln. Ir Juanda 28 Bogor 0251-314411 (hunting)','','','2013-04-25',''],
    ['096','KCU CILACAP Jln. A. Yani 118 Cilacap 0282-535120-21, 531281','','','2013-04-25',''],
    ['099','KCP Banjaran-Adiwerna Jln. Raya Utara 304, 306 Tegal 0283-443430, 443730','','','2013-04-25',''],
    ['100','KCP Pasar Turi Komp.Sinar Galaxy, Jln. Pasar Turi 42 Surabaya 031-3530822, 3530829','','','2013-04-25',''],
    ['101','KCP Kapas Krampung Jln. Kapas Krampung 126-126A-B Surabaya 031-5032213, 5030661 (hunting), 50','','','2013-04-25',''],
    ['102','KCP Pasar Atum Pasar Atum Mall, Lantai 2 Stand No. BA-1 s/d BA-7, Jln. Stasiun Kota No. 7A Surabaya 031-3530927','','','2013-04-25',''],
    ['103','KCP Kedungdoro Jln. Kedungdoro 118 Surabaya 031-5321787, 5345161, 5345518, 531','','','2013-04-25',''],
    ['105','KCP Jembatan Lima Jln. KH. Moch. Mansyur 15 F Jakarta 021-6323430 (hunting)','','','2013-04-25',''],
    ['106','KCP Pintu Air Jln. Pintu Air 36 Q Jakarta 021-3456366 (hunting)','','','2013-04-25',''],
    ['107','KCP Mangga Dua Surabaya Jln. Jagir Wonokromo 100, Pertokoan Mangga Dua Blok B-6 No.1 Surabaya 031-8474880, 8417077, 8491093-94','','','2013-04-25',''],
    ['108','KCU TANGERANG Jln. Kisamaun No. 57 Tangerang 021-5521125','','','2013-04-25',''],
    ['109','KCP Karawang Jln. Panatayuda 1 No. 37 Karawang 0264-403674, 403774, 403974','','','2013-04-25',''],
    ['111','KCP Penjernihan Jln. Penjernihan I No.23 Jakarta 021-5719050 (hunting)','','','2013-04-25',''],
    ['114','KCP Dempo Jln. Lingkaran I Dempo Luar No. 312 H Palembang 0711-366484, 366507','','','2013-04-25',''],
    ['115','KCP Lemabang Jln. Yos Sudarso 128/4F Palembang 0711-710979, 713746','','','2013-04-25',''],
    ['116','KCP Ruko Rajawali Jln. Veteran No. 938 Palembang 0711-351350','','','2013-04-25',''],
    ['117','KCP Metro Komp. Pertokoan Sumur Bandung Blok C 9-10 Metro Lampung 0725-47401, 47402','','','2013-04-25',''],
    ['118','KCP Sungai Liat Jln. Muhidin 1, Sungai Liat Bangka 0717-92291, 92381','','','2013-04-25',''],
    ['119','KCU JAMBI Jln. Dr. Sutomo 50-50A Jambi 0741-21116 (hunting)','','','2013-04-25',''],
    ['122','KCU MAGELANG Jln. A. Yani 1 Magelang 0293-367777 (hunting)','','','2013-04-25',''],
    ['126','KCP Mangkubumi Jln. P. Mangkubumi 5-7 Yogyakarta 0','','','2013-04-25',''],
    ['127','KCP Kepa Duri Jln. Mangga Raya 20 Jakarta 021-5663978 (hunting)','','','2013-04-25',''],
    ['128','KCP Pasar Minggu Jln. Raya Pasar Minggu 6 Jakarta 021-7974306 (hunting)','','','2013-04-25',''],
    ['130','KCP Manyar Pert.Manyar MI.Plz,Blok D14-15,Jl.Ngagel JayaSelatan Surabaya 031-5020618-19, 5012138','','','2013-04-25',''],
    ['134','KCU CIREBON Jln. Yos Sudarso 27 Cirebon 0231-232701, 234348-9','','','2013-04-25',''],
    ['135','KCP Ubud Jln. Raya Ubud 10 Gianyar 0361-975957-59','','','2013-04-25',''],
    ['137','KCP Lembang Jln. Pasar Baru 8 Bandung 022-2786171, 2786311','','','2013-04-25',''],
    ['138','KCP Ciamis Jln. A. Yani 33 Ciamis 0265-771428, 771633-34','','','2013-04-25',''],
    ['139','KCP Cimahi Jln. Cimahi 533 Bandung 0','','','2013-04-25',''],
    ['140','KCP Pare Jln. P.B Sudirman 2 ( Jln. Kediri ) Pare 0354-391750, 394288, 391520','','','2013-04-25',''],
    ['143','KCP Boyolali Jln. Kates No. 149 Boyolali 0273-321468, 322164','','','2013-04-25',''],
    ['144','KCP Juanda Jln. Ir Juanda 73-75 Pekanbaru 0761-32198, 32998','','','2013-04-25',''],
    ['145','KCP Gatot Subroto Graha BIP Lt.Dasar, Jln. Gatot Subroto Kav.23 Jakarta 021-2500171 (hunting)','','','2013-04-25',''],
    ['148','KCU GARUT Jln. Ciledug 162 Garut 0262-231304 (hunting)','','','2013-04-25',''],
    ['151','KCP Kenten Jln. MP. Magkunegara No. 016-017 Palembang 0711-316928, 360972','','','2013-04-25',''],
    ['152','KCP Kertajaya Jln. Kertajaya 35 Surabaya 031-5033637, 5037880-82','','','2013-04-25',''],
    ['153','KCP Singosaren Komp. Singosaren Plaza, Jln. Dr. Rajiman 169 Solo 0271-642331, 647531, 661690','','','2013-04-25',''],
    ['156','KCP Sunda Mall Jln. Sunda 50-54 Bandung 022-4208886, 4208890','','','2013-04-25',''],
    ['157','KCP Sumbersari Jln. Sumbersari T 12 No.23 Bandung 022-619935, 630568, 673136-38','','','2013-04-25',''],
    ['160','KCP Mangga Dua Pst.Perd.Grosir Psr Pagi Lt.2 Bl.KA No.001A-B,002&012,Jl.Arteri M.D. Jakarta 021-6599380','','','2013-04-25',''],
    ['161','KCP Mangga Besar Jln. Raya Mangga Besar 15 Jakarta 021-6008302-05, 6297582','','','2013-04-25',''],
    ['162','KCP Taman Ratu Komp.Taman Ratu Blok B 5/8 Jakarta 021-5651070, 5657375','','','2013-04-25',''],
    ['163','KCP Pemuda Jln. Pemuda No. 17 Padang 0751-34161, 33427','','','2013-04-25',''],
    ['164','KCP Kalimalang Jln. Inspeksi Kav. PTB Blok A 2 No. 2 C-D Jakarta 021-8642050 (hunting), 8642052-53,','','','2013-04-25',''],
    ['165','KCP Kramat Jati Jln. Raya Bogor Blok A muka No.17-19 Jakarta 021-8094485, 8093326','','','2013-04-25',''],
    ['166','KCP Cimanggis Jln. Raya Bogor Km. 29, Cimanggis Cibinong 021-8711571, 8711575','','','2013-04-25',''],
    ['167','KCP Graha Cibinong Ruko Graha Cibinong Blok D 6 dan D 7, Jln. Raya Cibinong No. 43 Cibinong 021-87914505, 87906162, 87914366','','','2013-04-25',''],
    ['168','KCU PLUIT Jln. Pluit Selatan 200 Jakarta 021-6601718 (hunting)','','','2013-04-25',''],
    ['169','KCP Ahmad Dahlan Jln. KH.A.Dahlan No. 27 Yogyakarta 0274-377115, 373393, 412143, 419928','','','2013-04-25',''],
    ['170','KCP Tomohon d/a Kolongan, Jln. Raya Tomohon 10 Manado 0431-','','','2013-04-25',''],
    ['171','KCP A. Yani Jln. Jend. A. Yani 1 A Pontianak 0561-','','','2013-04-25',''],
    ['174','KCP Kebon Kembang Jln. Dewi Sartika 36 Bogor 0251-321237, 314484, 328784','','','2013-04-25',''],
    ['175','KCP Binjai Jln. Jend. Sudirman No. 80-82 Binjai 061-8822071, 8821061, 8821807, 882','','','2013-04-25',''],
    ['176','KCP Kopo Jln. Kopo 26 A-B Bandung 022-6033127 (hunting)','','','2013-04-25',''],
    ['177','KCU MADIUN Jln. Jend. Sudirman 79-81 Madiun 0351-463443 (hunting','','','2013-04-25',''],
    ['178','KCP Permata Hijau Pertokoan Permata Hijau Blok D No. C27-28 dan B22 Jakarta 021-5308692, 5308694, 5308698','','','2013-04-25',''],
    ['179','KCP KHM Mansyur Jln. KHM Mansyur 246 A & B Jakarta 021-6254641 (hunting)','','','2013-04-25',''],
    ['182','KCU GANG TENGAH Jln Gang Tengah 88 Semarang 024-3516854, 3516856','','','2013-04-25',''],
    ['183','KCU CIANJUR Jln. Hos Cokroaminoto 56-58 Cianjur 0263-262182, 262158, 262067-69','','','2013-04-25',''],
    ['187','KCP Perak Jln. Perak Barat 267 Surabaya 031-3291529, 3293439, 329398384','','','2013-04-25',''],
    ['188','KCP Kusumabangsa Jln. Kusumabangsa 37 Surabaya 031-5320267, 5320265, 5344383, 534','','','2013-04-25',''],
    ['190','KCP Kertopaten Jln. Pegirian 114 Surabaya 031-3716084, 3721247, 3765950','','','2013-04-25',''],
    ['191','KCU BALIKPAPAN Jln. Jend. Sudirman 139 Balikpapan 0542-','','','2013-04-25',''],
    ['194','KCU PANGERAN JAYAKARTA Jln. Pangeran Jayakarta No.127 Jakarta 021-2601151, 2601152','','','2013-04-25',''],
    ['195','KCP Asia Jln. Asia 130 Medan 061-7365800 (hunting)','','','2013-04-25',''],
    ['197','KCP Cipanas Komp. Hotel Pendawa A 3-4, Jln. Raya Sidanglaya Cianjur 0263-513089, 513178','','','2013-04-25',''],
    ['198','KCU DAAN MOGOT Jln. Daan Mogot No. 95 Jakarta 021-5663824-28','','','2013-04-25',''],
    ['202','KCP Sweta-Lombar Jln. Sandubaya, Sweta Mataram 0370-','','','2013-04-25',''],
    ['204','KCP Bukit Cinere Indah Jln. Cinere Raya Blok NA - 18 C Depok 021-7532241','','','2013-04-25',''],
    ['205','KCU MENARA BCA Menara BCA, Grand Indonesia Lt. 28 Jln. MH Thamrin No. 1 Jakarta 021-23588000 (hunting)','','','2013-04-25',''],
    ['206','KCU THAMRIN Menara BCA, Grand Indonesia, Jln. MH Thamrin No. 1 Jakarta 021-23588000 (hunting)','','','2013-04-25',''],
    ['208','KCP Ciawi Jln. Raya Ciawi 151 Tasikmalaya 0265-455018-19','','','2013-04-25',''],
    ['209','KCP Pasar Wetan Jln. Pasar Wetan 91 Tasikmalaya 0265-330804, 332019, 335050','','','2013-04-25',''],
    ['210','KCP Monginsidi Jln. Wolter Monginsidi No. 129 Jakarta 021-2700188, 2700490-93','','','2013-04-25',''],
    ['211','KCP Ancol Jln. Parang Tritis Blok A VI No.3B-3C Jakarta 021-6902191, 6909190','','','2013-04-25',''],
    ['212','KCP Gunung Sahari Pert.Gunung Sahari Indah Blok B/11-12, Jl.Raya Gunung Sahari 13 Jakarta 021-6459965 (hunting)','','','2013-04-25',''],
    ['213','KCP Kapasan Jln. Kapasan 155 Surabaya 031-3762836, 3760175, 3760074-75','','','2013-04-25',''],
    ['214','KCP Tidar Jln. Tidar 109 Surabaya 031-5319351, 5459062-63','','','2013-04-25',''],
    ['215','KCP Undaan Jln. Undaan Wetan 46 F Surabaya 031-5456633-34','','','2013-04-25',''],
    ['216','KCP Pondok Chandra Komp. Pertokoan Pondok Chandra, Jln. Palem TC 09 Surabaya 031-8666842, 8666928','','','2013-04-25',''],
    ['217','KCU KUNINGAN Gedung Menara Karya Ground Floor, Jln. HR Rasuna Said Blok X-5 Kav. 1-2 Jakarta 021-57944500','','','2013-04-25',''],
    ['218','KCU BLOK A CIPETE Jln. RS Fatmawati 6 A Jakarta 021-7658605 (hunting)','','','2013-04-25',''],
    ['219','KCP Radio Dalam Jln. Radio Dalam Raya No. 5 B-C Jakarta 021-7245318 (hunting)','','','2013-04-25',''],
    ['220','KCP Nangka Jln Nangka 72 B Pekanbaru 0761-32842, 34338','','','2013-04-25',''],
    ['221','KCP Menara Imperium Jln. HR Rasuna Said Kav.01 Jakarta 021-8356383-87','','','2013-04-25',''],
    ['222','KCP Ungaran Ungaran Square Blok A3-A4, Jln. Gatot Subroto Ungaran 024-6923031, 6923041, 6921559','','','2013-04-25',''],
    ['223','KCP Pamanukan Jln. Ion Martasasmita No. 37 Subang 0260-551289, 551393','','','2013-04-25',''],
    ['224','KCP Batu Ceper Jln. Batu Ceper Raya 18 A-B Jakarta 021-3853383 (hunting)','','','2013-04-25',''],
    ['226','KCP Kembang Jepun Jln. Kebang Jepun 55 Surabaya 031-3523444-5, 3526430','','','2013-04-25',''],
    ['227','KCP Kelapa Gading Jln. Kelapa Gading Boulevard Blok FX No.9-10 Jakarta 021-4524913, 4532801-02','','','2013-04-25',''],
    ['228','KCP Mayestik Jln. Kiai Maja 77, Kebayoran Baru Jakarta 021-7205968 (hunting)','','','2013-04-25',''],
    ['229','KCP Palmerah Jln. Palmerah Barat 38 A Jakarta 021-5481108 (hunting)','','','2013-04-25',''],
    ['230','KCU KALIMALANG Jln. Tarum Barat Blok E No. 5 Jakarta 021-8643295 (hunting)','','','2013-04-25',''],
    ['231','KCU PURWAKARTA Jln. Jend. Sudirman 85 Purwakarta 0264-201311 (hunting)','','','2013-04-25',''],
    ['232','KCP Ampenan Jln. Yos Sudarso No. 26 & 28 Mataram 0370-636462','','','2013-04-25',''],
    ['233','KCP Setiabudi Jln. Setiabudi 146 Bandung 022-2034547, 2035065','','','2013-04-25',''],
    ['236','KCP Negara Jln. Ngurah Rai 83 Negara 0365-48283, 41480-81','','','2013-04-25',''],
    ['237','KCP Pondok Indah Jln. Metro Pondok Indah UA 60 & 61 Jakarta 021-7505601, 7507196, 7507253','','','2013-04-25',''],
    ['238','KCU PEKALONGAN Jln. Diponegoro 27 Pekalongan 0285-424783 (hunting),','','','2013-04-25',''],
    ['240','KCP Cengkeh Jln. Cengkeh 21-21A Jakarta 021-6905245-48','','','2013-04-25',''],
    ['241','KCP Jembatan Merah Jln. Mangga Besar 177 C Jakarta 021-6006745 (hunting), 6592500','','','2013-04-25',''],
    ['242','KCP Pulau Brayan Jln. Kol. Yos Sudarso 223 J Medan 061-6615800 (hunting)','','','2013-04-25',''],
    ['243','KCP ABC Jln. ABC 18 Bandung 022-4235850, 4241793, 4234919','','','2013-04-25',''],
    ['244','KCP Pluit Kencana Jln. Taman Pluit Kencana Selatan No. 1-3 Jakarta 021-6604691, 6690778','','','2013-04-25',''],
    ['246','KCP Siliwangi Jln. Jend. Sudirman 39 Semarang 024-7601435, 7605611','','','2013-04-25',''],
    ['247','KCP Jepara Jln. Pemuda 28-32 Jepara 0291-592392-592395 (hunting)','','','2013-04-25',''],
    ['248','KCP Pasar Kebayoran Lama Jln. Kebayoran Lama 174 Jakarta 021-2700436-38','','','2013-04-25',''],
    ['250','KCP Kedungwuni Komp.Ruko Kw.Permai, Jln.Raya Kedungwuni Blok A 6 Pekalongan 0285-85408-09, 85412, 85301','','','2013-04-25',''],
    ['251','KCP Wiradesa Komp. Ruko Wiradesa Indah, Jln. Raya Wiradesa 100F Pekalongan 0285-24527, 25375-76','','','2013-04-25',''],
    ['252','KCP MT Haryono Jln. MT Haryono 657 Semarang 0','','','2013-04-25',''],
    ['253','KCU GREEN GARDEN Perum. Green Garden Blok A.7 No.33-34 Jakarta 021-5824488, 5817342','','','2013-04-25',''],
    ['254','KCP Abul Hasan Jln. KH Abul Hasan 8-9 Samarinda 0541-202468 (hunting)','','','2013-04-25',''],
    ['255','KCP Menara Mulia Gedung Menara Mulia Lt.Dasar, Jln. Gatot Subroto Kav.9-11 Jakarta 021-5268472-75','','','2013-04-25',''],
    ['256','KCP Semut Jln. Bongkaran 17-19 Surabaya 031-3520610, 3530416-18-19, 354231','','','2013-04-25',''],
    ['257','KCP Baturaja Jln. Jend. Sudirman 15-16 Baturaja 0735-320233, 321013, 320790, 321601','','','2013-04-25',''],
    ['258','KCU DIPONEGORO Jln. Dr Sutomo 118 Surabaya 031-5671243 (hunting)','','','2013-04-25',''],
    ['260','KCP Grogol Permai Pert.Grogol Permai Blok F 3-4, Jln. Prof. Latumenten Jakarta 021-5668671, 5679988, 5668669','','','2013-04-25',''],
    ['261','KCU SURYOPRANOTO Jln. Suryopranoto 40 Jakarta 021-6331742 (hunting), 6304171','','','2013-04-25',''],
    ['262','KCP Hasyim Ashari Jln. KH H. Ashari 5 AA Jakarta 021-6327210, 6327212','','','2013-04-25',''],
    ['267','KCP Cinere Jln. Cinere Raya Blok A/18-19 Sawangan 021-7543388','','','2013-04-25',''],
    ['268','KCP Grogol Muwardi Jln. Muwardi 1/44 Jakarta 021-5665417-19','','','2013-04-25',''],
    ['270','KCP Roxi Mas Pertokoan Roxi Mas Blok C 5/6-8 Jakarta 021-6330687, 6330682','','','2013-04-25',''],
    ['272','KCP Gudang Peluru Komp. Gudang Peluru Blok A No. 23, Jln. Kampung Melayu Besar Jakarta 021-8312431, 8301212','','','2013-04-25',''],
    ['273','KCP Dewi Sartika Jln. Dewi Sartika 189 Jakarta 021-8093875, 8094425','','','2013-04-25',''],
    ['274','KCP Pondok Bambu Pondok Bambu Center Blok A/5-6, Jln. Pahlawan Revolusi 30 Jakarta 021-8611890-94','','','2013-04-25',''],
    ['275','KCP Pulogadung Jln. Raya Bekasi Km.19 No.30 B-C Jakarta 021-4758036, 4759537, 4753148','','','2013-04-25',''],
    ['276','KCP Cempaka Putih Jln. Letjen Suprapto No.30 EF Jakarta 021-','','','2013-04-25',''],
    ['277','KCU TAMAN DUTA MAS Jln. Tubagus Angke No. 10 ABC dan 11 H Jakarta 021-56941971 (hunting)','','','2013-04-25',''],
    ['278','KCP Padalarang Jln. Raya Padalarang Kav.10 Bandung 022-6809095 (hunting)','','','2013-04-25',''],
    ['279','KCP Dewi Sartika Jln. Dewi Sartika No. 58 Bandung 022-4233035','','','2013-04-25',''],
    ['280','KCP Kiaracondong Jln. Kiaracondong 190 Bandung 022-7306080, 7311793, 7311794','','','2013-04-25',''],
    ['281','KCP Rajawali Komp. Rajawali Plaza, Jln. Rajawali Timur 27B Bandung 022-6072852-53','','','2013-04-25',''],
    ['282','KCP Maranatha Jln. Prof. Drg.S. Soemantri 33 Bandung 022-2000351-52','','','2013-04-25',''],
    ['283','KCP Ujung Berung Jln. Ujung Berung 50 Bandung 022-7800619, 7806626','','','2013-04-25',''],
    ['284','KCP Sawah Besar Jln. Sukarjo Wiryopranoto 28 C Jakarta 021-2311388 (hunting)','','','2013-04-25',''],
    ['285','KCP Taman Sari Jln. Taman Sari 47-47A Jakarta 021-2600190 (hunting)','','','2013-04-25',''],
    ['286','KCP Kemang Jln. Raya Kemang No. 60 Jakarta 021-7193323, 7193327, 7193329','','','2013-04-25',''],
    ['287','KCP Kebon Jeruk Komp. Taman Kebon Jeruk, Jln. Meruya Ilir Blok B 6-7 Jakarta 021-5846187 (hunting)','','','2013-04-25',''],
    ['288','KCU PURI INDAH Komp. Puri Indah Blok A/20-22 Jakarta 021-5802635 (hunting)','','','2013-04-25',''],
    ['291','KCU ARTERI PONDOK INDAH Jln. Iskandar Muda 8 EFG Jakarta 021-72793389, 7225234','','','2013-04-25',''],
    ['292','KCP Pasar Tengah Jln. Kartini 20-21, Tanjung Karang Bandar Lampung 0721-251466, 263887','','','2013-04-25',''],
    ['293','KCP Bandar Jaya Jln. Proklamator No. 14 A-B, Bandar Jaya Metro Lampung 0725-25208, 528158','','','2013-04-25',''],
    ['294','KCP Pangeran Antasari Jln. Pangeran Antasari No. 130, Tanjung Baru, Sukabumi Bandar Lampung 0294-772477','','','2013-04-25',''],
    ['296','KCU LHOKSEUMAWE Jln. Merdeka 13-14 Lhokseumawe 0645-41305 (hunting)','','','2013-04-25',''],
    ['299','KCP Kuningan Cirebon Jln. Siliwangi 95 Kuningan 0232-875680-81, 871256','','','2013-04-25',''],
    ['300','KCU PRABUMULIH Jln. Jend. Sudirman 369-370 Prabumulih 0713-323888, 322551, 320788, 325139','','','2013-04-25',''],
    ['301','KCP Bendungan Hilir Jln. Bendungan Hilir 18-19 Jakarta 021-2510916-18, 5708509, 5706665','','','2013-04-25',''],
    ['302','KCP Jatibarang Jln. Mayor Dasuki 93, Jatibarang Indramayu 0234-351050, 351463','','','2013-04-25',''],
    ['303','KCP Indramayu Jln. D.I. Panjaitan No. 69 Indramayu 0234-272802, 275031-33','','','2013-04-25',''],
    ['304','KCP Sindang Laut Cirebon Jln. Cipeujeuh Wetan 26 Cirebon 0231-637820-22','','','2013-04-25',''],
    ['305','KCP Pasar Cikini Gedung Permata Hijau Lt.2 Jln. Pegangsaan Barat 7 A Jakarta 021-2300803-06','','','2013-04-25',''],
    ['307','KCP Mandala Hayam Wuruk Plaza Lt.Dasar Blok A/144, Jln. Hayam Wuruk Jakarta 021-2600404, 2600388-89, 2600413-1','','','2013-04-25',''],
    ['308','KCP Duta Merlin Komp. Duta Merlin Blok A No. 24-25, Jln. Gajah Mada 3-5 Jakarta 0','','','2013-04-25',''],
    ['309','KCP Kedoya Baru Ruko Tomang Tol Raya Blok A 1/21-22 Jakarta 021-5803228-31','','','2013-04-25',''],
    ['310','KCP Tomang Raya Jln. Tomang Raya 64 Jakarta 021-5669000 (hunting)','','','2013-04-25',''],
    ['311','KCP Latumenten Jln. Prof. Dr. Latumenten 28 Jakarta 021-6319274-75, 6310261','','','2013-04-25',''],
    ['312','KCP S. Parman Jln. S. Parman 184 Padang 0751-53085-88','','','2013-04-25',''],
    ['313','KCP Kapuk Kamal Jln. Raya Kapuk Kamal No. 1A Blok DEF Jakarta 021-6198279, 6198282','','','2013-04-25',''],
    ['314','KCU KUPANG Jln. Tompello 23 A Kupang 0380-832801 (hunting)','','','2013-04-25',''],
    ['319','KCU WISMA 46 Wisma 46, lt.dasar, Jln. Jend. Sudirman Kav. 1 Jakarta 021-5744546(h), 5744420-34-50-70,','','','2013-04-25',''],
    ['321','KCP Sutisna Senjaya Jln. Sutisna Senjaya 82 Tasikmalaya 0265-334962, 330908','','','2013-04-25',''],
    ['326','KCP Muka Kuning Wisma Batamindo # 01-03/04, Jln. Rasamala 1 Batam 0778-611452, 611557, 611447','','','2013-04-25',''],
    ['328','KCP Caruban Jln. Raya 173 Madiun 0351-383306, 384101','','','2013-04-25',''],
    ['329','KCP Baliwerti Jln. Baliwerti 119-121 Kav. 37-38 Surabaya 031-5319732, 5324502, 5324497 (hum','','','2013-04-25',''],
    ['335','KCU MANGGA DUA RAYA Jl.Mangga Dua Raya Blok C-5 Kav. No.1 Jakarta 021-6011410 (hunting)','','','2013-04-25',''],
    ['336','KCP Tanah Abang Zona 3 Gd. Jembatan Tanah Abang Blok A Zona 3, Jln. KH Wahid Hasyim Jakarta 021-23570283, 23570302, 23570384','','','2013-04-25',''],
    ['337','KCP Dayeuhkolot Jln. Raya Dayeuhkolot 463 B Bandung 022-5200859','','','2013-04-25',''],
    ['340','KCP Nagoya Komp. Sakura Anpan, Jln. Imam Bonjol Blok B 6-8 Batam 0778-457687 (hunting','','','2013-04-25',''],
    ['341','KCP Iskandar Jln. Letkol Iskandar No. 18, Komplek Palembang Indah Mall Palembang 0711-310035, 310150, 310177','','','2013-04-25',''],
    ['342','KCU MATRAMAN Jln. Matraman Raya 14-16 Jakarta 021-8581259 (hunting)','','','2013-04-25',''],
    ['343','KCP Cikarang Ruko Cikarang Plaza, Jln. Yos Sudarso Blok B No. 5-6 Bekasi 021-8900185, 8900867-68','','','2013-04-25',''],
    ['344','KCP Tidar Komp. Pert.Rejotumoto A 8-10, Jln. Tidar Magelang 0293-364383 (hunting)','','','2013-04-25',''],
    ['345','KCP Pondok Lestari Ruko Pdk Lestari Blok C/7-8, Jln. Ciledug Raya Tangerang 021-5847619, 5847620','','','2013-04-25',''],
    ['346','KCU SOEKARNO HATTA Jln. Soekarno Hatta 240 Bandung 022-5403343 (hunting)','','','2013-04-25',''],
    ['347','KCP Sultan Muhammad Jln. Sultan Muhammad 136 Pontianak 0561-738051','','','2013-04-25',''],
    ['348','KCP Dewi Sartika Jln. Dewi Sartika 15 Cianjur 0263-262001-04, 261001','','','2013-04-25',''],
    ['349','KCP Iskandar Muda Jln. Iskandar Muda 123 Medan 061-4144500 (hunting)','','','2013-04-25',''],
    ['350','KCP Hayam Wuruk Jln. Hayam Wuruk 54 Jakarta 021-6280124-25','','','2013-04-25',''],
    ['353','KCP Industri Jln. Industri II No. 14 Semarang 024-6581091','','','2013-04-25',''],
    ['358','KCP Pasar Wage Jln. DI Panjaitan, Ruko 12 Purwokerto 0281-631460, 632152, 632154','','','2013-04-25',''],
    ['360','KCP Pasar Pagi Tegal Jln. A. Yani No. 74 Tegal 0283-351007, 340303','','','2013-04-25',''],
    ['362','KCP Slawi Jln. Jend. Sudirman No. 46 Slawi 0283-492658','','','2013-04-25',''],
    ['363','KCP Tunjungan Plaza Komp. Pertokoan Tunjungan Plaza I LG-07B, Jln.Basuki Rachmat 8-12A Surabaya 031-5459627, 5459637','','','2013-04-25',''],
    ['364','KCP Rajawali Jln. Rajawali 53 G Surabaya 031-3542291, 3542348','','','2013-04-25',''],
    ['369','KCP Pasar Tanah Abang Jln. KH Fachrudin 36 Blok D/23 Jakarta 0','','','2013-04-25',''],
    ['370','KCP Karang Anyar Jln. Karang Anyar Blok A1 No.14-15 Jakarta 021-2600193, 2600196, 2600200','','','2013-04-25',''],
    ['371','KCP Sei Pinyuh Jln. Raya Terminal 05-06, Sei Pinyuh Pontianak 0561-','','','2013-04-25',''],
    ['372','KCU KEDOYA PERMAI Ruko Taman Kedoya Permai, Blok A 1A No.4-5 Jakarta 021-5310055 (hunting), 5344939 (hu','','','2013-04-25',''],
    ['373','KCP Roxy Square Gedung Roxy Square - Basement Blok A2, Jln. Kyai Tapa no.1 Jakarta 021-','','','2013-04-25',''],
    ['374','KCP Cipto Mangunkusumo Jln. Dr Cipto Mangunkusumo 4E Cirebon 0231-201218, 210937','','','2013-04-25',''],
    ['375','KCP Graha Inti Fauzi Gd. Graha Inti Fauzi Lt. Dasar, Jln. Buncit Raya No. 22, Pejaten Jakarta 0','','','2013-04-25',''],
    ['376','KCP Majalaya Jln. Raya Laswi 212 A Bandung 0','','','2013-04-25',''],
    ['378','KCP Cikampek Jln. A. Yani 53 Karawang 0264-313491, 313856','','','2013-04-25',''],
    ['379','KCP Taman Kopo Indah Kompleks Perumahan Taman Kopo Indah II, Blok I B No. 31-32 Bandung 022-5412694-95','','','2013-04-25',''],
    ['380','KCU TANJUNG PINANG Jln. Temiang 27-29, (Riau) Tanjung Pinang 0771-23571 (h), 23643 (h), 23612 (h','','','2013-04-25',''],
    ['381','KCP Tembaan Jln. Tembaan 17B Surabaya 031-5319267, 5324492, 5324495','','','2013-04-25',''],
    ['382','KCP Sultan Agung Jln. Sutan Agung No. 141 Pekalongan 0285-433582-84','','','2013-04-25',''],
    ['383','KCU BUKIT BARISAN Jln. Bukit Barisan 3 Medan 061-4515800 (hunting), 4557133','','','2013-04-25',''],
    ['384','KCP Delta Plaza Plaza Surabaya lt.1 No.6-7, Jln. Pemuda 33-37 Surabaya 031-5312808, 5313828 (hunting), 53','','','2013-04-25',''],
    ['386','KCP Pluit Timur Jln. Pluit Timur Blok L Barat Kav. 41-42 No.12A-14 Jakarta 0','','','2013-04-25',''],
    ['388','KCP Dharmahusada Jln. Dharmahusada No. 203 Surabaya 031-5947633, 5947676','','','2013-04-25',''],
    ['389','KCP Muliosari Jln. Muliosari 364 A Blok Z.56 Surabaya 031-5933388 ( Direct), 5937500 (hu','','','2013-04-25',''],
    ['391','KCP Bungur Jln. Bungur Besar Raya 32 & 32A Jakarta 021-4219627, 4248430, 4255606 (hun','','','2013-04-25',''],
    ['392','KCP Purwosari Jln. Slamet Riyadi 488 Solo 0271-712830, 714210','','','2013-04-25',''],
    ['393','KCP Kartasura Jn. Raya Kartasura Bok C 1-2 Solo 0271-780305, 780435','','','2013-04-25',''],
    ['394','KCP Urip Sumoharjo Jln. Urip Sumoharjo 133 Solo 0271-646552-3, 635500','','','2013-04-25',''],
    ['395','KCP Klungkung Jln. Diponegoro 40 Klungkung 0366-21966','','','2013-04-25',''],
    ['397','KCP Cideng Barat Jln. Cideng Barat 53 Jakarta 021-3842653','','','2013-04-25',''],
    ['398','KCP Mandala Raya Jln. Mandala Raya 14 Jakarta 021-5666756 (hunting)','','','2013-04-25',''],
    ['399','KCP Citra Garden Perum. Citra Garden I Blok I.1/4 Jakarta 021-5401239, 5401802','','','2013-04-25',''],
    ['401','KCP Ketapang Komp.Ketapang Indah Blok A/3-4, Jln. KH Zainal Arifin Jakarta 021-2600409 (hunting), 2600418','','','2013-04-25',''],
    ['402','KCP Mangunsarkoro Jln. Mangunsarkoro 24 Cianjur 0263-262930-31, 262933','','','2013-04-25',''],
    ['406','KCP Cileungsi Cileungsi Trade Center Blok C 10-11, Jln. Raya Narogong Km. 22,5, Cileungsi Bogor 021-8233001-03','','','2013-04-25',''],
    ['407','KCP Muara Karang 3 Jln. Galeri Niaga Mediterania Blok X.3 Kav.No.A8.J, Pantai Indah Kapuk Jakarta 021-5882943-44, 5882947','','','2013-04-25',''],
    ['408','KCP Kapuk Muara Komp.Duta Harapan Indah, Jln. Kapuk Muara Blok K.32-33 Jakarta 021-6606181-83','','','2013-04-25',''],
    ['409','KCP Suari Jln. Suari 18 Semarang 024-3556578, 3554773, 3554774','','','2013-04-25',''],
    ['410','KCP Ambengan Pert. Ambengan Plaza, Jln. Ngemplak 30 Blok A.15 Surabaya 031-5319723, 5317821','','','2013-04-25',''],
    ['412','KCP Klender Jln. I Gusti Ngurah Rai 8 A-B Jakarta 021-8614655-56','','','2013-04-25',''],
    ['413','KCP Kelapa Gading Villa Jln. Boulevard Barat Raya Blok LC No.51-52 Jakarta 021-4507890-91, 4507892-94','','','2013-04-25',''],
    ['414','KCP Kramat Jaya Jln. Kramat Jaya Blok F1/10 Jakarta 021-4400742 (hunting)','','','2013-04-25',''],
    ['415','KCP Mardika Jln. Pertokoan Mardika Blok A 1 No. 3-4 Ambon 0911-56315-16','','','2013-04-25',''],
    ['416','KCP Gianyar Jln. Airlangga No. 2 Gianyar 0361-','','','2013-04-25',''],
    ['419','KCP Sunter Danau Jln. Danau Agung 2 Blok E2 No. 1A, Sunter Podomoro Jakarta 021-6400090-92','','','2013-04-25',''],
    ['421','KCP Depok Jln. Margonda Raya No. 379 Depok 021-7870342-43, 7870345-46','','','2013-04-25',''],
    ['422','KCP Kroya Jln. A. Yani No. 09 Kroya Cilacap 0282-494090, 434191','','','2013-04-25',''],
    ['424','KCP Ajibarang Jln. Raya Pancasan No. 34, Ajibarang Purwokerto 0281-572425, 572426','','','2013-04-25',''],
    ['426','KCP Telogorejo Jln. KH Ahmad Dahlan No. 25 Semarang 024-8442555, 8442666, 8411907','','','2013-04-25',''],
    ['427','KCP Siliwangi Jl.Siliwangi 101 Bogor 0251-313737 (hunting)','','','2013-04-25',''],
    ['428','KCU SUNTER MALL Jln. Danau Sunter Utara Blok G 7 III No.1-2, Sunter Podomoro Jakarta 021-6400748, 6401851-52','','','2013-04-25',''],
    ['429','KCP A. Yani Jln. Jend. Achmad Yani 208 Surabaya 031-8292520 (hunting), 8291519','','','2013-04-25',''],
    ['430','KCP Teluk Betung Jln. Ikan Gurame 24-26 Bandar Lampung 0721-485489, 486747','','','2013-04-25',''],
    ['431','KCP Ciranjang Komp.Ciranjang Indah No.2, Jln. Raya Ciranjang Cianjur 0263-321792-93','','','2013-04-25',''],
    ['433','KCP Majenang Jln. Diponegoro 318, Majenang Cilacap 0280-621081, 621367','','','2013-04-25',''],
    ['434','KCP Lomanis Jln. Jend. Gatot Subroto No. 54 Gunungsimping Cilacap 0282-534380, 534199','','','2013-04-25',''],
    ['435','KCP Cokroaminoto Jln. Cokroaminoto No. 32 E Denpasar 0361-418131, 418132','','','2013-04-25',''],
    ['436','KCP Tebet Barat Jln. Tebet Barat IX/40 Jakarta 021-8301037, 8304297','','','2013-04-25',''],
    ['437','KCU A. YANI Jln. A. Yani 656-658 Bandung 022-7206706 (hunting)','','','2013-04-25',''],
    ['438','KCP Burangrang Jln. Burangrang 44 Bandung 0','','','2013-04-25',''],
    ['441','KCP Plaza Sentral Jln. Jend. Sudirman Kav.47 Jakarta 021-5207990, 2511344, 2511347','','','2013-04-25',''],
    ['445','KCP Katamso Jln. Brigjen Katamso 141 Yogyakarta 0274-371454 (hunting)','','','2013-04-25',''],
    ['446','KCP A. Yani Jln. Ahmad Yani 165 Garut 0','','','2013-04-25',''],
    ['449','KCP Banda Jln. Banda 39 Bandung 022-4201664, 432645','','','2013-04-25',''],
    ['450','KCU MENARA BIDAKARA Menara Bidakara Lt. Lobby dan Lt.1, Jln. Gatot Subroto Kav.71-73 Jakarta 021-83700809 (hunting)','','','2013-04-25',''],
    ['453','KCP Lingkar Selatan Komp. Ruko Kopo Plaza B.03-04, Jln. Peta 33 Bandung 022-6036457-58','','','2013-04-25',''],
    ['454','KCP Jembatan Merah Plaza Komp.Jemb.Mrh Plz lt.Dasar Blok B/6-8,Jl.Jayengrono 1 Surabaya 031-3556021-25','','','2013-04-25',''],
    ['455','KCP Gondongdia Lama Jln. R.P. Soeroso No. 25 Jakarta 021-39135180','','','2013-04-25',''],
    ['456','KCP Urip Sumoharjo Jln. Urip Sumoharjo 65 Yogyakarta 0','','','2013-04-25',''],
    ['458','KCP Bursa Efek Jakarta Gd. Bursa Efek Jakarta, Tower II G-09 & 108, Jln. Jend. Sudirman Kav. 52-53 Jakarta 021-5153020-21, 5153023-25','','','2013-04-25',''],
    ['459','KCP Wisma Indocement Wisma Indocement, Gd.Annex Lt. Dasar, Jl. Jend. Sudirman Kav. 1 Jakarta 021-2510101','','','2013-04-25',''],
    ['460','KCP Kota Bukit Indah Kawasan Kota Bukit Indah Kav.A II/29 No.RK 5 Purwakarta 0264-351411, 351568','','','2013-04-25',''],
    ['462','KCP Majapahit Jln. Majapahit 112 Semarang 024-6722048, 6722049','','','2013-04-25',''],
    ['463','KCP Margomulyo Jln. Margomulyo No. 9 Blok AA 11-12 Surabaya 031-7494218, 7494214','','','2013-04-25',''],
    ['464','KCP Kertajaya Indah Jln. Manyar Kertoardjo 95 Surabaya 031-5924592-93, 5930739, 5941116','','','2013-04-25',''],
    ['466','KCP Mal Ciputra Mal Ciputra LG II No. 24-28, Jln. Arteri S. Parman, Slipi Jakarta 021-5606531, 5607585, 5661048','','','2013-04-25',''],
    ['467','KCP Mal Taman Anggrek Lower Ground Lot. C 07, Jln. S. Parman Kav. 21, Slipi Jakarta 021-5639174, 5639176, 5639178','','','2013-04-25',''],
    ['468','KCU INDRAPURA Jln. Indrapura 35 Surabaya 031-3572888 (hunting)','','','2013-04-25',''],
    ['469','KCP Kenjeran Jln. Kenjeran 66 Surabaya 031-3720364 (hunting)','','','2013-04-25',''],
    ['470','KCP Darmo Indah Timur Jln. Darmo Indah Timur Blok SS No. 22 Surabaya 0','','','2013-04-25',''],
    ['472','KCP Mega Galaxy Jln. Pertokoan Galaxy Blok 14 A No. 3 A Surabaya 031-5990097, 5939530, 5939544, 593','','','2013-04-25',''],
    ['473','KCP Pamulang Jln. Raya Pamulang Blok SH 21 No.17-18 Tangerang 021-7432427-28','','','2013-04-25',''],
    ['474','KCP Bintaro Sektor 3 Ruko Graha Marcella No. 3 & 3 A Jln. Bintaro Utama Sektor 3 A Tangerang 021-7362657','','','2013-04-25',''],
    ['475','KCP Ciputat 2 Jln. Ciputat Raya 10 E-F Jakarta 021-7201651, 7201654','','','2013-04-25',''],
    ['476','KCP Pasar Cipulir Komp. Cipulir Permai No. 9 E, Jln. Raya Ciledug Jakarta 021-73880318-19','','','2013-04-25',''],
    ['477','KCP Samanhudi Jln. Samanhudi 57 B Jakarta 021-3919571-72 (huntung), 3519586','','','2013-04-25',''],
    ['478','KCP Wahid Hasyim Jln. KH Wahid Hasyim 82 Jakarta 021-3903979','','','2013-04-25',''],
    ['479','KCP Bojong Indah Komp. Bojong Indah Cengkareng, Jln. Pakis Raya 88 H Jakarta 021-5818548, 5825679','','','2013-04-25',''],
    ['480','KCP Mangga Dua ITC Gedung ITC Mangga Dua Lt.IV Blok B No.20-25, 29-32, Jln. Mangga Dua Raya Jakarta 021-6015205, 6016171','','','2013-04-25',''],
    ['481','KCP Teluk Mas Jln. Teluk Gong No. 9 & 9A Jakarta 021-6612075, 6628961','','','2013-04-25',''],
    ['482','KCP Untar I Universitas Tarumanegara Blok I & P, Jln. Letjen S. Parman 1 Jakarta 021-5667284, 5667286-87','','','2013-04-25',''],
    ['483','KCP Untar II Jln. Arteri S. Parman Jakarta 021-5655559, 5655564','','','2013-04-25',''],
    ['484','KCP Keamanan Jln. Keamanan 50 Jakarta 021-6325866, 6325870-72','','','2013-04-25',''],
    ['485','KCP Lokasari Komp. Lokasari Plaza Blok B 45, Jln. Mangga Besar 81 Jakarta 021-6012168, 6253245','','','2013-04-25',''],
    ['487','KCP Pademangan Jln. Pademangan IV No. 2A & 2B Jakarta 021-6415104-05, 645135','','','2013-04-25',''],
    ['488','KCP Jelambar Kavling Polri, Jln. Hadiah Blok B-7 No.706 Jakarta 021-5661660, 56962464','','','2013-04-25',''],
    ['489','KCP Taman Aries Rukan Kencana Niaga Blok D-1 No. 1 A Jakarta 021-5855219, 5855254','','','2013-04-25',''],
    ['490','KCP Taman Permata Buana Ruko Taman Permata Buana, Jln. Pulau Bira III Blok D1/36-37 Kembangan Jakarta 021-5818501, 5801684','','','2013-04-25',''],
    ['491','KCP Wisma Relasi Jln. Panjang 333 Jakarta 021-5322059, 5322060','','','2013-04-25',''],
    ['494','KCP Alaydrus Jln. Alaydrus 48 B Jakarta 021-6338411, 6345073, 3518409','','','2013-04-25',''],
    ['496','KCP Jatinegara Timur Jln. Jatinegara Timur No. 39 Jakarta 0','','','2013-04-25',''],
    ['497','KCU SERPONG Jln. Raya Serpong Km. 3 No.9 A-D Tangerang 021-53152262','','','2013-04-25',''],
    ['498','KCP Gedung Hijau Jln. Gedung Hijau Raya No. 41, Pondok Indah Jakarta 021-75817850, 7655981','','','2013-04-25',''],
    ['5000','KCP Taman Sunter Indah Taman Sunter Indah Blok KI-1/31 Jakarta 021-6500489, 6500630, 6519822','','','2013-04-25',''],
    ['5005','KCP Senayan City Senayan City L3 - 56, Jln. Asia Afrika Lot 19 Jakarta 021-72781515','','','2013-04-25',''],
    ['5010','KCP Bintaro Jln. RC. Veteran 8 D Jakarta 021-7370870-71','','','2013-04-25',''],
    ['5015','KCP Mega Kuningan Gedung Oakwood Premier Cozmo Jl. Lingkar Mega Kuningan Blok E 4.2 No. 1 Jakarta 021-25542450','','','2013-04-25',''],
    ['5020','KCP Graha Paramita Jln. Denpasar Raya, Kuningan Jakarta 0','','','2013-04-25',''],
    ['5025','KCP Grha Surya Jln. Setiabudi Selatan I Kav. 9 Jakarta 021-57904765','','','2013-04-25',''],
    ['5035','KCP Wisma Mulia Wisma Mulia Suite G02, Jln. Gatot Subroto No. 42 Jakarta 021-52971225','','','2013-04-25',''],
    ['5040','KCP Adhi Graha Gedung Adhi Graha - Ground Floor Unit C, Jln. Jend. Gatot Subroto Kav. 56 Jakarta 021-5268479','','','2013-04-25',''],
    ['5050','KCP ITC Permata Hijau Grand Permata Hijau Type Emerald no. 12 & 14, Jln. Arteri Permata Hijau Jakarta 0','','','2013-04-25',''],
    ['5060','KCP Babatan Pantai Jln. Babatan Pantai 2 T Surabaya 031-3818090 (hunting)','','','2013-04-25',''],
    ['5090','KCP Genteng Kali Jln. Genteng Kali 89 Surabaya 031-5465542','','','2013-04-25',''],
    ['5100','KCP Gemblongan Jln. Gemblong 63 L Surabaya 031-5469831-2','','','2013-04-25',''],
    ['5110','KCP Kalianyar Jln. Ngaglik No. 23 Surabaya 031-3763090','','','2013-04-25',''],
    ['5120','KCP Prapen Jln. Raya Prapen 38 Surabaya 0','','','2013-04-25',''],
    ['5130','KCP Perak Timur Jln. Perak Timur no. 518 E Surabaya 031-3292926','','','2013-04-25',''],
    ['5140','KCP Bandung Trade Centre Lower Ground Floor No. F.1, Jln. Dr. Djundjunan No. 143-149 Bandung 022-2033068, 2030330','','','2013-04-25',''],
    ['5150','KCP Abdul Rachman Saleh Jln. Abdul Rachman Saleh 77 Bandung 022-6020876-78','','','2013-04-25',''],
    ['5170','KCP Cihampelas Jln. Cihampelas No. 119 B Bandung 022-2060995, 2060996','','','2013-04-25',''],
    ['5190','KCP Tidar 2 Jln. Tidar No. 18 C Surabaya 031-5473270, 5311032','','','2013-04-25',''],
    ['5200','KCP Klampis Ruko Sinar Galaxi, Jln. Klampis Jaya 92-94 Surabaya 031-5925115, 5924980','','','2013-04-25',''],
    ['5210','KCP Bulevar Hijau Komp. Sentra Niaga Bulevar Hijau Kav. 33-35, Medan Satria Bekasi 021-88987185-86, 8884788','','','2013-04-25',''],
    ['5220','KCP Lippo Cikarang Jln. M. Thamrin Blok B-9, Thamrin Square Lippo City, Cikarang Bekasi 021-8972455, 89907269','','','2013-04-25',''],
    ['5225','KCP Talavera Gedung Talavera, Jln. TB Simatupang Kav. 26 Jakarta 021-75924541-43','','','2013-04-25',''],
    ['5230','KCP Hasanudin Jln. Hasanudin 43/48 Jakarta 021-72570705, 7250682','','','2013-04-25',''],
    ['5240','KCP Wolter Mongisidi Jln. Wolter Monginsidi 56 Jakarta 021-7202124-25','','','2013-04-25',''],
    ['5250','KCP Ratu Plaza Jln. Jend. Sudirman Lantai Dasar Jakarta 0','','','2013-04-25',''],
    ['5260','KCP KS Tubun Gd.Graha Indramas Lt.dasar, Jln.AIP II KS Tubun Raya No.77 Jakarta 021-53673301-03','','','2013-04-25',''],
    ['5270','KCP Bina Nusantara Kamp.II Univ.Bina Nusantara,Jln.Anggrek Cakra 10 Kebon Jeruk Jakarta 021-5350626-27','','','2013-04-25',''],
    ['5280','KCP Jelambar Baru Raya Jln. Jelambar Baru Raya 53 C Jakarta 021-5649208, 5691176','','','2013-04-25',''],
    ['5290','KCP Pejagalan Jln. Pejagalan I No. 3E Jakarta 021-6911693, 6914052, 6918906','','','2013-04-25',''],
    ['5300','KCP Perniagaan Timur Jln. Perniagaan Timur 38 Jakarta 021-6915120, 6918912','','','2013-04-25',''],
    ['5310','KCP Taman Kencana Komp.Taman Kencana Blok C1/11, Jln. Kamal Raya, Cengkareng Jakarta 021-5553439, 5553164, 5557742','','','2013-04-25',''],
    ['5320','KCP Telepon Kota Jln. Telepon Kota 34 Jakarta 021-6922768, 6928016','','','2013-04-25',''],
    ['5330','KCP ITC Roxy Mas II ITC Roxy Mas Lt. 4 Blok E No. 26-38, Jln. KH Hasyim Ashari No. 125 Jakarta 021-30002644-47','','','2013-04-25',''],
    ['5340','KCP Pinangsia Jln. Pinangsia II No.3 & 3A Jakarta 021-6903714, 6903719','','','2013-04-25',''],
    ['5350','KCP Juanda III Jln. Ir. Juanda III No. 34 Jakarta 021-3517662-63, 3853084, 3863949','','','2013-04-25',''],
    ['5360','KCP Metro Pasar Baru Gedung Metro Pasar Baru lt.4 No.404, Jln. Samanhudi Jakarta 0','','','2013-04-25',''],
    ['5370','KCP Grogol Jln. Dr. Mawardi IV/41 Jakarta 021-5660701, 5663145-52','','','2013-04-25',''],
    ['5375','KCP Pacific Place Pacific Place Mall Lt. 3 Unit 3-39 Kawasan Niaga Terpadu Sudirman Jln. Jend. Sudirman Kav. 52-53 Lot Jakarta 021-51402780, 51402790','','','2013-04-25',''],
    ['5380','KCP Taman Harapan Indah Komp. Taman Harapan Indah Blok EE No.1, Jelambar Baru Jakarta 021-56962463, 56962452','','','2013-04-25',''],
    ['5385','KCP Summitmas Summitmas I Lt. Dasar, Jln. Jend. Sudirman Kav. 61-62 Jakarta 021-5226886','','','2013-04-25',''],
    ['5390','KCP Citra Garden II Perum. Citra Garden II Ruko Citra Niaga Blok B No. 1 & 2 Jakarta 021-54374715','','','2013-04-25',''],
    ['5415','KCP Mall Grand Indonesia Gedung Grand Indonesia Mall A, Lower Ground No. 20-21, Jln. MH Thamrin No. 1 Jakarta 021-23580577','','','2013-04-25',''],
    ['5440','KCP Biak Jln. Biak No. 44 AB Jakarta 021-6319035, 6313614','','','2013-04-25',''],
    ['5450','KCP ITC Roxi Mas ITC Roxy Mas Basement 13, Jln.KH.Hasyim Ashari 125 Jakarta 021-63857816, 63857832','','','2013-04-25',''],
    ['5460','KCP Menara Batavia Gedung Menara Batavia Lt.Basement, Jln.KH Mansyur kav.126 Jakarta 0','','','2013-04-25',''],
    ['5470','KCP Pasar Minggu Center Jln. Lenteng Agung Raya No. 26 E-F Jakarta 021-78833675, 78833677-79','','','2013-04-25',''],
    ['5475','KCP Karawang Tuparev Jln. Tuparev No. 356 Karawang 0267-622458, 622648, 8452924, 84529','','','2013-04-25',''],
    ['5490','KCP Taman Semanan Indah Perum. Taman Semanan Blok C/48, Jln.Duri Kosambi Jakarta 021-5455438, 5455287, 54390238','','','2013-04-25',''],
    ['5500','KCP Kemanggisan Jln. Kemanggisan Utama Raya 37 Jakarta 021-5482311, 5482747','','','2013-04-25',''],
    ['5510','KCP Bandara S/H Term D Bandara Soekarno Hatta term D Tangerang 021-5501923, 5501980','','','2013-04-25',''],
    ['5520','KCP Warung Buncit Gedung Multika, Jln. Mampang Prapatan Raya 71-73 Jakarta 021-7975146, 7975149, 7975224','','','2013-04-25',''],
    ['5530','KCP Otista Jln. Otista No. 99 Jakarta 0','','','2013-04-25',''],
    ['5540','KCP Sejati Mulia Koperasi Sejati Mulia B 1, Jln.Ragunan Pasar Minggu Jakarta 021-7813150, 7827839','','','2013-04-25',''],
    ['5550','KCP M. Duryat Jln. Kombes M. Duryat Blok A No. 5-6 Surabaya 031-5352882-83','','','2013-04-25',''],
    ['5560','KCP Dupak Pertokoan Dupak Megah Jaya, Jln. Dupak 3-9 Blok B No. 1 Surabaya 031-5464852-53','','','2013-04-25',''],
    ['5600','KCP Margorejo Jln. Raya Margorejo Indah 10-11 Surabaya 0','','','2013-04-25',''],
    ['5650','KCP Kapasari Jln. Kapasari 81 Surabaya 0','','','2013-04-25',''],
    ['5660','KCP Panglima Polim Raya Ruko Grand Panglima Polim, Jln. Panglima Polim Raya 16-17 Jakarta 021-72793202, 72801501-02','','','2013-04-25',''],
    ['5680','KCP Kemang Pratama Komplek Ruko Kemang Pratama Blok AN No. 1A, Jln. Kemang Pratama Raya Bekasi 021-82427581, 82427535','','','2013-04-25',''],
    ['5700','KCP HR. Rasuna Said Jln. Rasuna Said Kav. B10-11 Jakarta 021-5251461, 5251561','','','2013-04-25',''],
    ['5710','KCP Kyai Caringin Jln. Balikpapan No. 19 B & C Jakarta 021-3844542, 3844490','','','2013-04-25',''],
    ['5720','KCP Mayor Oking Jln. M. Oking Jayaatmaja 142, Citeureup Bogor 0','','','2013-04-25',''],
    ['5725','KCP Kota Wisata Ruko Trafalgar Blok SE I No. 1-2, Perumahan Kota Wisata Cibubur, Kec. Gunung Putri Cibinong 021-84935346, 84935440, 84935106','','','2013-04-25',''],
    ['5730','KCP Cempaka Putih Permai Komp. Cempaka Putih Permai Blok A/12 Jakarta 0','','','2013-04-25',''],
    ['5735','KCP Puri Begawan Gedung Pertemuan Puri Begawan, Jl. Raya Pajajaran No. 5-7 Bogor 0251-392320','','','2013-04-25',''],
    ['5740','KCP Pasar Jatinegara Jln. Pasar Timur 37 Jakarta 021-2801384, 8190030','','','2013-04-25',''],
    ['5750','KCP Saharjo Jln. Dr. Saharjo 149 G-H Jakarta 021-8312723-24','','','2013-04-25',''],
    ['5770','KCP Taman Galaxi Jln. Raya Taman Galaxi Blok A/31 Bekasi 021-82408824-25','','','2013-04-25',''],
    ['5780','KCP Ruko Kalimas Ruko Kalimas Blok B No. 6, Jln. Chairil Anwar Bekasi 021-8809819, 8806217','','','2013-04-25',''],
    ['5790','KCP Rawasari Jln. Rawasari Selatan 41 Jakarta 021-4202909, 4268716','','','2013-04-25',''],
    ['5800','KCP Utan Kayu Jln. Utan Kayu 94 Jakarta 0','','','2013-04-25',''],
    ['5810','KCP Pluit Mega Mal Jln. Pluit Permai Raya 60 Jakarta 021-6684020-22','','','2013-04-25',''],
    ['5820','KCP Sunter Bisma Komp. Nirwana Sunter Blok A/31-32, Jln. Bisma Raya Asri Jakarta 021-6518629, 6518632','','','2013-04-25',''],
    ['5830','KCP Bandengan Utara Raya Jln. Bandengan Utara Raya 1A Jakarta 021-6928983, 6922861','','','2013-04-25',''],
    ['5850','KCP Angke Jln. Tubagus Angke No. 37 Jakarta 021-6330812, 6330843','','','2013-04-25',''],
    ['5860','KCP KHM Mansyur II Jln. KHM Mansyur 73 B dan 72 C Jakarta 021-6314044, 6314149, 63851039, 63','','','2013-04-25',''],
    ['5870','KCP Pembangunan Jln. Pembangunan I No. 25A Jakarta 021-6341428, 6343630','','','2013-04-25',''],
    ['5880','KCP Mangga Besar Raya Jln. Mangga Besar Raya 128 Jakarta 021-6009753, 6009769','','','2013-04-25',''],
    ['5885','KCP Lindeteves Trade Center Gedung Lindeteves Trade Center Ruko RA 33 - 35 - 36, Jln.Hayam Wuruk 127 Jakarta 021-. . .','','','2013-04-25',''],
    ['5890','KCP Pecenongan Jln. Pecenongan 86 Jakarta 021-2310140, 2310144','','','2013-04-25',''],
    ['5910','KCP Mangga Dua Square Komp. Mangga Dua Square Blok F No. 17, Jln. Gunung Sahari Raya Jakarta 021-623100-35-36','','','2013-04-25',''],
    ['5920','KCP Kaveling Polri Jln. Pasar Inpres Kav. Polri Blok F VIII No.1605 B Jakarta 021-5608274, 5655819','','','2013-04-25',''],
    ['5930','KCP Kosambi Jln. Kosambi Duri Raya 86 Jakarta 021-5446269, 9137710','','','2013-04-25',''],
    ['5940','KCP Poris Indah Komp. Poris Indah Blok D2/1, Jln. Ampera Tangerang 0','','','2013-04-25',''],
    ['5980','KCP Cideng Timur Jln. Cideng Timur 11 F Jakarta 021-6324667, 63851139','','','2013-04-25',''],
    ['5990','KCP Jamblang Jln. Jamblang Raya 51 Jakarta 021-6323684, 6327720','','','2013-04-25',''],
    ['6000','KCP Soepomo Jln. Prof. Dr. Soepomo 13 Jakarta 021-8309781, 8309794','','','2013-04-25',''],
    ['6010','KCP Arjuna Jln. Arjuna Utara No. 9A Jakarta 021-56942267','','','2013-04-25',''],
    ['6020','KCP Pluit Samudra Jln. Pluit Samudra No. 9 Blok N Kav. 5 Jakarta 021-6628120','','','2013-04-25',''],
    ['6030','KCP Bintaro Utama Bintaro Jaya Blok E Kav.3-5, Jln. Bintaro Utama Rukan Jakarta 021-7351025, 7373691','','','2013-04-25',''],
    ['6040','KCP Alam Sutra Jln. Sutra Niaga I No.39, Ruko Alam Sutra, Raya Serpong Tangerang 021-53120937-38','','','2013-04-25',''],
    ['6050','KCP Villa Melati Mas Komp. Pertokoan Villa Melati Mas Blok SR 1 No.18-19, Jln. Raya Serpong Tangerang 0','','','2013-04-25',''],
    ['6070','KCP Bina Mulia Gedung Bina Mulia I Lt.1, Jln. HR. Rasuna Said Kav. 10 Jakarta 021-5201130','','','2013-04-25',''],
    ['6080','KCP Bona Indah Plaza Bona Indah blok B/12, Jln.Karang Tengah Raya Jakarta 021-75908674-75','','','2013-04-25',''],
    ['6090','KCP Golden Point Center Plaza Ciputat Mas Blok AD 5, Jln.Ir Juanda 5A Ciputat 021-74704381-82','','','2013-04-25',''],
    ['6100','KCP Bhayangkara Komp. Univ. Bhayangkara Polda, Jln.A.Yani 114 Surabaya 031-8281358, 8293383','','','2013-04-25',''],
    ['6110','KCP Grand Sudirman Ruko Grand Sudirman, Jln. PB Sudirman Blok C5-C6 Denpasar 0361-241093','','','2013-04-25',''],
    ['6120','KCP Kupang Jaya Jln. Kupang Jaya 17/I Surabaya 031-7344550-52','','','2013-04-25',''],
    ['6130','KCP Raya Kuta - CCR Jln. Raya Kuta No. 55X Denpasar 0361-','','','2013-04-25',''],
    ['6170','KCP Tandes Jln. Manukan Wetan 52 A/B Surabaya 031-7406735, 7414878','','','2013-04-25',''],
    ['6220','KCP Kemang II Jln. Kemang Raya No. 15 Jakarta 021-7182752, 7182847','','','2013-04-25',''],
    ['6240','KCP Permata Ujung Menteng Jln. Raya Bekasi Km. 25 Blok A/17-18, Ujung Menteng Jakarta 021-46824214, 46824217','','','2013-04-25',''],
    ['6250','KCP Intercon Megah Komp.Intercom Megah, Jln. Joglo Raya Blok W-IV No. 27 Jakarta 021-5869950, 5868856, 5868160','','','2013-04-25',''],
    ['6260','KCP Metro Tanah Abang Pusat Grosir Metro Tanah Abang Lt. Lower Ground Blok A No. 31-33, 35-40, 82-83, 85-88, Jl. KH Wahid Jakarta 021-30036841-43','','','2013-04-25',''],
    ['6270','KCP Tebet Barat 2 Jln. Tebet Raya No. 25 B Blok CI Tebet Jakarta 021-83790412-13','','','2013-04-25',''],
    ['6280','KCP Cibubur Cibubur Indah Blk BA, Jln. Lapangan Tembak Blok A/24-26 Jakarta 021-8719451, 87701843','','','2013-04-25',''],
    ['6290','KCP Tebet Timur Jln. Tebet Timur Dalam Raya 61 B Jakarta 021-83790147, 8305755','','','2013-04-25',''],
    ['6300','KCP Kelapa Gading Hibrida Jln. Raya Boulevard Blok RA/11 Jakarta 021-4504505, 4516678','','','2013-04-25',''],
    ['6310','KCP Pegambiran Jln. Pengambiran Raya 2 Jakarta 021-4893352, 4898526','','','2013-04-25',''],
    ['6320','KCP Mal Kelapa Gading Jln. Boulevard Raya Blk LB1 No. 15-16 Jakarta 021-4531935, 45840075-77','','','2013-04-25',''],
    ['6330','KCP Buaran Raya Jln. Buaran Raya Blok A No. 100 dan 101 Jakarta 021-8628510','','','2013-04-25',''],
    ['6340','KCP Raden Saleh Grha Tirtadi, Lantai 1 Ruangan 101 Jln. Raden Saleh No. 20 Jakarta 021-39837391, 39837392','','','2013-04-25',''],
    ['6350','KCP Menara Ancol Jln. Pasir Putih Raya Jakarta 021-6459765, 6459766','','','2013-04-25',''],
    ['6360','KCP Pasar Pagi Mangga Dua Gedung Pusat Perdagangan Grosir Pasar Pagi Lt.III, Ruang No.4 (Banking), Jln. Mangga Dua Raya Jakarta 021-6011109, 6284218','','','2013-04-25',''],
    ['6370','KCP Muara Karang 2 Jln. Pluit Karang No. 64 Blok Z3 Selatan Kav. 32 Jakarta 021-6628869-70, 6629440, 6678894','','','2013-04-25',''],
    ['6380','KCP Graha Kirana Gedung Graha Kirana, Jl. Yos Sudarso No. 88 Jakarta 0','','','2013-04-25',''],
    ['6430','KCP Puri Deltamas Komplek Ruko Puri Deltamas Blok J No. 5, Jl. Bandengan Selatan No. 43 Jakarta 0','','','2013-04-25',''],
    ['6440','KCP Ricci Sekolah Ricci, Jln. Kemenangan III/70 Jakarta 0','','','2013-04-25',''],
    ['6450','KCP Lindeteves Gedung Hayam Wuruk Indah Lt 1 Blok A-L 01,CKS 056, Jln.Hayam Wuruk 100 Jakarta 021-6258061, 6245358','','','2013-04-25',''],
    ['6460','KCP Griya Utama Ruko Puri Mutiara, Jln. Griya Utama A No. 37-38 Jakarta 021-65310876, 65310877-79, 6531088','','','2013-04-25',''],
    ['6470','KCP Utama Raya Jln. Utama Raya 11 E Jakarta 021-5408847-48','','','2013-04-25',''],
    ['6500','KCP Sunrise Garden Jln. Surya Utama Blok V/31 Jakarta 021-5807147, 5808706','','','2013-04-25',''],
    ['6530','KCP Harmoni Plaza Ruko Harmoni Plaza Blok B 25, Jln. Suryopranoto 2 Jakarta 021-6330186','','','2013-04-25',''],
    ['6540','KCP Tanah Abang 2 Jln. Tanah Abang II No.40 Jakarta 021-3452836','','','2013-04-25',''],
    ['6550','KCP Abdul Muis Gedung Graha Motor City Level I Suite 101, Jln. Abdul Muis 24-26 Jakarta 021-3505034, 3507529, 3508103, 350','','','2013-04-25',''],
    ['6560','KCP Kebon Jeruk Raya Jln. Kebon Jeruk Raya 10 Blok B/1 Jakarta 021-5308847, 5364983','','','2013-04-25',''],
    ['6580','KCP Moderland Komp. Pertokoan Modernland Blok DR No.2-3, Jln. Baypass - Cipondoh Tangerang 021-55747509, 55749009','','','2013-04-25',''],
    ['6590','KCP Prima Sunter Ruko Prima Sunter, Jln. Danau Sunter Utara No.A2-A3 Jakarta 021-6517255, 6513047','','','2013-04-25',''],
    ['6600','KCP Boulevard Timur Jln. Boulevard Timur Blok NC 1 No.54-55 Jakarta 021-4517131-32','','','2013-04-25',''],
    ['6610','KCP Proklamasi Depok Jln. Proklamasi Blok D No.15 Depok 0','','','2013-04-25',''],
    ['6630','KCP Grand Mall Bekasi Jln. Jend.Sudirman No. 99 Kranji Bekasi 021-88958459, 88966811, 88966812','','','2013-04-25',''],
    ['6640','KCP ITC Kuningan ITC Kuningan Lt.1 Blok F No. 1&2, Jl. Prof. Dr. Satrio, Karet Kunungan - Setiabudi Jakarta 021-57935501, 57935502','','','2013-04-25',''],
    ['6690','KCP Gatot Subroto Denpasar Jln. Gatot Subroto No. 80 Unit 8-9 Denpasar 0361-430430','','','2013-04-25',''],
    ['6700','KCP Sanur Raya Jln. Bypass Ngurah Rai Kompleks Ruko Sanur Raya No. 17 Sanur 0361-281264','','','2013-04-25',''],
    ['6710','KCP Semarang Jln. Semarang blok B no.14 Surabaya 031-5464850-51','','','2013-04-25',''],
    ['6720','KCP Taman Pondok Indah Ruko Taman Pondok Indah blok A-16 Surabaya 031-7663389-8749','','','2013-04-25',''],
    ['6730','KCP Rungkut Megah Jln. Raya Kali Rungkut 5, Blok E No.11-12 Surabaya 031-8709880-82','','','2013-04-25',''],
    ['6750','KCP Rungkut Mapan Pasaraya Yakata, Jln. Raya Rungkut Mapan I Surabaya 0','','','2013-04-25',''],
    ['6760','KCP Ciputat Mall Mega Mal Ciputat, Jln.Ir.H. Juanda Ciputat 021-7440386-87','','','2013-04-25',''],
    ['6790','KCP Kebayoran Blok M Jln. Melawai raya 110 A-B Jakarta 021-7205082 (hunting)','','','2013-04-25',''],
    ['6800','KCP Bintaro Sentra Menteng Ruko Sentra Menteng Blok MN No. 03, Bintaro Sektor VII Tangerang 021-74863822','','','2013-04-25',''],
    ['6820','KCP Jembatan Merah Ruko Mall Merdeka Blok A 1, Jln.Merdeka Bogor 0251-376685','','','2013-04-25',''],
    ['6830','KCP Pasar Cibinong Jln. Mayor Oking 27, Cibinong Indah Blok A/7-8 Cibinong 021-8752733, 8753734','','','2013-04-25',''],
    ['6840','KCP Angkasa Jln. Angkasa No. 20 L Jakarta 021-4207844-46, 4207850','','','2013-04-25',''],
    ['6850','KCP Atrium Komp.Pert.Segitiga Atrium Blok F No.19, Jln.Senen Raya 135 Jakarta 021-2314610-13','','','2013-04-25',''],
    ['6860','KCP Kwitang Jln. Kwitang Raya No. 17 Jakarta 021-3908295, 3990079, 3920051','','','2013-04-25',''],
    ['6870','KCP Pondok Gede Plaza Ruko Pondok Gede Plaza Blok H no. 3 & 5, Jln. Raya Pondok Gede Pondok Gede 021-','','','2013-04-25',''],
    ['6880','KCP Union Square Ruko Union Square Blok A No.5, Jln.MH.Thamrin, Lippo Cikarang Bekasi 021-8973788, 89908236, 89908233','','','2013-04-25',''],
    ['6890','KCP MH Thamrin Tangerang Jln. MH. Thamrin 9, Cikokol Tangerang 021-','','','2013-04-25',''],
    ['6900','KCP Pelabuhan Tanjung Priok Gedung DHU, Jln. Panaitan No. 3, Pelabuhan Tanjung Priok Jakarta 021-','','','2013-04-25',''],
    ['6910','KCP Yos Sudarso Komplek Yos Sudarso Megah, Jln. Yos Sudarso No. 1 Blok B No. 5 Jakarta 021-4368568, 43930065, 43930067','','','2013-04-25',''],
    ['6920','KCP Duri Raya Jln. Duri Raya 37 B Jakarta 021-','','','2013-04-25',''],
    ['6930','KCP Mangga Dua Mal Mangga Dua Mal No. RM. 49, Jln. Mangga Dua Raya Jakarta 021-6129764, 62301097','','','2013-04-25',''],
    ['6970','KCP Kartini Jln. Kartini Raya 27 Jakarta 021-62200624','','','2013-04-25',''],
    ['6980','KCP Mangga Besar VIII Jln. Mangga Besar VIII No.12 A-F Jakarta 021-','','','2013-04-25',''],
    ['7000','KCP Kramat Jaya Baru Komp.Ruko Maisonet Blok B/12, Jln. Percetakan Negara II Jakarta 021-4265538-40','','','2013-04-25',''],
    ['7010','KCP Metro Permata Komp.Metro Permata, Jln. Raden Saleh Blok A2/1 Tangerang 021-7324330-31','','','2013-04-25',''],
    ['7020','KCP Duta Gardenia Komp. Duta Gardenia Blok A1/12A, Jln. Duta Gardenia Tangerang 021-5400714, 5400736','','','2013-04-25',''],
    ['7030','KCP Puri Kembangan Jln. Raya Kembangan No. 3A Jakarta 021-5806286, 5825171-72','','','2013-04-25',''],
    ['7040','KCP Green Ville Komp.Green Ville Blok AS No.42, Kepa Duri - Kebon Jeruk Jakarta 021-56964816, 56965188','','','2013-04-25',''],
    ['7050','KCP Tanjung Duren 2 Jln. Tanjung Duren Raya 11 C Jakarta 021-5643011, 56961845','','','2013-04-25',''],
    ['7060','KCP Cempaka Putih Raya Jln. Cempaka Putih Raya 102 C-D Jakarta 021-4266909, 4266910','','','2013-04-25',''],
    ['7080','KCP Pulogadung Trade Center Jln. Raya Bekasi Km. 21 Ruko A2/18-19, Kawasan Industri Pulogadung Jakarta 021-46801216, 46801217','','','2013-04-25',''],
    ['7090','KCP Rantai Mulia Kencana Jln. Pesanggrahan No. 28-29, Puri Kencana Kembangan Selatan Jakarta 021-5818328, 5818359, 5818520','','','2013-04-25',''],
    ['7100','KCP Tiang Bendera Jln. Tiang Bendera 5 No.38 E Jakarta 021-6929170, 6901635','','','2013-04-25',''],
    ['7110','KCP Balaraja Jln. Raya Serang Km.24/5, Balaraja Tangerang 021-5953989','','','2013-04-25',''],
    ['7120','KCP Karawaci Jln. Imam Bonjol 42 A Tangerang 021-','','','2013-04-25',''],
    ['7130','KCP Perum Cibodas Perum Ciobodas, Ruko Dutamas Plaza Blok A/23 Tangerang 021-5527380, 5527938, 55288487','','','2013-04-25',''],
    ['7140','KCP Iskandar Muda Jln. Arteri Pondok Indah Kav. 80/1-2 Jakarta 021-7203136-37','','','2013-04-25',''],
    ['7150','KCP Nusantara Jln. Nusantara Raya No. 15 Depok 0','','','2013-04-25',''],
    ['7160','KCP MT Haryono Cawang Jln. MT Haryono Kav. 9 Jakarta 021-8564873, 8583183, 8583185','','','2013-04-25',''],
    ['7180','KCP Pejaten Ruko Pejaten Mas, Jln.Raya Pasar Minggu Km.20 No. 98F & 98G Jakarta 021-7942662','','','2013-04-25',''],
    ['7210','KCP Gunungsari Jln. Gunungsari 5-7 blok G Surabaya 0','','','2013-04-25',''],
    ['7220','KCP Krembangan Jln. Krembangan Barat 26 D Surabaya 031-3537731 (hunting)','','','2013-04-25',''],
    ['7230','KCP Pabean Jln. Kalimati Kulon 23 & 25 Surabaya 031-3523320, 3573683','','','2013-04-25',''],
    ['7240','KCP Mega Grosir ITC Mega Grosir, Ground Floor Blok H2 No. 7-8-9, Jln. Gembong No. 20-30 Surabaya 031-3743701','','','2013-04-25',''],
    ['7260','KCP Simpang Darmo Permai Jln. Raya Darmo Permai Selatan 1E Surabaya 031-7319373, 7344311','','','2013-04-25',''],
    ['7290','KCP Jagalan Jln. Jagalan No. 117 B Surabaya 031-5470820, 5346082, 70991677','','','2013-04-25',''],
    ['7300','KCP Duta Mas Fatmawati Komp.Pert.Duta Mas Fatm.Blok D 1 No.12, Jl.RS Fatmawati, Jakarta Jakarta 021-72797056-57','','','2013-04-25',''],
    ['7310','KCP Mal Pondok Indah Ground Floor G31 & G32, Jln. Metro Pondok Indah Jakarta 021-75920772, 75920773','','','2013-04-25',''],
    ['7330','KCP Cilandak KKO I Jln. Cilandak KKO No. 9 Jakarta 021-78831801, 7816057','','','2013-04-25',''],
    ['7340','KCP Wisma Nusantara Gedung Wisma Nusantara, Lt.Dasar, Jln. MH Thamrin 59 Jakarta 021-3905165-6','','','2013-04-25',''],
    ['7350','KCP Menteng Jln. HOS Cokroaminoto 83 Jakarta 021-3905401-02','','','2013-04-25',''],
    ['7360','KCP Tajur Jln. Tajur No. 65 Bogor 0251-360812, 323310','','','2013-04-25',''],
    ['7370','KCP Surya Kencana Jln. Suryakencana 285 Bogor 0251-','','','2013-04-25',''],
    ['7380','KCP Warung Jambu Plaza Pertokoan Warung Jambu Blok A/1, Jln. Raya Pajajaran Bogor 0251-','','','2013-04-25',''],
    ['7390','KCP Ahmad Yani Ruko Kalimalang Commercial Center Blok A No.5-6, Jln. A. Yani Bekasi 021-8854017, 8854019','','','2013-04-25',''],
    ['7400','KCP Time Square Cibubur Ruko Time Square C1-2 & C1-3 Jln. Transyogi Km. 3 Cibubur Pondok Gede 021-84993572-73','','','2013-04-25',''],
    ['7410','KCP Pondok Ungu Bekasi Jln. Raya Sultan Agung, Kompleks Ruko Mall Harapan No.16 Blok A No.12 Bekasi 021-','','','2013-04-25',''],
    ['7420','KCP Percetakan Negara Jln. Percetakan Negara No. 223 C Jakarta 021-4255284, 4255231, 4255258','','','2013-04-25',''],
    ['7460','KCP Agung Sedayu II Komp. Agung Sedayu Blok C No.11, Jln. Mangga Dua Raya Jakarta 021-6121123, 6126962','','','2013-04-25',''],
    ['7480','KCP Gading Bukit Indah Jln. Bukit Gading Raya Blok D/1 Jakarta 021-45840715, 4515822','','','2013-04-25',''],
    ['7510','KCP Jatibening Jln. Caman Raya No. 17 J & K Bekasi 021-84992622, 84992617','','','2013-04-25',''],
    ['7520','KCP Krekot Bunder Jln. Raya Krekot Bunder 58, RT.003/06 Jakarta 021-3456042, 3456044','','','2013-04-25',''],
    ['7530','KCP PRJ Kemayoran Gambir Expo Blok C-3A dan C-5 Pintu 2 Arena PRJ Kemayoran Jakarta 021-26645289, 26645290, 26645291','','','2013-04-25',''],
    ['7540','KCP Sentra Puri Indah Komplek Sentra Niaga Puri Indah Blok T 3/12, Kembangan Jakarta 021-58302880-81','','','2013-04-25',''],
    ['7550','KCP Jalan Panjang Jln. Panjang 79 EF Jakarta 021-5633063-64','','','2013-04-25',''],
    ['7560','KCP Komp. Taman Kota Jln. Daan Mogot KM. 11 Wisma SSK Jakarta 021-54375241','','','2013-04-25',''],
    ['7570','KCP Taman Palem Lestari Komp. Perum Taman Palem Lestari Blok C5 No. 52 Jakarta 021-55956572-73','','','2013-04-25',''],
    ['7580','KCP Villa Bandara Perum Villa Bandara Blok M2 No. 40-41 Tangerang 021-5559496, 5558997, 9112590','','','2013-04-25',''],
    ['7600','KCP Jatinegara Barat Jln. Jatinegara Barat 54 E, Blok C 1-4 Jakarta 021-','','','2013-04-25',''],
    ['7610','KCP Supermal Karawaci 105 Boulevar Diponegoro No. 00-00 LG 184-186 Lippo Karawaci Tangerang 021-54201745','','','2013-04-25',''],
    ['7620','KCP Aneka Subur Jatake Aneka Subur Toserba, Jln. Raya Gatot Subroto Km. 7, Jatake Tangerang 021-59308786-88','','','2013-04-25',''],
    ['7630','KCP Taman Permata Indah II Komp.Taman Permata Indah II Blok M/23, Jln. Teluk Gong Raya Jakarta 021-6622375, 66690042','','','2013-04-25',''],
    ['7640','KCP Citra Raya Komp. Pertokoan Perum Citra Raya Blok H1 No.1 Cikupa Tangerang 021-59402936-37','','','2013-04-25',''],
    ['7650','KCP Depok Asri Ruko Depok No. 4 & 5, Jln. Tole Iskandar No. 40 Depok 021-7707525, 7709542','','','2013-04-25',''],
    ['7660','KCP Setiabudi Atrium Plaza Setiabudi, Gd.Setiabudi Atrium Lt.1 Suite 101 A, Jln.HR.Rasuna Said Kav.62, Kuningan Jakarta 021-5210698-99','','','2013-04-25',''],
    ['7670','KCP Sesetan Jln. Sesetan No. 78 Denpasar 0361-','','','2013-04-25',''],
    ['7680','KCP Teuku Umar Denpasar Jln. Teuku Umar No. 99 D Denpasar 0361-','','','2013-04-25',''],
    ['7720','KCP By Pass Mumbul Jln. By Pass Ngurah Rai No. 074 Nusa Dua Denpasar 0361-778630, 778688','','','2013-04-25',''],
    ['7725','KCP Renon Jln. Prof. Mohammad Yamin No. 11 A, Renon Denpasar 0361-242888','','','2013-04-25',''],
    ['7730','KCP WR Supratman Jln. WR Supratman No. 18 Denpasar 0361-465106, 467723','','','2013-04-25',''],
    ['7740','KCP Sumedang Jln. Mayor Abdurahman 181-183 Sumedang 0261-201121, 201928','','','2013-04-25',''],
    ['7750','KCP Buah Batu Jln. Buah Batu 192 Bandung 022-','','','2013-04-25',''],
    ['7770','KCU DAGO Jln. Ir. H. Juanda 66 Bandung 022-2513185-86','','','2013-04-25',''],
    ['7780','KCP Pusat Pasar Jln. Pusat Pasar No. 2 A/P 359, Komplek Medan Mall Medan 061-4519899, 4520635','','','2013-04-25',''],
    ['7800','KCP Ranotama Jln. DR Sam Ratulangi No. 108 Manado 0431-','','','2013-04-25',''],
    ['7805','KCU TARAKAN Jln. Yos Sudarso No. 08, Kel. Karang Rejo Pantai, Kec. Tarakan Barat Tarakan 0551-23999','','','2013-04-25',''],
    ['7810','KCP Pandan Sari Jln. Pandan Sari No. 114-155 Balikpapan 0542-415252, 415253','','','2013-04-25',''],
    ['7815','KCP Balikpapan Baru Jln. MT Haryono No. 99 Balikpapan 0542-8879936, 8879931, 8870111','','','2013-04-25',''],
    ['7820','KCP A. Yani Jln. Jend. A. Yani Km.2 No. 74 Banjarmasin 0511-3257931-32','','','2013-04-25',''],
    ['7825','KCP Karang Jati Jln. A. Yani No. 35 Balikpapan 0542-413177','','','2013-04-25',''],
    ['7830','KCP Bangkong Jln. MT Haryono 337 Semarang 024-3565405, 3565406','','','2013-04-25',''],
    ['7840','KCP Astana Anyar Jl. Astana Anyar No. 128 Bandung 022-6123161, 6123140, 6123156','','','2013-04-25',''],
    ['7850','KCU SOLO II Jln. Veteran 307 Solo 0271-663477 (hunting)','','','2013-04-25',''],
    ['7860','KCP Surabaya Jln. Surabaya No. 133 & 135 Medan 061-4568866','','','2013-04-25',''],
    ['7865','KCP Tomang Elok Komplek Tomang Elok, Jln. Gatot Subroto No. 143 Medan 061-8440800','','','2013-04-25',''],
    ['7870','KCP Sipin Jln. Kolonel Abunjani No. 12, Telanaipura Jambi 0741-60565, 65465','','','2013-04-25',''],
    ['7880','KCU KAYUN Jln. Kayun 2 C-D Surabaya 031-5481425 (hunting)','','','2013-04-25',''],
    ['7895','KCP Banjar Baru Jln. A. Yani Km. 33,5 Banjarmasin 0511-4788821, 4788823','','','2013-04-25',''],
    ['7910','KCU KENDARI Jln. Drs. H. Abd. Silondae 129 A-B Kendari 0401-325200, 32787-88','','','2013-04-25',''],
    ['7920','KCU PALU Jln. Emmy Saelan 17 Palu 0451-455575','','','2013-04-25',''],
    ['7925','KCP Imam Bonjol Jln. Imam Bonjol No. 457 Pontianak 0561-737984, 734524','','','2013-04-25',''],
    ['7930','KCU PALOPO Jln. Durian II Blok B 1-3 Palopo 0471-24010-11, 21892, 23998','','','2013-04-25',''],
    ['7935','KCP A. Yani Jln. A. Yani No. 23 Samarinda 0541-749789','','','2013-04-25',''],
    ['7940','KCP Bandung Elctronic Center Jln. Purnawarman No. 13-15, Lantai Utama Blok K 1,2,3,5,6,7 Bandung 022-4224352','','','2013-04-25',''],
    ['7955','KCP Abepura Jln. Raya Abepura No. 12 Jayapura 0967-587241, 587243, 587245','','','2013-04-25',''],
    ['7960','KCP Gatot Subroto Kawasan Industri Candi Kompleks Ruko, Jl. Gatot Subroto Blok E-37 F dan E-37 G Semarang 024-7611765, 7612364','','','2013-04-25',''],
    ['7975','KCP Gorontalo Jln. Ahmad Yani No. 10 Gorontalo 0435-830900, 831119','','','2013-04-25',''],
    ['8000','KCP Katamso Medan Jln. Brigjen Katamso 56 B-C Medan 0','','','2013-04-25',''],
    ['8010','KCP BSD Sektor VII Komp. Pertokoan BSD Sektor VII Blok RM No. 45, Serpong Tangerang 021-5375940-41','','','2013-04-25',''],
    ['8020','KCP Godean Pertokaan Tambak Mas Permai No. 5A, Jln. Raya Godean Km. 49-51 Yogyakarta 0274-541925-27','','','2013-04-25',''],
    ['8025','KCP Wates Jln. Brigjen Katamso No. 38 Wates Yogyakarta 0274-774440, 774635','','','2013-04-25',''],
    ['8030','KCP Banyumanik Ruko Srondol Square Blok 5 & 6, Jln. Setiabudi No. 147 Semarang 024-7473502','','','2013-04-25',''],
    ['8035',"KCP Tanjung Mas Gedung Terminal Peti Kemas, Jln. Coaster Pelabuhan 10 A Semarang \x{2026}-\x{2026}",'','','2013-04-25',''],
    ['8040','KCP Muara Karang Utara Jln. Pluit Karang Utara no. 137 A & 137 B, Blok A3 Kav. 11 Jakarta 021-','','','2013-04-25',''],
    ['8050','KCU BUKIT TINGGI Jln. A. Yani No. 51 Bukittinggi 0752-627888','','','2013-04-25',''],
    ['8060','KCP CBD Pluit Kawasan Hunian dan Bisnis Terpadu CBD Pluit Blok B No. 9 & 10, Jln. Pluit Selatan Raya Jakarta 021-66605648-9, 66605652-3','','','2013-04-25',''],
    ['8070','KCP Karimun Jln. Ampera 4-5, Tanjung Balai Karimun Karimun 0','','','2013-04-25',''],
    ['8075','KCP Plaza Medan Fair Gedung Plaza Medan Fair Lt. 2 No. 35 & 36, Jln. Gatot Subroto No. 30 Medan 061-4141800','','','2013-04-25',''],
    ['8080','KCP Tanjung Uban Jln. Merdeka 23A-24A, Tanjung Uban Tanjung Pinang 0','','','2013-04-25',''],
    ['8090','KCP Ahmad Yani II Jln. Ahmad Yani No. 280 Bandung 022-7275592','','','2013-04-25',''],
    ['8100','KCP Mohamad Toha Jln. Mohamad Toha No. 165 Bandung 022-5209785','','','2013-04-25',''],
    ['8105','KCP Kopo Bihbul Jln. Kopo Bihbul No. 49 Bandung 022-5413025','','','2013-04-25',''],
    ['8110','KCP Kotabumi Jln. Raden Intan 296-297 Kotabumi 0724-25742-43','','','2013-04-25',''],
    ['8115','KCP HM. Yamin Jln. Prof. HM. Yamin SH No. 245 A-B Medan 061-4517800','','','2013-04-25',''],
    ['8120','KCP Muara Enim Jln. Jend. Sudirman 26 Muara Enim 0734-421187, 422815','','','2013-04-25',''],
    ['8125',"KCP Aur Kuning Jln. Belakang Pasar Aur Kuning No. 686 & 687 Bukittinggi 0752-\x{2026}",'','','2013-04-25',''],
    ['8130','KCP Lahat Jln. Mayor Ruslan II/51 Lahat 0731-321169, 324426, 324427','','','2013-04-25',''],
    ['8140','KCU JAYAPURA Komp. Pertokoan Jayapura Pasific Permai Blok C - 30/31, Jln. Sam Ratulangi Dok II Jayapura 0967-550622','','','2013-04-25',''],
    ['8170','KCU SINGKAWANG Jln. GM Situt No. 12 B Singkawang 0562-','','','2013-04-25',''],
    ['8180','KCP Pekalipan Jln. Pekalipan no. 111 Cirebon 0','','','2013-04-25',''],
    ['8190','KCP Jelutung Jln. Hayam Wuruk No. 101, Jelutung Jambi 0741-21465, 21551','','','2013-04-25',''],
    ['8195','KCP Kawasan Industri Medan Jln. Pulau Batam No. 1, Kawasan Industri Medan Tahap II Medan 061-6871800','','','2013-04-25',''],
    ['8200','KCU PEMATANG SIANTAR Jln. Merdeka No. 39 Pematang Siantar 0','','','2013-04-25',''],
    ['8205','KCP Setiabudi Komplek Setiabudi Bisnis Center, Jln. Setiabudi Blok A No. 8 Medan 061-8224800','','','2013-04-25',''],
    ['8210','KCP Batam Center Komplek Trikarsa Ekualita Blok A No. 37-38 Batam 0778-473216, 473219, 473231','','','2013-04-25',''],
    ['8220','KCU RUNGKUT Jln. Kendangsari Industri 2 Surabaya 031-8438284 (hunting)','','','2013-04-25',''],
    ['8230','KCP Riau Bisnis Center Komplek Pertokoan Riau Plaza Blok A3, Jln. Riau Pekanbaru 0761-860941-42','','','2013-04-25',''],
    ['8250','KCP Golden Trade Center Jln. Glugur - Jln. Gatot Subroto No. 11-12 Medan 061-4520700','','','2013-04-25',''],
    ['8270','KCU SINGARAJA Jln. Dr. Sutomo 3 Singaraja 0362-23761-66','','','2013-04-25',''],
    ['8280','KCP Krakatau Jln. G. Krakatau No. 138 Medan 061-6630800','','','2013-04-25',''],
    ['8290','KCU HR MUHAMAD Jln. HR Muhamad 17 Surabaya 031-7346460 (hunting), 7327907, 73','','','2013-04-25',''],
    ['8300','KCP Asia II Jln. Asia No. 184 D Medan 061-7333800','','','2013-04-25',''],
    ['8305','KCP Asia Mega Mas Kompleks Asia Mega mas Blok BB No. 11 Medan 061-7326800','','','2013-04-25',''],
    ['8310','KCP Mal Artha Gading Mal Artha Gading - Lt. Dasar, Blok A6 No. 9,10,11,12,15,16, Jln. Bulevar Artha Gading Jakarta 021-45864363 (hunting)','','','2013-04-25',''],
    ['8320','KCP Dago Atas Jln. Ir. H. Juanda 144 Bandung 022-25024821, 2532059','','','2013-04-25',''],
    ['8330','KCP ITC BSD Jln. Pahlawan Seribu, ITC Bumi Serpong Damai No. 8-9 Tangerang 021-53161777','','','2013-04-25',''],
    ['8340','KCP Cibubur Junction Cibubur Junction Lantai LG-01, Jln. Jambore No. 1, Cibubur Jakarta 021-87756630','','','2013-04-25',''],
    ['8350','KCP Mal Ciputra II Mal Ciputra Lantai LG 45A - 45, Jln. Arteri S. Parman - Grogol Jakarta 021-56954816','','','2013-04-25',''],
    ['8370','KCP Sumatera Jln. Aiptu K.S. Tubun No. 46 Medan 061-4550700','','','2013-04-25',''],
    ['8375','KCP Rahmadsyah Jln. Rahmadsyah No. 105 (d/h No. 41) Medan 061-7332800','','','2013-04-25',''],
    ['8380','KCP Jamika Jln. Jamika No. 29 Bandung 022-6022241, 6046583','','','2013-04-25',''],
    ['8390','KCP Tanah Abang Blok A Kios Pasar Tanah Abang Blok A Basement I/G-063, F-080, F-081 Jakarta 021-23571671-74','','','2013-04-25',''],
    ['8400','KCP Artha Gading Ruko Artha Gading Blok A 15-16, Jln. Boulevar Artha Gading Jakarta 021-45850328-30','','','2013-04-25',''],
    ['8410','KCP Ciluar Jln. Raya Ciluar No. 2 & 3 Bogor 0251-650261','','','2013-04-25',''],
    ['8420','KCP Tambun Naga Swalayan Tambun, Jln. Diponegoro Km. 39 Tambun Bekasi 021-88355390-91','','','2013-04-25',''],
    ['8430','KCP Kampung Baru Jln. Brigjen Katamso No. 737 Medan 061-7883800','','','2013-04-25',''],
    ['8470','KCP Batununggal Jln. Batununggal Indah I No. 23 Bandung 022-7538743, 7538745','','','2013-04-25',''],
    ['8480','KCP Pasirkaliki Atas Jln. Pasirkaliki No. 165 Bandung 022-6011415, 6016205','','','2013-04-25',''],
    ['8490','KCP Palembang Trade Centre Komplek Palembang Trade Centre Blok B No. 11, Jln. R. Sukamto Palembang 0711-382089, 382093','','','2013-04-25',''],
    ['8600','KCU PALANGKARAYA Jln. Dr. Murjani No. 67, Pahandut Palangkaraya 0536-3232168','','','2013-04-25',''],
    ['8610','KCP Kaliurang Jln. Kaliurang Km. 6,4 No. 2 Sleman Yogyakarta','','','2013-04-25',''],
    ['8620','KCP Citraland Jln. Taman Gapura Blok K No. 2 & 3 Komplek Perumahan Citra Raya Surabaya','','','2013-04-25',''],
    ['8630','KCP Pakuwon Tarde Center Pakuwon Trade Center Ruko Terrace unit 011, Jln. Puncak Indah Lontar No. 2 Surabaya 031-7390971, 7390461','','','2013-04-25',''],
    ['8650','KCP Pantai Indah Kapuk II Rukan Eksklusif Bukit Golf Mediterania Blok C No. 17, PIK Jakarta 021-55965992, 55965992, 55965902','','','2013-04-25',''],
    ['8660','KCP Daan Mogot Baru Rukan Pusat Bisnis Daan Mogot Baru Blok KJF No. 9 & 10 Jakarta 021-54371996-7','','','2013-04-25',''],
    ['8670','KCP Terminal Kargo Bandara Soekarno Hatta Gedung JPTI No. P.14A, Area Kargo, Bandara Soekarno Hatta Cengkareng Tangerang 021-55912407, 55912408','','','2013-04-25',''],
    ['8680','KCP Cikokol Komp. Mahkota Mas Blok C 5-6, Jln. MH.Thamrin Tangerang 021-55744267 (hunting)','','','2013-04-25',''],
    ['8690','KCU MARGONDA Jln. Margonda Raya No. 182 Depok 0','','','2013-04-25',''],
    ['8700','KCP Gading Square Komplek Rukan Kelapa Gading Square, Jln. Boulevard Barat Raya Blok C No. 17 Jakarta 021-45866861-3','','','2013-04-25',''],
    ['8705','KCP Mal Kelapa Gading III Gedung Mal Kelapa Gading III, Jln. Bulevar Kelapa Gaing Blok M Jakarta 021-45853688, 45853689','','','2013-04-25',''],
    ['8710','KCP Gading Riviera Jln. Raya Kelapa Hibrida, Ruko Gading Riviera Blok PF 21/10 Jakarta 021-45874634, 45874636, 45866512','','','2013-04-25',''],
    ['8720','KCP Raya Baru Bogor Ruko Dua Empat, Jln. Soleh Iskandar No. 2C, Kedung Jaya Bogor 0251-371077, 371040, 371070','','','2013-04-25',''],
    ['8730','KCP Metro Jababeka Ruko Metro Boulevard Blok A21 & A22, Kawasan Jababeka, Cikarang Bekasi 021-89840590-92','','','2013-04-25',''],
    ['8740','KCP Pantai Indah Kapuk Jln. Pantai Indah Selatan I Blok DF No.1 & 2 Jakarta 021-5881118','','','2013-04-25',''],
    ['8760','KCP Ruko Jababeka Kawasan Industri Jababeka Blok B No.5, Cikarang Bekasi 021-8937055-56','','','2013-04-25',''],
    ['8770','KCP Grand Cempaka Mas Ruko Mega Grosir Cempaka Mas Blok A/5-A/7, Jln.Letjen Suprapto Jakarta 021-4265957-58','','','2013-04-25',''],
    ['8780','KCP Sentral Cikini Jln. Cikini Raya No. 60 T-U Jakarta 021-31908907-09','','','2013-04-25',''],
    ['8790','KCP WTC Mangga Dua Komp. Ruko WTC Mangga Dua, Upper Ground Blok D No. 16, Jln. Mangga Dua Raya No. 8 Jakarta 021-30017777','','','2013-04-25',''],
    ['8800','KCP Pondok Cabe Mutiara Ruko Pondok Cabe Mutiara Blok C/15, Jln. Cabe Raya Ciputat 021-7427135, 74707872-74','','','2013-04-25',''],
    ['8810','KCP Balai Pustaka Jln. Balai Pustaka Timur, Blok J No.225-C/3 Jakarta 021-4704411-12, 4722210','','','2013-04-25',''],
    ['8820','KCP Plaza Merdeka Mas Ruko Plaza Merdeka Mas Blok A1-A2, Jln. Raya Merdeka Tangerang 0','','','2013-04-25',''],
    ['8830','KCP Gading Serpong Summarecon Mal Serpong Unit DGF - 17 B, Lantai Dasar - Down Town Walk Tangerang 021-5461433, 5462877, 5462883, 542','','','2013-04-25',''],
    ['8840','KCP Islamic Karawaci Ruko Dahung Kidul, Jln. Raya Kelapa Dua No. 8 C Tangerang 0','','','2013-04-25',''],
    ['8850','KCP Grand Centre Bekasi Ruko Bekasi Grand Centre Blok A.5, Jln. Cut Mutia Bekasi 021-8809126-27','','','2013-04-25',''],
    ['8870','KCP Meruya Selatan Jln. Meruya Selatan 10 Jakarta 021-5868826-27','','','2013-04-25',''],
    ['8890','KCP Bintan Center Komp. Bintan Bestari, Jln. D.I. Panjaitan Km 9 No. 28-29, Bintan Center Tanjung Pinang 0771-441555','','','2013-04-25',''],
    ['8900','KCP Lagoi Township Center, Shop House No. 302, 302-2, 302-3 Tanjung Pinang 0','','','2013-04-25',''],
    ['8930','KCP Sidareja Jln. A. Yani 40, Sidareja Cilacap 0280-523330, 523340','','','2013-04-25',''],
    ['8990','KCP BSD Sektor I Ruko Pst.Rekreasi Sektor I.3 Blok B No.1,Jln.Griya Loka Raya (BSD) Tangerang 021-5375649-50','','','2013-04-25',''],
]
;
#END SNIPPET id=data
my $data_hash = {};
$data_hash->{$_->[0]} = $_ for @$data;

#BEGIN SNIPPET id=meta
# note: This section is generated by a script. Do not edit manually!
# src-file: /mnt/home/s1/repos/gudangdata/table/bca_branch/meta.yaml
# src-revision: 9224eb536d870734a1760dacf2d6c23b406bfd4d
# revision-date: Thu Apr 25 09:00:40 2013 +0700
# generate-date: Thu Apr 25 09:46:05 2013
# generated-by: /mnt/home/s1/repos/gudangdata/bin/gen-perl-meta-snippet
our $meta = {
  "fields" => {
    address => {
      "index" => 1,
      "schema" => "str*",
      "summary" => "Address",
      "summary.alt.lang.id_ID" => "Alamat",
    },
    city_code => {
      "index" => 3,
      "schema" => "str*",
      "sortable" => 1,
      "summary" => "City code, TBD",
      "summary.alt.lang.id_ID" => "Kode kota",
    },
    city_name => {
      "index" => 2,
      "schema" => "str*",
      "sortable" => 1,
      "summary" => "City name",
      "summary.alt.lang.id_ID" => "Nama kota",
    },
    code => {
      "index" => 0,
      "schema" => ["str*", "match", "^\\d{3,4}\$"],
      "sortable" => 1,
      "summary" => "Code",
      "summary.alt.lang.id_ID" => "Kode",
      "unique" => 1,
    },
    ctime => { index => 4, schema => "str*" },
    note => { index => 5, schema => "str*" },
  },
  "pk" => "code",
  "summary" => "BCA branches",
  "summary.alt.lang.id_ID" => "Kantor cabang BCA",
  "table_aliases.alt.lang.id_ID" => ["kantor_cabang_bca"],
}
;
#END SNIPPET id=meta
my $res = gen_read_table_func(
    name => 'list_bca_branches',
    table_data => $data,
    table_spec => $meta,
    default_fields => 'code',
    #langs => ['en_US', 'id_ID'],
);
die "BUG: Can't generate func: $res->[0] - $res->[1]" unless $res->[0] == 200;

$SPEC{parse_bca_account} = {
    v => 1.1,
    summary => 'Parse/validate BCA account number',
    description => <<'_',

Upon success/valid number, return status 200 with hash containing parsed
information. Upon invalid number, return 400. Parsed information contains these
keys:

- `branch_code`
- `branch_address`
- `branch_city_name` (not yet)
- `branch_city_code` (not yet)
- `account` (10-digits)
- `account_f` (canonically-formatted account number, e.g. 123.456789.0)
- `is_checking` (bool, true if detected as checking account [giro])
- `check_digit`

_
    args => {
        account => {
            schema => 'str*',
            req => 1,
            pos => 0,
        },
        check_known_branches => {
            summary => 'Check branch code against list of known branches',
            schema => [bool => default => 0],
            description => <<'_',

List of known branches

_
        },
    },
};
sub parse_bca_account {
    my %args = @_;

    my $acc = $args{account};
    defined($acc) or return [400, "Please specify account"];
    $acc =~ s/\D+//g;
    length($acc) == 10 or return [400, "Account number must be 10 digits"];

    my $parsed = {account=>$acc};

    my ($branch, $local, $check);
    if ($acc =~ /^[5-9]/) {
        ($branch, $local, $check) = $acc =~ /^(.{4})(.{5})(.)$/;
    } else {
        ($branch, $local, $check) = $acc =~ /^(.{3})(.{6})(.)$/;
    }
    $parsed->{account_f}   = sprintf("%s.%s.%s", $branch, $local, $check);
    $parsed->{branch_code} = $branch;
    $parsed->{check_digit} = $check;

    # XXX validate check digit

    if ($args{check_known_branches}) {
        $data_hash->{$branch} or return [400, "Unknown branch code '$branch'"];
    }
    if (my $bdata = $data_hash->{$branch}) {
        $parsed->{branch_address} = $bdata->[1];
        # XXX city_code, city_name
    }

    if ($local =~ /^1/) {
        $parsed->{is_checking} = 0; # tahapan
    } elsif ($local =~ /^3/) {
        $parsed->{is_checking} = 1; # giro
    }

    [200, "OK", $parsed];
}

#ABSTRACT: Parse/validate BCA account number


__END__
=pod

=encoding utf-8

=head1 NAME

Business::ID::BCA - Parse/validate BCA account number

=head1 VERSION

version 0.01

=head1 SYNOPSIS

 use Business::ID::BCA::Account qw(parse_bca_account);
 my $res = parse_bca_account(account => '6000327555');

=head1 DESCRIPTION

This module parses/validates BCA account number. BCA (Bank Central Asia) is one
of the major banks in Indonesia.

It also contains a routine to list known BCA branches. Data is retrieved from
the Gudang Data project (http://github.com/sharyanto/gudangdata ).

Indonesian keywords: struktur nomor rekening BCA, format rekening BCA, daftar
kode cabang BCA

=head1 BUGS/NOTES

Check digit checking is not implemented yet. Anybody knows the algorithm used?

=head1 AUTHOR

Steven Haryanto <stevenharyanto@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Steven Haryanto.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 FUNCTIONS


None are exported by default, but they are exportable.

=head2 list_bca_branches(%args) -> [status, msg, result, meta]

BCA branches.

REPLACE ME

Data is in table form. Table fields are as follow:

=over

=item *

I<code> (ID field): Code



=item *

I<address>: Address



=item *

I<city_name>: City name



=item *

I<city_code>: City code, TBD



=item *

I<ctime>



=item *

I<note>



=back

Arguments ('*' denotes required arguments):

=over 4

=item * B<address> => I<str>

Only return records where the 'address' field equals specified value.

=item * B<address.contains> => I<str>

Only return records where the 'address' field contains specified text.

=item * B<address.is> => I<str>

Only return records where the 'address' field equals specified value.

=item * B<address.max> => I<str>

Only return records where the 'address' field is less than or equal to specified value.

=item * B<address.min> => I<array>

Only return records where the 'address' field is greater than or equal to specified value.

=item * B<address.not_contains> => I<str>

Only return records where the 'address' field does not contain a certain text.

=item * B<address.xmax> => I<str>

Only return records where the 'address' field is less than specified value.

=item * B<address.xmin> => I<array>

Only return records where the 'address' field is greater than specified value.

=item * B<city_code> => I<str>

Only return records where the 'city_code' field equals specified value.

=item * B<city_code.contains> => I<str>

Only return records where the 'city_code' field contains specified text.

=item * B<city_code.is> => I<str>

Only return records where the 'city_code' field equals specified value.

=item * B<city_code.max> => I<str>

Only return records where the 'city_code' field is less than or equal to specified value.

=item * B<city_code.min> => I<array>

Only return records where the 'city_code' field is greater than or equal to specified value.

=item * B<city_code.not_contains> => I<str>

Only return records where the 'city_code' field does not contain a certain text.

=item * B<city_code.xmax> => I<str>

Only return records where the 'city_code' field is less than specified value.

=item * B<city_code.xmin> => I<array>

Only return records where the 'city_code' field is greater than specified value.

=item * B<city_name> => I<str>

Only return records where the 'city_name' field equals specified value.

=item * B<city_name.contains> => I<str>

Only return records where the 'city_name' field contains specified text.

=item * B<city_name.is> => I<str>

Only return records where the 'city_name' field equals specified value.

=item * B<city_name.max> => I<str>

Only return records where the 'city_name' field is less than or equal to specified value.

=item * B<city_name.min> => I<array>

Only return records where the 'city_name' field is greater than or equal to specified value.

=item * B<city_name.not_contains> => I<str>

Only return records where the 'city_name' field does not contain a certain text.

=item * B<city_name.xmax> => I<str>

Only return records where the 'city_name' field is less than specified value.

=item * B<city_name.xmin> => I<array>

Only return records where the 'city_name' field is greater than specified value.

=item * B<code> => I<str>

Only return records where the 'code' field equals specified value.

=item * B<code.contains> => I<str>

Only return records where the 'code' field contains specified text.

=item * B<code.is> => I<str>

Only return records where the 'code' field equals specified value.

=item * B<code.max> => I<str>

Only return records where the 'code' field is less than or equal to specified value.

=item * B<code.min> => I<array>

Only return records where the 'code' field is greater than or equal to specified value.

=item * B<code.not_contains> => I<str>

Only return records where the 'code' field does not contain a certain text.

=item * B<code.xmax> => I<str>

Only return records where the 'code' field is less than specified value.

=item * B<code.xmin> => I<array>

Only return records where the 'code' field is greater than specified value.

=item * B<ctime> => I<str>

Only return records where the 'ctime' field equals specified value.

=item * B<ctime.contains> => I<str>

Only return records where the 'ctime' field contains specified text.

=item * B<ctime.is> => I<str>

Only return records where the 'ctime' field equals specified value.

=item * B<ctime.max> => I<str>

Only return records where the 'ctime' field is less than or equal to specified value.

=item * B<ctime.min> => I<array>

Only return records where the 'ctime' field is greater than or equal to specified value.

=item * B<ctime.not_contains> => I<str>

Only return records where the 'ctime' field does not contain a certain text.

=item * B<ctime.xmax> => I<str>

Only return records where the 'ctime' field is less than specified value.

=item * B<ctime.xmin> => I<array>

Only return records where the 'ctime' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<fields> => I<array> (default: "code")

Select fields to return.

=item * B<note> => I<str>

Only return records where the 'note' field equals specified value.

=item * B<note.contains> => I<str>

Only return records where the 'note' field contains specified text.

=item * B<note.is> => I<str>

Only return records where the 'note' field equals specified value.

=item * B<note.max> => I<str>

Only return records where the 'note' field is less than or equal to specified value.

=item * B<note.min> => I<array>

Only return records where the 'note' field is greater than or equal to specified value.

=item * B<note.not_contains> => I<str>

Only return records where the 'note' field does not contain a certain text.

=item * B<note.xmax> => I<str>

Only return records where the 'note' field is less than specified value.

=item * B<note.xmin> => I<array>

Only return records where the 'note' field is greater than specified value.

=item * B<q> => I<str>

Search.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<str>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hash/associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).

=back

Return value:

Returns an enveloped result (an array). First element (status) is an integer containing HTTP status code (200 means OK, 4xx caller error, 5xx function error). Second element (msg) is a string containing error message, or 'OK' if status is 200. Third element (result) is optional, the actual result. Fourth element (meta) is called result metadata and is optional, a hash that contains extra information.

=head2 parse_bca_account(%args) -> [status, msg, result, meta]

Parse/validate BCA account number.

Upon success/valid number, return status 200 with hash containing parsed
information. Upon invalid number, return 400. Parsed information contains these
keys:

=over

=item *

C<branch_code>


=item *

C<branch_address>


=item *

C<branch_city_name> (not yet)


=item *

C<branch_city_code> (not yet)


=item *

C<account> (10-digits)


=item *

C<account_f> (canonically-formatted account number, e.g. 123.456789.0)


=item *

C<is_checking> (bool, true if detected as checking account [giro])


=item *

C<check_digit>


=back

Arguments ('*' denotes required arguments):

=over 4

=item * B<account>* => I<str>

=item * B<check_known_branches> => I<bool> (default: 0)

Check branch code against list of known branches.

List of known branches

=back

Return value:

Returns an enveloped result (an array). First element (status) is an integer containing HTTP status code (200 means OK, 4xx caller error, 5xx function error). Second element (msg) is a string containing error message, or 'OK' if status is 200. Third element (result) is optional, the actual result. Fourth element (meta) is called result metadata and is optional, a hash that contains extra information.

=cut

