package Date::Manip::TZ::aulord00;
# Copyright (c) 2008-2010 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:37 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::aulord00 - Support for the Australia/Lord_Howe time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.00";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,10,36,20],'+10:36:20',[10,36,20],
          'LMT',0,[1895,1,31,13,23,39],[1895,1,31,23,59,59] ],
     ],
   1895 =>
     [
        [ [1895,1,31,13,23,40],[1895,1,31,23,23,40],'+10:00:00',[10,0,0],
          'EST',0,[1981,2,28,13,59,59],[1981,2,28,23,59,59] ],
     ],
   1981 =>
     [
        [ [1981,2,28,14,0,0],[1981,3,1,0,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1981,10,24,15,29,59],[1981,10,25,1,59,59] ],
        [ [1981,10,24,15,30,0],[1981,10,25,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1982,3,6,14,29,59],[1982,3,7,1,59,59] ],
     ],
   1982 =>
     [
        [ [1982,3,6,14,30,0],[1982,3,7,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1982,10,30,15,29,59],[1982,10,31,1,59,59] ],
        [ [1982,10,30,15,30,0],[1982,10,31,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1983,3,5,14,29,59],[1983,3,6,1,59,59] ],
     ],
   1983 =>
     [
        [ [1983,3,5,14,30,0],[1983,3,6,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1983,10,29,15,29,59],[1983,10,30,1,59,59] ],
        [ [1983,10,29,15,30,0],[1983,10,30,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1984,3,3,14,29,59],[1984,3,4,1,59,59] ],
     ],
   1984 =>
     [
        [ [1984,3,3,14,30,0],[1984,3,4,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1984,10,27,15,29,59],[1984,10,28,1,59,59] ],
        [ [1984,10,27,15,30,0],[1984,10,28,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1985,3,2,14,29,59],[1985,3,3,1,59,59] ],
     ],
   1985 =>
     [
        [ [1985,3,2,14,30,0],[1985,3,3,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1985,10,26,15,29,59],[1985,10,27,1,59,59] ],
        [ [1985,10,26,15,30,0],[1985,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1986,3,15,14,59,59],[1986,3,16,1,59,59] ],
     ],
   1986 =>
     [
        [ [1986,3,15,15,0,0],[1986,3,16,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1986,10,18,15,29,59],[1986,10,19,1,59,59] ],
        [ [1986,10,18,15,30,0],[1986,10,19,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1987,3,14,14,59,59],[1987,3,15,1,59,59] ],
     ],
   1987 =>
     [
        [ [1987,3,14,15,0,0],[1987,3,15,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1987,10,24,15,29,59],[1987,10,25,1,59,59] ],
        [ [1987,10,24,15,30,0],[1987,10,25,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1988,3,19,14,59,59],[1988,3,20,1,59,59] ],
     ],
   1988 =>
     [
        [ [1988,3,19,15,0,0],[1988,3,20,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1988,10,29,15,29,59],[1988,10,30,1,59,59] ],
        [ [1988,10,29,15,30,0],[1988,10,30,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1989,3,18,14,59,59],[1989,3,19,1,59,59] ],
     ],
   1989 =>
     [
        [ [1989,3,18,15,0,0],[1989,3,19,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1989,10,28,15,29,59],[1989,10,29,1,59,59] ],
        [ [1989,10,28,15,30,0],[1989,10,29,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1990,3,3,14,59,59],[1990,3,4,1,59,59] ],
     ],
   1990 =>
     [
        [ [1990,3,3,15,0,0],[1990,3,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1990,10,27,15,29,59],[1990,10,28,1,59,59] ],
        [ [1990,10,27,15,30,0],[1990,10,28,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1991,3,2,14,59,59],[1991,3,3,1,59,59] ],
     ],
   1991 =>
     [
        [ [1991,3,2,15,0,0],[1991,3,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1991,10,26,15,29,59],[1991,10,27,1,59,59] ],
        [ [1991,10,26,15,30,0],[1991,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1992,2,29,14,59,59],[1992,3,1,1,59,59] ],
     ],
   1992 =>
     [
        [ [1992,2,29,15,0,0],[1992,3,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1992,10,24,15,29,59],[1992,10,25,1,59,59] ],
        [ [1992,10,24,15,30,0],[1992,10,25,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1993,3,6,14,59,59],[1993,3,7,1,59,59] ],
     ],
   1993 =>
     [
        [ [1993,3,6,15,0,0],[1993,3,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1993,10,30,15,29,59],[1993,10,31,1,59,59] ],
        [ [1993,10,30,15,30,0],[1993,10,31,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1994,3,5,14,59,59],[1994,3,6,1,59,59] ],
     ],
   1994 =>
     [
        [ [1994,3,5,15,0,0],[1994,3,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1994,10,29,15,29,59],[1994,10,30,1,59,59] ],
        [ [1994,10,29,15,30,0],[1994,10,30,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1995,3,4,14,59,59],[1995,3,5,1,59,59] ],
     ],
   1995 =>
     [
        [ [1995,3,4,15,0,0],[1995,3,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1995,10,28,15,29,59],[1995,10,29,1,59,59] ],
        [ [1995,10,28,15,30,0],[1995,10,29,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1996,3,30,14,59,59],[1996,3,31,1,59,59] ],
     ],
   1996 =>
     [
        [ [1996,3,30,15,0,0],[1996,3,31,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1996,10,26,15,29,59],[1996,10,27,1,59,59] ],
        [ [1996,10,26,15,30,0],[1996,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1997,3,29,14,59,59],[1997,3,30,1,59,59] ],
     ],
   1997 =>
     [
        [ [1997,3,29,15,0,0],[1997,3,30,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1997,10,25,15,29,59],[1997,10,26,1,59,59] ],
        [ [1997,10,25,15,30,0],[1997,10,26,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1998,3,28,14,59,59],[1998,3,29,1,59,59] ],
     ],
   1998 =>
     [
        [ [1998,3,28,15,0,0],[1998,3,29,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1998,10,24,15,29,59],[1998,10,25,1,59,59] ],
        [ [1998,10,24,15,30,0],[1998,10,25,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1999,3,27,14,59,59],[1999,3,28,1,59,59] ],
     ],
   1999 =>
     [
        [ [1999,3,27,15,0,0],[1999,3,28,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1999,10,30,15,29,59],[1999,10,31,1,59,59] ],
        [ [1999,10,30,15,30,0],[1999,10,31,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2000,3,25,14,59,59],[2000,3,26,1,59,59] ],
     ],
   2000 =>
     [
        [ [2000,3,25,15,0,0],[2000,3,26,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2000,8,26,15,29,59],[2000,8,27,1,59,59] ],
        [ [2000,8,26,15,30,0],[2000,8,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2001,3,24,14,59,59],[2001,3,25,1,59,59] ],
     ],
   2001 =>
     [
        [ [2001,3,24,15,0,0],[2001,3,25,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2001,10,27,15,29,59],[2001,10,28,1,59,59] ],
        [ [2001,10,27,15,30,0],[2001,10,28,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2002,3,30,14,59,59],[2002,3,31,1,59,59] ],
     ],
   2002 =>
     [
        [ [2002,3,30,15,0,0],[2002,3,31,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2002,10,26,15,29,59],[2002,10,27,1,59,59] ],
        [ [2002,10,26,15,30,0],[2002,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2003,3,29,14,59,59],[2003,3,30,1,59,59] ],
     ],
   2003 =>
     [
        [ [2003,3,29,15,0,0],[2003,3,30,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2003,10,25,15,29,59],[2003,10,26,1,59,59] ],
        [ [2003,10,25,15,30,0],[2003,10,26,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2004,3,27,14,59,59],[2004,3,28,1,59,59] ],
     ],
   2004 =>
     [
        [ [2004,3,27,15,0,0],[2004,3,28,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2004,10,30,15,29,59],[2004,10,31,1,59,59] ],
        [ [2004,10,30,15,30,0],[2004,10,31,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2005,3,26,14,59,59],[2005,3,27,1,59,59] ],
     ],
   2005 =>
     [
        [ [2005,3,26,15,0,0],[2005,3,27,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2005,10,29,15,29,59],[2005,10,30,1,59,59] ],
        [ [2005,10,29,15,30,0],[2005,10,30,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2006,4,1,14,59,59],[2006,4,2,1,59,59] ],
     ],
   2006 =>
     [
        [ [2006,4,1,15,0,0],[2006,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2006,10,28,15,29,59],[2006,10,29,1,59,59] ],
        [ [2006,10,28,15,30,0],[2006,10,29,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2007,3,24,14,59,59],[2007,3,25,1,59,59] ],
     ],
   2007 =>
     [
        [ [2007,3,24,15,0,0],[2007,3,25,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2007,10,27,15,29,59],[2007,10,28,1,59,59] ],
        [ [2007,10,27,15,30,0],[2007,10,28,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2008,4,5,14,59,59],[2008,4,6,1,59,59] ],
     ],
   2008 =>
     [
        [ [2008,4,5,15,0,0],[2008,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2008,10,4,15,29,59],[2008,10,5,1,59,59] ],
        [ [2008,10,4,15,30,0],[2008,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2009,4,4,14,59,59],[2009,4,5,1,59,59] ],
     ],
   2009 =>
     [
        [ [2009,4,4,15,0,0],[2009,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2009,10,3,15,29,59],[2009,10,4,1,59,59] ],
        [ [2009,10,3,15,30,0],[2009,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2010,4,3,14,59,59],[2010,4,4,1,59,59] ],
     ],
   2010 =>
     [
        [ [2010,4,3,15,0,0],[2010,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2010,10,2,15,29,59],[2010,10,3,1,59,59] ],
        [ [2010,10,2,15,30,0],[2010,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2011,4,2,14,59,59],[2011,4,3,1,59,59] ],
     ],
   2011 =>
     [
        [ [2011,4,2,15,0,0],[2011,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2011,10,1,15,29,59],[2011,10,2,1,59,59] ],
        [ [2011,10,1,15,30,0],[2011,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2012,3,31,14,59,59],[2012,4,1,1,59,59] ],
     ],
   2012 =>
     [
        [ [2012,3,31,15,0,0],[2012,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2012,10,6,15,29,59],[2012,10,7,1,59,59] ],
        [ [2012,10,6,15,30,0],[2012,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2013,4,6,14,59,59],[2013,4,7,1,59,59] ],
     ],
   2013 =>
     [
        [ [2013,4,6,15,0,0],[2013,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2013,10,5,15,29,59],[2013,10,6,1,59,59] ],
        [ [2013,10,5,15,30,0],[2013,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2014,4,5,14,59,59],[2014,4,6,1,59,59] ],
     ],
   2014 =>
     [
        [ [2014,4,5,15,0,0],[2014,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2014,10,4,15,29,59],[2014,10,5,1,59,59] ],
        [ [2014,10,4,15,30,0],[2014,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2015,4,4,14,59,59],[2015,4,5,1,59,59] ],
     ],
   2015 =>
     [
        [ [2015,4,4,15,0,0],[2015,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2015,10,3,15,29,59],[2015,10,4,1,59,59] ],
        [ [2015,10,3,15,30,0],[2015,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2016,4,2,14,59,59],[2016,4,3,1,59,59] ],
     ],
   2016 =>
     [
        [ [2016,4,2,15,0,0],[2016,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2016,10,1,15,29,59],[2016,10,2,1,59,59] ],
        [ [2016,10,1,15,30,0],[2016,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2017,4,1,14,59,59],[2017,4,2,1,59,59] ],
     ],
   2017 =>
     [
        [ [2017,4,1,15,0,0],[2017,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2017,9,30,15,29,59],[2017,10,1,1,59,59] ],
        [ [2017,9,30,15,30,0],[2017,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2018,3,31,14,59,59],[2018,4,1,1,59,59] ],
     ],
   2018 =>
     [
        [ [2018,3,31,15,0,0],[2018,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2018,10,6,15,29,59],[2018,10,7,1,59,59] ],
        [ [2018,10,6,15,30,0],[2018,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2019,4,6,14,59,59],[2019,4,7,1,59,59] ],
     ],
   2019 =>
     [
        [ [2019,4,6,15,0,0],[2019,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2019,10,5,15,29,59],[2019,10,6,1,59,59] ],
        [ [2019,10,5,15,30,0],[2019,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2020,4,4,14,59,59],[2020,4,5,1,59,59] ],
     ],
   2020 =>
     [
        [ [2020,4,4,15,0,0],[2020,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2020,10,3,15,29,59],[2020,10,4,1,59,59] ],
        [ [2020,10,3,15,30,0],[2020,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2021,4,3,14,59,59],[2021,4,4,1,59,59] ],
     ],
   2021 =>
     [
        [ [2021,4,3,15,0,0],[2021,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2021,10,2,15,29,59],[2021,10,3,1,59,59] ],
        [ [2021,10,2,15,30,0],[2021,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2022,4,2,14,59,59],[2022,4,3,1,59,59] ],
     ],
   2022 =>
     [
        [ [2022,4,2,15,0,0],[2022,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2022,10,1,15,29,59],[2022,10,2,1,59,59] ],
        [ [2022,10,1,15,30,0],[2022,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2023,4,1,14,59,59],[2023,4,2,1,59,59] ],
     ],
   2023 =>
     [
        [ [2023,4,1,15,0,0],[2023,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2023,9,30,15,29,59],[2023,10,1,1,59,59] ],
        [ [2023,9,30,15,30,0],[2023,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2024,4,6,14,59,59],[2024,4,7,1,59,59] ],
     ],
   2024 =>
     [
        [ [2024,4,6,15,0,0],[2024,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2024,10,5,15,29,59],[2024,10,6,1,59,59] ],
        [ [2024,10,5,15,30,0],[2024,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2025,4,5,14,59,59],[2025,4,6,1,59,59] ],
     ],
   2025 =>
     [
        [ [2025,4,5,15,0,0],[2025,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2025,10,4,15,29,59],[2025,10,5,1,59,59] ],
        [ [2025,10,4,15,30,0],[2025,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2026,4,4,14,59,59],[2026,4,5,1,59,59] ],
     ],
   2026 =>
     [
        [ [2026,4,4,15,0,0],[2026,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2026,10,3,15,29,59],[2026,10,4,1,59,59] ],
        [ [2026,10,3,15,30,0],[2026,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2027,4,3,14,59,59],[2027,4,4,1,59,59] ],
     ],
   2027 =>
     [
        [ [2027,4,3,15,0,0],[2027,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2027,10,2,15,29,59],[2027,10,3,1,59,59] ],
        [ [2027,10,2,15,30,0],[2027,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2028,4,1,14,59,59],[2028,4,2,1,59,59] ],
     ],
   2028 =>
     [
        [ [2028,4,1,15,0,0],[2028,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2028,9,30,15,29,59],[2028,10,1,1,59,59] ],
        [ [2028,9,30,15,30,0],[2028,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2029,3,31,14,59,59],[2029,4,1,1,59,59] ],
     ],
   2029 =>
     [
        [ [2029,3,31,15,0,0],[2029,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2029,10,6,15,29,59],[2029,10,7,1,59,59] ],
        [ [2029,10,6,15,30,0],[2029,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2030,4,6,14,59,59],[2030,4,7,1,59,59] ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+11:00:00',
                'stdoff' => '+10:30:00',

               },
   'rules'  => {
                '04' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'LHST',
                        },
                '10' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'LHST',
                        },

               },
);

1;
