package Date::Manip::TZ::afcair00;
# Copyright (c) 2008-2010 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:40 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::afcair00 - Support for the Africa/Cairo time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.00";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,2,5,0],'+02:05:00',[2,5,0],
          'LMT',0,[1900,9,30,21,54,59],[1900,9,30,23,59,59] ],
     ],
   1900 =>
     [
        [ [1900,9,30,21,55,0],[1900,9,30,23,55,0],'+02:00:00',[2,0,0],
          'EET',0,[1940,7,14,21,59,59],[1940,7,14,23,59,59] ],
     ],
   1940 =>
     [
        [ [1940,7,14,22,0,0],[1940,7,15,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1940,9,30,20,59,59],[1940,9,30,23,59,59] ],
        [ [1940,9,30,21,0,0],[1940,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1941,4,14,21,59,59],[1941,4,14,23,59,59] ],
     ],
   1941 =>
     [
        [ [1941,4,14,22,0,0],[1941,4,15,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1941,9,15,20,59,59],[1941,9,15,23,59,59] ],
        [ [1941,9,15,21,0,0],[1941,9,15,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1942,3,31,21,59,59],[1942,3,31,23,59,59] ],
     ],
   1942 =>
     [
        [ [1942,3,31,22,0,0],[1942,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1942,10,26,20,59,59],[1942,10,26,23,59,59] ],
        [ [1942,10,26,21,0,0],[1942,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1943,3,31,21,59,59],[1943,3,31,23,59,59] ],
     ],
   1943 =>
     [
        [ [1943,3,31,22,0,0],[1943,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1943,10,31,20,59,59],[1943,10,31,23,59,59] ],
        [ [1943,10,31,21,0,0],[1943,10,31,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1944,3,31,21,59,59],[1944,3,31,23,59,59] ],
     ],
   1944 =>
     [
        [ [1944,3,31,22,0,0],[1944,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1944,10,31,20,59,59],[1944,10,31,23,59,59] ],
        [ [1944,10,31,21,0,0],[1944,10,31,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1945,4,15,21,59,59],[1945,4,15,23,59,59] ],
     ],
   1945 =>
     [
        [ [1945,4,15,22,0,0],[1945,4,16,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1945,10,31,20,59,59],[1945,10,31,23,59,59] ],
        [ [1945,10,31,21,0,0],[1945,10,31,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1957,5,9,21,59,59],[1957,5,9,23,59,59] ],
     ],
   1957 =>
     [
        [ [1957,5,9,22,0,0],[1957,5,10,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1957,9,30,20,59,59],[1957,9,30,23,59,59] ],
        [ [1957,9,30,21,0,0],[1957,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1958,4,30,21,59,59],[1958,4,30,23,59,59] ],
     ],
   1958 =>
     [
        [ [1958,4,30,22,0,0],[1958,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1958,9,30,20,59,59],[1958,9,30,23,59,59] ],
        [ [1958,9,30,21,0,0],[1958,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1959,4,30,22,59,59],[1959,5,1,0,59,59] ],
     ],
   1959 =>
     [
        [ [1959,4,30,23,0,0],[1959,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1959,9,29,23,59,59],[1959,9,30,2,59,59] ],
        [ [1959,9,30,0,0,0],[1959,9,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1960,4,30,22,59,59],[1960,5,1,0,59,59] ],
     ],
   1960 =>
     [
        [ [1960,4,30,23,0,0],[1960,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1960,9,29,23,59,59],[1960,9,30,2,59,59] ],
        [ [1960,9,30,0,0,0],[1960,9,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1961,4,30,22,59,59],[1961,5,1,0,59,59] ],
     ],
   1961 =>
     [
        [ [1961,4,30,23,0,0],[1961,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1961,9,29,23,59,59],[1961,9,30,2,59,59] ],
        [ [1961,9,30,0,0,0],[1961,9,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1962,4,30,22,59,59],[1962,5,1,0,59,59] ],
     ],
   1962 =>
     [
        [ [1962,4,30,23,0,0],[1962,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1962,9,29,23,59,59],[1962,9,30,2,59,59] ],
        [ [1962,9,30,0,0,0],[1962,9,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1963,4,30,22,59,59],[1963,5,1,0,59,59] ],
     ],
   1963 =>
     [
        [ [1963,4,30,23,0,0],[1963,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1963,9,29,23,59,59],[1963,9,30,2,59,59] ],
        [ [1963,9,30,0,0,0],[1963,9,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1964,4,30,22,59,59],[1964,5,1,0,59,59] ],
     ],
   1964 =>
     [
        [ [1964,4,30,23,0,0],[1964,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1964,9,29,23,59,59],[1964,9,30,2,59,59] ],
        [ [1964,9,30,0,0,0],[1964,9,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1965,4,30,22,59,59],[1965,5,1,0,59,59] ],
     ],
   1965 =>
     [
        [ [1965,4,30,23,0,0],[1965,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1965,9,29,23,59,59],[1965,9,30,2,59,59] ],
        [ [1965,9,30,0,0,0],[1965,9,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1966,4,30,22,59,59],[1966,5,1,0,59,59] ],
     ],
   1966 =>
     [
        [ [1966,4,30,23,0,0],[1966,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1966,9,30,23,59,59],[1966,10,1,2,59,59] ],
        [ [1966,10,1,0,0,0],[1966,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1967,4,30,22,59,59],[1967,5,1,0,59,59] ],
     ],
   1967 =>
     [
        [ [1967,4,30,23,0,0],[1967,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1967,9,30,23,59,59],[1967,10,1,2,59,59] ],
        [ [1967,10,1,0,0,0],[1967,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1968,4,30,22,59,59],[1968,5,1,0,59,59] ],
     ],
   1968 =>
     [
        [ [1968,4,30,23,0,0],[1968,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1968,9,30,23,59,59],[1968,10,1,2,59,59] ],
        [ [1968,10,1,0,0,0],[1968,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1969,4,30,22,59,59],[1969,5,1,0,59,59] ],
     ],
   1969 =>
     [
        [ [1969,4,30,23,0,0],[1969,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1969,9,30,23,59,59],[1969,10,1,2,59,59] ],
        [ [1969,10,1,0,0,0],[1969,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1970,4,30,22,59,59],[1970,5,1,0,59,59] ],
     ],
   1970 =>
     [
        [ [1970,4,30,23,0,0],[1970,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1970,9,30,23,59,59],[1970,10,1,2,59,59] ],
        [ [1970,10,1,0,0,0],[1970,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1971,4,30,22,59,59],[1971,5,1,0,59,59] ],
     ],
   1971 =>
     [
        [ [1971,4,30,23,0,0],[1971,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1971,9,30,23,59,59],[1971,10,1,2,59,59] ],
        [ [1971,10,1,0,0,0],[1971,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1972,4,30,22,59,59],[1972,5,1,0,59,59] ],
     ],
   1972 =>
     [
        [ [1972,4,30,23,0,0],[1972,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1972,9,30,23,59,59],[1972,10,1,2,59,59] ],
        [ [1972,10,1,0,0,0],[1972,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1973,4,30,22,59,59],[1973,5,1,0,59,59] ],
     ],
   1973 =>
     [
        [ [1973,4,30,23,0,0],[1973,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1973,9,30,23,59,59],[1973,10,1,2,59,59] ],
        [ [1973,10,1,0,0,0],[1973,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1974,4,30,22,59,59],[1974,5,1,0,59,59] ],
     ],
   1974 =>
     [
        [ [1974,4,30,23,0,0],[1974,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1974,9,30,23,59,59],[1974,10,1,2,59,59] ],
        [ [1974,10,1,0,0,0],[1974,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1975,4,30,22,59,59],[1975,5,1,0,59,59] ],
     ],
   1975 =>
     [
        [ [1975,4,30,23,0,0],[1975,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1975,9,30,23,59,59],[1975,10,1,2,59,59] ],
        [ [1975,10,1,0,0,0],[1975,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1976,4,30,22,59,59],[1976,5,1,0,59,59] ],
     ],
   1976 =>
     [
        [ [1976,4,30,23,0,0],[1976,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1976,9,30,23,59,59],[1976,10,1,2,59,59] ],
        [ [1976,10,1,0,0,0],[1976,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1977,4,30,22,59,59],[1977,5,1,0,59,59] ],
     ],
   1977 =>
     [
        [ [1977,4,30,23,0,0],[1977,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1977,9,30,23,59,59],[1977,10,1,2,59,59] ],
        [ [1977,10,1,0,0,0],[1977,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1978,4,30,22,59,59],[1978,5,1,0,59,59] ],
     ],
   1978 =>
     [
        [ [1978,4,30,23,0,0],[1978,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1978,9,30,23,59,59],[1978,10,1,2,59,59] ],
        [ [1978,10,1,0,0,0],[1978,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1979,4,30,22,59,59],[1979,5,1,0,59,59] ],
     ],
   1979 =>
     [
        [ [1979,4,30,23,0,0],[1979,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1979,9,30,23,59,59],[1979,10,1,2,59,59] ],
        [ [1979,10,1,0,0,0],[1979,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1980,4,30,22,59,59],[1980,5,1,0,59,59] ],
     ],
   1980 =>
     [
        [ [1980,4,30,23,0,0],[1980,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1980,9,30,23,59,59],[1980,10,1,2,59,59] ],
        [ [1980,10,1,0,0,0],[1980,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1981,4,30,22,59,59],[1981,5,1,0,59,59] ],
     ],
   1981 =>
     [
        [ [1981,4,30,23,0,0],[1981,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1981,9,30,23,59,59],[1981,10,1,2,59,59] ],
        [ [1981,10,1,0,0,0],[1981,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1982,7,24,22,59,59],[1982,7,25,0,59,59] ],
     ],
   1982 =>
     [
        [ [1982,7,24,23,0,0],[1982,7,25,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1982,9,30,23,59,59],[1982,10,1,2,59,59] ],
        [ [1982,10,1,0,0,0],[1982,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1983,7,11,22,59,59],[1983,7,12,0,59,59] ],
     ],
   1983 =>
     [
        [ [1983,7,11,23,0,0],[1983,7,12,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1983,9,30,23,59,59],[1983,10,1,2,59,59] ],
        [ [1983,10,1,0,0,0],[1983,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1984,4,30,22,59,59],[1984,5,1,0,59,59] ],
     ],
   1984 =>
     [
        [ [1984,4,30,23,0,0],[1984,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1984,9,30,23,59,59],[1984,10,1,2,59,59] ],
        [ [1984,10,1,0,0,0],[1984,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1985,4,30,22,59,59],[1985,5,1,0,59,59] ],
     ],
   1985 =>
     [
        [ [1985,4,30,23,0,0],[1985,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1985,9,30,23,59,59],[1985,10,1,2,59,59] ],
        [ [1985,10,1,0,0,0],[1985,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1986,4,30,22,59,59],[1986,5,1,0,59,59] ],
     ],
   1986 =>
     [
        [ [1986,4,30,23,0,0],[1986,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1986,9,30,23,59,59],[1986,10,1,2,59,59] ],
        [ [1986,10,1,0,0,0],[1986,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1987,4,30,22,59,59],[1987,5,1,0,59,59] ],
     ],
   1987 =>
     [
        [ [1987,4,30,23,0,0],[1987,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1987,9,30,23,59,59],[1987,10,1,2,59,59] ],
        [ [1987,10,1,0,0,0],[1987,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1988,4,30,22,59,59],[1988,5,1,0,59,59] ],
     ],
   1988 =>
     [
        [ [1988,4,30,23,0,0],[1988,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1988,9,30,23,59,59],[1988,10,1,2,59,59] ],
        [ [1988,10,1,0,0,0],[1988,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1989,5,5,22,59,59],[1989,5,6,0,59,59] ],
     ],
   1989 =>
     [
        [ [1989,5,5,23,0,0],[1989,5,6,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1989,9,30,23,59,59],[1989,10,1,2,59,59] ],
        [ [1989,10,1,0,0,0],[1989,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1990,4,30,22,59,59],[1990,5,1,0,59,59] ],
     ],
   1990 =>
     [
        [ [1990,4,30,23,0,0],[1990,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1990,9,30,23,59,59],[1990,10,1,2,59,59] ],
        [ [1990,10,1,0,0,0],[1990,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1991,4,30,22,59,59],[1991,5,1,0,59,59] ],
     ],
   1991 =>
     [
        [ [1991,4,30,23,0,0],[1991,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1991,9,30,23,59,59],[1991,10,1,2,59,59] ],
        [ [1991,10,1,0,0,0],[1991,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1992,4,30,22,59,59],[1992,5,1,0,59,59] ],
     ],
   1992 =>
     [
        [ [1992,4,30,23,0,0],[1992,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1992,9,30,23,59,59],[1992,10,1,2,59,59] ],
        [ [1992,10,1,0,0,0],[1992,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1993,4,30,22,59,59],[1993,5,1,0,59,59] ],
     ],
   1993 =>
     [
        [ [1993,4,30,23,0,0],[1993,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1993,9,30,23,59,59],[1993,10,1,2,59,59] ],
        [ [1993,10,1,0,0,0],[1993,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1994,4,30,22,59,59],[1994,5,1,0,59,59] ],
     ],
   1994 =>
     [
        [ [1994,4,30,23,0,0],[1994,5,1,2,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1994,9,30,23,59,59],[1994,10,1,2,59,59] ],
        [ [1994,10,1,0,0,0],[1994,10,1,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1995,4,27,21,59,59],[1995,4,27,23,59,59] ],
     ],
   1995 =>
     [
        [ [1995,4,27,22,0,0],[1995,4,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1995,9,28,20,59,59],[1995,9,28,23,59,59] ],
        [ [1995,9,28,21,0,0],[1995,9,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1996,4,25,21,59,59],[1996,4,25,23,59,59] ],
     ],
   1996 =>
     [
        [ [1996,4,25,22,0,0],[1996,4,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1996,9,26,20,59,59],[1996,9,26,23,59,59] ],
        [ [1996,9,26,21,0,0],[1996,9,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1997,4,24,21,59,59],[1997,4,24,23,59,59] ],
     ],
   1997 =>
     [
        [ [1997,4,24,22,0,0],[1997,4,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1997,9,25,20,59,59],[1997,9,25,23,59,59] ],
        [ [1997,9,25,21,0,0],[1997,9,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1998,4,23,21,59,59],[1998,4,23,23,59,59] ],
     ],
   1998 =>
     [
        [ [1998,4,23,22,0,0],[1998,4,24,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1998,9,24,20,59,59],[1998,9,24,23,59,59] ],
        [ [1998,9,24,21,0,0],[1998,9,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1999,4,29,21,59,59],[1999,4,29,23,59,59] ],
     ],
   1999 =>
     [
        [ [1999,4,29,22,0,0],[1999,4,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1999,9,30,20,59,59],[1999,9,30,23,59,59] ],
        [ [1999,9,30,21,0,0],[1999,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2000,4,27,21,59,59],[2000,4,27,23,59,59] ],
     ],
   2000 =>
     [
        [ [2000,4,27,22,0,0],[2000,4,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2000,9,28,20,59,59],[2000,9,28,23,59,59] ],
        [ [2000,9,28,21,0,0],[2000,9,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2001,4,26,21,59,59],[2001,4,26,23,59,59] ],
     ],
   2001 =>
     [
        [ [2001,4,26,22,0,0],[2001,4,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2001,9,27,20,59,59],[2001,9,27,23,59,59] ],
        [ [2001,9,27,21,0,0],[2001,9,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2002,4,25,21,59,59],[2002,4,25,23,59,59] ],
     ],
   2002 =>
     [
        [ [2002,4,25,22,0,0],[2002,4,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2002,9,26,20,59,59],[2002,9,26,23,59,59] ],
        [ [2002,9,26,21,0,0],[2002,9,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2003,4,24,21,59,59],[2003,4,24,23,59,59] ],
     ],
   2003 =>
     [
        [ [2003,4,24,22,0,0],[2003,4,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2003,9,25,20,59,59],[2003,9,25,23,59,59] ],
        [ [2003,9,25,21,0,0],[2003,9,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2004,4,29,21,59,59],[2004,4,29,23,59,59] ],
     ],
   2004 =>
     [
        [ [2004,4,29,22,0,0],[2004,4,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2004,9,30,20,59,59],[2004,9,30,23,59,59] ],
        [ [2004,9,30,21,0,0],[2004,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2005,4,28,21,59,59],[2005,4,28,23,59,59] ],
     ],
   2005 =>
     [
        [ [2005,4,28,22,0,0],[2005,4,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2005,9,29,20,59,59],[2005,9,29,23,59,59] ],
        [ [2005,9,29,21,0,0],[2005,9,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2006,4,27,21,59,59],[2006,4,27,23,59,59] ],
     ],
   2006 =>
     [
        [ [2006,4,27,22,0,0],[2006,4,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2006,9,21,20,59,59],[2006,9,21,23,59,59] ],
        [ [2006,9,21,21,0,0],[2006,9,21,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2007,4,26,21,59,59],[2007,4,26,23,59,59] ],
     ],
   2007 =>
     [
        [ [2007,4,26,22,0,0],[2007,4,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2007,9,6,20,59,59],[2007,9,6,23,59,59] ],
        [ [2007,9,6,21,0,0],[2007,9,6,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2008,4,24,21,59,59],[2008,4,24,23,59,59] ],
     ],
   2008 =>
     [
        [ [2008,4,24,22,0,0],[2008,4,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2008,8,28,20,59,59],[2008,8,28,23,59,59] ],
        [ [2008,8,28,21,0,0],[2008,8,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2009,4,23,21,59,59],[2009,4,23,23,59,59] ],
     ],
   2009 =>
     [
        [ [2009,4,23,22,0,0],[2009,4,24,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2009,8,20,20,59,59],[2009,8,20,23,59,59] ],
        [ [2009,8,20,21,0,0],[2009,8,20,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2010,4,29,21,59,59],[2010,4,29,23,59,59] ],
     ],
   2010 =>
     [
        [ [2010,4,29,22,0,0],[2010,4,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2010,9,30,20,59,59],[2010,9,30,23,59,59] ],
        [ [2010,9,30,21,0,0],[2010,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2011,4,28,21,59,59],[2011,4,28,23,59,59] ],
     ],
   2011 =>
     [
        [ [2011,4,28,22,0,0],[2011,4,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2011,9,29,20,59,59],[2011,9,29,23,59,59] ],
        [ [2011,9,29,21,0,0],[2011,9,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2012,4,26,21,59,59],[2012,4,26,23,59,59] ],
     ],
   2012 =>
     [
        [ [2012,4,26,22,0,0],[2012,4,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2012,9,27,20,59,59],[2012,9,27,23,59,59] ],
        [ [2012,9,27,21,0,0],[2012,9,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2013,4,25,21,59,59],[2013,4,25,23,59,59] ],
     ],
   2013 =>
     [
        [ [2013,4,25,22,0,0],[2013,4,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2013,9,26,20,59,59],[2013,9,26,23,59,59] ],
        [ [2013,9,26,21,0,0],[2013,9,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2014,4,24,21,59,59],[2014,4,24,23,59,59] ],
     ],
   2014 =>
     [
        [ [2014,4,24,22,0,0],[2014,4,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2014,9,25,20,59,59],[2014,9,25,23,59,59] ],
        [ [2014,9,25,21,0,0],[2014,9,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2015,4,23,21,59,59],[2015,4,23,23,59,59] ],
     ],
   2015 =>
     [
        [ [2015,4,23,22,0,0],[2015,4,24,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2015,9,24,20,59,59],[2015,9,24,23,59,59] ],
        [ [2015,9,24,21,0,0],[2015,9,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2016,4,28,21,59,59],[2016,4,28,23,59,59] ],
     ],
   2016 =>
     [
        [ [2016,4,28,22,0,0],[2016,4,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2016,9,29,20,59,59],[2016,9,29,23,59,59] ],
        [ [2016,9,29,21,0,0],[2016,9,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2017,4,27,21,59,59],[2017,4,27,23,59,59] ],
     ],
   2017 =>
     [
        [ [2017,4,27,22,0,0],[2017,4,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2017,9,28,20,59,59],[2017,9,28,23,59,59] ],
        [ [2017,9,28,21,0,0],[2017,9,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2018,4,26,21,59,59],[2018,4,26,23,59,59] ],
     ],
   2018 =>
     [
        [ [2018,4,26,22,0,0],[2018,4,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2018,9,27,20,59,59],[2018,9,27,23,59,59] ],
        [ [2018,9,27,21,0,0],[2018,9,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2019,4,25,21,59,59],[2019,4,25,23,59,59] ],
     ],
   2019 =>
     [
        [ [2019,4,25,22,0,0],[2019,4,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2019,9,26,20,59,59],[2019,9,26,23,59,59] ],
        [ [2019,9,26,21,0,0],[2019,9,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2020,4,23,21,59,59],[2020,4,23,23,59,59] ],
     ],
   2020 =>
     [
        [ [2020,4,23,22,0,0],[2020,4,24,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2020,9,24,20,59,59],[2020,9,24,23,59,59] ],
        [ [2020,9,24,21,0,0],[2020,9,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2021,4,29,21,59,59],[2021,4,29,23,59,59] ],
     ],
   2021 =>
     [
        [ [2021,4,29,22,0,0],[2021,4,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2021,9,30,20,59,59],[2021,9,30,23,59,59] ],
        [ [2021,9,30,21,0,0],[2021,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2022,4,28,21,59,59],[2022,4,28,23,59,59] ],
     ],
   2022 =>
     [
        [ [2022,4,28,22,0,0],[2022,4,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2022,9,29,20,59,59],[2022,9,29,23,59,59] ],
        [ [2022,9,29,21,0,0],[2022,9,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2023,4,27,21,59,59],[2023,4,27,23,59,59] ],
     ],
   2023 =>
     [
        [ [2023,4,27,22,0,0],[2023,4,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2023,9,28,20,59,59],[2023,9,28,23,59,59] ],
        [ [2023,9,28,21,0,0],[2023,9,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2024,4,25,21,59,59],[2024,4,25,23,59,59] ],
     ],
   2024 =>
     [
        [ [2024,4,25,22,0,0],[2024,4,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2024,9,26,20,59,59],[2024,9,26,23,59,59] ],
        [ [2024,9,26,21,0,0],[2024,9,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2025,4,24,21,59,59],[2025,4,24,23,59,59] ],
     ],
   2025 =>
     [
        [ [2025,4,24,22,0,0],[2025,4,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2025,9,25,20,59,59],[2025,9,25,23,59,59] ],
        [ [2025,9,25,21,0,0],[2025,9,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2026,4,23,21,59,59],[2026,4,23,23,59,59] ],
     ],
   2026 =>
     [
        [ [2026,4,23,22,0,0],[2026,4,24,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2026,9,24,20,59,59],[2026,9,24,23,59,59] ],
        [ [2026,9,24,21,0,0],[2026,9,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2027,4,29,21,59,59],[2027,4,29,23,59,59] ],
     ],
   2027 =>
     [
        [ [2027,4,29,22,0,0],[2027,4,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2027,9,30,20,59,59],[2027,9,30,23,59,59] ],
        [ [2027,9,30,21,0,0],[2027,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2028,4,27,21,59,59],[2028,4,27,23,59,59] ],
     ],
   2028 =>
     [
        [ [2028,4,27,22,0,0],[2028,4,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2028,9,28,20,59,59],[2028,9,28,23,59,59] ],
        [ [2028,9,28,21,0,0],[2028,9,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2029,4,26,21,59,59],[2029,4,26,23,59,59] ],
     ],
   2029 =>
     [
        [ [2029,4,26,22,0,0],[2029,4,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2029,9,27,20,59,59],[2029,9,27,23,59,59] ],
        [ [2029,9,27,21,0,0],[2029,9,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2030,4,25,21,59,59],[2030,4,25,23,59,59] ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+03:00:00',
                'stdoff' => '+02:00:00',

               },
   'rules'  => {
                '04' => {
                         'flag'    => 'last',
                         'dow'     => '5',
                         'num'     => '0',
                         'type'    => 's',
                         'time'    => '00:00:00',
                         'isdst'   => '1',
                         'abb'     => 'EEST',
                        },
                '09' => {
                         'flag'    => 'last',
                         'dow'     => '4',
                         'num'     => '0',
                         'type'    => 's',
                         'time'    => '23:00:00',
                         'isdst'   => '0',
                         'abb'     => 'EET',
                        },

               },
);

1;
