package Date::Manip::TZ::ammont02;
# Copyright (c) 2008-2009 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:34 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::ammont02 - Support for the America/Montevideo time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.00";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,20,15,16],'-03:44:44',[-3,-44,-44],
          'LMT',0,[1898,6,28,3,44,43],[1898,6,27,23,59,59] ],
     ],
   1898 =>
     [
        [ [1898,6,28,3,44,44],[1898,6,28,0,0,0],'-03:44:44',[-3,-44,-44],
          'MMT',0,[1920,5,1,3,44,43],[1920,4,30,23,59,59] ],
     ],
   1920 =>
     [
        [ [1920,5,1,3,44,44],[1920,5,1,0,14,44],'-03:30:00',[-3,-30,0],
          'UYT',0,[1923,10,2,3,29,59],[1923,10,1,23,59,59] ],
     ],
   1923 =>
     [
        [ [1923,10,2,3,30,0],[1923,10,2,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1924,4,1,2,59,59],[1924,3,31,23,59,59] ],
     ],
   1924 =>
     [
        [ [1924,4,1,3,0,0],[1924,3,31,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1924,10,1,3,29,59],[1924,9,30,23,59,59] ],
        [ [1924,10,1,3,30,0],[1924,10,1,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1925,4,1,2,59,59],[1925,3,31,23,59,59] ],
     ],
   1925 =>
     [
        [ [1925,4,1,3,0,0],[1925,3,31,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1925,10,1,3,29,59],[1925,9,30,23,59,59] ],
        [ [1925,10,1,3,30,0],[1925,10,1,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1926,4,1,2,59,59],[1926,3,31,23,59,59] ],
     ],
   1926 =>
     [
        [ [1926,4,1,3,0,0],[1926,3,31,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1933,10,29,3,29,59],[1933,10,28,23,59,59] ],
     ],
   1933 =>
     [
        [ [1933,10,29,3,30,0],[1933,10,29,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1934,4,1,2,59,59],[1934,3,31,23,59,59] ],
     ],
   1934 =>
     [
        [ [1934,4,1,3,0,0],[1934,3,31,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1934,10,28,3,29,59],[1934,10,27,23,59,59] ],
        [ [1934,10,28,3,30,0],[1934,10,28,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1935,3,31,2,59,59],[1935,3,30,23,59,59] ],
     ],
   1935 =>
     [
        [ [1935,3,31,3,0,0],[1935,3,30,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1935,10,27,3,29,59],[1935,10,26,23,59,59] ],
        [ [1935,10,27,3,30,0],[1935,10,27,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1936,3,29,2,59,59],[1936,3,28,23,59,59] ],
     ],
   1936 =>
     [
        [ [1936,3,29,3,0,0],[1936,3,28,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1936,11,1,3,29,59],[1936,10,31,23,59,59] ],
        [ [1936,11,1,3,30,0],[1936,11,1,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1937,3,28,2,59,59],[1937,3,27,23,59,59] ],
     ],
   1937 =>
     [
        [ [1937,3,28,3,0,0],[1937,3,27,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1937,10,31,3,29,59],[1937,10,30,23,59,59] ],
        [ [1937,10,31,3,30,0],[1937,10,31,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1938,3,27,2,59,59],[1938,3,26,23,59,59] ],
     ],
   1938 =>
     [
        [ [1938,3,27,3,0,0],[1938,3,26,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1938,10,30,3,29,59],[1938,10,29,23,59,59] ],
        [ [1938,10,30,3,30,0],[1938,10,30,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1939,3,26,2,59,59],[1939,3,25,23,59,59] ],
     ],
   1939 =>
     [
        [ [1939,3,26,3,0,0],[1939,3,25,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1939,10,29,3,29,59],[1939,10,28,23,59,59] ],
        [ [1939,10,29,3,30,0],[1939,10,29,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1940,3,31,2,59,59],[1940,3,30,23,59,59] ],
     ],
   1940 =>
     [
        [ [1940,3,31,3,0,0],[1940,3,30,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1940,10,27,3,29,59],[1940,10,26,23,59,59] ],
        [ [1940,10,27,3,30,0],[1940,10,27,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1941,3,30,2,59,59],[1941,3,29,23,59,59] ],
     ],
   1941 =>
     [
        [ [1941,3,30,3,0,0],[1941,3,29,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1941,8,1,3,29,59],[1941,7,31,23,59,59] ],
        [ [1941,8,1,3,30,0],[1941,8,1,0,30,0],'-03:00:00',[-3,0,0],
          'UYHST',1,[1942,1,1,2,59,59],[1941,12,31,23,59,59] ],
     ],
   1942 =>
     [
        [ [1942,1,1,3,0,0],[1941,12,31,23,30,0],'-03:30:00',[-3,-30,0],
          'UYT',0,[1942,12,14,3,29,59],[1942,12,13,23,59,59] ],
        [ [1942,12,14,3,30,0],[1942,12,14,1,30,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1943,3,14,1,59,59],[1943,3,13,23,59,59] ],
     ],
   1943 =>
     [
        [ [1943,3,14,2,0,0],[1943,3,13,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1959,5,24,2,59,59],[1959,5,23,23,59,59] ],
     ],
   1959 =>
     [
        [ [1959,5,24,3,0,0],[1959,5,24,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1959,11,15,1,59,59],[1959,11,14,23,59,59] ],
        [ [1959,11,15,2,0,0],[1959,11,14,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1960,1,17,2,59,59],[1960,1,16,23,59,59] ],
     ],
   1960 =>
     [
        [ [1960,1,17,3,0,0],[1960,1,17,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1960,3,6,1,59,59],[1960,3,5,23,59,59] ],
        [ [1960,3,6,2,0,0],[1960,3,5,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1965,4,4,2,59,59],[1965,4,3,23,59,59] ],
     ],
   1965 =>
     [
        [ [1965,4,4,3,0,0],[1965,4,4,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1965,9,26,1,59,59],[1965,9,25,23,59,59] ],
        [ [1965,9,26,2,0,0],[1965,9,25,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1966,4,3,2,59,59],[1966,4,2,23,59,59] ],
     ],
   1966 =>
     [
        [ [1966,4,3,3,0,0],[1966,4,3,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1966,10,31,1,59,59],[1966,10,30,23,59,59] ],
        [ [1966,10,31,2,0,0],[1966,10,30,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1967,4,2,2,59,59],[1967,4,1,23,59,59] ],
     ],
   1967 =>
     [
        [ [1967,4,2,3,0,0],[1967,4,2,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1967,10,31,1,59,59],[1967,10,30,23,59,59] ],
        [ [1967,10,31,2,0,0],[1967,10,30,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1968,5,27,2,59,59],[1968,5,26,23,59,59] ],
     ],
   1968 =>
     [
        [ [1968,5,27,3,0,0],[1968,5,27,0,30,0],'-02:30:00',[-2,-30,0],
          'UYHST',1,[1968,12,2,2,29,59],[1968,12,1,23,59,59] ],
        [ [1968,12,2,2,30,0],[1968,12,1,23,30,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1969,5,27,2,59,59],[1969,5,26,23,59,59] ],
     ],
   1969 =>
     [
        [ [1969,5,27,3,0,0],[1969,5,27,0,30,0],'-02:30:00',[-2,-30,0],
          'UYHST',1,[1969,12,2,2,29,59],[1969,12,1,23,59,59] ],
        [ [1969,12,2,2,30,0],[1969,12,1,23,30,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1970,5,27,2,59,59],[1970,5,26,23,59,59] ],
     ],
   1970 =>
     [
        [ [1970,5,27,3,0,0],[1970,5,27,0,30,0],'-02:30:00',[-2,-30,0],
          'UYHST',1,[1970,12,2,2,29,59],[1970,12,1,23,59,59] ],
        [ [1970,12,2,2,30,0],[1970,12,1,23,30,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1972,4,24,2,59,59],[1972,4,23,23,59,59] ],
     ],
   1972 =>
     [
        [ [1972,4,24,3,0,0],[1972,4,24,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1972,8,15,1,59,59],[1972,8,14,23,59,59] ],
        [ [1972,8,15,2,0,0],[1972,8,14,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1974,3,10,2,59,59],[1974,3,9,23,59,59] ],
     ],
   1974 =>
     [
        [ [1974,3,10,3,0,0],[1974,3,10,0,30,0],'-02:30:00',[-2,-30,0],
          'UYHST',1,[1974,12,22,2,29,59],[1974,12,21,23,59,59] ],
        [ [1974,12,22,2,30,0],[1974,12,22,0,30,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1976,10,1,1,59,59],[1976,9,30,23,59,59] ],
     ],
   1976 =>
     [
        [ [1976,10,1,2,0,0],[1976,9,30,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1977,12,4,2,59,59],[1977,12,3,23,59,59] ],
     ],
   1977 =>
     [
        [ [1977,12,4,3,0,0],[1977,12,4,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1978,4,1,1,59,59],[1978,3,31,23,59,59] ],
     ],
   1978 =>
     [
        [ [1978,4,1,2,0,0],[1978,3,31,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1979,10,1,2,59,59],[1979,9,30,23,59,59] ],
     ],
   1979 =>
     [
        [ [1979,10,1,3,0,0],[1979,10,1,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1980,5,1,1,59,59],[1980,4,30,23,59,59] ],
     ],
   1980 =>
     [
        [ [1980,5,1,2,0,0],[1980,4,30,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1987,12,14,2,59,59],[1987,12,13,23,59,59] ],
     ],
   1987 =>
     [
        [ [1987,12,14,3,0,0],[1987,12,14,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1988,3,14,1,59,59],[1988,3,13,23,59,59] ],
     ],
   1988 =>
     [
        [ [1988,3,14,2,0,0],[1988,3,13,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1988,12,11,2,59,59],[1988,12,10,23,59,59] ],
        [ [1988,12,11,3,0,0],[1988,12,11,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1989,3,12,1,59,59],[1989,3,11,23,59,59] ],
     ],
   1989 =>
     [
        [ [1989,3,12,2,0,0],[1989,3,11,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1989,10,29,2,59,59],[1989,10,28,23,59,59] ],
        [ [1989,10,29,3,0,0],[1989,10,29,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1990,3,4,1,59,59],[1990,3,3,23,59,59] ],
     ],
   1990 =>
     [
        [ [1990,3,4,2,0,0],[1990,3,3,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1990,10,21,2,59,59],[1990,10,20,23,59,59] ],
        [ [1990,10,21,3,0,0],[1990,10,21,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1991,3,3,1,59,59],[1991,3,2,23,59,59] ],
     ],
   1991 =>
     [
        [ [1991,3,3,2,0,0],[1991,3,2,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1991,10,27,2,59,59],[1991,10,26,23,59,59] ],
        [ [1991,10,27,3,0,0],[1991,10,27,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1992,3,1,1,59,59],[1992,2,29,23,59,59] ],
     ],
   1992 =>
     [
        [ [1992,3,1,2,0,0],[1992,2,29,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[1992,10,18,2,59,59],[1992,10,17,23,59,59] ],
        [ [1992,10,18,3,0,0],[1992,10,18,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[1993,2,28,1,59,59],[1993,2,27,23,59,59] ],
     ],
   1993 =>
     [
        [ [1993,2,28,2,0,0],[1993,2,27,23,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2004,9,19,2,59,59],[2004,9,18,23,59,59] ],
     ],
   2004 =>
     [
        [ [2004,9,19,3,0,0],[2004,9,19,1,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2005,3,27,3,59,59],[2005,3,27,1,59,59] ],
     ],
   2005 =>
     [
        [ [2005,3,27,4,0,0],[2005,3,27,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2005,10,9,4,59,59],[2005,10,9,1,59,59] ],
        [ [2005,10,9,5,0,0],[2005,10,9,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2006,3,12,3,59,59],[2006,3,12,1,59,59] ],
     ],
   2006 =>
     [
        [ [2006,3,12,4,0,0],[2006,3,12,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2006,10,1,4,59,59],[2006,10,1,1,59,59] ],
        [ [2006,10,1,5,0,0],[2006,10,1,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2007,3,11,3,59,59],[2007,3,11,1,59,59] ],
     ],
   2007 =>
     [
        [ [2007,3,11,4,0,0],[2007,3,11,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2007,10,7,4,59,59],[2007,10,7,1,59,59] ],
        [ [2007,10,7,5,0,0],[2007,10,7,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2008,3,9,3,59,59],[2008,3,9,1,59,59] ],
     ],
   2008 =>
     [
        [ [2008,3,9,4,0,0],[2008,3,9,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2008,10,5,4,59,59],[2008,10,5,1,59,59] ],
        [ [2008,10,5,5,0,0],[2008,10,5,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2009,3,8,3,59,59],[2009,3,8,1,59,59] ],
     ],
   2009 =>
     [
        [ [2009,3,8,4,0,0],[2009,3,8,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2009,10,4,4,59,59],[2009,10,4,1,59,59] ],
        [ [2009,10,4,5,0,0],[2009,10,4,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2010,3,14,3,59,59],[2010,3,14,1,59,59] ],
     ],
   2010 =>
     [
        [ [2010,3,14,4,0,0],[2010,3,14,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2010,10,3,4,59,59],[2010,10,3,1,59,59] ],
        [ [2010,10,3,5,0,0],[2010,10,3,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2011,3,13,3,59,59],[2011,3,13,1,59,59] ],
     ],
   2011 =>
     [
        [ [2011,3,13,4,0,0],[2011,3,13,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2011,10,2,4,59,59],[2011,10,2,1,59,59] ],
        [ [2011,10,2,5,0,0],[2011,10,2,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2012,3,11,3,59,59],[2012,3,11,1,59,59] ],
     ],
   2012 =>
     [
        [ [2012,3,11,4,0,0],[2012,3,11,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2012,10,7,4,59,59],[2012,10,7,1,59,59] ],
        [ [2012,10,7,5,0,0],[2012,10,7,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2013,3,10,3,59,59],[2013,3,10,1,59,59] ],
     ],
   2013 =>
     [
        [ [2013,3,10,4,0,0],[2013,3,10,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2013,10,6,4,59,59],[2013,10,6,1,59,59] ],
        [ [2013,10,6,5,0,0],[2013,10,6,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2014,3,9,3,59,59],[2014,3,9,1,59,59] ],
     ],
   2014 =>
     [
        [ [2014,3,9,4,0,0],[2014,3,9,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2014,10,5,4,59,59],[2014,10,5,1,59,59] ],
        [ [2014,10,5,5,0,0],[2014,10,5,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2015,3,8,3,59,59],[2015,3,8,1,59,59] ],
     ],
   2015 =>
     [
        [ [2015,3,8,4,0,0],[2015,3,8,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2015,10,4,4,59,59],[2015,10,4,1,59,59] ],
        [ [2015,10,4,5,0,0],[2015,10,4,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2016,3,13,3,59,59],[2016,3,13,1,59,59] ],
     ],
   2016 =>
     [
        [ [2016,3,13,4,0,0],[2016,3,13,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2016,10,2,4,59,59],[2016,10,2,1,59,59] ],
        [ [2016,10,2,5,0,0],[2016,10,2,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2017,3,12,3,59,59],[2017,3,12,1,59,59] ],
     ],
   2017 =>
     [
        [ [2017,3,12,4,0,0],[2017,3,12,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2017,10,1,4,59,59],[2017,10,1,1,59,59] ],
        [ [2017,10,1,5,0,0],[2017,10,1,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2018,3,11,3,59,59],[2018,3,11,1,59,59] ],
     ],
   2018 =>
     [
        [ [2018,3,11,4,0,0],[2018,3,11,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2018,10,7,4,59,59],[2018,10,7,1,59,59] ],
        [ [2018,10,7,5,0,0],[2018,10,7,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2019,3,10,3,59,59],[2019,3,10,1,59,59] ],
     ],
   2019 =>
     [
        [ [2019,3,10,4,0,0],[2019,3,10,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2019,10,6,4,59,59],[2019,10,6,1,59,59] ],
        [ [2019,10,6,5,0,0],[2019,10,6,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2020,3,8,3,59,59],[2020,3,8,1,59,59] ],
     ],
   2020 =>
     [
        [ [2020,3,8,4,0,0],[2020,3,8,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2020,10,4,4,59,59],[2020,10,4,1,59,59] ],
        [ [2020,10,4,5,0,0],[2020,10,4,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2021,3,14,3,59,59],[2021,3,14,1,59,59] ],
     ],
   2021 =>
     [
        [ [2021,3,14,4,0,0],[2021,3,14,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2021,10,3,4,59,59],[2021,10,3,1,59,59] ],
        [ [2021,10,3,5,0,0],[2021,10,3,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2022,3,13,3,59,59],[2022,3,13,1,59,59] ],
     ],
   2022 =>
     [
        [ [2022,3,13,4,0,0],[2022,3,13,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2022,10,2,4,59,59],[2022,10,2,1,59,59] ],
        [ [2022,10,2,5,0,0],[2022,10,2,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2023,3,12,3,59,59],[2023,3,12,1,59,59] ],
     ],
   2023 =>
     [
        [ [2023,3,12,4,0,0],[2023,3,12,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2023,10,1,4,59,59],[2023,10,1,1,59,59] ],
        [ [2023,10,1,5,0,0],[2023,10,1,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2024,3,10,3,59,59],[2024,3,10,1,59,59] ],
     ],
   2024 =>
     [
        [ [2024,3,10,4,0,0],[2024,3,10,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2024,10,6,4,59,59],[2024,10,6,1,59,59] ],
        [ [2024,10,6,5,0,0],[2024,10,6,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2025,3,9,3,59,59],[2025,3,9,1,59,59] ],
     ],
   2025 =>
     [
        [ [2025,3,9,4,0,0],[2025,3,9,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2025,10,5,4,59,59],[2025,10,5,1,59,59] ],
        [ [2025,10,5,5,0,0],[2025,10,5,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2026,3,8,3,59,59],[2026,3,8,1,59,59] ],
     ],
   2026 =>
     [
        [ [2026,3,8,4,0,0],[2026,3,8,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2026,10,4,4,59,59],[2026,10,4,1,59,59] ],
        [ [2026,10,4,5,0,0],[2026,10,4,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2027,3,14,3,59,59],[2027,3,14,1,59,59] ],
     ],
   2027 =>
     [
        [ [2027,3,14,4,0,0],[2027,3,14,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2027,10,3,4,59,59],[2027,10,3,1,59,59] ],
        [ [2027,10,3,5,0,0],[2027,10,3,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2028,3,12,3,59,59],[2028,3,12,1,59,59] ],
     ],
   2028 =>
     [
        [ [2028,3,12,4,0,0],[2028,3,12,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2028,10,1,4,59,59],[2028,10,1,1,59,59] ],
        [ [2028,10,1,5,0,0],[2028,10,1,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2029,3,11,3,59,59],[2029,3,11,1,59,59] ],
     ],
   2029 =>
     [
        [ [2029,3,11,4,0,0],[2029,3,11,1,0,0],'-03:00:00',[-3,0,0],
          'UYT',0,[2029,10,7,4,59,59],[2029,10,7,1,59,59] ],
        [ [2029,10,7,5,0,0],[2029,10,7,3,0,0],'-02:00:00',[-2,0,0],
          'UYST',1,[2030,3,10,3,59,59],[2030,3,10,1,59,59] ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-02:00:00',
                'stdoff' => '-03:00:00',

               },
   'rules'  => {
                '03' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '8',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'UYT',
                        },
                '10' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'UYST',
                        },

               },
);

1;
