#!/usr/bin/python
from urllib import urlencode
import httplib2
import re
import sys
import os
import os.path
import json
import socket
try:
    # For c speedups
    from simplejson import loads, dumps
except ImportError:
    from json import loads, dumps

client_id = sys.argv[1];
http = httplib2.Http(disable_ssl_certificate_validation=True)
http.follow_redirects = False
url = "https://localhost/request?client_id=" + client_id \
      + "&response_type=code&redirect_uri=/cmd"
headers, content = http.request(url, "GET")
code = re.search('code=(\d+)',content)
code = code.group(1)
url = "https://localhost//token?grant_type=authorization_code&client_id=" \
      + client_id + "&redirect_uri=/cmd&code=" + code
headers, content = http.request(url, "GET")
accesstoken = re.search('access_token":(\d+)',content)
accesstoken = accesstoken.group(1);
refreshtoken = re.search('refresh_token":(\d+)',content)
refreshtoken = refreshtoken.group(1);
PATH='credentials.csv'
if os.path.isfile(PATH) and os.access(PATH, os.R_OK):
    print PATH+" exists and is readable"
else:
    print PATH+" is missing or is not readable"
with open(PATH) as f:
    for line in f:
        items=line.split(',');
data = {'cmd': [['aws_configure',items[1],items[2]],
                ['cmd','hostname'],
                ['cwd','/bin'],
                ['cmd_raw','export HELLO=hello'],
                ['cmd','echo $HELLO'],
                ['cmd','pwd'],
                ['cmd','aws ec2 describe-instances']]}
bearer  = "Bearer "+accesstoken
headers = {'Content-Type': 'application/json','Authorization': bearer }
url     = 'https://localhost/cmd'
headers, content = http.request(url, "POST", body=dumps(data), headers=headers)
result = json.loads(content)
result = json.loads(result['result'])
result = json.loads(result[5][0])
myip=([l for l in ([ip for ip in socket.gethostbyname_ex(socket.gethostname())[2] \
     if not ip.startswith("127.")][:1], [[(s.connect(('8.8.8.8', 53)), \
     s.getsockname()[0], s.close()) for s in [socket.socket(socket.AF_INET, \
     socket.SOCK_DGRAM)]][0][1]]) if l][0][0])
for inst in result['Reservations'][0]['Instances']:
   if myip == inst['PrivateIpAddress']:
      print inst['SecurityGroups'][0]['GroupId']
      print inst['PrivateIpAddress']
      print inst['State']['Name']
new_inst = 'aws ec2 run-instances --image-id ami-c229c0a2 --count=1 ' + \
           '--instance-type=t2.micro';
PATH='fullauto.pem'
if os.path.isfile(PATH) and os.access(PATH, os.R_OK):
    print PATH+" exists and is readable"
else:
    print PATH+" is missing or is not readable"
with open(PATH,'rb') as f:
    pemfile = f.read()
print pemfile

# http://mancoosi.org/~abate/upload-file-using-httplib
def upload(url,filename,bearer):
    def encode (file_path, fields=[]):
        BOUNDARY = '----------bundary------'
        CRLF = '\r\n'
        body = []
        # Add the metadata about the upload first
        for key, value in fields:
            body.extend(
              ['--' + BOUNDARY,
               'Content-Disposition: form-data; name="%s"' % key,
               '',
               value,
               ])
        # Now add the file itself
        file_name = os.path.basename(file_path)
        f = open(file_path, 'rb')
        file_content = f.read()
        f.close()
        body.extend(
          ['--' + BOUNDARY,
           'Content-Disposition: form-data; name="file"; filename="%s"'
           % file_name,
           # The upload server determines the mime-type, no need to set it.
           'Content-Type: application/octet-stream',
           '',
           file_content,
           ])
        # Finalize the form body
        body.extend(['--' + BOUNDARY + '--', ''])
        return 'multipart/form-data; boundary=%s' % BOUNDARY, CRLF.join(body)

    if os.path.exists(filename):
        content_type, body = encode(filename)
        headers = { 'Content-Type': content_type,'Authorization': bearer }
        httpx = httplib2.Http(disable_ssl_certificate_validation=True)
        httpx.request(url,'POST', body, headers)

upload(url,'fullauto.pem',bearer)

