/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.40 from the
 * contents of UV.xs. Do not edit this file, edit UV.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "lib/UV.xs"
#define PERL_NO_GET_CONTEXT 1

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#define NEED_newCONSTSUB
#include "ppport.h"

#include <assert.h>
#include <stdlib.h>

#include <uv.h>

#if defined(DEBUG) && DEBUG > 0
 #define DEBUG_PRINT(fmt, args...) fprintf(stderr, "C -- %s:%d:%s(): " fmt, \
    __FILE__, __LINE__, __func__, ##args)
#else
 #define DEBUG_PRINT(fmt, args...) /* Don't do anything in release builds */
#endif

#include "perl-backcompat.h"
#include "uv-backcompat.h"

#ifdef MULTIPLICITY
#  define storeTHX(var)  (var) = aTHX
#  define dTHXfield(var) tTHX var;
#else
#  define storeTHX(var)  dNOOP
#  define dTHXfield(var)
#endif

#if defined(__MINGW32__) || defined(WIN32)
#include <io.h> /* we need _get_osfhandle() on windows */
#  define _MAKE_SOCK(f) (_get_osfhandle(f))
#else
#  define _MAKE_SOCK(f) (f)
#endif

static void loop_walk_cb(uv_handle_t* handle, void* arg)
{
    SV *self;
    SV *cb;

    dTHX;

    if (!handle || !arg) return;
    cb = (SV *)arg;
    if (!cb || !SvOK(cb)) return;

    self = (SV *)(handle->data);

    /* provide info to the caller: invocant, suggested_size */
    dSP;
    ENTER;
    SAVETMPS;

    if (self && SvROK(self)) {
        PUSHMARK(SP);
        EXTEND(SP, 1);
        PUSHs(SvREFCNT_inc(self)); /* invocant */
        PUTBACK;
    }

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

#define do_callback_accessor(var, cb) MY_do_callback_accessor(aTHX_ var, cb)
static SV *MY_do_callback_accessor(pTHX_ SV **var, SV *cb)
{
    if(cb && SvOK(cb)) {
        if(*var)
            SvREFCNT_dec(*var);

        *var = newSVsv(cb);
    }

    if(*var && SvOK(*var))
        return SvREFCNT_inc(*var);
    else
        return &PL_sv_undef;
}

#define newSV_error(err)  MY_newSV_error(aTHX_ err)
static SV *MY_newSV_error(pTHX_ int err)
{
    SV *sv = newSVpv(err ? uv_strerror(err) : "", 0);
    sv_upgrade(sv, SVt_PVIV);
    SvIV_set(sv, err);
    SvIOK_on(sv);

    return sv;
}

static HV *make_errstash(pTHX_ int err)
{
    /* Technically a memory leak within libuv if err is unknown; we should
     * consider using uv_err_name_r()
     */
    SV *name = newSVpvf("UV::Exception::%s::", uv_err_name(err));
    sv_2mortal(name);

    HV *stash = get_hv(SvPVX(name), 0);
    if(stash) return stash;

    stash = get_hv(SvPVX(name), GV_ADD);

    /* push @ISA, "UV::Exception" */
    sv_catpvs(name, "ISA");
    av_push(get_av(SvPVX(name), GV_ADD), newSVpvs_share("UV::Exception"));

    return stash;
}

#define THROWERRSV(sv, err)                                               \
    do {                                                                  \
        SV *msgsv = mess_sv(sv, TRUE);                                    \
        sv_upgrade(msgsv, SVt_PVIV);                                      \
        SvIV_set(msgsv, err); SvIOK_on(msgsv);                            \
        croak_sv(sv_bless(newRV_noinc(msgsv), make_errstash(aTHX_ err))); \
    } while(0)

#define THROWERR(message, err)                                            \
    THROWERRSV(newSVpvf(message " (%d): %s", err, uv_strerror(err)), err)

#define CHECKCALL(call)                                  \
  do {                                                   \
    int err = call;                                      \
    if(err != 0)                                         \
      THROWERRSV(newSVpvf("Couldn't %" HEKf " (%d): %s", \
        HEKfARG(GvNAME_HEK(CvGV(cv))),                   \
        err, uv_strerror(err)), err);                    \
  } while(0)

/**************
 * UV::Handle *
 **************/

#define FIELDS_UV__Handle \
    SV *selfrv;           \
    dTHXfield(perl)       \
    SV *data;             \
    SV *on_close;

typedef struct UV__Handle {
    uv_handle_t *h;
    FIELDS_UV__Handle
} *UV__Handle;

#define NEW_UV__Handle(var, type) \
    Newxc(var, sizeof(*var) + sizeof(type), char, void); \
    var->h = (type *)((char *)var + sizeof(*var));

#define INIT_UV__Handle(handle)  { \
  handle->h->data = handle;        \
  storeTHX(handle->perl);          \
  handle->data     = NULL;         \
  handle->on_close = NULL;         \
}

static void destroy_handle(UV__Handle self);
static void destroy_handle_base(pTHX_ UV__Handle self)
{
    if(self->data)
        SvREFCNT_dec(self->data);
    if(self->on_close)
        SvREFCNT_dec(self->on_close);

    /* No need to destroy self->selfrv because Perl is already destroying
     * it, being the reason we are invoked in the first place
     */

    Safefree(self);
}

static void on_alloc_cb(uv_handle_t *handle, size_t suggested, uv_buf_t *buf)
{
    Newx(buf->base, suggested, char);
    buf->len = suggested;
}

static void on_close_cb(uv_handle_t *handle)
{
    UV__Handle  self;
    SV         *cb;

    if(!handle || !handle->data) return;

    self = handle->data;
    if(!(cb = self->on_close) || !SvOK(cb)) return;

    dTHXa(self->perl);
    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 1);
    mPUSHs(newRV_inc(self->selfrv));
    PUTBACK;

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

static void on_close_then_destroy(uv_handle_t *handle)
{
    on_close_cb(handle);
    destroy_handle(handle->data);
}

/**************
 * UV::Stream *
 **************/

#define FIELDS_UV__Stream \
    SV *on_read;          \
    SV *on_connection;

#define INIT_UV__Stream(stream)  { \
    stream->on_read = NULL;        \
    stream->on_connection = NULL;  \
}

typedef struct UV__Stream {
    uv_stream_t *h;
    FIELDS_UV__Handle
    FIELDS_UV__Stream
} *UV__Stream;

static void destroy_stream(pTHX_ UV__Stream self)
{
    if(self->on_read)
        SvREFCNT_dec(self->on_read);
    if(self->on_connection)
        SvREFCNT_dec(self->on_connection);
}

static void on_read_cb(uv_stream_t *stream, ssize_t nread, const uv_buf_t *buf)
{
    UV__Stream self;
    SV         *cb;

    if(!stream || !stream->data) return;

    self = stream->data;
    if((cb = self->on_read) && SvOK(cb)) {
        dTHXa(self->perl);
        dSP;
        ENTER;
        SAVETMPS;

        PUSHMARK(SP);
        EXTEND(SP, 3);
        mPUSHs(newRV_inc(self->selfrv));
        mPUSHs(nread < 0 ? newSV_error(nread) : &PL_sv_undef);
        if(nread >= 0)
            mPUSHp(buf->base, nread);
        PUTBACK;

        call_sv(cb, G_DISCARD|G_VOID);

        FREETMPS;
        LEAVE;
    }

    if(buf && buf->base)
        Safefree(buf->base);
}

static void on_connection_cb(uv_stream_t *stream, int status)
{
    UV__Stream self;
    SV         *cb;

    if(!stream || !stream->data) return;

    self = stream->data;
    if(!(cb = self->on_connection) || !SvOK(cb)) return;

    dTHXa(self->perl);
    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 2);
    mPUSHs(newRV_inc(self->selfrv));
    mPUSHi(status);
    PUTBACK;

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

/*************
 * UV::Async *
 *************/

typedef struct UV__Async {
    uv_async_t *h;
    FIELDS_UV__Handle
    SV         *on_async;
} *UV__Async;

static void destroy_async(pTHX_ UV__Async self)
{
    if(self->on_async)
        SvREFCNT_dec(self->on_async);
}

static void on_async_cb(uv_async_t *async)
{
    UV__Async self;
    SV        *cb;

    if(!async || !async->data) return;

    self = async->data;
    if(!(cb = self->on_async) || !SvOK(cb)) return;

    dTHXa(self->perl);
    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 1);
    mPUSHs(newRV_inc(self->selfrv));
    PUTBACK;

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

/*************
 * UV::Check *
 *************/

/* See also http://docs.libuv.org/en/v1.x/check.html */

typedef struct UV__Check {
    uv_check_t *h;
    FIELDS_UV__Handle
    SV         *on_check;
} *UV__Check;

static void destroy_check(pTHX_ UV__Check self)
{
    if(self->on_check)
        SvREFCNT_dec(self->on_check);
}

static void on_check_cb(uv_check_t *check)
{
    UV__Check  self;
    SV        *cb;

    if(!check || !check->data) return;

    self = check->data;
    if(!(cb = self->on_check) || !SvOK(cb)) return;

    dTHXa(self->perl);
    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 1);
    mPUSHs(newRV_inc(self->selfrv));
    PUTBACK;

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

/************
 * UV::Idle *
 ************/

/* See also http://docs.libuv.org/en/v1.x/idle.html */

typedef struct UV__Idle {
    uv_idle_t *h;
    FIELDS_UV__Handle
    SV        *on_idle;
} *UV__Idle;

static void destroy_idle(pTHX_ UV__Idle self)
{
    if(self->on_idle)
        SvREFCNT_dec(self->on_idle);
}

static void on_idle_cb(uv_idle_t *idle)
{
    UV__Idle self;
    SV       *cb;

    if(!idle || !idle->data) return;

    self = idle->data;
    if(!(cb = self->on_idle) || !SvOK(cb)) return;

    dTHXa(self->perl);
    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 1);
    mPUSHs(newRV_inc(self->selfrv));
    PUTBACK;

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

/************
 * UV::Pipe *
 ************/

/* See also http://docs.libuv.org/en/v1.x/pipe.html */

typedef struct UV__Pipe {
    uv_pipe_t *h;
    FIELDS_UV__Handle
    FIELDS_UV__Stream
} *UV__Pipe;

static void destroy_pipe(pTHX_ UV__Pipe self)
{
    destroy_stream(aTHX_ (UV__Stream)self);
}

/************
 * UV::Poll *
 ************/

/* See also http://docs.libuv.org/en/v1.x/poll.html */

typedef struct UV__Poll {
    uv_poll_t *h;
    FIELDS_UV__Handle
    SV        *on_poll;
} *UV__Poll;

static void destroy_poll(pTHX_ UV__Poll self)
{
    if(self->on_poll)
        SvREFCNT_dec(self->on_poll);
}

static void on_poll_cb(uv_poll_t *poll, int status, int events)
{
    UV__Poll self;
    SV       *cb;

    if(!poll || !poll->data) return;

    self = poll->data;
    if(!(cb = self->on_poll) || !SvOK(cb)) return;

    dTHXa(self->perl);
    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 3);
    mPUSHs(newRV_inc(self->selfrv));
    mPUSHi(status);
    mPUSHi(events);
    PUTBACK;

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

/***************
 * UV::Prepare *
 ***************/

/* See also http://docs.libuv.org/en/v1.x/prepare.html */

typedef struct UV__Prepare {
    uv_prepare_t *h;
    FIELDS_UV__Handle
    SV           *on_prepare;
} *UV__Prepare;

static void destroy_prepare(pTHX_ UV__Prepare self)
{
    if(self->on_prepare)
        SvREFCNT_dec(self->on_prepare);
}

static void on_prepare_cb(uv_prepare_t *prepare)
{
    UV__Prepare  self;
    SV          *cb;

    if(!prepare || !prepare->data) return;

    self = prepare->data;
    if(!(cb = self->on_prepare) || !SvOK(cb)) return;

    dTHXa(self->perl);
    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 1);
    mPUSHs(newRV_inc(self->selfrv));
    PUTBACK;

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

/* See also http://docs.libuv.org/en/v1.x/process.html */

typedef struct UV__Process {
    uv_process_t *h;
    FIELDS_UV__Handle
    SV           *on_exit;

    /* fields for spawn */
    uv_loop_t *loop;
    uv_process_options_t options;
} *UV__Process;

static void on_exit_cb(uv_process_t *process, int64_t exit_status, int term_signal)
{
    UV__Process self;
    SV          *cb;

    if(!process || !process->data) return;

    self = process->data;
    if(!(cb = self->on_exit) || !SvOK(cb)) return;

    dTHXa(self->perl);
    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 3);
    mPUSHs(newRV_inc(self->selfrv));
    mPUSHi(exit_status);
    mPUSHi(term_signal);
    PUTBACK;

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

/**************
 * UV::Signal *
 **************/

/* See also http://docs.libuv.org/en/v1.x/signal.html */

typedef struct UV__Signal {
    uv_signal_t *h;
    FIELDS_UV__Handle
    int          signum;
    SV          *on_signal;
} *UV__Signal;

static void destroy_signal(pTHX_ UV__Signal self)
{
    if(self->on_signal)
        SvREFCNT_dec(self->on_signal);
}

static void on_signal_cb(uv_signal_t *signal, int signum)
{
    UV__Signal self;
    SV         *cb;

    if(!signal || !signal->data) return;

    self = signal->data;
    if(!(cb = self->on_signal) || !SvOK(cb)) return;

    dTHXa(self->perl);
    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 2);
    mPUSHs(newRV_inc(self->selfrv));
    mPUSHi(signum);
    PUTBACK;

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

/*************
 * UV::Timer *
 *************/

/* See also http://docs.libuv.org/en/v1.x/timer.html */

typedef struct UV__Timer {
    uv_timer_t *h;
    FIELDS_UV__Handle
    SV         *on_timer;
} *UV__Timer;

static void destroy_timer(pTHX_ UV__Timer self)
{
    if(self->on_timer)
        SvREFCNT_dec(self->on_timer);
}

static void on_timer_cb(uv_timer_t *timer)
{
    UV__Timer  self;
    SV        *cb;

    if(!timer || !timer->data) return;

    self = timer->data;
    if(!(cb = self->on_timer) || !SvOK(cb)) return;

    dTHXa(self->perl);
    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 1);
    mPUSHs(newRV_inc(self->selfrv));
    PUTBACK;

    call_sv(cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;
}

/***********
 * UV::TCP *
 ***********/

/* See also http://docs.libuv.org/en/v1.x/tcp.html */

typedef struct UV__TCP {
    uv_tcp_t *h;
    FIELDS_UV__Handle;
    FIELDS_UV__Stream;
} *UV__TCP;

static void destroy_tcp(pTHX_ UV__TCP self)
{
    destroy_stream(aTHX_ (UV__Stream)self);
}

/***********
 * UV::TTY *
 ***********/

/* See also http://docs.libuv.org/en/v1.x/tty.html */

typedef struct UV__TTY {
    uv_tty_t *h;
    FIELDS_UV__Handle
    FIELDS_UV__Stream
} *UV__TTY;

static void destroy_tty(pTHX_ UV__TTY self)
{
    destroy_stream(aTHX_ (UV__Stream)self);
}

/***********
 * UV::UDP *
 ***********/

/* See also http://docs.libuv.org/en/v1.x/udp.html */

typedef struct UV__UDP {
    uv_udp_t *h;
    FIELDS_UV__Handle
    SV       *on_recv;
} *UV__UDP;

static void destroy_udp(pTHX_ UV__UDP self)
{
    if(self->on_recv)
        SvREFCNT_dec(self->on_recv);
}

static void on_recv_cb(uv_udp_t *udp, ssize_t nread, const uv_buf_t *buf, const struct sockaddr *addr, unsigned flags)
{
    UV__UDP self;
    SV      *cb;

    if(!udp || !udp->data) return;

    self = udp->data;
    if((cb = self->on_recv) && SvOK(cb)) {
        size_t addrlen = 0;
        dTHXa(self->perl);
        dSP;

        /* libuv doesn't give us the length of addr; we'll have to guess */
        switch(((struct sockaddr_storage *)addr)->ss_family) {
            case AF_INET:  addrlen = sizeof(struct sockaddr_in);  break;
            case AF_INET6: addrlen = sizeof(struct sockaddr_in6); break;
        }

        ENTER;
        SAVETMPS;

        PUSHMARK(SP);
        EXTEND(SP, 5);
        mPUSHs(newRV_inc(self->selfrv));
        mPUSHs(nread < 0 ? newSV_error(nread) : &PL_sv_undef);
        if(nread >= 0)
            mPUSHp(buf->base, nread);
        else
            PUSHs(&PL_sv_undef);
        mPUSHp((char *)addr, addrlen);
        mPUSHi(flags);
        PUTBACK;

        call_sv(cb, G_DISCARD|G_VOID);

        FREETMPS;
        LEAVE;
    }

    if(buf && buf->base)
        Safefree(buf->base);
}

/* Handle destructor has to be able to see the type-specific destroy_
 * functions above, so must be last
 */

static void destroy_handle(UV__Handle self)
{
    dTHXa(self->perl);

    uv_handle_t *handle = self->h;
    switch(handle->type) {
        case UV_ASYNC:   destroy_async  (aTHX_ (UV__Async)  self); break;
        case UV_CHECK:   destroy_check  (aTHX_ (UV__Check)  self); break;
        case UV_IDLE:    destroy_idle   (aTHX_ (UV__Idle)   self); break;
        case UV_NAMED_PIPE:
                         destroy_pipe   (aTHX_ (UV__Pipe)   self); break;
        case UV_POLL:    destroy_poll   (aTHX_ (UV__Poll)   self); break;
        case UV_PREPARE: destroy_prepare(aTHX_ (UV__Prepare)self); break;
        case UV_SIGNAL:  destroy_signal (aTHX_ (UV__Signal) self); break;
        case UV_TCP:     destroy_tcp    (aTHX_ (UV__TCP)    self); break;
        case UV_TIMER:   destroy_timer  (aTHX_ (UV__Timer)  self); break;
        case UV_TTY:     destroy_tty    (aTHX_ (UV__TTY)    self); break;
        case UV_UDP:     destroy_udp    (aTHX_ (UV__UDP)    self); break;
    }

    destroy_handle_base(aTHX_ self);
}

/***********
 * UV::Req *
 ***********/

#define FIELDS_UV__Req \
    SV *selfrv;        \
    dTHXfield(perl)    \
    SV *cb;

typedef struct UV__Req {
    uv_req_t *r;
    FIELDS_UV__Req
} *UV__Req;

#define NEW_UV__Req(var, type) \
    Newxc(var, sizeof(*var) + sizeof(type), char, void); \
    var->r = (type *)((char *)var + sizeof(*var));

#define INIT_UV__Req(req)  { \
    req->r->data = req;      \
    storeTHX(req->perl);     \
}

static void on_req_cb(uv_req_t *_req, int status)
{
    UV__Req req = _req->data;
    dTHXa(req->perl);

    if(req->cb) {
        dSP;
        ENTER;
        SAVETMPS;

        PUSHMARK(SP);
        EXTEND(SP, 1);
        mPUSHs(newSV_error(status));
        PUTBACK;

        call_sv(req->cb, G_DISCARD|G_VOID);

        FREETMPS;
        LEAVE;
    }

    SvREFCNT_dec(req->selfrv);
}

/* Simple UV::Req subtypes that just invoke a callback with status */

typedef struct UV__Req_connect {
    uv_connect_t *r;
    FIELDS_UV__Req
} *UV__Req_connect;

typedef struct UV__Req_shutdown {
    uv_shutdown_t *r;
    FIELDS_UV__Req
} *UV__Req_shutdown;

typedef struct UV__Req_udp_send {
    uv_udp_send_t *r;
    FIELDS_UV__Req
    char       *s;
} *UV__Req_udp_send;

typedef struct UV__Req_write {
    uv_write_t *r;
    FIELDS_UV__Req
    char       *s;
} *UV__Req_write;

/* See also http://docs.libuv.org/en/v1.x/dns.html#c.uv_getaddrinfo */

typedef struct UV__Req_getaddrinfo {
    uv_getaddrinfo_t *r;
    FIELDS_UV__Req
} *UV__Req_getaddrinfo;

typedef struct UV__getaddrinfo_result {
    int              family;
    int              socktype;
    int              protocol;
    socklen_t        addrlen;
    struct sockaddr *addr;
    char            *canonname;
} *UV__getaddrinfo_result;

static void on_getaddrinfo_cb(uv_getaddrinfo_t *_req, int status, struct addrinfo *res)
{
    UV__Req_getaddrinfo req = _req->data;
    dTHXa(req->perl);

    struct addrinfo *addrp;

    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 1);
    mPUSHs(newSV_error(status));
    for(addrp = res; addrp; addrp = addrp->ai_next) {
        UV__getaddrinfo_result result;
        STRLEN canonnamelen = addrp->ai_canonname ? strlen(addrp->ai_canonname) + 1 : 0;
        Newxc(result, sizeof(*result) + addrp->ai_addrlen + canonnamelen, char, struct UV__getaddrinfo_result);

        result->family   = addrp->ai_family;
        result->socktype = addrp->ai_socktype;
        result->protocol = addrp->ai_protocol;
        result->addrlen  = addrp->ai_addrlen;
        result->addr     = (struct sockaddr *)((char *)result + sizeof(*result));
        Copy(addrp->ai_addr, result->addr, addrp->ai_addrlen, char);
        if(canonnamelen) {
            result->canonname = (char *)result->addr + addrp->ai_addrlen;
            Copy(addrp->ai_canonname, result->canonname, canonnamelen, char);
        }
        else {
            result->canonname = NULL;
        }

        EXTEND(SP, 1);
        PUSHmortal;
        sv_setref_pv(TOPs, "UV::getaddrinfo_result", result);
    }
    PUTBACK;

    call_sv(req->cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;

    uv_freeaddrinfo(res);
    SvREFCNT_dec(req->selfrv);
}

typedef struct UV__Req_getnameinfo {
    uv_getnameinfo_t *r;
    FIELDS_UV__Req
} *UV__Req_getnameinfo;

static void on_getnameinfo_cb(uv_getnameinfo_t *_req, int status, const char *hostname, const char *service)
{
    UV__Req_getnameinfo req = _req->data;
    dTHXa(req->perl);

    dSP;
    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 3);
    mPUSHs(newSV_error(status));
    mPUSHp(hostname, strlen(hostname));
    mPUSHp(service, strlen(service));
    PUTBACK;

    call_sv(req->cb, G_DISCARD|G_VOID);

    FREETMPS;
    LEAVE;

    SvREFCNT_dec(req->selfrv);
}

/************
 * UV::Loop *
 ************/

typedef struct UV__Loop {
    uv_loop_t *loop; /* may point to uv_default_loop() or past this struct */
    SV *on_walk;     /* TODO as yet unused and probably not correct */
} *UV__Loop;

static void on_loop_walk(uv_handle_t* handle, void* arg)
{
    fprintf(stderr, "TODO: on_loop_walk\n");
}

#line 981 "lib/UV.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 1125 "lib/UV.c"

XS_EUPXS(XS_UV_err_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV_err_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "err");
    {
	const char *	RETVAL;
	dXSTARG;
	int	err = (int)SvIV(ST(0))
;

	RETVAL = uv_err_name(err);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV_hrtime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV_hrtime)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	UV	RETVAL;
	dXSTARG;
#line 1149 "lib/UV.xs"
        RETVAL = uv_hrtime();
#line 1157 "lib/UV.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV_strerror); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV_strerror)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "err");
    {
	const char *	RETVAL;
	dXSTARG;
	int	err = (int)SvIV(ST(0))
;

	RETVAL = uv_strerror(err);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV_version)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	unsigned int	RETVAL;
	dXSTARG;

	RETVAL = uv_version();
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV_version_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV_version_string)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const char *	RETVAL;
	dXSTARG;

	RETVAL = uv_version_string();
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Exception_message); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Exception_message)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	SV *	self = ST(0)
;
#line 1164 "lib/UV.xs"
        RETVAL = newSV(0);
        sv_copypv(RETVAL, SvRV(self));
#line 1230 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Exception_code); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Exception_code)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	SV *	self = ST(0)
;
#line 1172 "lib/UV.xs"
        RETVAL = SvIV(SvRV(self));
#line 1251 "lib/UV.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Handle_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Handle_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Handle	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Handle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"UV::Handle::DESTROY",
			"self")
;
#line 1181 "lib/UV.xs"
        /* TODO:
            $self->stop() if ($self->can('stop') && !$self->closing() && !$self->closed());
         */
        if(!uv_is_closing(self->h))
            uv_close(self->h, on_close_then_destroy);
        else
            destroy_handle(self);
#line 1284 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Handle_closed); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Handle_closed)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	bool	RETVAL;
	UV__Handle	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Handle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Handle::closed",
			"self", "UV::Handle")
;
#line 1192 "lib/UV.xs"
        RETVAL = 0;
#line 1311 "lib/UV.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Handle_closing); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Handle_closing)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	bool	RETVAL;
	UV__Handle	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Handle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Handle::closing",
			"self", "UV::Handle")
;
#line 1199 "lib/UV.xs"
        RETVAL = uv_is_closing(self->h);
#line 1339 "lib/UV.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Handle_active); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Handle_active)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	bool	RETVAL;
	UV__Handle	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Handle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Handle::active",
			"self", "UV::Handle")
;
#line 1206 "lib/UV.xs"
        RETVAL = uv_is_active(self->h);
#line 1367 "lib/UV.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Handle_loop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Handle_loop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	UV__Handle	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Handle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Handle::loop",
			"self", "UV::Handle")
;
#line 1213 "lib/UV.xs"
        UV__Loop loop;
#line 1395 "lib/UV.c"
#line 1215 "lib/UV.xs"
        Newx(loop, 1, struct UV__Loop);
        loop->loop = self->h->loop;
        loop->on_walk = NULL; /* this is a mess */

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Loop", loop);
#line 1403 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Handle_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Handle_data)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, data= NULL");
    {
	SV *	RETVAL;
	UV__Handle	self;
	SV *	data;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Handle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Handle::data",
			"self", "UV::Handle")
;

	if (items < 2)
	    data = NULL;
	else {
	    data = ST(1)
;
	}
#line 1227 "lib/UV.xs"
        if(items > 1) {
            if(self->data)
                SvREFCNT_dec(self->data);
            self->data = newSVsv(data);
        }
        RETVAL = self->data ? newSVsv(self->data) : &PL_sv_undef;
#line 1445 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Handle__close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Handle__close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Handle	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Handle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Handle::_close",
			"self", "UV::Handle")
;
#line 1239 "lib/UV.xs"
        uv_close(self->h, on_close_cb);
#line 1473 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Handle__on_close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Handle__on_close)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Handle	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Handle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Handle::_on_close",
			"self", "UV::Handle")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1244 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_close, cb);
#line 1508 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Async__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Async__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, loop");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Async::_new",
			"loop", "UV::Loop")
;
#line 1253 "lib/UV.xs"
        UV__Async self;
        int err;
#line 1540 "lib/UV.c"
#line 1256 "lib/UV.xs"
        NEW_UV__Handle(self, uv_async_t);

        err = uv_async_init(loop->loop, self->h, &on_async_cb);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialise async handle", err);
        }

        INIT_UV__Handle(self);
        self->on_async = NULL;

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Async", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 1556 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Async__on_async); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Async__on_async)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Async	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Async")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Async,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Async::_on_async",
			"self", "UV::Async")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1276 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_async, cb);
#line 1593 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Async_send); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Async_send)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Async	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Async")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Async,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Async::send",
			"self", "UV::Async")
;
#line 1283 "lib/UV.xs"
        CHECKCALL(uv_async_send(self->h));
#line 1621 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Check__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Check__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, loop");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Check::_new",
			"loop", "UV::Loop")
;
#line 1290 "lib/UV.xs"
        UV__Check self;
        int err;
#line 1651 "lib/UV.c"
#line 1293 "lib/UV.xs"
        NEW_UV__Handle(self, uv_check_t);

        err = uv_check_init(loop->loop, self->h);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialise check handle", err);
        }

        INIT_UV__Handle(self);
        self->on_check = NULL;

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Check", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 1667 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Check__on_check); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Check__on_check)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Check	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Check")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Check,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Check::_on_check",
			"self", "UV::Check")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1313 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_check, cb);
#line 1704 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Check__start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Check__start)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Check	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Check")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Check,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Check::_start",
			"self", "UV::Check")
;
#line 1320 "lib/UV.xs"
        CHECKCALL(uv_check_start(self->h, on_check_cb));
#line 1732 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Check_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Check_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Check	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Check")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Check,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Check::stop",
			"self", "UV::Check")
;
#line 1325 "lib/UV.xs"
        CHECKCALL(uv_check_stop(self->h));
#line 1758 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Idle__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Idle__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, loop");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Idle::_new",
			"loop", "UV::Loop")
;
#line 1332 "lib/UV.xs"
        UV__Idle self;
        int err;
#line 1788 "lib/UV.c"
#line 1335 "lib/UV.xs"
        NEW_UV__Handle(self, uv_idle_t);

        err = uv_idle_init(loop->loop, self->h);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialise idle handle", err);
        }

        INIT_UV__Handle(self);
        self->on_idle = NULL;

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Idle", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 1804 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Idle__on_idle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Idle__on_idle)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Idle	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Idle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Idle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Idle::_on_idle",
			"self", "UV::Idle")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1355 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_idle, cb);
#line 1841 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Idle__start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Idle__start)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Idle	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Idle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Idle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Idle::_start",
			"self", "UV::Idle")
;
#line 1362 "lib/UV.xs"
        CHECKCALL(uv_idle_start(self->h, on_idle_cb));
#line 1869 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Idle_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Idle_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Idle	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Idle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Idle,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Idle::stop",
			"self", "UV::Idle")
;
#line 1367 "lib/UV.xs"
        CHECKCALL(uv_idle_stop(self->h));
#line 1895 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Pipe__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Pipe__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, loop");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Pipe::_new",
			"loop", "UV::Loop")
;
#line 1374 "lib/UV.xs"
        UV__Pipe self;
        int err;
#line 1925 "lib/UV.c"
#line 1377 "lib/UV.xs"
        NEW_UV__Handle(self, uv_pipe_t);

        err = uv_pipe_init(loop->loop, self->h, 0);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialse pipe handle", err);
        }

        INIT_UV__Handle(self);
        INIT_UV__Stream(self);

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Pipe", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 1941 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Pipe__open); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Pipe__open)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, fd");
    {
	UV__Pipe	self;
	int	fd = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Pipe")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Pipe,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Pipe::_open",
			"self", "UV::Pipe")
;
#line 1397 "lib/UV.xs"
        CHECKCALL(uv_pipe_open(self->h, fd));
#line 1971 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Pipe_bind); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Pipe_bind)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, name");
    {
	UV__Pipe	self;
	char *	name = (char *)SvPV_nolen(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Pipe")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Pipe,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Pipe::bind",
			"self", "UV::Pipe")
;
#line 1402 "lib/UV.xs"
        CHECKCALL(uv_pipe_bind(self->h, name));
#line 1999 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Pipe_connect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Pipe_connect)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, path, cb");
    {
	SV *	RETVAL;
	UV__Pipe	self;
	char *	path = (char *)SvPV_nolen(ST(1))
;
	SV *	cb = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Pipe")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Pipe,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Pipe::connect",
			"self", "UV::Pipe")
;
#line 1407 "lib/UV.xs"
        UV__Req_connect req;
#line 2030 "lib/UV.c"
#line 1409 "lib/UV.xs"
        NEW_UV__Req(req, uv_connect_t);
        INIT_UV__Req(req);

        uv_pipe_connect(req->r, self->h, path, (uv_connect_cb)on_req_cb);

        req->cb = newSVsv(cb);

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Req", req);
        req->selfrv = SvREFCNT_inc(SvRV(RETVAL));
#line 2042 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Pipe_getpeername); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Pipe_getpeername)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	UV__Pipe	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Pipe")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Pipe,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			GvNAME(CvGV(cv)),
			"self", "UV::Pipe")
;
#line 1428 "lib/UV.xs"
        size_t len;
        int err;
#line 2073 "lib/UV.c"
#line 1431 "lib/UV.xs"
        RETVAL = newSV(256);
        len = SvLEN(RETVAL);

        err = (ix == 0) ?
            uv_pipe_getpeername(self->h, SvPVX(RETVAL), &len) :
            uv_pipe_getsockname(self->h, SvPVX(RETVAL), &len);
        if(err != 0) {
            SvREFCNT_dec(RETVAL);
            croak("Couldn't %s from pipe handle (%d): %s", (ix == 0) ? "getpeername" : "getsockname",
                err, uv_strerror(err));
        }

        SvCUR_set(RETVAL, len);
        SvPOK_on(RETVAL);
#line 2089 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Pipe_chmod); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Pipe_chmod)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, flags");
    {
	UV__Pipe	self;
	int	flags = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Pipe")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Pipe,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Pipe::chmod",
			"self", "UV::Pipe")
;
#line 1451 "lib/UV.xs"
        CHECKCALL(uv_pipe_chmod(self->h, flags));
#line 2119 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Poll__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Poll__new)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, loop, fd, is_socket");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;
	int	fd = (int)SvIV(ST(2))
;
	bool	is_socket = (bool)SvTRUE(ST(3))
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Poll::_new",
			"loop", "UV::Loop")
;
#line 1458 "lib/UV.xs"
        UV__Poll self;
        int err;
#line 2153 "lib/UV.c"
#line 1461 "lib/UV.xs"
        NEW_UV__Handle(self, uv_poll_t);

        if(is_socket)
            err = uv_poll_init_socket(loop->loop, self->h, _MAKE_SOCK(fd));
        else
            err = uv_poll_init(loop->loop, self->h, fd);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialise poll handle", err);
        }

        INIT_UV__Handle(self);
        self->on_poll = NULL;

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Poll", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 2172 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Poll__on_poll); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Poll__on_poll)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Poll	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Poll")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Poll,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Poll::_on_poll",
			"self", "UV::Poll")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1484 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_poll, cb);
#line 2209 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Poll__start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Poll__start)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, events= UV_READABLE");
    {
	UV__Poll	self;
	int	events;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Poll")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Poll,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Poll::_start",
			"self", "UV::Poll")
;

	if (items < 2)
	    events = UV_READABLE;
	else {
	    events = (int)SvIV(ST(1))
;
	}
#line 1491 "lib/UV.xs"
        CHECKCALL(uv_poll_start(self->h, events, on_poll_cb));
#line 2245 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Poll_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Poll_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Poll	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Poll")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Poll,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Poll::stop",
			"self", "UV::Poll")
;
#line 1496 "lib/UV.xs"
        CHECKCALL(uv_poll_stop(self->h));
#line 2271 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Prepare__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Prepare__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, loop");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Prepare::_new",
			"loop", "UV::Loop")
;
#line 1503 "lib/UV.xs"
        UV__Prepare self;
        int err;
#line 2301 "lib/UV.c"
#line 1506 "lib/UV.xs"
        NEW_UV__Handle(self, uv_prepare_t);

        err = uv_prepare_init(loop->loop, self->h);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialise prepare handle", err);
        }

        INIT_UV__Handle(self);
        self->on_prepare = NULL;

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Prepare", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 2317 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Prepare__on_prepare); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Prepare__on_prepare)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Prepare	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Prepare")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Prepare,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Prepare::_on_prepare",
			"self", "UV::Prepare")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1526 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_prepare, cb);
#line 2354 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Prepare__start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Prepare__start)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Prepare	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Prepare")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Prepare,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Prepare::_start",
			"self", "UV::Prepare")
;
#line 1533 "lib/UV.xs"
        CHECKCALL(uv_prepare_start(self->h, on_prepare_cb));
#line 2382 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Prepare_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Prepare_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Prepare	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Prepare")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Prepare,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Prepare::stop",
			"self", "UV::Prepare")
;
#line 1538 "lib/UV.xs"
        CHECKCALL(uv_prepare_stop(self->h));
#line 2408 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Process__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, loop");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::_new",
			"loop", "UV::Loop")
;
#line 1545 "lib/UV.xs"
        UV__Process self;
        int err;
#line 2438 "lib/UV.c"
#line 1548 "lib/UV.xs"
        NEW_UV__Handle(self, uv_process_t);
        self->loop = loop->loop;

        Zero(&self->options, 1, uv_process_options_t);

        self->options.exit_cb = &on_exit_cb;

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Process", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 2450 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Process__on_exit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process__on_exit)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Process	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Process")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Process,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::_on_exit",
			"self", "UV::Process")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1564 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_exit, cb);
#line 2487 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Process__set_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process__set_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, file");
    {
	UV__Process	self;
	char *	file = (char *)SvPV_nolen(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Process")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Process,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::_set_file",
			"self", "UV::Process")
;
#line 1571 "lib/UV.xs"
        self->options.file = savepv(file);
#line 2517 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Process__set_args); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process__set_args)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, args");
    {
	UV__Process	self;
	SV *	args = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Process")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Process,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::_set_args",
			"self", "UV::Process")
;
#line 1576 "lib/UV.xs"
        AV *argsav;
        U32 i;
#line 2546 "lib/UV.c"
#line 1579 "lib/UV.xs"
        if(!SvROK(args) || SvTYPE(SvRV(args)) != SVt_PVAV)
            croak("Expected args as ARRAY reference");

        argsav = (AV *)SvRV(args);

        Newx(self->options.args, AvFILL(argsav) + 3, char *);
        self->options.args[0] = NULL;
        for(i = 0; i <= AvFILL(argsav); i++)
            self->options.args[i+1] = savepv(SvPVbyte_nolen(AvARRAY(argsav)[i]));
        self->options.args[i+1] = NULL;
#line 2558 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Process__set_env); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process__set_env)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, env");
    {
	UV__Process	self;
	SV *	env = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Process")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Process,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::_set_env",
			"self", "UV::Process")
;
#line 1593 "lib/UV.xs"
        HV *envhv;
        I32 nkeys, i, dummy;
        HE *iter;
        SV *tmp;
#line 2589 "lib/UV.c"
#line 1598 "lib/UV.xs"
        if(!SvROK(env) || SvTYPE(SvRV(env)) != SVt_PVHV)
            croak("Expected env as HASH reference");

        envhv = (HV *)SvRV(env);
        nkeys = hv_iterinit(envhv);

        Newx(self->options.env, nkeys + 1, char *);
        tmp = sv_newmortal();

        i = 0;
        while((iter = hv_iternext(envhv))) {
            sv_setpvf(tmp, "%s=%s",
                hv_iterkey(iter, &dummy), SvPVbyte_nolen(HeVAL(iter)));

            self->options.env[i++] = SvPVX(tmp);
            SvPVX(tmp) = NULL;
            SvLEN(tmp) = 0;
        }
        self->options.env[i] = NULL;
#line 2610 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Process__set_stdio_h); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process__set_stdio_h)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, fd, arg");
    {
	UV__Process	self;
	int	fd = (int)SvIV(ST(1))
;
	SV *	arg = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Process")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Process,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::_set_stdio_h",
			"self", "UV::Process")
;
#line 1621 "lib/UV.xs"
        uv_stdio_container_t *cont;
        int flags = 0;
        SV *fdarg = arg;
#line 2642 "lib/UV.c"
#line 1625 "lib/UV.xs"
        if(self->options.stdio_count < (fd+1)) {
            int n = self->options.stdio_count;
            if(n < (fd+1)) n = (fd+1);
            if(n < 3)      n = 3;

            Renew(self->options.stdio, n, uv_stdio_container_t);
            int i;
            for(i = self->options.stdio_count; i < n; i++)
                self->options.stdio[i].flags = UV_IGNORE;

            self->options.stdio_count = n;
        }

        cont = self->options.stdio + fd;

        if(SvROK(arg) && SvTYPE(SvRV(arg)) == SVt_PVHV) {
            fprintf(stderr, "TODO: grab extra values from hash\n");
        }

        if(!SvROK(fdarg)) {
            /* FD by stream number */
            cont->data.fd = SvIV(arg);
            flags |= UV_INHERIT_FD;
        }
        else if(SvTYPE(SvRV(fdarg)) == SVt_PVGV) {
            /* FD by globref */
            cont->data.fd = PerlIO_fileno(IoOFP(GvIO(SvRV(fdarg))));
            flags |= UV_INHERIT_FD;
        }
        else {
            croak("Unsure what to do with _set_stdio_h fd argument %" SVf, SVfARG(arg));
        }

        cont->flags = flags;
#line 2678 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Process__set_setuid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process__set_setuid)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, uid");
    {
	UV__Process	self;
	int	uid = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Process")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Process,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::_set_setuid",
			"self", "UV::Process")
;
#line 1663 "lib/UV.xs"
        self->options.flags |= UV_PROCESS_SETUID;
        self->options.uid = uid;
#line 2707 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Process__set_setgid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process__set_setgid)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, gid");
    {
	UV__Process	self;
	int	gid = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Process")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Process,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::_set_setgid",
			"self", "UV::Process")
;
#line 1669 "lib/UV.xs"
        self->options.flags |= UV_PROCESS_SETGID;
        self->options.uid = gid;
#line 2736 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Process__spawn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process__spawn)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Process	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Process")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Process,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::_spawn",
			"self", "UV::Process")
;
#line 1676 "lib/UV.xs"
        int err;
#line 2762 "lib/UV.c"
#line 1678 "lib/UV.xs"
        if(!self->options.file)
            croak("Require 'file' to spawn a UV::Process");
        if(!self->options.args)
            croak("Require 'args' to spawn a UV::Process");

        if(!self->options.args[0])
            self->options.args[0] = savepv(self->options.file);

        err = uv_spawn(self->loop, self->h, &self->options);
        if (err != 0) {
            THROWERR("Couldn't spawn process", err);
        }

        INIT_UV__Handle(self);
#line 2778 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Process_kill); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process_kill)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, signum");
    {
	UV__Process	self;
	int	signum = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Process")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Process,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::kill",
			"self", "UV::Process")
;
#line 1696 "lib/UV.xs"
        CHECKCALL(uv_process_kill(self->h, signum));
#line 2806 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Process_pid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Process_pid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	UV__Process	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Process")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Process,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Process::pid",
			"self", "UV::Process")
;
#line 1701 "lib/UV.xs"
        RETVAL = self->h->pid;
#line 2834 "lib/UV.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Signal__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Signal__new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "class, loop, signum");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;
	int	signum = (int)SvIV(ST(2))
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Signal::_new",
			"loop", "UV::Loop")
;
#line 1710 "lib/UV.xs"
        UV__Signal self;
        int err;
#line 2867 "lib/UV.c"
#line 1713 "lib/UV.xs"
        NEW_UV__Handle(self, uv_signal_t);

        err = uv_signal_init(loop->loop, self->h);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialise signal handle", err);
        }

        INIT_UV__Handle(self);
        self->signum = signum; /* need to remember this until start() time */
        self->on_signal = NULL;

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Signal", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 2884 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Signal__on_signal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Signal__on_signal)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Signal	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Signal")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Signal,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Signal::_on_signal",
			"self", "UV::Signal")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1734 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_signal, cb);
#line 2921 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Signal__start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Signal__start)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Signal	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Signal")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Signal,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Signal::_start",
			"self", "UV::Signal")
;
#line 1741 "lib/UV.xs"
        CHECKCALL(uv_signal_start(self->h, on_signal_cb, self->signum));
#line 2949 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Signal_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Signal_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Signal	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Signal")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Signal,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Signal::stop",
			"self", "UV::Signal")
;
#line 1746 "lib/UV.xs"
        CHECKCALL(uv_signal_stop(self->h));
#line 2975 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Stream__on_read); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Stream__on_read)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Stream	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Stream,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Stream::_on_read",
			"self", "UV::Stream")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1753 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_read, cb);
#line 3010 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Stream__on_connection); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Stream__on_connection)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Stream	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Stream,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Stream::_on_connection",
			"self", "UV::Stream")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1760 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_connection, cb);
#line 3047 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Stream__listen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Stream__listen)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, backlog");
    {
	UV__Stream	self;
	int	backlog = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Stream,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Stream::_listen",
			"self", "UV::Stream")
;
#line 1767 "lib/UV.xs"
        CHECKCALL(uv_listen(self->h, backlog, on_connection_cb));
#line 3077 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Stream__accept); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Stream__accept)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, client");
    {
	UV__Stream	self;
	UV__Stream	client;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Stream,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Stream::_accept",
			"self", "UV::Stream")
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    client = INT2PTR(UV__Stream,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Stream::_accept",
			"client", "UV::Stream")
;
#line 1772 "lib/UV.xs"
        CHECKCALL(uv_accept(self->h, client->h));
#line 3114 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Stream_shutdown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Stream_shutdown)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, cb");
    {
	SV *	RETVAL;
	UV__Stream	self;
	SV *	cb = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Stream,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Stream::shutdown",
			"self", "UV::Stream")
;
#line 1777 "lib/UV.xs"
        UV__Req_shutdown req;
        int err;
#line 3144 "lib/UV.c"
#line 1780 "lib/UV.xs"
        NEW_UV__Req(req, uv_shutdown_t);
        INIT_UV__Req(req);

        err = uv_shutdown(req->r, self->h, (uv_shutdown_cb)on_req_cb);

        if(err != 0) {
            Safefree(req);
            THROWERR("Couldn't shutdown", err);
        }

        req->cb = newSVsv(cb);

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Req", req);
        req->selfrv = SvREFCNT_inc(SvRV(RETVAL));
#line 3161 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Stream_read_start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Stream_read_start)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Stream	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Stream,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Stream::read_start",
			"self", "UV::Stream")
;
#line 1801 "lib/UV.xs"
        CHECKCALL(uv_read_start(self->h, on_alloc_cb, on_read_cb));
#line 3189 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Stream_read_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Stream_read_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Stream	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Stream,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Stream::read_stop",
			"self", "UV::Stream")
;
#line 1806 "lib/UV.xs"
        CHECKCALL(uv_read_stop(self->h));
#line 3215 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Stream_write); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Stream_write)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, s, cb");
    {
	SV *	RETVAL;
	UV__Stream	self;
	SV *	s = ST(1)
;
	SV *	cb = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Stream,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Stream::write",
			"self", "UV::Stream")
;
#line 1811 "lib/UV.xs"
        UV__Req_write req;
        uv_buf_t buf[1];
        int err;
#line 3248 "lib/UV.c"
#line 1815 "lib/UV.xs"
        NEW_UV__Req(req, uv_write_t);
        INIT_UV__Req(req);

        buf[0].len  = SvCUR(s);
        buf[0].base = savepvn(SvPVX(s), buf[0].len);

        req->s = buf[0].base;

        err = uv_write(req->r, self->h, buf, 1, (uv_write_cb)on_req_cb);

        if(err != 0) {
            Safefree(req->s);
            Safefree(req);
            THROWERR("Couldn't write", err);
        }

        req->cb = newSVsv(cb);

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Req", req);
        req->selfrv = SvREFCNT_inc(SvRV(RETVAL));
#line 3271 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Timer__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Timer__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, loop");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Timer::_new",
			"loop", "UV::Loop")
;
#line 1844 "lib/UV.xs"
        UV__Timer self;
        int err;
#line 3303 "lib/UV.c"
#line 1847 "lib/UV.xs"
        NEW_UV__Handle(self, uv_timer_t);

        err = uv_timer_init(loop->loop, self->h);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialise timer handle", err);
        }

        INIT_UV__Handle(self);
        self->on_timer = NULL;

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Timer", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 3319 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Timer__on_timer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Timer__on_timer)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Timer	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Timer")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Timer,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Timer::_on_timer",
			"self", "UV::Timer")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 1867 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_timer, cb);
#line 3356 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Timer__start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Timer__start)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, timeout, repeat");
    {
	UV__Timer	self;
	UV	timeout = (UV)SvUV(ST(1))
;
	UV	repeat = (UV)SvUV(ST(2))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Timer")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Timer,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Timer::_start",
			"self", "UV::Timer")
;
#line 1874 "lib/UV.xs"
        CHECKCALL(uv_timer_start(self->h, on_timer_cb, timeout, repeat));
#line 3388 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Timer__get_repeat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Timer__get_repeat)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV	RETVAL;
	dXSTARG;
	UV__Timer	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Timer")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Timer,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Timer::_get_repeat",
			"self", "UV::Timer")
;
#line 1879 "lib/UV.xs"
        RETVAL = uv_timer_get_repeat(self->h);
#line 3416 "lib/UV.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Timer__set_repeat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Timer__set_repeat)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, repeat");
    {
	UV__Timer	self;
	UV	repeat = (UV)SvUV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Timer")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Timer,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Timer::_set_repeat",
			"self", "UV::Timer")
;
#line 1886 "lib/UV.xs"
        uv_timer_set_repeat(self->h, repeat);
#line 3445 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Timer_again); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Timer_again)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Timer	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Timer")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Timer,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Timer::again",
			"self", "UV::Timer")
;
#line 1891 "lib/UV.xs"
        CHECKCALL(uv_timer_again(self->h));
#line 3471 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Timer_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Timer_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Timer	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Timer")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Timer,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Timer::stop",
			"self", "UV::Timer")
;
#line 1896 "lib/UV.xs"
        CHECKCALL(uv_timer_stop(self->h));
#line 3497 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__TCP__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TCP__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, loop");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TCP::_new",
			"loop", "UV::Loop")
;
#line 1903 "lib/UV.xs"
        UV__TCP self;
        int err;
#line 3527 "lib/UV.c"
#line 1906 "lib/UV.xs"
        NEW_UV__Handle(self, uv_tcp_t);

        err = uv_tcp_init(loop->loop, self->h);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialise tcp handle", err);
        }

        INIT_UV__Handle(self);
        INIT_UV__Stream(self);

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::TCP", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 3543 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__TCP__open); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TCP__open)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, fd");
    {
	UV__TCP	self;
	int	fd = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::TCP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__TCP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TCP::_open",
			"self", "UV::TCP")
;
#line 1926 "lib/UV.xs"
        CHECKCALL(uv_tcp_open(self->h, fd));
#line 3573 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__TCP_nodelay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TCP_nodelay)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, enable");
    {
	UV__TCP	self;
	bool	enable = (bool)SvTRUE(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::TCP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__TCP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TCP::nodelay",
			"self", "UV::TCP")
;
#line 1931 "lib/UV.xs"
        CHECKCALL(uv_tcp_nodelay(self->h, enable));
#line 3601 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__TCP_keepalive); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TCP_keepalive)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, enable, delay= 0");
    {
	UV__TCP	self;
	bool	enable = (bool)SvTRUE(ST(1))
;
	unsigned int	delay;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::TCP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__TCP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TCP::keepalive",
			"self", "UV::TCP")
;

	if (items < 3)
	    delay = 0;
	else {
	    delay = (unsigned int)SvUV(ST(2))
;
	}
#line 1936 "lib/UV.xs"
        if(enable && items < 3)
            croak_xs_usage(cv, "self, enable=true, delay");

        CHECKCALL(uv_tcp_keepalive(self->h, enable, delay));
#line 3640 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__TCP_simultaneous_accepts); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TCP_simultaneous_accepts)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, enable");
    {
	UV__TCP	self;
	bool	enable = (bool)SvTRUE(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::TCP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__TCP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TCP::simultaneous_accepts",
			"self", "UV::TCP")
;
#line 1944 "lib/UV.xs"
        CHECKCALL(uv_tcp_simultaneous_accepts(self->h, enable));
#line 3668 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__TCP_bind); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TCP_bind)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, addr, flags= 0");
    {
	UV__TCP	self;
	SV *	addr = ST(1)
;
	int	flags;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::TCP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__TCP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TCP::bind",
			"self", "UV::TCP")
;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (int)SvIV(ST(2))
;
	}
#line 1949 "lib/UV.xs"
        if(!SvPOK(addr) || SvCUR(addr) < sizeof(struct sockaddr))
            croak("Expected a packed socket address for addr");

        CHECKCALL(uv_tcp_bind(self->h, (struct sockaddr *)SvPVX(addr), flags));
#line 3707 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__TCP_connect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TCP_connect)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, addr, cb");
    {
	SV *	RETVAL;
	UV__TCP	self;
	SV *	addr = ST(1)
;
	SV *	cb = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::TCP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__TCP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TCP::connect",
			"self", "UV::TCP")
;
#line 1957 "lib/UV.xs"
        UV__Req_connect req;
#line 3738 "lib/UV.c"
#line 1959 "lib/UV.xs"
        NEW_UV__Req(req, uv_connect_t);
        INIT_UV__Req(req);

        if(!SvPOK(addr) || SvCUR(addr) < sizeof(struct sockaddr))
            croak("Expected a packed socket address for addr");

        uv_tcp_connect(req->r, self->h, (struct sockaddr *)SvPVX(addr), (uv_connect_cb)on_req_cb);

        req->cb = newSVsv(cb);

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Req", req);
        req->selfrv = SvREFCNT_inc(SvRV(RETVAL));
#line 3753 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__TCP_getpeername); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TCP_getpeername)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	UV__TCP	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::TCP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__TCP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			GvNAME(CvGV(cv)),
			"self", "UV::TCP")
;
#line 1981 "lib/UV.xs"
        int len;
        int err;
#line 3784 "lib/UV.c"
#line 1984 "lib/UV.xs"
        len = sizeof(struct sockaddr_storage);
        RETVAL = newSV(len);

        err = (ix == 0) ?
            uv_tcp_getpeername(self->h, (struct sockaddr *)SvPVX(RETVAL), &len) :
            uv_tcp_getsockname(self->h, (struct sockaddr *)SvPVX(RETVAL), &len);
        if(err != 0) {
            SvREFCNT_dec(RETVAL);
            croak("Couldn't %s from tcp handle (%d): %s", (ix == 0) ? "getpeername" : "getsockname",
                err, uv_strerror(err));
        }

        SvCUR_set(RETVAL, len);
        SvPOK_on(RETVAL);
#line 3800 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__TCP__close_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TCP__close_reset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__TCP	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::TCP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__TCP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TCP::_close_reset",
			"self", "UV::TCP")
;
#line 2004 "lib/UV.xs"
        CHECKCALL(uv_tcp_close_reset(self->h, on_close_cb));
#line 3828 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__TTY__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TTY__new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "class, loop, fd");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;
	int	fd = (int)SvIV(ST(2))
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TTY::_new",
			"loop", "UV::Loop")
;
#line 2011 "lib/UV.xs"
        UV__TTY self;
        int err;
#line 3860 "lib/UV.c"
#line 2014 "lib/UV.xs"
        NEW_UV__Handle(self, uv_tty_t);

        err = uv_tty_init(loop->loop, self->h, fd, 0);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialise tty handle", err);
        }

        INIT_UV__Handle(self);
        INIT_UV__Stream(self);

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::TTY", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 3876 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__TTY_set_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TTY_set_mode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, mode");
    {
	UV__TTY	self;
	int	mode = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::TTY")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__TTY,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TTY::set_mode",
			"self", "UV::TTY")
;
#line 2034 "lib/UV.xs"
        CHECKCALL(uv_tty_set_mode(self->h, mode));
#line 3906 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__TTY_get_winsize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__TTY_get_winsize)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	UV__TTY	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::TTY")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__TTY,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::TTY::get_winsize",
			"self", "UV::TTY")
;
#line 2039 "lib/UV.xs"
        int width, height;
#line 3934 "lib/UV.c"
#line 2041 "lib/UV.xs"
        CHECKCALL(uv_tty_get_winsize(self->h, &width, &height));
        EXTEND(SP, 2);
        mPUSHi(width);
        mPUSHi(height);
        XSRETURN(2);
#line 3941 "lib/UV.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_UV__UDP__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, loop");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	UV__Loop	loop;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    loop = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::_new",
			"loop", "UV::Loop")
;
#line 2052 "lib/UV.xs"
        UV__UDP self;
        int err;
#line 3972 "lib/UV.c"
#line 2055 "lib/UV.xs"
        NEW_UV__Handle(self, uv_udp_t);

        err = uv_udp_init(loop->loop, self->h);
        if (err != 0) {
            Safefree(self);
            THROWERR("Couldn't initialse udp handle", err);
        }

        INIT_UV__Handle(self);
        self->on_recv = NULL;

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::UDP", self);
        self->selfrv = SvRV(RETVAL); /* no inc */
#line 3988 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__UDP__on_recv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP__on_recv)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__UDP	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::_on_recv",
			"self", "UV::UDP")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 2075 "lib/UV.xs"
        RETVAL = do_callback_accessor(&self->on_recv, cb);
#line 4025 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__UDP__open); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP__open)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, fd");
    {
	UV__UDP	self;
	int	fd = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::_open",
			"self", "UV::UDP")
;
#line 2082 "lib/UV.xs"
        CHECKCALL(uv_udp_open(self->h, fd));
#line 4055 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_bind); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_bind)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, addr, flags= 0");
    {
	UV__UDP	self;
	SV *	addr = ST(1)
;
	int	flags;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::bind",
			"self", "UV::UDP")
;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (int)SvIV(ST(2))
;
	}
#line 2087 "lib/UV.xs"
        if(!SvPOK(addr) || SvCUR(addr) < sizeof(struct sockaddr))
            croak("Expected a packed socket address for addr");

        CHECKCALL(uv_udp_bind(self->h, (struct sockaddr *)SvPVX(addr), flags));
#line 4094 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_connect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_connect)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, addr");
    {
	SV *	RETVAL;
	UV__UDP	self;
	SV *	addr = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::connect",
			"self", "UV::UDP")
;
#line 2095 "lib/UV.xs"
        if(!SvPOK(addr) || SvCUR(addr) < sizeof(struct sockaddr))
            croak("Expected a packed socket address for addr");

        CHECKCALL(uv_udp_connect(self->h, (struct sockaddr *)SvPVX(addr)));
#line 4126 "lib/UV.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__UDP_getpeername); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_getpeername)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	UV__UDP	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			GvNAME(CvGV(cv)),
			"self", "UV::UDP")
;
#line 2106 "lib/UV.xs"
        int len;
        int err;
#line 4155 "lib/UV.c"
#line 2109 "lib/UV.xs"
        len = sizeof(struct sockaddr_storage);
        RETVAL = newSV(len);

        err = (ix == 0) ?
            uv_udp_getpeername(self->h, (struct sockaddr *)SvPVX(RETVAL), &len) :
            uv_udp_getsockname(self->h, (struct sockaddr *)SvPVX(RETVAL), &len);
        if(err != 0) {
            SvREFCNT_dec(RETVAL);
            croak("Couldn't %s from udp handle (%d): %s", (ix == 0) ? "getpeername" : "getsockname",
                err, uv_strerror(err));
        }

        SvCUR_set(RETVAL, len);
        SvPOK_on(RETVAL);
#line 4171 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__UDP_recv_start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_recv_start)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__UDP	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::recv_start",
			"self", "UV::UDP")
;
#line 2129 "lib/UV.xs"
        CHECKCALL(uv_udp_recv_start(self->h, on_alloc_cb, on_recv_cb));
#line 4199 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_recv_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_recv_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__UDP	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::recv_stop",
			"self", "UV::UDP")
;
#line 2134 "lib/UV.xs"
        CHECKCALL(uv_udp_recv_stop(self->h));
#line 4225 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_send); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_send)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "self, s, ...");
    {
	SV *	RETVAL;
	UV__UDP	self;
	SV *	s = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::send",
			"self", "UV::UDP")
;
#line 2139 "lib/UV.xs"
        UV__Req_udp_send req;
        uv_buf_t buf[1];
        int err;
        SV *addr;
        struct sockaddr *sockaddr = NULL;
        SV *cb;
#line 4259 "lib/UV.c"
#line 2146 "lib/UV.xs"
        if(items > 4)
            croak_xs_usage(cv, "self, s, [from], cb");
        else if(items == 4) {
            addr = ST(2);
            cb   = ST(3);
        }
        else if(SvTYPE(SvRV(ST(2))) == SVt_PVCV) {
            addr = NULL;
            cb   = ST(2);
        }
        else {
            addr = ST(2);
            cb   = NULL;
        }

        if(addr) {
            if(!SvPOK(addr) || SvCUR(addr) < sizeof(struct sockaddr))
                croak("Expected a packed socket address for addr");
            sockaddr = (struct sockaddr *)SvPVX(addr);
        }

        NEW_UV__Req(req, uv_udp_send_t);
        INIT_UV__Req(req);

        buf[0].len  = SvCUR(s);
        buf[0].base = savepvn(SvPVX(s), buf[0].len);

        req->s = buf[0].base;

        err = uv_udp_send(req->r, self->h, buf, 1, sockaddr,
            (uv_udp_send_cb)on_req_cb);

        if(err != 0) {
            Safefree(req->s);
            Safefree(req);
            THROWERR("Couldn't send", err);
        }

        if(cb)
            req->cb = newSVsv(cb);
        else
            req->cb = NULL;

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Req", req);
        req->selfrv = SvREFCNT_inc(SvRV(RETVAL));
#line 4307 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__UDP_set_broadcast); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_set_broadcast)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, on");
    {
	UV__UDP	self;
	bool	on = (bool)SvTRUE(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::set_broadcast",
			"self", "UV::UDP")
;
#line 2198 "lib/UV.xs"
        CHECKCALL(uv_udp_set_broadcast(self->h, on));
#line 4337 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_set_ttl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_set_ttl)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, ttl");
    {
	UV__UDP	self;
	int	ttl = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::set_ttl",
			"self", "UV::UDP")
;
#line 2203 "lib/UV.xs"
        CHECKCALL(uv_udp_set_ttl(self->h, ttl));
#line 4365 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_set_multicast_loop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_set_multicast_loop)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, on");
    {
	UV__UDP	self;
	bool	on = (bool)SvTRUE(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::set_multicast_loop",
			"self", "UV::UDP")
;
#line 2208 "lib/UV.xs"
        CHECKCALL(uv_udp_set_multicast_loop(self->h, on));
#line 4393 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_set_multicast_ttl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_set_multicast_ttl)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, ttl");
    {
	UV__UDP	self;
	int	ttl = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::set_multicast_ttl",
			"self", "UV::UDP")
;
#line 2213 "lib/UV.xs"
        CHECKCALL(uv_udp_set_multicast_ttl(self->h, ttl));
#line 4421 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_set_multicast_interface); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_set_multicast_interface)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, ifaddr");
    {
	UV__UDP	self;
	SV *	ifaddr = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::set_multicast_interface",
			"self", "UV::UDP")
;
#line 2218 "lib/UV.xs"
        CHECKCALL(uv_udp_set_multicast_interface(self->h, SvPVbyte_nolen(ifaddr)));
#line 4449 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_set_membership); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_set_membership)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, mcaddr, ifaddr, membership");
    {
	UV__UDP	self;
	SV *	mcaddr = ST(1)
;
	SV *	ifaddr = ST(2)
;
	int	membership = (int)SvIV(ST(3))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::set_membership",
			"self", "UV::UDP")
;
#line 2223 "lib/UV.xs"
        CHECKCALL(uv_udp_set_membership(
            self->h, SvPVbyte_nolen(mcaddr), SvPVbyte_nolen(ifaddr), membership));
#line 4482 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_set_source_membership); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_set_source_membership)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "self, mcaddr, ifaddr, srcaddr, membership");
    {
	UV__UDP	self;
	SV *	mcaddr = ST(1)
;
	SV *	ifaddr = ST(2)
;
	SV *	srcaddr = ST(3)
;
	int	membership = (int)SvIV(ST(4))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::set_source_membership",
			"self", "UV::UDP")
;
#line 2229 "lib/UV.xs"
        CHECKCALL(uv_udp_set_source_membership(
            self->h, SvPVbyte_nolen(mcaddr), SvPVbyte_nolen(ifaddr), SvPVbyte_nolen(srcaddr), membership));
#line 4517 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_try_send); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_try_send)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "self, s, ...");
    {
	UV__UDP	self;
	SV *	s = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::UDP::try_send",
			"self", "UV::UDP")
;
#line 2235 "lib/UV.xs"
        uv_buf_t buf[1];
        int err;
        SV *addr;
        struct sockaddr *sockaddr = NULL;
#line 4548 "lib/UV.c"
#line 2240 "lib/UV.xs"
        if(items > 3)
            croak_xs_usage(cv, "self, s, [from]");
        else if(items == 3) {
            addr = ST(2);
        }
        else {
            addr = NULL;
        }

        if(addr) {
            if(!SvPOK(addr) || SvCUR(addr) < sizeof(struct sockaddr))
                croak("Expected a packed socket address for addr");
            sockaddr = (struct sockaddr *)SvPVX(addr);
        }

        buf[0].len  = SvCUR(s);
        buf[0].base = savepvn(SvPVX(s), buf[0].len);

        err = uv_udp_try_send(self->h, buf, 1, sockaddr);

        if(err < 0) {
            THROWERR("Couldn't send", err);
        }
#line 4573 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__UDP_get_send_queue_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__UDP_get_send_queue_size)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV	RETVAL;
	dXSTARG;
	UV__UDP	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::UDP")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__UDP,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			GvNAME(CvGV(cv)),
			"self", "UV::UDP")
;
#line 2270 "lib/UV.xs"
        switch(ix) {
            case 0: RETVAL = uv_udp_get_send_queue_size(self->h);  break;
            case 1: RETVAL = uv_udp_get_send_queue_count(self->h); break;
        }
#line 4605 "lib/UV.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Loop__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, want_default");
    {
	SV *	RETVAL;
	char *	class = (char *)SvPV_nolen(ST(0))
;
	int	want_default = (int)SvIV(ST(1))
;
#line 2282 "lib/UV.xs"
        UV__Loop self;
        int err;
#line 4627 "lib/UV.c"
#line 2285 "lib/UV.xs"
        Newxc(self, sizeof(struct UV__Loop) + (!want_default * sizeof(uv_loop_t)),
            char, struct UV__Loop);
        self->on_walk = NULL;

        if(want_default) {
            self->loop = uv_default_loop();
        }
        else {
            self->loop = (uv_loop_t *)((char *)self + sizeof(struct UV__Loop));
            err = uv_loop_init(self->loop);
            if(err != 0) {
                Safefree(self);
                THROWERR("Couldn't initialise loop", err);
            }
        }

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Loop", self);
#line 4647 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Loop__on_walk); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop__on_walk)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= NULL");
    {
	SV *	RETVAL;
	UV__Loop	self;
	SV *	cb;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::_on_walk",
			"self", "UV::Loop")
;

	if (items < 2)
	    cb = NULL;
	else {
	    cb = ST(1)
;
	}
#line 2309 "lib/UV.xs"
        if(cb && SvOK(cb)) {
            if(self->on_walk)
                SvREFCNT_dec(self->on_walk);

            self->on_walk = newSVsv(cb);
        }

        RETVAL = newSVsv(self->on_walk);
#line 4691 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Loop__walk); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop__walk)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Loop	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::_walk",
			"self", "UV::Loop")
;
#line 2323 "lib/UV.xs"
        uv_walk(self->loop, on_loop_walk, self->on_walk);
#line 4719 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Loop_alive); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_alive)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	bool	RETVAL;
	UV__Loop	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::alive",
			"self", "UV::Loop")
;
#line 2328 "lib/UV.xs"
        RETVAL = uv_loop_alive(self->loop);
#line 4746 "lib/UV.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Loop_backend_fd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_backend_fd)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	UV__Loop	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::backend_fd",
			"self", "UV::Loop")
;
#line 2335 "lib/UV.xs"
        RETVAL = uv_backend_fd(self->loop);
#line 4775 "lib/UV.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Loop_backend_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_backend_timeout)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	UV__Loop	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::backend_timeout",
			"self", "UV::Loop")
;
#line 2342 "lib/UV.xs"
        RETVAL = uv_backend_timeout(self->loop);
#line 4804 "lib/UV.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Loop_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Loop	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"UV::Loop::DESTROY",
			"self")
;
#line 2349 "lib/UV.xs"
        /* Don't allow closing the default loop */
        if(self->loop != uv_default_loop())
            uv_loop_close(self->loop);
#line 4833 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Loop_configure); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_configure)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, option, value");
    {
	UV__Loop	self;
	int	option = (int)SvIV(ST(1))
;
	int	value = (int)SvIV(ST(2))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::configure",
			"self", "UV::Loop")
;
#line 2356 "lib/UV.xs"
        CHECKCALL(uv_loop_configure(self->loop, option, value));
#line 4863 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Loop_is_default); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_is_default)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	bool	RETVAL;
	UV__Loop	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::is_default",
			"self", "UV::Loop")
;
#line 2361 "lib/UV.xs"
        RETVAL = (self->loop == uv_default_loop());
#line 4890 "lib/UV.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Loop_now); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_now)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV	RETVAL;
	dXSTARG;
	UV__Loop	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::now",
			"self", "UV::Loop")
;
#line 2368 "lib/UV.xs"
        RETVAL = uv_now(self->loop);
#line 4919 "lib/UV.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Loop_run); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_run)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, mode= UV_RUN_DEFAULT");
    {
	int	RETVAL;
	dXSTARG;
	UV__Loop	self;
	int	mode;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::run",
			"self", "UV::Loop")
;

	if (items < 2)
	    mode = UV_RUN_DEFAULT;
	else {
	    mode = (int)SvIV(ST(1))
;
	}
#line 2375 "lib/UV.xs"
        RETVAL = uv_run(self->loop, mode);
#line 4956 "lib/UV.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Loop_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Loop	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::stop",
			"self", "UV::Loop")
;
#line 2382 "lib/UV.xs"
        uv_stop(self->loop);
#line 4983 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Loop_update_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_update_time)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__Loop	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::update_time",
			"self", "UV::Loop")
;
#line 2387 "lib/UV.xs"
        uv_update_time(self->loop);
#line 5009 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Loop__getaddrinfo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop__getaddrinfo)
{
    dVAR; dXSARGS;
    if (items != 8)
       croak_xs_usage(cv,  "self, node, service, flags, family, socktype, protocol, cb");
    {
	SV *	RETVAL;
	UV__Loop	self;
	char *	node = (char *)SvPV_nolen(ST(1))
;
	char *	service = (char *)SvPV_nolen(ST(2))
;
	SV *	flags = ST(3)
;
	SV *	family = ST(4)
;
	SV *	socktype = ST(5)
;
	SV *	protocol = ST(6)
;
	SV *	cb = ST(7)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::_getaddrinfo",
			"self", "UV::Loop")
;
#line 2392 "lib/UV.xs"
        UV__Req_getaddrinfo req;
        struct addrinfo hints = { 0 };
        int err;
#line 5052 "lib/UV.c"
#line 2396 "lib/UV.xs"
        NEW_UV__Req(req, uv_getaddrinfo_t);
        INIT_UV__Req(req);

        hints.ai_flags    = SvOK(flags)    ? SvIV(flags)    : (AI_V4MAPPED|AI_ADDRCONFIG);
        hints.ai_family   = SvOK(family)   ? SvIV(family)   : AF_UNSPEC;
        hints.ai_socktype = SvOK(socktype) ? SvIV(socktype) : 0;
        hints.ai_protocol = SvOK(protocol) ? SvIV(protocol) : 0;

        err = uv_getaddrinfo(self->loop, req->r, on_getaddrinfo_cb,
            node, service, &hints);
        if (err != 0) {
            Safefree(req);
            THROWERR("Couldn't getaddrinfo", err);
        }

        req->cb = newSVsv(cb);

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Req", req);
        req->selfrv = SvREFCNT_inc(SvRV(RETVAL));
#line 5074 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Loop_getnameinfo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Loop_getnameinfo)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, addr, flags, cb");
    {
	SV *	RETVAL;
	UV__Loop	self;
	SV *	addr = ST(1)
;
	int	flags = (int)SvIV(ST(2))
;
	SV *	cb = ST(3)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Loop")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__Loop,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Loop::getnameinfo",
			"self", "UV::Loop")
;
#line 2422 "lib/UV.xs"
        UV__Req_getnameinfo req;
        int err;
#line 5110 "lib/UV.c"
#line 2425 "lib/UV.xs"
        NEW_UV__Req(req, uv_getnameinfo_t);
        INIT_UV__Req(req);

        err = uv_getnameinfo(self->loop, req->r, on_getnameinfo_cb,
            (struct sockaddr *)SvPV_nolen(addr), flags);
        if (err != 0) {
            Safefree(req);
            THROWERR("Couldn't getnameinfo", err);
        }

        req->cb = newSVsv(cb);

        RETVAL = newSV(0);
        sv_setref_pv(RETVAL, "UV::Req", req);
        req->selfrv = SvREFCNT_inc(SvRV(RETVAL));
#line 5127 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__Req_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Req_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "req");
    {
	UV__Req	req;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    req = INT2PTR(UV__Req,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"UV::Req::DESTROY",
			"req")
;
#line 2448 "lib/UV.xs"
        switch(req->r->type) {
            case UV_CONNECT:
                SvREFCNT_dec(((UV__Req_connect)req)->cb);
                break;

            case UV_GETADDRINFO:
                SvREFCNT_dec(((UV__Req_getaddrinfo)req)->cb);
                break;

            case UV_GETNAMEINFO:
                SvREFCNT_dec(((UV__Req_getnameinfo)req)->cb);
                break;

            case UV_SHUTDOWN:
                SvREFCNT_dec(((UV__Req_shutdown)req)->cb);
                break;

            case UV_WRITE:
                Safefree(((UV__Req_write)req)->s);
                SvREFCNT_dec(((UV__Req_write)req)->cb);
                break;
        }

        Safefree(req);
#line 5178 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__Req_cancel); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__Req_cancel)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "req");
    {
	UV__Req	req;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::Req")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    req = INT2PTR(UV__Req,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"UV::Req::cancel",
			"req", "UV::Req")
;
#line 2476 "lib/UV.xs"
        int err;
#line 5204 "lib/UV.c"
#line 2478 "lib/UV.xs"
        err = uv_cancel(req->r);
        /* Cancellation is best-effort; don't consider it an error if we get
         * EBUSY */
        if((err != 0) && (err != UV_EBUSY))
            THROWERR("Couldn't cancel", err);
#line 5211 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__getaddrinfo_result_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__getaddrinfo_result_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV__getaddrinfo_result	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__getaddrinfo_result,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"UV::getaddrinfo_result::DESTROY",
			"self")
;
#line 2489 "lib/UV.xs"
        Safefree(self);
#line 5237 "lib/UV.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_UV__getaddrinfo_result_family); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__getaddrinfo_result_family)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	UV__getaddrinfo_result	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::getaddrinfo_result")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__getaddrinfo_result,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			GvNAME(CvGV(cv)),
			"self", "UV::getaddrinfo_result")
;
#line 2498 "lib/UV.xs"
        switch(ix) {
            case 0: RETVAL = self->family;   break;
            case 1: RETVAL = self->socktype; break;
            case 2: RETVAL = self->protocol; break;
        }
#line 5270 "lib/UV.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_UV__getaddrinfo_result_addr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_UV__getaddrinfo_result_addr)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	UV__getaddrinfo_result	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "UV::getaddrinfo_result")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(UV__getaddrinfo_result,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			GvNAME(CvGV(cv)),
			"self", "UV::getaddrinfo_result")
;
#line 2512 "lib/UV.xs"
        switch(ix) {
            case 0: RETVAL = newSVpvn((char *)self->addr, self->addrlen); break;
            case 1: RETVAL = self->canonname ? newSVpv(self->canonname, 0) : &PL_sv_undef; break;
        }
#line 5302 "lib/UV.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_UV); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_UV)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

    {
        CV * cv;

        newXS_deffile("UV::err_name", XS_UV_err_name);
        newXS_deffile("UV::hrtime", XS_UV_hrtime);
        newXS_deffile("UV::strerror", XS_UV_strerror);
        newXS_deffile("UV::version", XS_UV_version);
        newXS_deffile("UV::version_string", XS_UV_version_string);
        newXS_deffile("UV::Exception::message", XS_UV__Exception_message);
        newXS_deffile("UV::Exception::code", XS_UV__Exception_code);
        newXS_deffile("UV::Handle::DESTROY", XS_UV__Handle_DESTROY);
        newXS_deffile("UV::Handle::closed", XS_UV__Handle_closed);
        newXS_deffile("UV::Handle::closing", XS_UV__Handle_closing);
        newXS_deffile("UV::Handle::active", XS_UV__Handle_active);
        newXS_deffile("UV::Handle::loop", XS_UV__Handle_loop);
        newXS_deffile("UV::Handle::data", XS_UV__Handle_data);
        newXS_deffile("UV::Handle::_close", XS_UV__Handle__close);
        newXS_deffile("UV::Handle::_on_close", XS_UV__Handle__on_close);
        newXS_deffile("UV::Async::_new", XS_UV__Async__new);
        newXS_deffile("UV::Async::_on_async", XS_UV__Async__on_async);
        newXS_deffile("UV::Async::send", XS_UV__Async_send);
        newXS_deffile("UV::Check::_new", XS_UV__Check__new);
        newXS_deffile("UV::Check::_on_check", XS_UV__Check__on_check);
        newXS_deffile("UV::Check::_start", XS_UV__Check__start);
        newXS_deffile("UV::Check::stop", XS_UV__Check_stop);
        newXS_deffile("UV::Idle::_new", XS_UV__Idle__new);
        newXS_deffile("UV::Idle::_on_idle", XS_UV__Idle__on_idle);
        newXS_deffile("UV::Idle::_start", XS_UV__Idle__start);
        newXS_deffile("UV::Idle::stop", XS_UV__Idle_stop);
        newXS_deffile("UV::Pipe::_new", XS_UV__Pipe__new);
        newXS_deffile("UV::Pipe::_open", XS_UV__Pipe__open);
        newXS_deffile("UV::Pipe::bind", XS_UV__Pipe_bind);
        newXS_deffile("UV::Pipe::connect", XS_UV__Pipe_connect);
        cv = newXS_deffile("UV::Pipe::getpeername", XS_UV__Pipe_getpeername);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("UV::Pipe::getsockname", XS_UV__Pipe_getpeername);
        XSANY.any_i32 = 1;
        newXS_deffile("UV::Pipe::chmod", XS_UV__Pipe_chmod);
        newXS_deffile("UV::Poll::_new", XS_UV__Poll__new);
        newXS_deffile("UV::Poll::_on_poll", XS_UV__Poll__on_poll);
        newXS_deffile("UV::Poll::_start", XS_UV__Poll__start);
        newXS_deffile("UV::Poll::stop", XS_UV__Poll_stop);
        newXS_deffile("UV::Prepare::_new", XS_UV__Prepare__new);
        newXS_deffile("UV::Prepare::_on_prepare", XS_UV__Prepare__on_prepare);
        newXS_deffile("UV::Prepare::_start", XS_UV__Prepare__start);
        newXS_deffile("UV::Prepare::stop", XS_UV__Prepare_stop);
        newXS_deffile("UV::Process::_new", XS_UV__Process__new);
        newXS_deffile("UV::Process::_on_exit", XS_UV__Process__on_exit);
        newXS_deffile("UV::Process::_set_file", XS_UV__Process__set_file);
        newXS_deffile("UV::Process::_set_args", XS_UV__Process__set_args);
        newXS_deffile("UV::Process::_set_env", XS_UV__Process__set_env);
        newXS_deffile("UV::Process::_set_stdio_h", XS_UV__Process__set_stdio_h);
        newXS_deffile("UV::Process::_set_setuid", XS_UV__Process__set_setuid);
        newXS_deffile("UV::Process::_set_setgid", XS_UV__Process__set_setgid);
        newXS_deffile("UV::Process::_spawn", XS_UV__Process__spawn);
        newXS_deffile("UV::Process::kill", XS_UV__Process_kill);
        newXS_deffile("UV::Process::pid", XS_UV__Process_pid);
        newXS_deffile("UV::Signal::_new", XS_UV__Signal__new);
        newXS_deffile("UV::Signal::_on_signal", XS_UV__Signal__on_signal);
        newXS_deffile("UV::Signal::_start", XS_UV__Signal__start);
        newXS_deffile("UV::Signal::stop", XS_UV__Signal_stop);
        newXS_deffile("UV::Stream::_on_read", XS_UV__Stream__on_read);
        newXS_deffile("UV::Stream::_on_connection", XS_UV__Stream__on_connection);
        newXS_deffile("UV::Stream::_listen", XS_UV__Stream__listen);
        newXS_deffile("UV::Stream::_accept", XS_UV__Stream__accept);
        newXS_deffile("UV::Stream::shutdown", XS_UV__Stream_shutdown);
        newXS_deffile("UV::Stream::read_start", XS_UV__Stream_read_start);
        newXS_deffile("UV::Stream::read_stop", XS_UV__Stream_read_stop);
        newXS_deffile("UV::Stream::write", XS_UV__Stream_write);
        newXS_deffile("UV::Timer::_new", XS_UV__Timer__new);
        newXS_deffile("UV::Timer::_on_timer", XS_UV__Timer__on_timer);
        newXS_deffile("UV::Timer::_start", XS_UV__Timer__start);
        newXS_deffile("UV::Timer::_get_repeat", XS_UV__Timer__get_repeat);
        newXS_deffile("UV::Timer::_set_repeat", XS_UV__Timer__set_repeat);
        newXS_deffile("UV::Timer::again", XS_UV__Timer_again);
        newXS_deffile("UV::Timer::stop", XS_UV__Timer_stop);
        newXS_deffile("UV::TCP::_new", XS_UV__TCP__new);
        newXS_deffile("UV::TCP::_open", XS_UV__TCP__open);
        newXS_deffile("UV::TCP::nodelay", XS_UV__TCP_nodelay);
        newXS_deffile("UV::TCP::keepalive", XS_UV__TCP_keepalive);
        newXS_deffile("UV::TCP::simultaneous_accepts", XS_UV__TCP_simultaneous_accepts);
        newXS_deffile("UV::TCP::bind", XS_UV__TCP_bind);
        newXS_deffile("UV::TCP::connect", XS_UV__TCP_connect);
        cv = newXS_deffile("UV::TCP::getpeername", XS_UV__TCP_getpeername);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("UV::TCP::getsockname", XS_UV__TCP_getpeername);
        XSANY.any_i32 = 1;
        newXS_deffile("UV::TCP::_close_reset", XS_UV__TCP__close_reset);
        newXS_deffile("UV::TTY::_new", XS_UV__TTY__new);
        newXS_deffile("UV::TTY::set_mode", XS_UV__TTY_set_mode);
        newXS_deffile("UV::TTY::get_winsize", XS_UV__TTY_get_winsize);
        newXS_deffile("UV::UDP::_new", XS_UV__UDP__new);
        newXS_deffile("UV::UDP::_on_recv", XS_UV__UDP__on_recv);
        newXS_deffile("UV::UDP::_open", XS_UV__UDP__open);
        newXS_deffile("UV::UDP::bind", XS_UV__UDP_bind);
        newXS_deffile("UV::UDP::connect", XS_UV__UDP_connect);
        cv = newXS_deffile("UV::UDP::getpeername", XS_UV__UDP_getpeername);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("UV::UDP::getsockname", XS_UV__UDP_getpeername);
        XSANY.any_i32 = 1;
        newXS_deffile("UV::UDP::recv_start", XS_UV__UDP_recv_start);
        newXS_deffile("UV::UDP::recv_stop", XS_UV__UDP_recv_stop);
        newXS_deffile("UV::UDP::send", XS_UV__UDP_send);
        newXS_deffile("UV::UDP::set_broadcast", XS_UV__UDP_set_broadcast);
        newXS_deffile("UV::UDP::set_ttl", XS_UV__UDP_set_ttl);
        newXS_deffile("UV::UDP::set_multicast_loop", XS_UV__UDP_set_multicast_loop);
        newXS_deffile("UV::UDP::set_multicast_ttl", XS_UV__UDP_set_multicast_ttl);
        newXS_deffile("UV::UDP::set_multicast_interface", XS_UV__UDP_set_multicast_interface);
        newXS_deffile("UV::UDP::set_membership", XS_UV__UDP_set_membership);
        newXS_deffile("UV::UDP::set_source_membership", XS_UV__UDP_set_source_membership);
        newXS_deffile("UV::UDP::try_send", XS_UV__UDP_try_send);
        cv = newXS_deffile("UV::UDP::get_send_queue_count", XS_UV__UDP_get_send_queue_size);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("UV::UDP::get_send_queue_size", XS_UV__UDP_get_send_queue_size);
        XSANY.any_i32 = 0;
        newXS_deffile("UV::Loop::_new", XS_UV__Loop__new);
        newXS_deffile("UV::Loop::_on_walk", XS_UV__Loop__on_walk);
        newXS_deffile("UV::Loop::_walk", XS_UV__Loop__walk);
        newXS_deffile("UV::Loop::alive", XS_UV__Loop_alive);
        newXS_deffile("UV::Loop::backend_fd", XS_UV__Loop_backend_fd);
        newXS_deffile("UV::Loop::backend_timeout", XS_UV__Loop_backend_timeout);
        newXS_deffile("UV::Loop::DESTROY", XS_UV__Loop_DESTROY);
        newXS_deffile("UV::Loop::configure", XS_UV__Loop_configure);
        newXS_deffile("UV::Loop::is_default", XS_UV__Loop_is_default);
        newXS_deffile("UV::Loop::now", XS_UV__Loop_now);
        newXS_deffile("UV::Loop::run", XS_UV__Loop_run);
        newXS_deffile("UV::Loop::stop", XS_UV__Loop_stop);
        newXS_deffile("UV::Loop::update_time", XS_UV__Loop_update_time);
        newXS_deffile("UV::Loop::_getaddrinfo", XS_UV__Loop__getaddrinfo);
        newXS_deffile("UV::Loop::getnameinfo", XS_UV__Loop_getnameinfo);
        newXS_deffile("UV::Req::DESTROY", XS_UV__Req_DESTROY);
        newXS_deffile("UV::Req::cancel", XS_UV__Req_cancel);
        newXS_deffile("UV::getaddrinfo_result::DESTROY", XS_UV__getaddrinfo_result_DESTROY);
        cv = newXS_deffile("UV::getaddrinfo_result::family", XS_UV__getaddrinfo_result_family);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("UV::getaddrinfo_result::protocol", XS_UV__getaddrinfo_result_family);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("UV::getaddrinfo_result::socktype", XS_UV__getaddrinfo_result_family);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("UV::getaddrinfo_result::addr", XS_UV__getaddrinfo_result_addr);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("UV::getaddrinfo_result::canonname", XS_UV__getaddrinfo_result_addr);
        XSANY.any_i32 = 1;
    }

    /* Initialisation Section */

#line 974 "lib/UV.xs"
{
    HV *stash;
    AV *export;
#define DO_CONST_IV(c) \
    newCONSTSUB_flags(stash, #c, strlen(#c), 0, newSViv(c)); \
    av_push(export, newSVpvs(#c));
#define DO_CONST_PV(c) \
    newCONSTSUB_flags(stash, #c, strlen(#c), 0, newSVpvn(c, strlen(c))); \
    av_push(export, newSVpvs(#c));

    /* constants under UV */
    {
        stash = gv_stashpv("UV", GV_ADD);
        export = get_av("UV::EXPORT_XS", TRUE);

        DO_CONST_IV(UV_VERSION_MAJOR);
        DO_CONST_IV(UV_VERSION_MINOR);
        DO_CONST_IV(UV_VERSION_PATCH);
        DO_CONST_IV(UV_VERSION_IS_RELEASE);
        DO_CONST_IV(UV_VERSION_HEX);
        DO_CONST_PV(UV_VERSION_SUFFIX);

        DO_CONST_IV(UV_E2BIG);
        DO_CONST_IV(UV_EACCES);
        DO_CONST_IV(UV_EADDRINUSE);
        DO_CONST_IV(UV_EADDRNOTAVAIL);
        DO_CONST_IV(UV_EAFNOSUPPORT);
        DO_CONST_IV(UV_EAGAIN);
        DO_CONST_IV(UV_EAI_ADDRFAMILY);
        DO_CONST_IV(UV_EAI_AGAIN);
        DO_CONST_IV(UV_EAI_BADFLAGS);
        DO_CONST_IV(UV_EAI_BADHINTS);
        DO_CONST_IV(UV_EAI_CANCELED);
        DO_CONST_IV(UV_EAI_FAIL);
        DO_CONST_IV(UV_EAI_FAMILY);
        DO_CONST_IV(UV_EAI_MEMORY);
        DO_CONST_IV(UV_EAI_NODATA);
        DO_CONST_IV(UV_EAI_NONAME);
        DO_CONST_IV(UV_EAI_OVERFLOW);
        DO_CONST_IV(UV_EAI_PROTOCOL);
        DO_CONST_IV(UV_EAI_SERVICE);
        DO_CONST_IV(UV_EAI_SOCKTYPE);
        DO_CONST_IV(UV_EALREADY);
        DO_CONST_IV(UV_EBADF);
        DO_CONST_IV(UV_EBUSY);
        DO_CONST_IV(UV_ECANCELED);
        DO_CONST_IV(UV_ECHARSET);
        DO_CONST_IV(UV_ECONNABORTED);
        DO_CONST_IV(UV_ECONNREFUSED);
        DO_CONST_IV(UV_ECONNRESET);
        DO_CONST_IV(UV_EDESTADDRREQ);
        DO_CONST_IV(UV_EEXIST);
        DO_CONST_IV(UV_EFAULT);
        DO_CONST_IV(UV_EFBIG);
        DO_CONST_IV(UV_EHOSTUNREACH);
        DO_CONST_IV(UV_EINTR);
        DO_CONST_IV(UV_EINVAL);
        DO_CONST_IV(UV_EIO);
        DO_CONST_IV(UV_EISCONN);
        DO_CONST_IV(UV_EISDIR);
        DO_CONST_IV(UV_ELOOP);
        DO_CONST_IV(UV_EMFILE);
        DO_CONST_IV(UV_EMSGSIZE);
        DO_CONST_IV(UV_ENAMETOOLONG);
        DO_CONST_IV(UV_ENETDOWN);
        DO_CONST_IV(UV_ENETUNREACH);
        DO_CONST_IV(UV_ENFILE);
        DO_CONST_IV(UV_ENOBUFS);
        DO_CONST_IV(UV_ENODEV);
        DO_CONST_IV(UV_ENOENT);
        DO_CONST_IV(UV_ENOMEM);
        DO_CONST_IV(UV_ENONET);
        DO_CONST_IV(UV_ENOPROTOOPT);
        DO_CONST_IV(UV_ENOSPC);
        DO_CONST_IV(UV_ENOSYS);
        DO_CONST_IV(UV_ENOTCONN);
        DO_CONST_IV(UV_ENOTDIR);
        DO_CONST_IV(UV_ENOTEMPTY);
        DO_CONST_IV(UV_ENOTSOCK);
        DO_CONST_IV(UV_ENOTSUP);
        DO_CONST_IV(UV_EPERM);
        DO_CONST_IV(UV_EPIPE);
        DO_CONST_IV(UV_EPROTO);
        DO_CONST_IV(UV_EPROTONOSUPPORT);
        DO_CONST_IV(UV_EPROTOTYPE);
        DO_CONST_IV(UV_ERANGE);
        DO_CONST_IV(UV_EROFS);
        DO_CONST_IV(UV_ESHUTDOWN);
        DO_CONST_IV(UV_ESPIPE);
        DO_CONST_IV(UV_ESRCH);
        DO_CONST_IV(UV_ETIMEDOUT);
        DO_CONST_IV(UV_ETXTBSY);
        DO_CONST_IV(UV_EXDEV);
        DO_CONST_IV(UV_UNKNOWN);
        DO_CONST_IV(UV_EOF);
        DO_CONST_IV(UV_ENXIO);
        DO_CONST_IV(UV_EMLINK);
    }

    /* constants under UV::Handle */
    {
        stash = gv_stashpv("UV::Handle", GV_ADD);
        export = get_av("UV::Handle::EXPORT_XS", TRUE);

        DO_CONST_IV(UV_ASYNC);
        DO_CONST_IV(UV_CHECK);
        DO_CONST_IV(UV_FS_EVENT);
        DO_CONST_IV(UV_FS_POLL);
        DO_CONST_IV(UV_IDLE);
        DO_CONST_IV(UV_NAMED_PIPE);
        DO_CONST_IV(UV_POLL);
        DO_CONST_IV(UV_PREPARE);
        DO_CONST_IV(UV_PROCESS);
        DO_CONST_IV(UV_STREAM);
        DO_CONST_IV(UV_TCP);
        DO_CONST_IV(UV_TIMER);
        DO_CONST_IV(UV_TTY);
        DO_CONST_IV(UV_UDP);
        DO_CONST_IV(UV_SIGNAL);
        DO_CONST_IV(UV_FILE);
    }

    /* constants under UV::Loop */
    {
        stash = gv_stashpv("UV::Loop", GV_ADD);
        export = get_av("UV::Loop::EXPORT_XS", TRUE);

        /* Loop run constants */
        DO_CONST_IV(UV_RUN_DEFAULT);
        DO_CONST_IV(UV_RUN_ONCE);
        DO_CONST_IV(UV_RUN_NOWAIT);

        /* expose the Loop configure constants */
        DO_CONST_IV(UV_LOOP_BLOCK_SIGNAL);
        DO_CONST_IV(SIGPROF);
    }

    /* constants under UV::Poll */
    {
        stash = gv_stashpv("UV::Poll", GV_ADD);
        export = get_av("UV::Poll::EXPORT_XS", TRUE);

        /* Poll Event Types */
        DO_CONST_IV(UV_READABLE);
        DO_CONST_IV(UV_WRITABLE);
        DO_CONST_IV(UV_DISCONNECT);
        DO_CONST_IV(UV_PRIORITIZED);
    }

    /* constants under UV::TTY */
    {
        stash = gv_stashpv("UV::TTY", GV_ADD);
        export = get_av("UV::TTY::EXPORT_XS", TRUE);

        /* TTY mode types */
        DO_CONST_IV(UV_TTY_MODE_NORMAL);
        DO_CONST_IV(UV_TTY_MODE_RAW);
        DO_CONST_IV(UV_TTY_MODE_IO);
    }

    /* constants under UV::UDP */
    {
        stash = gv_stashpv("UV::UDP", GV_ADD);
        export = get_av("UV::UDP::EXPORT_XS", TRUE);

        /* TTY mode types */
        DO_CONST_IV(UV_JOIN_GROUP);
        DO_CONST_IV(UV_LEAVE_GROUP);
    }
}

#line 5656 "lib/UV.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

