package DNS::Hetzner::API::Zones;
$DNS::Hetzner::API::Zones::VERSION = '0.04';
# ABSTRACT: Zones

# ---
# This class is auto-generated by bin/get_hetzner_info.pl
# ---

use v5.24;

use Moo;
use Types::Standard qw(:all);

use Mojo::Base -strict, -signatures;

extends 'DNS::Hetzner::APIBase';

with 'MooX::Singleton';

use DNS::Hetzner::Schema;

has endpoint  => ( is => 'ro', isa => Str, default => sub { 'zones' } );

sub list ($self, %params) {
    return $self->_do( 'GetZones', \%params, '', { type => 'get' } );
}

sub create ($self, %params) {
    return $self->_do( 'CreateZone', \%params, '', { type => 'post' } );
}

sub validate_file_plain ($self, %params) {
    return $self->_do( 'ValidateZoneFilePlain', \%params, '/file/validate', { type => 'post' } );
}

sub delete ($self, %params) {
    return $self->_do( 'DeleteZone', \%params, '/:ZoneID', { type => 'delete' } );
}

sub get ($self, %params) {
    return $self->_do( 'GetZone', \%params, '/:ZoneID', { type => 'get' } );
}

sub update ($self, %params) {
    return $self->_do( 'UpdateZone', \%params, '/:ZoneID', { type => 'put' } );
}

sub export_file ($self, %params) {
    return $self->_do( 'ExportZoneFile', \%params, '/:ZoneID/export', { type => 'get' } );
}

sub import_file_plain ($self, %params) {
    return $self->_do( 'ImportZoneFilePlain', \%params, '/:ZoneID/import', { type => 'post' } );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

DNS::Hetzner::API::Zones - Zones

=head1 VERSION

version 0.04

=head1 SYNOPSIS

    use DNS::Hetzner;

    my $api_key = '1234abc';
    my $dns     = DNS::Hetzner->new(
        token => $api_key,
    );

    $dns->records->create(
    );

=head1 ATTRIBUTES

=over 4

=item * endpoint

=back

=head1 METHODS

=head2 list

Returns paginated zones associated with the user. Limited to 100 zones per request.

    $dns->zones->list();

=head2 create

Creates a new zone.

    $dns->zones->create();

=head2 validate_file_plain

Validate a zone file in text/plain format.

    $dns->zones->validate_file_plain();

=head2 delete

Deletes a zone.

    $dns->zones->delete();

=head2 get

Returns an object containing all information about a zone. Zone to get is identified by 'ZoneID'.

    $dns->zones->get();

=head2 update

Updates a zone.

    $dns->zones->update();

=head2 export_file

Export a zone file.

    $dns->zones->export_file();

=head2 import_file_plain

Import a zone file in text/plain format.

    $dns->zones->import_file_plain();

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
