package Bencher::Scenario::Accessors::Construction;

our $DATE = '2016-09-09'; # DATE
our $VERSION = '0.09'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark object construction',
    modules => {
        'Perl::Examples::Accessors' => {version=>0.05},
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "${_}->new",
            };
        } keys %$classes,
    ],
    include_result_size => 1,
};

1;
# ABSTRACT: Benchmark object construction

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Construction - Benchmark object construction

=head1 VERSION

This document describes version 0.09 of Bencher::Scenario::Accessors::Construction (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-09-09.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Construction

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Construction

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors> 0.08

L<Perl::Examples::Accessors::Array> 0.08

L<Perl::Examples::Accessors::ClassAccessor> 0.08

L<Perl::Examples::Accessors::ClassAccessorArray> 0.08

L<Perl::Examples::Accessors::ClassInsideOut> 0.08

L<Perl::Examples::Accessors::ClassTiny> 0.08

L<Perl::Examples::Accessors::ClassXSAccessor> 0.08

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.08

L<Perl::Examples::Accessors::Hash> 0.08

L<Perl::Examples::Accessors::Mo> 0.08

L<Perl::Examples::Accessors::MojoBase> 0.08

L<Perl::Examples::Accessors::Moo> 0.08

L<Perl::Examples::Accessors::Moose> 0.08

L<Perl::Examples::Accessors::Mouse> 0.08

L<Perl::Examples::Accessors::ObjectSimple> 0.08

L<Perl::Examples::Accessors::Scalar> 0.08

L<Perl::Examples::Accessors::SimpleAccessor> 0.08

=head1 BENCHMARK PARTICIPANTS

=over

=item * Object::Simple (perl_code)

Code template:

 Perl::Examples::Accessors::ObjectSimple->new



=item * Moo (perl_code)

Code template:

 Perl::Examples::Accessors::Moo->new



=item * Mouse (perl_code)

Code template:

 Perl::Examples::Accessors::Mouse->new



=item * Mo (perl_code)

Code template:

 Perl::Examples::Accessors::Mo->new



=item * Mojo::Base (perl_code)

Code template:

 Perl::Examples::Accessors::MojoBase->new



=item * Class::Accessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessorArray->new



=item * Moose (perl_code)

Code template:

 Perl::Examples::Accessors::Moose->new



=item * Class::Tiny (perl_code)

Code template:

 Perl::Examples::Accessors::ClassTiny->new



=item * Class::XSAccessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessor->new



=item * no generator (hash-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Hash->new



=item * Simple::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::SimpleAccessor->new



=item * no generator (array-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Array->new



=item * no generator (scalar-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Scalar->new



=item * Class::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessor->new



=item * Class::XSAccessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessorArray->new



=item * Class::InsideOut (perl_code)

Code template:

 Perl::Examples::Accessors::ClassInsideOut->new



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Construction >>):

 #table1#
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | participant                 | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | Class::InsideOut            |    190000 |     5.2   |       1    | 6.7e-09 |      20 |
 | Simple::Accessor            |    330000 |     3     |       1.7  | 6.5e-09 |      21 |
 | Class::Tiny                 |    380000 |     2.6   |       2    | 3.3e-09 |      20 |
 | Moose                       |    520000 |     1.9   |       2.7  | 3.3e-09 |      20 |
 | Mo                          |    800000 |     1.3   |       4.2  | 1.8e-09 |      26 |
 | Moo                         |   1050000 |     0.949 |       5.52 | 1.4e-10 |      20 |
 | Class::Accessor             |   1100000 |     0.91  |       5.7  | 1.1e-09 |      25 |
 | Mouse                       |   1400000 |     0.7   |       7.5  | 1.8e-09 |      26 |
 | no generator (array-based)  |   1740000 |     0.576 |       9.1  | 2.1e-10 |      21 |
 | Object::Simple              |   2200000 |     0.46  |      11    | 7.5e-10 |      25 |
 | Mojo::Base                  |   2200000 |     0.45  |      12    | 8.4e-10 |      20 |
 | no generator (hash-based)   |   2230000 |     0.448 |      11.7  | 9.3e-11 |      20 |
 | Class::Accessor::Array      |   2470000 |     0.404 |      13    | 9.3e-11 |      20 |
 | no generator (scalar-based) |   2480000 |     0.403 |      13    | 9.3e-11 |      21 |
 | Class::XSAccessor           |   3540000 |     0.282 |      18.6  | 1.3e-10 |      24 |
 | Class::XSAccessor::Array    |   3600000 |     0.28  |      19    |   1e-09 |      29 |
 +-----------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
