package Bencher::Scenario::Textsprintfn;

our $DATE = '2016-06-28'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Text::sprintfn vs sprintf()',
    participants => [
        {
            fcall_template => 'Text::sprintfn::sprintfn(<format>, @{<data>})',
            tags => ['sprintfn'],
        },
        {
            name => 'sprintf',
            code_template => 'sprintf(<format>, @{<data>})',
            tags => ['sprintf'],
        },
    ],
    datasets => [
        {
            args => {format => '%s', data => [1]},
        },
        {
            args => {format => '%s%d%f', data => [1,2,3]},
        },
        {
            args => {format => '%(a)s', data => [{a=>1}]},
            exclude_participant_tags => ['sprintf'],
        },
        {
            args => {format => '%(a)s%(b)d%(c)f', data => [{a=>1,b=>2,c=>3}]},
            exclude_participant_tags => ['sprintf'],
        },
    ],
};

1;
# ABSTRACT: Benchmark Text::sprintfn vs sprintf()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Textsprintfn - Benchmark Text::sprintfn vs sprintf()

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::Textsprintfn (from Perl distribution Bencher-Scenario-Textsprintfn), released on 2016-06-28.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Textsprintfn

To run module startup overhead benchmark:

 % bencher --module-startup -m Textsprintfn

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Text::sprintfn> 0.08

=head1 BENCHMARK PARTICIPANTS

=over

=item * Text::sprintfn::sprintfn (perl_code) [sprintfn]

Function call template:

 Text::sprintfn::sprintfn(<format>, @{<data>})



=item * sprintf (perl_code) [sprintf]

Code template:

 sprintf(<format>, @{<data>})



=back

=head1 BENCHMARK DATASETS

=over

=item * {data=>[1],format=>"%s"}

=item * {data=>[1,2,3],format=>"%s%d%f"}

=item * {data=>[{a=>1}],format=>"%(a)s"}

=item * {data=>[{a=>1,b=>2,c=>3}],format=>"%(a)s%(b)d%(c)f"}

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Textsprintfn >>):

 +--------------------------+------------------------------------------------------+-----------+-----------+------------+---------+---------+
 | participant              | dataset                                              | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +--------------------------+------------------------------------------------------+-----------+-----------+------------+---------+---------+
 | Text::sprintfn::sprintfn | {data=>[{a=>1,b=>2,c=>3}],format=>"%(a)s%(b)d%(c)f"} |     44300 |    22.6   |        1   | 6.7e-09 |      20 |
 | Text::sprintfn::sprintfn | {data=>[{a=>1}],format=>"%(a)s"}                     |    100000 |     9.8   |        2.3 | 1.3e-08 |      20 |
 | Text::sprintfn::sprintfn | {data=>[1,2,3],format=>"%s%d%f"}                     |    510000 |     2     |       12   | 6.2e-09 |      23 |
 | sprintf                  | {data=>[1,2,3],format=>"%s%d%f"}                     |    860000 |     1.2   |       19   | 5.3e-09 |      21 |
 | Text::sprintfn::sprintfn | {data=>[1],format=>"%s"}                             |   1200000 |     0.84  |       27   | 1.3e-09 |      20 |
 | sprintf                  | {data=>[1],format=>"%s"}                             |   2740000 |     0.365 |       61.9 |   2e-10 |      23 |
 +--------------------------+------------------------------------------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m Textsprintfn --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Text::sprintfn      |         8 |                      4 |          1 | 4.1e-05 |      20 |
 | perl -e1 (baseline) |         4 |                      0 |          2 |   5e-05 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Textsprintfn>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Textsprintfn>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Textsprintfn>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
