package Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-04-12'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240412.0'; # VERSION

use Acme::CPANAuthors::Register (
    'BINGOS' => '',
    'ETHER' => '',
    'LEEJO' => '',
    'PERLANCAR' => '',
    'UTASHIRO' => '',
    'OALDERS' => '',
    'KIMOTO' => '',
    'OLIVER' => '',
    'SKIM' => '',
    'DERF' => '',
    'JDEGUEST' => '',
    'BDFOY' => '',
    'JIMAVERA' => '',
    'ASPOSE' => '',
    'DJERIUS' => '',
    'VVELOX' => '',
    'JV' => '',
    'AJNN' => '',
    'CUKEBOT' => '',
    'TEAM' => '',
    'WYANT' => '',
    'RKAPL' => '',
    'BPS' => '',
    'JRM' => '',
    'RRWO' => '',
    'JGNI' => '',
    'SREZIC' => '',
    'DAMI' => '',
    'MIKKOI' => '',
    'RJBS' => '',
    'DAVECROSS' => '',
    'INGY' => '',
    'MATHIAS' => '',
    'GUILLEM' => '',
    'KUERBIS' => '',
    'SBECK' => '',
    'ARISTOTLE' => '',
    'BKB' => '',
    'DDICK' => '',
    'ETJ' => '',
    'FREDERICD' => '',
    'LEONT' => '',
    'LNATION' => '',
    'MBRADSHAW' => '',
    'NHORNE' => '',
    'MANWAR' => '',
    'MSIMERSON' => '',
    'SANKO' => '',
    'SHE' => '',
    'SISYPHUS' => '',
    'BRIANDFOY' => '',
    'DWHEELER' => '',
    'EXODIST' => '',
    'GBROWN' => '',
    'HANJE' => '',
    'JAVONET' => '',
    'JONASBN' => '',
    'MRUEDA' => '',
    'PMQS' => '',
    'TANIGUCHI' => '',
    'TIMKA' => '',
    'TYRRMINAL' => '',
    'WATERKIP' => '',
    'ABRAXXA' => '',
    'AKXLIX' => '',
    'ASB' => '',
    'HOUSTON' => '',
    'ILYAZ' => '',
    'JACOBY' => '',
    'JDDPAUSE' => '',
    'JSF' => '',
    'KHEDIN' => '',
    'LSTEVENS' => '',
    'MDOOTSON' => '',
    'NICOMEN' => '',
    'PLICEASE' => '',
    'RES' => '',
    'SOMMREY' => '',
    'ATRODO' => '',
    'BLIAKO' => '',
    'CORION' => '',
    'DANBERR' => '',
    'DILLANBH' => '',
    'FKENTO' => '',
    'GENE' => '',
    'HERNAN' => '',
    'JMATES' => '',
    'MAUKE' => '',
    'MEWP' => '',
    'PEVANS' => '',
    'SHLOMIF' => '',
    'SIDNEY' => '',
    'SYP' => '',
    'TRIZEN' => '',
    'ANTONOV' => '',
    'ARTHAS' => '',
    'ATOY' => '',
    'AZOMER' => '',
    'BAYASHI' => '',
    'BLHOTSKY' => '',
    'BOD' => '',
    'BRTASTIC' => '',
    'CADE' => '',
    'CHRISARG' => '',
    'DAPINK' => '',
    'DBOOK' => '',
    'DCANTRELL' => '',
    'DCHURCH' => '',
    'DERIV' => '',
    'DVEEDEN' => '',
    'FANF' => '',
    'FSEITZ' => '',
    'FSM' => '',
    'GAHAYES' => '',
    'GARU' => '',
    'GETTY' => '',
    'GRYPHON' => '',
    'GTERMARS' => '',
    'HAUKEX' => '',
    'HAX' => '',
    'JBAIER' => '',
    'JKEENAN' => '',
    'JKSTILL' => '',
    'JOESUF' => '',
    'KALDOR' => '',
    'KTAT' => '',
    'LTHEGLER' => '',
    'LWP' => '',
    'MANNI' => '',
    'MICKEY' => '',
    'MIKAGE' => '',
    'MIKEVNTNR' => '',
    'MIYAGAWA' => '',
    'NERDVANA' => '',
    'NJFRANCK' => '',
    'NUDDLEGG' => '',
    'OMEGA' => '',
    'PATRICKB' => '',
    'PETDANCE' => '',
    'RATL' => '',
    'RHESA' => '',
    'RKELSCH' => '',
    'RSCHUPP' => '',
    'SGRAY' => '',
    'SHOGO' => '',
    'SRI' => '',
    'STEVEB' => '',
    'TULAMILI' => '',
    'UPWORK' => '',
    'VPIT' => '',
    'YANICK' => '',
    'ZNMSTR' => '',
    'AAHAZRED' => '',
    'ABEVERLEY' => '',
    'ARFREITAS' => '',
    'ASPIERS' => '',
    'DFE' => '',
    'DRCLAW' => '',
    'DROLSKY' => '',
    'GSG' => '',
    'HMBRAND' => '',
    'HOLLIE' => '',
    'ISHIGAKI' => '',
    'JDASILVA' => '',
    'JMERELO' => '',
    'LEV' => '',
    'LITCHIE' => '',
    'MELMOTHX' => '',
    'MERKYS' => '',
    'MJEMMESON' => '',
    'MSTPLBG' => '',
    'MYSOCIETY' => '',
    'PAYJP' => '',
    'PHILIPPE' => '',
    'PRBRENAN' => '',
    'REEDFISH' => '',
    'SJQUINNEY' => '',
    'SONGMU' => '',
    'TONYC' => '',
    'WESM' => '',
);


1;
# ABSTRACT: Authors with ongoing month releases streak (do a release every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current - Authors with ongoing month releases streak (do a release every month)

=head1 VERSION

This document describes version 20240412.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-04-12.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-04-12, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | BINGOS    | 217 | 2006-03    | might-break |
  | ETHER     | 146 | 2012-03    | ongoing     |
  | LEEJO     | 121 | 2014-04    | ongoing     |
  | PERLANCAR | 117 | 2014-08    | ongoing     |
  | UTASHIRO  |  71 | 2018-06    | ongoing     |
  | OALDERS   |  57 | 2019-08    | ongoing     |
  | KIMOTO    |  29 | 2021-12    | ongoing     |
  | OLIVER    |  27 | 2022-02    | ongoing     |
  | SKIM      |  25 | 2022-04    | ongoing     |
  | DERF      |  23 | 2022-06    | ongoing     |
  | JDEGUEST  |  23 | 2022-06    | ongoing     |
  | BDFOY     |  16 | 2023-01    | ongoing     |
  | JIMAVERA  |  16 | 2023-01    | ongoing     |
  | ASPOSE    |  15 | 2023-02    | ongoing     |
  | DJERIUS   |  14 | 2023-03    | ongoing     |
  | VVELOX    |  12 | 2023-05    | ongoing     |
  | JV        |  11 | 2023-05    | might-break |
  | AJNN      |  11 | 2023-06    | ongoing     |
  | CUKEBOT   |   8 | 2023-08    | might-break |
  | TEAM      |   8 | 2023-08    | might-break |
  | WYANT     |   8 | 2023-08    | might-break |
  | RKAPL     |   8 | 2023-09    | ongoing     |
  | BPS       |   7 | 2023-09    | might-break |
  | JRM       |   7 | 2023-10    | ongoing     |
  | RRWO      |   7 | 2023-10    | ongoing     |
  | JGNI      |   6 | 2023-10    | might-break |
  | SREZIC    |   6 | 2023-10    | might-break |
  | DAMI      |   5 | 2023-11    | might-break |
  | MIKKOI    |   5 | 2023-11    | might-break |
  | RJBS      |   5 | 2023-11    | might-break |
  | DAVECROSS |   5 | 2023-12    | ongoing     |
  | INGY      |   5 | 2023-12    | ongoing     |
  | MATHIAS   |   5 | 2023-12    | ongoing     |
  | GUILLEM   |   4 | 2023-12    | might-break |
  | KUERBIS   |   4 | 2023-12    | might-break |
  | SBECK     |   4 | 2023-12    | might-break |
  | ARISTOTLE |   4 | 2024-01    | ongoing     |
  | BKB       |   4 | 2024-01    | ongoing     |
  | DDICK     |   4 | 2024-01    | ongoing     |
  | ETJ       |   4 | 2024-01    | ongoing     |
  | FREDERICD |   4 | 2024-01    | ongoing     |
  | LEONT     |   4 | 2024-01    | ongoing     |
  | LNATION   |   4 | 2024-01    | ongoing     |
  | MBRADSHAW |   4 | 2024-01    | ongoing     |
  | NHORNE    |   4 | 2024-01    | ongoing     |
  | MANWAR    |   3 | 2024-01    | might-break |
  | MSIMERSON |   3 | 2024-01    | might-break |
  | SANKO     |   3 | 2024-01    | might-break |
  | SHE       |   3 | 2024-01    | might-break |
  | SISYPHUS  |   3 | 2024-01    | might-break |
  | BRIANDFOY |   3 | 2024-02    | ongoing     |
  | DWHEELER  |   3 | 2024-02    | ongoing     |
  | EXODIST   |   3 | 2024-02    | ongoing     |
  | GBROWN    |   3 | 2024-02    | ongoing     |
  | HANJE     |   3 | 2024-02    | ongoing     |
  | JAVONET   |   3 | 2024-02    | ongoing     |
  | JONASBN   |   3 | 2024-02    | ongoing     |
  | MRUEDA    |   3 | 2024-02    | ongoing     |
  | PMQS      |   3 | 2024-02    | ongoing     |
  | TANIGUCHI |   3 | 2024-02    | ongoing     |
  | TIMKA     |   3 | 2024-02    | ongoing     |
  | TYRRMINAL |   3 | 2024-02    | ongoing     |
  | WATERKIP  |   3 | 2024-02    | ongoing     |
  | ABRAXXA   |   2 | 2024-02    | might-break |
  | AKXLIX    |   2 | 2024-02    | might-break |
  | ASB       |   2 | 2024-02    | might-break |
  | HOUSTON   |   2 | 2024-02    | might-break |
  | ILYAZ     |   2 | 2024-02    | might-break |
  | JACOBY    |   2 | 2024-02    | might-break |
  | JDDPAUSE  |   2 | 2024-02    | might-break |
  | JSF       |   2 | 2024-02    | might-break |
  | KHEDIN    |   2 | 2024-02    | might-break |
  | LSTEVENS  |   2 | 2024-02    | might-break |
  | MDOOTSON  |   2 | 2024-02    | might-break |
  | NICOMEN   |   2 | 2024-02    | might-break |
  | PLICEASE  |   2 | 2024-02    | might-break |
  | RES       |   2 | 2024-02    | might-break |
  | SOMMREY   |   2 | 2024-02    | might-break |
  | ATRODO    |   2 | 2024-03    | ongoing     |
  | BLIAKO    |   2 | 2024-03    | ongoing     |
  | CORION    |   2 | 2024-03    | ongoing     |
  | DANBERR   |   2 | 2024-03    | ongoing     |
  | DILLANBH  |   2 | 2024-03    | ongoing     |
  | FKENTO    |   2 | 2024-03    | ongoing     |
  | GENE      |   2 | 2024-03    | ongoing     |
  | HERNAN    |   2 | 2024-03    | ongoing     |
  | JMATES    |   2 | 2024-03    | ongoing     |
  | MAUKE     |   2 | 2024-03    | ongoing     |
  | MEWP      |   2 | 2024-03    | ongoing     |
  | PEVANS    |   2 | 2024-03    | ongoing     |
  | SHLOMIF   |   2 | 2024-03    | ongoing     |
  | SIDNEY    |   2 | 2024-03    | ongoing     |
  | SYP       |   2 | 2024-03    | ongoing     |
  | TRIZEN    |   2 | 2024-03    | ongoing     |
  | ANTONOV   |   1 | 2024-03    | might-break |
  | ARTHAS    |   1 | 2024-03    | might-break |
  | ATOY      |   1 | 2024-03    | might-break |
  | AZOMER    |   1 | 2024-03    | might-break |
  | BAYASHI   |   1 | 2024-03    | might-break |
  | BLHOTSKY  |   1 | 2024-03    | might-break |
  | BOD       |   1 | 2024-03    | might-break |
  | BRTASTIC  |   1 | 2024-03    | might-break |
  | CADE      |   1 | 2024-03    | might-break |
  | CHRISARG  |   1 | 2024-03    | might-break |
  | DAPINK    |   1 | 2024-03    | might-break |
  | DBOOK     |   1 | 2024-03    | might-break |
  | DCANTRELL |   1 | 2024-03    | might-break |
  | DCHURCH   |   1 | 2024-03    | might-break |
  | DERIV     |   1 | 2024-03    | might-break |
  | DVEEDEN   |   1 | 2024-03    | might-break |
  | FANF      |   1 | 2024-03    | might-break |
  | FSEITZ    |   1 | 2024-03    | might-break |
  | FSM       |   1 | 2024-03    | might-break |
  | GAHAYES   |   1 | 2024-03    | might-break |
  | GARU      |   1 | 2024-03    | might-break |
  | GETTY     |   1 | 2024-03    | might-break |
  | GRYPHON   |   1 | 2024-03    | might-break |
  | GTERMARS  |   1 | 2024-03    | might-break |
  | HAUKEX    |   1 | 2024-03    | might-break |
  | HAX       |   1 | 2024-03    | might-break |
  | JBAIER    |   1 | 2024-03    | might-break |
  | JKEENAN   |   1 | 2024-03    | might-break |
  | JKSTILL   |   1 | 2024-03    | might-break |
  | JOESUF    |   1 | 2024-03    | might-break |
  | KALDOR    |   1 | 2024-03    | might-break |
  | KTAT      |   1 | 2024-03    | might-break |
  | LTHEGLER  |   1 | 2024-03    | might-break |
  | LWP       |   1 | 2024-03    | might-break |
  | MANNI     |   1 | 2024-03    | might-break |
  | MICKEY    |   1 | 2024-03    | might-break |
  | MIKAGE    |   1 | 2024-03    | might-break |
  | MIKEVNTNR |   1 | 2024-03    | might-break |
  | MIYAGAWA  |   1 | 2024-03    | might-break |
  | NERDVANA  |   1 | 2024-03    | might-break |
  | NJFRANCK  |   1 | 2024-03    | might-break |
  | NUDDLEGG  |   1 | 2024-03    | might-break |
  | OMEGA     |   1 | 2024-03    | might-break |
  | PATRICKB  |   1 | 2024-03    | might-break |
  | PETDANCE  |   1 | 2024-03    | might-break |
  | RATL      |   1 | 2024-03    | might-break |
  | RHESA     |   1 | 2024-03    | might-break |
  | RKELSCH   |   1 | 2024-03    | might-break |
  | RSCHUPP   |   1 | 2024-03    | might-break |
  | SGRAY     |   1 | 2024-03    | might-break |
  | SHOGO     |   1 | 2024-03    | might-break |
  | SRI       |   1 | 2024-03    | might-break |
  | STEVEB    |   1 | 2024-03    | might-break |
  | TULAMILI  |   1 | 2024-03    | might-break |
  | UPWORK    |   1 | 2024-03    | might-break |
  | VPIT      |   1 | 2024-03    | might-break |
  | YANICK    |   1 | 2024-03    | might-break |
  | ZNMSTR    |   1 | 2024-03    | might-break |
  | AAHAZRED  |   1 | 2024-04    | ongoing     |
  | ABEVERLEY |   1 | 2024-04    | ongoing     |
  | ARFREITAS |   1 | 2024-04    | ongoing     |
  | ASPIERS   |   1 | 2024-04    | ongoing     |
  | DFE       |   1 | 2024-04    | ongoing     |
  | DRCLAW    |   1 | 2024-04    | ongoing     |
  | DROLSKY   |   1 | 2024-04    | ongoing     |
  | GSG       |   1 | 2024-04    | ongoing     |
  | HMBRAND   |   1 | 2024-04    | ongoing     |
  | HOLLIE    |   1 | 2024-04    | ongoing     |
  | ISHIGAKI  |   1 | 2024-04    | ongoing     |
  | JDASILVA  |   1 | 2024-04    | ongoing     |
  | JMERELO   |   1 | 2024-04    | ongoing     |
  | LEV       |   1 | 2024-04    | ongoing     |
  | LITCHIE   |   1 | 2024-04    | ongoing     |
  | MELMOTHX  |   1 | 2024-04    | ongoing     |
  | MERKYS    |   1 | 2024-04    | ongoing     |
  | MJEMMESON |   1 | 2024-04    | ongoing     |
  | MSTPLBG   |   1 | 2024-04    | ongoing     |
  | MYSOCIETY |   1 | 2024-04    | ongoing     |
  | PAYJP     |   1 | 2024-04    | ongoing     |
  | PHILIPPE  |   1 | 2024-04    | ongoing     |
  | PRBRENAN  |   1 | 2024-04    | ongoing     |
  | REEDFISH  |   1 | 2024-04    | ongoing     |
  | SJQUINNEY |   1 | 2024-04    | ongoing     |
  | SONGMU    |   1 | 2024-04    | ongoing     |
  | TONYC     |   1 | 2024-04    | ongoing     |
  | WESM      |   1 | 2024-04    | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
